<?php
/**
 * The template for displaying Default Product Category pages
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Azoom
 * @since Azoom 1.0
 */
global $wp_query;
$term = $wp_query->get_queried_object();

$post_type = get_post_type();
$layout_id = xr_get_option($post_type.'_archive_layout', false);
if(!$layout_id || $layout_id === ''){
	$layout_id = false;
}else{
	$layout_id = intval($layout_id);	
}


get_header(); ?>
<?php do_action('rockthemes_pb_frontend_before_page'); ?>
<?php if(defined('RPB_FULL_SHORTCODE')){ echo '<!-- Regular Content Area --><div class="row">';} ?>
<?php if(function_exists('rockthemes_pb_frontend_sidebar_before_content')) rockthemes_pb_frontend_sidebar_before_content(); ?>


	<div id="primary" class="content-area large-<?php echo rockthemes_pb_frontend_get_content_columns_after_sidebars(); ?> column">
		<div id="content" class="site-content" role="main">
	<?php
	
	
	//If there is a page layout selected for this archive, display that layout
	if($layout_id):
		//Add the the_content for RPB filter
		the_content();

	//If Azoom Call Portfolio Shortcode function is defined, call the shortcode function.
	elseif(function_exists('azoom_call_portfolio_shortcode') && $term):
		$portfolio_atts = array(
				'image_size'				=>	'shop_catalog',
				'post_type'					=>	'product',
				'category'					=>	'',
				'excerpt_title_option'		=>	'title_cats_excerpt',
				
				'activate_hover'			=>	'true',
				'hover_bg_change_elem'		=>	'true',
				'details_in_hover'			=>	'din_hover',
				
				'activate_category_link'	=>	'true',
				'activate_header_link'		=>	'true',
				'where_to_link'				=>	'items',
				
				'use_back_icon'				=>	'true',
				'use_link_icon'				=>	'true',
				'use_lightbox_image'		=>	'true',
				'use_lightbox_video'		=>	'true',
				'use_lightbox_gallery'		=>	'true',
				'use_like'					=>	'true',
				
				'wall_mode'					=>	'false',
				'masonry'					=>	'false',
				
				'display_price'				=>	'true',
				'display_date'				=>	'false',
				'excerpt_length'			=>	8,
				'block_grid_large'			=>	'3',
				'block_grid_medium'			=>	'2',
				'block_grid_small'			=>	'1',
				
				'total'						=>	get_option('posts_per_page'),
				'boxed_layout'				=>	'false',
				'more_items'				=>	'pagination',
				'swiper_nav_number'			=>	'4',

				'portfolio_model'			=>	'grid',
				'portfolio_model_switch'	=>	'false',
				'list_image_col_large'		=>	'5',
				
				'use_shadow'				=>	'false',
				'use_swiper_for_thumbnails'	=>	'false'
		);
				
		azoom_call_portfolio_shortcode($portfolio_atts);
		?>
    
    <?php
	else :
	?>
		<?php if ( have_posts() ) : ?>
        	<?php
			global $azoom_disable_regular_title;

			if(!$azoom_disable_regular_title):
			?>
			<header class="taxonomy-header">
				<h2 class="taxonomy-title">
				<?php
					if(is_category()){
						printf( esc_html__( 'Category Archives: %s', 'azoom' ), single_cat_title( '', false ) );
					}elseif(is_tag()){
						printf( esc_html__( 'Tag Archives: %s', 'azoom' ), single_tag_title( '', false ) );
					}elseif(is_tax()){
						$queried = get_queried_object();
						$the_tax = get_taxonomy( get_query_var( 'taxonomy' ) );
						printf( esc_html__( $the_tax->labels->name.': %s', 'azoom' ), $queried->name );
					}elseif(is_archive()){
						if ( is_day() ) :
							printf( esc_html__( 'Daily Archives: %s', 'azoom' ), get_the_date() );
						elseif ( is_month() ) :
							printf( esc_html__( 'Monthly Archives: %s', 'azoom' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'azoom' ) ) );
						elseif ( is_year() ) :
							printf( esc_html__( 'Yearly Archives: %s', 'azoom' ), get_the_date( _x( 'Y', 'yearly archives date format', 'azoom' ) ) );
						else :
							_e( 'Archives', 'azoom' );
						endif;
					}else{
						echo get_the_title(get_queried_object_id()); 
					}
				?> 
				?></h2>
			</header><!-- .archive-header -->
			<?php endif; ?>
            
			<?php /* The loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content', get_post_format() ); ?>
			<?php endwhile; ?>

			<?php azoom_paging_nav(true); ?>

		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>
	<?php endif; ?>
    
		</div><!-- #content -->
	</div><!-- #primary -->
<?php 
if(function_exists('rockthemes_pb_frontend_sidebar_after_content')) rockthemes_pb_frontend_sidebar_after_content();
else get_sidebar();
?>
<?php if(defined('RPB_FULL_SHORTCODE')){ echo '</div><!-- /End of Regular Content Area -->';} ?>
<?php do_action('rockthemes_pb_frontend_after_page'); ?>
<?php get_footer(); ?>