<?php
/*
**	Rockthemes Mega Menu Modals
**
**	Icon Modal ( Currently using Icomoon free set )
*/





if(!function_exists('rockthemes_mm_admin_icons_modal')):
function rockthemes_mm_admin_icons_modal($data = array()){
	$icons = function_exists('rockthemes_get_icon_list') ? rockthemes_get_icon_list() : array();//rockthemes_mm_get_icomoon_list();
	
	$modal_content = '';
	
	
	foreach($icons as $icon){
		$modal_content .= '<span class="icon-holder rock-choose-icon" data-icon-class="'.esc_attr($icon).'"><i class="'.esc_attr($icon).'"></i></span>';
	}
	
	//Icon Search System
	$modal_content = '
		<div class="row-fluid">
			<div class="span12">
				<input autocomplete="off" type="text" class="rock-search-icons widefat" value="" placeholder="Search :" />
				<br/><br/>
				<div class="rock-icon-list" >
					'.$modal_content.'
				</div>
			</div>
		</div>
	';
	
	$modal_args = array(
		'modal_id'					=> 'rockthemes_mm_icon_modal',
		'modal_title'				=> 'Choose an Icon',
		'modal_content'				=> $modal_content,
		'modal_save_button_class'	=> 'save-icon-modal',
	);
	
	$modal = rockthemes_mm_admin_make_modals($modal_args);
	
	return $modal;
}
endif;




if(!function_exists('rockthemes_mm_admin_make_modals')):
/*
**	Finalize the modal structure. This will use basic modal structure. 
**	Modal details will be generated through their specific functions
**
**	@param	:	$args Array() arguments for the modal
*/
function rockthemes_mm_admin_make_modals($args = array()){
	
	if(empty($args)) return '';
	
	extract($args);
	
	/*
	**	$args = array(
	**		modal_id
	**		modal_title
	**		modal_content
	**		modal_save_button_class
	**	)
	*/
	$modal = '
	<div id="'.esc_attr($modal_id).'" class="modal bs-modal-lg" tabindex="-1" role="dialog" aria-labelledby="'.esc_attr($modal_title).'" aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<div type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</div>
					<h4 class="modal-title">'.esc_html($modal_title).'</h4>
				</div>
				<div class="modal-body">
					'.$modal_content.'
				</div>
				<div class="modal-footer">
					<button type="button" class="button '.esc_attr($modal_save_button_class).'" data-dismiss="modal">Close</button>
					<button type="button" class="button close-modal-button">Save changes</button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	';
	
	return $modal;
}
endif;

/*
if(!function_exists('rockthemes_mm_get_icomoon_list')):
function rockthemes_mm_get_icomoon_list(){
	
	$icons_list = array();
	
	$icomoon_list = array(
		'icomoon-icon-home',
		'icomoon-icon-home2',
		'icomoon-icon-home3',
		'icomoon-icon-office',
		'icomoon-icon-newspaper',
		'icomoon-icon-pencil',
		'icomoon-icon-pencil2',
		'icomoon-icon-quill',
		'icomoon-icon-pen',
		'icomoon-icon-blog',
		'icomoon-icon-droplet',
		'icomoon-icon-paint-format',
		'icomoon-icon-image',
		'icomoon-icon-image2',
		'icomoon-icon-images',
		'icomoon-icon-camera',
		'icomoon-icon-music',
		'icomoon-icon-headphones',
		'icomoon-icon-play',
		'icomoon-icon-film',
		'icomoon-icon-camera2',
		'icomoon-icon-dice',
		'icomoon-icon-pacman',
		'icomoon-icon-spades',
		'icomoon-icon-clubs',
		'icomoon-icon-diamonds',
		'icomoon-icon-pawn',
		'icomoon-icon-bullhorn',
		'icomoon-icon-connection',
		'icomoon-icon-podcast',
		'icomoon-icon-feed',
		'icomoon-icon-book',
		'icomoon-icon-books',
		'icomoon-icon-library',
		'icomoon-icon-file',
		'icomoon-icon-profile',
		'icomoon-icon-file2',
		'icomoon-icon-file3',
		'icomoon-icon-file4',
		'icomoon-icon-copy',
		'icomoon-icon-copy2',
		'icomoon-icon-copy3',
		'icomoon-icon-paste',
		'icomoon-icon-paste2',
		'icomoon-icon-paste3',
		'icomoon-icon-stack',
		'icomoon-icon-folder',
		'icomoon-icon-folder-open',
		'icomoon-icon-tag',
		'icomoon-icon-tags',
		'icomoon-icon-barcode',
		'icomoon-icon-qrcode',
		'icomoon-icon-ticket',
		'icomoon-icon-cart',
		'icomoon-icon-cart2',
		'icomoon-icon-cart3',
		'icomoon-icon-coin',
		'icomoon-icon-credit',
		'icomoon-icon-calculate',
		'icomoon-icon-support',
		'icomoon-icon-phone',
		'icomoon-icon-phone-hang-up',
		'icomoon-icon-address-book',
		'icomoon-icon-notebook',
		'icomoon-icon-envelope',
		'icomoon-icon-pushpin',
		'icomoon-icon-location',
		'icomoon-icon-location2',
		'icomoon-icon-compass',
		'icomoon-icon-map',
		'icomoon-icon-map2',
		'icomoon-icon-history',
		'icomoon-icon-clock',
		'icomoon-icon-clock2',
		'icomoon-icon-alarm',
		'icomoon-icon-alarm2',
		'icomoon-icon-bell',
		'icomoon-icon-stopwatch',
		'icomoon-icon-calendar',
		'icomoon-icon-calendar2',
		'icomoon-icon-print',
		'icomoon-icon-keyboard',
		'icomoon-icon-screen',
		'icomoon-icon-laptop',
		'icomoon-icon-mobile',
		'icomoon-icon-mobile2',
		'icomoon-icon-tablet',
		'icomoon-icon-tv',
		'icomoon-icon-cabinet',
		'icomoon-icon-drawer',
		'icomoon-icon-drawer2',
		'icomoon-icon-drawer3',
		'icomoon-icon-box-add',
		'icomoon-icon-box-remove',
		'icomoon-icon-download',
		'icomoon-icon-upload',
		'icomoon-icon-disk',
		'icomoon-icon-storage',
		'icomoon-icon-undo',
		'icomoon-icon-redo',
		'icomoon-icon-flip',
		'icomoon-icon-flip2',
		'icomoon-icon-undo2',
		'icomoon-icon-redo2',
		'icomoon-icon-forward',
		'icomoon-icon-reply',
		'icomoon-icon-bubble',
		'icomoon-icon-bubbles',
		'icomoon-icon-bubbles2',
		'icomoon-icon-bubble2',
		'icomoon-icon-bubbles3',
		'icomoon-icon-bubbles4',
		'icomoon-icon-user',
		'icomoon-icon-users',
		'icomoon-icon-user2',
		'icomoon-icon-users2',
		'icomoon-icon-user3',
		'icomoon-icon-user4',
		'icomoon-icon-quotes-left',
		'icomoon-icon-busy',
		'icomoon-icon-spinner',
		'icomoon-icon-spinner2',
		'icomoon-icon-spinner3',
		'icomoon-icon-spinner4',
		'icomoon-icon-spinner5',
		'icomoon-icon-spinner6',
		'icomoon-icon-binoculars',
		'icomoon-icon-search',
		'icomoon-icon-zoomin',
		'icomoon-icon-zoomout',
		'icomoon-icon-expand',
		'icomoon-icon-contract',
		'icomoon-icon-expand2',
		'icomoon-icon-contract2',
		'icomoon-icon-key',
		'icomoon-icon-key2',
		'icomoon-icon-lock',
		'icomoon-icon-lock2',
		'icomoon-icon-unlocked',
		'icomoon-icon-wrench',
		'icomoon-icon-settings',
		'icomoon-icon-equalizer',
		'icomoon-icon-cog',
		'icomoon-icon-cogs',
		'icomoon-icon-cog2',
		'icomoon-icon-hammer',
		'icomoon-icon-wand',
		'icomoon-icon-aid',
		'icomoon-icon-bug',
		'icomoon-icon-pie',
		'icomoon-icon-stats',
		'icomoon-icon-bars',
		'icomoon-icon-bars2',
		'icomoon-icon-gift',
		'icomoon-icon-trophy',
		'icomoon-icon-glass',
		'icomoon-icon-mug',
		'icomoon-icon-food',
		'icomoon-icon-leaf',
		'icomoon-icon-rocket',
		'icomoon-icon-meter',
		'icomoon-icon-meter2',
		'icomoon-icon-dashboard',
		'icomoon-icon-hammer2',
		'icomoon-icon-fire',
		'icomoon-icon-lab',
		'icomoon-icon-magnet',
		'icomoon-icon-remove',
		'icomoon-icon-remove2',
		'icomoon-icon-briefcase',
		'icomoon-icon-airplane',
		'icomoon-icon-truck',
		'icomoon-icon-road',
		'icomoon-icon-accessibility',
		'icomoon-icon-target',
		'icomoon-icon-shield',
		'icomoon-icon-lightning',
		'icomoon-icon-switch',
		'icomoon-icon-powercord',
		'icomoon-icon-signup',
		'icomoon-icon-list',
		'icomoon-icon-list2',
		'icomoon-icon-numbered-list',
		'icomoon-icon-menu',
		'icomoon-icon-menu2',
		'icomoon-icon-tree',
		'icomoon-icon-cloud',
		'icomoon-icon-cloud-download',
		'icomoon-icon-cloud-upload',
		'icomoon-icon-download2',
		'icomoon-icon-upload2',
		'icomoon-icon-download3',
		'icomoon-icon-upload3',
		'icomoon-icon-globe',
		'icomoon-icon-earth',
		'icomoon-icon-link',
		'icomoon-icon-flag',
		'icomoon-icon-attachment',
		'icomoon-icon-eye',
		'icomoon-icon-eye-blocked',
		'icomoon-icon-eye2',
		'icomoon-icon-bookmark',
		'icomoon-icon-bookmarks',
		'icomoon-icon-brightness-medium',
		'icomoon-icon-brightness-contrast',
		'icomoon-icon-contrast',
		'icomoon-icon-star',
		'icomoon-icon-star2',
		'icomoon-icon-star3',
		'icomoon-icon-heart',
		'icomoon-icon-heart2',
		'icomoon-icon-heart-broken',
		'icomoon-icon-thumbs-up',
		'icomoon-icon-thumbs-up2',
		'icomoon-icon-happy',
		'icomoon-icon-happy2',
		'icomoon-icon-smiley',
		'icomoon-icon-smiley2',
		'icomoon-icon-tongue',
		'icomoon-icon-tongue2',
		'icomoon-icon-sad',
		'icomoon-icon-sad2',
		'icomoon-icon-wink',
		'icomoon-icon-wink2',
		'icomoon-icon-grin',
		'icomoon-icon-grin2',
		'icomoon-icon-cool',
		'icomoon-icon-cool2',
		'icomoon-icon-angry',
		'icomoon-icon-angry2',
		'icomoon-icon-evil',
		'icomoon-icon-evil2',
		'icomoon-icon-shocked',
		'icomoon-icon-shocked2',
		'icomoon-icon-confused',
		'icomoon-icon-confused2',
		'icomoon-icon-neutral',
		'icomoon-icon-neutral2',
		'icomoon-icon-wondering',
		'icomoon-icon-wondering2',
		'icomoon-icon-point-up',
		'icomoon-icon-point-right',
		'icomoon-icon-point-down',
		'icomoon-icon-point-left',
		'icomoon-icon-warning',
		'icomoon-icon-notification',
		'icomoon-icon-question',
		'icomoon-icon-info',
		'icomoon-icon-info2',
		'icomoon-icon-blocked',
		'icomoon-icon-cancel-circle',
		'icomoon-icon-checkmark-circle',
		'icomoon-icon-spam',
		'icomoon-icon-close',
		'icomoon-icon-checkmark',
		'icomoon-icon-checkmark2',
		'icomoon-icon-spell-check',
		'icomoon-icon-minus',
		'icomoon-icon-plus',
		'icomoon-icon-enter',
		'icomoon-icon-exit',
		'icomoon-icon-play2',
		'icomoon-icon-pause',
		'icomoon-icon-stop',
		'icomoon-icon-backward',
		'icomoon-icon-forward2',
		'icomoon-icon-play3',
		'icomoon-icon-pause2',
		'icomoon-icon-stop2',
		'icomoon-icon-backward2',
		'icomoon-icon-forward3',
		'icomoon-icon-first',
		'icomoon-icon-last',
		'icomoon-icon-previous',
		'icomoon-icon-next',
		'icomoon-icon-eject',
		'icomoon-icon-volume-high',
		'icomoon-icon-volume-medium',
		'icomoon-icon-volume-low',
		'icomoon-icon-volume-mute',
		'icomoon-icon-volume-mute2',
		'icomoon-icon-volume-increase',
		'icomoon-icon-volume-decrease',
		'icomoon-icon-loop',
		'icomoon-icon-loop2',
		'icomoon-icon-loop3',
		'icomoon-icon-shuffle',
		'icomoon-icon-arrow-up-left',
		'icomoon-icon-arrow-up',
		'icomoon-icon-arrow-up-right',
		'icomoon-icon-arrow-right',
		'icomoon-icon-arrow-down-right',
		'icomoon-icon-arrow-down',
		'icomoon-icon-arrow-down-left',
		'icomoon-icon-arrow-left',
		'icomoon-icon-arrow-up-left2',
		'icomoon-icon-arrow-up2',
		'icomoon-icon-arrow-up-right2',
		'icomoon-icon-arrow-right2',
		'icomoon-icon-arrow-down-right2',
		'icomoon-icon-arrow-down2',
		'icomoon-icon-arrow-down-left2',
		'icomoon-icon-arrow-left2',
		'icomoon-icon-arrow-up-left3',
		'icomoon-icon-arrow-up3',
		'icomoon-icon-arrow-up-right3',
		'icomoon-icon-arrow-right3',
		'icomoon-icon-arrow-down-right3',
		'icomoon-icon-arrow-down3',
		'icomoon-icon-arrow-down-left3',
		'icomoon-icon-arrow-left3',
		'icomoon-icon-tab',
		'icomoon-icon-checkbox-checked',
		'icomoon-icon-checkbox-unchecked',
		'icomoon-icon-checkbox-partial',
		'icomoon-icon-radio-checked',
		'icomoon-icon-radio-unchecked',
		'icomoon-icon-crop',
		'icomoon-icon-scissors',
		'icomoon-icon-filter',
		'icomoon-icon-filter2',
		'icomoon-icon-font',
		'icomoon-icon-text-height',
		'icomoon-icon-text-width',
		'icomoon-icon-bold',
		'icomoon-icon-underline',
		'icomoon-icon-italic',
		'icomoon-icon-strikethrough',
		'icomoon-icon-omega',
		'icomoon-icon-sigma',
		'icomoon-icon-table',
		'icomoon-icon-table2',
		'icomoon-icon-insert-template',
		'icomoon-icon-pilcrow',
		'icomoon-icon-lefttoright',
		'icomoon-icon-righttoleft',
		'icomoon-icon-paragraph-left',
		'icomoon-icon-paragraph-center',
		'icomoon-icon-paragraph-right',
		'icomoon-icon-paragraph-justify',
		'icomoon-icon-paragraph-left2',
		'icomoon-icon-paragraph-center2',
		'icomoon-icon-paragraph-right2',
		'icomoon-icon-paragraph-justify2',
		'icomoon-icon-indent-increase',
		'icomoon-icon-indent-decrease',
		'icomoon-icon-newtab',
		'icomoon-icon-embed',
		'icomoon-icon-code',
		'icomoon-icon-console',
		'icomoon-icon-share',
		'icomoon-icon-mail',
		'icomoon-icon-mail2',
		'icomoon-icon-mail3',
		'icomoon-icon-mail4',
		'icomoon-icon-google',
		'icomoon-icon-googleplus',
		'icomoon-icon-googleplus2',
		'icomoon-icon-googleplus3',
		'icomoon-icon-googleplus4',
		'icomoon-icon-google-drive',
		'icomoon-icon-facebook',
		'icomoon-icon-facebook2',
		'icomoon-icon-facebook3',
		'icomoon-icon-instagram',
		'icomoon-icon-twitter',
		'icomoon-icon-twitter2',
		'icomoon-icon-twitter3',
		'icomoon-icon-feed2',
		'icomoon-icon-feed3',
		'icomoon-icon-feed4',
		'icomoon-icon-youtube',
		'icomoon-icon-youtube2',
		'icomoon-icon-vimeo',
		'icomoon-icon-vimeo2',
		'icomoon-icon-vimeo3',
		'icomoon-icon-lanyrd',
		'icomoon-icon-flickr',
		'icomoon-icon-flickr2',
		'icomoon-icon-flickr3',
		'icomoon-icon-flickr4',
		'icomoon-icon-picassa',
		'icomoon-icon-picassa2',
		'icomoon-icon-dribbble',
		'icomoon-icon-dribbble2',
		'icomoon-icon-dribbble3',
		'icomoon-icon-forrst',
		'icomoon-icon-forrst2',
		'icomoon-icon-deviantart',
		'icomoon-icon-deviantart2',
		'icomoon-icon-steam',
		'icomoon-icon-steam2',
		'icomoon-icon-github',
		'icomoon-icon-github2',
		'icomoon-icon-github3',
		'icomoon-icon-github4',
		'icomoon-icon-github5',
		'icomoon-icon-wordpress',
		'icomoon-icon-wordpress2',
		'icomoon-icon-joomla',
		'icomoon-icon-blogger',
		'icomoon-icon-blogger2',
		'icomoon-icon-tumblr',
		'icomoon-icon-tumblr2',
		'icomoon-icon-yahoo',
		'icomoon-icon-tux',
		'icomoon-icon-apple',
		'icomoon-icon-finder',
		'icomoon-icon-android',
		'icomoon-icon-windows',
		'icomoon-icon-windows8',
		'icomoon-icon-soundcloud',
		'icomoon-icon-soundcloud2',
		'icomoon-icon-skype',
		'icomoon-icon-reddit',
		'icomoon-icon-linkedin',
		'icomoon-icon-lastfm',
		'icomoon-icon-lastfm2',
		'icomoon-icon-delicious',
		'icomoon-icon-stumbleupon',
		'icomoon-icon-stumbleupon2',
		'icomoon-icon-stackoverflow',
		'icomoon-icon-pinterest',
		'icomoon-icon-pinterest2',
		'icomoon-icon-xing',
		'icomoon-icon-xing2',
		'icomoon-icon-flattr',
		'icomoon-icon-foursquare',
		'icomoon-icon-foursquare2',
		'icomoon-icon-paypal',
		'icomoon-icon-paypal2',
		'icomoon-icon-paypal3',
		'icomoon-icon-yelp',
		'icomoon-icon-libreoffice',
		'icomoon-icon-file-pdf',
		'icomoon-icon-file-openoffice',
		'icomoon-icon-file-word',
		'icomoon-icon-file-excel',
		'icomoon-icon-file-zip',
		'icomoon-icon-file-powerpoint',
		'icomoon-icon-file-xml',
		'icomoon-icon-file-css',
		'icomoon-icon-html5',
		'icomoon-icon-html52',
		'icomoon-icon-css3',
		'icomoon-icon-chrome',
		'icomoon-icon-firefox',
		'icomoon-icon-IE',
		'icomoon-icon-opera',
		'icomoon-icon-safari',
		'icomoon-icon-IcoMoon',
		'icomoon-icon-list3',
		'icomoon-icon-arrow-left4',
		'icomoon-icon-arrow-down4',
		'icomoon-icon-arrow-up4',
		'icomoon-icon-arrow-right4',
		'icomoon-icon-arrow-left5',
		'icomoon-icon-arrow-down5',
		'icomoon-icon-arrow-up5',
		'icomoon-icon-arrow-right5',
		'icomoon-icon-arrow-left6',
		'icomoon-icon-arrow-down6',
		'icomoon-icon-arrow-up6',
		'icomoon-icon-uniE7CF',
		'icomoon-icon-heart3',
		'icomoon-icon-cloud2',
		'icomoon-icon-star4',
		'icomoon-icon-tv2',
		'icomoon-icon-sound',
		'icomoon-icon-video',
		'icomoon-icon-trash',
		'icomoon-icon-user5',
		'icomoon-icon-key3',
		'icomoon-icon-search2',
		'icomoon-icon-settings2',
		'icomoon-icon-camera3',
		'icomoon-icon-tag2',
		'icomoon-icon-lock3',
		'icomoon-icon-bulb',
		'icomoon-icon-pen2',
		'icomoon-icon-diamond',
		'icomoon-icon-display',
		'icomoon-icon-location3',
		'icomoon-icon-eye3',
		'icomoon-icon-bubble3',
		'icomoon-icon-stack2',
		'icomoon-icon-cup',
		'icomoon-icon-phone2',
		'icomoon-icon-news',
		'icomoon-icon-mail5',
		'icomoon-icon-like',
		'icomoon-icon-photo',
		'icomoon-icon-note',
		'icomoon-icon-clock3',
		'icomoon-icon-paperplane',
		'icomoon-icon-params',
		'icomoon-icon-banknote',
		'icomoon-icon-data',
		'icomoon-icon-music2',
		'icomoon-icon-megaphone',
		'icomoon-icon-study',
		'icomoon-icon-lab2',
		'icomoon-icon-food2',
		'icomoon-icon-t-shirt',
		'icomoon-icon-fire2',
		'icomoon-icon-clip',
		'icomoon-icon-shop',
		'icomoon-icon-calendar3',
		'icomoon-icon-wallet',
		'icomoon-icon-vynil',
		'icomoon-icon-truck2',
		'icomoon-icon-world',
		'icomoon-icon-30',
		'icomoon-icon-45',
		'icomoon-icon-601',
		'icomoon-icon-a1',
		'icomoon-icon-abacus',
		'icomoon-icon-academic',
		'icomoon-icon-adn1',
		'icomoon-icon-alphabet1',
		'icomoon-icon-amount',
		'icomoon-icon-application5',
		'icomoon-icon-avi1',
		'icomoon-icon-backpack',
		'icomoon-icon-bag',
		'icomoon-icon-big52',
		'icomoon-icon-big55',
		'icomoon-icon-big56',
		'icomoon-icon-big57',
		'icomoon-icon-book10',
		'icomoon-icon-book11',
		'icomoon-icon-book12',
		'icomoon-icon-book13',
		'icomoon-icon-book14',
		'icomoon-icon-book15',
		'icomoon-icon-book7',
		'icomoon-icon-brain2',
		'icomoon-icon-briefcase2',
		'icomoon-icon-calendar5',
		'icomoon-icon-canvas',
		'icomoon-icon-cd',
		'icomoon-icon-certificate2',
		'icomoon-icon-certificate3',
		'icomoon-icon-certificate',
		'icomoon-icon-chemical',
		'icomoon-icon-chemistry',
		'icomoon-icon-cinema2',
		'icomoon-icon-cinema3',
		'icomoon-icon-clock4',
		'icomoon-icon-clock5',
		'icomoon-icon-competition',
		'icomoon-icon-computer12',
		'icomoon-icon-correct2',
		'icomoon-icon-curriculum',
		'icomoon-icon-deleted',
		'icomoon-icon-desktop',
		'icomoon-icon-diary1',
		'icomoon-icon-document5',
		'icomoon-icon-document6',
		'icomoon-icon-dotplot',
		'icomoon-icon-download4',
		'icomoon-icon-download8',
		'icomoon-icon-draw',
		'icomoon-icon-educational1',
		'icomoon-icon-educational',
		'icomoon-icon-education',
		'icomoon-icon-encyclopedia',
		'icomoon-icon-favorite5',
		'icomoon-icon-fifteen',
		'icomoon-icon-file32',
		'icomoon-icon-flag4',
		'icomoon-icon-football1',
		'icomoon-icon-foreign',
		'icomoon-icon-forms',
		'icomoon-icon-geography',
		'icomoon-icon-glasses1',
		'icomoon-icon-glasses',
		'icomoon-icon-graph',
		'icomoon-icon-guitar',
		'icomoon-icon-hand',
		'icomoon-icon-hierarchical',
		'icomoon-icon-homework',
		'icomoon-icon-icloud1',
		'icomoon-icon-icloud',
		'icomoon-icon-images2',
		'icomoon-icon-information2',
		'icomoon-icon-injection',
		'icomoon-icon-insignia',
		'icomoon-icon-ipad',
		'icomoon-icon-keyboard2',
		'icomoon-icon-leaf4',
		'icomoon-icon-lecture1',
		'icomoon-icon-lecture',
		'icomoon-icon-library2',
		'icomoon-icon-looking1',
		'icomoon-icon-looking2',
		'icomoon-icon-look',
		'icomoon-icon-magnet2',
		'icomoon-icon-mail42',
		'icomoon-icon-mathematical1',
		'icomoon-icon-mathematical',
		'icomoon-icon-measure',
		'icomoon-icon-measuring',
		'icomoon-icon-meeting',
		'icomoon-icon-microscope',
		'icomoon-icon-molecules1',
		'icomoon-icon-mouse2',
		'icomoon-icon-museum2',
		'icomoon-icon-music12',
		'icomoon-icon-music13',
		'icomoon-icon-necktie',
		'icomoon-icon-new5',
		'icomoon-icon-online1',
		'icomoon-icon-online2',
		'icomoon-icon-online',
		'icomoon-icon-open14',
		'icomoon-icon-pdf2',
		'icomoon-icon-physical',
		'icomoon-icon-physics',
		'icomoon-icon-picture5',
		'icomoon-icon-pie3',
		'icomoon-icon-placard',
		'icomoon-icon-play6',
		'icomoon-icon-play7',
		'icomoon-icon-q',
		'icomoon-icon-quarter',
		'icomoon-icon-research',
		'icomoon-icon-robot3',
		'icomoon-icon-rubber3',
		'icomoon-icon-schedule',
		'icomoon-icon-school1',
		'icomoon-icon-school4',
		'icomoon-icon-school6',
		'icomoon-icon-school7',
		'icomoon-icon-schoolclass',
		'icomoon-icon-science1',
		'icomoon-icon-science2',
		'icomoon-icon-science',
		'icomoon-icon-set1',
		'icomoon-icon-shake',
		'icomoon-icon-shelf',
		'icomoon-icon-shopping7',
		'icomoon-icon-signature2',
		'icomoon-icon-small53',
		'icomoon-icon-small54',
		'icomoon-icon-smartphone2',
		'icomoon-icon-smartphone',
		'icomoon-icon-stethoscope2',
		'icomoon-icon-student',
		'icomoon-icon-table3',
		'icomoon-icon-tablet2',
		'icomoon-icon-tactil1',
		'icomoon-icon-talking',
		'icomoon-icon-teacher',
		'icomoon-icon-teach',
		'icomoon-icon-telescope',
		'icomoon-icon-thought',
		'icomoon-icon-time2',
		'icomoon-icon-uniform',
		'icomoon-icon-university1',
		'icomoon-icon-university2',
		'icomoon-icon-university',
		'icomoon-icon-unknown1',
		'icomoon-icon-unknown',
		'icomoon-icon-virus',
		'icomoon-icon-wagon',
		'icomoon-icon-wall3',
		'icomoon-icon-window8',
		'icomoon-icon-working1',
		'icomoon-icon-2440',
		'icomoon-icon-2441',
		'icomoon-icon-2442',
		'icomoon-icon-air6',
		'icomoon-icon-airplane68',
		'icomoon-icon-barscode',
		'icomoon-icon-black330',
		'icomoon-icon-black331',
		'icomoon-icon-boat17',
		'icomoon-icon-box49',
		'icomoon-icon-call36',
		'icomoon-icon-call37',
		'icomoon-icon-chronometer10',
		'icomoon-icon-clipboard52',
		'icomoon-icon-commercial15',
		'icomoon-icon-container5',
		'icomoon-icon-container6',
		'icomoon-icon-crane6',
		'icomoon-icon-crane7',
		'icomoon-icon-delivered',
		'icomoon-icon-delivery16',
		'icomoon-icon-delivery17',
		'icomoon-icon-delivery18',
		'icomoon-icon-delivery19',
		'icomoon-icon-delivery20',
		'icomoon-icon-delivery21',
		'icomoon-icon-delivery23',
		'icomoon-icon-delivery25',
		'icomoon-icon-delivery26',
		'icomoon-icon-delivery28',
		'icomoon-icon-delivery29',
		'icomoon-icon-delivery30',
		'icomoon-icon-delivery31',
		'icomoon-icon-delivery33',
		'icomoon-icon-delivery34',
		'icomoon-icon-delivery35',
		'icomoon-icon-delivery36',
		'icomoon-icon-delivery37',
		'icomoon-icon-delivery38',
		'icomoon-icon-delivery39',
		'icomoon-icon-frontal19',
		'icomoon-icon-identification4',
		'icomoon-icon-international11',
		'icomoon-icon-international12',
		'icomoon-icon-international14',
		'icomoon-icon-international15',
		'icomoon-icon-localization2',
		'icomoon-icon-locked14',
		'icomoon-icon-logistics1',
		'icomoon-icon-logistics2',
		'icomoon-icon-logistics3',
		'icomoon-icon-logistics4',
		'icomoon-icon-logistics5',
		'icomoon-icon-logistics',
		'icomoon-icon-ocean3',
		'icomoon-icon-package10',
		'icomoon-icon-package11',
		'icomoon-icon-package12',
		'icomoon-icon-package13',
		'icomoon-icon-package8',
		'icomoon-icon-packages2',
		'icomoon-icon-phone322',
		'icomoon-icon-placeholder8',
		'icomoon-icon-sea8',
		'icomoon-icon-sea9',
		'icomoon-icon-search51',
		'icomoon-icon-talking2',
		'icomoon-icon-telephone91',
		'icomoon-icon-train20',
		'icomoon-icon-triangular42',
		'icomoon-icon-verification5',
		'icomoon-icon-view10',
		'icomoon-icon-weight10',
		'icomoon-icon-woman93',
		'icomoon-icon-world77',
		'icomoon-icon-shopping109',
		'icomoon-icon-shopping110',
		'icomoon-icon-shopping111',
		'icomoon-icon-shopping113',
		'icomoon-icon-shopping114',
		'icomoon-icon-finger2',
		'icomoon-icon-finger5',
		'icomoon-icon-finger',
		'icomoon-icon-hand8',
		'icomoon-icon-mobiletuxedo2',
		'icomoon-icon-ring2',
		'icomoon-icon-two33',
		'icomoon-icon-collapse3',
		'icomoon-icon-down44',
		'icomoon-icon-down45',
		'icomoon-icon-expand22',
		'icomoon-icon-left126',
		'icomoon-icon-left127',
		'icomoon-icon-left128',
		'icomoon-icon-left129',
		'icomoon-icon-next15',
		'icomoon-icon-previous11',
		'icomoon-icon-right103',
		'icomoon-icon-right104',
		'icomoon-icon-right105',
		'icomoon-icon-right106',
		'icomoon-icon-right107',
		'icomoon-icon-thin35',
		'icomoon-icon-thin36',
		'icomoon-icon-up76',
		'icomoon-icon-up77',
		'icomoon-icon-up78',
		'icomoon-icon-fa-credit-card',
		'icomoon-icon-fa-money',
		'icomoon-icon-uniF1B4',
		'icomoon-icon-uniF1B5',
		'icomoon-icon-fa-paypal',
		'icomoon-icon-fa-google-wallet',
		'icomoon-icon-fa-cc-visa',
		'icomoon-icon-fa-cc-mastercard',
		'icomoon-icon-fa-cc-discover',
		'icomoon-icon-fa-cc-amex',
		'icomoon-icon-fa-cc-paypal',
		'icomoon-icon-fa-cc-stripe',
	);
			
	if(defined('RPB_USE_ICOMOON')){
		$icons_list = array_merge($icons_list, $icomoon_list);
	}
	
	if(defined('RPB_USE_FONTAWESOME')){
		$fontawesome_list = array();
		
		$icons_list = array_merge($icons_list, $fontawesome_list);
	}

	return $icons_list;
}
endif;
*/


if(!function_exists('rockthemes_mm_modal_unique_id')):
function rockthemes_mm_modal_unique_id(){
	if(isset($GLOBALS['rockthemes_mm_modal_id'])){
		$GLOBALS['rockthemes_mm_modal_id']++;
	}else{
		$GLOBALS['rockthemes_mm_modal_id'] = 0;	
	}
	
	return 'modal-'.$GLOBALS['rockthemes_mm_modal_id'];
}
endif;





if(!function_exists('rockthemes_mm_admin_ui')):
function rockthemes_mm_admin_ui(){
	$return = '';
	
	$modal_holder = '<div class="modal_holder">';
	
	//Icon Modal 
	$modal_holder .= rockthemes_mm_admin_icons_modal();
	
	
	$modal_holder .= '</div>';//close modal_holder
	
	
	$return .= $modal_holder;
	
	echo rockthemes_escaped_out_render($return);
}
endif;

add_action( 'wp_after_admin_bar_render', 'rockthemes_mm_admin_ui' ); 

//echo rockthemes_mm_admin_ui();



?>