<?php
/*
**	Rockthemes Mega Menu Functions
**
*/



function rockthemes_mm_data_update_check($data = array()){
	global $rockthemes_mm_defaults;
	
	$level_1 = 0;
	$level_2 = 0;
			
	$i = 0;
	foreach($rockthemes_mm_defaults as $i_key => $default_options1){
		
		$found_level_1 = false;
		foreach($data as $option){
			if($default_options1['category_id'] === $option['category_id']){
				$found_level_1 = true;
				
				foreach($default_options1['elements'] as $t_key => $default_options2){
					$t = 0;
					foreach($option['elements'] as $opt){
												
						if($default_options2['id'] === $opt['id'] && $default_options2['type'] !== 'header'){
							
							if(is_array($rockthemes_mm_defaults[$i_key]['elements'][$t_key]['default'])){

								foreach($rockthemes_mm_defaults[$i_key]['elements'][$t_key]['default'] as $dk => $dv){
									if(isset($opt['default'][$dk])){
										$rockthemes_mm_defaults[$i_key]['elements'][$t_key]['default'][$dk] = $opt['default'][$dk];
									}
								}

							}else{
								$rockthemes_mm_defaults[$i_key]['elements'][$t_key]['default'] = $opt['default'];
							}

							break;	
						}
						$t++;
					}
				}
				break;
			}
		}
		
		$i++;
		
		if(!$found_level_1) continue;
		
	}
	
	
	return $rockthemes_mm_defaults;
	
	//die('success');
	exit;
	
}




/*
**	Save details
*/
function rockthemes_mm_validate_save_data($data=array()){
	if(empty($data) || !is_array($data)) return false;
	
	foreach($data as $key=>$val){
		if(is_array($val)){
			$val = 	rockthemes_mm_validate_save_data($val);
		}else{
			$data[$key] = wp_kses(sanitize_text_field($val),array());	
		}
	}
	
	return $data;
}
function rockthemes_mm_save_details($data, $data_fe, $menu_id){
	$return = update_post_meta($menu_id, '_rockthemes_mm', rockthemes_mm_validate_save_data(wp_slash(json_decode(stripslashes($data),true))));
	if($return){
		$return = update_post_meta($menu_id, '_rockthemes_mm_fe', rockthemes_mm_validate_save_data(wp_slash(json_decode(stripslashes($data_fe),true))));
	}else{
		return 'ERROR : BACKEND COULD NOT BEEN SAVED';	
	}
	
	if($return){
		return 'SAVED';	
	}else{
		return 'ERROR : FRONT END COULD NOT BEEN SAVED';	
	}
}
function rockthemes_mm_save_details_ajax(){
	if(!is_admin()) die('ERROR : Missing Request');
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		empty($_REQUEST['data']) || 
		empty($_REQUEST['data_fe']) || 
		empty($_REQUEST['menu_id']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rockthemes_mm_nonce') ||
		!check_ajax_referer('rockthemes_mm_nonce')) {
	
		//Die
		die('ERROR : Missing Request');	
	}
	echo rockthemes_mm_save_details($_REQUEST['data'], $_REQUEST['data_fe'], $_REQUEST['menu_id']);
	exit;
}
add_action('wp_ajax_rockthemes_mm_save_details', 'rockthemes_mm_save_details_ajax');





/*
**	Make Regular Image Element
*/

function rockthemes_mm_make_element_image($args = array()){

	$image_align_array = array(
		array('text' =>	'Top', 'value'=>'top'),
		array('text' => 'Left', 'value'=>'left'),
		array('text' => 'Right', 'value'=>'right'),
		array('text' => 'Bottom', 'value'=>'bottom')
	);
			
	extract($args);
	extract($default);
	
	$image_url = esc_attr($image_url);
	$image_id = esc_attr($image_id);
	
	if($image_id && $image_id !== '' && !wp_get_attachment_image($image_id,'')){
		$image_url = rockthemes_demo_image('',true);
	}
	
	$image_align_list = '<h4>'.esc_html__('Image Align','azoom').'</h4><select class="image_align" autocomplete="off">';
	foreach($image_align_array as $align){
		$image_align_list .= '<option value="'.esc_attr($align['value']).'" '.($align['value'] === $image_align ? 'selected' : '').'>'.esc_html($align['text']).'</option>';
	}
	$image_align_list .= '</select>';
	
		
	$return = '
	<div class="rockthemes-mm-element-setting '.esc_attr($level_class).' '.($image_url !== '' ? 'image-added' : '').'">
		<h3 class="rmm-element-heading">'.esc_html($label).'</h3>
		<p>'.stripslashes(($description)).'</p>
		<div class="rockthemes-mm-image-wrapper">'.($image_url !== ''  ? '<img src="'.esc_url($image_url).'" />' : '').'</div>
		<input id="'.esc_attr($id).'" name="'.esc_attr($id).'" type="text" value="'.esc_url($image_url).'"  data-image_id="'.esc_attr($image_id).'" />
		<a href="#" class="rockthemes-mm-text-link rockthemes_mm_image_uploader" data-ref="'.esc_attr($id).'">'.esc_html__('Upload Image', 'azoom').'</a>
		<a href="#" class="rockthemes-mm-text-link rockthemes_mm_image_delete" data-ref="'.esc_attr($id).'">'.esc_html__('Delete Image', 'azoom').'</a>
		<div class="clear"></div>
		<div id="'.esc_attr($id).'_details" class="image_extra_details">
			<h3>'.esc_html__('Extra Details', 'azoom').'</h3>
			'.$image_align_list.'
			'.rockthemes_mm_get_image_sizes($image_size, esc_html__('Select Image Size','azoom')).'
		</div>
	</div>';
	
	return $return;
}


function rockthemes_mm_make_element_background_image($args = array()){

	$image_valign_array = array(
		array('text' =>	'Top', 'value'=>'top'),
		array('text' => 'Center', 'value'=>'center'),
		array('text' => 'Bottom', 'value'=>'bottom'),
	);
	
	$image_halign_array = array(
		array('text' =>	'Left', 'value'=>'left'),
		array('text' => 'Center', 'value'=>'center'),
		array('text' => 'Right', 'value'=>'right'),
	);
	
	$image_repeat_array = array(
		array('text' => 'Repeat Both', 'value'=>'repeat'),
		array('text' => 'Repeat X', 'value'=>'repeat-x'),
		array('text' => 'Repeat Y', 'value'=>'repeat-y'),
		array('text' => 'No Repeat', 'value'=>'no-repeat'),
	);
			
	extract($args);
	extract($default);
	
	$image_valign_list = '<h4>'.esc_html__('Vertical Align','azoom').'</h4><select class="image_valign" autocomplete="off">';
	foreach($image_valign_array as $align){
		$image_valign_list .= '<option value="'.esc_attr($align['value']).'" '.($align['value'] === $valign ? 'selected' : '').'>'.esc_html($align['text']).'</option>';
	}
	$image_valign_list .= '</select>';
	
	
	
	$image_halign_list = '<h4>'.esc_html__('Horizontal Align','azoom').'</h4><select class="image_halign" autocomplete="off">';
	foreach($image_halign_array as $align){
		$image_halign_list .= '<option value="'.esc_attr($align['value']).'" '.($align['value'] === $halign ? 'selected' : '').'>'.esc_html($align['text']).'</option>';
	}
	$image_halign_list .= '</select>';
	
	
	$image_repeat_list = '<h4>'.esc_html__('Image Repeat','azoom').'</h4><select class="image_repeat" autocomplete="off">';
	foreach($image_repeat_array as $repeat){
		$image_repeat_list .= '<option value="'.esc_attr($repeat['value']).'" '.($repeat['value'] === $image_repeat ? 'selected' : '').'>'.esc_html($repeat['text']).'</option>';
	}
	$image_repeat_list .= '</select>';
	
	$image_url = esc_attr($image_url);
	$image_id = esc_attr($image_id);
	
	if($image_id && $image_id !== '' && !wp_get_attachment_image($image_id,'')){
		$image_url = rockthemes_demo_image('',true);
	}
		
	$return = '
	<div class="rockthemes-mm-element-setting '.esc_attr($level_class).' '.($image_url !== '' ? 'image-added' : '').'">
		<h3 class="rmm-element-heading">'.esc_html($label).'</h3>
		<p>'.stripslashes(($description)).'</p>
		<div class="rockthemes-mm-image-wrapper">'.($image_url !== ''  ? '<img src="'.esc_url($image_url).'" />' : '').'</div>
		<input id="'.esc_attr($id).'" name="'.esc_attr($id).'" type="text" value="'.esc_url($image_url).'"  data-image_id="'.esc_attr($image_id).'" />
		<a href="#" class="rockthemes-mm-text-link rockthemes_mm_image_uploader" data-ref="'.esc_attr($id).'">'.esc_html__('Upload Image', 'azoom').'</a>
		<a href="#" class="rockthemes-mm-text-link rockthemes_mm_image_delete" data-ref="'.esc_attr($id).'">'.esc_html__('Delete Image', 'azoom').'</a>
		<div class="clear"></div>
		<div id="'.esc_attr($id).'_details" class="image_extra_details">
			<h3>'.esc_html__('Extra Details', 'azoom').'</h3>
			'.$image_valign_list.'
			'.$image_halign_list.'
			'.$image_repeat_list.'
			<h4>'.esc_html__('Image Width (For Retina)', 'azoom').'</h4>
			<input type="text" class="width" value="'.esc_attr($width).'" autocomplete="off" placeholder="'.esc_html__('Enter the image width', 'azoom').'" />
			<h4>'.esc_html__('Image Height (For Retina)', 'azoom').'</h4>
			<input type="text" class="height" value="'.esc_attr($height).'" autocomplete="off" placeholder="'.esc_html__('Enter the image height', 'azoom').'" />
			'.rockthemes_mm_get_image_sizes($image_size, esc_html__('Select Background Image Size','azoom')).'
		</div>
	</div>';
	
	return $return;
}



/*
**	Get All Image Types (thumbnail, medium, large etc..)
*/

function rockthemes_mm_get_image_sizes($selected = null, $header = null){
	global $_wp_additional_image_sizes;
	
	$sizes = array();
	foreach( get_intermediate_image_sizes() as $s ){
 		$sizes[ $s ] = array( 0, 0 );
 		if( in_array( $s, array( 'thumbnail', 'medium', 'large' ) ) ){
 			$sizes[ $s ][0] = get_option( $s . '_size_w' );
 			$sizes[ $s ][1] = get_option( $s . '_size_h' );
 		}else{
 			if( isset( $_wp_additional_image_sizes ) && isset( $_wp_additional_image_sizes[ $s ] ) )
 				$sizes[ $s ] = array( $_wp_additional_image_sizes[ $s ]['width'], $_wp_additional_image_sizes[ $s ]['height'], );
 		}
 	}
		
	if(sizeof($sizes) <= 0) {return;}
	
	$return = '';
	
	$selected = esc_attr($selected);
	
	if(isset($header)) $return .= '<h4>'.esc_html($header).'</h4>';
			
	$return .= '<select class="image_size" autocomplete="off">';
	
	if($selected == "no-selected"){
		$return .= '<option value="no-selected" selected>Full Size</option>';
	}else{
		$return .= '<option value="no-selected">Full Size</option>';
	}
	
	
	foreach($sizes as $size => $atts){
		//Remove the unlrelated image sizes.
		if($size == '' ){
			//Do Nothing	
		}else{
			//If post type is allowed in our list and not unrelated add them to select item
			if($selected == $size){
				$return .= '<option value="'.$size.'" sizes="' . implode( 'x', $atts ) .'" selected>'.$size. ' ' . implode( 'x', $atts ) .'</option>';
			}else{
				$return .= '<option value="'.$size.'" sizes="' . implode( 'x', $atts ) .'">'.$size. ' ' . implode( 'x', $atts ) .'</option>';
			}
		}
	}
	
	$return .= '</select>';
	
	$return .= '</div>';
	
	return $return;
}



function rockthemes_mm_make_element_columns_selector($args = array()){
	
	$default = 3;
	extract($args);
	
	$default = (int) $default;
	
	$return = '
	<div class="rockthemes-mm-element-setting '.esc_attr($level_class).'">
		<h3 class="rmm-element-heading">'.esc_html($label).'</h3>
		<p>'.stripslashes(($description)).'</p>';
	
		$return .= '<ul id="'.esc_attr($id).'" class="rockthemes-mm-columns-selector">';
		
		for($i = 1; $i < 13; $i++){
			$return .= '<li class="col '.($i <= $default ? 'selected' : '').'">'.$i.' ÷ 12</li>';
		}
	
		$return .= '
		</ul>
	</div>';
	
	return $return;
}



/*
Regular Text Element
*/

if(!function_exists('rockthemes_mm_make_element_text_field')){
	function rockthemes_mm_make_element_text_field($args = array()){
		$default = '';
		extract($args);
		
		$return = '
		<div class="rockthemes-mm-element-setting '.esc_attr($level_class).'">
			<h3 class="rmm-element-heading">'.esc_html($label).'</h3>
			<p>'.stripslashes(($description)).'</p>
			<input autocomplete="off" type="text" id="'.esc_attr($id).'" value="'.esc_attr(stripslashes($default)).'" />
		</div>';
		return $return;
	}
}




function rockthemes_mm_make_element_icon($args = array()){
	
	extract($args);
	
	$default = esc_attr($default);
	
	$return = '
	<div class="rockthemes-mm-element-setting '.esc_attr($level_class).' '.($default !== '' ? 'icon-added' : '').'">
		<h3 class="rmm-element-heading">'.esc_html($label).'</h3>
		<p>'.esc_attr(stripslashes($description)).'</p>
		'.($default !== '' ? '<i class="rockthemes-mm-selected-icon icon-modal-button icomoon '.esc_attr($default).'" data-icon-ref="'.esc_attr($id).'"></i>' : '').'
		<input type="text" id="'.esc_attr($id).'" name="'.esc_attr($id).'" value="'.esc_attr($default).'" />
		<a href="#" class="rockthemes-mm-text-link icon-modal-button" data-icon-ref="'.esc_attr($id).'">'.esc_html__('Choose Icon','azoom').'</a>
		<a href="#" class="rockthemes-mm-text-link rockthemes_mm_icon_delete" data-ref="'.esc_attr($id).'">'.esc_html__('Delete Icon', 'azoom').'</a>
	</div>
	';
	
	return $return;
}



/*
Checkbox (With jQuery Slide)
*/

if(!function_exists('rockthemes_mm_make_element_checkbox')){
	function rockthemes_mm_make_element_checkbox($args = array()){
		$default = '';
		extract($args);
		
		$return = '<div class="rockthemes-mm-element-setting '.esc_attr($level_class).'">';
		$return .= '<h3 class="rmm-element-heading">'.esc_html($label).'</h3>';
		$return .= '<p>'.stripslashes($description).'</p>';
		
		$return .= '<section id="'.esc_attr($id).'" class="checkbox_holder">';
            
        $return .= '<div class="slider-frame">';
		if($default == "YES"){
			$return .= '<span class="slider-button on">YES</span>';
		}else{
			$return .= '<span class="slider-button">NO</span>';
		}
		$return .= '</div>';

        $return .= '</section>';
		$return .= '</div>';
		
		return $return;
	}
}



/*
Select (Dropdown) Element
*/

if(!function_exists('rockthemes_mm_make_element_select')){
	function rockthemes_mm_make_element_select($args = array()){
		$default = '';
		extract($args);
		
		$default = esc_attr($default);
		
		$return = '<div class="rockthemes-mm-element-setting '.esc_attr($level_class).'">';
		$return .= '<h3 class="rmm-element-heading">'.esc_html($label).'</h3>';
		$return .= '<p>'.stripslashes($description).'</p>';
		$return .= '<select name="'.esc_attr($id).'" id="'.esc_attr($id).'">';
		
		foreach($choices as $choice){
			if($choice['value'] == $default){
				$return .= '<option value="'.$choice['value'].'" selected>'.$choice['text'].'</option>';
			}else{
				$return .= '<option value="'.$choice['value'].'" >'.$choice['text'].'</option>';
			}
		}
		
		$return .= '</select>';
		$return .= '</div>';
		
		return $return;
	}
}



function rockthemes_mm_make_element_sidebar_list($args = array()){
	global $wp_registered_sidebars;
	
	extract($args);
	
	$default = esc_attr($default);
	
	$return = '<div class="rockthemes-mm-element-setting '.esc_attr($level_class).'">';
	$return .= '<h3 class="rmm-element-heading">'.esc_html($label).'</h3>';
	$return .= '<p>'.stripslashes($description).'</p>';
	$return .= '<select name="'.esc_attr($id).'" id="'.esc_attr($id).'">';

	$return .= '<option value="">No Sidebar</option>';
		
	if($wp_registered_sidebars && is_array($wp_registered_sidebars) && sizeof($wp_registered_sidebars) > 0) {
		foreach($wp_registered_sidebars as $sidebar){
			if($sidebar['id'] === $default){
				$return .= '<option value="'.$sidebar['id'].'" selected>'.$sidebar['name'].'</option>';
			}else{
				$return .= '<option value="'.$sidebar['id'].'">'.$sidebar['name'].'</option>';
			}
		}
	}
	
	$return .= '</select>';
	$return .= '</div>';

	return $return;	
		
}


function rockthemes_mm_make_element_sticker_list($atts = array()){
	$menu_sticker_array = array(
		array(
			'name'	=>	'Hot',
			'id'	=>	'hot',
		),
		array(
			'name'	=>	'New',
			'id'	=>	'new',
		),
		array(
			'name'	=>	'Info',
			'id'	=>	'info',
		),
	);
	
	extract($atts);
	
	$default = esc_attr($default);
	
	$return = '<div class="rockthemes-mm-element-setting '.esc_attr($level_class).'">';
	$return .= '<h3 class="rmm-element-heading">'.esc_html($label).'</h3>';
	$return .= '<p>'.stripslashes($description).'</p>';
	$return .= '<select name="'.esc_attr($id).'" id="'.esc_attr($id).'">';
				
	$return .= '<option value="">No Sticker</option>';
	
	foreach($menu_sticker_array as $sticker){
		if($sticker['id'] === $default){
			$return .= '<option value="'.$sticker['id'].'" selected>'.$sticker['name'].'</option>';
		}else{
			$return .= '<option value="'.$sticker['id'].'">'.$sticker['name'].'</option>';
		}
	}
	
	$return .= '</select>';
	$return .= '</div>';

	return $return;	

}





/*
Select with Images Element
*/

if(!function_exists('rockthemes_mm_make_element_element_images')){
	function rockthemes_mm_make_element_select_images($args = array()){
		
		$default = '';
		
		extract($args);
		
		$default = esc_attr($default);
		
		$columns = isset($max_cols) && $max_cols !== '' ? $max_cols : '';
				
		$return = '<div class="rockthemes-mm-element-setting '.esc_attr($level_class).'">';
		$return .= '<h3 class="rmm-element-heading">'.esc_html($label).'</h3>';
		$return .= '<p>'.stripslashes($description).'</p>';
		$return .= '<div id="'.esc_attr($id).'" class="image-select-list">';
		$return .= '<div class="image-select-container rmm-columns rmm-large-'.esc_attr($columns).'">';
		
			foreach($choices as $choice){
				if($choice['value'] == $default){
					$return .= '<div class="image-select-elem selected" value="'.$choice['value'].'"><img src="'.$choice['url'].'" alt="'.$choice['value'].'" /></div>';
				}else{
					$return .= '<div class="image-select-elem" value="'.$choice['value'].'"><img src="'.$choice['url'].'" alt="'.$choice['value'].'" /></div>';
				}
			}

		$return .= '</div>';
		$return .= '</div>';
		$return .= '</div>';

		return $return;
	}
}






function rockthemes_mm_make_element($elem = array()){
	$function_name = 'rockthemes_mm_make_element_'.$elem['type'];
	if(function_exists($function_name)){
		return $function_name($elem);
	}else{
		return '';	
	}	
}



?>