<?php
/*
**	Defualt values of Rockthemes Mega Menu elements
**
*/


$rockthemes_mm_defaults = array(

	array(
		'category_name' => 'General',
		'category_id'	=> 'general_settings',
		'class'			=> '',
		'level_class'	=> 'all_menu_items',
		'elements'		=> array(
		
			array(
				'label'			=> 'Navigation Label',
				'id'			=> 'nav_label',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'You can display or hide the navigation menu. Also you can set navigation menu as heading. When you set label as heading, image and widget will not be aligned to top.',
				'choices'		=> array(
					array('text' => 'Show', 'value'=>'1'),
					array('text' => 'Hide', 'value'=>'3'),
					array('text' => 'Heading', 'value'=>'2'),
				),
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Disable Link',
				'id'			=> 'disable_link',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'level_class'	=> 'all_menu_items',
				'description'	=> 'If you want, you can disable the link of this item. Useful for heading menu.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
		
			array(
				'label'			=> 'Regular Icon',
				'id'			=> 'regular_icon',
				'type'			=> 'icon',
				'is_hidden'		=> 'false',
				'level_class'	=> 'all_menu_items',
				'description'	=> 'Select an icon for regular menu',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Mobile Icon',
				'id'			=> 'mobile_icon',
				'type'			=> 'icon',
				'is_hidden'		=> 'false',
				'level_class'	=> 'all_menu_items',
				'description'	=> 'Select an icon for mobile menu',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Enable Horizontal Menu Padding',
				'id'			=> 'enable_horizontal_padding',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'You can easily enable sub menu margins',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Enable Vertical Menu Padding',
				'id'			=> 'enable_vertical_padding',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'You can easily enable sub menu margins',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			
			array(
				'label'			=> 'Enable Sub Menu Padding',
				'id'			=> 'enable_submenu_padding',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'level_class'	=> 'all_menu_items',
				'description'	=> 'Only for Mega Menu. When using Mega Menu, you can enable padding for all sub menus.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Sub Menu Model (Mega Menu / Flyout Menu)',
				'id'			=> 'submenu_model',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'level_class'	=> 'top_menu_items_only',
				'description'	=> 'You can enable mega menu for submenu',
				'choices'		=> array(
					array('text' => 'Flyout', 'value'=>''),
					array('text' => 'Mega Menu', 'value'=>'megamenu'),
				),
				'default'		=> 'left'
			),
						
			array(
				'label'			=> 'Sub Menu Width',
				'id'			=> 'submenu_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'level_class'	=> 'top_menu_items_only',
				'is_translate'	=> 'true',
				'description'	=> 'You can enter a width for the sub menu. If you want to use default width, leave this area empty. Enter a valid px value (i.e. 340px)',
				'choices'		=> '',
				'default'		=> '',
			),
			
			array(
				'label'			=> 'Sub Menu Alignment',
				'id'			=> 'submenu_align',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'level_class'	=> 'top_menu_items_only',
				'description'	=> 'If you use regular menu, you can choose to align sub menu to left or right. If you are using mega menu, you will need to enter a submenu width to use submenu alignment.',
				'choices'		=> array(
					array('text' =>	'Default', 'value'=>''),
					array('text' => 'Left', 'value'=>'left'),
					array('text' => 'Right', 'value'=>'right'),
					array('text' => 'Full', 'value'=>'full'),
				),
				'default'		=> 'left'
			),
			
			array(
				'label'			=> 'Enable Sub Menu Light Colors',
				'id'			=> 'sub_menu_light_colors',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'level_class'	=> 'all_menu_items',
				'description'	=> 'If you enable this feature, sub menus will use light font color. This color can be set in Theme Options.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Enable Sticker',
				'id'			=> 'enable_sticker',
				'type'			=> 'sticker_list',
				'level_class'	=> 'all_menu_items',
				'is_hidden'		=> 'false',
				'description'	=> 'You can enable the sticker on menu. Sticker will display a text on the menu item. You can also change sticker colors in the Theme Options',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Sticker Title',
				'id'			=> 'sticker_title',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'level_class'	=> 'all_menu_items',
				'is_translate'	=> 'true',
				'description'	=> 'If you enabled sticker, you should enter a sticker title. A sticker title is mostly the same name as the sticker. (i.e. Hot)',
				'choices'		=> '',
				'default'		=> '',
			),

			array(
				'label'			=> 'Display A Widget',
				'id'			=> 'display_widget',
				'type'			=> 'sidebar_list',
				'is_hidden'		=> 'false',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'You can display a widget in the mega menu. If you want to display a widget, you should select the sidebar of it.',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Widget Alignment',
				'id'			=> 'widget_align',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'Widget will align itself with the menu label. You can choose to where to align widget.',
				'choices'		=> array(
					array('text' => 'Bottom', 'value'=>'bottom'),
					array('text' =>	'Top', 'value'=>'top'),
				),
				'default'		=> 'bottom'
			),
			
		)
	),
	
	array(
		'category_name' => 'Image',
		'category_id'	=> 'image_settings',
		'class'			=> '',
		'level_class'	=> 'all_menu_items',
		'elements'		=> array(
		
			array(
				'label'			=> 'Image',
				'id'			=> 'menu_image',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'You can upload an image for this menu item.',
				'choices'		=> '',
				'default'		=> array(
					'image_url'		=> '',
					'image_id'		=> '',
					'image_align'	=> '',
					'image_size'	=> ''
				)
			),
			
			array(
				'label'			=> 'Submenu Background Image',
				'id'			=> 'submenu_background_image',
				'type'			=> 'background_image',
				'is_hidden'		=> 'false',
				'level_class'	=> 'all_menu_items',
				'description'	=> 'You can upload an image for this menu item.',
				'choices'		=> '',
				'default'		=> array(
					'valign'		=> '',
					'halign'		=> '',
					'image_repeat'	=> '',
					'image_id'		=> '',
					'image_url'		=> '',
					'image_size'	=> '',
					'width'			=> '',
					'height'		=> ''
				)
			),
			
		)
	),
	
	array(
		'category_name' => 'Columns',
		'category_id'	=> 'columns_settings',
		'class'			=> '',
		'level_class'	=> 'sub_menu_items_only',
		'elements'		=> array(

			array(
				'label'			=> 'Enable Menu Columns',
				'id'			=> 'enable_menu_columns',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'If you want to use columns, you should enable this feature. When you enable this feature, you can choose different columns for this menu item.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
						
			array(
				'label'			=> 'Mega Menu Columns',
				'id'			=> 'menu_item_columns',
				'type'			=> 'columns_selector',
				'level_class'	=> 'sub_menu_items_only',
				'description'	=> 'This feature will only set columns for megamenu sub menus. Select how many columns will this element use. Columns should match to 12 in total.',
				'choices'		=> '',
				'default'		=> '4'
			),

		)
	)	
);

?>