<?php
/*
**	Rockthemes Mega Menu Functions
**
*/


function rockthemes_mm_details_container(){
	global $rockthemes_mm_defaults;
	
	$tabs = '<ul>';
	foreach ($rockthemes_mm_defaults as $tab){
		$class = (!empty($tab['class'])) ? 'rockthemes_mm_tab_nav '.$tab['class'].'' : 'rockthemes_mm_tab_nav';
		$tabs .= '<li '.(!empty($tab['level_class']) ? 'class="'.esc_attr($tab['level_class']).'"' : '').'><a href="" id="'.esc_attr($tab['category_id']).'_button" class="'.esc_attr($class).'">'.esc_html($tab['category_name']).'</a></li>';
	}
	$tabs .= '</ul>';
	
	$return = '
		<div id="rockthemes_mm_details_container" class="rockthemes_mm_details_container rockthemes-transition">
			<div class="rockthemes-mm-body">
				<div class="rockthemes-mm-header">
					<h3><i class="icomoon icomoon-icon-cog2"></i> Mega Menu Settings</h3>
					<span class="rmm-close-icon">×</span>
				</div>
				<div class="rmm-actions">
					<div class="rmm-details-tabs">
						'.$tabs.'
					</div>
					<div class="rmm-button rmm-button-save"><i class="button-icon icomoon icomoon-icon-file4"></i> '.esc_html__('SAVE','azoom').'</div>
				</div>
				<div class="rmm-details-loader"><i class="icomoon icomoon-icon-spinner2 fullSpin"></i></div>
				<div class="rockthemes-mm-element">
					
				</div>
			</div>
		</div>
	';
	
	return $return;
}
function rockthemes_mm_details_container_ajax(){
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rockthemes_mm_nonce') ||
		!check_ajax_referer('rockthemes_mm_nonce')) {
	
		//Die
		die('ERROR');		
	}
	echo rockthemes_mm_details_container();
	exit;
}
add_action('wp_ajax_rockthemes_mm_details_container', 'rockthemes_mm_details_container_ajax');







function rockthemes_mm_get_data($data = array()){
	global $rockthemes_mm_defaults;
	
	if(!isset($data['menu_id'])){
		return 'ERROR : No Button ID';	
	}
	
	$return = (get_post_meta($data['menu_id'], '_rockthemes_mm'));
		
	if($return && isset($return[0]) && is_array($return[0])){	
		$return = rockthemes_mm_data_update_check($return[0]);
	}else{
		$return = $rockthemes_mm_defaults;	
	}
	$return = rockthemes_mm_get_features($return);
	
	return $return;
}
function rockthemes_mm_get_data_ajax(){
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rockthemes_mm_nonce') ||
		!check_ajax_referer('rockthemes_mm_nonce') || 
		!isset($_REQUEST['data']) ||
		empty($_REQUEST['data'])) {
	
		//Die
		die('ERROR');		
	}
	echo (rockthemes_mm_get_data($_REQUEST['data']));
	exit;
}
add_action('wp_ajax_rockthemes_mm_get_data', 'rockthemes_mm_get_data_ajax');




function rockthemes_mm_get_features($data = array()){
	
	//$navigation_side	= '<ul>';
	
	$content 			= '<div class="content_holder">';
		
	$firstCat = true;

	foreach($data as $option){
		
		/* This will generate elements inside the category.
		** This loop will check the element type then will generate the element according to it's type
		*/
		$class = (!empty($option['class'])) ? 'rockthemes_mm_tab_nav '.$option['class'].'' : 'rockthemes_mm_tab_nav';
		
		//Check if the first button, then add active_button class to it
		$activeBtn = $firstCat ? " active_button " : "";
		
		/*
		**	Navigation label will be used for tabbed details. Disabled for now
		*/
		//$navigation_side .= '<li '.($firstCat ? 'class="active_nav_item"' : '').'><a href="" id="'.$option['category_id'].'_button" class="'.$class.$activeBtn.'">'.$option['category_name'].'</a></li>';

			//Only show the first content
			//$hide = !$firstCat ? "hide" : "active_content";
			$firstCat = false;
			
			//starting content div
			$content .= '<div class="content" id="'.esc_attr($option['category_id']).'">';
			//$content .= '<div class="content_header '.$class.'">'.$option['category_name'].'</div>';

		foreach($option['elements'] as $element){
			if(isset($element['is_hidden']) && $element['is_hidden'] === 'true') continue;
			$content .= '<div class="in_content">'.rockthemes_mm_make_element($element).'</div>';

		}

			$content .= '<div class="clear"></div>';
			//closing content div
			$content .= '</div>';
	}
	//closing content-holder div
	$content .= '</div>';
	
	//$navigation_side .= '</ul>';
	
	return $content;
}



?>