<?php
/**
 * Custom Walker
 *
 * @access      public
 * @since       1.0 
 * @return      void
*/
class Rockthemes_MegaMenu_Walker extends Walker_Nav_Menu
{
	function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0){
		global $wp_query;
		
		//Get Mega Menu Front End Data (_rockthemes_mm_fe)
		$data = get_post_meta($item->ID, '_rockthemes_mm_fe');
		if($data && !empty($data) && count($data) > 0){
			$data = $data[0];	
		}

		$enable_menu_columns = false;
		$megamenu = false;
		$column = 1;		
		if($depth > 0 && $data){
						
			$top_data = get_post_meta( $item->menu_item_parent, '_rockthemes_mm_fe' );			
			
			if($top_data && !empty($top_data) && count($top_data) > 0){
				$top_data = $top_data[0];	
			}
			
			if($data && isset($data['menu_item_columns']) && $data['menu_item_columns']){
				$column = $data['menu_item_columns'];
			}

			$megamenu = isset($top_data['submenu_model']) && $top_data['submenu_model'] === 'megamenu' ? true : false;
		
			if(isset($data['enable_menu_columns']) && $data['enable_menu_columns'] === 'YES'){
				$enable_menu_columns = true;
			}
		}
		
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		
		$class_names = $value = '';
		
		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		
		$labelclass = ' show-label';
		
		if($data && isset($data['nav_label'])){
			switch($data['nav_label']){
				case 1 :
				$labelclass = ' show-label';
				break;
				
				case 2 :
				$labelclass = ' heading-label';
				break;   
				
				case 3 :
				$labelclass = ' hide-label';
				break;
			}
		}
		
		// $labelclass = (isset($item->nav_label) && ($item->nav_label == 1))? ' show-label' : ' hide-label';
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );          
		$class_megamenu = ( $data && isset($data['submenu_model']) && $data['submenu_model'] === 'megamenu' ) ? ' megamenu': ' regularmenu ';
		$class_submargin = '';
		$class_padding = '';
		
		//Do not highlight inline navigation elements which contains # (hash) in their link
		if(isset($item->url) && strpos(esc_attr( $item->url), '#') > -1 && strpos($class_names, 'current-menu-item') > -1){
			$class_names = str_replace('current-menu-item','',$class_names);
		}

		if($data && isset($data['enable_submenu_padding']) && ($data['enable_submenu_padding']) === 'YES'){
			$class_submargin = ' padding-submenu ';  
		}

		if($data && isset($data['enable_horizontal_padding']) && $data['enable_horizontal_padding'] === 'YES'){
			$class_padding .= ' rtm-horizontal-padding ';
		}
		if($data && isset($data['enable_vertical_padding']) && $data['enable_vertical_padding'] === 'YES'){
			$class_padding .= ' rtm-vertical-padding ';
		}
		
		$menu_depth_class = ' rtm-menu-depth-'.$depth.' ';

		if(($megamenu && $enable_menu_columns) || $enable_menu_columns){
			//$class_megamenu .= ' large-'.(12/$column).' medium-'.(12/$column).' small-'.(12/$column).' columns ';
			$class_megamenu .= ' large-'.($column).' medium-'.($column).' small-'.($column).' columns ';
		}
		$class_names = ' class="'. esc_attr( $class_names.$class_megamenu.$class_padding.$class_submargin. $labelclass.$menu_depth_class);
		
		//Check custom alignment
		$inline_data = ' ';
		if($data && isset($data['submenu_width']) && $data['submenu_width'] !== ''){
			if(strpos($data['submenu_width'], 'px') < 0) $data['submenu_width'] = $data['submenu_width'].'px';//Add px if not added
			$inline_data .= ' data-mm-width="'.esc_attr($data['submenu_width']).'" ';
		}
		
		if(($data && isset($data['submenu_align'])) && 
			((isset($data['submenu_width']) && $data['submenu_width'] !== '') ||
			(isset($data['submenu_model']) && $data['submenu_model'] === ''))){
			//submenu_model == '' flyout
			$inline_data .= ' data-mm-align="'.esc_attr($data['submenu_align']).'" ';
		}
		
		if($data && isset($data['submenu_background_image']) && isset($data['submenu_background_image']['url']) && $data['submenu_background_image']['url']!== ''){
			$img_url = $data['submenu_background_image']['url'];
			
			if(isset($data['submenu_background_image']['id']) && isset($data['submenu_background_image']['image_size'])){
				$img_url_test = wp_get_attachment_image_src($data['submenu_background_image']['id'], $data['submenu_background_image']['image_size']);
				
				if($img_url_test == ''){
					$img_url = rockthemes_demo_image($data['submenu_background_image']['image_size'],true);	
				}else{
					$img_url = isset($img_url_test[0]) ? $img_url_test[0] : $img_url;
				}
			}
						
			$inline_data .= ' data-sub-bg-img="'.esc_url($img_url).'" 
							  data-sub-bg-img-halign="'.esc_attr(isset($data['submenu_background_image']['halign']) ? $data['submenu_background_image']['halign'] : 'left').'" 
							  data-sub-bg-img-valign="'.esc_attr(isset($data['submenu_background_image']['valign']) ? $data['submenu_background_image']['valign'] : 'top').'" 
							  data-sub-bg-img-repeat="'.esc_attr(isset($data['submenu_background_image']['image_repeat']) ? $data['submenu_background_image']['image_repeat'] : 'no-repeat').'" 
							  data-sub-bg-img-width="'.esc_attr(isset($data['submenu_background_image']['width']) ? $data['submenu_background_image']['width'] : '').'" 
							  data-sub-bg-img-height="'.esc_attr(isset($data['submenu_background_image']['height']) ? $data['submenu_background_image']['height'] : '').'" ';	
		}

		//Is there any images in the menu?
		$menu_image = '';
		$menu_image_align = false;
		if($data && isset($data['menu_image']) && 
			isset($data['menu_image']['url']) && $data['menu_image']['url'] !== '' && $depth !== 0 &&
			isset($data['menu_image']['image_align']) && $data['menu_image']['image_align'] !== ''){
			
			if(isset($data['menu_image']['id'])){
				$menu_image = wp_get_attachment_image($data['menu_image']['id'], (isset($data['menu_image']['image_size']) ? $data['menu_image']['image_size'] : 'full'));
				if($menu_image == ''){
					$menu_image = rockthemes_demo_image((isset($data['menu_image']['image_size']) ? $data['menu_image']['image_size'] : 'full'));
				}
			}
			
			if(isset($data['menu_image']['image_align'])){
				$menu_image_align = $data['menu_image']['image_align'];	
				$menu_image = '<span class="rtm-menu-image rtm-menu-image-'.esc_attr($menu_image_align).'">'.$menu_image.'</span>';
			}
			
			if($menu_image !== '' && $menu_image_align !== false){
				$class_names .= ' rtm-has-img ';
			}
		}
		
		//Is there any widgets in the menu?
		$menu_widget = '';
		$menu_widget_align = false;
		if($data && isset($data['display_widget']) && !empty($data['display_widget']) && $depth !== 0){
			$sidebar_widgets = '';
			ob_start();
			dynamic_sidebar($data['display_widget']);
			$sidebar_widgets = ob_get_contents();
			ob_get_clean();
			$widget_padding = true;
			
			$menu_widget = '<div class="rtm-widget">'.$sidebar_widgets.'<div class="clear"></div></div>';	
			
			if(isset($data['widget_align']) && $data['widget_align'] !== ''){
				$menu_widget_align = $data['widget_align'];	
			}
			
			if($menu_widget !== '' && $menu_widget_align){
				$class_names .= ' rtm-has-widget ';	
			}
		}
		
		if($data && isset($data['sub_menu_light_colors']) && $data['sub_menu_light_colors'] === 'YES'){
			$class_names .= ' rtm-menu-light-fonts ';	
		}
		
		$disable_link = false;
		if(isset($data) && isset($data['disable_link']) && $data['disable_link'] === 'YES'){
			$disable_link = true;
			$class_names .= ' link-disabled ';	
		}
		
		$class_names .= '"';//close the class=""
		
		$output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names.$inline_data.'>';
		
		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

		$description  = ! empty( $item->description ) ? '<span class="description">'.esc_html( $item->description ).'</span>' : '';
		
		$mobile_icon = ($data && !empty($data['mobile_icon'])) ? ' data-mobile-icon="'.esc_attr( $data['mobile_icon']).'"' : '';
		$icon  = ($data && !empty( $data['regular_icon'] )) ? '<i class="nav-icon dismiss-icon '.esc_attr( $data['regular_icon'] ).'"></i> ' : '';
		$mobile_icon_html = $mobile_icon != '' ? '<span class="mobile-icon hide" '.$mobile_icon.'></span>' : '';
		
		$prepend = '<span class="main-nav-item-title main-title-with-desc">';
		$append = '</span>';
		
		//Add Icon
		//if(is_rtl()){
			//$append = $icon.$mobile_icon_html.$append;
		//}else{
			$prepend .= $icon.$mobile_icon_html;
		//}
		
		$item_output = $args->before;
				
		//Enable the link
		if(!$disable_link){
			$item_output .= '<a'. $attributes .'>';	
		}elseif($depth === 0){
			$item_output .= '<a>';
		}
		
		//If label is heading, then display it as heading
		if(strpos($labelclass, 'heading-label') > -1){
			if($data && $menu_image_align && $menu_image_align == 'top'){
				$menu_image_align = 'bottom';	
			}
			$item_output .= '<div class="mm-heading-container heading-nav"><div class="azoom-heading-icon heading-icon-widget"></div><h3 class="widget-title">';
		}
				
		//Image is Before Or Left?
		if($data && $menu_image_align && $menu_image_align == 'top'){
			$item_output .= '<span class="rtm-menu-image relative-container">'.$menu_image.'</span>';
		}
		if($data && $menu_image_align && $menu_image_align == 'left'){
			$prepend = '<span class="rtm-menu-image">'.$menu_image.'</span>'.$prepend;
		}
		
		//Widget is Before?
		if($data && $menu_widget_align && $menu_widget_align == 'top'){
			$item_output .= $menu_widget;
		}
		
		$item_output .= $args->link_before .$prepend;
		
		
		//Display the title/label
		if(strpos($labelclass, 'hide-label') > -1){
			//Hide the label	
			$item_output .= '<span class="hidden">'.apply_filters( 'the_title', $item->title, $item->ID ).'</span>';  
		}else{
			$item_output .= apply_filters( 'the_title', $item->title, $item->ID ); 
			if($data && isset($data['enable_sticker']) && $data['enable_sticker'] !== ''){
				$item_output .= '<span class="rtm-menu-sticker sticker-model-'.esc_attr($data['enable_sticker']).'">'.esc_html($data['sticker_title']).'</span>';
			}
		}
		
		//Image is Right?
		if($data && $menu_image_align && $menu_image_align == 'right'){
			$append .= $menu_image;
		}
		
		$item_output .= $append;
		$item_output .= $args->link_after;
		
		
		if(strpos($labelclass, 'heading-label') > -1){
			$item_output .= '</h3><hr/></div>';
		}
		
		//Image is After?
		if($data && $menu_image_align && $menu_image_align == 'bottom'){
			$item_output .= $menu_image;
		}
		
		if(!$disable_link || $depth === 0){
			$item_output .= '</a>';
		}
						
		//Widget is After?
		if($data && $menu_widget_align && $menu_widget_align == 'bottom'){
			$item_output .= $menu_widget;
		}
		
		if($description !== ''){
			$item_output .= $description;
		}
		
		$item_output .= $args->after;
		
		
		
		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}