<?php
/*
**	Rock Theme Options - Import Export Datas
**
**	Elements are located here
**
**	Version	:	1.0
*/

global $pagenow;
if(($pagenow !== 'themes.php' || !isset($_REQUEST['page']) || strpos($_REQUEST['page'],'rock_options') === false)
	&& ( !(defined( 'WP_ADMIN' ) && WP_ADMIN ) &&  !( defined( 'DOING_AJAX' ) && DOING_AJAX ))) return;



function rockthemes_to_generate_import_export_modal(){
	//return;
	$export_data = rockthemes_to_gather_export_data();
	
	$modules = array(
		'curvy_slider' 			=>	'Curvy Slider',
		'rock_form_builder'		=>	'Rock Form Builder',
		'rock_page_builder'		=>	'Rock Page Builder',
		'rock_theme_options'	=>	'Rock Theme Options',
		'rock_sidebar'			=>	'Rock Custom Sidebars',
		'wordpress_details'		=>	'Wordpress Details'
	);
	
	$module_select = '<h4>Select Modules To Load</h4>';
	foreach($modules as $module => $name){
		$module_select .= '<input autocomplete="off" autocomplete="off" type="checkbox" value="1" class="module_'.$module.'" checked /><label>'.$name.'</label><br/>';
	}
	
	$return = '
	<div id="import_all_datas_modal" class="row-fluid">
		<div class="header">
			<h1>Theme Options Load / Export</h1>
		</div>
			<div class="row-fluid select-load-modules">
				<h3>LOAD DEMO DATA</h3>
				<p>To load a demo data, simply select the demo you want first. In the "Select A Demo" you will see our diferent demos. After you select a demo, you can choose which modules you want to load. And then click on "Load Data" button</p>
				<hr/>
				'.$module_select.'
				<h4>Select A Demo</h4>
				'.xr_get_demo_list_selector_html().'
				<div class="button rockthemes_to_import_predefined_data_button" title="Load the data as seen in demo">Load Demo Data</div>
				<br/><br/><br/>
			</div>
			<hr/>
			<br/>
			<div class="row-fluid export_data">
				<h3>LOAD YOUR DATA</h3>
				<strong>Load Data</strong><br/>
				<p>Paste your saved data and then click to "Load Data" button.</p><br/>
				<textarea class="rockthemes_to_import_data"></textarea>
				<br/>
				<div class="button rockthemes_to_import_data_button">Load Data</div>
			</div>
			<br/>
			<hr/>
			<br/>
			<div class="row-fluid export_data">
				<h3>EXPORT YOUR DATA</h3>
				<strong>Export Data</strong><br/>
				<p>Store this data in a file by using your favorite text editor.</p><br/>
				<textarea class="rockthemes_to_export_textarea">'.$export_data.'</textarea>
			</div>
			<hr/>
	</div>';
		
	echo rockthemes_escaped_out_render($return);
	rockthemes_to_import_export_js();
	return;
}


function rockthemes_to_gather_export_data(){
	global $rockthemes_to_options;
	$return = '';
	
	$data_array = array();
	
	$data_array['rockthemes_export_settings'] = json_encode(
		array(
			'site_url'		=>	home_url(),
			'media_url'		=>	wp_upload_dir()
		)
	);

	//Get Rock Theme Options data
	$data_array[] = array('module' => 'rock_theme_options', 'data' => json_encode(array('site_url' => home_url(), 'media_url' => wp_upload_dir(), 'datas' => $rockthemes_to_options)));//$rockthemes_to_options is now php array, turn it into json string
	
	//Rock Form Builder Data
	if(function_exists('rockthemes_fb_get_export_data')){
		$data_array[] = array('module' => 'rock_form_builder', 'data' => rockthemes_fb_get_export_data());
	}elseif(function_exists('rfb_export_data')){
		$data_array[] = array('module' => 'rock_form_builder', 'data' => rfb_export_data());
	}
		
	//Rock Page Builder Data
	if(function_exists('rockthemes_pb_get_export_data')){
		$data_array[] = array('module' => 'rock_page_builder', 'data' => rockthemes_pb_get_export_data());	
	}
	
	//Curvy Slider Data
	if(function_exists('curvy_slider_get_export_data')){
		$data_array[] = array('module' => 'curvy_slider', 'data' => curvy_slider_get_export_data());	
	}
	
	//Rock Sidebars
	if(function_exists('rockthemes_sidebar_get_export_data')){
		$data_array[] = array('module' => 'rock_sidebar', 'data' => rockthemes_sidebar_get_export_data());	
	}
	
	if(function_exists('rockthemes_to_wd_export')){
		$data_array[] = array('module' => 'wordpress_details', 'data' => rockthemes_to_wd_export());	
	}
		
	return json_encode($data_array);
}





function rockthemes_to_import_export_js(){
?>
<script type="text/javascript">
	jQuery(document).ready(function(){
		
		//Main Import Functions
		jQuery(document).on("click", ".rockthemes_to_import_data_button", function(){
			if(jQuery(this).find("i").length) return;
			
			var button = jQuery(this);
			
			var old_button_text = jQuery(this).html();

			//Add loading spin
			jQuery(this).html('Loading data. Do not navigate away from this page! <i class="fa fa-refresh fa-spin"></i>');
			
		
			var data = jQuery(".rockthemes_to_import_data").val();
			var details = get_details();
					
			jQuery.post(ajaxurl, {data:data, details:details, action:"rockthemes_to_import_all_datas"}, function(data){
				button.html(old_button_text);
			});
		
		});
		
		jQuery(document).on("click", ".rockthemes_to_import_predefined_data_button", function(){
			if(jQuery(this).find("i").length) return;
			
			var button = jQuery(this);
			
			var old_button_text = jQuery(this).html();
			//Add loading spin
			jQuery(this).html('Loading data. Do not navigate away from this page! <i class="fa fa-refresh fa-spin"></i>');
			var details = get_details();
		
			//var data = jQuery(".rockthemes_to_import_data").val();
			var demo_details = jQuery("#demo_selector .image-select-elem.selected").length ? jQuery("#demo_selector .image-select-elem.selected").data() : jQuery("#demo_selector .image-select-elem").first().data();
			
			jQuery.post(ajaxurl, {action:"rockthemes_to_import_all_predefined_datas", details:details, demo_details:demo_details}, function(data){
				button.html(old_button_text);
			});
		});
		
		
		function get_details(){
			//Import Modules Select Elements
			var elements = ['curvy_slider', 'rock_form_builder', 'rock_page_builder', 'rock_theme_options', 'rock_sidebar', 'wordpress_details'];
			var selected_modules = new Object();
			for(var i = 0; i < elements.length; i++){
				if(jQuery('.module_'+elements[i]).length && jQuery('.module_'+elements[i]).is(":checked")){
					selected_modules[elements[i]] = 'yes';	
				}
			}
			
			var datas = new Object();
			datas.modules = selected_modules;
			
			return datas;
		}
		
		//Select with Image Element
		jQuery(".image-select-list").each(function(){
			jQuery(this).find(".image-select-elem").on("click",function(){
				jQuery(this).parent().find(".selected").removeClass("selected");
				jQuery(this).addClass("selected");
			});
		});

		
	});
</script>
<?php
}


function rockthemes_to_import_all_datas($data, $details = array()){
	
	
	//Remove any additional line breaks. Some PHP versions adds line breaks during json_encode / json_decode	
	$data = preg_replace( "/\r|\n/", "", $data);
		
	$array_data = json_decode($data, true);
	
	if(!is_array($array_data)){
		//echo 'its not an array';
		$array_data = json_decode(stripslashes($data), true);	
	}
	
	if(!is_array($details)){
		$temp_details = json_decode($details, true);
		if(is_array($temp_details)){
			$details = $temp_details;	
		}
	}
	
	if(rockthemes_woocommerce_active()){
		//WooCommerce Image Sizes
		rockthemes_to_woocommerce_image_sizes();
	}

	$modules = '';
	$unprocessed_modules = array();
	foreach($array_data as $module){
		if(!is_array($module)) $module = stripslashes($module);
		if(!is_array($module) || !$module['data']) continue;

		switch($module['module']){
			case 'rock_form_builder':
			if(function_exists('rockthemes_fb_import') && isset($details['modules']['rock_form_builder']) && $details['modules']['rock_form_builder'] === 'yes'){
				if(is_string($module['data'])){
					rockthemes_fb_import(addslashes(str_replace('&quot;', '"', $module['data'])));
				}else{
					rockthemes_fb_import($module['data']);
				}
			}
			break;
			
			case 'curvy_slider':
			if(function_exists('curvy_slider_import') && isset($details['modules']['curvy_slider']) && $details['modules']['curvy_slider'] === 'yes'){
				if(isset($details['modules']) && isset($details['curvy_slider']['fetch_images'])){
					//This will fetch images from Curvy Slider's image folder and upload them to the Wordpress media.
					curvy_slider_import_predefined_data(addslashes(str_replace('&quot;', '"', $module['data'])));
				}else{
					curvy_slider_import(addslashes(str_replace('&quot;', '"', $module['data'])));
				}
			}
			break;
			
			case 'rock_page_builder':
			if(isset($details['modules']['rock_page_builder']) && $details['modules']['rock_page_builder'] === 'yes'){
				rockthemes_pb_import($module['data']);
			}
			break;
			
			case 'rock_theme_options':
			if(isset($details['modules']['rock_theme_options']) && $details['modules']['rock_theme_options'] === 'yes'){
				if(isset($details['modules']) && isset($details['rock_theme_options']['use_demo_images'])){
					rockthemes_to_import_to_demo_datas($module['data']);
				}else{
					rockthemes_to_import_to_datas($module['data']);
				}
			}
			break;
			
			case 'rock_sidebar':
			if(isset($details['modules']['rock_sidebar']) && $details['modules']['rock_sidebar'] === 'yes'){
				rockthemes_sidebar_import_data($module['data']);
			}
			break;
			
			case 'wordpress_details':
			if(isset($details['modules']['wordpress_details']) && $details['modules']['wordpress_details'] === 'yes'){
				//wd = Wordpress Details
				rockthemes_to_wd_import($module['data']);
			}
			break;
			
		}
	}

	return $modules;
}

function rockthemes_to_import_all_datas_ajax(){
	if(!is_admin()) die;
	if(!isset($_REQUEST['data'])) die;
	if(!isset($_REQUEST['details'])) die;

	echo rockthemes_to_import_all_datas($_REQUEST['data'], $_REQUEST['details']);
	exit;	
}

add_action('wp_ajax_rockthemes_to_import_all_datas', 'rockthemes_to_import_all_datas_ajax');


function rockthemes_to_import_all_predefined_datas_func($details = array()){

	$filename = OPTIONS_DIR.'rockthemes-to-predefined-import-data.txt';
	
	//var_dump($GLOBALS['xroc_demo_details']);
	if(isset($GLOBALS['xroc_demo_details'])){
		$filename = OPTIONS_DIR.'demos/'.$GLOBALS['xroc_demo_details']['dir_name'].'/'.$GLOBALS['xroc_demo_details']['xr_filename'];
	}
	
    WP_Filesystem();

    global $wp_filesystem;

    $data = $wp_filesystem->get_contents( $filename );

	
	/*
	$handle = fopen($filename, "r");
	$rockthemes_to_predefined_data = fread($handle, filesize($filename));
	fclose($handle);
	
	$data = $rockthemes_to_predefined_data;
	*/
	
	
	$data = mb_convert_encoding($data, "UTF-8", "Windows-1252");	
	echo rockthemes_to_import_all_datas(($data), $details);
}
function rockthemes_to_import_all_predefined_datas_ajax(){
	if(!is_admin()) die;
	if(!isset($_REQUEST['details'])) die;
	if(isset($_REQUEST['demo_details'])){
		$GLOBALS['xroc_demo_details'] = isset($_REQUEST['demo_details']) ? $_REQUEST['demo_details'] : array(); 
	}
	
	rockthemes_to_import_all_predefined_datas_func($_REQUEST['details']);
	exit;
}
add_action('wp_ajax_rockthemes_to_import_all_predefined_datas', 'rockthemes_to_import_all_predefined_datas_ajax');


/*
**	Load Theme Options datas
**
**	@param	:	$data
**	@echo	:	Echo 'success' on successful load
**
**	@since 	:	1.0
*/
function rockthemes_to_import_to_datas($data){

	if(!isset($data)) return;
	

	if(!is_array($data)){
		$data_decoded = json_decode(($data), true);
		if(!is_array($data_decoded)){
			$data_decoded = json_decode(stripslashes($data), true);
		}
		$data = $data_decoded;
	}
	
	$old_url = $data['site_url'];
	$new_url = home_url();
	
	
	if(isset($data['media_url']) && isset($data['media_url']['baseurl']) && $data['media_url']['baseurl'] !== ''){
		$omu = $data['media_url']['baseurl'];	
	}
	
	if(isset($omu) && $omu && $omu !== ''){
		$old_url = $omu;
		$nmu = wp_upload_dir();
		$new_url = $nmu['baseurl'];
	}
	
	$old_site_url_slashed = str_replace('/', '\\/', $old_url);
	$current_site_url_slashed = str_replace('/', '\\/', $new_url);
	
	$data = str_replace($old_url, $new_url, json_encode($data['datas']));
	$data = str_replace($old_site_url_slashed, $current_site_url_slashed, $data);
	
	$data = json_decode($data, true);
	
	if(update_option('xr_main_settings', $data)){
		echo 'success';	
	}
	
}


function rockthemes_to_filePath($filePath)
{
	$fileParts = pathinfo($filePath);
	
	if(!isset($fileParts['filename']))
	{$fileParts['filename'] = substr($fileParts['basename'], 0, strrpos($fileParts['basename'], '.'));}
	  
	return $fileParts;
}


/*
**	Load Theme Options datas by using images in theme for Theme Options
**
**	@param	:	$data
**	@echo	:	Echo 'success' on successful load
**
**	@since 	:	1.0
*/
function rockthemes_to_import_to_demo_datas($data){

	if(!isset($data)) return;
	

	if(!is_array($data)){
		$data_decoded = json_decode(($data), true);
		if(!is_array($data_decoded)){
			$data_decoded = json_decode(stripslashes($data), true);
		}
		$data = $data_decoded;
	}
		
	
	$demo_images_url = F_WAY.'/images/demo/';
		
	$rockthemes_to_options = $data['datas'];

	$demo_image_new_url = '';
	for($r = 0; $r < count($rockthemes_to_options); $r++){
		for($el = 0; $el< count($rockthemes_to_options[$r]['elements']); $el++){
			if($rockthemes_to_options[$r]['elements'][$el]['type'] == 'image'){
				if($rockthemes_to_options[$r]['elements'][$el]['id'] == 'demo_image_url'){
					$file_name = rockthemes_to_filePath($rockthemes_to_options[$r]['elements'][$el]['default']);
					$file_name = $file_name['basename'];
					$file_name = $demo_images_url.$file_name;
					$demo_image_new_url = $file_name;
				}
			}
		}
	}

	
	$image_upload_url = '';
	if($demo_image_new_url !== '' && function_exists('curvy_demo_upload_images')){
		$image_upload_url = rockthemes_to_upload_images($demo_image_new_url);
		if(!$image_upload_url){
			$image_upload_url = $demo_image_new_url;	
		}
	}	

		
	for($r = 0; $r < count($rockthemes_to_options); $r++){
		
		for($el = 0; $el< count($rockthemes_to_options[$r]['elements']); $el++){

			if($rockthemes_to_options[$r]['elements'][$el]['type'] == 'image' &&
				$rockthemes_to_options[$r]['elements'][$el]['default'] != ''){
				
				$file_name = rockthemes_to_filePath($rockthemes_to_options[$r]['elements'][$el]['default']);
				
				$file_name = $file_name['basename'];
				
				$file_name = $demo_images_url.$file_name;
				
				if(isset($rockthemes_to_options[$r]['elements'][$el]['demo_default']) &&
				$rockthemes_to_options[$r]['elements'][$el]['demo_default'] === 'true'){
					/*
					**	This is default demo image. It's inside the theme directory.
					*/
					$rockthemes_to_options[$r]['elements'][$el]['default'] = $image_upload_url;
				}else{
					$rockthemes_to_options[$r]['elements'][$el]['default'] = $file_name;
				}
			}
			
			if($rockthemes_to_options[$r]['elements'][$el]['id'] === 'enable_demo_image'){
				$rockthemes_to_options[$r]['elements'][$el]['default'] = 'YES';	
			}
			
		}
		
	}
	
	
	update_option('xr_main_settings', ($rockthemes_to_options));
	
	
	
	$the_query = new WP_Query(array('post_type'=>'any', 'posts_per_page'=>9999, 'max_num_pages'=>9999));
	
	//$the_regex = "/src='(?:[^'\/]*\/)*([^']+)'/";
	$the_regex = '/src="(?:[^"\/]*\/)*([^"]+)"/';
	$the_regex_slash = '/src=\\\"(?:[^"\/]*\/)*([^"]+)\\\"/';
	
	$image_upload_url = 'src="'.addslashes($image_upload_url).'"';
	$image_upload_url_slash = ''.addslashes($image_upload_url).'';
	
	if ( $the_query->have_posts() ) {
		while ( $the_query->have_posts() ) {
			$the_query->the_post();

			$rpb_content = get_post_meta($the_query->post->ID, '_this_r_content',true);
			if($rpb_content && $rpb_content != ''){
				
				$rpb_content = preg_replace( "/\r|\n/", "", $rpb_content);
								
				$fake_content = (json_decode($rpb_content, true));
					
				if(!is_array($fake_content)){
					$rpb_content = json_decode(stripslashes($rpb_content), true);
				}else{
					$rpb_content = $fake_content;	
				}
				
				$rpb_content = json_encode($rpb_content);
				
				//$rpb_content = maybe_unserialize($rpb_content);
				$rpb_content = preg_replace($the_regex, $image_upload_url, $rpb_content);
				$rpb_content = preg_replace($the_regex_slash, $image_upload_url_slash, $rpb_content);
								
				$rpb_content = addslashes($rpb_content);
				
				update_post_meta($the_query->post->ID, '_this_r_content', $rpb_content);
			}

			$content = $the_query->post->post_content;
			if($content && $content != ''){
				$content = preg_replace($the_regex, $image_upload_url, $content);	
				//wp_update_post($the_query->post);
				wp_update_post(array('ID'=>$the_query->post->ID, 'post_content'=>$content));	

			}
		}
	}


	
}




function rockthemes_to_upload_images($file_url){
	if(!function_exists('curvy_demo_upload_images')) return;
		
	$file_url = curvy_demo_upload_images($file_url);
	
	return $file_url;
	
}





/*
**	Load Custom Sidebars
**
**	@param	:	$data
**	@echo	:	Echo 'success' on successful load
**
**	@since	:	1.3
*/
function rockthemes_to_import_sidebar_datas($data){
	if(!isset($data)) return;
	

	if(!is_array($data)){
		$data_decoded = json_decode(($data), true);
		if(!is_array($data_decoded)){
			$data_decoded = json_decode(stripslashes($data), true);
		}
		$data = $data_decoded;
	}
	
	$old_url = $data['site_url'];
	$new_url = home_url();
	
	if(isset($omu) && $omu && $omu !== ''){
		$old_url = $omu;
		$nmu = wp_upload_dir();
		$new_url = $nmu['baseurl'];
	}
	
	$old_site_url_slashed = str_replace('/', '\\/', $old_url);
	$current_site_url_slashed = str_replace('/', '\\/', $new_url);
	
	$data = str_replace($old_url, $new_url, json_encode($data['datas']));
	$data = str_replace($old_site_url_slashed, $current_site_url_slashed, $data);
	
	$data = json_decode($data, true);
	
	if(update_option('xr_main_settings', $data)){
		echo 'success';	
	}
	
}









############################
#### Wordpress Details #####
############################

/*
**	Wordpress Details Export
**
*/
function rockthemes_to_wd_export(){
	$return = array();
	$return['widgets'] = rockthemes_to_wd_widgets_export();
	
	return $return;
}

/*
**	Wordpress Details Import
**
*/
function rockthemes_to_wd_import($data = array()){
	if(empty($data)) return;
	
	
	//Import Widgets
	if(isset($data['widgets']) && !empty($data['widgets'])){
		rockthemes_to_wd_widgets_import($data['widgets']);	
	}
	
}

/*
**	WooCommerce Image Sizes
**
**	Set default WooCommerce image sizes
*/
function rockthemes_to_woocommerce_image_sizes(){
  	$catalog = array(
		'width' 	=> '570',	// px
		'height'	=> '640',	// px
		'crop'		=> 1 		// true
	);

	$single = array(
		'width' 	=> '570',	// px
		'height'	=> '640',	// px
		'crop'		=> 1 		// true
	);

	$thumbnail = array(
		'width' 	=> '150',	// px
		'height'	=> '150',	// px
		'crop'		=> 1 		// true
	);

	// Image sizes
	update_option( 'shop_catalog_image_size', $catalog ); 		// Product category thumbs
	update_option( 'shop_single_image_size', $single ); 		// Single product image
	update_option( 'shop_thumbnail_image_size', $thumbnail ); 	// Image gallery thumbs	
}




/*
**	Export All Widget Datas
**
**	This function will get the raw data of all of the widget datas.
**
**	@since	:	1.3
*/
function rockthemes_to_wd_widgets_export(){
	global $wp_registered_sidebars, $wp_registered_widgets;
	
	// Holds the final data to return
	$return = array();
	
	// A nested array in the format $sidebar_id => array( 'widget_id-1', 'widget_id-2' ... );
	$sidebars_widgets = wp_get_sidebars_widgets();
	
	// Loop over all of the registered sidebars looking for the one with the same name as $sidebar_name
	$sibebar_id = false;
	foreach( $wp_registered_sidebars as $sidebar ) {
			
		// We now have the Sidebar ID, we can stop our loop and continue.
		$sidebar_id = $sidebar['id'];
		
		if(!isset($sidebars_widgets[$sidebar_id])) continue;
		
		$widget_ids = $sidebars_widgets[$sidebar_id];
		
		//var_dump($widget_ids);
		
		if( !$widget_ids ) {
			// Without proper widget_ids we can't continue. 
			continue;
		}

		// Loop over each widget_id so we can fetch the data out of the wp_options table.
		foreach( $widget_ids as $id ) {
			
			//For some reason new server does not contain the widget. Skip it. (Mostly because of missing plugins or version conflict)
			if(!isset($wp_registered_widgets[$id])) continue;
			
			// The name of the option in the database is the name of the widget class.  
			$option_name = $wp_registered_widgets[$id]['callback'][0]->option_name;
			
			// Widget data is stored as an associative array. To get the right data we need to get the right key which is stored in $wp_registered_widgets
			$key = $wp_registered_widgets[$id]['params'][0]['number'];
			
			//var_dump($option_name);
			
			$widget_data = get_option($option_name);
			
			//var_dump($widget_data);
			
			// Add the widget data on to the end of the return array.
			$return[$sidebar_id][$option_name] = (object) $widget_data[$key];
		}

	}
	
	return $return;
}
/*
**	Import All Widtet Datas
**
**	This function will import all of the widget details and add widgets to their sidebars
**
**	@since	:	1.3
*/
function rockthemes_to_wd_widgets_import($data = array()){
	global $wp_registered_sidebars, $wp_registered_widgets;
	
	if(empty($data)) return;
	
	//var_dump($data);
	//return;
	

	foreach($data as $s_key => $s_val){
		$add_to_sidebar = $s_key;
		$sidebar_options[$add_to_sidebar] = array();

		foreach($s_val as $w_key => $w_val){
			$widget_name = str_replace('widget_', '', $w_key);
			$homepagewidget = delete_option('widget_'.$widget_name);
		}
	}
	
	$wp_registered_widgets = array();
	
	//WPML String Translation Plugin tries to update changes when saving Text Widget. Remove that action.
	remove_action('update_option_widget_text', 'icl_st_update_text_widgets_actions',99);
	
	//var_dump($data);
	//return;
	
	$count = 0;
	foreach($data as $s_key => $s_val){
		$add_to_sidebar = $s_key;
		/*
		$sidebar_options = get_option('sidebars_widgets');
		if(!isset($sidebar_options[$add_to_sidebar])){
			$sidebar_options[$add_to_sidebar] = array('_multiwidget'=>1);
		}
		*/
		$sidebar_options[$add_to_sidebar] = array();

		foreach($s_val as $w_key => $w_val){
			
			$widget_name = str_replace('widget_', '', $w_key);
			
			$homepagewidget = get_option('widget_'.$widget_name);
			
			if(!is_array($homepagewidget)) $homepagewidget = array();
			$count = count($homepagewidget)+1;
			
			// add first widget to sidebar:
			$sidebar_options[$add_to_sidebar][] = $widget_name.'-'.$count;
			$homepagewidget[$count] = $w_val;
			$count++;
						

			update_option('widget_'.$widget_name, $homepagewidget);
		}
		
		update_option('sidebars_widgets',$sidebar_options);
		
	}
	
}





?>