<?php
/*
Rock Options
*/

//Animation Builder Included
define('ANIMATION_BUILDER',true);
define('CURVY_STANDALONE',false);

define('OPTIONS_DIR', get_template_directory().'/rock-options/');
define('OPTIONS_URI', get_template_directory_uri().'/rock-options/');



function rockthemes_after_setup(){
	global $pagenow;	

	/*
	**	TO DO	:	Improve this activation for child theme.
	**	TO DO	:	Check if $pagenow value causes any conflict if so, use strpos() function
	**
	*/

	if(isset($_GET['activated']) && $pagenow === 'themes.php'){
		/*
		**	Wordpress Default Image Size Hook to Match image size in demo
		*/
		update_option('thumbnail_size_w', 200);
		update_option('thumbnail_size_h', 150);
		update_option('thumbnail_crop', 0);
		
		update_option('medium_size_w', 540);
		update_option('medium_size_h', 405);
		update_option('medium_crop', 0);
		
		update_option('large_size_w', 960);
		update_option('large_size_h', 720);
		update_option('large_crop', 0);
		
		//Reset All Instalaltion Helper Values
		//do_action('rockthemes_ih_reset_all'); Update options directly instead of calling the action
		update_option('rockthemes_ih_dismiss', 'no');
		update_option('rockthemes_ih_last_step', 0);

		
		wp_redirect(admin_url('themes.php?page=rock_options'));	
	}
}

add_action('after_setup_theme','rockthemes_after_setup');

function xr_ds_archive_layout_selection(){
	global $rpb_post_types;
	if(empty($rpb_post_types)){
		$rpb_post_types = function_exists('rpb_get_post_types') ? rpb_get_post_types() : array();	
	}
	
	$return = array();
	
	
	foreach($rpb_post_types as $type){
		if($type === 'page') continue;
		$return[] = array(
			'label'			=> 'Archive Layout Page for '.$type.'',
			'id'			=> $type.'_archive_layout',
			'type'			=> 'page_list',
			'is_hidden'		=> 'false',
			'is_translate'	=> 'false',
			'description'	=> 'Choose your page for '.$type.' archive layout',
			'choices'		=> '',
			'default'		=> ''
		);

	}
		
	return ($return);
}

//Load the settings
function xr_load_default_settings(){
	global $rockthemes_to_options, $rockthemes_to_default_options, $translation_options;
	$rockthemes_to_options = (get_option('xr_main_settings'));
		
	$translation_options = get_option('xr_main_settins_translate',array());
	
	//This is required for save function. Save function uses default data for details.
	include_once(OPTIONS_DIR.'default_settings.php');
		
	//First time load
	if(empty($rockthemes_to_options)) {
		$rockthemes_to_options = $rockthemes_to_default_options;
	}
	
}

xr_load_default_settings();


if(!function_exists('xr_get_option')){
	function xr_get_option($search,$default = ''){
		global $rockthemes_to_options, $translation_options;

		foreach($rockthemes_to_options as $option){
			
			foreach($option['elements'] as $element){

				if($element['id'] == $search){
					
					if(isset($element['is_hidden']) && $element['is_hidden'] === 'true'){
						if(isset($element['hidden_val'])){
							if($element['type'] == 'checkbox'){
								if($element['hidden_val'] == 'YES'){
									return true;	
								}
								return false;
							}
							return $element['hidden_val'];
						}else{
							return '';	
						}
					}
					
					if(!isset($element['is_translate']) || $element['is_translate'] !== 'true' || empty($translation_options)){
						$element_value = xr_return_element_value($element);
						if(is_bool($element_value)){
							return $element_value;
						}elseif(!is_array($element_value)){
							return stripslashes(($element_value));
						}else{
							return $element_value;	
						}
					}else{
						foreach($translation_options as $key => $value){
							if($search === $key){
								return stripslashes($value);	
							}
						}
					}
					
				}
				
			}
			
		}
		
		return $default;
	}
}

/* 
** This function will find the element type and return it's value
*/
if(!function_exists('xr_return_element_value')){
	function xr_return_element_value($elem){
		if(!isset($elem['default'])) return '';
		
		//Text Field
		if($elem['type'] == 'text_field'){
			return $elem['default'];
		}
		
		//Colorpicker
		if($elem['type'] == 'colorpicker'){
			return $elem['default'];	
		}
		
		//Colorpicker
		if($elem['type'] == 'select'){
			return $elem['default'];	
		}
		
		//Social Icons Modal
		if($elem['type'] == 'socialicons'){
			return addslashes($elem['default']);	
		}
		
		//Checkbox
		if($elem['type'] == 'checkbox'){
			if($elem['default'] == 'YES'){
				return true;	
			}
			return false;
		}
				
		//Font Option Field
		if($elem['type'] == 'font_option_field'){
			return $elem['default'];	
			
			/*
			OPTIONAL : Directly Return with the ready class
			$return_class = '';
			if(isset($elem['default']['font_family']) && $elem['default']['font_family'] !== ''){
				$return_class .= 'font-family: '.$elem['default']['font_family'];	
			}
			
			if(isset($elem['default']['font_size']) && $elem['default']['font_size'] !== ''){
				$return_class .= 'font-size: '.$elem['default']['font_size'];	
			}
			
			return $return_class;
			*/
		}
		
		return $elem['default'];
			
	}
}

if(!function_exists('xr_options_load')):
function xr_options_load(){
	//Only load settings page if the user is admin
	global $pagenow;

	if(current_user_can('edit_theme_options')){
		if($pagenow == 'themes.php' && isset($_GET['page']) && strpos($_GET['page'],'rock_options') > -1){

			//load wordpress's new colorpicker
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script('wp-color-picker');
	
			wp_enqueue_media();
			
			//Check if debug mode is on
			
			wp_enqueue_style('xr_options_style',  OPTIONS_URI.'css/rock_style.css', '','', 'all');
			wp_enqueue_script('xr_jquery', OPTIONS_URI.'js/rock_jquery.js', array('jquery'));
			
			//FontAwesome 
			wp_enqueue_style('font-awesome-css',  OPTIONS_URI.'css/font-awesome.min.css', '','', 'all');
			
	
			include_once(OPTIONS_DIR.'elements.php');
			include_once(OPTIONS_DIR.'options_ui.php');
		}
	}
	
	//Register Rock Options
	include_once(OPTIONS_DIR.'register.php');
}
add_action('init','xr_options_load');

endif;



/*
**	Typekit Code
**
*/
if(!function_exists('xr_typekit_header_code')):
function xr_typekit_header_code(){
	$typekit_code = xr_get_option('typekit_font_code', '');
	
	if($typekit_code !== ''){
		echo wp_kses_post($typekit_code);	
	}
}
if(xr_get_option('typekit_font_code', '') !== ''){
	add_action('wp_head', 'xr_typekit_header_code');	
}
endif;


if ( (defined( 'WP_ADMIN' ) && WP_ADMIN ) ||  ( defined( 'DOING_AJAX' ) && DOING_AJAX )){
	include_once(OPTIONS_DIR.'rockthemes-to-import-export.php');
}




if(!function_exists('xr_save_settings')){
	function xr_save_settings(){
		if(!is_admin()) die('update_error : user not able to');
		
		if(!isset($_REQUEST['_ajax_nonce']) ||
			empty($_REQUEST['_ajax_nonce']) || 
			!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rto_save') ||
			!check_ajax_referer('rto_save')) {
		
			//Die
			die('update_error : Security Error');		
		}
		
		$current_options = json_decode(stripslashes($_REQUEST['settings_data']), true);
		$kses_tags = array(
			'a' => array(
				'href' => array(),
				'title' => array()
			),
			'br' => array(),
			'em' => array(),
			'strong' => array(),
			'img'=>array(),
			'i'	=>	array(
				'class' => true
			),
		);
		
		$kses_translate_elems = array();
		
		for($i = 0; $i < count($current_options); $i++){
			for($j = 0; $j<count($current_options[$i]['elements']); $j++){
				if(isset($current_options[$i]['elements'][$j]['is_validate']) && $current_options[$i]['elements'][$j]['is_validate'] !== ''){
			
					switch($current_options[$i]['elements'][$j]['is_validate']){
						case 'wp_kses_post':
						if($current_options[$i]['elements'][$j]['type'] === 'font_option_field'){
							$current_options[$i]['elements'][$j]['default']['font_family'] = wp_kses_post($current_options[$i]['elements'][$j]['default']['font_family']);
							$current_options[$i]['elements'][$j]['default']['font_size'] = wp_kses_post($current_options[$i]['elements'][$j]['default']['font_size']);
						}else{
							$current_options[$i]['elements'][$j]['default'] = wp_kses_post($current_options[$i]['elements'][$j]['default']);
						}
						if($current_options[$i]['elements'][$j]['id'] === 'extra_css_code'){
							//wp_kses_post escapes > symbol.
							$current_options[$i]['elements'][$j]['default'] = str_replace('&gt;','>', $current_options[$i]['elements'][$j]['default']);
						}
						break;
						case 'wp_kses':
						if($current_options[$i]['elements'][$j]['type'] === 'font_option_field'){
							$current_options[$i]['elements'][$j]['default']['font_family'] = wp_kses($current_options[$i]['elements'][$j]['default']['font_family'], $kses_tags);
							$current_options[$i]['elements'][$j]['default']['font_size'] = wp_kses($current_options[$i]['elements'][$j]['default']['font_size'], $kses_tags);
						}else{
							$current_options[$i]['elements'][$j]['default'] = wp_kses($current_options[$i]['elements'][$j]['default'], $kses_tags);
						}
						break;
						
						default:
						if($current_options[$i]['elements'][$j]['type'] === 'font_option_field'){
							$current_options[$i]['elements'][$j]['default']['font_family'] = wp_kses($current_options[$i]['elements'][$j]['default']['font_family'], $kses_tags);
							$current_options[$i]['elements'][$j]['default']['font_size'] = wp_kses($current_options[$i]['elements'][$j]['default']['font_size'], $kses_tags);
						}else{
							$current_options[$i]['elements'][$j]['default'] = wp_kses($current_options[$i]['elements'][$j]['default'], $kses_tags);
						}
						break;
					}
					if(isset($current_options[$i]['elements'][$j]['is_translate']) && $current_options[$i]['elements'][$j]['is_translate'] === 'true'){
						$kses_translate_elems[$current_options[$i]['elements'][$j]['id']] = $current_options[$i]['elements'][$j]['default'];
					}

				}
			}
		}
								
		if(isset($_POST['translate_array'])){
			$translate_array = json_decode(stripslashes($_POST['translate_array']),true);
			foreach($kses_translate_elems as $kek => $kev){
				if(isset($translate_array[$kek])){
					$translate_array[$kek] = $kev;	
				}
			}
			update_option('xr_main_settins_translate', $translate_array);
		}
		
		$error = update_option('xr_main_settings', (($current_options)));
		
		
		
		echo 'saved';
		/*
		if($error){
			echo "saved";
		}else{
			echo "update_error ".$error;
		}
		*/
		exit;
	}
}
//IN USE Rockthemes Animation Builder Save Function
add_action( 'wp_ajax_xr_save_settings', 'xr_save_settings' );



function rockthemes_to_import_new_options(){
	if(!is_admin()) die();
	global $rockthemes_to_options, $rockthemes_to_default_options;
	$rockthemes_to_options = (get_option('xr_main_settings',array()));
	
	
	include_once(OPTIONS_DIR.'default_settings.php');

	
	if(!isset($rockthemes_to_default_options)) die('error');
	if(!isset($rockthemes_to_options)) die('error');
	
	$level_1 = 0;
	$level_2 = 0;
		
	
	$i = 0;
	foreach($rockthemes_to_default_options as $i_key => $default_options1){
		
		$found_level_1 = false;
		foreach($rockthemes_to_options as $option){
			if($default_options1['category_id'] === $option['category_id']){
				$found_level_1 = true;
				
				foreach($default_options1['elements'] as $t_key => $default_options2){
					$t = 0;
					foreach($option['elements'] as $opt){
						
						if($default_options2['id'] === $opt['id'] && $default_options2['type'] !== 'header'){
							$rockthemes_to_default_options[$i_key]['elements'][$t_key]['default'] = $opt['default'];
							break;	
						}
						$t++;
					}
				}
				break;
			}
		}
		
		$i++;
		
		if(!$found_level_1) continue;
		
	}
	
	
	update_option('xr_main_settings', $rockthemes_to_default_options);
	
	die('success');
	exit;
}
add_action('wp_ajax_rockthemes_to_import_new_options', 'rockthemes_to_import_new_options');


if(!function_exists('rockthemes_hex2rgba')):
function rockthemes_hex2rgba($hex, $opacity = 1) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return implode(",", $rgb).','.$opacity; // returns the rgb values separated by commas
   //return $rgb; // returns an array with the rgb values
}
endif;




//Theme options style function frontend
function xr_style_callback(){
	global $post;	
	
	$custom_style = '';
		
	
	$default_padding = esc_attr(xr_get_option('content_padding','15px'));
	$custom_style .= '.padding{padding:'.$default_padding.';}';
	$custom_style .= '.padding-2x{padding:'.(2 * rockthemes_fn_px_em_return_num($default_padding)).'px;}';
	$header_model = (int) xr_get_option('header_model', 1);
	
	//Site general color
	$site_general_color = esc_attr(xr_get_option('site_general_color','#56CCC8'));
	//Site General Color Dark
	$site_general_color_dark = esc_attr(xr_get_option('site_general_color_dark','#152840'));
	
	//Link Colors
	$a_link_color = esc_attr(xr_get_option('a_link_color','#eeeeee'));
	$a_link_hover_color = esc_attr(xr_get_option('a_link_hover_color','#ffffff'));
	
	/*Font Colors*/
	$custom_style .= 'body,html,p{color:'.esc_attr(xr_get_option('default_text_color','#101010')).';}';
	
	if(is_rtl()){
		$custom_style .= 'body,html,p, body *{direction:rtl;}';
	}	

	
	/*All link "a" tags with will contain this not attributes. These are the escape class from a color*/
	$a_not = 'a:not(.escapea):not(.button)';
	
	$ie8 = '.lt-ie9 ';
	
	/*General Details*/
	$custom_style .= $a_not.'{color:'.$a_link_color.';}';
	$custom_style .= $a_not.':hover{color:'.$a_link_hover_color.';}';
	

	
	/*Grid details*/
	/*1140px grid*/
	/*960px grid*/
	/*1060px grid*/
	
	$custom_style .= '.row{max-width:'.esc_attr(xr_get_option('main_layout_grid','')).';}';
	$custom_style .= '.lt-ie9 .row{width:'.esc_attr(xr_get_option('main_layout_grid','')).';}';
		
	/*Responsivity*/
	$disable_responsivity = xr_get_option('disable_responsivity',false);
	if($disable_responsivity === true){
		$custom_style .= 'html{overflow-x:auto;}';
		//Responsivity disabled
		$custom_style .= 'body, .main-container{min-width:'.(((2 * rockthemes_fn_px_em_return_num($default_padding)) + rockthemes_fn_px_em_return_num(xr_get_option('main_layout_grid','')))).'px; }';
		$custom_style .= '.row{width:'.esc_attr(xr_get_option('main_layout_grid','')).';}';
		$custom_style .= '
			.rockthemes-fullscreen, div[data-rsb-fullscreen="true"]{min-width:'.esc_attr(xr_get_option('main_layout_grid','')).' !important;}
		';
	}else{
		//Responsive Design
		
	}
	
	//Dark Special Grids font color - Will not affect all font colors.
	$custom_style .= '
		.unique-grid-light-fonts, .unique-grid-light-fonts p,
		.unique-grid-light-fonts h1, .unique-grid-light-fonts h2,
		.unique-grid-light-fonts h3, .unique-grid-light-fonts h4,
		.unique-grid-light-fonts h5, .unique-grid-light-fonts h6,
		.unique-grid-light-fonts .rock-iconictext-header-title *,
		.unique-grid-light-fonts .azoom-steps li .step-details *{
			color:'.esc_attr(xr_get_option('rsg_light_font_color', '#f0f0f0')).';	
		}
	';
	
	//Rockthemes Mega Menu Light Font Colors
	$custom_style .= '
		#nav ul.rtm-menu .rtm-menu-light-fonts ul a, #nav .rtm-menu .rtm-menu-light-fonts ul ul a
		.rtm-menu .rtm-menu-light-fonts a,
		.rtm-menu .rtm-menu-light-fonts .widget-title{
			color:'.esc_attr(xr_get_option('rsg_light_font_color', '#f0f0f0')).';	
		}
	';
	
	
	//Font loading system
	if(xr_get_option('font_loading_active', true)){
		$custom_style .= 'body{visibility:hidden;}';
	}
	
	/*General Color Settings*/
	$custom_style .= '
		.main-color, .team-member-content .team-member-i, ol.comment-list li.comment .comment-author,
		ol.comment-list li.comment .comment-author a.url,
		#wp-calendar td a,
		.woocommerce-MyAccount-navigation li.is-active a,
		.woocommerce ul.products li.product .azoom-woo-grid-buttons a:hover, 
		.woocommerce-page ul.products li.product .azoom-woo-grid-buttons a:hover,
		.woocommerce #content div.product p.price, .woocommerce #content div.product span.price, 
		.woocommerce div.product p.price, .woocommerce div.product span.price, 
		.woocommerce-page #content div.product p.price, .woocommerce-page #content div.product span.price, 
		.woocommerce-page div.product p.price, .woocommerce-page div.product span.price,
		.woo-grid-hover .azoom-hover-effect .rockthemes-woo-buttons-container a:hover, 
		.woo-grid-hover .azoom-hover-effect .rockthemes-woo-buttons-container a:hover i,
		.azoom-hover-effect li:not(.link-elem) a:hover i,
		.ajax-category-navigation li a:hover, .ajax-category-navigation li a.active{
			color:'.$site_general_color.';	
		}
		
		#wp-calendar caption, .rockthemes-divider .divider-symbol, .rockthemes-divider .divider-symbol-left,
		.azoom-pagination .page-numbers.current:not(.dots), .azoom-link_pages > span.page-numbers:not(.dots), 
		.azoom-style-dot{
			background-color:'.$site_general_color.';	
			border-color:'.$site_general_color.';
		}
		
		.azoom-pt-featured,.widget_search .searchform #searchsubmit, 
		.azoom-heading-icon,
		.search-results-empty-content #searchform #searchsubmit, .widget_product_search #searchform #searchsubmit,
		.widget_display_forums li:hover:before, .bbp_widget_login li:hover:before, 
		.widget_display_replies li:hover:before, .widget_display_topics li:hover:before,
		.widget_display_stats dd:hover:before, .widget_display_views li:hover:before,
		.widget_archive li:hover:before, .widget_categories li:hover:before, .widget_meta li:hover:before, 
		.widget_pages li:hover:before, .widget_recent_comments li:hover:before, 
		.widget_recent_entries li:hover:before, .widget_nav_menu li:hover:before, 
		.woocommerce.widget_products li:hover:before, 
		.woocommerce.widget_product_categories .product-categories li:hover:before, 
		.woocommerce.widget_recently_viewed_products .product_list_widget li:hover:before, 
		.woocommerce.widget_layered_nav li:hover:before, .woocommerce.widget_recent_reviews li:hover:before, 
		.sidebar-area .woocommerce.widget_shopping_cart li:hover:before, 
		.woocommerce.widget_top_rated_products li:hover:before,
		.woocommerce span.onsale, .woocommerce-page span.onsale, .woocommerce .boxed-layout.boxed-colors span.onsale,
		.woocommerce-page .boxed-layout.boxed-colors span.onsale, .overlay-date-area,
		.woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price,
		.azoom-woocommerce-cart-wrapper span.amount, .azoom-woocommerce-cart-wrapper span.amount,
		.shop_table thead th, #order_review .button, .shop_table .actions .checkout-button, 
		.product form.cart .button, .woocommerce-message .button, form.checkout_coupon .button, 
		.woocommerce form.login .button, .woocommerce-page form.login .button, .bbp-login-form .button,
		.product_meta > span, .entry-meta-single, .badge-top-left, .comment-list .reply a, #cancel-comment-reply-link{
			background-color:'.$site_general_color.';	
		}
		
		/*Hover Colors of WooCommerce*/
		.woocommerce-MyAccount-navigation li:hover:before,
		.woocommerce-MyAccount-navigation li.is-active:before,
		#order_review .button:hover, .shop_table .actions .checkout-button:hover, 
		.product form.cart .button:hover, .woocommerce-message .button:hover, 
		form.checkout_coupon .button:hover, .woocommerce form.login .button:hover, 
		.woocommerce-page form.login .button:hover, .bbp-login-form .button:hover{
			background-color:'.$site_general_color.';	
		}
		
		.azoom-woo-grid-buttons .rockthemes-woo-buttons-container > span.large-6:last-child,
		.azoom-woocommerce-cart-wrapper.azoom-woocommerce-box .azoom-woocommerce-box-content .cart_list li .ajax-cart-content.ajax-cart-animate-border{
			border-color:'.$site_general_color.';
		}
		
		.box-shadow-dark{
			-webkit-box-shadow:inset 0 0 2px '.$site_general_color.';
			-moz-box-shadow:inset  0 0 2px '.$site_general_color.';
			box-shadow:inset 0 0 2px '.$site_general_color.';
			border-color:'.$site_general_color.';
		}
		
		.rockthemes-before-after-slider .twentytwenty-handle .twentytwenty-left-arrow{
			border-right-color:'.$site_general_color.';
		}
		
		.rockthemes-before-after-slider .twentytwenty-handle .twentytwenty-right-arrow{
			border-left-color:'.$site_general_color.';
		}
		
	';
	
	if(!xr_get_option('disable_responsivity',false)){
		$custom_style .= '
		@media only screen and (max-width: 540px){
			.mobile-menu-background{
				background:'.$site_general_color.';	
			}
		}
		
		@media only screen and (max-width:1023px){
			.mobile-menu-switcher{
				background:'.$site_general_color.';	
			}
		}
		
		.menu_use_mobile_for_main .mobile-menu-switcher{
			background:'.$site_general_color.';	
		}

		
		';
	}
	
	/*General Color Dark Settings*/
	$custom_style .= '
		.date-area-container{
			background:'.$site_general_color_dark.';
		}
	';
	
	/*Site Medium Color*/
	$site_main_color_medium = esc_attr(xr_get_option('site_main_color_medium','#c5cdd1'));
	$custom_style .= '
		.widget_archive li:before, .widget_categories li:before, .widget_meta li:before, 
		.widget_pages li:before, .widget_recent_comments li:before, .widget_recent_entries li:before, 
		.widget_nav_menu li:before, .woocommerce.widget_products li:before, 
		.woocommerce.widget_product_categories .product-categories li:before, 
		.woocommerce.widget_recently_viewed_products .product_list_widget li:before, 
		.woocommerce.widget_layered_nav li:before, .woocommerce.widget_recent_reviews li:before, 
		.sidebar-area .woocommerce.widget_shopping_cart li:before, .woocommerce.widget_top_rated_products li:before{
			background:'.$site_main_color_medium.';	
		}
	';
	
	
	
	
	/*HR Color*/
	$custom_style .= '
		hr{
			border-color:'.esc_attr(xr_get_option('hr_color','#c5cdd1')).';	
		}
	';
	
	
	/*Typography Details*/
	$site_default_font_details = xr_get_option('site_default_font_details', array());
	if(!empty($site_default_font_details)){
		$custom_style .= '
			body, .button, .date-area, .date-area *, .comment-list .reply a, #cancel-comment-reply-link,
			p, a, .header-small-contact, .more-link, .rock-skill text tspan, textarea.wp-editor-area{
				'.$site_default_font_details['font_family'].'
			}
			
			.azoom-breadcrumbs *, table, table tr th, table tr td, input[type="submit"]
			.rock-tabs-container .rock-tabs-header-container .rock-tab-header,
			ul,ol,dl, address, label, input, input:not([type="submit"]), select, button, textarea, .wp-editor-area,
			textarea.wp-editor-area,
			.azoom-pagination .page-numbers, input[type="submit"]:not(.button), .comments-submit, #comments-submit,
			p, .header-small-contact, .rock-toggle-header,
			.rock-tabs-container .rock-tabs-header-container .rock-tab-header{
				font-size:'.esc_attr($site_default_font_details['font_size']).';	
			}
		';	
	}
	
	$site_heading_font = xr_get_option('site_heading_font_family', '');
	if($site_heading_font){
		$custom_style .= '
		h1, h2, h3, h4, h5, h6, .title-container, .title-container a, .page-title, 
		.sidebar-area caption, .azoom-portfolio-main-title, .team-member-content .member-b,
		.ajax-filtered-gallery-holder .ajax-navigation strong, .searchform label,
		.azoom-breadcrumbs li a, .azoom-breadcrumbs li,
		.rock-iconictext-container .rock-iconictext-header-title,
		.rock-iconictext-container .rock-iconictext-header-title strong,
		.azoom-element-responsive-title{
			'.$site_heading_font.'
		}
		';	
	}
	
	$menu_font_family = xr_get_option('menu_font_family', '');
	if($menu_font_family){
		$custom_style .= '
		#nav, #nav a, #nav ul li{
			'.$menu_font_family.'
		}';
		
		$custom_style .= '
		#nav .rtm-menu li a{
			font-size:'.esc_attr(xr_get_option('main_nav_font_size','14px')).';
		}
		
		#nav ul.rtm-menu > li > a, #nav .rtm-menu > ul > li > a{
			font-weight:'.esc_attr(xr_get_option('main_nav_font_weight','inherit')).';	
		}
		
		#nav ul.rtm-menu > li li a, #nav .rtm-menu > ul > li li a{
			font-weight:'.esc_attr(xr_get_option('main_nav_sub_font_weight','inherit')).';	
		}
		
		#nav .rtm-menu ul li a{
			font-size:'.esc_attr(xr_get_option('main_nav_sub_font_size', '13px')).';	
		}
		';
	}
	/*End of Typography*/
	
	
	
	if( xr_get_option('use_boxed_layout',false)){
		$custom_style .= '#main-canvas{width:100%;}';
		if(strpos(xr_get_option('main_layout_grid',''), 'px') !== false){
			$custom_style .= '#main-canvas{max-width:'.(((2 * rockthemes_fn_px_em_return_num($default_padding)) + rockthemes_fn_px_em_return_num(xr_get_option('main_layout_grid','')))).'px; }';
		}elseif(strpos(xr_get_option('main_layout_grid',''), '%') !== false){
			$custom_style .= '#main-canvas{max-width:'.esc_attr(xr_get_option('main_layout_grid','')).'}';
		}
	}
	
	
	/*General Colors*/
	$custom_style .= '.main-color{color:'.$site_general_color.';}';/*Real Color 00aae8*/
	$custom_style .= '.main-boxed-text-color{color:'.esc_attr(xr_get_option('boxed_layout_text_color','#101010')).';}';/*General Boxed Text Color*/
	
	/*Go To Top Button*/
	$custom_style .= '#toTop{background:'.$site_general_color.';}';
	
	//TO DO : Bind this feature
	$header_top_2_height = 45;
	
	/*Header Top Border Color*/
	$custom_style .= '
		.header-top-2, .header-top-2 .social-icon .rock-social-icon,
		.header-top-2 .social-icon .rock-social-icon:first-child,
		.header-top-2 .header-wpml-container{
			border-color:'.esc_attr(xr_get_option('header_top_border_dim_color', '#f0f0f0')).';	
		}
	';


	$rad_transparent_header = rad_get_option('transparent_header');
	if($rad_transparent_header == 'header_only'){
		$custom_style .= '.header-all-wrapper{
			background:none;
			position:absolute;
			top:'.(is_admin_bar_showing() ? '32' : '0').'px;
			left:0px;
			right:0px;
			z-index:auto;
			
			transition:none;
			-webkit-transition:none;
			-moz-transition:none;
		}
		.header-top-2, .header-all-wrapper .header-top-2 .social-icon .rock-social-icon,
		.header-top-2 .header-wpml-container{
			border:none;	
		}
		.header-top-2{
			max-height:'.$header_top_2_height.'px;
		}';
		if(xr_get_option('enable_header_top',true)){
			$custom_style .= '.header-all-wrapper.sticky-activated{top:'.(is_admin_bar_showing() ? (32 - $header_top_2_height) : -$header_top_2_height).'px;}';
		}
	}
	
	
	$header_area_margin_top = xr_get_option('header_area_margin_top', '');
	if(xr_get_option('header_location','top_navigation') === 'top_navigation' && $header_area_margin_top !== ''){
		$custom_style .= '.header-all-wrapper{margin-top:'.esc_attr($header_area_margin_top).';}';
	}

	/*Header Large Area*/
	$header_large_background_repeat = esc_attr(xr_get_option('header_large_background_repeat', ''));
	$header_large_background = esc_attr(xr_get_option('header_large_background', ''));
	if($header_large_background !== ''){
		$custom_style .= '.header-top-1{background:url("'.$header_large_background.'") '.$header_large_background_repeat.';}';
		//Sticky Header Wrapper
		$custom_style .= '.sticky-header-wrapper{background:url("'.$header_large_background.'") '.$header_large_background_repeat.';}';
	}elseif(rad_get_option('transparent_header',true) === 'all_wrapper' || rad_get_option('transparent_header',true) === 'header_only'){
		$custom_style .= '.header-top-1{background:transparent;}';
		//Sticky Header Wrapper
		$custom_style .= '.sticky-header-wrapper{background:transparent;}';
	}else{
		$custom_style .= '.header-top-1{background:'.esc_attr(xr_get_option('header_large_background_color', '')).';}';
		//Sticky Header Wrapper
		$custom_style .= '.sticky-header-wrapper{background:'.esc_attr(xr_get_option('header_large_background_color', '')).';}';
	}
	
	
	//Sticky Header
	if(is_admin_bar_showing()){
		$custom_style .= '
			.header-sticky-active{top:32px;}
			body #rockthemes_mobile_menu{top:32px;}
		';	
	}

	
	/*Header Top Area - Header Level 2*/
	$custom_style .= '.header-top-2{
		background-color:'.esc_attr(xr_get_option('header_top_background_color', '#00aae8')).';
		color:'.esc_attr(xr_get_option('header_top_font_color', '#F0F0F0')).';
	}';
	if(rad_get_option('transparent_header', false) === 'all_wrapper' || rad_get_option('transparent_header', false) === 'header_only'){
		$custom_style .= '.header-top-2{
			background:transparent;
		}';
	}
	
	$custom_style .= '.header-top-2 '.$a_not.'{color:'.esc_attr(xr_get_option('header_top_link_color', '#FAFAFA')).';}';
	$custom_style .= '.header-top-2 '.$a_not.':hover{color:'.esc_attr(xr_get_option('header_top_link_hover_color', '#DEDEDE')).';}';
	
	$custom_style .= $ie8.'body .header-top-2 div a{color:'.esc_attr(xr_get_option('header_top_link_color', '#FAFAFA')).';}';
	$custom_style .= $ie8.'.header-top-2 a:hover{color:'.esc_attr(xr_get_option('header_top_link_hover_color', '#DEDEDE')).';}';
	$custom_style .= '.ie.ie8 .header-top-2 div a{color:'.esc_attr(xr_get_option('header_top_link_color', '#FAFAFA')).' !important;}';/*IE8 Style Fix*/
	
	
	/*Logo Settings*/
	$custom_style .= '
		.logo-main-wrapper .logo-container a{
			line-height:'.esc_attr(xr_get_option('logo_regular_line_height', '90px')).'; 
		}
		.logo-main-wrapper .sticky-logo-container a{
			line-height:'.esc_attr(xr_get_option('logo_sticky_line_height', '60px')).';
		}
	';

	
	$custom_style .= '
		.logo-main-wrapper{max-height:'.esc_attr(xr_get_option('logo_regular_line_height','90px')).';}
		.header-sticky-animate .logo-main-wrapper{max-height:'.esc_attr(xr_get_option('logo_sticky_line_height','60px')).';}	
	';
	
	//$custom_style .= '.logo-main-wrapper{margin-top:'.xr_get_option('logo_margin_top', '0px').'; margin-bottom:'.xr_get_option('logo_margin_bottom', '0px').';}';
	/*Logo Animation*/
	
	$header_regular_line_height = esc_attr(xr_get_option('logo_regular_line_height','90px'));
	$custom_style .= '
		.header-sticky-animate .logo-animation-container{
			transform:translateY(-'.$header_regular_line_height.');
			-webkit-transform:translateY(-'.$header_regular_line_height.');
			-moz-transform:translateY(-'.$header_regular_line_height.');
			-ms-transform:translateY(-'.$header_regular_line_height.');
		}
		
		.main-header-area{
			/*height:'.$header_regular_line_height.';*/
		}
		
		.main-header-area.header-sticky-animate{
			/*height:'.xr_get_option('header_sticky_line_height','60px').';*/
		}
		
		.main-header-area.header-sticky-active{
			background:'.esc_attr(xr_get_option('header_large_background_color', '')).';
		}
	';
	
	if($header_model === 3 || $header_model === 4){
		$custom_style .= '
		/*
			.main-header-area{
				height:'.(rockthemes_fn_px_em_return_num(xr_get_option('header_regular_line_height','90px')) * 2).'px;
			}
			
			.main-header-area.header-sticky-animate{
				height:'.(rockthemes_fn_px_em_return_num(xr_get_option('header_sticky_line_height','60px')) * 2).'px;
			}
			*/
		';
	}
	
	
	
	/*Azoom Menu*/
	if(!xr_get_option('disable_mega_menu',false)){
		//Azoom Mega Menu used
		$custom_style .= '
			#nav .rtm-menu > li > a, 
			#nav .rtm-menu > ul > li > a{
				line-height:'.esc_attr(xr_get_option('header_regular_line_height', '90px')).';
			}
			
			
			.header-sticky-animate #nav .rtm-menu > li > a, 
			.header-sticky-animate #nav .rtm-menu > ul > li > a{
				line-height:'.esc_attr(xr_get_option('header_sticky_line_height', '60px')).';
			}
			
			
			#nav ul.rtm-menu a, #nav .rtm-menu ul a{
				color:'.esc_attr(xr_get_option('menu_level1_font_color','#787878')).';
			}
			
			#nav ul.rtm-menu > li:hover > a,
			#nav .rtm-menu > ul > li a:hover,
			#nav ul.rtm-menu > li.current-menu-item > a,
			#nav .rtm-menu > ul > li.current-menu-item a,
			#nav ul.rtm-menu > li.current-menu-ancestor > a,
			#nav .rtm-menu > ul > li.current-menu-ancestor a,
			#nav .azoom-woocommerce-cart-menu-item a{
				color:'.esc_attr(xr_get_option('menu_level1_font_hover_color','#ffffff')).';			
			}
		';
		
		if(xr_get_option('menu_level1_bg_hover_enable',true)){
			$custom_style .= '
			ul.rtm-menu > li:hover:not(.dismiss-mobile), .rtm-menu > ul > li:hover:not(.dismiss-mobile), 
			ul.rtm-menu > li.current-menu-item:not(.dismiss-mobile), 
			.rtm-menu > ul > li.current-menu-item:not(.dismiss-mobile), 
			ul.rtm-menu > li.current-menu-ancestor:not(.dismiss-mobile), 
			.rtm-menu > ul > li.current-menu-ancestor:not(.dismiss-mobile){
				background:'.esc_attr(xr_get_option('menu_level1_bg_hover_color', '#56CCC8')).';
			}';
		}
		
		$custom_style .= '	
			#nav ul.rtm-menu ul a, #nav .rtm-menu ul ul a{
				color:#787878;	
			}
			
			#nav ul.rtm-menu ul li:not(.hide-label) a:hover, #nav .rtm-menu ul ul li:not(.hide-label) a:hover,
			#nav ul.rtm-menu ul li.current-menu-item:not(.hide-label) > a, 
			#nav .rtm-menu ul ul li.current-menu-item:not(.hide-label) > a{
				background:'.esc_attr(xr_get_option('menu_level2_bg_hover_color','#f0f0f0')).';
			}
			
			
			
			/*Sub Menu Details*/
			.rtm-menu .sub-menu, .rtm-menu .children{
				background:'.esc_attr(xr_get_option('menu_level2_bg_color','#F9F9F9')).';	
			}
			#nav ul.rtm-menu ul a, #nav .rtm-menu ul ul a{
				color:'.esc_attr(xr_get_option('menu_level2_font_color','#787878')).';		
			}
			#nav ul.rtm-menu ul li .description, #nav .rtm-menu ul ul li .description{
				color:'.esc_attr(xr_get_option('menu_level2_desc_font_color','#999999')).';		
			}
			#nav ul.rtm-menu ul a:hover, #nav .rtm-menu ul ul a:hover,
			#nav ul.rtm-menu ul li:not(.hide-label) a:hover, #nav .rtm-menu ul ul li:not(.hide-label) a:hover, 
			#nav ul.rtm-menu ul li.current-menu-item:not(.hide-label) > a, 
			#nav .rtm-menu ul ul li.current-menu-item:not(.hide-label) > a{
				color:'.esc_attr(xr_get_option('menu_level2_font_hover_color','#56ccc8')).';	
			}
			.main-navigation ul.rtm-menu > li.regularmenu li a,
			.rtm-menu .megamenu li.columns{
				border-color:'.esc_attr(xr_get_option('menu_level2_border_dim_color','#F0F0F0')).';	
			}
			#nav ul.rtm-menu > li > ul, #nav .rtm-menu > ul > li > ul{
				border-color:'.esc_attr(xr_get_option('menu_level2_border_top_color','#56ccc8')).';	
			}
			
		';
	
		//Azoom Tablet Navigation Layout
		if(!xr_get_option('disable_responsivity',false)){
			$custom_style .= '@media only screen and (max-width: '.esc_attr(xr_get_option('main_layout_grid','1440px')).') {
				.rtm-menu > li > a,
				.rtm-menu > ul > li > a,
				.rtm-menu > ul > li > .heading-nav{
					padding:0 10px;
				}
			}';
		}
		
		$custom_style .= '
			.rtm-menu-sticker.sticker-model-hot{
				background: '.esc_attr(xr_get_option('menu_sticker_hot_bg_color','#ea6060')).';
				color: '.esc_attr(xr_get_option('menu_sticker_hot_font_color','#ffffff')).';
			}
			.rtm-menu-sticker.sticker-model-new{
				background: '.esc_attr(xr_get_option('menu_sticker_new_bg_color','#56CCC8')).';
				color: '.esc_attr(xr_get_option('menu_sticker_new_font_color','#ffffff')).';
			}
			.rtm-menu-sticker.sticker-model-info{
				background: '.esc_attr(xr_get_option('menu_sticker_info_bg_color','#324864')).';
				color: '.esc_attr(xr_get_option('menu_sticker_info_font_color','#ffffff')).';
			}
		';
	}
	
	/*Under Menu - Search and WooCommerce*/
	if(xr_get_option('menu_search_bg_color_enable',true)){
		$custom_style .= '
			/*Menu Search Element*/
			#nav ul.rtm-menu > li.azoom-ajax-search-menu-item,
			#nav .rtm-menu > ul > li.azoom-ajax-search-menu-item,
			nav .azoom-ajax-search-menu-item{
				background:'.esc_attr(xr_get_option('menu_search_bg_color','#152840')).';	
			}';
	}
	
	$custom_style .= '
			#nav ul.rtm-menu > li.azoom-ajax-search-menu-item a,
			#nav .rtm-menu > ul > li.azoom-ajax-search-menu-item a,
			nav .azoom-ajax-search-menu-item a{
				color:'.esc_attr(xr_get_option('menu_search_font_color','#f9f9f9')).';
			}
			#nav ul.rtm-menu > li.azoom-ajax-search-menu-item:hover a,
			#nav .rtm-menu > ul > li.azoom-ajax-search-menu-item:hover a,
			nav li.azoom-ajax-search-menu-item:hover a{
				color:'.esc_attr(xr_get_option('menu_search_font_hover_color','#FFFFFF')).';
			}';
	
	if(xr_get_option('menu_woocart_bg_color_enable', true)){
		$custom_style .= '
			/*Menu WooCart Element*/
			#nav ul.rtm-menu > li.azoom-woocommerce-cart-menu-item,
			#nav .rtm-menu > ul > li.azoom-woocommerce-cart-menu-item,
			nav li.azoom-woocommerce-cart-menu-item{
				background:'.esc_attr(xr_get_option('menu_woocart_bg_color','#56CCC8')).';	
			}';
	}
	
	$custom_style .= '
			#nav ul.rtm-menu > li.azoom-woocommerce-cart-menu-item a,
			#nav .rtm-menu > ul > li.azoom-woocommerce-cart-menu-item a,
			nav li.azoom-woocommerce-cart-menu-item a{
				color:'.esc_attr(xr_get_option('menu_woocart_font_color','#f9f9f9')).';
			}
			#nav ul.rtm-menu > li.azoom-woocommerce-cart-menu-item:hover a,
			#nav .rtm-menu > ul > li.azoom-woocommerce-cart-menu-item:hover a,
			nav li.azoom-woocommerce-cart-menu-item:hover a{
				color:'.esc_attr(xr_get_option('menu_woocart_font_hover_color','#FFFFFF')).';
			}
			
			
			/*Menu Extras (WooCommerce Cart Contents and Search Results)*/
			.azoom-undermenu-box, #nav .regularmenu ul ul{
				border-color:'.esc_attr(xr_get_option('menu_extras_border_top_color', '#56CCC8')).';
			}
			.azoom-undermenu-box-background{
				background:'.esc_attr(xr_get_option('menu_extras_bg_color','#f9f9f9')).';	
			}
			.azoom-undermenu-box .undermenu-box-button-cover{
				background:'.esc_attr(xr_get_option('menu_extras_bg_color','#f9f9f9')).';	
			}
			.azoom-undermenu-box .undermenu-box-button-cover .search-results-button,
			.azoom-undermenu-box .undermenu-box-button-cover .azoom-woo-cart-buttons
			{
				background:'.esc_attr(xr_get_option('menu_extras_button_bg_color','#787878')).';
				color:'.esc_attr(xr_get_option('menu_extras_button_font_color','#FFFFFF')).';	
			}
			.azoom-undermenu-box .undermenu-box-button-cover .azoom-woo-cart-buttons:hover,
			.azoom-undermenu-box .undermenu-box-button-cover .search-results-button:hover{
				background:'.esc_attr(xr_get_option('menu_extras_button_bg_hover_color','#56CCC8')).';
			}
			.azoom-undermenu-mask .search_full .rockthemes-ajax-search-input, 
			.search_full .rockthemes-ajax-search-input:focus, 
			.search_full .rockthemes-ajax-search-input:hover, 
			.search_full .rockthemes-ajax-search-input:active{
				border-color:'.esc_attr(xr_get_option('menu_extras_search_border_color','#DEDEDE')).';
			}
			.azoom-woocommerce-cart-wrapper.azoom-woocommerce-box .azoom-woocommerce-box-content .cart_list li .ajax-cart-content,
			.search-single-result{
				background:'.esc_attr(xr_get_option('menu_extras_results_bg_color','#FFFFFF')).';	
			}
			.azoom-woocommerce-cart-wrapper.azoom-woocommerce-box .azoom-woocommerce-box-content .cart_list li .ajax-cart-content:hover,
			.search-single-result:hover{
				background:'.esc_attr(xr_get_option('menu_extras_results_bg_hover_color','#f9f9f9')).';	
			}
	';
	
	$mobile_menu_font_details = xr_get_option('mobile_menu_font_details', array());
	if(empty($mobile_menu_font_details) || !isset($mobile_menu_font_details['font_family'])){
		$mobile_menu_font_details = array('font_family'=>'','font_size'=>'14px');	
	}

	/*Azoom Mobile Menu*/
	$custom_style .= '
		.mobile-menu-switcher-holder, .mobile-cart-holder, .menu_use_mobile_for_main .azoom-ajax-search-menu-item{
			line-height:'.esc_attr(xr_get_option('header_regular_line_height', '90px')).';
		}
		.header-sticky-animate .mobile-menu-switcher-holder,
		.header-sticky-animate .mobile-cart-holder,
		.menu_use_mobile_for_main .header-sticky-animate .azoom-ajax-search-menu-item{
			line-height:'.esc_attr(xr_get_option('header_sticky_line_height', '60px')).';
		}
		.menu_use_mobile_for_main .menu-mobile-details{
			max-height:'.esc_attr(xr_get_option('header_regular_line_height', '90px')).';
		}
		.menu_use_mobile_for_main .header-sticky-animate .menu-mobile-details{
			max-height:'.esc_attr(xr_get_option('header_sticky_line_height', '60px')).';
		}
		
		#rnmm.mm-menu{
			background:'.esc_attr(xr_get_option('mobile_background_color','#f3f3f3')).';	
		}
		
		#rnmm .mm-panel a, #rnmm .mm-panel '.$a_not.',
		#rnmm.mm-menu .mm-navbar-top{color:'.esc_attr(xr_get_option('mobile_font_color','#787878')).';}
		
		#rnmm a:hover, #rnmm '.$a_not.':hover,
		#rnmm li.current-menu-item > a, #rnmm li.current-menu-item > '.$a_not.'{
			color:'.esc_attr(xr_get_option('mobile_hover_font_color','#C5CDD1')).';
		}
		
		#rnmm.mm-menu .mm-listview > li.mm-selected > a:not(.mm-subopen), 
		#rnmm.mm-menu .mm-listview > li.mm-selected > span{
			background:'.esc_attr(xr_get_option('mobile_hover_bg_color','#f9f9f9')).';	
		}
		
		#rnmm i:not(.social-icon-regular):not(.social-icon-hover){
			color:'.esc_attr(xr_get_option('mobile_icon_color','#C5CDD1')).';	
		}

		#rnmm.mm-menu .mm-navbar .mm-prev:before, #rnmm.mm-menu .mm-navbar .mm-next:after,
		.mm-menu .mm-listview > li .mm-prev:before, .mm-menu .mm-listview > li .mm-next:after, .mm-menu .mm-listview > li .mm-arrow:after,
		#rnmm.mm-menu .mm-listview > li > a.mm-subopen:after, 
		#rnmm.mm-menu .mm-listview > li > a.mm-subclose:before{
			border-color:'.esc_attr(xr_get_option('mobile_arrow_color','#f9f9f9')).';	
		}
		
		#rnmm .mm-navbar-top .logo-container{
			padding-top:'.esc_attr(xr_get_option('mobile_menu_logo_padding_top','0px')).';
			padding-bottom:'.esc_attr(xr_get_option('mobile_menu_logo_padding_bottom','0px')).';
		}
		
		#rnmm .mm-panel li a, #rnmm .mm-navbar-top a, #rnmm .mm-navbar-top span, #rnmm .mm-navbar-top div{
			'.$mobile_menu_font_details['font_family'].'
		}
		#rnmm .mm-listview li a{
			font-size:'.esc_attr($mobile_menu_font_details['font_size']).';
			font-weight:'.esc_attr(xr_get_option('mobile_menu_font_weight', 'inherit')).';
		}
		#rnmm .mm-navbar-top a, #rnmm .mm-navbar-top span, #rnmm .mm-navbar-top div{font-size:'.esc_attr(xr_get_option('mobile_menu_title_font_size','16px')).';}
	';
	
	if(xr_get_option('mobile_menu_use_dark_border_color',false)){
		$custom_style .= '
			.mm-menu .mm-navbar,
			.mm-menu .mm-listview > li:after,
			.mm-menu .mm-panel > li > a.mm-subopen:before,
			.mm-menu .mm-listview > li .mm-prev:after,
			.mm-menu .mm-listview > li .mm-next:before,
			.mm-menu .mm-navbar-bottom{border-color:rgba(0, 0, 0, 0.1);}
		';	
	}

	if(is_rtl()){
		$custom_style .= '#rockthemes_mobile_menu{right:0px;}';
	}else{
		$custom_style .= '#rockthemes_mobile_menu{left:0px;}';
	}
	
	
	$custom_style .= '
		#mobile-menu-list-icon{
			background:rgba('.rockthemes_hex2rgba(xr_get_option('mobile_menu_list_bg_color','#324864'), 0.6).');
		}
		
		#mobile-menu-list-icon:before, #mobile-menu-list-icon:after, #mobile-menu-list-icon span {
			background:'.xr_get_option('mobile_menu_list_icon_color','#ffffff').';	
		}
		.menu-mobile-details #mobile-menu-list-icon::before, .menu-mobile-details #mobile-menu-list-icon::after, 
		.menu-mobile-details #mobile-menu-list-icon span{
			background:'.xr_get_option('mobile_menu_list_icon_color','#ffffff').';	
		}
	';	
	
	if(xr_get_option('header_location','top_navigation') === 'side_navigation'){
		$mobile_side_menu_width = xr_get_option('mobile_side_menu_width','') !== '' ? esc_attr(xr_get_option('mobile_side_menu_width','')) : '350px';
		$custom_style .= '
		@media only screen and (min-width: 1024px){
			.mm-menu{
				width:'.$mobile_side_menu_width.' !important;	
			}
			body{
				padding-left:'.$mobile_side_menu_width.' !important;
			}
		}
		';
	}
	
	
	
	//Inline Navigation (Righ side dots)
	$custom_style .= '
		#rockthemes-inline-nav .rin-title:after{border-left-color:'.$site_general_color.';}
		#rockthemes-inline-nav .rin-title{background-color:'.$site_general_color.';}
	';
	//Go to top
	$custom_style .= '#azoom-go-to-top{background:'.esc_attr(xr_get_option('gototop_bg_color','#152840')).'; color:'.esc_attr(xr_get_option('gototop_font_color','#FFFFFF')).';}';
	
	
	
	/*
	**	Uber Menu - Base Support For 3rd
	**	Still under development.
	**	TO DO 	:	Work more on this.
	*/
	if(1 == 0){
		$custom_style .= '
			@media only screen and (min-width:1023px){
				/*Uber Menu*/
				nav.ubermenu > li > a, 
				nav.ubermenu > ul > li > a,
				nav.ubermenu > li > a.ubermenu-target, 
				nav.ubermenu > ul > li > a.ubermenu-target{
					line-height:'.esc_attr(xr_get_option('header_regular_line_height', '90px')).';
					padding-top:0px;
					padding-bottom:0px;
					transition:all .3s;
					-webkit-transition: all .3s;
					-moz-transition: all .3s;
				}
				
				/*Uber Menu*/
				.header-sticky-animate nav.ubermenu > li > a, 
				.header-sticky-animate nav.ubermenu > ul > li > a,
				.header-sticky-animate nav.ubermenu > li > a.ubermenu-target, 
				.header-sticky-animate nav.ubermenu > ul > li > a.ubermenu-target{
					line-height:'.esc_attr(xr_get_option('header_sticky_line_height', '60px')).';
				}
				.main-header-area .ubermenu .ubermenu-target-text{
					vertical-align:inherit;	
				}
			}
			
			.main-header-area .ubermenu-responsive-toggle{
				line-height:'.esc_attr(xr_get_option('header_regular_line_height', '90px')).';
				padding-top:0px;
				padding-bottom:0px;
				transition:all .3s;
				-webkit-transition: all .3s;
				-moz-transition: all .3s;
			}
			.main-header-area.header-sticky-animate .ubermenu-responsive-toggle{
				line-height:'.esc_attr(xr_get_option('header_sticky_line_height', '60px')).';
			}

		';
	}

	
	
	//Title Breadcrumbs Area Settings
	$title_area_data_prefix = '';//Use this prefix for WooCommerce datas
	if(function_exists('rockthemes_woocommerce_active') && rockthemes_woocommerce_active() && (is_woocommerce() || is_cart() || is_account_page() || is_checkout())){
		$title_area_data_prefix	= 'woo_';
	}elseif(is_page()){
		$title_area_data_prefix = 'page_';	
	}
	
	$title_area_background_image_repeat = esc_attr(xr_get_option($title_area_data_prefix.'title_area_background_image_repeat', ''));
	$title_area_background_image = esc_url(xr_get_option($title_area_data_prefix.'title_area_background_image', ''));
	$title_area_background_color = esc_attr(xr_get_option($title_area_data_prefix.'title_area_background_color', ''));
	
	$title_area_background_image_retina = esc_url(xr_get_option($title_area_data_prefix.'title_area_background_image_retina', ''));
	$title_area_background_image_width = esc_attr(xr_get_option($title_area_data_prefix.'title_area_background_image_width', ''));
	$title_area_background_image_height = esc_attr(xr_get_option($title_area_data_prefix.'title_area_background_image_height', ''));
	
	$rad_header_bg_image = rad_get_option('header_bg_image','');
	if($rad_header_bg_image !== '' && is_string($rad_header_bg_image) && (is_single() || is_page())){
		$title_area_background_image = $rad_header_bg_image;
	}
	$rad_header_bg_image_retina = rad_get_option('header_bg_image_retina','');
	if($rad_header_bg_image_retina !== '' && is_string($rad_header_bg_image_retina) && (is_single() || is_page())){
		$title_area_background_image_retina = $rad_header_bg_image_retina;
	}

	if(rad_get_option('transparent_header', false) !== 'all_wrapper' && rad_get_option('transparent_header', false) !== 'breadcrumbs'){		
		if($title_area_background_image !== ''){
			if($title_area_background_image_repeat !== 'parallax'){
				$custom_style .= '.azoom-title-breadcrumbs{
					background:url("'.$title_area_background_image.'") '.$title_area_background_image_repeat.';
					background-size:'.$title_area_background_image_width.' '.$title_area_background_image_height.'
				}
				
				@media screen and (-webkit-min-device-pixel-ratio: 2), screen and (max--moz-device-pixel-ratio: 2) {
					.azoom-title-breadcrumbs{background-image:url("'.$title_area_background_image_retina.'");}
				}';
			}else{
				$custom_style .= '
				@media screen and (-webkit-min-device-pixel-ratio: 2), screen and (max--moz-device-pixel-ratio: 2) {
					.azoom-title-breadcrumbs{background-image:url("'.$title_area_background_image_retina.'");}
				}';
			}
		}else{
			$custom_style .= '.azoom-title-breadcrumbs{background:'.$title_area_background_color.';}';
		}
	}
	
	
	$custom_style .= '
		.azoom-title-breadcrumbs, .azoom-title-breadcrumbs .page-title,
		.azoom-title-breadcrumbs.full-width-title-breadcrumbs .page-title{
			color:'.esc_attr(xr_get_option($title_area_data_prefix.'title_area_font_color', '#333')).';
		}';
	$custom_style .= '.azoom-title-breadcrumbs '.$a_not.'{color:'.esc_attr(xr_get_option($title_area_data_prefix.'title_area_link_color', '#333')).';}';
	$custom_style .= '.azoom-title-breadcrumbs '.$a_not.':hover{color:'.$a_link_hover_color.';}';
	
	$custom_style .= $ie8.'.azoom-title-breadcrumbs a{color:'.esc_attr(xr_get_option($title_area_data_prefix.'title_area_link_color', '#333')).';}';
	$custom_style .= $ie8.'.azoom-title-breadcrumbs a:hover{color:'.$a_link_hover_color.';}';
	//End of Title Breadcrumbs Area
	
	
	//Footer Large Area
	$footer_large_background_image_repeat = esc_attr(xr_get_option('footer_large_background_image_repeat', ''));
	$footer_large_background_image = esc_attr(xr_get_option('footer_large_background_image', ''));
	$footer_large_background_color = esc_attr(xr_get_option('footer_large_background_color', ''));
	
	$footer_large_background_image_retina = esc_attr(xr_get_option('footer_large_background_image_retina', ''));
	$footer_large_background_image_width = esc_attr(xr_get_option('footer_large_background_image_width', ''));
	$footer_large_background_image_height = esc_attr(xr_get_option('footer_large_background_image_height', ''));
	
	if($footer_large_background_image !== ''){
		$custom_style .= '.footer-large{
				background:url("'.$footer_large_background_image.'") '.$footer_large_background_image_repeat.';
				background-size:'.$footer_large_background_image_width.' '.$footer_large_background_image_height.'
		}
		
		@media screen and (-webkit-min-device-pixel-ratio: 2), screen and (max--moz-device-pixel-ratio: 2) {
			.footer-large{background-image:url("'.$footer_large_background_image_retina.'");}
		}
		';
	}else{
		$custom_style .= '.footer-large{background:'.$footer_large_background_color.';}';
	}
	$custom_style .= '
		.footer-large, .footer-large *, .footer-large .widget-title, 
		.footer-large .widget > h3, .footer-large .widget > .widget-title{
			color:'.esc_attr(xr_get_option('footer_large_font_color', '#333')).';
		}
	';
	$custom_style .= '.footer-large '.$a_not.'{color:'.esc_attr(xr_get_option('footer_large_link_color', '#333')).';}';
	$custom_style .= '.footer-large '.$a_not.':hover{color:'.$a_link_hover_color.';}';
	
	$custom_style .= $ie8.'.footer-large a{color:'.esc_attr(xr_get_option('footer_large_link_color', '#333')).';}';
	$custom_style .= $ie8.'.footer-large a:hover{color:'.$a_link_hover_color.';}';
	
	if(!xr_get_option('footer_large_headers_shadow', true)){
		$custom_style .= '.footer-large .widget-title{text-shadow:none;}';
	}
	
	$custom_style .= '
		.widget_archive li, .widget_categories li, .widget_meta li, .widget_pages li, 
		.widget_recent_comments li, .widget_recent_entries li, .widget_nav_menu li, 
		.woocommerce.widget_product_categories .product-categories li, 
		.woocommerce.widget_recently_viewed_products .product_list_widget li, 
		.woocommerce.widget_products .product_list_widget li, .woocommerce.widget_layered_nav li, 
		.woocommerce.widget_recent_reviews li, .sidebar-area .woocommerce.widget_shopping_cart li, 
		.woocommerce.widget_top_rated_products li{
			border-color:'.esc_attr(xr_get_option('footer_large_border_dim_color','#C5CDD1')).';	
		}
	';
	
	
	if(xr_get_option('footer_large_top_border',true)){
		$custom_style .= '.footer-large{border-top:3px solid '.$site_general_color.';}';
	}
	//End of Footer Large Area
	
	
	//Footer Bottom
	$custom_style .= '.footer-bottom{background:'.esc_attr(xr_get_option('footer_bottom_background_color', '')).';}';

	$custom_style .= '.footer-bottom{color:'.esc_attr(xr_get_option('footer_bottom_font_color', '#333')).';}';
	$custom_style .= '.footer-bottom '.$a_not.'{color:'.esc_attr(xr_get_option('footer_bottom_link_color', '#333')).';}';
	$custom_style .= '.footer-bottom '.$a_not.':hover{color:'.$a_link_hover_color.';}';
	
	$custom_style .= $ie8.'.footer-bottom a{color:'.esc_attr(xr_get_option('footer_bottom_link_color', '#333')).';}';
	$custom_style .= $ie8.'.footer-bottom a:hover{color:'.$a_link_hover_color.';}';
	
	$custom_style .= '.footer-bottom > .row{border-color:'.esc_attr(xr_get_option('footer_bottom_top_border_color','#c5cdd1')).';}';
	//End of Footer Bottom
	
	
	//General Font Colors
	$custom_style .= 'h1{color:'.esc_attr(xr_get_option('font_h1_color', '')).';}';//was h1, .rock-iconictext-header-title strong
	$custom_style .= 'h2{color:'.esc_attr(xr_get_option('font_h2_color', '')).';}';
	$custom_style .= 'h3{color:'.esc_attr(xr_get_option('font_h3_color', '')).';}';
	$custom_style .= 'h4{color:'.esc_attr(xr_get_option('font_h4_color', '')).';}';
	$custom_style .= 'h5{color:'.esc_attr(xr_get_option('font_h5_color', '')).';}';
	$custom_style .= 'h6{color:'.esc_attr(xr_get_option('font_h6_color', '')).';}';
	//End of General Font Colors
	
	$custom_style .= '.error-404-header, .error-404-description{color:'.esc_attr(xr_get_option('404_heading_color','#787878')).';}';
	
	//Blog Colors
	$custom_style .= '
	.genericon:before,
	.menu-toggle:after,
	.featured-post:before,
	.date a:before,
	.entry-meta .author a:before,
	.format-audio .entry-content:before,
	.comments-link a:before,
	.tags-links a:first-child:before,
	.categories-links a:first-child:before,
	.post-view:before,
	.edit-link a:before,
	.attachment .entry-title:before,
	.attachment-meta:before,
	.attachment-meta a:before,
	.comment-awaiting-moderation:before,
	.comment-reply-link:before,
	.comment-reply-login:before,
	.comment-reply-title small a:before,
	.bypostauthor > .comment-body .fn:before,
	.error404 .page-title:before{
		color:'.$site_general_color.';
	}
	';
	
	$custom_style .= '.more-link:not(.button){color:'.$a_link_color.';}';
	$custom_style .= '.post-format-container{background-color:'.$site_general_color.'; color:'.esc_attr(xr_get_option('blog_post_type_icon_color','#FFF')).';}';
	//End of Blog Colors
	
		
	/*Pagination Hover*/
	$custom_style .= '
	.azoom-pagination .page-numbers:not(.current):hover, input[type="submit"]:not(.checkout-button):not(.button.alt):hover, .comments-submit:hover, #comments-submit:hover{

	}
	';

	$custom_style .= '
	.azoom-pagination .page-numbers.current:not(.dots), .azoom-pagination .page-numbers:not(.dots):active, .azoom-link_pages > span.page-numbers:not(.dots), 
	.button.active, .button.current, .button.active:hover, .button.current:hover .button.active:active, .button.current:active{
		background:'.$site_general_color.';	 
		border-color:'.$site_general_color.';
	}
	';
	/*End of Main Gradients*/

	
	/*Hover effect mask*/
	/*$custom_style .= '.regular-hover-container .hover-bg{background-color:'.$site_general_color.';}';*/
	
	
	//Main Boxed Layout Background Settings
	$main_boxed_layout_bg_image_repeat = esc_attr(xr_get_option('main_boxed_layout_bg_image_repeat', ''));
	$main_boxed_layout_bg_image = esc_attr(xr_get_option('main_boxed_layout_bg_image', ''));
	$main_boxed_layout_bg_color = esc_attr(xr_get_option('main_boxed_layout_bg_color', ''));
	
	$main_boxed_layout_bg_image_retina = esc_attr(xr_get_option('main_boxed_layout_bg_image_retina', ''));
	$main_boxed_layout_bg_image_width = esc_attr(xr_get_option('main_boxed_layout_bg_image_width', ''));
	$main_boxed_layout_bg_image_height = esc_attr(xr_get_option('main_boxed_layout_bg_image_height', ''));
	
	if($main_boxed_layout_bg_image !== ''){
		$custom_style .= '#main-canvas{
				background:url("'.$main_boxed_layout_bg_image.'") '.$main_boxed_layout_bg_image_repeat.';
				background-size:'.$main_boxed_layout_bg_image_width.' '.$main_boxed_layout_bg_image_height.'
		}
		
		@media screen and (-webkit-min-device-pixel-ratio: 2), screen and (max--moz-device-pixel-ratio: 2) {
			#main-canvas{background-image:url("'.$main_boxed_layout_bg_image_retina.'");}
		}
		';
	}else{
		$custom_style .= '#main-canvas{background:'.$main_boxed_layout_bg_color.';}';
	}
	
	//Main Boxed Layout Background Settings	
	$main_bg_image_retina = esc_attr(xr_get_option('main_bg_image_retina', ''));
	$main_bg_image_width = esc_attr(xr_get_option('main_bg_image_width', ''));
	$main_bg_image_height = esc_attr(xr_get_option('main_bg_image_height', ''));
	
	$custom_style .= 'body.custom-background{
			background-size:'.$main_bg_image_width.' '.$main_bg_image_height.'
	}';
	if($main_bg_image_retina !== ''){
		$custom_style .= '
		@media screen and (-webkit-min-device-pixel-ratio: 2), screen and (max--moz-device-pixel-ratio: 2) {
			body.custom-background{background-image:url("'.$main_bg_image_retina.'");}
		}
		';
	}


	
	/*Background Settings*/
	$bg_color = get_theme_mod( 'background_color','f0f0f0' ) !== '' ? '#'.get_theme_mod( 'background_color','f0f0f0' ) : '';
	$custom_style .= '.ui-panel-content-wrap, .ui-overlay-c{background:'.$bg_color.' url("'.get_theme_mod('background_image','').'") '.get_theme_mod('background_repeat','').' '.get_theme_mod('background_attachment','').' '.'top'.' '.get_theme_mod('background_position_x','').' !important; } ';
	
	$canvas_shadow_width = xr_get_option('canvas_shadow_width','50') != '' ? esc_attr(xr_get_option('canvas_shadow_width','50')) : 50 ;
	$custom_style .= '.content_holder{ -webkit-box-shadow: 0px 0px '.$canvas_shadow_width.'px rgba(80, 80, 80, 0.78); -moz-box-shadow: 0px 0px '.$canvas_shadow_width.'px rgba(80, 80, 80, 0.78); box-shadow: 0px 0px '.$canvas_shadow_width.'px rgba(80, 80, 80, 0.78);  } ';
	
	/*Boxed Layout Background Color for Elements*/
	$boxed_layout_bg = esc_attr(xr_get_option('boxed_layout_element_background_color','#666666'));
	if(rockthemes_browser_ie9()){
		$boxed_layout_bg = 'rgba('.rockthemes_hex2rgba($boxed_layout_bg, 0.68).')';
	}
	$custom_style .= '.boxed-layout{background-color:'.$boxed_layout_bg.';}';
	$custom_style .= '.rockthemes-parallax .boxed-layout{background-color:'.$boxed_layout_bg.';}';
	$custom_style .= '.boxed-layout.boxed-colors, .boxed-layout.boxed-colors p, .boxed-layout.boxed-colors h1,
	 .boxed-layout.boxed-colors h2, .boxed-layout.boxed-colors h3, .boxed-layout.boxed-colors h4,
	 .boxed-layout.boxed-colors h5, .boxed-layout.boxed-colors h6,
	 .boxed-layout.boxed-colors div{color:'.esc_attr(xr_get_option('boxed_layout_text_color','#101010')).';}';/*Boxed layout text color*/
	$custom_style .= '.boxed-layout.boxed-colors a:not(.button){color:'.esc_attr(xr_get_option('boxed_layout_a_link_color','#eeeeee')).';}';
	$custom_style .= '.boxed-layout.boxed-colors a:not(.button):hover{color:'.esc_attr(xr_get_option('boxed_layout_a_link_hover_color','#ffffff')).';}';
	
	
	//Change Self Background
	if(isset($post) && !empty($post)){
		$self_different_bg = rad_get_option('self_bg');
		if($self_different_bg !== 'default'){
			if($self_different_bg === 'color'){
				$custom_style .= 'body, body.custom-background{background:'.esc_attr(rad_get_option('self_bg_color')).' !important;}';	
			}elseif($self_different_bg === 'image'){
				$custom_style .= 'body, body.custom-background{background:'.esc_attr(rad_get_option('self_bg_color')).' 
													url("'.esc_url(rad_get_option('self_bg_image')).'") '.
													esc_attr(rad_get_option('self_bg_image_pos')).' '.
													esc_attr(rad_get_option('self_bg_image_repeat')).' '.
													esc_attr(rad_get_option('self_bg_image_attach')).' !important; }';
			}
		}
	}
	
	
	
	/*Pricing Table*/
	$custom_style .= '
		.azoom-pt-package-name{
			background:'.esc_attr(xr_get_option('pricing_table_heading_bg','#324864')).';	
		}
	';
	
	/*Iconic Text*/
	/*
	$custom_style .= '.rock-iconictext-container .rockicon-circle-box i,
	.rock-iconictext-container .rockicon-rounded-box i{color:'.xr_get_option('boxed_layout_text_color','#101010').';}';
	
	$custom_style .= '.rock-iconictext-container .rockicon-circle-box i,
	.rock-iconictext-container .rockicon-rounded-box i,
	.rock-iconictext-container .rockicon-azoom-box i{color:#f3f3f3;}';
	*/
	
	/*Tabs and Toggles use the same background color*/
	$tabs_toggles_border_color = esc_attr(xr_get_option('tabs_toggles_border_color', '#E4E4E4'));
	$tabs_bg_light_color = esc_attr(xr_get_option('tabs_toggles_bg_light_color','#F0F0F0'));
	$tabs_bg_dark_color = esc_attr(xr_get_option('tabs_toggles_bg_dark_color','#F0F0F0'));
	$tabs_toggles_header_default_text_color = esc_attr(xr_get_option('tabs_toggles_header_default_text_color', '#787878'));
	$tabs_toggles_header_hover_text_color = esc_attr(xr_get_option('tabs_toggles_header_hover_text_color', '#56CCC8'));
	$tabs_toggles_header_active_text_color = esc_attr(xr_get_option('tabs_toggles_header_active_text_color', '#FFFFFF'));
	/*Toggles*/
	$custom_style .= '.rock-toggles-container .rock-toggle-header{color:'.$tabs_toggles_header_default_text_color.';}';
	$custom_style .= '.rock-toggles-container .active .rock-toggle-header{
		color:'.$tabs_toggles_header_active_text_color.';
		background:'.$site_general_color.';
	}';

	$custom_style .= '.rock-toggles-container > div:not(.active) .rock-toggle-header:hover{color:'.$tabs_toggles_header_hover_text_color.';}';
	$custom_style .= '.rock-toggle-content{background:'.$tabs_bg_light_color.';}';
	$custom_style .= '.rock-toggle-header{background:'.$tabs_bg_dark_color.';}';
	
	
	

	
	/*Tabs*/
	$custom_style .= '
		.rock-tabs-container .rock-tabs-header-container .rock-tab-header{color:'.$tabs_toggles_header_default_text_color.';}
		.rock-tabs-container .rock-tabs-header-container .rock-tab-header:hover{color:'.$tabs_toggles_header_hover_text_color.';}
		.rock-tabs-container .rock-tabs-header-container .rock-tab-header.active{color:'.$tabs_toggles_header_active_text_color.';}
	';
	$custom_style .= '.rock-tabs-container .rock-tabs-header-container .rock-tab-header{
		background:'.$tabs_bg_dark_color.';
	}';	
	$custom_style .= '
	.rock-tabs-container .rock-tabs-content-container .tabs-motion-container{
		background:'.$tabs_bg_light_color.';
	}';
	$custom_style .= '
	.rock-tabs-container .rock-tabs-header-container .rock-tab-header.active{
		background:'.$site_general_color.';
	}';
	
	$custom_style .= '
		.boxed-layout .rock-tabs-container .rock-tabs-header-container .rock-tab-header{color:'.esc_attr(xr_get_option('boxed_layout_a_link_color','#eeeeee')).';}
		.boxed-layout .rock-tabs-container .rock-tabs-header-container .rock-tab-header.active,
		.boxed-layout .rock-tabs-container .rock-tabs-header-container .rock-tab-header.active:hover{color:'.esc_attr(xr_get_option('tabs_toggles_boxed_header_hover_text_color','#ffffff')).';}
		.boxed-layout .rock-tabs-container .rock-tabs-header-container .rock-tab-header:hover{color:'.esc_attr(xr_get_option('tabs_toggles_header_hover_text_color','#56CCC8')).';}
	';
	
	$custom_style .= '.rock-tabs-container.tab-top .rock-tabs-header-container .rock-tab-header.active:first-child,
	.rock-tabs-container.tab-top .rock-tabs-header-container .rock-tab-header.active,
	.rock-tabs-container.tab-top .rock-tabs-header-container .rock-tab-header.active{
		border-left-color:'.$tabs_toggles_border_color.';
		border-right-color:'.$tabs_toggles_border_color.';
		border-top-color:'.$tabs_toggles_border_color.';
	}';
	
	$custom_style .= '.rock-tabs-container.tab-top .rock-tabs-header-container .rock-tab-header.active{
		border-bottom-color:'.$site_general_color.';
	}';
	
	$custom_style .= '.rock-tabs-container.tab-left .rock-tabs-content-container{border-left-color:'.$tabs_toggles_border_color.';}
	.rock-tabs-container.tab-right .rock-tabs-content-container{border-right-color:'.$tabs_toggles_border_color.';}
	.rock-tabs-container.tab-top .rock-tabs-content-container .tabs-motion-container{border-top-color:'.$tabs_toggles_border_color.';}
	';
	
	
	
	/*Border Radius of boxed layouts*/
	$layout_border_radius = esc_attr(xr_get_option('layout_border_radius','0px'));
	$custom_style .= '.boxed-layout{border-radius:'.$layout_border_radius.';}';
	
	/*Ajax Filtered Gallery Details*/
	$ajax_filtered_gallery_width = esc_attr(xr_get_option('ajax_filtered_hover_width','590px'));
	$ajax_filtered_gallery_height = esc_attr(xr_get_option('ajax_filtered_hover_height','300px'));
	$ajax_filtered_gallery_image_width = rockthemes_fn_px_em_return_num($ajax_filtered_gallery_width) + rockthemes_fn_px_em_return_num($default_padding);
	$ajax_filtered_gallery_image_height = rockthemes_fn_px_em_return_num($ajax_filtered_gallery_height) + rockthemes_fn_px_em_return_num($default_padding);
	$custom_style .= '
	.ajax-filtered-hover-box{
		width:'.$ajax_filtered_gallery_image_width.'px; 
		height:'.($ajax_filtered_gallery_image_height + 90).'px;
		background:'.esc_attr(xr_get_option('ajax_filtered_hover_box_bg', '#FAFAFA')).';
		border-color:'.esc_attr(xr_get_option('ajax_filtered_hover_box_border', '#BEBEBE')).';
		color:'.esc_attr(xr_get_option('ajax_filtered_hover_box_font', '666666')).';
	}';
	$custom_style .= '.ajax-filtered-hover-box > ajax-filtered-image{width:'.$ajax_filtered_gallery_width.'; height:'.$ajax_filtered_gallery_height.';}';
	
	$custom_style .= '
	.ajax-filtered-gallery-holder.category-names-in-border .ajax-navigation ul li a,
	.ajax-filtered-gallery-holder.category-names-in-border .ajax-filtered-footer a{
		border-color:'.esc_attr(xr_get_option('ajax_filtered_hover_box_font', '666666')).';
	}';
	
	$custom_style .= '
	.ajax-filtered-gallery-holder.category-names-in-border .ajax-navigation ul li a:hover,
	.ajax-filtered-gallery-holder.category-names-in-border .ajax-filtered-footer a:hover,
	.ajax-filtered-gallery-holder.category-names-in-border .ajax-navigation ul li.active a{
		border-color:'.$site_general_color.';
	}';
	
	
	/*Social Icons*/
	$custom_style .= '.header-top-1 .rock-social-icon a .social-icon-regular{color:'.esc_attr(xr_get_option('social_media_icons_default_color','#999')).' !important;}';
	$custom_style .= $ie8.'.header-top-2 .social-icon-regular{color:'.esc_attr(xr_get_option('header_top_link_color', '#FAFAFA')).' !important;}';
	$custom_style .= '.rock-social-icon a .social-icon-regular{color:'.esc_attr(xr_get_option('header_top_link_color', '#FAFAFA')).' !important;}';
	$custom_style .= '.rock-social-icon a .social-icon-hover{color:'.$site_general_color.' !important;}';
		
	/*Team Members*/
	$custom_style .= '.team-member-content .team-member-i{color:'.$site_general_color.';}';
	

	/*404*/	
	$custom_style .= '.error-404-icon{color:'.$site_general_color.';}';
	
	/*HTML Extended Elements*/
	$custom_style .= 'mark{background-color:'.$site_general_color.';}';
	
	
	/*Extra Styling from user*/
	$custom_style .= xr_get_option('extra_css_code','');
	
	//$custom_style .= '</style>';
	
	wp_add_inline_style('azoom-style', $custom_style);
	
}

//add_filter('wp_footer', 'xr_style_callback');






/*
**	Include Chosen Google Font in wp_head action hook
**
**	@params	:	None
**	@return	:	Void
*/
if(!function_exists('rockthemes_to_google_font')){
	function rockthemes_to_google_font(){
		$google_font_link = xr_get_option('google_font_standard_code', '');

		$google_font_url = '';
		if(isset($google_font_link) && strlen($google_font_link) > 0){
			if(preg_match('/<link href="(.*?)">/i', $google_font_link, $google_link_match)) {
					$google_font_url = $google_link_match[1];
			}
			
			if($google_font_url){
				if(is_ssl()){
					$google_font_url = str_replace('http:', 'https:', $google_font_url);
				}
				echo (str_replace($google_font_url, str_replace('|', '%7C', $google_font_url), $google_font_link));
			}
		}
		
		return;
	}
}
//add_action('wp_head', 'rockthemes_to_google_font');





/*
	This function should be moved to another file
*/
if(!function_exists('rockthemes_fn_px_em_return_num')):
function rockthemes_fn_px_em_return_num($val){
	$val = str_replace('px','',$val);
	$val = str_replace('em','',$val);
	return intval($val);
}
endif;


?>