<?php
/*
**	Rock Theme Options
**
**	Elements are located here
**
**	Version	:	1.0
*/



/*
Regular Text Element
*/

if(!function_exists('xr_make_text_field')){
	function xr_make_text_field($args = array()){
		$default = '';
		extract($args);
		$return = '<h3>'.esc_attr($label).'</h3>';
		$return .= '<input autocomplete="off" type="text" id="'.esc_attr($id).'" value="'.esc_attr(stripslashes($default)).'" />';
		$return .= '<div class="element-description">'.stripslashes(($description)).'</div>';
		
		return $return;
	}
}




/*
Regular Text Area (No TinyMCE)
*/

if(!function_exists('xr_make_text_area')){
	function xr_make_text_area($args = array()){
		
		extract($args);
		$return = '<h3>'.esc_attr($label).'</h3>';
		$return .= '<textarea id="'.esc_attr($id).'">'.esc_textarea(stripslashes($default)).'</textarea>';
		$return .= '<div class="element-description">'.stripslashes(esc_attr($description)).'</div>';
		
		return $return;
	}
}






/*
Image Uploader
*/

if(!function_exists('xr_make_image')){
	function xr_make_image($args = array()){
		$default = '';
		extract($args);
		$return = '<h3>'.esc_attr($label).'</h3>';
				
		$return .= '<div class="image_nocode_container">';
		if(!empty($default)){
			$default = esc_url($default);
			$return .= '<img src="'.$default.'" /><br />';
		}
		
		$return .= '<label for="upload_image">
						<input autocomplete="off" id="'.esc_attr($id).'" class="rockthemes_to_upload_image_button" size="36" name="upload_image" type="text" value="'.esc_attr($default).'" />
						<input autocomplete="off" class="rockthemes_to_image_uploader_class button" value="Upload Image" type="button" /> 
						<input autocomplete="off" class="rockthemes_to_image_delete_button button" value="Delete Image" type="button" />
					</label>';
		$return .= '</div><br />';
		
		$return .= '<div class="element-description-full">'.stripslashes($description).'</div>';
		
		return $return;
	}
}






/*
Checkbox (With jQuery Slide)
*/

if(!function_exists('xr_make_checkbox')){
	function xr_make_checkbox($args = array()){
		$default = '';
		extract($args);
		$return = '<h3>'.esc_html($label).'</h3>';
		
		$return .= '<section id="'.esc_attr($id).'" class="checkbox_holder">';
            
        $return .= '<div class="slider-frame">';
		if($default == "YES"){
			$return .= '<span class="slider-button on">YES</span>';
		}else{
			$return .= '<span class="slider-button">NO</span>';
		}
		$return .= '</div>';

        $return .= '</section>';
		$return .= '<div class="element-description">'.stripslashes($description).'</div>';
		$return .= '<div class="clear"></div>';
		
		return $return;
	}
}





/*
Select (Dropdown) Element
*/

if(!function_exists('xr_make_select')){
	function xr_make_select($args = array()){
		$default = '';
		extract($args);
		$return = '<h3>'.esc_html($label).'</h3>';
		$return .= '<select name="'.esc_attr($id).'" id="'.esc_attr($id).'">';
		
		
		foreach($choices as $choice){
			if($choice['value'] == $default){
				$return .= '<option value="'.esc_attr($choice['value']).'" selected>'.esc_html($choice['text']).'</option>';
			}else{
				$return .= '<option value="'.esc_attr($choice['value']).'" >'.esc_html($choice['text']).'</option>';
			}
		}
		
		$return .= '</select>';
		$return .= '<div class="element-description">'.stripslashes($description).'</div>';
		$return .= '<div class="clear"></div>';
		
		return $return;
	}
}




/*
Select with Images Element
*/

if(!function_exists('xr_make_select_images')){
	function xr_make_select_images($args = array()){
		
		$default = '';
		
		extract($args);
		$return = '<h3>'.esc_html($label).'</h3>';
		
		$return .= '<div id="'.esc_attr($id).'" class="image-select-list">';
		$return .= '<div class="image-select-container">';
		
			foreach($choices as $choice){
				if($choice['value'] == $default){
					$return .= '<div class="image-select-elem selected" value="'.esc_attr($choice['value']).'"><img src="'.esc_url($choice['url']).'" alt="'.esc_attr($choice['value']).'" /></div>';
				}else{
					$return .= '<div class="image-select-elem" value="'.esc_attr($choice['value']).'"><img src="'.esc_url($choice['url']).'" alt="'.esc_attr($choice['value']).'" /></div>';
				}
			}

		$return .= '<div class="clear"></div>';
		$return .= '</div>';
		$return .= '</div><br />';
		$return .= '<div class="element-description-full">'.(stripslashes($description)).'</div>';

		return $return;
	}
}




/*
Select with Images Element
*/

if(!function_exists('xr_make_select_images_vertical')){
	function xr_make_select_images_vertical($args = array()){
		
		extract($args);
		$return = '<h3>'.esc_html($label).'</h3>';
		$return .= '<div class="element-description-full">'.esc_attr(stripslashes($description)).'</div>';
		
		$return .= '<div id="'.esc_attr($id).'" class="image-select-vertical-list">';
		$return .= '<div class="image-select-vertical-container">';
		
			foreach($choices as $choice){
				if($choice['value'] == $default){
					$return .= '<div class="image-select-vertical-elem selected" value="'.esc_attr($choice['value']).'"><img src="'.esc_url($choice['url']).'" alt="'.esc_attr($choice['value']).'" /></div>';
				}else{
					$return .= '<div class="image-select-vertical-elem" value="'.esc_attr($choice['value']).'"><img src="'.esc_url($choice['url']).'" alt="'.esc_attr($choice['value']).'" /></div>';
				}
			}

		$return .= '<div class="clear"></div>';
		$return .= '</div>';
		$return .= '</div><br />';

		return $return;
	}
}






/*
Colorpicker
*/
if(!function_exists('xr_make_colorpicker')){
	function xr_make_colorpicker($args = array()){
		extract($args);

		$return = '<h3>'.esc_html($label).'</h3>';
		$return .= '<input autocomplete="off" type="text" id="'.esc_attr($id).'" value="'.esc_attr($default).'" class="my-color-field" data-default-color="'.esc_attr($default).'" />';
		$return .= '<div class="element-description">'.stripslashes($description).'</div>';
		$return .= '<script type="text/javascript">
					jQuery(document).ready(function(){
				jQuery("#'.esc_attr($id).'").wpColorPicker();
			});

		</script>';	
		
		return $return;
	}
}




/*
**	Header for Rock Theme Optins
**
**	Only for the backend
*/
if(!function_exists('xr_make_header')){
	function xr_make_header($args = array()){
		extract($args);
		
		$return = '<div class="rockthemes-to-header-container">';		
		$return .= '<h2>'.stripslashes(esc_html($description)).'</h2>';
		$return .= '</div>';
		
		return $return;
	}
}



/*
**	Page List
**	
**	Displays all of the wordpress pages.
**
*/
if(!function_exists('xr_make_page_list')){
	function xr_make_page_list($args = array()){
		
		$default = '';
		
		extract($args);
		
		$default = esc_attr($default);

		$return = '<h3>'.esc_html($label).'</h3>';
		$mypages = get_pages();
		$return .= '<select id="'.esc_attr($id).'" autocomplete="off">';
		$return .= '<option value="" '.($default === '' ? 'selected' : '').'>No Page</option>';
		foreach($mypages as $page){     
			$return .= '<option value="'.$page->ID.'"';
			if ($page->ID == $default) {$return .= ' selected';}
			$return .= '>'.$page->post_title.'</option>';
		}
		$return .= '</select>';  
		$return .= '<div class="element-description">'.stripslashes($description).'</div>';
		$return .= '<div class="clear"></div>';

		return $return;
	}
}



/*
**	Font CSS Details Field
**
**	Contains font CSS Code and Font Size
*/
if(!function_exists('xr_make_font_option_field')){
	function xr_make_font_option_field($args = array()){

		extract($args);
		
		if(empty($default) || !isset($default['font_family'])){
			$default = array('font_family'=>'','font_size'=>'14px');
		}

		$return = '<h3>'.esc_html($label).'</h3>';
		
		$return .= '<div id="'.esc_attr($id).'" class="font_option_field row-fluid">';
			$return .= '
				<div class="span5">
					<strong>Font Family :</strong><br/>
					<input autocomplete="off" class="font_family" type="text" value="'.esc_attr(stripslashes($default['font_family'])).'" />
				</div>
				<div class="span2">
					<strong>Font Size :</strong><br/>
					<input autocomplete="off" class="font_size" type="text" value="'.esc_attr($default['font_size']).'" />
				</div>
			';
			
			$return .= '<div class="element-description span5">'.stripslashes($description).'. Make sure you use correct CSS codes for both font family and font size. Do not forget to add "px" for font size</div>';
		$return .= '</div>';
		

		return $return;
		
	}
}




/*
**	ROCKTHEMES PAGE BUILDER ELEMENTS
*/

/*
**	Social Icons
*/
if(!function_exists('xr_make_socialicons')){
	function xr_make_socialicons($args = array()){
		extract($args);

		$default = json_decode(($default),true);

		$return = '<h3>'.esc_html($label).'</h3>';
		$return .= '<div class="social_icons_class" ref="0">';
		$return .= '<input autocomplete="off" id="'.esc_attr($id).'" type="hidden" value="'.esc_attr(json_encode($default)).'" />';
		$return .= '<input autocomplete="off" id="'.esc_attr($id).'-shortcode" type="text" value="'.esc_attr($default['shortcode']).'" /><div class="button call_social_icons_external" id_ref="'.esc_attr($id).'-shortcode" id_data_ref="'.esc_attr($id).'">Add Social Icons</div>';
		$return .= '</div>';
		$return .= '<div class="clear"></div><br/>';
		$return .= '<div class="element-description-full">'.stripslashes($description).'</div>';
				
		return $return;
	}
}



/*
**	Server Details (Special Field)
*/
if(!function_exists('xr_make_server_details')){
	function xr_make_server_details($args = array()){

		if(!current_user_can('switch_themes')) return;
		
		extract($args);
		
		//Server details to display
		$config = array(
			//To display elements with different class
			'styles'	=>	array(
				'req'	=>	'required-value',
				'rec'	=>	'recommended-value',
				'low'	=>	'low-value'
			),
			
			'texts'		=>	array(
				'req'	=>	' - Recommended Value ',
				'rec'	=>	'',
				'low'	=>	' - You should increase this value to at least ',
				'error'	=>	'Could Not Get The Data',
			),
			
			'icons'		=>	array(
				'req'	=>	'<i class="fa fa-circle icon"></i>',
				'rec'	=>	'<i class="fa fa-check icon"></i>',
				'low'	=>	'<i class="fa fa-times icon"></i>',
			),
		
			'functions'	=>	array(
				array(
					'title'		=>	'Maximum Execution Time',
					'function'	=>	'ini_get',
					'fn'		=>	'max_execution_time',
					'req'		=>	'30seconds',
					'rec'		=>	'60seconds',
					'smack'		=>	'number'
				),
				
				array(
					'title'		=>	'PHP Memory Limit',
					'function'	=>	'ini_get',
					'fn'		=>	'memory_limit',
					'req'		=>	(int)(memory_get_usage() / (1024 * 1024)).'MB',
					'rec'		=>	'128MB',
					'smack'		=>	'number'
				),
				
				array(
					'title'		=>	'Wordpress Memory Limit',
					'function'	=>	'variable',
					'fn'		=>	'WP_MEMORY_LIMIT',
					'req'		=>	(int)(memory_get_usage() / (1024 * 1024)).'MB',
					'rec'		=>	'128MB',
					'smack'		=>	'number'
				),
			
				array(
					'title'		=>	'Maximum File Upload Size',
					'function'	=>	'ini_get',
					'fn'		=>	'upload_max_filesize',
					'req'		=>	'16M',
					'rec'		=>	'32M',
					'smack'		=>	'number'
				),
				
				array(
					'title'		=>	'Maximum Post File Size',
					'function'	=>	'ini_get',
					'fn'		=>	'post_max_size',
					'req'		=>	'8M',
					'rec'		=>	'16M',
					'smack'		=>	'number'
				),
			
				
				array(
					'title'		=>	'Maximum Input Variables',
					'function'	=>	'ini_get',
					'fn'		=>	'max_input_vars',
					'req'		=>	'3000',
					'rec'		=>	'4000',
					'smack'		=>	'number',
				),
				
			)
		);
		
		
		//Suhosin
		
		
		extract($config);
		
		$details = '';
		
		foreach($functions as $f){
			extract($f);
			switch($function){
				case 'ini_get':
				$val = ini_get($fn);
				if(!$val){
					$val = 	$texts['error'];
				}
				break;
				
				case 'variable':
				if(defined($fn)){
					$val = constant($fn);
				}else{
					continue;	
				}
				break;
			}
			
						
			$class = '';
			$smack_result = '';
			$value_smack_info = '';
			$smack_icon = '';
			//Smackdown Method
			switch($smack){
				case 'number':										
					if((int) $val >= (int)$rec){
						$smack_result = 'rec';
					}elseif((int)$val >= (int)$req){
						$smack_result = 'req';
					}else{
						$smack_result = 'low';
					}
				break;
			}
			

			//Attend smack results
			$class = $styles[$smack_result];
			$smack_icon = $icons[$smack_result];
			$value_smack_info = $texts[$smack_result];
			if($smack_result === 'low') $value_smack_info .= $req;
			if($smack_result === 'req') $value_smack_info .= $rec;
			
			$details .= '
			<div class="'.esc_attr($class).' row-fluid">
				<div class="span4 detail">
					'.$smack_icon.' '.$title.'
				</div>
				<div class="span8 val">
					'.$val.' '.$value_smack_info.'
				</div>
			</div>';
		}
		
		$upload_dir = wp_upload_dir();
		
		$return = '
		<div class="server_details_container" id="'.esc_attr($id).'">
			<h3>'.esc_attr($label).'</h3>
			<div class="element-description-full">'.esc_html(stripslashes($description)).'</div>
			<br/>
			<br/>
			'.$details.'
			<div class="recommended-value row-fluid">
				<div class="span4 detail">
					'.$icons['rec'].' Your Media Library URL
				</div>
				<div class="span8 val">
					'.$upload_dir['baseurl'].'
				</div>
			</div>

			<br/>
			<hr/>
			<br/>
			<br/>
			<h3>Understanding The Details</h3>
			<div class="row-fluid">
				<div class="span4 recommended-value">
					'.$icons['rec'].' Recommended Value
				</div>
				<div class="span4 required-value">
					'.$icons['req'].' Required Value
				</div>
				<div class="span4 low-value">
					'.$icons['low'].' Low Value
				</div>
			</div>
			<br/>
			<br/>
			<br/>
			<br/>
		</div>';
		
		return $return;
	}
}






if(!function_exists('xr_get_demo_list')):
/*
**	Demo System - Predefined Demo Lists
**
**	This will only return the demo list as array.
**
**	@since	:	1.3
*/
function xr_get_demo_list(){
	$demos = array(
		array(
			'id'				=>	'default', //Mostly same name with the dir_name
			'dir_name'			=>	'default', //Directory of the demo files
			'img_reference'		=>	'default.jpg', //Image for selector
			
			'xml_filename'		=>	'default.xml', //If not using default xml filename, use this
			'xr_filename'		=>	'default.txt', //If not using default xr theme options data, use this
			
			'details'			=>	array(
				array(
					'key'		=>	'Name',
					'val'		=>	'Azoom',
				),
				array(
					'key'		=>	'Width',
					'val'		=>	'1140px',
				),
				array(
					'key'		=>	'Description',
					'val'		=>	'Everything You Need',
				),
			),
		),
		
		array(
			'id'				=>	'allefty', //Mostly same name with the dir_name
			'dir_name'			=>	'allefty', //Directory of the demo files
			'img_reference'		=>	'allefty.jpg', //Image for selector
			
			'xml_filename'		=>	'allefty.xml', //If not using default xml filename, use this
			'xr_filename'		=>	'allefty.txt', //If not using default xr theme options data, use this
			
			'details'			=>	array(
				array(
					'key'		=>	'Name',
					'val'		=>	'Allefty',
				),
				array(
					'key'		=>	'Width',
					'val'		=>	'900px',
				),
				array(
					'key'		=>	'Description',
					'val'		=>	'Full of Article',
				),
			),
		),

		array(
			'id'				=>	'aparallax', //Mostly same name with the dir_name
			'dir_name'			=>	'aparallax', //Directory of the demo files
			'img_reference'		=>	'aparallax.jpg', //Image for selector
			
			'xml_filename'		=>	'aparallax.xml', //If not using default xml filename, use this
			'xr_filename'		=>	'aparallax.txt', //If not using default xr theme options data, use this
			
			'details'			=>	array(
				array(
					'key'		=>	'Name',
					'val'		=>	'Aparallax',
				),
				array(
					'key'		=>	'Width',
					'val'		=>	'1140px',
				),
				array(
					'key'		=>	'Description',
					'val'		=>	'Full of Parallax',
				),
			),
		),
		
		array(
			'id'				=>	'abboxed', //Mostly same name with the dir_name
			'dir_name'			=>	'abboxed', //Directory of the demo files
			'img_reference'		=>	'abboxed.jpg', //Image for selector
			
			'xml_filename'		=>	'abboxed.xml', //If not using default xml filename, use this
			'xr_filename'		=>	'abboxed.txt', //If not using default xr theme options data, use this
			
			'details'			=>	array(
				array(
					'key'		=>	'Name',
					'val'		=>	'Abboxed',
				),
				array(
					'key'		=>	'Width',
					'val'		=>	'960px',
				),
				array(
					'key'		=>	'Description',
					'val'		=>	'Boxed Layout',
				),
			),
		),
		
		
	);
	
	for($i = 0; $i < count($demos); $i++){
		if($demos[$i]['xml_filename'] === ''){
			$demos[$i]['xml_filename'] = 'demo.xml';	
		}
		
		if($demos[$i]['xr_filename'] === ''){
			$demos[$i]['xr_filename'] = 'xr_data.txt';	
		}
	}
	
	return $demos;
}
endif;




function xr_get_demo_list_selector_html($default = 'default'){
	$demos = xr_get_demo_list();
	
	$return = '';
	$return .= '<div id="demo_selector" class="image-select-list demo_selector">';
	$return .= '<div class="image-select-container">';
	
	foreach($demos as $demo){
		$demo_datas = '';
		foreach($demo as $key => $val){
			
			if($key === 'details') continue;
			
			$demo_datas .= 'data-'.esc_attr($key).'="'.esc_attr($val).'" ';		
		}
		
		if($demo['id'] == $default){
			$return .= '<div class="image-select-elem selected" '.$demo_datas.' value="'.esc_attr($demo['id']).'"><div class="demo-selector-image"><img src="'.OPTIONS_URI.'demos/'.$demo['dir_name'].'/'.$demo['img_reference'].'" alt="'.$demo['id'].'" /></div>';
		}else{
			$return .= '<div class="image-select-elem" '.$demo_datas.' value="'.esc_attr($demo['id']).'"><div class="demo-selector-image"><img src="'.OPTIONS_URI.'demos/'.$demo['dir_name'].'/'.$demo['img_reference'].'" alt="'.$demo['id'].'" /></div>';
		}
		
		$details = '<ul class="layout-details">';
		foreach($demo['details'] as $d){
			$details .= '<li class="layout-details-single"><span class="details-key">'.$d['key'].'</span><span class="details-val">'.$d['val'].'</span></li>';
		}
		$details .= '</ul>';
		
		$return .= $details;
		
		//Hover, Selected
		$return .= '<div class="demo-selected-overlay"><div class="demo-selected-text">SELECTED</div></div>';
		
		$return .= '</div>';//.image-select-elem
	}

	$return .= '<div class="clear"></div>';
	$return .= '</div>';
	$return .= '</div><br />';
	
	return $return;
}






/*
**	One Click Demo Install Field (Special Field)
**
**	Ajax side codes will be inside "options_loader.php" file
*/
if(!function_exists('xr_make_one_click_demo')){
	function xr_make_one_click_demo($args = array()){
		extract($args);
		
		$return = '<h3>'.esc_html($label).'</h3>';
		
		
		$return .= '
		<div class="xr_one_click_install_div">
			<a class="button button-primary button-hero start_one_click_install">Start Demo Installation</a>
			<br/><br/><br/>
			<div class="element-description-full">This will load all demo datas. You can select a demo below and click on "Start Demo Installation" button. Make sure you have installed all required plugins before installing demo data. If you have installed a demo data and want to install another, you should delete all contents from old installation.</div>
			<br/><br/><br/>
			'.xr_get_demo_list_selector_html().'
		</div>
		';
		
		
		$script = '
		<script type="text/javascript">
			jQuery(document).ready(function(){';
		
		
		$script .= '
				jQuery(document).on("click", ".start_one_click_install", function(e){
					e.preventDefault();
					if(jQuery(this).hasClass("installing")) return;
					
					var is_yes = confirm("Do you want to install demo data? (Make sure all required plugins are installed and activated before installing demo data)");
					
					if(is_yes){
						jQuery(this).addClass("installing");
						jQuery("body").append(jQuery("<div class=\"xroc_demo_overlay\" style=\"position:fixed;top:0px;left:0px;z-index:9999;width:100%;height:100%;background:rgba(0,0,0,0.01);\"></div>"));
						xroc_progress("step_0");
					}else{
						//Do Nothing	
					}
				});
				
				function xroc_notify(step){
					
					if(jQuery("#xroc_notify").length){
						var that = jQuery("#xroc_notify");
						that.find(".detail").html(step.text);
						return;
					}

					var notfy = "<div id=\"xroc_notify\" class=\"rpb_modal hide\" >"+
						"<div class=\"modal-body\">"+
							"<div class=\"xroc_modal_details\">"+
								"<h2>Installing...</h2>"+
								"<p class=\"detail\">"+step.text+"</p>"+
								"<div class=\"\" style=\"width: 100%; display:block\">"+
									"<div class=\"progress progress-striped active\" style=\"margin-bottom:0px;\">"+
										"<div class=\"bar\" style=\"width: 100%;\"></div>"+
									"</div>"+
								"</div>"+
							"</div>"+
							"<div class=\"xroc_modal_finished hide\" style=\"text-align:centered;\">"+
								"<h1><i class=\"fa fa-check\" style=\"color:#19E919;\"></i> Completed.</h1>"
							"</div>"+
						"</div>"+
					"</div>";

					jQuery("#modal-holder").append(notfy);
					jQuery("#xroc_notify").rpb_modal({width:400});
				}
				
				
				function xroc_progress(step){
					if(typeof step === "undefined") return;
					
					var xroc_steps = [
						{
							text:"Importing Frontend Datas",
							function:"import_xml"
						},
						{
							text:"Importing Backend Datas",
							function:"import_backend"
						},
						{
							text:"Configuring Wordpress Details",
							function:"import_wp_config"
						}
					];
					
					
					step = parseInt(step.replace("step_",""));
					var step_data = JSON.stringify(xroc_steps[step]);
					xroc_notify(xroc_steps[step]);
					var demo_details = jQuery("#demo_selector .image-select-elem.selected").length ? jQuery("#demo_selector .image-select-elem.selected").data() : jQuery("#demo_selector .image-select-elem").first().data();
					
					//console.log(step_data);
					//return;
					
					
					jQuery.post(ajaxurl, {action:"xr_one_click_demo_install", step_data:step_data, demo_details:demo_details}, function(data){
						//console.log(data);
						if(data && (data.indexOf("success") > -1) && (step  + 1 )< xroc_steps.length){
							//console.log("NEXT STEP");
							xroc_progress("step_"+(step+1));
							return;
						}else{
							var that = jQuery("#xroc_notify");
							that.find(".xroc_modal_details").hide();
							that.find(".xroc_modal_finished").show();
							setTimeout(function(){
								that.rpb_modal("hide");
								setTimeout(function(){
									that.remove();
									jQuery(".start_one_click_install").removeClass("installing");
									jQuery(".xroc_demo_overlay").remove();
								},1400);
							},1800);
							return;
						}
					});
					
				}
		';
		
		
		$script .= '
			});
		</script>';
		
		return $return.$script;

	}
}








/*
**	License Field (Special Field)
*/
if(!function_exists('xr_make_license')){
	function xr_make_license($args = array()){
		extract($args);
		
		$buyer = '';
		$activated_at = '';
		$activated_url = '';
		$purchase_code_entered_at = '';
				
		$default = json_decode(stripslashes($default),true);
		
		$current_theme = wp_get_theme();
		
		$backbone = json_decode(stripslashes(unserialize(get_option('html_backbone_moderation', false))),true);
		if($backbone && $backbone['data']) extract($backbone['data']);
		
		
		$return = '<div class="enter_purchase_code_container '.($buyer !== "" ? "hide" : "").'">';
		$return .= '<h3>'.esc_attr($label).'</h3>';
		$return .= '<input autocomplete="off" type="text" id="license_input" value="" /><div id="activate_license_code" class="button" >Activate Purchase Code</div>';
		$return .= '<div class="clear"></div>';
		$return .= '<br/>
					<br/>
					<div id="license_errors"></div>
					<strong style="color:#FF0000;">!Important</strong>
					<p>If this is your testing server, do not enter your purchase code. Purchase code can only be used in one site and can not be removed. But if this is your demo server for your clients, you can enter your Purchase Code. When you will move your site to your clients domain you can contact us to migrate your license.</p>
					<br/>
					<br/>
					<strong style="color:#FF0000;">!Important</strong>
					<p>Make sure you are not using child theme when entering Purchase Code. If you are using child theme, switch to main Quasar Theme before entering Purchase Code</p>
					<br/>
					<br/>
					<h3 class="purchase_code_howto_title">How to get your Purchase Code?</h3>
					<div class="purchase_code_howto_image image_nocode_container">
						<img src="'.OPTIONS_URI.'images/purchase_code.png" />
					</div>
					<p class="purchase_code_howto_desc">To get your purchase code, login to your Themeforest Account and follow these steps :</p>
					<ul class="license-description-list">
						<li>Go To Downloads</li>
						<li>You will see the "Download" button next to our theme icon, click on it</li>
						<li>When you click to "Download" you will see different options, click on "License certificate & purchase code"</li>
						<li>Download the file</li>
						<li>Open the downloaded file with your favorite text editor</li>
						<li>You will see "Item Purchase Code:", copy that code</li>
						<li>And now you can paste your purchase code here</li>
					</ul>
					<br/>
					<p><strong>Purchase Code Format Example : </strong></p>
					<p>aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee</p>
					<br/>
					';
		
		$return .= '</div>';
		

		//Licensed item details
		$return .= '
			<div class="licensed_to_container '.($buyer === "" ? "hide" : "").'">
				<h3>License Information</h3>
				<div class="row-fluid">
					<div class="span3">
						<strong>Licensed To : </strong>
					</div>
					<div class="span9">
						<span class="licensed_to">'.$buyer.'</span>
					</div>
				</div>
				<div class="row-fluid">
					<div class="span3">
						<strong>For : </strong>
					</div>
					<div class="span9">
						<span class="licensed_for">'.$activated_url.'</span>
					</div>
				</div>
				<div class="row-fluid">
					<div class="span3">
						<strong>At : </strong>
					</div>
					<div class="span9">
						<span class="licensed_at">'.$purchase_code_entered_at.'</span>
					</div>
				</div>
				<div class="row-fluid">
					<div class="large-12">
						<br/><br/>
						<p>If you have entered your Purchase Code on wrong domain or you want to change your domain, you can contact us to migrate your Purchase Code when you move your site to your new/final domain</p>
						<a class="reenter_purcase_code" style="cursor:pointer;">Re-Enter Purchase Code</a>
					</div>
				</div>
			</div>
		';			
					
		$script = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					
					jQuery(document).on("click", ".reenter_purcase_code", function(){
						jQuery(".purchase_code_howto_image, .license-description-list, .purchase_code_howto_title, .purchase_code_howto_desc").addClass("hide");
						jQuery(".enter_purchase_code_container.hide").removeClass("hide");
					});
					
					function substr_replace (str, replace, start, length) {
					  if (start < 0) { // start position in str
						start = start + str.length;
					  }
					  length = length !== undefined ? length : str.length;
					  if (length < 0) {
						length = length + str.length - start;
					  }
					  return str.slice(0, start) + replace.substr(0, length) + replace.slice(length) + str.slice(start + length);
					}			
					
					
					var user_try = 0;
					jQuery(document).on("click", "#activate_license_code", function(){
						
						//If already on progress stop the function and remove the icon
						if(jQuery(this).find(".fa fa-refresh").length){
							jQuery(this).find(".fa fa-refresh").remove();
							return;
						}
						
						//If no purchase code entered, return
						if(jQuery("#license_input").val() == ""){ return alert("Enter a Purchase Code");}
						
						//Add loading icon
						var button_text = jQuery(this).html();
						button_text += " <i class=\"fa fa-refresh fa-spin\"></i>";
						jQuery(this).html(button_text);
						
						
						jQuery.post(ajaxurl, {action:"theme_license_total_try"}, function(data){
							user_try = data.try;
							if(data.try >  10){
								jQuery("#activate_license_code").find(".fa fa-refresh").remove();
								jQuery("#license_errors").html("");
								alert("You have reached to maximum limit for wrong codes\n10 Wrong Purchase Code\n\nPlease try again later with a valid purchase code");	
							}else{
								on_activate_click();
							}
						});
					});
							
					function on_activate_click(){
						
						var data = new Object();
						
						data.purchase_code = jQuery("#license_input").val();
						data.url = window.location.host;
						data.theme = "'.$current_theme->name.'"
						//http://rockthemes.net/theme_license/license_control.php
						jQuery.post("http://rockthemes.net/theme_license/license_control.php", 
									{data:JSON.stringify(data)},
						function(data){
							jQuery("#activate_license_code").find(".fa fa-refresh").remove();
							jQuery("#license_errors").html("");
														
							try{
								data = JSON.parse(data);	
							}catch(e){
								//Do nothing	
							}
							
							if(data){
								//data = JSON.parse(data);
								if(data.error){
									var try_left;
									if(data.error == "maximum_wrong_code"){
										alert("You have reached to maximum limit for wrong codes\n10 Wrong Purchase Code\n\nPlease try again later with a valid purchase code");	
									}else if(data.error == "wrong_code_limit"){
										data.try = user_try;

										if(data.try && data.try >= 8){
											try_left = 10 - parseInt(data.try);
											jQuery("#license_errors").html("Purchase code you have entered is not valid. Limit left :"+try_left+"<br/><br/>");
										}else{
											jQuery("#license_errors").html("Purchase code you have entered is not valid. Make sure you have entered your Purchase Code correctly.<br/><br/>");
										}
									}else if(data.error == "purchase_code_in_use"){
										data.try = user_try
										try_left = 10 - parseInt(data.try);
										var error_message = "Purchase code you have entered is registered to another domain. Please Enter your valid Purchase Code.";
										if(try_left <= 3){
											error_message += " Limit left :"+try_left+"<br/><br/>";
										}else{
											error_message += "<br/><br/>";
										}
										jQuery("#license_errors").html(error_message);
									}else if(data.error == "wrong_item_name"){
										data.try = user_try;
										try_left = 10 - parseInt(data.try);
										var error_message = "Purchase code you have entered does not belong to your current theme.";
										if(try_left <= 3){
											error_message += " Limit left :"+try_left+"<br/><br/>";
										}else{
											error_message += "<br/><br/>";
										}
										jQuery("#license_errors").html(error_message);
									}
								}else if(data.success){
									jQuery.post(ajaxurl, {data:JSON.stringify(data), action:"backbone_core"}, function(backbone_data){										
										if(backbone_data == "success"){
											jQuery(".licensed_to_container").find(".licensed_to").html(data.data.buyer);
											jQuery(".licensed_to_container").find(".licensed_for").html(data.data.activated_url);
											jQuery(".licensed_to_container").find(".licensed_at").html(data.data.purchase_code_entered_at);
											
											jQuery(".enter_purchase_code_container").hide();
											jQuery(".licensed_to_container").removeClass("hide").fadeIn();
										}else{
											alert("An error occured during the mysql connection to "+window.location.host+backbone_data);	
										}
									});
									
								}
							}
						}).fail(function(){
							jQuery("#activate_license_code").find(".fa fa-refresh").remove();
							alert("Connection to the server could not be established. Please try again later.");
						});
					};
					
				});
			</script>
		';
				
		return $return.$script;
	}
}







/* This function finds the element type and calls it's function
** 
*/
if(!function_exists('xr_find_element')){
	function xr_find_element($elem){
		$function_name = 'xr_make_'.$elem['type'];
		if(function_exists($function_name)){
			return $function_name($elem);
		}else{
			return '';	
		}
	}
}


?>