<?php

$rockthemes_to_default_options = array(
	array(
		'category_name' => 'General Settings',
		'category_id'	=> 'general_settings',
		'class'			=> '',
		'elements'		=> array(
		
			array(
				'label'			=> 'One Click Demo Installation',
				'id'			=> 'one_click_demo_install',
				'type'			=> 'one_click_demo',
				'is_hidden'		=> 'false',
				'description'	=> '',
				'choices'		=> '',
				'default'		=> ''
			),
		
			array(
				'label'			=> 'Company Logo',
				'id'			=> 'company_logo',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'description'	=> 'Upload your company logo. If you want to use your site title instead of logo, leave this area empty.',
				'choices'		=> '',
				'default'		=> F_WAY.'/images/demo/azoom-wordpress-business-theme.png'
			),
						
			array(
				'label'			=> 'Company Logo Retina',
				'id'			=> 'company_logo_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'description'	=> 'If you are using retina plugin, upload your company logo retina size. You should name your logo with @2x. For example, if your originial logo named as "company_logo.png" your retina logo should be named as "company_logo@2x.png".',
				'choices'		=> '',
				'default'		=> F_WAY.'/images/demo/azoom-wordpress-business-theme@2x.png'
			),
			
			array(
				'label'			=> 'Logo Width',
				'id'			=> 'logo_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Your logo\'s regular width',
				'choices'		=> '',
				'default'		=> '250px'
			),
			
			array(
				'label'			=> 'Logo Height',
				'id'			=> 'logo_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Your logo\'s regular height',
				'choices'		=> '',
				'default'		=> '60px'
			),

			array(
				'label'			=> 'Company Sticky Logo',
				'id'			=> 'company_sticky_logo',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'description'	=> 'Upload your company sticky logo.',
				'choices'		=> '',
				'default'		=> F_WAY.'/images/demo/azoom-wp-theme-sticky.png'
			),
						
			array(
				'label'			=> 'Company Sticky Logo Retina',
				'id'			=> 'company_sticky_logo_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'description'	=> 'If you are using retina plugin, upload your company logo retina size. You should name your logo with @2x. For example, if your originial logo named as "company_logo.png" your retina logo should be named as "company_logo@2x.png".',
				'choices'		=> '',
				'default'		=> F_WAY.'/images/demo/azoom-wp-theme-sticky@2x.png'
			),
			
			array(
				'label'			=> 'Sticky Logo Width',
				'id'			=> 'sticky_logo_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Your logo\'s regular width',
				'choices'		=> '',
				'default'		=> '225px'
			),
			
			array(
				'label'			=> 'Sticky Logo Height',
				'id'			=> 'sticky_logo_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Your logo\'s regular height',
				'choices'		=> '',
				'default'		=> '23px'
			),
						
			array(
				'label'			=> 'Header Regular Line Height',
				'id'			=> 'header_regular_line_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a px value for your header line height. Mostly a 3px bigger than logo height.',
				'choices'		=> '',
				'default'		=> '98px'
			),
			
			array(
				'label'			=> 'Header Sticky Line Height',
				'id'			=> 'header_sticky_line_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a px value for your header sticky line height. Mostly 3px bigger than logo sticky height.',
				'choices'		=> '',
				'default'		=> '50px'
			),
			
			array(
				'label'			=> 'Logo Regular Line Height',
				'id'			=> 'logo_regular_line_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a px value for your header line height. Mostly the same value of Header Regular Line Height',
				'choices'		=> '',
				'default'		=> '98px'
			),
			
			array(
				'label'			=> 'Logo Sticky Line Height',
				'id'			=> 'logo_sticky_line_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a px value for your header sticky line height. Mostly the same value of Header Sticky Line Height',
				'choices'		=> '',
				'default'		=> '50px'
			),
		
			array(
				'label'			=> 'Company Logo Favico',
				'id'			=> 'company_logo_favicon',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'description'	=> 'Upload your .ico file of your logo here.',
				'choices'		=> '',
				'default'		=> F_WAY.'/images/demo/favico.ico'
			),
			
			array(
				'label'			=> 'Default Items Page',
				'id'			=> 'default_products_page',
				'type'			=> 'page_list',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'false',
				'description'	=> 'Choose your Default Items page for improved SEO and Breadcrumbs',
				'choices'		=> '',
				'default'		=> ''
			),
			
		
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Advanced Style',
			),
		
			array(
				'label'			=> 'Your Extra CSS Code',
				'id'			=> 'extra_css_code',
				'type'			=> 'text_area',
				'is_hidden'		=> 'false',
				'is_validate'	=> 'wp_kses_post',
				'is_translate'	=> 'false',
				'description'	=> 'If you want to change some styles or add some extra CSS code, enter those codes here.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Go To Top Button',
			),
			
			array(
				'label'			=> 'Enable Go To Top Button',
				'id'			=> 'enable_gototop',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you enable go to top button, a button will be displayed for going to top of the page.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Background Color of Go To Top Button',
				'id'			=> 'gototop_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Set a background color for go to top button',
				'choices'		=> '',
				'default'		=> '#c5cdd1'
			),
			
			array(
				'label'			=> 'Icon Color of Go To Top Button',
				'id'			=> 'gototop_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Set icon color for go to top button',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Display Go To Top with Inline Navigation',
				'id'			=> 'enable_gototop_with_rin',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'By default, if inline navigation is enabled, go to top button will not be displayed. You can choose to display go to top button with inline navigation.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Miscellaneous',
			),
			
			array(
				'label'			=> 'Activate Smooth Scroll',
				'id'			=> 'activate_smooth_scroll',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can activate/deactivate the smooth scroll effect. Smooth scroll effect works perfectly on most of the desktops but may cause fast sliding on touch based mouses.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Enable Smooth Scroll Style',
				'id'			=> 'nicescroll_style_enabled',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" the default scrollbar will be removed and a new styled scrollbar will be displayed',
				'choices'		=> '',
				'default'		=> 'NO'
			),
					
		)
	),
		
	array(
		'category_name' => 'Reading',
		'category_id'	=> 'reading_settings',
		'class'			=> '',
		'elements'		=> array(
		
			array(
				'label'			=> 'Blog, Archive Summary',
				'id'			=> 'post_summary',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'Blog and arhive summary will display excerpt or the content?',
				'choices'		=> array(
					array(
						'text'	=> 'Display Excerpt',
						'value'	=> 'excerpt',
					),
					array(
						'text'	=> 'Display Content',
						'value'	=> 'content',
					)
				
				),
				'default'		=> 'content'
			),
						
			array(
				'label'			=> 'Show Post Name on Title',
				'id'			=> 'show_post_name_on_title',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to display post title in the breadcrumbs title area, choose "YES". Choosing this option will display same title in the breadcrumbs area and in the top of the post.',
				'choices'		=> '',
				'default'		=> 'FALSE'
			),
			
			array(
				'label'			=> 'Display Blog Link in Breadcrumbs',
				'id'			=> 'blog_link_in_breadcrumbs',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to display Blog link in the breadcrumbs choose "YES".',
				'choices'		=> '',
				'default'		=> 'FALSE'
			),
			
			array(
				'label'			=> 'Activate Comments on Pages?',
				'id'			=> 'activate_comments_on_pages',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to activate comments on pages, choose "YES". This option will only effect to regular pages.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Activate Comments on Default Products?',
				'id'			=> 'activate_comments_on_default_products',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to activate comments on Default Products, choose "YES". This option will only effect to Default Product pages.',
				'choices'		=> '',
				'default'		=> 'FALSE'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Post Details',
			),
			
			array(
				'label'			=> 'Post View',
				'id'			=> 'blog_single_feature_view',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Enable Post View',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Post Like',
				'id'			=> 'blog_single_feature_love',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Enable Like Icons',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Post Format',
				'id'			=> 'blog_single_feature_format',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Enable Post Format Icon',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Social Icons',
			),
			
			array(
				'label'			=> 'Facebook',
				'id'			=> 'blog_single_share_facebook',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Enable Facebook icon under single posts',
				'choices'		=> '',
				'default'		=> 'YES'
			),

			array(
				'label'			=> 'Twitter',
				'id'			=> 'blog_single_share_twitter',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Enable Twitter icon under single posts',
				'choices'		=> '',
				'default'		=> 'YES'
			),

			array(
				'label'			=> 'Google+',
				'id'			=> 'blog_single_share_google',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Enable Google+ icon under single posts',
				'choices'		=> '',
				'default'		=> 'NO'
			),

			array(
				'label'			=> 'Pinterest',
				'id'			=> 'blog_single_share_pinterest',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Enable Pinterest icon under single posts',
				'choices'		=> '',
				'default'		=> 'YES'
			),

		),
	),	
	
	array(
		'category_name' => 'Archive Settings',
		'category_id'	=> 'archive_settings',
		'class'			=> '',
		'elements'		=> xr_ds_archive_layout_selection(),
	),

	
	array(
		'category_name' => 'Typography Settings',
		'category_id'	=> 'typography_settings',
		'class'			=> '',
		'elements'		=> array(
			array(
				'label'			=> 'Enter Your Google Font Standard Code',
				'id'			=> 'google_font_standard_code',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Enter the Google Font Standard Code to use a Google Font. You can find your font standard code in "Use" section at step "3. Add this code to your website:"',
				'choices'		=> '',
				'default'		=> '<link href="http://fonts.googleapis.com/css?family=Titillium+Web:400,200,200italic,300,300italic,400italic,600,700" rel="stylesheet" type="text/css">',
			),
			
			array(
				'label'			=> 'Enter Your Typekit Code',
				'id'			=> 'typekit_font_code',
				'type'			=> 'text_field',
				'is_validate'	=> 'wp_kses_post',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'If you want to use Adobe Typekit fonts, enter the code given by Typkit',
				'choices'		=> '',
				'default'		=> '',
			),
			
			array(
				'label'			=> 'Site Default Font Details',
				'id'			=> 'site_default_font_details',
				'type'			=> 'font_option_field',
				'is_hidden'		=> 'false',
				'is_validate'	=> 'wp_kses',
				'hidden_val'	=> '',
				'description'	=> 'This font rule will apply all of the regular fields.',
				'choices'		=> '',
				'default'		=> array(
					'font_family'	=>	'font-family: "Titillium Web", sans-serif;',
					'font_size'		=>	"16px",
				),
			),
			
			array(
				'label'			=> 'Site Heading Font Family',
				'id'			=> 'site_heading_font_family',
				'type'			=> 'text_field',
				'is_validate'	=> 'wp_kses',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'This font rule will apply all of the headings.',
				'choices'		=> '',
				'default'		=> 'font-family: "Titillium Web", sans-serif;',
			),
			
			array(
				'label'			=> 'Menu Font Family',
				'id'			=> 'menu_font_family',
				'type'			=> 'text_field',
				'is_validate'	=> 'wp_kses',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Enter the font family of the menu',
				'choices'		=> '',
				'default'		=> 'font-family: "Titillium Web", sans-serif;',
			),
			
			array(
				'label'			=> 'Menu Font Size',
				'id'			=> 'main_nav_font_size',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Enter a "px" value for the menu font size.',
				'choices'		=> '',
				'default'		=> '14px',
			),
			
			array(
				'label'			=> 'Menu Font Weight',
				'id'			=> 'main_nav_font_weight',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Main Navigation Font Weight',
				'choices'		=> array(
					array('text' => 'Default', 'value'=>'inherit'),
					array('text' => '100', 'value'=>'100'),
					array('text' => '200', 'value'=>'200'),
					array('text' => '300', 'value'=>'300'),
					array('text' => '400', 'value'=>'400'),
					array('text' => '500', 'value'=>'500'),
					array('text' => '600', 'value'=>'600'),
					array('text' => '700', 'value'=>'700'),
					array('text' => '800', 'value'=>'800'),
					array('text' => '900', 'value'=>'900'),
					array('text' => 'bold', 'value'=>'bold')
				),
				'default'		=> 'inherit'
			),
			
			array(
				'label'			=> 'Sub Menu Font Weight',
				'id'			=> 'main_nav_sub_font_weight',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Main Navigation Sub Menu Font Weight',
				'choices'		=> array(
					array('text' => 'Default', 'value'=>'inherit'),
					array('text' => '100', 'value'=>'100'),
					array('text' => '200', 'value'=>'200'),
					array('text' => '300', 'value'=>'300'),
					array('text' => '400', 'value'=>'400'),
					array('text' => '500', 'value'=>'500'),
					array('text' => '600', 'value'=>'600'),
					array('text' => '700', 'value'=>'700'),
					array('text' => '800', 'value'=>'800'),
					array('text' => '900', 'value'=>'900'),
					array('text' => 'bold', 'value'=>'bold')
				),
				'default'		=> 'inherit'
			),
			
			array(
				'label'			=> 'Sub Menu Font Size',
				'id'			=> 'main_nav_sub_font_size',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Enter a "px" value for the sub menu font size.',
				'choices'		=> '',
				'default'		=> '14px',
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Side / Mobile Menu',
			),
			
			array(
				'label'			=> 'Mobile Menu Font Details',
				'id'			=> 'mobile_menu_font_details',
				'type'			=> 'font_option_field',
				'is_validate'	=> 'wp_kses',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'This font rule will apply to mobile/side menu',
				'choices'		=> '',
				'default'		=> array(
					'font_family'	=>	'font-family: "Titillium Web", sans-serif;',
					'font_size'		=>	"14px",
				),
			),
			
			array(
				'label'			=> 'Mobile Menu Font Weight',
				'id'			=> 'mobile_menu_font_weight',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'When site is viewed in the small screens, block grids will change their number. You can choose how may blocks will be shown for each row.',
				'choices'		=> array(
					array('text' => 'Default', 'value'=>'inherit'),
					array('text' => '100', 'value'=>'100'),
					array('text' => '200', 'value'=>'200'),
					array('text' => '300', 'value'=>'300'),
					array('text' => '400', 'value'=>'400'),
					array('text' => '500', 'value'=>'500'),
					array('text' => '600', 'value'=>'600'),
					array('text' => '700', 'value'=>'700'),
					array('text' => '800', 'value'=>'800'),
					array('text' => '900', 'value'=>'900'),
					array('text' => 'bold', 'value'=>'bold')
				),
				'default'		=> 'inherit'
			),
			
			array(
				'label'			=> 'Mobile Menu Title Font Size',
				'id'			=> 'mobile_menu_title_font_size',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Enter a "px" value for the title size of mobile menu',
				'choices'		=> '',
				'default'		=> '16px',
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'General',
			),
			
			array(
				'label'			=> 'All Font Families',
				'id'			=> 'site_all_font_families',
				'type'			=> 'text_area',
				'is_validate'	=> 'wp_kses_post',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'If you want to use your fonts in Text Editor, enter your font families here as regular CSS code. (i.e. font-family:Arial)',
				'choices'		=> '',
				'default'		=> 'font-family: "PT Sans Narrow", sans-serif; font-family: "Titillium Web", sans-serif;',
			),
			
			array(
				'label'			=> 'Activate Font Load System',
				'id'			=> 'font_loading_active',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'hidden_val'	=> 'YES',
				'description'	=> 'If you choose "YES", site will wait for the fonts to be loaded before displaying. Nice for visuality. We advise this for companies but if you are running a blog and you want to display your content directly without care of font change, you may choose "NO"',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Font Icon Libraries',
			),

			array(
				'label'			=> 'Enable Font Awesome Icons',
				'id'			=> 'enable_fontawesome',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can choose to use Font Awesome Icon Library. Every icon library will increase the total size of the site.',
				'choices'		=> '',
				'default'		=> 'NO'
			),

			array(
				'label'			=> 'Enable Stroke 7 Icon Font Set',
				'id'			=> 'enable_pestroke7',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can choose to use Pixeden Stroke 7 Icon Library. Every icon library will increase the total size of the site.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
		),
	),	
	

	array(
		'category_name' => 'Color Settings',
		'category_id'	=> 'color_settings',
		'class'			=> '',
		'elements'		=> array(
		
			array(
				'label'			=> 'Main Color',
				'id'			=> 'site_general_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Main color of the site. This color will be the main color that will attend to menus, buttons, links etc.',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Hover Color Default',
				'id'			=> 'hover_color_default',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Portfolio elements, blogs and some elements are using hover effect. This is default hover effect color.',
				'choices'		=> '',
				'default'		=> '#324864'
			),
			
			array(
				'label'			=> 'Hover Color Opacity',
				'id'			=> 'hover_color_opacity',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a value between 0 to 100 for hover effect background color opacity.',
				'choices'		=> '',
				'default'		=> '80'
			),
			
			array(
				'label'			=> 'Main Color Dark',
				'id'			=> 'site_general_color_dark',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Dark version of main color.',
				'choices'		=> '',
				'default'		=> '#152840'
			),
			
			array(
				'label'			=> 'Main Color Medium',
				'id'			=> 'site_main_color_medium',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'This is a medium level color. Not dark not light.',
				'choices'		=> '',
				'default'		=> '#c5cdd1'
			),
					
			array(
				'label'			=> 'Default Text Color',
				'id'			=> 'default_text_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default text color',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Link Color',
				'id'			=> 'a_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Regular link color (a tag color)',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Link Hover Color',
				'id'			=> 'a_link_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Link hover color (a:hover tag color). Usually the same color with Main Color',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Blog Post Type Icon Color',
				'id'			=> 'blog_post_type_icon_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose the color of blog post type icon',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Elements with Boxed Layout',
			),
			
			array(
				'label'			=> 'Boxed Layout Background',
				'id'			=> 'boxed_layout_element_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of boxed layouts for elements',
				'choices'		=> '',
				'default'		=> '#f9f9f9'
			),
			
			array(
				'label'			=> 'Boxed Layout Text Color',
				'id'			=> 'boxed_layout_text_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Text color of the content in the boxed layout',
				'choices'		=> '',
				'default'		=> '#666666'
			),
			
			
			array(
				'label'			=> 'Boxed Layout Link Color',
				'id'			=> 'boxed_layout_a_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Boxed layout\'s link color (a tag color)',
				'choices'		=> '',
				'default'		=> '#666666'
			),
			
			array(
				'label'			=> 'Boxed Layout Link Hover Color',
				'id'			=> 'boxed_layout_a_link_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Boxed Layout\'s hover color (a:hover tag color). Usually the same color with the main color',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Font Colors',
			),
			
			array(
				'label'			=> 'General Font Color',
				'id'			=> 'general_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'General font color of the site',
				'choices'		=> '',
				'default'		=> '#333'
			),
			
			array(
				'label'			=> 'Light Font Color',
				'id'			=> 'rsg_light_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Special Grid light font color',
				'choices'		=> '',
				'default'		=> '#f0f0f0'
			),
			
			array(
				'label'			=> 'H1 Color',
				'id'			=> 'font_h1_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Color of h1 tag',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			
			array(
				'label'			=> '404 Heading and Description Color',
				'id'			=> '404_heading_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Color of heading and the main description of 404 page',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'H2 Color',
				'id'			=> 'font_h2_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Color of h2 tag',
				'choices'		=> '',
				'default'		=> '#787878'
			),

			array(
				'label'			=> 'H3 Color',
				'id'			=> 'font_h3_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Color of h3 tag',
				'choices'		=> '',
				'default'		=> '#787878'
			),

			array(
				'label'			=> 'H4 Color',
				'id'			=> 'font_h4_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Color of h4 tag',
				'choices'		=> '',
				'default'		=> '#787878'
			),

			array(
				'label'			=> 'H5 Color',
				'id'			=> 'font_h5_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Color of h5 tag',
				'choices'		=> '',
				'default'		=> '#787878'
			),

			array(
				'label'			=> 'H6 Color',
				'id'			=> 'font_h6_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Color of h6 tag',
				'choices'		=> '',
				'default'		=> '#787878'
			),
								
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Iconic Text Colors',
			),
			
			array(
				'label'			=> 'Iconic Text Icon Box Default Color',
				'id'			=> 'iconic_text_icon_box_default_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default color of the iconic text element icon box.',
				'choices'		=> '',
				'default'		=> '#4fc6f8'
			),
			
			array(
				'label'			=> 'Iconic Text Icon Box Hover Color',
				'id'			=> 'iconic_text_icon_box_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Hover color of the iconic text element icon box.',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Iconic Text Icon Default Color',
				'id'			=> 'iconic_text_icon_default_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default color of the iconic text element icon.',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Iconic Text Icon Hover Color',
				'id'			=> 'iconic_text_icon_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default color of the iconic text element icon hover.',
				'choices'		=> '',
				'default'		=> '#F9F9F9'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Heading Element Default Colors',
			),
			
			array(
				'label'			=> 'Heading Element Bold Text Color',
				'id'			=> 'heading_bold_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default color of the heading element bold text',
				'choices'		=> '',
				'default'		=> '#152840'
			),
			
			array(
				'label'			=> 'Heading Element Light Text Color',
				'id'			=> 'heading_light_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default color of the heading element light text',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Heading Element Description Text Color',
				'id'			=> 'heading_desc_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default color of the heading element description text',
				'choices'		=> '',
				'default'		=> '#a5a7a8'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Miscellaneous Element Colors',
			),
			
			array(
				'label'			=> 'Tabs & Toggles Light Background',
				'id'			=> 'tabs_toggles_bg_light_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Light background color of the tabs and toggles elements.',
				'choices'		=> '',
				'default'		=> '#fff'
			),
			
			array(
				'label'			=> 'Tabs & Toggles Dark Background',
				'id'			=> 'tabs_toggles_bg_dark_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Dark background color of the tabs and toggles elements.',
				'choices'		=> '',
				'default'		=> '#f9f9f9'
			),
			
			array(
				'label'			=> 'Tabs & Toggles Border Color',
				'id'			=> 'tabs_toggles_border_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Border color of the tabs and toggles',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Tabs & Toggles Default Header Text Color',
				'id'			=> 'tabs_toggles_header_default_text_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default font color of the tabs and toggles element header.',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Tabs & Toggles Hover Header Text Color',
				'id'			=> 'tabs_toggles_header_hover_text_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Hover font color of the tabs and toggles element header.',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Tabs & Toggles Active Header Text Color',
				'id'			=> 'tabs_toggles_header_active_text_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Active font color of the tabs and toggles element header.',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Tabs & Toggles Boxed Hover & Active Header Text Color',
				'id'			=> 'tabs_toggles_boxed_header_hover_text_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Hover and active font color of the tabs and toggles element header.',
				'choices'		=> '',
				'default'		=> '#ffffff'
			),
			
			array(
				'label'			=> 'Pricing Table Heading Background',
				'id'			=> 'pricing_table_heading_bg',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of the pricing table heading',
				'choices'		=> '',
				'default'		=> '#324864'
			),
			
			array(
				'label'			=> 'HR Default Color',
				'id'			=> 'hr_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Default color of HR (horizontal rule) element',
				'choices'		=> '',
				'default'		=> '#c5cdd1'
			),
			
		)
	),
	
	
	array(
		'category_name' => 'Image Settings',
		'category_id'	=> 'image_settings',
		'class'			=> '',
		'elements'		=> array(
		
			//General Small Image Width and Height
			array(
				'label'			=> 'General Small Image Width',
				'id'			=> 'rockthemes_small_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the general small image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '100px'
			),
			
			array(
				'label'			=> 'General Small Image Height',
				'id'			=> 'rockthemes_small_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the general small image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '100px'
			),
		

			//General Thumbnail Image Width and Height
			array(
				'label'			=> 'General Thumbnail Image Width',
				'id'			=> 'rockthemes_thumbnail_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the general thumbnail image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '200px'
			),
			
			array(
				'label'			=> 'General Thumbnail Image Height',
				'id'			=> 'rockthemes_thumbnail_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the general thumbnail image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '150px'
			),
			
			//General Medium Image Width and Height
			array(
				'label'			=> 'General Medium Image Width',
				'id'			=> 'rockthemes_medium_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the general medium image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '540px'
			),
			
			array(
				'label'			=> 'General Medium Image Height',
				'id'			=> 'rockthemes_medium_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the general medium image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '405px'
			),
			
			//General Large Image Width and Height
			array(
				'label'			=> 'General Large Image Width',
				'id'			=> 'rockthemes_large_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the general large image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '720px'
			),
			
			array(
				'label'			=> 'General Large Image Height',
				'id'			=> 'rockthemes_large_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the general large image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '540px'
			),
			
			
			//General Featured Image Width and Height
			array(
				'label'			=> 'General Featured Image Width',
				'id'			=> 'rockthemes_featured_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the general featured image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '1140px'
			),
			
			array(
				'label'			=> 'General Featured Image Height',
				'id'			=> 'rockthemes_featured_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the general featured image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '400px'
			),
			
			
			//General Featured Image Width and Height
			array(
				'label'			=> 'Grid Background Image Width',
				'id'			=> 'grid_background_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Width of the grid backgrounds. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '1440px'
			),
			
			array(
				'label'			=> 'Grid Background Image Height',
				'id'			=> 'grid_background_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Height of the grid backgrounds. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '1080px'
			),
						
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Masonry Mode Details',
			),
			
			array(
				'label'			=> 'Enable Masonry Image Size',
				'id'			=> 'masonry_enable_image_size',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Masonry mode allows you to use different image sizes like "Wide, Tall, Wide & Tall". If you want to use these different sizes, enable this feature.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Masonry Image Regular Width',
				'id'			=> 'masonry_image_size_regular_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the masonry default image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '480px'
			),
			
			array(
				'label'			=> 'Masonry Image Regular Height',
				'id'			=> 'masonry_image_size_regular_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the masonry default image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '360px'
			),
			
			array(
				'label'			=> 'Masonry Image Wide Width',
				'id'			=> 'masonry_image_size_wide_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the masonry wide image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '960px'
			),
			
			array(
				'label'			=> 'Masonry Image Wide Height',
				'id'			=> 'masonry_image_size_wide_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the masonry wide image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '360px'
			),
			
			array(
				'label'			=> 'Masonry Image Tall Width',
				'id'			=> 'masonry_image_size_tall_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the masonry tall image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '480px'
			),
			
			array(
				'label'			=> 'Masonry Image Tall Height',
				'id'			=> 'masonry_image_size_tall_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the masonry tall image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '720px'
			),
			
			
			array(
				'label'			=> 'Masonry Image Wide & Tall Width',
				'id'			=> 'masonry_image_size_widetall_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the masonry wide & tall image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '960px'
			),
			
			array(
				'label'			=> 'Masonry Image Wide & Tall Height',
				'id'			=> 'masonry_image_size_widetall_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the masonry wide & tall image. Do not forget to add "px". For example : 4px',
				'choices'		=> '',
				'default'		=> '720px'
			),
					
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Hover Effect Size',
			),
			
			array(
				'label'			=> 'Hover Large Minimum Width',
				'id'			=> 'hover_width_min_large',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a minimum width value for the hover effect large. Do not add px. (i.e. 300)',
				'choices'		=> '',
				'default'		=> '250'
			),
			
			array(
				'label'			=> 'Hover Large Minimum Height',
				'id'			=> 'hover_height_min_large',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a minimum height value for the hover effect large. Do not add px. (i.e. 225)',
				'choices'		=> '',
				'default'		=> '225'
			),
			
			array(
				'label'			=> 'Hover Medium Minimum Width',
				'id'			=> 'hover_width_min_medium',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a minimum width value for the hover effect medium. Do not add px. (i.e. 160)',
				'choices'		=> '',
				'default'		=> '160'
			),
			
			array(
				'label'			=> 'Hover Medium Minimum Height',
				'id'			=> 'hover_height_min_medium',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a minimum height value for the hover effect medium. Do not add px. (i.e. 100)',
				'choices'		=> '',
				'default'		=> '125'
			),
			
			array(
				'label'			=> 'Remove Image Width and Height',
				'id'			=> 'remove_image_wh',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'By default Wordpress will add width and height value to images. You can remove it if you want. For full responsive design it is advised to remove image dimensions.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
		),
	),
	
	array(
		'category_name' => 'Layout Settings',
		'category_id'	=> 'layout_settings',
		'class'			=> '',
		'elements'		=> array(
					
			array(
				'label'			=> 'Choose Main Layout Grid',
				'id'			=> 'main_layout_grid',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a px or % value for the main layout grid. (30px padding will apply to grid. i.e. 1170px will have 1140px content area). <br/><br/>Default value is 1170px. If you change default value, you will need to change image sizes and other layout settings.',
				'choices'		=> '',
				'default'		=> '1170px'
			),
			
			array(
				'label'			=> 'Search Model',
				'id'			=> 'search_model',
				'type'			=> 'select',
				'is_hidden'		=> 'true',
				'hidden_val'	=> 'search_full',
				'description'	=> '',
				'choices'		=> array(
					array('text' => 'Search Centered', 'value'=>'search_centered'),
					array('text' => 'Search Fullwidth (Default)', 'value'=>'search_full'),
				),
				'default'		=> 'search_full'
			),
						
			array(
				'label'			=> 'Border Radius',
				'id'			=> 'layout_border_radius',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the border radius in the px or em format. For example : 4px',
				'choices'		=> '',
				'default'		=> '0px'
			),
			
			array(
				'label'			=> 'Content Padding',
				'id'			=> 'content_padding',
				'type'			=> 'text_field',
				'is_hidden'		=> 'true',
				'hidden_val'	=> '15px',
				'description'	=> 'Enter the general content padding in px or em. (i.e. 10px)',
				'choices'		=> '',
				'default'		=> '15px'
			),
			
			array(
				'label'			=> 'Disable Responsivity',
				'id'			=> 'disable_responsivity',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to disable the responsivity, check this option. Disabling responsivity does not support sticky menu.',
				'choices'		=> '',
				'default'		=> 'FALSE'
			),
			
			array(
				'label'			=> 'Use Boxed Layout',
				'id'			=> 'use_boxed_layout',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" boxed layout will be activated',
				'choices'		=> '',
				'default'		=> 'FALSE'
			),
			
			array(
				'label'			=> 'Use Boxed Layout For Blog Articles',
				'id'			=> 'blog_boxed_article',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" boxed layout will be activated for blog articles',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Main Background Settings',
			),
			
			array(
				'label'			=> 'Main Background Image Retina',
				'id'			=> 'main_bg_image_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'description'	=> 'Main background image of the Wordpress does not contain Retina support. You can upload your retina version of your background image',
				'choices'		=> '',
				'default'		=> '',
			),
			
			array(
				'label'			=> 'Main Background Image Width',
				'id'			=> 'main_bg_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the Main Background Image.',
				'choices'		=> '',
				'default'		=> '149px',
			),
			
			array(
				'label'			=> 'Main Background Image Height',
				'id'			=> 'main_bg_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the Main Background Image.',
				'choices'		=> '',
				'default'		=> '139px',
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Main Boxed Layout Settings',
			),
			
			array(
				'label'			=> 'Main Boxed Layout Background Image',
				'id'			=> 'main_boxed_layout_bg_image',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you want to use an image for Main Boxed Layout Background, upload your Image Here',
				'choices'		=> '',
				'default'		=> '',
			),
			
			array(
				'label'			=> 'Main Boxed Layout Background Image Retina',
				'id'			=> 'main_boxed_layout_bg_image_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you use a background image for Main Boxed Layout Background, you can add Retina version of your background image here.',
				'choices'		=> '',
				'default'		=> '',
			),
			
			array(
				'label'			=> 'Main Boxed Layout Background Image Width',
				'id'			=> 'main_boxed_layout_bg_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the Main Boxed Layout Background Image.',
				'choices'		=> '',
				'default'		=> '297px',
			),
			
			array(
				'label'			=> 'Main Boxed Layout Background Image Height',
				'id'			=> 'main_boxed_layout_bg_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the Main Boxed Layout Background Image.',
				'choices'		=> '',
				'default'		=> '297px',
			),
			
			array(
				'label'			=> 'Main Boxed Layout Background Image Repeat',
				'id'			=> 'main_boxed_layout_bg_image_repeat',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'If you used an image for Main Boxed Layout Background you can choose the repeat mode here.',
				'choices'		=> array(
					array('text' => 'Repeat Both', 'value'=>'repeat'),
					array('text' => 'Repeat X', 'value'=>'repeat-x'),
					array('text' => 'Repeat Y', 'value'=>'repeat-y'),
					array('text' => 'No Repeat', 'value'=>'no-repeat'),
				),
				'default'		=> 'repeat',
			),
			
			array(
				'label'			=> 'Main Boxed Layout Background Color',
				'id'			=> 'main_boxed_layout_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to use a color for background, you should leave the image area empty',
				'choices'		=> '',
				'default'		=> '',
			),
			
			
			
			
			array(
				'label'			=> 'Small Block Grid',
				'id'			=> 'small_block_grid',
				'type'			=> 'select',
				'is_hidden'		=> 'true',
				'hidden_val'	=> 2,
				'description'	=> 'When site is viewed in the small screens, block grids will change their number. You can choose how may blocks will be shown for each row.',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12')
				),
				'default'		=> '2'
			),
			
			array(
				'label'			=> 'Medium Block Grid',
				'id'			=> 'medium_block_grid',
				'type'			=> 'select',
				'is_hidden'		=> 'true',
				'hidden_val'	=> 3,
				'description'	=> '',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12')
				),
				'default'		=> '3'
			),
					
		)
	),
		
	array(
		'category_name' => 'Header Settings',
		'category_id'	=> 'header_settings',
		'class'			=> '',
		'elements'		=> array(
		
			array(
				'label'			=> 'Header Model',
				'id'			=> 'header_model',
				'type'			=> 'select_images_vertical',
				'description'	=> 'Choose a header model',
				'choices'		=> array(
					array(
						'value' => 1,
						'url'  => OPTIONS_URI.'images/header_model_01.jpg'
					),
					
					array(
						'value' => 2,
						'url'  => OPTIONS_URI.'images/header_model_02.jpg'
					),
					
					array(
						'value' => 3,
						'url'  => OPTIONS_URI.'images/header_model_03.jpg'
					),
					
					array(
						'value' => 4,
						'url'  => OPTIONS_URI.'images/header_model_04.jpg'
					),
										
				),
				'default'		=> '1'
			),
			
			array(
				'label'			=> 'Header Location',
				'id'			=> 'header_location',
				'type'			=> 'select_images',
				'description'	=> 'Select a location for header model',
				'choices'		=> array(
					array(
						'value' => 'top_navigation',
						'url'  => OPTIONS_URI.'images/header_align_top.jpg'
					),
					
					array(
						'value' => 'side_navigation',
						'url'  => OPTIONS_URI.'images/header_align_left.jpg'
					),
															
				),
				'default'		=> 'top_navigation'
			),
			
			array(
				'label'			=> 'Enable Header Top',
				'id'			=> 'enable_header_top',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can enable/disable header top area. Header top area contains social icons, quick contact and WPML Selector and Widget fields.',
				'choices'		=> '',
				'default'		=> 'YES'
			),

			array(
				'label'			=> 'Enable Header Top Right Widget',
				'id'			=> 'enable_header_topr_widget',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can enable/disable header top right widget area here.',
				'choices'		=> '',
				'default'		=> 'NO'
			),

			array(
				'label'			=> 'Enable Sticky Menu',
				'id'			=> 'enable_sticky_menu',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can enable/disable sticky menu.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Enable Sticky Header Glow',
				'id'			=> 'enable_sticky_header_glow',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can easily enable sticky header glow.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
					
			array(
				'label'			=> 'Header Area Margin Top',
				'id'			=> 'header_area_margin_top',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'true',
				'description'	=> 'If you want to add margin to header area enter a px value (ie. 80px). This will only work with header top model',
				'choices'		=> '',
				'default'		=> '',
			),
					
			array(
				'label'			=> 'Header Contact Info',
				'id'			=> 'header_contact_info',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'true',
				'is_validate'	=> 'wp_kses',
				'description'	=> 'You can enter your small contact information to the header',
				'choices'		=> '',
				'default'		=> '<strong> Call Us:</strong> +1 555 5 555 | <strong> Email : </strong><a href="mailto:info@rockthemes.net">info@rockthemes.net</a>',
			),
			
			array(
				'label'			=> 'WPML Selector',
				'id'			=> 'header_top_2_wpml',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can enable/disable WPML Language Selector (This feature requires WPML)',
				'choices'		=> '',
				'default'		=> 'NO'
			),

			array(
				'label'			=> 'Social Icons',
				'id'			=> 'social_icons',
				'type'			=> 'socialicons',
				'is_validate'	=> 'wp_kses_post',
				'is_hidden'		=> 'false',
				'description'	=> 'Add social icon',
				'choices'		=> '',
				'default'		=> (('{"data":{"shortcode":"[rockthemes_social_icons][rockthemes_social_icons_single url=\"http://www.facebook.com\" icon_class=\"icomoon icomoon-icon-facebook\" icon_url=\"\"][/rockthemes_social_icons_single][rockthemes_social_icons_single url=\"http://www.twitter.com\" icon_class=\"icomoon icomoon-icon-twitter\" icon_url=\"\"][/rockthemes_social_icons_single][rockthemes_social_icons_single url=\"http://www.youtube.com\" icon_class=\"icomoon icomoon-icon-youtube\" icon_url=\"\"][/rockthemes_social_icons_single][rockthemes_social_icons_single url=\"http://www.dribbble.com\" icon_class=\"icomoon icomoon-icon-dribbble\" icon_url=\"\"][/rockthemes_social_icons_single][/rockthemes_social_icons]","socialicons":[{"title":"http://www.facebook.com","icon_class":"icomoon icomoon-icon-facebook","icon_url":""},{"title":"http://www.twitter.com","icon_class":"icomoon icomoon-icon-twitter","icon_url":""},{"title":"http://www.youtube.com","icon_class":"icomoon icomoon-icon-youtube","icon_url":""},{"title":"http://www.dribbble.com","icon_class":"icomoon icomoon-icon-dribbble","icon_url":""}]},"shortcode":"[rockthemes_social_icons][rockthemes_social_icons_single url=\"http://www.facebook.com\" icon_class=\"icomoon icomoon-icon-facebook\" icon_url=\"\"][/rockthemes_social_icons_single][rockthemes_social_icons_single url=\"http://www.twitter.com\" icon_class=\"icomoon icomoon-icon-twitter\" icon_url=\"\"][/rockthemes_social_icons_single][rockthemes_social_icons_single url=\"http://www.youtube.com\" icon_class=\"icomoon icomoon-icon-youtube\" icon_url=\"\"][/rockthemes_social_icons_single][rockthemes_social_icons_single url=\"http://www.dribbble.com\" icon_class=\"icomoon icomoon-icon-dribbble\" icon_url=\"\"][/rockthemes_social_icons_single][/rockthemes_social_icons]"}'))
			),
			
			
			array(
				'label'			=> 'Header Large Background',
				'id'			=> 'header_large_background',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'You can upload an image for header large area. If you leave this area empty, you can choose a color for your background large area.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Header Large Background Repeat',
				'id'			=> 'header_large_background_repeat',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'If you used an image for header large area you can choose the repeat mode for the header large background image.',
				'choices'		=> array(
					array('text' => 'Repeat Both', 'value'=>'repeat'),
					array('text' => 'Repeat X', 'value'=>'repeat-x'),
					array('text' => 'Repeat Y', 'value'=>'repeat-y'),
					array('text' => 'No Repeat', 'value'=>'no-repeat'),
				),
				'default'		=> 'repeat'
			),
			
			array(
				'label'			=> 'Header Large Background Color',
				'id'			=> 'header_large_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to use a color for background, you should leave the image area empty',
				'choices'		=> '',
				'default'		=> '#ffffff'
			),
			
			array(
				'label'			=> 'Header Large Font Color',
				'id'			=> 'header_large_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your header large area text',
				'choices'		=> '',
				'default'		=> '#ededde'
			),
			
			array(
				'label'			=> 'Header Large Link Color',
				'id'			=> 'header_large_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your header large area links',
				'choices'		=> '',
				'default'		=> '#f4f3e6'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Header Top',
			),
						
			array(
				'label'			=> 'Header Top Background Color',
				'id'			=> 'header_top_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for Header Top Area background',
				'choices'		=> '',
				'default'		=> '#ffffff',
			),
			
			array(
				'label'			=> 'Header Top Border Dim Color',
				'id'			=> 'header_top_border_dim_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for Header Top Area background',
				'choices'		=> '',
				'default'		=> '#f0f0f0',
			),
						
			array(
				'label'			=> 'Header Top Font Color',
				'id'			=> 'header_top_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your header top area text',
				'choices'		=> '',
				'default'		=> '#c5cdd1',
			),
			
			array(
				'label'			=> 'Header Top Link Color',
				'id'			=> 'header_top_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your header top area links',
				'choices'		=> '',
				'default'		=> '#c5cdd1',
			),
			
			array(
				'label'			=> 'Header Top Link Hover Color',
				'id'			=> 'header_top_link_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your header top area hover',
				'choices'		=> '',
				'default'		=> '#787878',
			),

			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Social Media Icons',
			),
			
			array(
				'label'			=> 'Social Media Icons Default Color',
				'id'			=> 'social_media_icons_default_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a default color for social media icons',
				'choices'		=> '',
				'default'		=> '#ededde'
			),
						
		),
	),	
	
	array(
		'category_name' => 'Menu Settings',
		'category_id'	=> 'menu_settings',
		'class'			=> '',
		'elements'		=> array(
										
			array(
				'label'			=> 'Add Search Box To Menu',
				'id'			=> 'add_search_box_to_menu',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to add the special search box to the menu, choose "YES"',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Menu Search Excerpt Length',
				'id'			=> 'menu_search_excerpt_length',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter a number for excerpt length',
				'choices'		=> '',
				'default'		=> '10'
			),
			
			array(
				'label'			=> 'Enable Hash Navigation',
				'id'			=> 'enable_menu_hash_navigation',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'Hash navigation will use links inside the page. If you want to use main menu instead of side navigation, enable this feature',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Main Menu Model',
				'id'			=> 'main_menu_model',
				'type'			=> 'select',
				'is_hidden'		=> 'true',
				'description'	=> 'You can use mobile menu instead of regular menu as default.',
				'choices'		=> array(
					array('text' => 'Use Regular Main Menu', 'value'=>'regular'),
					array('text' => 'Use Mobile Menu For Main Navigation', 'value'=>'menu_use_mobile_for_main'),
				),
				'default'		=> 'regular'
			),
			
			array(
				'label'			=> 'Menu First Level Font Color',
				'id'			=> 'menu_level1_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Menu first level font color',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Menu First Level Font Hover Color',
				'id'			=> 'menu_level1_font_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Menu first level font hover color',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Enable Menu First Level Hover Background Color',
				'id'			=> 'menu_level1_bg_hover_enable',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can easily enable/disable background color for the first level menu hover.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Menu First Level Hover Background Color',
				'id'			=> 'menu_level1_bg_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Menu first level hover background color',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Menu Search and WooCommerce Cart Colors',
			),
			
			array(
				'label'			=> 'Extras Background Color',
				'id'			=> 'menu_extras_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of Menu Search and WooCommerce extra field',
				'choices'		=> '',
				'default'		=> '#ffffff'
			),
			
			array(
				'label'			=> 'Extras Border Top Color',
				'id'			=> 'menu_extras_border_top_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Border Top color of Menu Search and WooCommerce extra field',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Extras Button Background Color',
				'id'			=> 'menu_extras_button_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of Menu Search and WooCommerce extra field buttons',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Extras Button Font Color',
				'id'			=> 'menu_extras_button_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Font color of Menu Search and WooCommerce extra field buttons',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Extras Button Background Hover Color',
				'id'			=> 'menu_extras_button_bg_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background Hover color of Menu Search and WooCommerce extra field buttons',
				'choices'		=> '',
				'default'		=> '#324864'
			),
			
			array(
				'label'			=> 'Search Input Field Border Color',
				'id'			=> 'menu_extras_search_border_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Border Color of the search input',
				'choices'		=> '',
				'default'		=> '#DEDEDE'
			),
			
			array(
				'label'			=> 'Results Default Background Color',
				'id'			=> 'menu_extras_results_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'WooCommerce Cart Contents and Search Results Default Background Color',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Results Background Hover Color',
				'id'			=> 'menu_extras_results_bg_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'WooCommerce Cart Contents and Search Results Background Hover Color',
				'choices'		=> '',
				'default'		=> '#F9F9F9'
			),
			
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'First Level Menu Extras',
			),
			
			array(
				'label'			=> 'Enable Search Element Background Color',
				'id'			=> 'menu_search_bg_color_enable',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can easily enable/disable background color for the search element in the menu.',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Search Element Background Color',
				'id'			=> 'menu_search_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Search element background color in the menu',
				'choices'		=> '',
				'default'		=> '#152840'
			),
			
			array(
				'label'			=> 'Search Element Font Color',
				'id'			=> 'menu_search_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Search element font color in the menu',
				'choices'		=> '',
				'default'		=> '#F9F9F9'
			),
			
			array(
				'label'			=> 'Search Element Font Hover Color',
				'id'			=> 'menu_search_font_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Search element font hover color in the menu',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Enable WooCommerce Cart Element Background Color',
				'id'			=> 'menu_woocart_bg_color_enable',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can easily enable/disable background color for the WooCommerce Cart element in the menu.',
				'choices'		=> '',
				'default'		=> 'YES'
			),

			array(
				'label'			=> 'WooCommerce Cart Element Background Color',
				'id'			=> 'menu_woocart_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'WooCommerce Cart element background color in the menu',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'WooCommerce Cart Element Background Color',
				'id'			=> 'menu_woocart_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'WooCommerce Cart element font color in the menu',
				'choices'		=> '',
				'default'		=> '#F9F9F9'
			),
			
			array(
				'label'			=> 'WooCommerce Cart Element Background Color',
				'id'			=> 'menu_woocart_font_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'WooCommerce Cart element font hover color in the menu',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),

			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Sub Menu Settings',
			),
			
			array(
				'label'			=> 'Submenu Background Color',
				'id'			=> 'menu_level2_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Submenu background color',
				'choices'		=> '',
				'default'		=> '#F9F9F9'
			),
			
			array(
				'label'			=> 'Submenu Background Hover Color',
				'id'			=> 'menu_level2_bg_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Submenu background hover color',
				'choices'		=> '',
				'default'		=> '#f0f0f0'
			),
						
			array(
				'label'			=> 'Submenu Font Color',
				'id'			=> 'menu_level2_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Submenu font color',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Submenu Font Hover Color',
				'id'			=> 'menu_level2_font_hover_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Submenu font hover color',
				'choices'		=> '',
				'default'		=> '#56ccc8'
			),
			
			array(
				'label'			=> 'Submenu Description Font Color',
				'id'			=> 'menu_level2_desc_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Submenu description font color',
				'choices'		=> '',
				'default'		=> '#999999'
			),
			
			array(
				'label'			=> 'Submenu Border Dim Color',
				'id'			=> 'menu_level2_border_dim_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Border dim color of the sub menu elements',
				'choices'		=> '',
				'default'		=> '#F0F0F0'
			),
			
			array(
				'label'			=> 'Submenu Border Top Color',
				'id'			=> 'menu_level2_border_top_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Border top color of the sub menu elements. Usually main color of the site',
				'choices'		=> '',
				'default'		=> '#56ccc8'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Mobile Menu / Side Menu Details',
			),
			
			array(
				'label'			=> 'Mobile / Side Menu Logo Padding Top',
				'id'			=> 'mobile_menu_logo_padding_top',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'false',
				'description'	=> 'Padding top of the side menu.',
				'choices'		=> '',
				'default'		=> '30px',
			),	
			
			array(
				'label'			=> 'Mobile / Side Menu Logo Padding Bottom',
				'id'			=> 'mobile_menu_logo_padding_bottom',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'false',
				'description'	=> 'Padding bottom of the side menu.',
				'choices'		=> '',
				'default'		=> '30px',
			),		
			
			array(
				'label'			=> 'Side Menu Width',
				'id'			=> 'mobile_side_menu_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'false',
				'description'	=> 'When you select header on the left, you can set a size to menu width. Enter a valid "px" value. (i.e. 350px)',
				'choices'		=> '',
				'default'		=> '350px',
			),			
			
			array(
				'label'			=> 'Mobile Menu Background Color',
				'id'			=> 'mobile_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of Mobile Menu',
				'choices'		=> '',
				'default'		=> '#f3f3f3'
			),
			
			array(
				'label'			=> 'Mobile Menu Font Color',
				'id'			=> 'mobile_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Font color of Mobile Menu',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Mobile Menu Hover Font Color',
				'id'			=> 'mobile_hover_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Font hover color of Mobile Menu',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Mobile Menu Active Background Color',
				'id'			=> 'mobile_hover_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of the active menu element',
				'choices'		=> '',
				'default'		=> '#f9f9f9'
			),
			
			array(
				'label'			=> 'Mobile Menu Arrow Color',
				'id'			=> 'mobile_arrow_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Arrow color of Mobile Menu',
				'choices'		=> '',
				'default'		=> '#C5CDD1'
			),
			
			array(
				'label'			=> 'Mobile Menu Icon Color',
				'id'			=> 'mobile_icon_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Icon color of Mobile Menu',
				'choices'		=> '',
				'default'		=> '#C5CDD1'
			),
			
			array(
				'label'			=> 'Use Dark Border Colors',
				'id'			=> 'mobile_menu_use_dark_border_color',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'By default, mobile/side menu will use a light color for bordes. If you choose yes, it will use a dark color.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Mobile Menu List Icon Background',
				'id'			=> 'mobile_menu_list_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of the mobile menu list icon. This only will be used when side navigation enabled.',
				'choices'		=> '',
				'default'		=> '#324864'
			),		
			
			array(
				'label'			=> 'Mobile Menu List Icon Color',
				'id'			=> 'mobile_menu_list_icon_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Mobile Menu burger icon color.',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),			
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Menu Sticker Details',
			),
			
			array(
				'label'			=> 'Sticker Hot Background Color',
				'id'			=> 'menu_sticker_hot_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of the hot sticker',
				'choices'		=> '',
				'default'		=> '#ea6060'
			),
			
			array(
				'label'			=> 'Sticker Hot Font Color',
				'id'			=> 'menu_sticker_hot_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Font color of the hot sticker',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Sticker New Background Color',
				'id'			=> 'menu_sticker_new_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of the new sticker',
				'choices'		=> '',
				'default'		=> '#56CCC8'
			),
			
			array(
				'label'			=> 'Sticker New Font Color',
				'id'			=> 'menu_sticker_new_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Font color of the new sticker',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
			
			array(
				'label'			=> 'Sticker Info Background Color',
				'id'			=> 'menu_sticker_info_bg_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Background color of the info sticker',
				'choices'		=> '',
				'default'		=> '#324864'
			),
			
			array(
				'label'			=> 'Sticker Info Font Color',
				'id'			=> 'menu_sticker_info_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Font color of the info sticker',
				'choices'		=> '',
				'default'		=> '#FFFFFF'
			),
						
		),
	),	
	
	array(
		'category_name' => 'Title & Breadcrumbs',
		'category_id'	=> 'title_and_breadcrumbs',
		'class'			=> '',
		'elements'		=> array(
		
			array(
				'label'			=> 'Title & Breadcrumbs Area Model',
				'id'			=> 'title_breadcrumbs_area_model',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> '',
				'choices'		=> array(
					array('text' => 'Full Width Centered', 'value'=>'full'),
					array('text' => 'Side by Side', 'value'=>'half'),
				),
				'default'		=> 'full'
			),
		
			array(
				'label'			=> 'Title Area Background Image',
				'id'			=> 'title_area_background_image',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you want to use another image for Title Area, upload your Image Here',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Retina',
				'id'			=> 'title_area_background_image_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you use a background image for Title Area, you can add Retina version of your background image here.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Width',
				'id'			=> 'title_area_background_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the Title Area Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Height',
				'id'			=> 'title_area_background_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the Title Area Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Repeat',
				'id'			=> 'title_area_background_image_repeat',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'If you used an image for Title Area Background you can choose the repeat mode here.',
				'choices'		=> array(
					array('text' => 'Repeat Both', 'value'=>'repeat'),
					array('text' => 'Repeat X', 'value'=>'repeat-x'),
					array('text' => 'Repeat Y', 'value'=>'repeat-y'),
					array('text' => 'No Repeat', 'value'=>'no-repeat'),
					array('text' => 'Parallax', 'value'=>'parallax'),
				),
				'default'		=> 'parallax'
			),
			
			array(
				'label'			=> 'Title Area Background Color',
				'id'			=> 'title_area_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to use a color for background, you should leave the image area empty',
				'choices'		=> '',
				'default'		=> '#f9f9f9'
			),
			
			array(
				'label'			=> 'Title Area Font Color',
				'id'			=> 'title_area_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Title Area text',
				'choices'		=> '',
				'default'		=> '#ffffff'
			),
			
			array(
				'label'			=> 'Title Area Link Color',
				'id'			=> 'title_area_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Title Area link',
				'choices'		=> '',
				'default'		=> '#f0f0f0'
			),
			
			array(
				'label'			=> 'Use Top Shadow',
				'id'			=> 'title_area_top_shadow',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to activate the shadow at the top of the area choose "YES"',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Use Bottom Shadow',
				'id'			=> 'title_area_bottom_shadow',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to activate the shadow at the bottom of the area choose "YES"',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Deactivate Breadcrumbs',
				'id'			=> 'deactivate_breadcrumbs',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to deactivate the breadcrumbs choose "YES"',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Disable Breadcrumbs Title Area',
				'id'			=> 'disable_breadcrumbs_title_area',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to disable the Header Title and Breadcrumbs area, choose "YES". This will not take effect if you specifically set another option inside page.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Disable Space Under Header',
				'id'			=> 'disable_space_under_header',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'This option will remove the extra vertical space under header. This will not take effect if you specifically set another option inside page.',
				'choices'		=> '',
				'default'		=> 'NO'
			),

			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Title Breadcrumbs Of Pages',
			),

			array(
				'label'			=> 'Title Area Background Image',
				'id'			=> 'page_title_area_background_image',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you want to use another image for Title Area, upload your Image Here',
				'choices'		=> '',
				'default'		=> F_WAY.'/images/demo/demo-image-default.jpg'

			),
			
			array(
				'label'			=> 'Title Area Background Image Retina',
				'id'			=> 'page_title_area_background_image_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you use a background image for Title Area, you can add Retina version of your background image here.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Width',
				'id'			=> 'page_title_area_background_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the Title Area Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Height',
				'id'			=> 'page_title_area_background_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the Title Area Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Repeat',
				'id'			=> 'page_title_area_background_image_repeat',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'If you used an image for Title Area Background you can choose the repeat mode here.',
				'choices'		=> array(
					array('text' => 'Repeat Both', 'value'=>'repeat'),
					array('text' => 'Repeat X', 'value'=>'repeat-x'),
					array('text' => 'Repeat Y', 'value'=>'repeat-y'),
					array('text' => 'No Repeat', 'value'=>'no-repeat'),
					array('text' => 'Parallax', 'value'=>'parallax'),
				),
				'default'		=> 'parallax'
			),
			
			array(
				'label'			=> 'Title Area Background Color',
				'id'			=> 'page_title_area_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to use a color for background, you should leave the image area empty',
				'choices'		=> '',
				'default'		=> '#f9f9f9'
			),
			
			array(
				'label'			=> 'Title Area Font Color',
				'id'			=> 'page_title_area_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Title Area text',
				'choices'		=> '',
				'default'		=> '#ffffff'
			),
			
			array(
				'label'			=> 'Title Area Link Color',
				'id'			=> 'page_title_area_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Title Area link',
				'choices'		=> '',
				'default'		=> '#f0f0f0'
			),

			array(
				'label'			=> 'Enable YOAST Breadcrumbs',
				'id'			=> 'enable_yoast_breadcrumbs',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you use YOAST SEO plugin, you can enable this feature. Make sure you also enable breadcrumbs in "SEO > Advanced > Enable Breadcrumbs"',
				'choices'		=> '',
				'default'		=> 'NO'
			),

		),
	),	
	
	array(
		'category_name' => 'Footer Settings',
		'category_id'	=> 'footer_settings',
		'class'			=> '',
		'elements'		=> array(
		
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Footer Large Settings',
			),
			
			array(
				'label'			=> 'Large Footer Columns',
				'id'			=> 'large_footer_columns',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'Footer Large Columns. If you choose 6 there will be 2 blocks. If you choose 4 there will be 3 blocks.',
				'choices'		=> array(
					array('text' => '1 Column', 'value'=>'1'),
					array('text' => '2 Columns', 'value'=>'2'),
					array('text' => '3 Columns', 'value'=>'3'),
					array('text' => '4 Columns', 'value'=>'4'),
					array('text' => '6 Columns', 'value'=>'6'),
					array('text' => '12 Columns', 'value'=>'12'),
				),
				'default'		=> '3'
			),
			
			array(
				'label'			=> 'Display Footer Large Area',
				'id'			=> 'display_footer_large_area',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'As default footer large area will be displayed. If you want to remove the footer large area you can choose to remove it. This will be a general rule for every page. But you can still make page specific choice in Advanced Details',
				'choices'		=> array(
					array('text' => 'Display Footer Large Area', 'value'=>'true'),
					array('text' => 'Remove Footer Large Area', 'value'=>'false'),
				),
				'default'		=> 'true'
			),
		
			array(
				'label'			=> 'Footer Large Background Image',
				'id'			=> 'footer_large_background_image',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you want to use image for Footer Large, upload your Image Here',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Footer Large Background Image Retina',
				'id'			=> 'footer_large_background_image_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you use a background image for Footer Large, you can add Retina version of your background image here.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Footer Large Background Image Width',
				'id'			=> 'footer_large_background_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the Footer Large Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Footer Large Background Image Height',
				'id'			=> 'footer_large_background_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the Footer Large Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Footer Large Background Image Repeat',
				'id'			=> 'footer_large_background_image_repeat',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'If you used an image for Footer Large Background you can choose the repeat mode here.',
				'choices'		=> array(
					array('text' => 'Repeat Both', 'value'=>'repeat'),
					array('text' => 'Repeat X', 'value'=>'repeat-x'),
					array('text' => 'Repeat Y', 'value'=>'repeat-y'),
					array('text' => 'No Repeat', 'value'=>'no-repeat'),
				),
				'default'		=> 'repeat'
			),
			
			array(
				'label'			=> 'Footer Large Background Color',
				'id'			=> 'footer_large_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to use a color for background, you should leave the image area empty',
				'choices'		=> '',
				'default'		=> '#dbdee0'
			),
			
			array(
				'label'			=> 'Footer Large Border Dim Color',
				'id'			=> 'footer_large_border_dim_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Border color for footer large area',
				'choices'		=> '',
				'default'		=> '#C5CDD1'
			),
			
			array(
				'label'			=> 'Footer Large Font Color',
				'id'			=> 'footer_large_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Footer Large text',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Footer Large Link Color',
				'id'			=> 'footer_large_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Footer Large link',
				'choices'		=> '',
				'default'		=> '#333333'
			),
									
			array(
				'label'			=> 'Use Top Shadow',
				'id'			=> 'footer_large_top_shadow',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to activate the shadow on top of Footer Large choose "YES"',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Use Top Border',
				'id'			=> 'footer_large_top_border',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to activate the border on top of Footer Large choose "YES"',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Footer Bottom Settings',
			),
			
			array(
				'label'			=> 'Footer Bottom Columns',
				'id'			=> 'footer_bottom_columns',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'Footer Bottom Columns. If you choose 6 there will be 2 blocks. If you choose 12 there will be 1 block and the details will be centered.',
				'choices'		=> array(
					array('text' => '6 Columns', 'value'=>'6'),
					array('text' => '12 Columns', 'value'=>'12'),
				),
				'default'		=> '12'
			),
			
			array(
				'label'			=> 'Display Footer Bottom Area',
				'id'			=> 'display_footer_bottom_area',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'As default footer bottom area will be displayed. If you want to remove the footer bottom area you can choose to remove it. This will be a general rule for every page. But you can still make page specific choice in Advanced Details',
				'choices'		=> array(
					array('text' => 'Display Footer Bottom Area', 'value'=>'true'),
					array('text' => 'Remove Footer Bottom Area', 'value'=>'false'),
				),
				'default'		=> 'true'
			),
			
			array(
				'label'			=> 'Footer Bottom Background Color',
				'id'			=> 'footer_bottom_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose footer bottom area background color',
				'choices'		=> '',
				'default'		=> '#dbdee0'
			),
			
			array(
				'label'			=> 'Footer Bottom Top Border Color',
				'id'			=> 'footer_bottom_top_border_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Top border color of footer bottom area.',
				'choices'		=> '',
				'default'		=> '#c5cdd1'
			),
			
			array(
				'label'			=> 'Footer Bottom Font Color',
				'id'			=> 'footer_bottom_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Footer Bottom text',
				'choices'		=> '',
				'default'		=> '#787878'
			),
			
			array(
				'label'			=> 'Footer Bottom Link Color',
				'id'			=> 'footer_bottom_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Footer Bottom link',
				'choices'		=> '',
				'default'		=> '#333333'
			),
			
			array(
				'label'			=> 'Footer Copyright Information',
				'id'			=> 'footer_copyright',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'true',
				'is_validate'	=> 'wp_kses',
				'description'	=> 'Enter your footer copyright information here',
				'choices'		=> '',
				'default'		=> '© Copyright - Azoom Theme'
			),

		),	
	),
	
	
	array(
		'category_name' => 'Under Construction',
		'category_id'	=> 'under_construction',
		'class'			=> '',
		'elements'		=> array(
		
			array(
				'label'			=> 'Enable Redirect (Under Construction)',
				'id'			=> 'enable_template_redirect',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES", site will redirect to a page you choose for not logged in users. This is useful for making an Under Construction page',
				'choices'		=> '',
				'default'		=> 'NO'
			),
		
			array(
				'label'			=> 'Redirect / Under Construction Page',
				'id'			=> 'template_redirect_page',
				'type'			=> 'page_list',
				'is_hidden'		=> 'false',
				'is_translate'	=> 'false',
				'description'	=> 'Choose your Redirect / Under Construction page',
				'choices'		=> '',
				'default'		=> ''
			),
		
		),
	),

	
	
	array(
		'category_name' => 'WooCommerce Settings',
		'category_id'	=> 'woocommerce_settings',
		'class'			=> '',
		'elements'		=> array(
			array(
				'label'			=> 'Add Cart Icon To Menu',
				'id'			=> 'add_cart_icon_to_menu',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to add the special cart icon with cart contents to the menu, choose "YES"',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Auto Display Cart After Refresh',
				'id'			=> 'auto_display_cart_after_refresh',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'When a new product added to cart, cart will slide down automatically. If you want to deactivate this option choose "NO"',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Cross & Related & Up Sells Total in Cart',
				'id'			=> 'cross_up_sells_total_cart',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'How many products should be displayed in cross & related & up sells in the cart.',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12'),
				),
				'default'		=> '2'
			),
			
			array(
				'label'			=> 'Cross & Related & Up Sells Blocks in Cart',
				'id'			=> 'cross_up_sells_blocks_cart',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose the blocks of cross & related & up sells in the cart.',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12'),
				),
				'default'		=> '2'
			),
			
			array(
				'label'			=> 'Cross & Related & Up Sells Total in Product',
				'id'			=> 'cross_up_sells_total_item',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'How many products should be displayed in cross & related & up sells in the product.',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12'),
				),
				'default'		=> '4'
			),
			
			array(
				'label'			=> 'Cross & Related & Up Sells Blocks in Product',
				'id'			=> 'cross_up_sells_blocks_item',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose the blocks of cross & related & up sells in the product.',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12'),
				),
				'default'		=> '4'
			),
						
			array(
				'label'			=> 'Shop Product Blocks Large',
				'id'			=> 'woo_shop_blocks_large',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'How many products should be displayed in a row on the shop page. Only for bigger than 768px ',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12'),
				),
				'default'		=> '3'
			),
			
			array(
				'label'			=> 'Shop Product Blocks Medium',
				'id'			=> 'woo_shop_blocks_medium',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'How many products should be displayed in a row on the shop page. For tablets',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12'),
				),
				'default'		=> '2'
			),
			
			array(
				'label'			=> 'Shop Product Blocks Small',
				'id'			=> 'woo_shop_blocks_small',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'How many products should be displayed in a row on the shop page. For smaller devices',
				'choices'		=> array(
					array('text' => '1 Block', 'value'=>'1'),
					array('text' => '2 Block', 'value'=>'2'),
					array('text' => '3 Block', 'value'=>'3'),
					array('text' => '4 Block', 'value'=>'4'),
					array('text' => '5 Block', 'value'=>'5'),
					array('text' => '6 Block', 'value'=>'6'),
					array('text' => '7 Block', 'value'=>'7'),
					array('text' => '8 Block', 'value'=>'8'),
					array('text' => '9 Block', 'value'=>'9'),
					array('text' => '10 Block', 'value'=>'10'),
					array('text' => '11 Block', 'value'=>'11'),
					array('text' => '12 Block', 'value'=>'12'),
				),
				'default'		=> '1'
			),
			
			array(
				'label'			=> 'Remove Margins Between Blocks',
				'id'			=> 'woo_wall_mode',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can choose to remove margins between WooCommerce product blocks in shop and archives.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Use RPB Portfolio Element for Archives',
				'id'			=> 'woo_rpb_archive',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'You can choose to use Rock Page Builder Portfolio Element for WooCommerce Archive Pages. However, doing this will remove any WooCommerce Hooks and this may not be compatible with 3rd party WooCommerce plugins. If you will use a lot of WooCommerce plugins for shop/archive pages, disabling this is advised. If you want to make changes for RPB element, you can edit our shortcode attributes in rpb_woo-archive.php file',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'WooCommerce Breadcrumbs Title Area',
			),

			array(
				'label'			=> 'Title Area Background Image',
				'id'			=> 'woo_title_area_background_image',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you want to use another image for Title Area, upload your Image Here',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Retina',
				'id'			=> 'woo_title_area_background_image_retina',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'demo_default'	=> 'true',
				'description'	=> 'If you use a background image for Title Area, you can add Retina version of your background image here.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Width',
				'id'			=> 'woo_title_area_background_image_width',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the width value of the Title Area Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Height',
				'id'			=> 'woo_title_area_background_image_height',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'description'	=> 'Enter the height value of the Title Area Background Image.',
				'choices'		=> '',
				'default'		=> ''
			),
			
			array(
				'label'			=> 'Title Area Background Image Repeat',
				'id'			=> 'woo_title_area_background_image_repeat',
				'type'			=> 'select',
				'is_hidden'		=> 'false',
				'description'	=> 'If you used an image for Title Area Background you can choose the repeat mode here.',
				'choices'		=> array(
					array('text' => 'Repeat Both', 'value'=>'repeat'),
					array('text' => 'Repeat X', 'value'=>'repeat-x'),
					array('text' => 'Repeat Y', 'value'=>'repeat-y'),
					array('text' => 'No Repeat', 'value'=>'no-repeat'),
					array('text' => 'Parallax', 'value'=>'parallax'),
				),
				'default'		=> 'parallax'
			),
			
			array(
				'label'			=> 'Title Area Background Color',
				'id'			=> 'woo_title_area_background_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to use a color for background, you should leave the image area empty',
				'choices'		=> '',
				'default'		=> '#f9f9f9'
			),
			
			array(
				'label'			=> 'Title Area Font Color',
				'id'			=> 'woo_title_area_font_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Title Area text',
				'choices'		=> '',
				'default'		=> '#ffffff'
			),
			
			array(
				'label'			=> 'Title Area Link Color',
				'id'			=> 'woo_title_area_link_color',
				'type'			=> 'colorpicker',
				'is_hidden'		=> 'false',
				'description'	=> 'Choose a color for your Title Area link',
				'choices'		=> '',
				'default'		=> '#f0f0f0'
			),
						
			array(
				'label'			=> 'Deactivate Breadcrumbs',
				'id'			=> 'woo_deactivate_breadcrumbs',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to deactivate the breadcrumbs choose "YES"',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Disable Breadcrumbs Title Area',
				'id'			=> 'woo_disable_breadcrumbs_title_area',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you want to disable the Header Title and Breadcrumbs area, choose "YES". This will not take effect if you specifically set another option inside page.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
						
		),
	),
	
	
	array(
		'category_name' => 'Server Details',
		'category_id'	=> 'server_details',
		'class'			=> '',
		'elements'		=> array(
			
			array(
				'label'			=> 'Server Details',
				'id'			=> 'server_details_field',
				'type'			=> 'server_details',
				'is_hidden'		=> 'false',
				'description'	=> 'Here you can find some server details. These are most known details of your server and Wordpress Installation. If you have lower values than required, you will need to contact to your hosting to increase those values. Using low values may cause some features to not work properly. Thus we highly recommend to increase low values to avoid further issues.',
				'choices'		=> '',
				'default'		=> ''
			),
								
		)
	),	
	
	array(
		'category_name' => 'Theme Features',
		'category_id'	=> 'theme_features',
		'class'			=> '',
		'elements'		=> array(
				
			array(
				'label'			=> 'Disable RPB (Rock Page Builder)',
				'id'			=> 'disable_rpb',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" RPB will be disabled',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'RPB, Only Users Who Can',
				'id'			=> 'user_ableto_rpb',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'The minimum user capability to use RPB. You can check <a href="http://codex.wordpress.org/Roles_and_Capabilities">Roles and Capabilities</a> for the full list of user capabilities.',
				'choices'		=> '',
				'default'		=> 'delete_pages',
			),
			
			/*Move this to General or Page Builder Settings*/
			array(
				'label'			=> 'Auto Add Featured Image',
				'id'			=> 'auto_add_featured_image_to_builder',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you activate this option, page builder will automatically add a featured image area for each new page. (Recommended)',
				'choices'		=> '',
				'default'		=> 'YES'
			),
			
			array(
				'label'			=> 'Enable Demo Image',
				'id'			=> 'enable_demo_image',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'This feature will use demo image for image areas which does not have any image. For demo modes.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Demo Image URL',
				'id'			=> 'demo_image_url',
				'type'			=> 'image',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'If demo image is enabled, this image will be used.',
				'choices'		=> '',
				'default'		=> F_WAY.'/images/demo/demo-image-default.jpg',
			),
			
			array(
				'label'			=> 'Disable Mega Menu',
				'id'			=> 'disable_mega_menu',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" Mega Menu will be disabled. !Important : Disabling Mega Menu, will also disable menu style.',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Disable Custom Sidebars',
				'id'			=> 'disable_custom_sidebars',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" Custom Sidebars will be disabled',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Disable Curvy Slider',
				'id'			=> 'disable_curvy_slider',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" Curvy Slider will be disabled',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Curvy Slider, Only Users Who Can',
				'id'			=> 'user_ableto_curvy_slider',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'The minimum user capability to edit Curvy Slider. You can check <a href="http://codex.wordpress.org/Roles_and_Capabilities">Roles and Capabilities</a> for the full list of user capabilities.',
				'choices'		=> '',
				'default'		=> 'delete_pages',
			),
			
			array(
				'label'			=> 'Disable Advanced Details',
				'id'			=> 'disable_advanced_details',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" Advanced Details will be disabled',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Advanced Details, Only Users Who Can',
				'id'			=> 'user_ableto_advanced_details',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'The minimum user capability to use Advanced Details. You can check <a href="http://codex.wordpress.org/Roles_and_Capabilities">Roles and Capabilities</a> for the full list of user capabilities.',
				'choices'		=> '',
				'default'		=> 'delete_pages',
			),
						
			array(
				'id'			=> '',
				'type'			=> 'header',
				'description'	=> 'Theme Related Post Types',
			),
			
			array(
				'label'			=> 'Disable Default Items',
				'id'			=> 'disable_default_items',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" Default Items will be disabled',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			array(
				'label'			=> 'Default Items Slug',
				'id'			=> 'slug_default_item',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Slug of the Default Items. If you change this option you need to go to "Settings > Permalinks" and click "Save Changes"',
				'choices'		=> '',
				'default'		=> 'default-item'
			),
			
			array(
				'label'			=> 'Default Items Category Slug',
				'id'			=> 'slug_default_item_category',
				'type'			=> 'text_field',
				'is_hidden'		=> 'false',
				'hidden_val'	=> '',
				'description'	=> 'Slug of the Default Item Category. If you change this option you need to go to "Settings > Permalinks" and click "Save Changes"',
				'choices'		=> '',
				'default'		=> 'default-category',
			),

			array(
				'label'			=> 'Disable Default Gallery',
				'id'			=> 'disable_default_gallery',
				'type'			=> 'checkbox',
				'is_hidden'		=> 'false',
				'description'	=> 'If you choose "YES" Default Gallery will be disabled',
				'choices'		=> '',
				'default'		=> 'NO'
			),
			
			
		),
			
	),
	
	


);

?>