<?php

// Hook into WordPress
add_action( 'admin_init', 'rockthemes_ad_add_custom_metabox' );

/**
 * Add meta box
 */
function rockthemes_ad_add_custom_metabox() {
	global $rpb_post_types;
	
	if(empty($rpb_post_types)){
		$rpb_post_types = function_exists('rpb_get_post_types') ? rpb_get_post_types() : array();	
	}

	if(!function_exists('xr_get_option')) return;
	
	//Return if Advanced Details Disabled
	if(true === xr_get_option('disable_advanced_details', false)) return;
	
	//Return if not able
	if(!current_user_can(esc_attr(xr_get_option('user_ableto_advanced_details', 'delete_pages')))) return;
	
	
	//This will include the sidebar
	foreach ($rpb_post_types as $type) 
    {
		add_meta_box( 'rockthemes_post_details',  'Advanced Details' , 'rockthemes_post_details_metabox', $type, 'normal', 'default' );
    }

	return;
	
		
}

/*
**	Custom Sidebar Metabox
*/
function rockthemes_post_details_metabox() {
	global $post;
	$custom_sidebar = get_post_meta($post->ID,'custom_sidebar_list',true);
	$rockthemes_advanced_post_details = get_post_meta($post->ID,'advanced_post_details',true);
		
	$ajax_filtered_thumbnail = '';
	$ajax_filtered_hover_box_image = '';
	$extra_featured_images = '';
	$extra_buttons = '';
	$video_iframe_code = '';
	$self_bg_image = '';
	
	if($rockthemes_advanced_post_details) extract($rockthemes_advanced_post_details);
	
	//Extra featured images
	$extra_featured_images_counter = 0;
	$extra_featured_images_html = '';
	if($extra_featured_images){

		foreach($extra_featured_images as $featured_image){

			$extra_featured_images_html .= '
				<div class="extra_featured_image_class" ref="'.$extra_featured_images_counter.'">
					<strong>Choose an Image : </strong><br/><br/>
					<div class="hide image-data"></div>
					<label for="upload_image"> 
						<input id="extra_featured_image'.$extra_featured_images_counter.'" class="upload_image_button" size="36" name="advanced_post_details[extra_featured_images]['.$extra_featured_images_counter.']" type="text" value="'.esc_url($featured_image).'" /> 
						<input type="hidden" class="data_image_id" name="advanced_post_details[extra_featured_image_ids]['.$extra_featured_images_counter.']" value="'.esc_attr((isset($extra_featured_image_ids) && !empty($extra_featured_image_ids)) ? $extra_featured_image_ids[$extra_featured_images_counter] : '').'" />
						<input class="image_uploader_class btn" value="Upload Image" type="button" /> 
					</label>
					<br/>
					<div class="button extra_featured_images_remove_button">Remove Image</div>
				</div>
				<br/>
			';
			$extra_featured_images_counter++;

		}
	}else{
		$extra_featured_images_html ='
			<div class="extra_featured_image_class" ref="'.$extra_featured_images_counter.'">
				<strong>Choose an Image : </strong><br/><br/>
				<div class="hide image-data"></div>
				<label for="upload_image"> 
					<input id="extra_featured_image'.$extra_featured_images_counter.'" class="upload_image_button" size="36" name="advanced_post_details[extra_featured_images]['.$extra_featured_images_counter.']" type="text" value="" /> 
					<input class="image_uploader_class btn" value="Upload Image" type="button" /> 
				</label>
				<br/>
				<div class="button extra_featured_images_remove_button">Remove Image</div>
			</div>
			<br/>
		';
		
		$extra_featured_images_counter++;
	}
	
	$extra_featured_images_script = '
		jQuery(document).on("click",".extra_featured_images_remove_button", function(){
			jQuery(this).parent().remove();
		});
		
		jQuery(document).on("click", ".extra_featured_images_add_button", function(){
			var id = 0;
			if(jQuery(".extra_featured_image_class").length){
				id = parseInt(jQuery(".extra_featured_image_class").last().attr("ref"))+1;
			}
			
			var new_elem = "<div class=\"extra_featured_image_class\" ref=\""+id+"\">"+
				"<strong>Choose an Image : </strong><br/><br/>"+
				"<div class=\"hide image-data\"></div>"+
				"<label for=\"upload_image\"> "+
					"<input id=\"extra_featured_image"+id+"\" class=\"upload_image_button\" size=\"36\" name=\"advanced_post_details[extra_featured_images]["+id+"]\" type=\"text\" value=\"\" /> "+
					"<input class=\"image_uploader_class btn\" value=\"Upload Image\" type=\"button\" /> "+
				"</label>"+
				"<br/>"+
				"<div class=\"button extra_featured_images_remove_button\">Remove Image</div>"+
			"</div>";

			
			jQuery(".extra_featured_image_holder").append(new_elem);
		});
	';
	

	//Deprecated
	$extra_buttons_script = '';

	
	$inline_navigation_change = '
		jQuery(".display_inline_nav").change(function(){
			if(jQuery(this).find(":selected").val() === "true"){
				jQuery(".add-menu-footer-to-rin").slideDown();	
			}else{
				jQuery(".add-menu-footer-to-rin").hide();	
			}
		});
	
	';
	
	$self_bg_change = '
		jQuery(".self_bg").change(function(){
			if(jQuery(this).find(":selected").val() === "color"){
				jQuery(".self_bg_image_details").hide();	
				jQuery(".self_bg_color_details").slideDown();	
			}else if(jQuery(this).find(":selected").val() === "image"){
				jQuery(".self_bg_image_details").slideDown();	
				jQuery(".self_bg_color_details").hide();	
			}else if(jQuery(this).find(":selected").val() === "image"){
				jQuery(".self_bg_image_details").hide();	
				jQuery(".self_bg_color_details").hide();	
			}else{
				jQuery(".self_bg_image_details").hide();	
				jQuery(".self_bg_color_details").hide();	
			}
		});
	
	';
	
	$colorpicker_script = '
		jQuery(".main_hover_bg_color").wpColorPicker();
		jQuery(".self_bg_color").wpColorPicker();
	';
	
	
	
	echo '<div class="rockthemes-post-advanced-details">';//Main Container
	
	echo '
		<br/>
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-film"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Add Lightbox Video (PrettyPhoto Video)</strong><br/>
				<p>You can enter your Youtube / Vimeo video link.</p>
			</div>
			<div class="span5">
				<textarea class="" name="advanced_post_details[video_iframe_code]" rows="4">'.esc_textarea($video_iframe_code).'</textarea>
			</div>
		</div>
		<hr />

		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-columns"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Choose a Sidebar</strong><br/>
				<p>Choose your sidebar. If you do not have any sidebar, you can quickly add sidebars by clicking to "Add New Sidebar" button. If you don\'t want to use sidebar leave it empty.</p>
			</div>
			<div class="span5">
				'.rockthemes_pb_get_custom_sidebars_dropdown($custom_sidebar,false).'
			</div>
		</div>
		<hr />
		
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-link"></i>
				</div>
			</div>
			<div class="span6">
				<strong>External Link</strong><br/>
				<p>If you enter an external link, when this item displayed it will link to that link</p>
			</div>
			<div class="span5 external_link_holder">
				<input id="external_link" name="advanced_post_details[external_link]" type="text" value="'.(isset($external_link) ? esc_url($external_link) : '').'" />
			</div>
		</div>
		<hr/>
		
		
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-dashboard"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Change Background</strong><br/>
				<p>You can change background to a different background. You can choose to use an image or color for the background. This will override the general background rule for this.<br/><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" class="self_bg" name="advanced_post_details[self_bg]">
					<option value="default" '.(isset($rockthemes_advanced_post_details['self_bg']) && $rockthemes_advanced_post_details['self_bg'] === 'default' ? 'selected="selected"' : '').'>Use Default Background</option>
					<option value="color" '.(isset($rockthemes_advanced_post_details['self_bg']) && $rockthemes_advanced_post_details['self_bg'] === 'color' ? 'selected="selected"' : '').'>Use Different Color</option>
					<option value="image" '.(isset($rockthemes_advanced_post_details['self_bg']) && $rockthemes_advanced_post_details['self_bg'] === 'image' ? 'selected="selected"' : '').'>Use Different Image</option>
				</select>
				<br/><br/>
				<div class="self_bg_color_details '.((isset($rockthemes_advanced_post_details['self_bg']) && $rockthemes_advanced_post_details['self_bg'] === 'color') ? '' : 'hide').'">
					<strong>Choose Background Color : </strong><br/><br/>
					<div class="hide image-data"></div>
					<input type="text" class="self_bg_color" name="advanced_post_details[self_bg_color]" autocomplete="off" value="'.esc_attr(isset($rockthemes_advanced_post_details['self_bg_color']) && $rockthemes_advanced_post_details['self_bg_color'] !== '' ? $rockthemes_advanced_post_details['self_bg_color'] : '#f9f9f9').'" />
					<br/>
				</div>
				<div class="self_bg_image_details '.((isset($rockthemes_advanced_post_details['self_bg']) && $rockthemes_advanced_post_details['self_bg'] === 'image') ? '' : 'hide').'">
					<strong>Choose Background Image : </strong><br/><br/>
					<div class="hide image-data"></div>
					<label for="upload_image">
						<input id="self_bg_image" class="upload_image_button" size="36" name="advanced_post_details[self_bg_image]" type="text" value="'.esc_attr($self_bg_image).'" />
						<input type="hidden" class="data_image_id" name="advanced_post_details[self_bg_image_id]" value="'.esc_url((isset($self_bg_image_id) && !empty($self_bg_image_id)) ? $self_bg_image_id : '').'" />
						<input class="image_uploader_class btn" value="Upload Image" type="button" />
					</label>
					<br/><br/>
					<strong>Background Image Align</strong><br/><br/>
					<select autocomplete="off" name="advanced_post_details[self_bg_image_pos]">
						<option value="left" '.(isset($rockthemes_advanced_post_details['self_bg_image_pos']) && $rockthemes_advanced_post_details['self_bg_image_pos'] === 'left' ? 'selected="selected"' : '').'>Align Left</option>
						<option value="center" '.(isset($rockthemes_advanced_post_details['self_bg_image_pos']) && $rockthemes_advanced_post_details['self_bg_image_pos'] === 'center' ? 'selected="selected"' : '').'>Align Center</option>
						<option value="right" '.(isset($rockthemes_advanced_post_details['self_bg_image_pos']) && $rockthemes_advanced_post_details['self_bg_image_pos'] === 'right' ? 'selected="selected"' : '').'>Align Right</option>
					</select>
					<br/><br/>
					<strong>Background Image Repeat</strong><br/><br/>
					<select autocomplete="off" name="advanced_post_details[self_bg_image_repeat]">
						<option value="no-repeat" '.(isset($rockthemes_advanced_post_details['self_bg_image_repeat']) && $rockthemes_advanced_post_details['self_bg_image_repeat'] === 'no-repeat' ? 'selected="selected"' : '').'>No Repeat</option>
						<option value="repeat" '.(isset($rockthemes_advanced_post_details['self_bg_image_repeat']) && $rockthemes_advanced_post_details['self_bg_image_repeat'] === 'repeat' ? 'selected="selected"' : '').'>Tile</option>
						<option value="repeat-x" '.(isset($rockthemes_advanced_post_details['self_bg_image_repeat']) && $rockthemes_advanced_post_details['self_bg_image_repeat'] === 'repeat-x' ? 'selected="selected"' : '').'>Tile Horizontally</option>
						<option value="repeat-y" '.(isset($rockthemes_advanced_post_details['self_bg_image_repeat']) && $rockthemes_advanced_post_details['self_bg_image_repeat'] === 'repeat-y' ? 'selected="selected"' : '').'>Tile Vertically</option>
					</select>
					<br/><br/>
					<strong>Background Image Attachment</strong><br/><br/>
					<select autocomplete="off" name="advanced_post_details[self_bg_image_attach]">
						<option value="scroll" '.(isset($rockthemes_advanced_post_details['self_bg_image_attach']) && $rockthemes_advanced_post_details['self_bg_image_attach'] === 'scroll' ? 'selected="selected"' : '').'>Scroll</option>
						<option value="fixed" '.(isset($rockthemes_advanced_post_details['self_bg_image_attach']) && $rockthemes_advanced_post_details['self_bg_image_attach'] === 'fixed' ? 'selected="selected"' : '').'>Fixed</option>
					</select>
					<br/>
				</div>
			</div>
		</div>
		<hr />
		
		
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-arrows-alt"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Choose Mansonry Size</strong><br/>
				<p>You can choose different size for your masonry image.<br/><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[masonry_size]">
					<option value="" '.(isset($rockthemes_advanced_post_details['masonry_size']) && $rockthemes_advanced_post_details['masonry_size'] === '' ? 'selected="selected"' : '').'>Default</option>
					<option value="wide" '.(isset($rockthemes_advanced_post_details['masonry_size']) && $rockthemes_advanced_post_details['masonry_size'] === 'wide' ? 'selected="selected"' : '').'>Wide</option>
					<option value="tall" '.(isset($rockthemes_advanced_post_details['masonry_size']) && $rockthemes_advanced_post_details['masonry_size'] === 'tall' ? 'selected="selected"' : '').'>Tall</option>
					<option value="widetall" '.(isset($rockthemes_advanced_post_details['masonry_size']) && $rockthemes_advanced_post_details['masonry_size'] === 'widetall' ? 'selected="selected"' : '').'>Wide & Tall</option>
				</select>
			</div>
		</div>
		<hr />
		
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-dashboard"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Choose Hover Color</strong><br/>
				<p>When this item used in portfolio or hover element, you can choose a different hover color<br/><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[main_hover_bg_change]">
					<option value="" '.(isset($rockthemes_advanced_post_details['main_hover_bg_change']) && $rockthemes_advanced_post_details['main_hover_bg_change'] === '' ? 'selected="selected"' : '').'>Regular Color</option>
					<option value="yes" '.(isset($rockthemes_advanced_post_details['main_hover_bg_change']) && $rockthemes_advanced_post_details['main_hover_bg_change'] === 'yes' ? 'selected="selected"' : '').'>Change Hover Background Color</option>
				</select>
				<br/>
				<input type="text" class="main_hover_bg_color" name="advanced_post_details[main_hover_bg_color]" autocomplete="off" value="'.esc_attr(isset($rockthemes_advanced_post_details['main_hover_bg_color']) && $rockthemes_advanced_post_details['main_hover_bg_color'] !== '' ? $rockthemes_advanced_post_details['main_hover_bg_color'] : '#FFFFFF').'" />
				<br/>
				<input type="text" class="main_hover_bg_opacity" name="advanced_post_details[main_hover_bg_opacity]" autocomplete="off" placeholder="Background Color Opacity (0 - 100)" value="'.esc_attr(isset($rockthemes_advanced_post_details['main_hover_bg_opacity']) && $rockthemes_advanced_post_details['main_hover_bg_opacity'] !== '' ? $rockthemes_advanced_post_details['main_hover_bg_opacity'] : '100').'" />
			</div>
		</div>
		<hr />
		
		

		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-picture-o"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Add Extra Featured Image</strong><br/>
				<p>You can add up to 5 featured images. You can add new images by clicking to "Add Featured Image" button.</p><br/>
				<div class="button extra_featured_images_add_button"><i class="fa fa-plus"></i> Add Featured Image</div>
			</div>
			<div class="span5 extra_featured_image_holder">
				'.$extra_featured_images_html.'
			</div>
		</div>
		<hr />
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-terminal"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Disable Breadcrumbs / Title Area</strong><br/>
				<p>If you want to disable the Header Title and Breadcrumbs area, choose disable</p><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[disable_title_breadcrumbs_area]">
					<option value="false" '.(isset($rockthemes_advanced_post_details['disable_title_breadcrumbs_area']) && $rockthemes_advanced_post_details['disable_title_breadcrumbs_area'] === 'false' ? 'selected="selected"' : '').'>Do Not Disable Area</option>
					<option value="true" '.(isset($rockthemes_advanced_post_details['disable_title_breadcrumbs_area']) && $rockthemes_advanced_post_details['disable_title_breadcrumbs_area'] === 'true' ? 'selected="selected"' : '').'>Disable Area</option>
				</select>
			</div>
		</div>
		<hr />
		
		
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-adjust"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Transparent Menu/Header Area</strong><br/>
				<p>Make menu and header area transparent.</p><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[transparent_header]">
					<option value="false" '.(isset($rockthemes_advanced_post_details['transparent_header']) && $rockthemes_advanced_post_details['transparent_header'] === 'false' ? 'selected="selected"' : '').'>Regular Header</option>
					<option value="header_only" '.(isset($rockthemes_advanced_post_details['transparent_header']) && $rockthemes_advanced_post_details['transparent_header'] === 'header_only' ? 'selected="selected"' : '').'>Transparent Header</option>
				</select>
			</div>
		</div>
		<hr />
		
		
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-picture-o"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Title & Breadcrumbs Background</strong><br/>
				<p>You can set a background image for the Title and Breadcrumbs area. <br/><br/>
			</div>
			<div class="span5">
				<div class="header_bg_image" ref="icon-image-uploader">
					<strong>Choose an Image : </strong><br/><br/>
					<div class="hide image-data"></div>
					<label for="upload_image">
						<input id="header_bg_image" class="upload_image_button" size="36" name="advanced_post_details[header_bg_image]" type="text" value="'.esc_url(isset($header_bg_image) && !empty($header_bg_image) ? $header_bg_image : '').'" />
						<input type="hidden" class="data_image_id" name="advanced_post_details[header_bg_image_id]" value="'.intval((isset($header_bg_image_id) && !empty($header_bg_image_id)) ? $header_bg_image_id : '').'" />
						<input class="image_uploader_class btn" value="Upload Image" type="button" />
					</label>
					<br/>
				</div><br/><br/>
				
				<div class="header_bg_image_retina" ref="icon-image-uploader-retina">
					<strong>Choose a Retina Image : </strong><br/><br/>
					<div class="hide image-data"></div>
					<label for="upload_image">
						<input id="header_bg_image_retina" class="upload_image_button" size="36" name="advanced_post_details[header_bg_image_retina]" type="text" value="'.esc_url(isset($header_bg_image_retina) && !empty($header_bg_image_retina) ? $header_bg_image_retina : '').'" />
						<input type="hidden" class="header_bg_image_retina_id" name="advanced_post_details[header_bg_image_retina_id]" value="'.intval((isset($header_bg_image_retina_id) && !empty($header_bg_image_retina_id)) ? $header_bg_image_retina_id : '').'" />
						<input class="image_uploader_class btn" value="Upload Image" type="button" />
					</label>
					<br/>
				</div>
			</div>
		</div>
		<hr />
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-toggle-up"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Disable Header</strong><br/>
				<p>You can choose to disable header. If you leave this default, header will be displayed</p><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[disable_header]">
					<option value="" '.(isset($rockthemes_advanced_post_details['disable_header']) && $rockthemes_advanced_post_details['disable_header'] === '' ? 'selected="selected"' : '').'>Default</option>
					<option value="true" '.(isset($rockthemes_advanced_post_details['disable_header']) && $rockthemes_advanced_post_details['disable_header'] === 'true' ? 'selected="selected"' : '').'>Disable Header</option>
				</select>
			</div>
		</div>
		<hr />
		
		
		
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-arrows-v"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Space Between Header and Footer</strong><br/>
				<p>This option will add extra vertical space under header and top of the footer.</p><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[activate_space_under_menu]">
					<option value="true" '.(isset($rockthemes_advanced_post_details['activate_space_under_menu']) && $rockthemes_advanced_post_details['activate_space_under_menu'] === 'true' ? 'selected="selected"' : '').'>Add Vertical Space</option>
					<option value="false" '.(isset($rockthemes_advanced_post_details['activate_space_under_menu']) && $rockthemes_advanced_post_details['activate_space_under_menu'] === 'false' ? 'selected="selected"' : '').'>Do Not Add Vertical Space</option>
				</select>
			</div>
		</div>
		<hr />
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-archive"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Display Footer Large Area</strong><br/>
				<p>If you choose default, your choice in Theme Options for footer large area will be used.</p><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[display_footer_large_area]">
					<option value="" '.(isset($rockthemes_advanced_post_details['display_footer_large_area']) && $rockthemes_advanced_post_details['display_footer_large_area'] === '' ? 'selected="selected"' : '').'>Default</option>
					<option value="true" '.(isset($rockthemes_advanced_post_details['display_footer_large_area']) && $rockthemes_advanced_post_details['display_footer_large_area'] === 'true' ? 'selected="selected"' : '').'>Display Footer Large Area</option>
					<option value="false" '.(isset($rockthemes_advanced_post_details['display_footer_large_area']) && $rockthemes_advanced_post_details['display_footer_large_area'] === 'false' ? 'selected="selected"' : '').'>Remove Footer Large Area</option>
				</select>
			</div>
		</div>
		<hr />
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-minus"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Display Footer Bottom Area</strong><br/>
				<p>If you choose default, your choice in Theme Options for footer bottom area will be used.</p><br/>
			</div>
			<div class="span5">
				<select autocomplete="off" name="advanced_post_details[display_footer_bottom_area]">
					<option value="" '.(isset($rockthemes_advanced_post_details['display_footer_bottom_area']) && $rockthemes_advanced_post_details['display_footer_bottom_area'] === '' ? 'selected="selected"' : '').'>Default</option>
					<option value="true" '.(isset($rockthemes_advanced_post_details['display_footer_bottom_area']) && $rockthemes_advanced_post_details['display_footer_bottom_area'] === 'true' ? 'selected="selected"' : '').'>Display Footer Bottom Area</option>
					<option value="false" '.(isset($rockthemes_advanced_post_details['display_footer_bottom_area']) && $rockthemes_advanced_post_details['display_footer_bottom_area'] === 'false' ? 'selected="selected"' : '').'>Remove Footer Bottom Area</option>
				</select>
			</div>
		</div>
		<hr />
		<div class="row-fluid">
			<div class="span1">
				<div class="advanced-details-icon">
					<i class="fa fa-ellipsis-v"></i>
				</div>
			</div>
			<div class="span6">
				<strong>Display Inline Navigation</strong><br/>
				<p>If you activate this option, there will be side navigation for inline navigation. You also need to add Special Grid Blocks in RPB (Rock Page Builder) and give them ID and Title. If you do not activate this option, inline navigation will not be activated</p><br/>
			</div>
			<div class="span5">
				<select class="display_inline_nav" autocomplete="off" name="advanced_post_details[display_inline_nav]">
					<option value="" '.(isset($rockthemes_advanced_post_details['display_inline_nav']) && $rockthemes_advanced_post_details['display_inline_nav'] === '' ? 'selected="selected"' : '').'>Remove Inline Navigation</option>
					<option value="true" '.(isset($rockthemes_advanced_post_details['display_inline_nav']) && $rockthemes_advanced_post_details['display_inline_nav'] === 'true' ? 'selected="selected"' : '').'>Activate Inline Navigation</option>
				</select>
				<div class="row-fluid add-menu-footer-to-rin '.(!isset($rockthemes_advanced_post_details['display_inline_nav']) || (isset($rockthemes_advanced_post_details['display_inline_nav']) && $rockthemes_advanced_post_details['display_inline_nav'] === '') ? 'hide' : '').'">
					<p>Add Header to inline navigation. If you do not enter any title, it will not be included</p>
					<input type="text" name="advanced_post_details[rin_header_id]" placeholder="Header ID for Inline Nav" autocomplete="off" value="'.esc_attr(isset($rockthemes_advanced_post_details['rin_header_id']) && $rockthemes_advanced_post_details['rin_header_id'] !== '' ? $rockthemes_advanced_post_details['rin_header_id'] : '').'" />
					<input type="text" name="advanced_post_details[rin_header_title]" placeholder="Header Title for Inline Nav" autocomplete="off" value="'.esc_attr(isset($rockthemes_advanced_post_details['rin_header_title']) && $rockthemes_advanced_post_details['rin_header_title'] !== '' ? $rockthemes_advanced_post_details['rin_header_title'] : '').'" />
					<br/>
				</div>
			</div>
		</div>
		<hr />
		';
	
	echo '</div>'; //End of main container
	
	//Echo the scripts
	echo '
		<script type="text/javascript">
			jQuery(document).ready(function(){
				'.$extra_featured_images_script.'
				'.$extra_buttons_script.'
				'.$inline_navigation_change.'
				'.$self_bg_change.'
				'.$colorpicker_script.'
			});
		</script>
	';
	?>
    
   	<style type="text/css">
		.rockthemes-post-advanced-details .advanced-details-icon{
			font-size:40px;
			margin-left:10px;
			color:#666666;
		}
		
		.rockthemes-post-advanced-details .advanced_empty_a{cursor:pointer;}
		
		.rockthemes-post-advanced-details select, 
		.rockthemes-post-advanced-details input:not(.btn),
		.rockthemes-post-advanced-details textarea{
			padding:10px;
			border-radius:4px;
			color:#444444;
		}
		
		.rockthemes-post-advanced-details select{
			min-height:40px;	
		}

	</style>
    
    <?php
}

function rockthemes_ad_save_post_details_metabox( $post_id ) {
	global $post;	

	
	//Save Advanced Post Details
	if( isset($_POST['advanced_post_details'])){
		$rad = $_POST['advanced_post_details'];
		if(isset($rad['video_iframe_code'])){
			$rad['video_iframe_code'] = wp_kses_post($rad['video_iframe_code']);	
		}
		update_post_meta($post->ID, 'advanced_post_details', $rad);

		//Save Sidebar : This moved here to save empty sidebar choices (No sidebar chosen, Sidebar will be setted via general not strict) 
		update_post_meta( $post->ID, 'custom_sidebar_list', isset($_POST['custom_sidebar_list']) ? $_POST['custom_sidebar_list'] : '' );
	}
}
add_action( 'save_post', 'rockthemes_ad_save_post_details_metabox' );

function rockthemes_ad_get_post_details_metabox(){
	global $wp_query, $post, $rockthemes_advanced_details, $rpb_post;

	$rockthemes_advanced_details = get_post_meta(intval($rpb_post['ID']), 'advanced_post_details', true);
			
	return $rockthemes_advanced_details;
}




//Only for sidebar. This is used in the rock-widgets/load-widgets.php file.
function rockthemes_cs_get_custom_sidebar_metabox(){
	global $post, $rpb_post;
	if(!is_single() && !is_page() && !is_home() && !is_front_page() && !is_archive()) return false;

	$sidebar = get_post_meta(intval($rpb_post['ID']), 'custom_sidebar_list', true);
	return $sidebar;
}

/*
**	Rockthemes Advanced Details Get Option
**
**	@since	:	1.3
*/

function rad_get_option($option_id, $incoming_post = null){
	global $post, $wp_query, $rpb_post;

	$that_id;//That Post ID	
	if(isset($incoming_post) && !empty($incoming_post) && isset($incoming_post->ID)){
		$that_id = $incoming_post->ID;
	}elseif(isset($rpb_post) && !empty($rpb_post) && isset($rpb_post['ID'])){
		$that_id = $rpb_post['ID'];	
	}else{
		$that_id = $wp_query->get_queried_object_id();
	}
	
	if(empty($that_id)) return false;
	
	$ad = get_post_meta(intval($that_id), 'advanced_post_details', true);// Advanced Details
	
	if(!isset($ad) || empty($ad)) return false;
	
	if(!isset($ad[$option_id]) || empty($ad[$option_id])) return false;
	
	return $ad[$option_id];
}


?>