<?php
/*
**	This is the main file of any required changes in the theme
**	for the new Envato theme submission rules
**
**	@version:1.0
**	@author: XanderRock
*/

function azoom_customize_register( $wp_customize ) {

	/*
	**	Register Logo
	*/
    // Add Section
    $wp_customize->add_section('azoom_logo', array(
        'title'             => esc_html__('Site Logo', 'azoom'), 
        'priority'          => 70,
    )); 
    //Add Settings	
    $wp_customize->add_setting('azoom_logo_main', array(
    	'transport'         => 'refresh',
    	'height'         	=> 325,
    	'sanitize_callback' =>	'esc_url',
    ));
    $wp_customize->add_setting('azoom_logo_main_retina', array(
    	'transport'         => 'refresh',
    	'height'         	=> 325,
    	'sanitize_callback' =>	'esc_url',
    ));
    $wp_customize->add_setting('azoom_logo_sticky', array(
    	'transport'         => 'refresh',
    	'height'         	=> 325,
    	'sanitize_callback' =>	'esc_url',
    ));
    $wp_customize->add_setting('azoom_logo_sticky_retina', array(
    	'transport'         => 'refresh',
    	'height'         	=> 325,
    	'sanitize_callback' =>	'esc_url',
    ));

    //Add Control
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'azoom_logo_main',
			array(
				'label'      => esc_html__( 'Main Logo', 'azoom' ),
				'section'    => 'azoom_logo',
				'settings'   => 'azoom_logo_main',
			)
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'azoom_logo_main_retina',
			array(
				'label'      => esc_html__( 'Main Logo Retina', 'azoom' ),
				'section'    => 'azoom_logo',
				'settings'   => 'azoom_logo_main_retina',
			)
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'azoom_logo_sticky',
			array(
				'label'      => esc_html__( 'Sticky Logo', 'azoom' ),
				'section'    => 'azoom_logo',
				'settings'   => 'azoom_logo_sticky',
			)
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'azoom_logo_sticky_retina',
			array(
				'label'      => esc_html__( 'Sticky Logo Retina', 'azoom' ),
				'section'    => 'azoom_logo',
				'settings'   => 'azoom_logo_sticky_retina',
			)
		)
	);

}
add_action( 'customize_register', 'azoom_customize_register' );




function azoom_customizer_logo() {
	
	add_theme_support( 'custom-logo', array(
		'height'      => 100,
		'width'       => 400,
		'flex-width'  => false,
	) );

}
add_action( 'after_setup_theme', 'azoom_customizer_logo' );


?>