<?php

/*
**	Globals Functions
**
**	Most of the Rock Themes plugins and built in systems are requiring these functions.
**	For standalone plugins and widgets of Rock Themes, these functions will be prevented from the widget/plugin/feature inside
*/


/*
**	Global wp_ajax function to be called from Javascript/jQuery
*/
if(isset($_POST['action'])){
	
	if(function_exists('wp_ajax_' . $_POST['action'])){
		do_action( 'wp_ajax_' . $_POST['action'] );
	}
	
}



if(!function_exists('rockthemes_woocommerce_active')):
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/*
**	Rockthemes WooCommerce Integration
**	@return : true if WooCommerce installed and activated, false if not activated
*/
function rockthemes_woocommerce_active(){

	if(class_exists('WooCommerce')) return true;

	return false;

}
endif;



if(!function_exists('rockthemes_bbpress_active')):
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/*
**	Rockthemes WooCommerce Integration
**	@return : true if WooCommerce installed and activated, false if not activated
*/
function rockthemes_bbpress_active(){

	if(class_exists('bbPress')) return true;

	return false;

}
endif;








if(!function_exists('rockthemes_escaped_out_render')):
function rockthemes_escaped_out_render($val){
	return $val;
}
endif;



/*
**	Sidebar Alignment
**	Rock Custom Sidebar system allows 5 different alignment for the sidebar
**	
**	This function generates a list object with 5 different alignment for sidebars
**
*/
if(!function_exists('rockthemes_cs_make_sidebar_alignment_list')){
	function rockthemes_cs_make_sidebar_alignment_list(){
		$return = '
			<h4>Choose your sidebar alignment</h4>
			<select class="sidebar-alignment-list">
				<option value="leftleft">Left Left</option>
				<option value="left">Left</option>
				<option value="right">Right</option>
				<option value="rightright">Right Right</option>
			</select>
		';	
		
		return $return;
	}
}


/*
**	Rock Builder Uses 12 Columns Grid system
**	This function generates a list object for 12 column
**	@param $selected = selected column value
*/
if(!function_exists('rockthemes_pb_make_columns_list')){
	function rockthemes_pb_make_columns_list($selected = null){
		
		if(isset($selected)){
			$selected = intval($selected);	
		}
		
		$return = '<div class="columns_select_holder">
						<h4>Select Columns</h4>
						<select class="columns_select">';
		
		if($selected === 1){
			$return .= '<option value="1" selected>One Column</option>';
		}else{
			$return .= '<option value="1">One Column</option>';
		}
		
		if($selected === 2){
			$return .= '<option value="2" selected>Two Column</option>';
		}else{
			$return .= '<option value="2">Two Column</option>';
		}
		
		if($selected === 3){
			$return .= '<option value="3" selected>Three Column</option>';
		}else{
			$return .= '<option value="3">Three Column</option>';
		}
		
		if($selected === 4){
			$return .= '<option value="4" selected>Four Column</option>';
		}else{
			$return .= '<option value="4">Four Column</option>';
		}
		
		if($selected === 5){
			$return .= '<option value="5" selected>Five Column</option>';
		}else{
			$return .= '<option value="5">Five Column</option>';
		}
		
		if($selected === 6){
			$return .= '<option value="6" selected>Six Column</option>';
		}else{
			$return .= '<option value="6">Six Column</option>';
		}
		
		if($selected === 7){
			$return .= '<option value="7" selected>Seven Column</option>';
		}else{
			$return .= '<option value="7">Seven Column</option>';
		}
	
		if($selected === 8){
			$return .= '<option value="8" selected>Eight Column</option>';
		}else{
			$return .= '<option value="8">Eight Column</option>';
		}
	
		if($selected === 9){
			$return .= '<option value="9" selected>Nine Column</option>';
		}else{
			$return .= '<option value="9">Nine Column</option>';
		}
	
		if($selected === 10){
			$return .= '<option value="10" selected>Ten Column</option>';
		}else{
			$return .= '<option value="10">Ten Column</option>';
		}
	
		if($selected === 11){
			$return .= '<option value="11" selected>Eleven Column</option>';
		}else{
			$return .= '<option value="11">Eleven Column</option>';
		}
	
		if($selected === 12){
			$return .= '<option value="12" selected>Twelve Column</option>';
		}else{
			$return .= '<option value="12">Twelve Column</option>';
		}
	
		$return .= '</select></div>';
		
		return $return;
	}
}




if(!function_exists('rockthemes_demo_image')):
/*
**	We use a demo image when demo data loaded. This feature can be turned off in Theme Options.
**
**	@attr	:	$size:String Image Size. Since the demo image is the same for all size
**						this will only affect img width, height attributes
**
**	@attr	:	$only_url:Boolean, If true, only URL of the image will be returned. Otherwise
**						HTML img element will be returned
**
**	@since	:	1.0
*/
function rockthemes_demo_image($size = '', $only_url = false){
	
	if(xr_get_option('enable_demo_image', false) !== true) return '';
	
	$alt = esc_html__('Demo Image', 'azoom');

	$image = esc_url(xr_get_option('demo_image_url',''));
	
	if($image === '') return '';
	
	
	if(function_exists('rockthemes_get_image_id_from_url')){
		$upload_dir = wp_upload_dir();
		$image_id = rockthemes_get_image_id_from_url($upload_dir['url'].'/'.basename($image));

		if($image_id != ''){
			$image_test = wp_get_attachment_image_src($image_id, esc_attr($size));
			if($image_test){
				$image = $image_test[0];	
			}
		}
	}
	
	if(!$only_url){
		$image = '<img src="'.esc_url($image).'" alt="'.esc_attr($alt).'"';
		
		if(!xr_get_option('remove_image_wh', true) && $size !== ''){
			$sizes = rockthemes_demo_image_sizes(esc_attr($size));
			
			if($sizes && isset($sizes['width']) && isset($sizes['height'])){
				$image .= ' width="'.esc_attr($sizes['width']).'" height="'.esc_attr($sizes['height']).'"';
			}
		}
		
		$image .= ' />';
	}
	
	return $image;
}
endif;




if(!function_exists('rockthemes_demo_image_sizes')):
/*
**	Only for demo images. This function is the same functions at Wordpress. Ref ;
**
**	http://codex.wordpress.org/Function_Reference/get_intermediate_image_sizes
**
*/
function rockthemes_demo_image_sizes( $size = '' ) {

	global $_wp_additional_image_sizes;

	if(isset($size)){
		$size = esc_attr($size);	
	}
		
	$sizes = array();
	$get_intermediate_image_sizes = get_intermediate_image_sizes();

	// Create the full array with sizes and crop info
	foreach( $get_intermediate_image_sizes as $_size ) {

		if ( in_array( $_size, array( 'thumbnail', 'medium', 'large' ) ) ) {

			$sizes[ $_size ]['width'] = get_option( $_size . '_size_w' );
			$sizes[ $_size ]['height'] = get_option( $_size . '_size_h' );
			$sizes[ $_size ]['crop'] = (bool) get_option( $_size . '_crop' );

		} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {

			$sizes[ $_size ] = array( 
				'width' => $_wp_additional_image_sizes[ $_size ]['width'],
				'height' => $_wp_additional_image_sizes[ $_size ]['height'],
				'crop' =>  $_wp_additional_image_sizes[ $_size ]['crop']
			);

		}

	}

	// Get only 1 size if found
	if ( $size ) {

		if( isset( $sizes[ $size ] ) ) {
			return $sizes[ $size ];
		} else {
			return false;
		}

	}

	return $sizes;
}
endif;








/*
**	Checks if the browser is IE9. 
**
**	@return	:	Boolean, True if the browser is IE9
**	@since	:	1.0
**
*/
function rockthemes_browser_ie9(){
	if(!isset($_SERVER['HTTP_USER_AGENT']) || empty($_SERVER['HTTP_USER_AGENT'])) return false;
	return preg_match('/(?i)msie 9/',$_SERVER['HTTP_USER_AGENT']) == 1 ? true : false;
}





/*
**	We use some special hooks for plugins for performance improvement. This function makes plugins
**	widgets and extra features to recognize we are using a rockthemes theme. 
**
**	!Attention	:	Do not remove or change these functions
*/
function rockthemes_switched_to_rockthemes(){
	update_option('rockthemes_theme_active',true);
}
add_action('after_switch_theme', 'rockthemes_switched_to_rockthemes');
function rockthemes_switched_to_other_themes(){
	update_option('rockthemes_theme_active',false);
}
add_action('switch_theme', 'rockthemes_switched_to_other_themes');









?>