<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7 lt-ie9" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8 lt-ie9" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 9]>
<html class="ie ie9" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />

<?php if(xr_get_option('disable_responsivity', false) === false): ?>
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes">
<?php else: ?>
<meta name="viewport" content="width=<?php echo str_replace('px','',esc_html(xr_get_option('main_layout_grid',''))); ?>">
<?php endif; ?>
 
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />





<?php
    /*
     *  Add this to support sites with sites with threaded comments enabled.
     */
    if ( is_singular() && get_option( 'thread_comments' ) )
        wp_enqueue_script( 'comment-reply' );
  
    wp_head();
?>

</head>
<body <?php body_class(); ?> <?php rockthemes_schema_body(); ?>>


<?php if( xr_get_option('use_boxed_layout',false)): ?>
	<div id="main-canvas">
	    <div class="main-container">
<?php else : ?>
    <div id="main-container" class="main-container">
<?php endif; ?>

<?php get_template_part('header', 'models'); ?>