<?php


//Get Theme Options details
$logo					=	xr_get_option('company_logo','');
$logo_retina			=	xr_get_option('company_logo_retina','');
$sticky_logo			=	xr_get_option('company_sticky_logo', '');
$sticky_logo_retina		=	xr_get_option('company_sticky_logo_retina', '');

//Customizer Get
$logo 					=	esc_url(get_theme_mod('azoom_logo_main') ? get_theme_mod('azoom_logo_main') : $logo);
$logo_retina			=	esc_url(get_theme_mod('azoom_logo_main_retina') ? get_theme_mod('azoom_logo_main_retina') : $logo_retina);
$sticky_logo			=	esc_url(get_theme_mod('azoom_logo_sticky') ? get_theme_mod('azoom_logo_sticky') : $sticky_logo);
$sticky_logo_retina		=	esc_url(get_theme_mod('azoom_logo_sticky_retina') ? get_theme_mod('azoom_logo_sticky_retina') : $sticky_logo_retina);


$current_model			=	(int) xr_get_option('header_model', 1);
$header_location		=	xr_get_option('header_location','top_navigation');
$social_icons			=	json_decode(xr_get_option('social_icons',''), true);
$header_contact_info	=	wp_kses_post(xr_get_option('header_contact_info','<strong> Call Us:</strong> +1 555 5 555 | <strong> Email : </strong><a href="mailto:you@yoursite.come">you@yoursite.come</a>'));
$use_header_top_2		=	xr_get_option('enable_header_top',true);
$header_sticky			=	xr_get_option('enable_sticky_menu',true);
$main_menu_model		=	xr_get_option('main_menu_model', 'regular');
$search_model			=	xr_get_option('search_model', 'search_centered');
$is_rock_mobile			=	xr_get_option('rockthemes_mobile_menu','mobile_menu') === 'mobile_menu' ? true : false;


//Add Html tags to elements
$logo_html				=	'<div class="logo-container"><a href="'.(function_exists('icl_get_home_url') ? icl_get_home_url() : get_home_url()).'" title="'.get_bloginfo('name').'"><img src="'.esc_url($logo).'" srcset="'.esc_url($logo).' 1x, '.esc_url($logo_retina).' 2x" alt="'.get_bloginfo('name').'" '.(xr_get_option('remove_image_wh', true) !== true ? 'width="'.(intval(xr_get_option('logo_width','190px'))).'" height="'.(intval(xr_get_option('logo_height','80px'))).'" ' : '').' style="max-width:'.esc_attr(xr_get_option('logo_width','190px')).'; max-height:'.esc_attr(xr_get_option('logo_height','80px')).'; width:100%;" /></a></div>';
$sticky_logo_html		=	'<div class="sticky-logo-container"><a href="'.(function_exists('icl_get_home_url') ? icl_get_home_url() : get_home_url()).'" title="'.get_bloginfo('name').'"><img src="'.esc_url($sticky_logo).'" srcset="'.esc_url($sticky_logo).' 1x, '.esc_url($sticky_logo_retina).' 2x" alt="'.get_bloginfo('name').'" '.(xr_get_option('remove_image_wh', true) !== true ? 'width="'.(intval(xr_get_option('sticky_logo_width','190px'))).'" height="'.(intval(xr_get_option('sticky_logo_height','80px'))).'" ' : '').' style="max-width:'.esc_attr(xr_get_option('sticky_logo_width','190px')).'; max-height:'.esc_attr(xr_get_option('sticky_logo_height','80px')).'; width:100%;" /></a></div>';
$social_html			=	'<div class="header-social-container">'.(isset($social_icons['shortcode']) && !empty($social_icons['shortcode']) ? (shortcode_exists('rockthemes_social_icons') ? do_shortcode($social_icons['shortcode']) : '' ) : '').'</div>';
$wpml_select			=	'';
if(xr_get_option('header_top_2_wpml', false)){
	ob_start();
	do_action('icl_language_selector');
	$wpml_select			=	ob_get_contents();
	$wpml_select			=	$wpml_select !== '' ? '<div class="header-wpml-container">'.$wpml_select.'</div>' : '';
	ob_get_clean();
}
ob_start();
if(dynamic_sidebar('Header Top Right'));
$header_top_2_widget	=	ob_get_contents();
$header_top_2_widget	=	$header_top_2_widget !== '' ? '<div class="header-top-2-widget-area">'.$header_top_2_widget.'</div>' : '';
ob_get_clean();

$azoom_undermenu_contents	=	apply_filters('azoom_undermenu_contents', '');//Filter for extra content. Used by WooCommerce
$azoom_undermenu_buttons 	=	apply_filters('azoom_undermenu_buttons', '');//Filter for extra buttons. Used by WooCommerce
$azoom_search			=	'';
$loader_motion			=	(function_exists('rockthemes_loader_motion') ? rockthemes_loader_motion('azoom-search-loader') : '<img src="'.esc_url(F_WAY.'/images/ajax-loader.gif').'" alt="'.esc_html__('Loading','azoom').'" />');
if($search_model == 'search_centered'){
	$azoom_search		=	'<div class="azoom-ajax-search-wrapper large-6 large-centered columns">
								<div class="azoom-ajax-search-box '.esc_attr($search_model).'">
									<form role="search" method="get" id="searchform" class="searchform" action="'.esc_url( home_url( '/' ) ).'">
										<input type="text" tabindex="-1" name="s" id="s" class="rockthemes-ajax-search-input azoom-transition" autocomplete="off" placeholder="'.esc_html__('Type To Search..','azoom').'" value="" />
									</form>
									<span class="ajax-loading-icon azoom-transition">'.esc_attr($loader_motion).'</span>
									<span class="close-search-icon azoom-transition">&times;</span>
									<div class="clear"></div>
									<div class="ajax-search-results"></div>
								</div>
							</div>
							';
}elseif($search_model == 'search_full'){
	$azoom_search		=	'	
							<div class="azoom-ajax-search-wrapper azoom-ajax-search-box '.esc_attr($search_model).'">
								<form role="search" method="get" id="searchform" class="searchform" action="'.esc_url( home_url( '/' ) ).'">
									<input type="text" tabindex="-1" name="s" id="s" class="rockthemes-ajax-search-input azoom-transition" autocomplete="off" placeholder="'.esc_html__('Type To Search..','azoom').'" value="" />
								</form>
								<span class="ajax-loading-icon azoom-transition">'.$loader_motion.'</span>
								<span class="close-search-icon azoom-transition">&times;</span>
								<div class="clear"></div>
								<div class="ajax-search-results"></div>
							</div>
							';
}


$add_woo_icon_to_menu	=	(function_exists('rockthemes_woocommerce_active') && function_exists('xr_get_option') && rockthemes_woocommerce_active() && xr_get_option('add_cart_icon_to_menu', false)) ? true : false;
if($add_woo_icon_to_menu){
	add_filter( 'wp_nav_menu_items', 'rockthemes_add_cart_icon_to_menu', 10, 2);
}

$menu_shadow_class		= (function_exists('xr_get_option') && xr_get_option('enable_sticky_header_glow', false)) ? 'menu-box-shadow' : '';


/*
**	Header ID will be added if Inline Navigation has header id. This variable will make sure it added to the correct place
*/
$header_rin_id = function_exists('rad_get_option') ? rad_get_option('rin_header_id', false) : false;
$header_rin_id_html = isset($header_rin_id) && $header_rin_id && $header_rin_id !== '' ? 'id="'.esc_attr($header_rin_id).'"' : '';




/*
**	Under Menu Details Area
**
*/
$under_menu_details_html = '';
if(function_exists('xr_get_option') && xr_get_option('add_search_box_to_menu', true) || $add_woo_icon_to_menu){
	$under_menu_details_html = '
		<div class="azoom-undermenu-mask">
			<div class="azoom-undermenu-box">
				<div class="azoom-undermenu-box-background">
					<div class="row">
						<div class="large-12 columns">
							'.$azoom_search.'
							'.$azoom_undermenu_contents.'
							<div class="undermenu-box-button-cover border-radius-class azoom-transition">
								<a href="#" class="large-12 small-12 columns search-results-button undermenu-box-button border-radius-class azoom-transition">
									'.esc_html__('Search Results','azoom').' 
								</a>
								'.$azoom_undermenu_buttons.'
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	';
}


/*
**	Header Models
**
**
**
*/

$header_return = '';


/*
**	Switch between header models
**	
**	@since	:	1.0
*/
switch($current_model){
	
	//1 - Left Logo - Right Menu (Default)
	case 1:
	
	//Include special search box to the menu
	if(xr_get_option('add_search_box_to_menu', true)){
		add_filter( 'wp_nav_menu_items', 'azoom_add_search_to_menu', 11, 2 );
	}
			
	if($header_sticky){
		$header_return .= '<div '.((isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="sticky-header-wrapper '.($header_location === 'side_navigation' ? 'hide' : '').' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').'">';
	}

	$header_return .= '
		<div '.((isset($header_sticky) && $header_sticky) || (isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="main-header-area '.($header_location === 'side_navigation' ? 'hide' : '').' '.$menu_shadow_class.' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').' header-top-1 '.($header_sticky ? 'header-sticky' : '').'">
			<div class="row header-row">
				<div class="logo-main-wrapper left-text">'
					.($header_sticky ? '<div class="logo-animation-container">' : '')
					.$logo_html.($header_sticky ? $sticky_logo_html : '')
					.($header_sticky ? '</div>' : '').'
				</div>
				<div class="nav-main-wrapper '.($is_rock_mobile ? 'right-text-responsive' : 'centered-text-responsive').'">
					'.azoom_get_nav_menu(false).'
				</div>
			</div>
			'.$under_menu_details_html.'
		</div>
	';
	
	if($header_sticky){
		$header_return .= '</div>';//sticky-header-wrapper
	}	

	break;
	

	//2	-	Left Menu - Right Logo
	case 2:
	
	//Include special search box to the menu
	if(xr_get_option('add_search_box_to_menu', true)){
		add_filter( 'wp_nav_menu_items', 'azoom_add_search_to_menu', 11, 2 );
	}
		
			
	if($header_sticky){
		$header_return .= '<div '.((isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="sticky-header-wrapper '.($header_location === 'side_navigation' ? 'hide' : '').' '.$menu_shadow_class.' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').'">';
	}
	
	$header_return .= '
		<div '.((isset($header_sticky) && $header_sticky) || (isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="main-header-area '.($header_location === 'side_navigation' ? 'hide' : '').' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').' header-top-1 '.($header_sticky ? 'header-sticky' : '').'">
			<div class="row header-row">
				<div class="nav-main-wrapper '.($is_rock_mobile ? 'left-text-responsive' : 'centered-text-responsive').'">
					'.azoom_get_nav_menu(false).'
				</div>
				<div class="logo-main-wrapper right-text">'
					.($header_sticky ? '<div class="logo-animation-container">' : '')
					.$logo_html.($header_sticky ? $sticky_logo_html : '')
					.($header_sticky ? '</div>' : '').'
				</div>
			</div>
			'.$under_menu_details_html.'
		</div>
	';
	
	if($header_sticky){
		$header_return .= '</div>';//sticky-header-wrapper
	}	

	break;
	
	
	//3	-	Centered Logo - Centered Menu
	case 3:
	
	//Include special search box to the menu
	if(xr_get_option('add_search_box_to_menu', true)){
		add_filter( 'wp_nav_menu_items', 'azoom_add_search_to_menu', 11, 2 );
	}
		
			
	if($header_sticky){
		$header_return .= '<div '.((isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="sticky-header-wrapper '.($header_location === 'side_navigation' ? 'hide' : '').' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').'">';
	}
	
		
	$header_return .= '
		<div '.((isset($header_sticky) && $header_sticky) || (isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="main-header-area '.($header_location === 'side_navigation' ? 'hide' : '').' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').' header-top-1 '.($header_sticky ? 'header-sticky' : '').'">
			<div class="header-row row">
				<div class="logo-main-wrapper large-12 medium-12 small-12 columns text-center">'
					.($header_sticky ? '<div class="logo-animation-container">' : '')
					.$logo_html.($header_sticky ? $sticky_logo_html : '')
					.($header_sticky ? '</div>' : '').'
				</div>
				<div class="large-12 medium-12 small-12 columns center-text centered-text-responsive">
					'.azoom_get_nav_menu(false).'
				</div>
			</div>
			'.$under_menu_details_html.'
		</div>
	';
	
	if($header_sticky){
		$header_return .= '</div>';//sticky-header-wrapper
	}	

	break;
	
	
	//4	-	Centered Logo - Left Menu, Right Cart, Right Search
	case 4:
	
	//Include special search box to the menu
	if(xr_get_option('add_search_box_to_menu', true)){
		add_filter( 'wp_nav_menu_items', 'azoom_add_search_to_menu', 1, 2 );
	}
		
	
	if($header_sticky){
		$header_return .= '<div '.((isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="sticky-header-wrapper '.($header_location === 'side_navigation' ? 'hide' : '').' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').'">';
	}
	
	
	$header_return .= '
		<div '.((isset($header_sticky) && $header_sticky) || (isset($use_header_top_2) && $use_header_top_2) ? '' : $header_rin_id_html).' class="main-header-area '.($header_location === 'side_navigation' ? 'hide' : '').' '.(xr_get_option('font_loading_active', true) === true ? 'not-visible' : '').' header-top-1 '.($header_sticky ? 'header-sticky' : '').'">
			<div class="header-row row">
				<div class="logo-main-wrapper large-12 medium-12 small-12 columns text-center">'
					.($header_sticky ? '<div class="logo-animation-container">' : '')
					.$logo_html.($header_sticky ? $sticky_logo_html : '')
					.($header_sticky ? '</div>' : '').'
				</div>
				<div class="large-12 medium-12 small-12 columns center-text centered-text-responsive">
					<div class="relative-container">
						'.azoom_get_nav_menu(false).'
					</div>
				</div>
			</div>
			'.$under_menu_details_html.'
		</div>
	';
	
	if($header_sticky){
		$header_return .= '</div>';//sticky-header-wrapper
	}	

	break;
		
}



/*
**	Rock Page Builder Contents Above Header
**	We use return for each RPB elements, however there can be 3rd party system which may not use return but echo.
**	Thus we use ob_start() and ob_get_clean() functions to get contents
**
**	@since	:	1.3
*/
echo '<!-- Before Header Area -->';
echo '<div id="before-header" class="rockthemes-before-header intro-effect-slide">';
do_action('rockthemes_pb_frontend_before_header');
echo '</div>';
echo '<!-- /End of Before Header Area -->';



//Wrap all header to use a background image
echo '<!-- Main Header Area -->';
echo '<div class="header-all-wrapper azoom-transition header-model-'.esc_attr($current_model).'">';

if(rad_get_option('disable_header','') !== 'true'){
/*
**	Disable Header and menu
**
**	@since	:	1.3
*/
	if($use_header_top_2){
	?>
	<div <?php echo rockthemes_escaped_out_render($header_rin_id_html); ?> class="header-top-2 <?php echo rockthemes_escaped_out_render($header_location === 'side_navigation' ? 'hide' : ''); ?> <?php echo rockthemes_escaped_out_render($wpml_select !== '' ? 'wpml-selector-active' : ''); ?> <?php echo xr_get_option('font_loading_active', true) === true ? 'not-visible' : ''; ?>">
        <div class="row">
        	<div class="large-12 columns">
                <div class="row">
					<div class="large-6 medium-6 small-12 <?php echo (is_rtl() ? 'left-text' : ''); ?> text-overflow columns header-top-2-font-size header-social-line-height header-contact-info centered-text-responsive"><span><?php echo rockthemes_escaped_out_render($header_contact_info); ?></span></div>
					<div class="large-6 medium-6 small-12 columns right-text centered-text-responsive header-top-2-responsive-inline-block social-no-margin wpml-in-ht2"><?php echo rockthemes_escaped_out_render($social_html); ?><?php echo rockthemes_escaped_out_render($header_top_2_widget); ?><?php echo rockthemes_escaped_out_render($wpml_select); ?></div>
                </div>
            </div>
		</div>
	</div>
	<?php
					
	}
	echo rockthemes_escaped_out_render($header_return);
}

if(!is_404()){
	$rockthemes_advanced_post_details = rockthemes_ad_get_post_details_metabox();
		
	if((isset($rockthemes_advanced_post_details['disable_title_breadcrumbs_area']) && 
	$rockthemes_advanced_post_details['disable_title_breadcrumbs_area'] === 'true')){
		//Do not include anything if disabled
		if(rockthemes_woocommerce_active() && is_woocommerce()){
			remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
		}
	}elseif(xr_get_option('disable_breadcrumbs_title_area', false)){
		//Get the title and breadcrumb template
		$azoom_disable_regular_title = true;
	}elseif(function_exists('is_woocommerce') && xr_get_option('woo_disable_breadcrumbs_title_area',false) && (is_woocommerce() || is_shop() || is_checkout())){
		//WooCommerce enabled	
		remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
	}else{
		//Get the title and breadcrumb template
		get_template_part('title','default');
		$azoom_disable_regular_title = true;
	}
}
/*
**	.header-all-wrapper in header-models.php
*/
echo '</div>';
echo '<!-- /End of Main Header Area -->';


/*
**	.header-all-wrapper div will be closed in rockthemes_pb_frontend_before_page filter
*/
?>