<?php






/*
**	#######	Overridable Functions	#########
**	
**	Functions down below are overridable. This functions can be override by a child theme.
**	You can use our child theme to change any of these functions. You can also change these functions as well.
**	But we strongly recommend using a childtheme for file based changes to prevent any updating problem in further.
*/





/*
**	Down Arrow Button to slide to the next special grid
**
**	@since	:	1.3
**
*/
if(!function_exists('rockthemes_op_make_down_arrow')):
/*
**	Down Arrow Button to slide to the next special grid
**
**	@since	:	1.3
**
*/
function rockthemes_op_make_down_arrow($color = '#f9f9f9'){
	$down_arrow_icon = '';
		
	//Reason of double icomoon (in both if and else) is to supporting both libraries
	if(defined('RPB_USE_ICOMOON')){
		$down_arrow_icon = '
		<i class="azoom-down-arrow-icon icomoon icomoon-icon-azoom-arrow-down azoom-small-text-shadow"></i>';
	}
	
	/*removed enable-animate*/
	$return = '
		<div class="azoom-down-arrow-container" style="color:'.esc_attr($color).'">
			'.$down_arrow_icon.'
		</div>
	';	
	
	return $return;
}
endif;







if(!function_exists('azoom_after_header_title_hook')):
/*
**	This function or hook can be used to add extra content after header title and breadcrumbs.
**	This function is called from "title-default.php"
**
*/
function azoom_after_header_title_hook(){
	//Do Nothing
}
endif;
add_action('azoom_after_header_title','azoom_after_header_title_hook');


if(!function_exists('azoom_before_footer_hook')):
/*
**	This function or hook can be used to add extra content before footer.
**	This function is called from "footer.php"
**
*/
function azoom_before_footer_hook(){
	//Do Nothing
}
endif;
add_action('azoom_before_footer','azoom_before_footer_hook');












if(!function_exists('azoom_alter_default_comment_form')):
/*
**	Alter the Wordpress Comment Form values and variables
**
*/
function azoom_alter_default_comment_form($defaults){
	$fields = array('author' => '<div class="row"><div class="large-4 columns"><input name="author" id="author" class="comments-field inputs-class" placeholder="'.esc_html__('Name :','azoom').'" type="text"></div>',
					'email' => '<div class="large-4 columns"><input name="email" id="email" class="comments-field inputs-class" style="margin-right:0px;" placeholder="'.esc_html__('Email :','azoom').'" type="text"></div>',
					'url' => '<div class="large-4 columns"><input name="url" id="url" class="comments-field inputs-class" placeholder="'.esc_html__('Website :','azoom').'" type="text"></div></div>');
	
	$defaults['fields'] = apply_filters( 'comment_form_default_fields', $fields );
	$defaults['title_reply'] = esc_html__('Leave a Comment','azoom');
    $defaults['comment_notes_before'] = '';
    $defaults['comment_notes_after'] = '';
	$defaults['comment_field'] = '<textarea class="comments-field inputs-class" placeholder="'.esc_html__('Your Message :','azoom').'" name="comment" id="comment"></textarea>';
	$defaults['id_submit'] = 'comments-submit';

    return $defaults;
}
endif;
add_filter('comment_form_defaults','azoom_alter_default_comment_form');






/*
**	You can always change the background in "Appearance > Background". This hook will activate
**	custom-background and add a default value
**
**
*/
$azoom_custom_background_args = array(
	'default-color' => 'f0f0f0',
	'default-image' => '',
);
add_theme_support( 'custom-background', $azoom_custom_background_args );






/*
**	Wordpress's Required Functions
*/

if(!function_exists('azoom_content_width')):
/*
 * Adjusts content_width value for video post formats and attachment templates.
 *
 * @since Azoom 1.0
 *
 * @return void
 */
function azoom_content_width() {
	global $content_width;

	if ( is_attachment() )
		$content_width = 724;
	elseif ( has_post_format( 'audio' ) )
		$content_width = 484;
}
endif;
add_action( 'template_redirect', 'azoom_content_width' );





if(!function_exists('azoom_favico')):
/*
**	Add Favico to header
**	@since	:	Azoom 1.0
*/
function azoom_favico() {
    echo '<link rel="shortcut icon" type="image/x-icon" href="'.esc_url(xr_get_option('company_logo_favicon', F_WAY.'/images/demo/favico.ico')).'" />';
}
endif;
add_action( 'wp_head', 'azoom_favico' );








if(!function_exists('azoom_get_post_type_icon_class')):
/*
**	Generates the icon for different post type. This function
**	will only work for 'post' post format
**	
**	@param	:	$post_format String, 
**	@return	:	HTML class of the icon
**	@since	:	1.0
**
*/
function azoom_get_post_type_icon_class($post_format = ''){

	global $post;

	if(!$post) return false;
	
	$post_format = get_post_format();
	
	$return = 'icomoon ';
	
	//Check if the post format is default
	if(!$post_format){
		//Post format is default. Default post format returns false from get_post_format() function
		$return .= 'icomoon-icon-pencil2';
	}else{
		switch($post_format){
			case 'gallery':
			$return .= 'icomoon-icon-images';
			break;	
			
			case 'image':
			$return .= 'icomoon-icon-image';
			break;
			
			case 'audio':
			$return .= 'icomoon-icon-headphones';
			break;
			
			case 'video':
			$return .= 'icomoon-icon-film';
			break;
			
			case 'aside':
			$return .= 'icomoon-icon-file4';
			break;
			
			case 'status':
			$return .= 'icomoon-icon-bubble';
			break;
			
			case 'link':
			$return .= 'icomoon-icon-link';
			break;
			
			case 'quote':
			$return .= 'icomoon-icon-quotes-left';
			break;
			
			case 'chat':
			$return .= 'icomoon-icon-bubbles4';
			break;
		}
	}
	
	
	return $return;
}
endif;










if(!function_exists('azoom_get_boxed_date')):
function azoom_get_boxed_date(){
	global $post;
	if(!$post) return false;
	
	
	$date = '
		<div class="date-area data updated">
			<a href="'.get_month_link(get_the_time('Y'), get_the_time('m')).'" class="escapea">
				<div class="day-area">'.get_the_time('d', $post->ID).'</div>
				<span class="month-area">'.get_the_date('M').'</span>
				<span class="year-area">'.get_the_time('Y', $post->ID).'</span>
			</a>
		</div>
	';
	
	
	
	$post_format = '';
	if(xr_get_option('blog_single_feature_format', true)):
	$post_format = azoom_get_post_format_icon();
	$post_format = '<div class="post-format-container">'.$post_format.'</div>';
	endif;
	
	$entry_love = '';
	if(xr_get_option('blog_single_feature_love',true)):
	$entry_love = '
		<a href="#" class="disable-link escapea"><i class="icomoon icomoon-icon-heart"></i></a>
		<span>'.azoom_get_love_num().'</span>
	';
	$entry_love = '<div class="entry-love-container azoom-love-icon azoom-transition" data-post-id="'.$post->ID.'">'.$entry_love.'</div>';
	endif;
	
	$sticky = '';
	if ( is_sticky() && is_home() && ! is_paged() ){
		$sticky = '<div class="entry-sticky-container"><i class="icomoon icomoon-icon-pushpin"></i></div>';
	}
	
	
	$return = '
	<div class="article-date-post-format azoom-small-box-shadow">
		'.$sticky.'
		<div class="date-area-container">'.$date.'</div>
		'.$post_format.'
		'.$entry_love.'
		<div class="clear"></div>
	</div>';
	
	return $return;
}
endif;








if(!function_exists('azoom_get_post_share')):
/*
**	Social share buttons for the blog posts. Currently support 4 social buttons :
**
**	Facebook
**	Twitter
**	Google+
**	Pinterest
**
**	@param	:	$args array with $social_html and $social_js. Allows to add extra entry at the beginning
**	@return	:	Returns the social media button in HTML
*/
function azoom_get_post_share($args=null){
	global $post;
		
	$social_html	=	'';
	$social_js		=	'';
	
	if($args && is_array($args)){
		extract($args);
	}
	
	if(xr_get_option('blog_single_share_facebook', true) === true):
	//Facebook
	$social_html	.=	'<div class="fb-like" data-href="'.get_permalink().'" data-width="90" data-layout="button_count" data-show-faces="false" data-send="false"></div>';	
	$social_js		.=	'
		(function(d, s, id) {
		  var js, fjs = d.getElementsByTagName(s)[0];
		  if (d.getElementById(id)) return;
		  js = d.createElement(s); js.id = id;
		  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
		  fjs.parentNode.insertBefore(js, fjs);
		}(document, "script", "facebook-jssdk"));
	';
	endif;
	
	if(xr_get_option('blog_single_share_twitter', true) === true):
	//Twitter
	$social_html	.=	'<a href="//twitter.com/share" class="twitter-share-button">Tweet</a>';
	$social_js		.=	'!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?"http":"https";if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document, "script", "twitter-wjs");';
	endif;
	
	if(xr_get_option('blog_single_share_google', true) === true):
	//Google+
	$social_html	.=	'<div class="g-plusone" data-size="medium"></div>';
	$social_js		.=	'
	  (function() {
		var po = document.createElement("script"); po.type = "text/javascript"; po.async = true;
		po.src = "https://apis.google.com/js/plusone.js";
		var s = document.getElementsByTagName("script")[0]; s.parentNode.insertBefore(po, s);
	  })();
	';
	endif;
	
	if(xr_get_option('blog_single_share_pinterest', true) === true):
	//Pinterest
	$pinterest_html	=	'<a href="//pinterest.com/pin/create/button/?url='.get_permalink().'&media='.get_permalink().'&description='.get_permalink().'" data-pin-do="buttonPin" data-pin-config="beside"><img src="//assets.pinterest.com/images/pidgets/pin_it_button.png" alt="Pin It" /></a>';
	$pinterest_html = str_replace('&', '&amp;', $pinterest_html);
	
	$social_html 	.=	$pinterest_html;
	endif;
	
	$social_html	=	apply_filters('azoom_post_social_html',$social_html);
	$social_js		=	apply_filters('azoom_post_social_js',$social_js);
	
	$return		=	'';
	
	if($social_html == ''){
		return '';	
	}
	
	$return		.=	'<script type="text/javascript">'.$social_js.'</script>';
	
	$return		.=	'<div class="azoom-post-social">'.$social_html.'</div><div class="clear"></div>';
	
	return $return;
}
endif;



/*
**	Load the Core System. Do NOT make any changes in the core file.
**	Do not edit the details below.
**	
*/
include_once(get_template_directory().'/functions-core.php');




?>