<?php

/*
**	Main Functions Core file of Azoom Theme
**
**	######	updated 	###########
**
**	This new version will be ready for ThemeForest new submission rules.
**
**	@version:2.6
**
*/


//Define the required global file ways.
if(!defined('F_WAY')):
	define('F_WAY', get_template_directory_uri());
endif;

if(!defined('ROCKTHEMES_THEME')):
	define('ROCKTHEMES_THEME',true);
endif;


/**
 * Sets up the content width value based on the theme's design.
 * @see azoom_content_width() for template-specific adjustments.
 */
if ( ! isset( $content_width ) )
	$content_width = 1440;
	

/*
**	Global Variables about the theme. Will be used in configs and js.
**
*/	
$rockthemes_globals = array('theme_name_formatted' => 'Azoom');


if(!function_exists('azoom_after_setup')):
//Activate Theme Theme Domain
function azoom_after_setup() {
 
    // Retrieve the directory for the localization files
    $lang_dir = get_template_directory() . '/languages';
     
    // Set the theme's text domain using the unique identifier from above
    load_theme_textdomain('azoom', $lang_dir);
	
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( 'css/editor-style.css' );

	// Adds RSS feed links to <head> for posts and comments.
	add_theme_support( 'automatic-feed-links' );
	
	/*
     * Let WordPress manage the document title.
     * By adding theme support, we declare that this theme does not use a
     * hard-coded <title> tag in the document head, and expect WordPress to
     * provide it for us.
     */
    add_theme_support( 'title-tag' );

    /*
     * Let WordPress the manage Gutenberg Styles
     *
     * New Theme submission rules.
     */
    add_theme_support( 'wp-block-styles' );

	/*
	 * This theme supports all available post formats by default.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'audio', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video'
	) );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menu( 'primary', esc_html__( 'Navigation Menu', 'azoom' ) );

	/*
	 * This theme uses a custom image size for featured images, displayed on
	 * "standard" posts and pages.
	 */
	add_theme_support( 'post-thumbnails' );
	//set_post_thumbnail_size( 604, 270, true );

	// This theme uses its own gallery styles.
	add_filter( 'use_default_gallery_style', '__return_false' );
 
} // end custom_theme_setup
endif;
add_action('after_setup_theme', 'azoom_after_setup');


/*
**	Global functions included earlier to use special global variables and functions
**	in all theme files
*/
include_once(get_template_directory().'/libs/global-functions.php');


/*
**	Global functions included earlier to use special global variables and functions
**	in all theme files
*/
include_once(get_template_directory().'/libs/new-rules.php');




if(!function_exists('azoom_enqueue_frontend_files')):
/*
**	Enqueue all frontend files. All default styles and javascript files enqueued here. 
**
**	Some feature specific files are not enqueued here for better performance
**
*/
function azoom_enqueue_frontend_files(){
	global $rock_page_builder_config;	
		
	//Foundation normalize
	wp_enqueue_style( 'foundation-normalize', F_WAY.'/css/normalize.css', '', '', 'all' );
	
	//Wordpress Default Style (Specially for tinyMCE Content)
	wp_enqueue_style( 'wp-core', F_WAY.'/css/wp-core.css', '', '', 'all' );
	
	//Responsive Foundation Layout
	wp_enqueue_style( 'foundation', F_WAY.'/css/foundation.css', '', '', 'all' );
	
	//Foundation extra features like hd blocks
	wp_enqueue_style( 'foundation-extra', F_WAY.'/css/foundation-extra.css', '', '', 'all' );
	
	//Animate CSS
	wp_enqueue_style( 'animate-css', F_WAY.'/css/animate.css', '', '', 'all' );
	
	//Lightbox Effect
	wp_enqueue_style('prettyPhoto', F_WAY.'/css/prettyPhoto.css');
	
	//Buttons
	wp_enqueue_style('azoom-buttons',  F_WAY.'/css/buttons.css', '','', 'all');
	
	//Load swiper as default. It's file size is very low.
	wp_enqueue_style('swiper-css', F_WAY.'/css/idangerous.swiper-2.css', '', '', 'all' );
	

	//Load Menu
	wp_enqueue_style('rockthemes-mega-menu', get_template_directory_uri().'/menu-ltr.css');
		
	if(is_rtl()){
		wp_enqueue_style('rockthemes-mega-menu-rtl', get_template_directory_uri().'/menu-rtl.css');
	}
	
	rockthemes_enqueue_external_style();
		
	//Loads our main stylesheet.
	wp_enqueue_style( 'azoom-style', get_stylesheet_uri() );
	
	if(rockthemes_browser_ie9()){
		wp_enqueue_style( 'ie9-fix', F_WAY.'/css/ie9.css', '', '', 'all' );
	}
	
	//Dynamic Style
	xr_style_callback();
	
	/*Responsivity*/
	$disable_responsivity = xr_get_option('disable_responsivity',false);
	if($disable_responsivity){
		//Responsivity disabled
		wp_enqueue_style( 'foundation-nonresponsive', F_WAY.'/css/foundation-nonresponsive.css', '', '', 'all' );
	}else{
		//Responsive Design
		wp_enqueue_style( 'azoom-media-queries', F_WAY.'/media-queries.css', '', '', 'all' );
	}
		
	
	$ajax_call = array('ajaxurl' => admin_url('admin-ajax.php'), 
					   'colors'		=> array(
					   		'main_color'	=>	xr_get_option('site_general_color','#56CCC8'),
					   ),
					   'ajax_nonce' => wp_create_nonce("rockthemes_security_nonce"), 
					   'f_way' => F_WAY,
					   'nonces'		=> array(
					   		'portfolio'		=>	wp_create_nonce('rockthemes_portfolio_nonce'),
							'asearch'		=>	wp_create_nonce('rockthemes_asearch_nonce'),
							'achievement'	=>	wp_create_nonce('rockthemes_achievement_nonce'),
							'love'			=>	wp_create_nonce('rockthemes_love_nonce'),
					   ),
					   'home_url' => get_home_url(),
					   'gif_loader'	=>	'<img src="'.F_WAY.'/images/ajax-loader.gif" class="gif-loader" alt="'.esc_html__('Loading','azoom').'" />',
					   'frontend_options' => array(
					   		'activate_smooth_scroll' 		=>	xr_get_option('activate_smooth_scroll', false) ? 'true' : 'false',
							'nicescroll_style_enabled'		=>	xr_get_option('nicescroll_style_enabled', false) ? 'yes' : 'false',
							'is_admin_bar_showing'			=>	is_admin_bar_showing(),
							'display_inline_nav'			=>	rad_get_option('display_inline_nav'),
							'header_location'				=>	xr_get_option('header_location', 'top_navigation'),
					   ),
					   'hover_details'	=>	array(
					   		'hover_width_min_large'			=>	xr_get_option('hover_width_min_large',250),
							'hover_height_min_large'		=>	xr_get_option('hover_height_min_large', 225),
					   		'hover_width_min_medium'		=>	xr_get_option('hover_width_min_medium',160),
							'hover_height_min_medium'		=>	xr_get_option('hover_height_min_medium', 100),
					   ),
					   'fonts'	=> array(
							'use_icomoon'						=>	(defined('RPB_USE_ICOMOON') ? 'true' : 'false'),
							'icomoon_url'						=>	F_WAY.'/icons/css/icomoon.css',
							'menu_font_family'					=>	xr_get_option('menu_font_family',''),
							'activate_font_loading'				=>	(xr_get_option('font_loading_active', true) ? 'true' : 'false'),
					   		'font_families'						=>	rockthemes_get_user_fonts_array(),
					   ),
					   'is_rtl' => (is_rtl() ? 'rtl' : 'ltr'),
					   'mobile_menu' => array(
					   		'main_title'	=>	__('Menu', 'azoom'),
							'back_text'		=>	__('Back', 'azoom'),
					   ),
					   'menu'		=>	array(
					   		'regular_height'	=>	rockthemes_fn_px_em_return_num(xr_get_option('header_regular_line_height',98)),
							'sticky_height'		=>	rockthemes_fn_px_em_return_num(xr_get_option('header_sticky_line_height',50)),
					   		'enable_menu_hash_navigation'	=>	xr_get_option('enable_menu_hash_navigation',false) ? 'true' : 'false',
					   		'main_menu_model'	=>	xr_get_option('main_menu_model', 'regular'),
					   ),
					   'resposivity' =>	xr_get_option('disable_responsivity',false) ? 'false' : 'true',
					   'grid'		=> array(
					   		/*Block Grid Size*/
							'block'	=> array(
								'medium'	=>	$rock_page_builder_config['settings']['medium_block_size'],
								'small'		=>	$rock_page_builder_config['settings']['small_block_size']
							)
					   ),
					   'woocommerce' => array(),
				   );

	if(function_exists('rockthemes_woocommerce_active') && rockthemes_woocommerce_active()){
		$ajax_call['woocommerce'] = array(
			'auto_display_cart_after_refresh' => xr_get_option('auto_display_cart_after_refresh', true)
		);
	}

	
	wp_enqueue_script('modernizr-js', F_WAY.'/js/modernizr.js', '');
	
	wp_enqueue_script('jquery');
	
	if(function_exists('rockthemes_enqueue_icon_fonts')) rockthemes_enqueue_icon_fonts($ajax_call);
		
	//Required for color based elements such as buttons
	wp_enqueue_script('jquery-color');
	
	wp_enqueue_script('jquery-effects-core');
	
	wp_enqueue_script('underscore');	
	
	wp_enqueue_script('images-loaded', F_WAY.'/js/imagesloaded.pkgd.min.js', array('jquery'), '3.1.8', false);
	
	
	wp_enqueue_script('smartresize-js', F_WAY.'/js/jquery.smartresize.js', array('jquery'), '1.0.0', false);
	
	
	wp_enqueue_script('jquery.prettyPhoto', F_WAY.'/js/jquery.prettyPhoto.js', array('jquery'), '3.1.6', false);
	
	if(xr_get_option('activate_smooth_scroll', false)){
		wp_enqueue_script('nice-scroll', F_WAY.'/js/jquery.nicescroll.min.js', array('jquery'), '3.6.0', false);	
	}
		
	wp_enqueue_script('inview-js', F_WAY.'/js/isInViewport.min.js', array('jquery'), '1.0.0', false);
	
	wp_enqueue_script('jquery-appear', F_WAY.'/js/jquery.appear.js', array('jquery'), '1.0.0', false);
	
	wp_enqueue_script('azoom-jquery', F_WAY.'/js/azoom.jquery.js', array('jquery'), '1.0.0', false);
	
	wp_localize_script('azoom-jquery', 'rockthemes', $ajax_call);
	
		
}
endif;
add_action('wp_enqueue_scripts','azoom_enqueue_frontend_files');





if(!function_exists('rockthemes_enqueue_icon_fonts')):
/*
**	Icon List Enqueue System.
**
**	For both backend and frontend, font icons will be enqueued here.
**
**	@attr	:	$ajax_call:Array	-	This array comes from functions-core.php file. Contains javascript
**										based details as array.
**
*/
function rockthemes_enqueue_icon_fonts($ajax_call = false){
	
	/*
	**	This commented field will be used for extra font families.
	*/
	//Font Awesome
	if(function_exists('xr_get_option') && xr_get_option('enable_fontawesome', false)){
		$ajax_call['fonts']['libs'][] = array('name' => 'FontAwesome', 'url' => F_WAY.'/icons/css/font-awesome.css');
	}
	//Pixed Stroke 7 icon set - http://www.pixeden.com/icon-fonts/stroke-7-icon-font-set
	if(function_exists('xr_get_option') && xr_get_option('enable_pestroke7', false)){
		$ajax_call['fonts']['libs'][] = array('name' => 'Pe-icon-7-stroke', 'url' => F_WAY.'/icons/css/pe-icon-7-stroke.css');
	}
	

	//This library does not need jQuery in order to work
	if(function_exists('xr_get_option') && xr_get_option('font_loading_active', true) && $ajax_call !== false && !is_admin()){
		//wp_enqueue_script('webfontloader', '//ajax.googleapis.com/ajax/libs/webfont/1.5.0/webfont.js');
		wp_enqueue_script('webfontloader', F_WAY.'/js/webfont.js');
		wp_enqueue_script('rockthemes-font-loader', F_WAY.'/js/rockthemes_font_load.js', array('webfontloader','jquery'));
		wp_localize_script('rockthemes-font-loader', 'rockthemes', $ajax_call);
	}else{
		//Azoom uses icomoon
		wp_enqueue_style('rock-icomoon-css',  F_WAY.'/icons/css/icomoon.css', '','', 'all');
				
		//External Libraries coming from theme options.
		if(isset($ajax_call['fonts']['libs']) && count($ajax_call['fonts']['libs']) > 0){
			foreach($ajax_call['fonts']['libs'] as $font){
				wp_enqueue_style('rock-'.$font['name'],  $font['url'], '','', 'all');
			}
		}
	}
}
endif;




if(!function_exists('rockthemes_enqueue_icon_fonts_hook')):
/*
**	Enqueue Icon files for admin area.
**
**	$attr	:	$hook:String, the page name for the admin area.
**	$source	:	http://codex.wordpress.org/Plugin_API/Action_Reference/admin_enqueue_scripts
**
**	@since	:	1.0
*/
function rockthemes_enqueue_icon_fonts_hook($hook=''){
	rockthemes_enqueue_icon_fonts();	
}
endif;
add_action('admin_enqueue_scripts','rockthemes_enqueue_icon_fonts_hook');







if(!function_exists('rockthemes_get_user_fonts_array')):
function rockthemes_get_user_fonts_array(){
	$google_font_link = xr_get_option('google_font_standard_code', '');
	
	
	if(strpos($google_font_link, 'href="') > -1){
		if(preg_match('/<link href="(.*?)">/i', $google_font_link, $google_link_match)) {
			$google_font_url = $google_link_match[1];
		}
		$google_font_url = preg_match('/css\?family\=(.*?)"/i', $google_font_url, $match);
	}elseif(strpos($google_font_link, "href='") > -1){
		if(preg_match("/<link href='(.*?)'>/i", $google_font_link, $google_link_match)) {
			$google_font_url = $google_link_match[1];
		}
		$google_font_url = preg_match("/css\?family\=(.*?)'/i", $google_font_url, $match);
	}
	
	if(!isset($match) || !isset($match[1])) return '';
	
	$google_font_array = explode('|', $match[1]);
	
	return str_replace('+', ' ', $google_font_array);
}
endif;




if(!function_exists('rockthemes_enqueue_external_style')):
/*
**	When style files enqueued inside shortcode, they break W3 Validation. We use this function
**	to enqueue all used style files before </head>
**
**	@since	:	1.3
*/
function rockthemes_enqueue_external_style(){
	global $post;
	
	if(!isset($post) || empty($post) || !$post || $post === '') return;
	
	$enqueue_data = get_post_meta($post->ID, '_enqueue_libs', true);
	if(empty($enqueue_data) || !is_array($enqueue_data) || count($enqueue_data) < 1) return;
	
	$enqueue_js = false;//Also enqueue js files
	
	$ssl = is_ssl() ? 'https' : 'http';

	foreach($enqueue_data as $enqueue){

		switch($enqueue){
			case 'textfield':
			$return = 'Text Field';
			break;
	
	
			case 'textarea':
			$return = 'Text Area';
			break;
	
	
			case 'image':
			$return = 'Image';
			break;
			
			
			case 'ajaxfiltered':
			$return = 'Ajax Filtered Gallery';
			break;
			
			
			case 'featuredimage':
			$return = 'Featured Image';
			break;		
			
			case 'swiperslider':
			$return = "Swiper Slider";
			break;
			
			case "pricingtable":
			$return = "Pricing Table";
			break;
			
			case 'curvyslider':
			if(defined('CURVY_URI')){				
				wp_enqueue_style('rockthemes-curvy-slider-style',  CURVY_URI.'css/curvy-slider-style.css', '','', 'all');
				if($enqueue_js){
					wp_enqueue_script('google-webfont-api', CURVY_URI.'frontend/js/webfont.js', array(), '1.0.0');
					wp_enqueue_script('rockthemes-curvy-slider-caat', CURVY_URI.'js/caat.min.js', array('jquery'), '1.0.0', true);
					wp_enqueue_script('rockthemes-curvy-slider-js', CURVY_URI.'frontend/js/curvy-slider-frontend.min.js', array('jquery', 'google-webfont-api'), '2.0.0', true);
				}
			}
			break;
			
			case "sidebar":
			$return = "Sidebar";
			break;
			
			case "toggles":
			$return = "Toggles";
			break;
			
			case "tabs":
			$return = "Tabs";
			break;
			
			case "iconictext":
			$return = "Iconic Text";
			break;
			
			case "button":
			$return = "Button";
			break;
					
			case "skill":
			$return = "Skill";
			break;
			
			case "horizontalrule":
			$return = "HR";
			break;
			
			case "portfolio";
			wp_enqueue_style('swiper-css', F_WAY.'/css/idangerous.swiper-2.css', '', '', 'all' );
			$return = "Portfolio";
			break;
			
			case "rockformbuilder";
			$return = "Rock Form Builder";
			break;
			
			case "googlemap";
			$return = "Google Map";
			break;

			case "leafletmap";
			//Enqueue LeafLet Map Library with API KEY
			wp_enqueue_style( 'leaflet', F_WAY.'/libs/leaflet/leaflet.css', '', '', 'all' );
			wp_enqueue_script('leaflet', F_WAY.'/libs/leaflet/leaflet.js', array('jquery'), '2.7.0', false);
			$return = "LeafLet Map";
			break;

			case "promotionbox";
			$return = "Promotion Box";
			break;
			
			case "alertbox";
			$return = "Alert Box";
			break;
			
			case "referencesbuilder";
			$return = "References Builder";
			break;
			
			case "testimonialsbuilder";
			wp_enqueue_style( 'swiper-css', F_WAY.'/css/idangerous.swiper-2.css', '', '', 'all' );
			if($enqueue_js){
				wp_enqueue_script('jquery');
				wp_enqueue_script('swiper-js', F_WAY.'/js/idangerous.swiper-2.7.js', array('jquery'), '2.7.0', true);
			}
			break;
			
			case "socialicons";
			$return = "Social Icons";
			break;
			
			case "teammembers";
			$return = "Team Members";
			break;
			
			case "beforeafterslider";
			wp_enqueue_style( 'zurb-twenty-twenty-style', F_WAY.'/css/twentytwenty.css', '', '', 'all' );
			if($enqueue_js){
				wp_enqueue_script('jquery-event-move', F_WAY.'/js/jquery.event.move.min.js', array('jquery'), '1.3.1', true);
				wp_enqueue_script('zurb-twenty-twenty', F_WAY.'/js/jquery.twentytwenty.min.js', array('jquery'), '1.0.0', true);
			}
			break;
			
			case "externalshortcode";
			$return = "External Code";
			break;
			
			case "regularblog";
			$return = "Regular Blog";
			break;
			
			case "gallery";
			$return = "Gallery";
			break;
			
			case "achievement";
			if($enqueue_js){
				wp_enqueue_script('countup', F_WAY.'/js/countUp.min.js', array('jquery'), '1.0.0', true);
			}
			break;

		}
	}
}
endif;


/*
**	Load Required files and Softwares. These files contains special options and features.
*/


//Rock Options
include_once(get_template_directory().'/rock-options/options_loader.php');

//Load Rock Wigets
include_once(get_template_directory().'/rock-widgets/load_widgets.php');

//Mega Menu
include_once(get_template_directory().'/rock-widgets/mega-menu/rockthemes-mega-menu.php');



//Shortcodes get_stylesheet_directory() should be used in the child theme
//include_once(get_template_directory().'/shortcodes.php');

//Post meta, Plugins, Widgets (Custom Sidebar)
include_once(get_template_directory().'/post_meta.php');






//ROCK DEMO STYLER
if ((defined( 'ROCK_DEMO' ) && ROCK_DEMO)){
	include_once(get_template_directory().'/rock-style-editor/demo-style-editor.php');
}
//Plugin Activation (Now Mandatory for Themeforest)
if ((defined( 'WP_ADMIN' ) && WP_ADMIN )){
	include_once(get_template_directory().'/libs/plugin-activation.php');
}
//Compatibility with woocommerce plugin
if(function_exists('rockthemes_woocommerce_active') && rockthemes_woocommerce_active()){
	include_once(get_template_directory().'/woocommerce-settings.php');
}
//Compatibility with bbpress plugin
if(function_exists('rockthemes_bbpress_active') && rockthemes_bbpress_active()){
	include_once(get_template_directory().'/bbpress-settings.php');
}




if(!function_exists('azoom_tinymce_add_page_button')):
/*
**	Add pagination button to TinyMCE. 
**
**	This function filters TinyMCE plugins and adds pagination button to TinyMCE.
**	Pagination button in TinyMCE allows you to add pagination in any page and split
**	your content into multiple pages for your pages and blog posts
**	
*/
function azoom_tinymce_add_page_button($mce_buttons) { 
	$pos = array_search('wp_more',$mce_buttons,true); 
	if ($pos !== false) { 
		$tmp_buttons = array_slice($mce_buttons, 0, $pos+1); 
		$tmp_buttons[] = 'wp_page'; 
		$mce_buttons = array_merge($tmp_buttons, array_slice($mce_buttons, $pos+1)); 
	} 
	return $mce_buttons;
}
endif;
add_filter('mce_buttons','azoom_tinymce_add_page_button'); 



// Customize mce editor font sizes
if ( ! function_exists( 'rockthemes_tinymce_text_sizes_fonts' ) ) {
	function rockthemes_tinymce_text_sizes_fonts( $initArray ){
		$initArray['fontsize_formats'] = "9px 10px 12px 13px 14px 16px 18px 21px 24px 28px 32px 36px 48px 64px 72px 86px";
		
		//Get the fonts from Rock Theme Options
		$fonts = xr_get_option('site_all_font_families', '');
				
		$fonts_str = '';
		if($fonts !== '' ){
			$fonts_array = explode('font-family:', $fonts);

			foreach($fonts_array as $f){
				if($f === '') continue;
				preg_match('/\".*\"/i', $f, $match);
				if($match && isset($match[0])){
					$fonts_str .= trim($match[0]).'='.trim(strtolower($f));	
				}else{
					preg_match("/\'.*\'/i", $f, $match);
					if($match && isset($match[0])){
						$fonts_str .= trim($match[0]).'='.trim(strtolower($f));	
					}
				}
			}
						
			if($fonts_str !== ''){
				$fonts_str = str_replace('"', '', $fonts_str);
				$fonts_str = str_replace("'", "", $fonts_str);
				$fonts_str = str_replace('= ', '=', $fonts_str);
				$initArray['font_formats'] = $fonts_str.'Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats';
			}
		}
		
		return $initArray;
	}
}
add_filter( 'tiny_mce_before_init', 'rockthemes_tinymce_text_sizes_fonts' );







// Enable font size & font family selects in the editor
if ( ! function_exists( 'rockthemes_tinymce_font_select' ) ) {
	function rockthemes_tinymce_font_select( $buttons ) {
		array_unshift( $buttons, 'fontselect' ); // Add Font Select
		array_unshift( $buttons, 'fontsizeselect' ); // Add Font Size Select
		return $buttons;
	}
}
add_filter( 'mce_buttons_2', 'rockthemes_tinymce_font_select' );








if(!function_exists('azoom_rfb_button_class_filter')):
/*
**	Rock Form Builder Button Style Filter
**
**	@since	:	1.0
*/
function azoom_rfb_button_class_filter($class){
	return 'button button-rounded button-border-bottom';	
}
add_filter('rock_form_builder_button_class', 'azoom_rfb_button_class_filter');
endif;

/*
**	Rock Form Builder Datepicker icons
**
**	@since	:	1.0
*/
if(!function_exists('azoom_rfb_date_icon_close')):
function azoom_rfb_date_icon_close(){
	return 'icomoon icomoon-icon-close';
}
add_filter('rock_form_builder_date_icon_close', 'azoom_rfb_date_icon_close');
endif;

if(!function_exists('azoom_rfb_date_icon_back')):
function azoom_rfb_date_icon_back(){
	return 'icomoon icomoon-icon-arrow-left6';
}
add_filter('rock_form_builder_date_icon_back', 'azoom_rfb_date_icon_back');
endif;

if(!function_exists('azoom_rfb_date_icon_next')):
function azoom_rfb_date_icon_next(){
	return 'icomoon icomoon-icon-uniE7CF';
}
add_filter('rock_form_builder_date_icon_next', 'azoom_rfb_date_icon_next');
endif;
/*
**	Rock Form Builder General Settings Icons Default Values
**
**	@since	:	1.0
*/
if(!function_exists('azoom_rfb_icon_check')):
function azoom_rfb_icon_check(){
	return 'icomoon icomoon-icon-checkmark';	
}
add_filter('rock_form_builder_icon_check', 'azoom_rfb_icon_check');
endif;
if(!function_exists('azoom_rfb_icon_error')):
function azoom_rfb_icon_error(){
	return 'icomoon icomoon-icon-close';
}
add_filter('rock_form_builder_icon_error', 'azoom_rfb_icon_error');
endif;
if(!function_exists('azoom_rfb_icon_sending')):
function azoom_rfb_icon_sending(){
	return 'icomoon icomoon-icon-spinner3 fullSpin';
}
add_filter('rock_form_builder_icon_sending', 'azoom_rfb_icon_sending');
endif;









if(!function_exists('azoom_under_construction')):
/*
**	Under Construction Page 
**
**	Redirects not logged in users to a specific page. Page supports Rock Page Builder
**
**	@since	:	1.0
*/
function azoom_under_construction()
{
    if(!is_user_logged_in() ){
		$id = intval(xr_get_option('template_redirect_page', false));
		if($id && !is_page($id)){
			wp_redirect( get_permalink($id) );
			exit();
		}
    }
}
endif;

if(xr_get_option('enable_template_redirect')){
	add_action( 'template_redirect', 'azoom_under_construction' );
}







if(!function_exists('rockthemes_add_excerpt_pages')):
/*
**	Add Excerpt Support for the "page" post type
**
**	@since	:	1.0
**
*/
function rockthemes_add_excerpt_pages() {
	add_post_type_support( 'page', 'excerpt' );
}
endif;
add_action('init', 'rockthemes_add_excerpt_pages');

if(!function_exists('azoom_frontend_init')):
/*
** 	Add Required Filters
*/
function azoom_frontend_init(){
	add_post_type_support( 'post', 'excerpt');
}
endif;
add_action('init', 'azoom_frontend_init');







if(!function_exists('azoom_add_search_to_menu')):
/*
**	Adds search to menu. This function will be called from "header-models.php" file
**
**	@params	:	Filter Params
*/
function azoom_add_search_to_menu($items, $args) {
	if( $args->theme_location !== 'primary' ) return $items;
		
	$search_icon = '<a href="#" class="special-search-icon"><span><i class="icomoon icomoon-icon-search"></i></span></a>';

	$homeMenuItem =
			'<li class="menu-item dismiss-mobile azoom-ajax-search-menu-item">' .
			$args->before .
			$search_icon.
			$args->after .
			'</li>';

	$items = $items.$homeMenuItem;

	return $items;
}
endif;
if(!function_exists('azoom_add_main_nav_mobile_add_search')):
function azoom_add_main_nav_mobile_add_search(){
	$search_icon = '<span class="special-search-icon"><i class="icomoon icomoon-icon-search"></i></span>';
	return '<div class="dismiss-mobile azoom-ajax-search-menu-item azoom-transition">'.$search_icon.'</div>';
}
endif;



if(!function_exists('rockthemes_ajax_search')):
/*
**	Ajax Search System
**
**	Generates ajax search function and extends the search with Rock Page Builder support
**	and some more post types ;
**
**	post, page, product, defaultitem
**
**	@since	:	1.0
**
*/
function rockthemes_ajax_search(){
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rockthemes_asearch_nonce') ||
		!check_ajax_referer('rockthemes_asearch_nonce')) {
	
		//Die
		die('ERROR');		
	}

	
	global $wpdb;

	$keyword = function_exists('sanitize_text_field') ? sanitize_text_field($_POST['search_term']) : $_POST['search_term'];
	$args = array(
		's'	=>	$keyword,
		'orderby' => null,
		'post_status' => 'publish',
		'posts_per_page'	=> 5,
		'suppress_filters'	=> 0,//WPML Compatibility
  	);
		
	$search_q = new WP_Query($args);
	$posts = $search_q->get_posts();

	if ( $posts ){
		render_search_results( $posts );
	}else{
		echo '<p class="search-no-result">'.esc_html__('Nothing Found...','azoom').'</p>';
	}
	exit;
}
endif;
add_action( 'wp_ajax_rockthemes_ajax_search', 'rockthemes_ajax_search');
add_action( 'wp_ajax_nopriv_rockthemes_ajax_search', 'rockthemes_ajax_search');






if(!function_exists('render_search_results')):
function render_search_results( $posts ){
	global $post;
	
	$search_model = xr_get_option('search_model', 'search_centered');
	$block_class = $search_model === 'search_centered' ? '' : 'large-block-grid-3 medium-block-grid-2 small-block-grid-1';
	echo '<ul class="active-search-results '.$block_class.'">';


	$excerpt_length = intval(xr_get_option('menu_search_excerpt_length', 10));

	foreach ( $posts as $single_post ){
		$post = $single_post;
		setup_postdata($post);
		echo '
		<li class="active-search-result">
		<a href="'.get_permalink( $post->ID ).'">
			<div class="search-single-result azoom-transition-fast">
				<div class="search-image">
					'.azoom_get_featured_image(false, 'main_small', false, array('line_height' => '60px', 'font_size' => '30px', 'width' => '60px', 'max_width'=>'60px'), false).'
				</div>
				<div class="search-content">
					<strong>'.esc_html( $post->post_title ).'</strong>
					<p>'.esc_html(azoom_get_the_excerpt('',false,$excerpt_length)).'</p>
				</div>
				<div class="link-icon azoom-transition-fast">
					'.((is_rtl() ? '<i class="icomoon icomoon-icon-previous11"></i>' : '<i class="icomoon icomoon-icon-next15"></i>')).'
				</div>
			</div>
		</a>
		</li>
		';
	}
	echo '</ul>';
}
endif;







if(!function_exists('azoom_search_widget_filter')):
/*
**	Alter Wordpress's Default Search Widget
**
**	@since	:	1.0
*/
function azoom_search_widget_filter($text) {
	$text = str_replace('value="Search"', 'value=""', $text);
	$text = str_replace('<input type="submit"', '<button type="submit"', $text);
	
	$search = '/>';
	$replace = '></button>';
	if( ( $pos = strrpos( $text , $search ) ) !== false ) {
		$search_length  = strlen( $search );
		$text    = substr_replace( $text , $replace , $pos , $search_length );
	}
	 
	$text = str_replace('<input type="text"', '<input type="text" placeholder="'.esc_html__('Search for:','azoom').'"', $text);
	return $text;
}
endif;
add_filter('get_search_form', 'azoom_search_widget_filter');









if(!function_exists('rockthemes_op_make_down_arrow')):
/*
**	Down Arrow Button to slide to the next special grid
**
**	@since	:	1.3
**
*/
function rockthemes_op_make_down_arrow($color = '#f9f9f9'){
	$down_arrow_icon = '';
		
	//Reason of double icomoon (in both if and else) is to supporting both libraries
	if(defined('RPB_USE_ICOMOON')){
		$down_arrow_icon = '
		<i class="azoom-down-arrow-icon icomoon icomoon-icon-azoom-arrow-down azoom-small-text-shadow"></i>';
	}
	
	
	/*removed enable-animate*/
	$return = '
		<div class="azoom-down-arrow-container" style="color:'.esc_attr($color).'">
			'.$down_arrow_icon.'
		</div>
	';	
	
	return $return;
}
endif;









if(!function_exists('azoom_before_page_content')):
/*
**	Rock Before Page hook is called right after "get_header()" function in pages
**	
**	This function adds specific details and options according to the page
**
*/
function azoom_before_page_content(){
	global $post, $azoom_disable_regular_title, $rockthemes_advanced_post_details;
	
	$rockthemes_advanced_post_details = rockthemes_ad_get_post_details_metabox();
	
	//Deactivate regular title entirely
	$azoom_disable_regular_title = true;
	
	if((isset($rockthemes_advanced_post_details['activate_space_under_menu']))){
		if($rockthemes_advanced_post_details['activate_space_under_menu'] === 'true'){
			//Add extra vertical spacing
			echo '<div class="vertical-space"></div>';
		}
	}elseif(xr_get_option('disable_space_under_header', false) !== true){
		//Add extra vertical spacing
		echo '<div class="vertical-space"></div>';
	}
	
	if(defined('RPB_FULL_SHORTCODE')) return;
	
	echo '<div class="row">';
}

endif;
add_action('rockthemes_pb_frontend_before_page','azoom_before_page_content', 1);





if(!function_exists('azoom_after_page_content')):
/*
**	Rock After Page hook is called right before "get_footer()" function in pages
**	
**	This function adds specific details and options according to the page
**
*/
function azoom_after_page_content(){
	global $rockthemes_advanced_post_details;
	
	//Clear any uncleared float
	echo '<div class="clear"></div>';

	if((isset($rockthemes_advanced_post_details['activate_space_under_menu']))){
		if($rockthemes_advanced_post_details['activate_space_under_menu'] === 'true'){
			//Add extra vertical spacing
			echo '<div class="vertical-space"></div>';
		}
	}elseif(xr_get_option('disable_space_under_header', false) !== true){
		//Add extra vertical spacing
		echo '<div class="vertical-space"></div>';
	}
	
	if(defined('RPB_FULL_SHORTCODE')) return;
	
	//Add an empty div for footer to close. This way both Azoom and 3rd party pages will stay in layout.
	echo '<div>';
}

endif;
if(!defined('RPB_FULL_SHORTCODE')){
	add_action('rockthemes_pb_frontend_after_page','azoom_after_page_content', 1);
}else{
	add_action('rockthemes_pb_frontend_after_page','azoom_after_page_content', 15);
}






if(!function_exists('azoom_after_header_title_hook')):
/*
**	This function or hook can be used to add extra content after header title and breadcrumbs.
**	This function is called from "title-default.php"
**
*/
function azoom_after_header_title_hook(){
	//Do Nothing
}
endif;
add_action('azoom_after_header_title','azoom_after_header_title_hook');


if(!function_exists('azoom_before_footer_hook')):
/*
**	This function or hook can be used to add extra content before footer.
**	This function is called from "footer.php"
**
*/
function azoom_before_footer_hook(){
	//Do Nothing
}
endif;
add_action('azoom_before_footer','azoom_before_footer_hook');







/*
**	Set Image sizes as default. Dimension 4/3
**
**	We have removed the branding from images. Now all images are named as "main_"
*/
//Small Image Size - Mostly for ajax search
$rockthemes_small_image_width = sanitize_text_field(xr_get_option('rockthemes_small_image_width','100px'));
$rockthemes_small_image_height = sanitize_text_field(xr_get_option('rockthemes_small_image_height','100px'));
add_image_size('main_small',$rockthemes_small_image_width,$rockthemes_small_image_height,true);
//General Image Thumbnail
$rockthemes_thumbnail_image_width = sanitize_text_field(xr_get_option('rockthemes_thumbnail_image_width','200px'));
$rockthemes_thumbnail_image_height = sanitize_text_field(xr_get_option('rockthemes_thumbnail_image_height','150px'));
add_image_size('main_thumbnail',$rockthemes_thumbnail_image_width,$rockthemes_thumbnail_image_height,true);
//General Image Medium
$rockthemes_medium_image_width = sanitize_text_field(xr_get_option('rockthemes_medium_image_width','400px'));
$rockthemes_medium_image_height = sanitize_text_field(xr_get_option('rockthemes_medium_image_height','200px'));
add_image_size('main_medium',$rockthemes_medium_image_width,$rockthemes_medium_image_height,true);
//General Image Large
$rockthemes_large_image_width = sanitize_text_field(xr_get_option('rockthemes_large_image_width','960px'));
$rockthemes_large_image_height = sanitize_text_field(xr_get_option('rockthemes_large_image_height','720px'));
add_image_size('main_large',$rockthemes_large_image_width,$rockthemes_large_image_height,true);
//General Featured Image (Mostly for blog posts)
$rockthemes_featured_image_width = sanitize_text_field(xr_get_option('rockthemes_featured_image_width','1140px'));
$rockthemes_featured_image_height = sanitize_text_field(xr_get_option('rockthemes_featured_image_height','400px'));
add_image_size('main_featured',$rockthemes_featured_image_width,$rockthemes_featured_image_height,true);
//Grid Backgrounds default size
$grid_background_image_width = sanitize_text_field(xr_get_option('grid_background_image_width','1440px'));
$grid_background_image_height = sanitize_text_field(xr_get_option('grid_background_image_height','1080px'));
add_image_size('main_big',$grid_background_image_width,$grid_background_image_height,false);




if(xr_get_option('masonry_enable_image_size', true)):
/*
**	Enable Masonry Image Sizes.
**
*/
	//Masonry Default Size
	$masonry_image_size_regular_width = sanitize_text_field(xr_get_option('masonry_image_size_regular_width','480px'));
	$masonry_image_size_regular_height = sanitize_text_field(xr_get_option('masonry_image_size_regular_height','360px'));
	add_image_size('masonry_regular',$masonry_image_size_regular_width,$masonry_image_size_regular_height,true);
	
	//Masonry Wide Size
	$masonry_image_size_wide_width = sanitize_text_field(xr_get_option('masonry_image_size_wide_width','960px'));
	$masonry_image_size_wide_height = sanitize_text_field(xr_get_option('masonry_image_size_wide_height','360px'));
	add_image_size('masonry_wide',$masonry_image_size_wide_width,$masonry_image_size_wide_height,true);
	
	//Masonry Tall Size
	$masonry_image_size_tall_width = sanitize_text_field(xr_get_option('masonry_image_size_tall_width','960px'));
	$masonry_image_size_tall_height = sanitize_text_field(xr_get_option('masonry_image_size_tall_height','360px'));
	add_image_size('masonry_tall',$masonry_image_size_tall_width,$masonry_image_size_tall_height,true);
	
	//Masonry Wide & Tall Size
	$masonry_image_size_wide_tall_width = sanitize_text_field(xr_get_option('masonry_image_size_widetall_width','960px'));
	$masonry_image_size_wide_tall_height = sanitize_text_field(xr_get_option('masonry_image_size_widetall_height','720px'));
	add_image_size('masonry_wide_tall',$masonry_image_size_wide_tall_width,$masonry_image_size_wide_tall_height,true);
endif;







if(!function_exists('rockthemes_get_custom_image_size')):
/*
**	Get custom image size.
**
**	@since	:	1.3
*/
function rockthemes_get_custom_image_size($selected = ''){
	global $_wp_additional_image_sizes;
	
	$sizes = array();
	foreach( get_intermediate_image_sizes() as $s ){
 		$sizes[ $s ] = array( 0, 0 );
 		if( in_array( $s, array( 'thumbnail', 'medium', 'large' ) ) ){
 			$sizes[ $s ][0] = get_option( $s . '_size_w' );
 			$sizes[ $s ][1] = get_option( $s . '_size_h' );
 		}else{
 			if( isset( $_wp_additional_image_sizes ) && isset( $_wp_additional_image_sizes[ $s ] ) )
 				$sizes[ $s ] = array( $_wp_additional_image_sizes[ $s ]['width'], $_wp_additional_image_sizes[ $s ]['height'], );
 		}
 	}
	
	if(empty($sizes)) return false;
	
	foreach($sizes as $size => $atts){
		//Remove the unlrelated image sizes.
		if($size == '' ){
			//Do Nothing	
		}else{
			//If post type is allowed in our list and not unrelated add them to select item
			if($selected == $size){
				return $atts;
			}
		}
	}
	
	return false;
	
}
endif;









if(!function_exists('azoom_alter_default_comment_form')):
/*
**	Alter the Wordpress Comment Form values and variables
**
*/
function azoom_alter_default_comment_form($defaults){
	$fields = array('author' => '<div class="row"><div class="large-4 columns"><input name="author" id="author" class="comments-field inputs-class" placeholder="'.esc_html__('Name :','azoom').'" type="text"></div>',
					'email' => '<div class="large-4 columns"><input name="email" id="email" class="comments-field inputs-class" style="margin-right:0px;" placeholder="'.esc_html__('Email :','azoom').'" type="text"></div>',
					'url' => '<div class="large-4 columns"><input name="url" id="url" class="comments-field inputs-class" placeholder="'.esc_html__('Website :','azoom').'" type="text"></div></div>');
	
	$defaults['fields'] = apply_filters( 'comment_form_default_fields', $fields );
	$defaults['title_reply'] = esc_html__('Leave a Comment','azoom');
    $defaults['comment_notes_before'] = '';
    $defaults['comment_notes_after'] = '';
	$defaults['comment_field'] = '<textarea class="comments-field inputs-class" placeholder="'.esc_html__('Your Message :','azoom').'" name="comment" id="comment"></textarea>';
	$defaults['id_submit'] = 'comments-submit';

    return $defaults;
	//apply_filters( 'comment_form_defaults', $defaults );
}
endif;
add_filter('comment_form_defaults','azoom_alter_default_comment_form');






/*
**	Wrap content form with "row" divs.
**
**
*/
if(!function_exists('azoom_alter_comment_form_before')):
function azoom_alter_comment_form_before(){
	echo '<div class="row"><div class="large-12 medium-12 columns">';
}
endif;
add_action('comment_form_before','azoom_alter_comment_form_before');

if(!function_exists('azoom_alter_comment_form_after')):
function azoom_alter_comment_form_after(){
	echo '</div></div>';	
}
endif;
add_action('comment_form_after','azoom_alter_comment_form_after');







/*
**	You can always change the background in "Appearance > Background". This hook will activate
**	custom-background and add a default value
**
**
*/
$azoom_custom_background_args = array(
	'default-color' => 'f3f3f3',
	'default-image' => '',
);
add_theme_support( 'custom-background', $azoom_custom_background_args );





/*
**	Core Functions. 
**	###############
**	
**	These functions should not be overriden. If you override any of these functions it may cause errors and conflicts
*/

if(!function_exists('rockthemes_get_image_id_from_url')):
/*
**	Some of our special elements allow you to choose different image size. This function will
**	retrive the "image id" according to the image url
**
**	@param	:	$image_url:String	URL of the image to get id from
**	@return	:	$attachment[0]:String	ID of the image
*/
function rockthemes_get_image_id_from_url($image_url='') {
	
	global $wpdb;
	$prefix = $wpdb->prefix;
	
	if(!is_string($image_url)) return;
		
	$image_url = $wpdb->esc_like(esc_url($image_url));
	$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM " . $prefix . "posts" . " WHERE guid LIKE '%s';", $image_url )); 

	if(!empty($attachment) && $attachment[0]){
        return $attachment[0]; 
	}else{
		$new_image_url = '';
		
		if(strpos($image_url, 'https') > -1){
			$new_image_url = str_replace('https', 'http', $image_url);
		}elseif(strpos($image_url, 'http') > -1){
			$new_image_url = str_replace('http', 'https', $image_url);
		}

		$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM " . $prefix . "posts" . " WHERE guid='%s';", $new_image_url)); 

		if(!empty($attachment) && $attachment[0]){
        	return $attachment[0]; 
		}	

	}
	return '';
}
endif;




if(!function_exists('rock_check_p')):
/*
**	To use TinyMCE in full power, we check if the string wrapped with "<p>" tags correctly
**
**	@param	:	$string:String	String to check if wrapped correctly
**	@return	:	$string:String	String wrapped with "<p>" tags
*/
function rock_check_p($string){
	return wpautop($string);
	
	if(substr($string,0,2) != '<p') return '<p>'.$string.'</p>';
	return $string;
}
endif;


/*
**	End of Core Functions
**	##################################
*/





/*
**	Wordpress's Required Functions
*/

if(!function_exists('azoom_content_width')):
/*
 * Adjusts content_width value for video post formats and attachment templates.
 *
 * @since Azoom 1.0
 *
 * @return void
 */
function azoom_content_width() {
	global $content_width;

	if ( is_attachment() )
		$content_width = 724;
	elseif ( has_post_format( 'audio' ) )
		$content_width = 484;
}
endif;
add_action( 'template_redirect', 'azoom_content_width' );



if(!function_exists('azoom_favico')):
/*
**	Add Favico to header
**	@since	:	Azoom 1.0
*/
function azoom_favico() {
    echo '<link rel="shortcut icon" type="image/x-icon" href="'.esc_url(xr_get_option('company_logo_favicon', F_WAY.'/images/demo/favico.ico')).'" />';
}
endif;
add_action( 'wp_head', 'azoom_favico' );







/*
**	#######	Overridable Functions	#########
**	
**	Functions down below are overridable. This functions can be override by a child theme.
**	You can use our child theme to change any of these functions. You can also change these functions as well.
**	But we strongly recommend using a childtheme for file based changes to prevent any updating problem in further.
*/


/*
**	Alter title with site name and current page/post details. Improves the SEO
**
*/
if(!function_exists('azoom_wp_title_prefix')){
	function azoom_wp_title_prefix() {
		$title = '';
	 
		// Single post
		if ( is_single() ) {
			$title .= single_post_title( '', false );
			$title .= ' | ';
			$title .= get_bloginfo( 'name' );
		}
	 
		// Home page
		elseif ( is_home() ) {
			$title .= get_bloginfo( 'name' );
			$title .= ' | ';
			$title .= get_bloginfo( 'description' );
			if ( get_query_var( 'paged' ) )
				$title .= ' | ' . esc_html__( 'Page', 'azoom' ) . ' ' . get_query_var( 'paged' );
		}
	 
		// Static page
		elseif ( is_page() ) {
			$title .= single_post_title( '', false );
			$title .= ' | ';
			$title .= get_bloginfo( 'name' );
		}
		
		// Category page
		elseif ( is_category() ) {
			$title .= single_cat_title( '', false );
			$title .= ' | ';
			$title .= get_bloginfo( 'name' );
		}
	 
		// Search page
		elseif ( is_search() ) {
			$title .= get_bloginfo( 'name' );
			$title .= ' | '. esc_html__( 'Search Results for: ', 'azoom' ) .get_search_query() ; 
			if ( get_query_var( 'paged' ) )
				$title .= ' | ' . esc_html__( 'Page', 'azoom' ) . ' ' . get_query_var( 'paged' );
		}
	 
		// 404 not found error
		elseif ( is_404() ) {
			$title .= get_bloginfo( 'name' );
			$title .= ' | ' . esc_html__( 'Not Found', 'azoom' );
		}
	 
		// Anything else
		else {
			$title .= get_bloginfo( 'name' );
			if ( get_query_var( 'paged' ) )
				$title .= ' | ' . esc_html__( 'Page', 'azoom' ) . ' ' . get_query_var( 'paged' );
		}
	 
		return $title;
	}
}


















if(!function_exists('azoom_get_post_type_icon_class')):
/*
**	Generates the icon for different post type. This function
**	will only work for 'post' post format
**	
**	@param	:	$post_format String, 
**	@return	:	HTML class of the icon
**	@since	:	1.0
**
*/
function azoom_get_post_type_icon_class($post_format = ''){

	global $post;

	if(!$post) return false;
	
	$post_format = get_post_format();
	
	$return = 'icomoon ';
	
	//Check if the post format is default
	if(!$post_format){
		//Post format is default. Default post format returns false from get_post_format() function
		$return .= 'icomoon-icon-pencil2';
	}else{
		switch($post_format){
			case 'gallery':
			$return .= 'icomoon-icon-images';
			break;	
			
			case 'image':
			$return .= 'icomoon-icon-image';
			break;
			
			case 'audio':
			$return .= 'icomoon-icon-headphones';
			break;
			
			case 'video':
			$return .= 'icomoon-icon-film';
			break;
			
			case 'aside':
			$return .= 'icomoon-icon-file4';
			break;
			
			case 'status':
			$return .= 'icomoon-icon-bubble';
			break;
			
			case 'link':
			$return .= 'icomoon-icon-link';
			break;
			
			case 'quote':
			$return .= 'icomoon-icon-quotes-left';
			break;
			
			case 'chat':
			$return .= 'icomoon-icon-bubbles4';
			break;
		}
	}
	
	
	return $return;
}
endif;





if(!function_exists('azoom_featured_empty_icons')):
/*
**	List of featured icons for different post types and pages
**
**	@param	:	$post_type String,
**	@param	:	$line_height String
**	@return	:	HTML element with an icon for the post type
**	@since	:	1.0
*/

function azoom_featured_empty_icons($post_type='', $placeholder = array(), $use_box = false){
	global $post;
	if(empty($post_type)) {
		$post_type = get_post_type();
	}else{
		$post_type = sanitize_text_field($post_type);	
	}
	
	//Default args
	$placeholder_main = array('line_height' => '60px', 'font_size' => '40px', 'width' => '80px', 'max_width'=>'80px');
	
	$placeholder = array_merge($placeholder_main, $placeholder);
	
	if(!empty($placeholder)) extract($placeholder);
	
	if(!isset($height)){
		$height = $line_height;	
	}

	$lib = 'icomoon'; //fa fa- font awesome;
	
	$return = '<span style="font-size:'.esc_attr($font_size).'; line-height:'.esc_attr($line_height).'; text-align:center; width:'.esc_attr($width).'; max-width:'.esc_attr($max_width).'; height:100%; max-height:'.esc_attr($height).'; background:'.esc_attr(xr_get_option('site_general_color','#56CCC8')).'; color:#fff; position:relative; display:block;">';

	
	if($use_box){
		$return = '<div class="rectangle-box" style="font-size:'.esc_attr($font_size).'; line-height:'.esc_attr($line_height).'; max-width:'.esc_attr($width).'; background:'.esc_attr(xr_get_option('site_general_color','#56CCC8')).';"><div class="rectangle-content"><div><span>';	
	}
	
	switch($post_type){
		case 'page':
		$return .= '<i class="'.$lib.' icomoon-icon-file4"></i>';
		break;
		
		case 'post':
		$return .= '<i class="'.esc_attr(azoom_get_post_type_icon_class($post_type)).'"></i>';
		break;
		
		case 'product':
		if(function_exists('rockthemes_woocommerce_active') && rockthemes_woocommerce_active()){
			//WooCommerce Product
			$return = '<span>';
			
			if ( version_compare( WOOCOMMERCE_VERSION, "2.3" ) >= 0 ) {
				$return .= wc_placeholder_img();
			}else{
				$return .= woocommerce_placeholder_img();
			}
		}
		//$use_box = false;
		break;
		
		case 'defaultitems':
		$return .= '<i class="'.$lib.' icomoon-icon-briefcase"></i>';
		break;
		
		default:
		$return .= '<i class="'.esc_attr(azoom_get_post_type_icon_class($post_type)).'"></i>';
		break;
	}
	
	if($use_box){
		$return .= '</span></div></div></div>';
	}else{
		$return .= '</span>';
	}
	
	return $return;
}

endif;










if( ! function_exists('azoom_get_featured_image')):
/*
**	Gets the current posts featured image or video or images in Swiper Slider
**
**	@param	:	$echo Boolean, 
**	@param	:	$featured_image_size String, Optional image size - Default : main_featured
**	@param	:	$hover_active Boolean, deactivate hover
**	@param	:	$placeholder_details	Array, array(line_height,font_size)
**	@return	:	Returns HTML of the values in order : Video, Swiper Slider, Image
**
*/
function azoom_get_featured_image($echo=true, $featured_image_size = 'main_featured', $hover_active = true, $placeholder = array('line_height' => '60px', 'font_size' => '40px', 'width' => '80px'), $enable_swiper = true){
	global $post, $rockthemes_globals;
	
	$display_video_directly = true;
		
	$rockthemes_advanced_details = get_post_meta($post->ID, 'advanced_post_details',true);	
	
	
	$post_format = get_post_format();
	
	$hover_obj = array(
		'activate_hover_box'	=>	false,
		'activate_hover'		=>	true,
		'use_link'				=>	true,
		'use_back_icon'			=>	true,
		'full_link'				=>	true,
		'lightbox'				=>	array(
			'image'		=>	true,
			'video'		=>	true,
			'gallery'	=>	true,
		),
		'like'					=>	true,
		'use_schema'			=>	true,
		'content'				=>	array(
			'use_title'		=>	true,
			'link_title'	=>	true,
			'use_cats'		=>	false,
			'use_price'		=>	false,
			'use_excerpt'	=>	true,
			'excerpt_length'	=>	18,
		),
	);
	
	if(isset($GLOBALS['lightbox_gallery'])){
		$GLOBALS['lightbox_gallery']++;
	}else{
		$GLOBALS['lightbox_gallery'] = 0;	
	}
	
	$return = '<div class="relative-container rockthemes-hover">';
	
	$media = '';
	
	//First check if there is a video for this post
	if(isset($rockthemes_advanced_details['video_iframe_code']) && !empty($rockthemes_advanced_details['video_iframe_code'])){
		//Post contains a video in the Advanced Details field
		if($display_video_directly){
			$media .= azoom_embed_video($rockthemes_advanced_details['video_iframe_code']);
		}
	}
	
	//Check if post contains extra images for Swiper Slider
	elseif(isset($rockthemes_advanced_details['extra_featured_images']) && 
		is_array($rockthemes_advanced_details['extra_featured_images']) && 
		count($rockthemes_advanced_details['extra_featured_images']) &&
		$rockthemes_advanced_details['extra_featured_images'][0] != '' &&
		$enable_swiper){
		//There are extra images bound to this post. We will return as Swiper Slider
		$media .= rockthemes_make_swiperslider_shortcode($post->ID,$featured_image_size);
		return '<div style="position:relative;">'.$media.'</div>';
	}
	
	//There is no video or extra images for Swiper Slider. We will return regular Featured image with hover
	elseif(wp_get_attachment_image(get_post_thumbnail_id($post->ID),$featured_image_size)){
		if(!xr_get_option('remove_image_wh', true)){
			$media .= wp_get_attachment_image(get_post_thumbnail_id($post->ID),$featured_image_size);
		}else{
			$image_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),$featured_image_size);
			$image_alt = trim(strip_tags( get_post_meta(get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true) ));
		
			$media .= '<img src="'.$image_url[0].'" '.(isset($image_alt) && $image_alt ? 'alt="'.$image_alt.'"' : '').' />';
		}
		if($hover_active){
			$media .= azoom_hover_effect($post->ID, $hover_obj);
		}
	}elseif(get_post_thumbnail_id($post->ID)){
		$media .= rockthemes_demo_image($featured_image_size);	
		if($hover_active){
			$media .= azoom_hover_effect($post->ID, $hover_obj);
		}
	}
	
	//azoom_featured_empty_icons();
	
	if($media){
		$return .= $media;	
	}else{
		return azoom_featured_empty_icons('', $placeholder);
	}
	
	//If there is no value entered for the $return we will turn back as empty string.
	$return .= '</div>';//Close relative-container div
	
		
	if($echo) echo rockthemes_escaped_out_render($return);
	else return $return;
}


endif;






if(!function_exists('azoom_embed_video')):
/*
**	Embed iframe videos in responsive container
**
**	@param	:	$url:String, URL of the video
**	@return	:	$return:String,	HTML iframe element wrapped in flex-video class
*/
function azoom_embed_video($url=null){
	if(!$url) return;
	
	$return = '
	<div class="flex-video">
         <iframe src="'.esc_url($url).'" frameborder="0" width="560" height="315"></iframe>
	</div>
	';
	
	return $return;
}
endif;





if(!function_exists('rockbb_get_logout_link')):
/*
**	BBPress Logout Link
**
*/
function rockbb_get_logout_link( $redirect_to = '' ) {
	return '<a href="' . wp_logout_url( $redirect_to ) . '" class="logout-link">' . esc_html__( 'Log Out', 'azoom' ) . '</a>';
}
endif;
add_filter('bbp_get_logout_link', 'rockbb_get_logout_link', 10, 1);




if ( ! function_exists( 'azoom_entry_meta' ) ) :
/**
 * Prints HTML with meta information for current post: categories, tags, permalink, author, and date.
 *
 * @return void
 */
function azoom_entry_meta() {
	$return = '';
	
	// Translators: used between list items, there is a space after the comma.
	$categories_list = get_the_category_list( esc_html__( ', ', 'azoom' ) );
	if ( $categories_list ) {
		if(strpos($categories_list, 'class=') > -1){
			$categories_list = str_replace('class="', 'class="escapea ', $categories_list);	
		}else{
			$categories_list = str_replace('<a ', '<a class="escapea" ', $categories_list);	
		}
		$return .= '<span class="categories-links entry-meta-single"><i class="icomoon icomoon-icon-folder-open"></i> ' . $categories_list . '</span>';
	}
	
	// Translators: used between list items, there is a space after the comma.
	$tag_list = get_the_tag_list( '', esc_html__( ', ', 'azoom' ) );
	if ( $tag_list ) {
		if(strpos($tag_list, 'class=') > -1){
			$tag_list = str_replace('class="', 'class="escapea ', $tag_list);	
		}else{
			$tag_list = str_replace('<a ', '<a class="escapea" ', $tag_list);	
		}
		$return .= '<span class="tags-links entry-meta-single"><i class="icomoon icomoon-icon-tags"></i> ' . $tag_list . '</span>';
	}
	

	// Post author
	if ( 'post' == get_post_type() ) {
		/*
		**	it was used to be "url fn n". "n" removed
		**	rel="author" removed from <a> tag
		*/
		$return .= sprintf( '<span class="author vcard entry-meta-single"><i class="icomoon icomoon-icon-user"></i> <a class="url fn escapea" href="%1$s" title="%2$s" >%3$s</a></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_attr( sprintf( esc_html__( 'View all posts by %s', 'azoom' ), get_the_author() ) ),
			get_the_author()
		);
	}

	return $return;
}
endif;







//Deprecated
if ( ! function_exists( 'azoom_entry_date' ) ) :
/**
 * Prints HTML with date information for current post.
 *
 * @param boolean $echo Whether to echo the date. Default true.
 * @return string
 */
function azoom_entry_date( $echo = true ) {
	$format_prefix = ( has_post_format( 'chat' ) || has_post_format( 'status' ) ) ? esc_html_x( '%1$s on %2$s', '1: post format name. 2: date', 'azoom' ): '%2$s';

	$date = sprintf( '<span class="date"><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a></span>',
		esc_url( get_permalink() ),
		esc_attr( sprintf( esc_html__( 'Permalink to %s', 'azoom' ), the_title_attribute( 'echo=0' ) ) ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( sprintf( $format_prefix, get_post_format_string( get_post_format() ), get_the_date() ) )
	);

	if ( $echo ){
		echo rockthemes_escaped_out_render($date);
	}

	return $date;
}
endif;








if(!function_exists('azoom_get_before_post_link')):
/*
**	Azoom Get Before Post Link
**
**	@since	:	1.0
*/
function azoom_get_before_post_link($echo = true, $use_icon = true){
	global $post;
	if(!isset($post)) return;
	
	$before = get_previous_post_link('<div class="azoom-before-post-link">%link</div>');
	$before_post = get_previous_post();
	
	$img = '';
	if($before_post && $before_post !== ''){
		$img = wp_get_attachment_image(get_post_thumbnail_id($before_post->ID), 'main_small');
		if(!$img || $img === ''){
			$img = azoom_featured_empty_icons($before_post->post_type, array('line_height' => '60px', 'font_size' => '30px', 'width' => '60px', 'max_width'=>'60px'));
		}
		$img = '<div class="back-article-link">'.$img.'</div>';
	}
	
	if($use_icon){
		preg_match('/\<a .*?\>(.*?)\<\/a\>/', $before, $text);

		if(isset($text) && isset($text[1])){
			if(!is_rtl()){
				$new_text = '<i class="animate-icon animate-to-left icomoon icomoon-icon-arrow-left3"></i> '.$text[1];
			}else{
				$new_text = $text[1].' <i class="animate-icon animate-to-left icomoon icomoon-icon-arrow-left3"></i>';
			}
			$before = str_replace($text[1], $new_text, $before);
		}

	}
	
	if($img !== ''){
		preg_match('/\<a .*?\>(.*?)\<\/a\>/', $before, $text);
		if(isset($text) && isset($text[1])){
			$before = str_replace($text[1], $img.'<p><strong>'.esc_html__('Previous Article','azoom').'</strong></p>'.$text[1], $before);
		}
	}
	
	
	
	if($echo){
		echo rockthemes_escaped_out_render($before);
	}else{
		return $before;	
	}
	
	return;
}
endif;



if(!function_exists('azoom_get_next_post_link')):
/*
**	Azoom Get Next Post Link
**
**	@since	:	1.0
*/
function azoom_get_next_post_link($echo = true, $use_icon = true){
	global $post;
	if(!isset($post)) return;
	
	$next = get_next_post_link('<div class="azoom-next-post-link">%link</div>');
	$next_post = get_next_post();
	
	
	$img = '';
	if($next_post && $next_post !== ''){
		$img = wp_get_attachment_image(get_post_thumbnail_id($next_post->ID), 'main_small');
		if(!$img || $img === ''){
			$img = azoom_featured_empty_icons($next_post->post_type, array('line_height' => '60px', 'font_size' => '30px', 'width' => '60px', 'max_width'=>'60px'));
		}	
		$img = '<div class="next-article-link">'.$img.'</div>';
	}
		
	if($use_icon){
		preg_match('/\<a .*?\>(.*?)\<\/a\>/', $next, $text);

		if(isset($text) && isset($text[1])){
			if(!is_rtl()){
				$new_text = $text[1].' <i class="animate-icon animate-to-right icomoon icomoon-icon-next15"></i>';
			}else{
				$new_text = '<i class="animate-icon animate-to-right icomoon icomoon-icon-previous11"></i> '.$text[1];
			}
			$next = str_replace($text[1], $new_text, $next);
		}
	}
	
	
	if($img !== ''){
		preg_match('/\<a .*?\>(.*?)\<\/a\>/', $next, $text);
		if(isset($text) && isset($text[1])){
			$next = str_replace($text[1], $img.'<p><strong>'.esc_html__('Next Article','azoom').'</strong></p>'.$text[1], $next);
		}
	}
	
	
	if($echo){
		echo rockthemes_escaped_out_render($next);	
	}else{
		return $next;	
	}
	
	return;
}
endif;






if(!function_exists('azoom_single_post_footer')):
/*
**	Single Post Footer
**
**	@since	:	1.0
*/
function azoom_single_post_footer(){
	if(!is_single()) return;
	
	
	$return = azoom_get_post_share();
	
	
	$el = '
		<div class="large-6 medium-6 columns ">
			'.azoom_get_before_post_link(false,false).'
		</div>
		<div class="large-6 medium-6 columns right-text ">
			'.azoom_get_next_post_link(false,false).'
		</div>
	';
	
	if(is_rtl()){
		$el = '
			<div class="large-6 medium-6 columns left-text ">
				'.azoom_get_next_post_link(false,false).'
			</div>
			<div class="large-6 medium-6 columns ">
				'.azoom_get_before_post_link(false,false).'
			</div>
		';
	}
	
	$return .= '
	<div class="posts-navigation">
		<hr/>
			<div class="row collapse">
				'.$el.'
			</div>
		<hr/>	
	</div>
	';
	
	echo rockthemes_escaped_out_render($return);
}
endif;
add_action('rockthemes_single_post_footer', 'azoom_single_post_footer');





if(!function_exists('azoom_article_details_class')):
/*
**	Article details can have a boxed layout easily
**
*/
function azoom_article_details_class(){
	if(xr_get_option('blog_boxed_article', false) !== true) return '';
	
	return 'azoom-small-box-shadow padding-2x boxed-layout';
}
endif;



if(!function_exists('azoom_blogroll_after_article_func')):
function azoom_blogroll_after_article_func(){
	if(xr_get_option('blog_boxed_article', false) === true){
		echo '<div class="vertical-space"></div>';
		return;
	}
	
	echo '<div class="clear"></div>
		<div class="vertical-space"></div>
		<hr />
		<div class="vertical-space"></div>';
}
endif;
add_action('azoom_blogroll_after_article', 'azoom_blogroll_after_article_func');










if ( ! function_exists( 'azoom_paging_nav' ) ) :
/**
 * Displays navigation to next/previous set of posts when applicable.
 *
 */
function azoom_paging_nav($echo=false) {
	global $wp_query;
	
	$total_pages = $wp_query->max_num_pages;

	// Don't print empty markup if there's only one page.
	if ( $total_pages < 2 && ( is_home() || is_archive() || is_search() ) )
		return;
		
	//Define current page
	$current_page = max(1, get_query_var('paged'));  
	$big = 999999999;
	$base = str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) );
	
	//If echo value is true echo the output
	if($echo){
		echo '<div class="azoom-pagination">';
		echo paginate_links(array(  
			'base'		=> $base,  
			'format'	=> 'page/%#%',  
			'prev_text'	=> '<i class="icomoon icomoon-icon-previous11"></i> '.esc_html__('Previous','azoom'),
			'next_text'	=> esc_html__('Next','azoom').' <i class="icomoon icomoon-icon-next15"></i>',
			'current'	=> $current_page,  
			'total'		=> $total_pages,  
		));  
		echo '<div class="clear"></div>';
		echo '</div>';
	}else{
		//If echo is false, only return the output. Useful for shortcodes
		return '<div class="azoom-pagination">'.paginate_links(array(  
			'base'		=> $base,  
			'format'	=> 'page/%#%',  
			'prev_text'	=> '<i class="icomoon icomoon-icon-previous11"></i> '.esc_html__('Previous','azoom'),
			'next_text'	=> esc_html__('Next','azoom').' <i class="icomoon icomoon-icon-next15"></i>',
			'current'	=> $current_page,  
			'total'		=> $total_pages,  
		)).'<div class="clear"></div></div>';  
	}
}
endif;











if(!function_exists('azoom_get_link_pages')):
/*
**	Alters the wp_link_pages function for the visuality
**
**	@return	:	Echo the page numbers and links in HTML
*/
function azoom_get_link_pages(){
	global $post;
	if(!$post) return;
	
	wp_link_pages( 
		array( 
			'before'			=>	'<div class="azoom-pagination azoom-link_pages">', 
			'after'				=>	'</div><div class="clear"></div>', 
			'link_before'		=>	'<span class="page-numbers">', 
			'link_after'		=>	'</span>',
			'previouspagelink'	=>	'<i class="icomoon icomoon-icon-previous11"></i> '.esc_html__('Previous','azoom'),
			'nextpagelink'		=>	esc_html__('Next','azoom').' <i class="icomoon icomoon-icon-next15"></i>',
		) 
	);
}

endif;






if(!function_exists('azoom_get_comments_pages')):
/*
**	Alters the wp_link_pages function for the visuality
**
**	@return	:	Echo the page numbers and links in HTML
*/
function azoom_get_comments_pages(){
	global $post;
	if(!$post) return;
	
	echo '<div class="azoom-pagination azoom-link_pages">';
	paginate_comments_links( 
		array( 
			'before'			=>	'<div class="azoom-pagination azoom-link_pages">', 
			'after'				=>	'</div>', 
			'link_before'		=>	'<span class="page-numbers">', 
			'link_after'		=>	'</span>',
			'previouspagelink'	=>	'<i class="icomoon icomoon-icon-previous11"></i> '.esc_html__('Previous','azoom'),
			'nextpagelink'		=>	esc_html__('Next','azoom').' <i class="icomoon icomoon-icon-next15"></i>',
		) 
	);
	
	echo '</div>';
	echo '<br/>';
}

endif;









if ( ! function_exists( 'azoom_the_attached_image' ) ) :
/**
 * Prints the attached image with a link to the next attached image.
 *
 * @since Azoom 1.0
 *
 * @return void
 */
function azoom_the_attached_image() {
	$post                = get_post();
	$attachment_size     = apply_filters( 'rockthemes_large', array( 724, 724 ) );
	$next_attachment_url = wp_get_attachment_url();

	/**
	 * Grab the IDs of all the image attachments in a gallery so we can get the URL
	 * of the next adjacent image in a gallery, or the first image (if we're
	 * looking at the last image in a gallery), or, in a gallery of one, just the
	 * link to that image file.
	 */
	$attachment_ids = get_posts( array(
		'post_parent'    => $post->post_parent,
		'fields'         => 'ids',
		'numberposts'    => -1,
		'post_status'    => 'inherit',
		'post_type'      => 'attachment',
		'post_mime_type' => 'image',
		'order'          => 'ASC',
		'orderby'        => 'menu_order ID'
	) );

	// If there is more than 1 attachment in a gallery...
	if ( count( $attachment_ids ) > 1 ) {
		foreach ( $attachment_ids as $attachment_id ) {
			if ( $attachment_id == $post->ID ) {
				$next_id = current( $attachment_ids );
				break;
			}
		}

		// get the URL of the next image attachment...
		if ( $next_id )
			$next_attachment_url = get_attachment_link( $next_id );

		// or get the URL of the first image attachment.
		else
			$next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
	}

	printf( '<a href="%1$s" title="%2$s" rel="attachment">%3$s</a>',
		esc_url( $next_attachment_url ),
		the_title_attribute( array( 'echo' => false ) ),
		wp_get_attachment_image( $post->ID, $attachment_size )
	);
}
endif;






if(!function_exists('azoom_get_post_format_icon')):
/*
**	Uses FontAwesome icons and returns post format icon
**
**	@return	:	Returns the post type icon
*/
function azoom_get_post_format_icon(){
	global $post;

	if(!$post) return false;
	
	$post_format = get_post_format();
	
	$return = '';
	
	//Check if the post format is default
	if(!$post_format){
		//Post format is default. Default post format returns false from get_post_format() function
		$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-pencil2"></i></div>';
	}else{
		switch($post_format){
			case 'gallery':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-images"></i></div>';
			break;	
			
			case 'image':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-image2"></i></div>';
			break;
			
			case 'audio':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-headphones"></i></div>';
			break;
			
			case 'video':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-film"></i></div>';
			break;
			
			case 'aside':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-copy2"></i></div>';
			break;
			
			case 'status':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-bubble"></i></div>';
			break;
			
			case 'link':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-link"></i></div>';
			break;
			
			case 'quote':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-quotes-left"></i></div>';
			break;
			
			case 'chat':
			$return = '<div class="icomoon-icon"><i class="icomoon icomoon-icon-bubbles2"></i></div>';
			break;
		}
	}
	
	
	return $return;
}

endif;







if(!function_exists('azoom_get_title_with_date')):
/*
**	Generates the title and the date for the posts
**
**	@return	:	Returns the Title, Date and Post Format in HTML
*/
function azoom_get_title_with_date(){
	global $post;
	if(!$post) return false;
	
	$title = azoom_get_the_title();
	if(is_single()){
		$title = '
			<h1 class="title-container entry-title">
				'.$title.'
			</h1>
		';
	}else{
		$title = '
			<h2 class="title-container entry-title">
				'.$title.'
			</h2>
		';
	}

	

	$edit_text = '';
	
	if(current_user_can('edit_posts')){
		$edit_text = '<span class="edit-link"><a href="'.get_edit_post_link($post->ID).'">'.esc_html__( 'Edit', 'azoom' ).'</a></span>';	
	}
	
	$return = '';
		
	$return .= '
		<div class="azoom-title-date-container">
			'.$title.'
			<span class="entry-meta">
			'.azoom_entry_meta().'
			'.$edit_text.'
			</span>
		</div>
	';
	
	$return .= '<br/>';
	
	return $return;
}

endif;



if(!function_exists('azoom_get_boxed_date')):
function azoom_get_boxed_date(){
	global $post;
	if(!$post) return false;
	
	
	$date = '
		<div class="date-area data updated">
			<a href="'.get_month_link(get_the_time('Y'), get_the_time('m')).'" class="escapea">
				<div class="day-area">'.get_the_time('d', $post->ID).'</div>
				<span class="month-area">'.get_the_date('M').'</span>
				<span class="year-area">'.get_the_time('Y', $post->ID).'</span>
			</a>
		</div>
	';
	
	
	
	$post_format = '';
	if(xr_get_option('blog_single_feature_format', true)):
	$post_format = azoom_get_post_format_icon();
	$post_format = '<div class="post-format-container">'.$post_format.'</div>';
	endif;
	
	$entry_love = '';
	if(xr_get_option('blog_single_feature_love',true)):
	$entry_love = '
		<a href="#" class="disable-link escapea"><i class="icomoon icomoon-icon-heart"></i></a>
		<span>'.azoom_get_love_num().'</span>
	';
	$entry_love = '<div class="entry-love-container azoom-love-icon azoom-transition" data-post-id="'.$post->ID.'">'.$entry_love.'</div>';
	endif;
	
	$sticky = '';
	if ( is_sticky() && is_home() && ! is_paged() ){
		$sticky = '<div class="entry-sticky-container"><i class="icomoon icomoon-icon-pushpin"></i></div>';
	}
	
	
	$return = '
	<div class="article-date-post-format azoom-small-box-shadow">
		'.$sticky.'
		<div class="date-area-container">'.$date.'</div>
		'.$post_format.'
		'.$entry_love.'
		<div class="clear"></div>
	</div>';
	
	return $return;
}
endif;





if(!function_exists('azoom_get_the_title')):
/*
**	Returns the title with or without link. Used in RPB elements
**
**	@return	:	Returns the post/article title with or without link in HTML
*/

function azoom_get_the_title(){
	global $post,$title_link_active;//Global variable to set link to the title.
	$title_link_active = true; //Varible name can be changed later
	
	$return = '';
	
	//TO DO	:	Title will be wrapped with a special class for styling. 
	
	if($title_link_active){
		//Link is active. Wrap a tag for link around the title
		$return = '<a href="'.get_permalink().'" rel="bookmark">'.get_the_title().'</a>';
	}else{
		//Link is not active. Return only the title.
		$return = get_the_title();	
	}
	
	return $return;
	
}

endif;




if(!function_exists('azoom_get_main_title')):
/*
**	Get the Main Title. (Main Title of the current page/post/type)
**	Moved from title-default.php
**
**	@since	:	1.0
**	@return	:	Echo title of post type
*/
function azoom_get_main_title(){
	global $post;
			
	if(is_author()){
		printf( esc_html__( 'All posts by %s', 'azoom' ), '<span class="vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . esc_attr( get_the_author() ) . '" rel="me">' . get_the_author() . '</a></span>' );
	}elseif(is_category()){
		printf( esc_html__( 'Category Archives: %s', 'azoom' ), single_cat_title( '', false ) );
	}elseif(is_tag()){
		printf( esc_html__( 'Tag Archives: %s', 'azoom' ), single_tag_title( '', false ) );
	}elseif(is_tax()){
		if(function_exists('rockthemes_woocommerce_active') && rockthemes_woocommerce_active() && (is_woocommerce() || is_product())){
			woocommerce_page_title();
			
			//Remove WooCommerce default page title
			add_filter('woocommerce_show_page_title', 'rockthemes_woo_override_page_title');	
		}else{
			$queried = get_queried_object();
			$the_tax = get_taxonomy( get_query_var( 'taxonomy' ) );

			if($the_tax->name == "defaultitem_cat"){
				esc_html_e("Default Items :", "azoom");
				echo " ".$queried->name;
			}else{
				printf( esc_html__( $the_tax->labels->name.': %s', 'azoom' ), $queried->name );
			}
		}
	}elseif(is_archive()){
		if ( is_day() ) :
			printf( esc_html__( 'Daily Archives: %s', 'azoom' ), get_the_date() );
		elseif ( is_month() ) :
			printf( esc_html__( 'Monthly Archives: %s', 'azoom' ), get_the_date( esc_html_x( 'F Y', 'monthly archives date format', 'azoom' ) ) );
		elseif ( is_year() ) :
			printf( esc_html__( 'Yearly Archives: %s', 'azoom' ), get_the_date( esc_html_x( 'Y', 'yearly archives date format', 'azoom' ) ) );
		elseif(function_exists('rockthemes_woocommerce_active') && rockthemes_woocommerce_active() && is_woocommerce()):
			woocommerce_page_title();
			
			//Remove WooCommerce default page title
			add_filter('woocommerce_show_page_title', 'rockthemes_woo_override_page_title');
		else :
			if(get_queried_object() && get_queried_object()->labels){
				echo get_queried_object()->labels->name;
			}else{
				esc_html_e( 'Archives', 'azoom' );
			}
		endif;
	}elseif(is_search()){
		printf( esc_html__( 'Search Results For: %s', 'azoom' ), get_search_query() );
	}elseif(is_author()){
		printf( esc_html__( 'All posts by %s', 'azoom' ), '<span class="vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . esc_attr( get_the_author() ) . '" rel="me">' . get_the_author() . '</a></span>' );
	}elseif(function_exists('is_bbpress') && is_bbpress()){
		echo get_the_title(get_queried_object_id());
	}else{
		if(is_single()){
			if(xr_get_option('show_post_name_on_title', false)){
				echo get_the_title(get_queried_object_id());
			}else{
				if(rockthemes_woocommerce_active() && is_product()){
					woocommerce_page_title();
					
					add_filter('woocommerce_show_page_title', 'rockthemes_woo_override_page_title');	
				}elseif(is_singular( 'defaultitems' )){
					esc_html_e('Portfolio', 'azoom');
				}else{
					if(!xr_get_option('blog_link_in_breadcrumbs', false)){
						$cat = get_the_category();
						if(isset($cat) && isset($cat[0])){
							$cat = $cat[0];
							$top_levels = get_category_parents($cat, FALSE, '-');
							if(isset($top_levels) && !empty($top_levels)){
								$top_title = explode('-', $top_levels);
								echo rockthemes_escaped_out_render($top_title[0]);
							}else{
								echo rockthemes_escaped_out_render($cat->cat_name);
							}
						}else{
							esc_html_e('Blog', 'azoom');
						}
					}else{
						$posts_page_id = get_option( 'page_for_posts');
						$blog_page_html = '';
						if($posts_page_id){
							$posts_page = get_page( $posts_page_id);
							$posts_page_title = $posts_page->post_title;
							echo rockthemes_escaped_out_render($posts_page_title);
						}else{
							esc_html_e('Blog', 'azoom');
						}
					}
				}
			}
		}else{
			if(is_home()){
				esc_html_e('Blog', 'azoom');
			}else{
				echo get_the_title(get_queried_object_id());
			}
		}
	}
}
endif;


if(!function_exists('rockthemes_woo_override_page_title')):
//Remove WooCommerce default page title
function rockthemes_woo_override_page_title() {
	return false;
}
endif;





if(!function_exists('azoom_get_post_loop_description')):
/*
**	This function will generate the summary for the blog post loop. 
**
**
**	@return	:	Returns the excerpt or the content according to the choice	
**
**	TO DO	:	Usage of the function can be extended
*/
function azoom_get_post_loop_description(){
	global $post;
	if(!$post) return;
	
	$summary_choice = sanitize_text_field(xr_get_option('post_summary','content'));//or excerpt;
	
	$return = '';
	
	if($summary_choice === 'content'){
		//Check if page-builder in use
		$in_use = get_post_meta($post->ID,'_builder_in_use',true);
		if((isset($in_use) || $in_use !== 'false')){
			//RPB Content area closes div tag. Add an extra div for that
			$return = rock_check_p(get_the_excerpt());
		}else{
			$return = azoom_get_the_content();
		}
	}elseif($summary_choice === 'excerpt'){
		$return = rock_check_p(get_the_excerpt());
		//$return .= azoom_get_read_more_link();
	}
	
	return $return;
}

endif;






if(!function_exists('azoom_get_entry_header')):
/*
**	Post contents will have a header. We will add two options for these headers. 
**	These options will be setted with Theme Options. Options are :
**	1 - Featured Image at the top and the header title and details
**	2 - Header title and the details are at the top and then the featured image
**
**	@return	:	Entry header content in HTML
*/

function azoom_get_entry_header(){
	global $post;
	if(!$post) return;
	
	$image_at_top = true;
	
	$return = '';
	
	if($image_at_top){
		if ( has_post_thumbnail() && ! post_password_required() ) :
		$return .= '
		<div class="entry-thumbnail">
			'.azoom_get_featured_image(false).'
		</div>
		';
		endif;
		
		if ( is_single() ) :
		$return .= azoom_get_title_with_date();
		else :
		$return .= azoom_get_title_with_date();
		endif; // is_single()		
	}else{
		if ( is_single() ) :
		$return .= azoom_get_title_with_date();
		else :
		$return .= azoom_get_title_with_date();
		endif; // is_single()
		
		if ( has_post_thumbnail() && ! post_password_required() ) :
		$return .= '
		<div class="entry-thumbnail">
			'.azoom_get_featured_image(false).'
		</div>
		';
		endif;
	}
	
	return $return;
}
endif;







if(!function_exists('azoom_get_read_more_text')):
/*
**	Instead of using the same read more text a lot of place, we will use this function to return read more text
**
**	@return	:	read more text
*/
function azoom_get_read_more_text(){
	
	$return = '';
	
	if(is_rtl()){
		$return .= esc_html__('Read More','azoom').' <i class="animate-icon animate-to-left icomoon icomoon-icon-previous11"></i>';
	}else{
		$return .= esc_html__('Read More','azoom').' <i class="animate-icon animate-to-right icomoon icomoon-icon-next15"></i>';
	}
	
	return $return;	
}

endif;








if(!function_exists('azoom_get_read_more_link')):
/*
**	Returns the read more as link
**
**	@param	:	$target link target. _self or _blank
**	@return	:	Returns the "read more" link in HTML format
*/
function azoom_get_read_more_link($target='_self'){
	global $post;
	if(!$post) return;
	
	$is_button = false;
	
	$return = '';
	
	if($is_button){
		$return .= '<a href="'.get_permalink().'" class="more-link button button-custom"  target="'.esc_attr($target).'">'.azoom_get_read_more_text().'</a>';
	}else{
		$return .= '<a href="'.get_permalink().'" class="more-link"  target="'.esc_attr($target).'">'.azoom_get_read_more_text().'</a>';
	}
	

	return $return;
}

endif;






/*This will be removed and the above function will be in use*/
if(!function_exists('azoom_read_more')):
/*
**	Qusar read more link
**
**	@param	:	postID
**	@return	:	read more text with post link in HTML format 
*/
function azoom_read_more($target='_self'){
	global $post;

	if(!$post || (!$post->ID)) return;
	
	$return = ' <a href="'.get_permalink().'" target="'.esc_attr($target).'">'.esc_html__('read more','azoom').' <i class="icomoon icomoon-icon-next15"></i></a>';
	
	return $return;
}

endif;





if(!function_exists('azoom_entry_footer_meta')):
/*
**	Entry Footer Meta Details
**
**	Comments Number
**	Post Views
**
**	@return	:	Echo Footer Post Meta deatails in HTML
**	
**	@since	:	1.0
*/
function azoom_entry_footer_meta(){
	global $post;

	if(comments_open()){
		?>
		<div class="comments-link">
			<?php comments_popup_link( '<span class="leave-reply"><i class="icomoon icomoon-icon-bubbles4"></i> ' . esc_html__( 'Leave a comment', 'azoom' ) . '</span>', '<i class="icomoon icomoon-icon-bubbles4"></i> '.esc_html__( 'One comment so far', 'azoom' ), '<i class="icomoon icomoon-icon-bubbles4"></i> '.esc_html__( 'View all % comments', 'azoom' ) ); ?>
		</div><!-- .comments-link -->
		<?php
	}

	?>
    
    <?php if(xr_get_option('blog_single_feature_view',true)): ?>
    <div class="post-view">
        <?php echo azoom_get_post_views(); ?>
    </div>
	<?php endif; ?>
	<?php 
	if(!is_single()){
		echo azoom_get_read_more_link(); 
	}
	?>

    <div class="clear"></div>
    <?php
}
endif;






if(!function_exists('azoom_get_post_views')):
/*
**	Gets the post view number
**
**	@return	:	Returns the post number
*/
function azoom_get_post_views(){
	global $post;
	if(!$post) return;
	
	$count_key = 'post_views_count';
	$count = get_post_meta($post->ID, $count_key, true);
	if ($count == '') {
		delete_post_meta($post->ID, $count_key);
		add_post_meta($post->ID, $count_key, '0');
		$count = 0;
	}
	
	$return = '<i class="icomoon icomoon-icon-eye"></i> '.$count.esc_html__(' View', 'azoom');
	
	return $return;
}
endif;



if(!function_exists('azoom_set_post_views')):
/*
**	Set the post view number for the current post. This function will be called fonr the "single.php" file
**	and only will set the view if the post is single
**
**	@return	:	Does not return any value
*/
function azoom_set_post_views(){
	global $post;
	if(!$post) return;
	
	if(!is_single()) return;
	
	$count_key = 'post_views_count';
	$count = get_post_meta($post->ID, $count_key, true);
	if ($count == '') {
		$count = 0;
		delete_post_meta($post->ID, $count_key);
		add_post_meta($post->ID, $count_key, '0');
	} else {
		$count++;
		update_post_meta($post->ID, $count_key, $count);
	}
}
endif;



if(!function_exists('azoom_get_love_num')):
/*
**	Gets the post view number
**
**	@return	:	Returns the post number
*/
function azoom_get_love_num(){
	global $post;
	if(!$post) return;
	
	$count_key = '_entry_love_num';
	$count = get_post_meta($post->ID, $count_key, true);
	if ($count == '') {
		delete_post_meta($post->ID, $count_key);
		add_post_meta($post->ID, $count_key, '0');
		$count = 0;
	}
		
	return $count;
}
endif;



if(!function_exists('azoom_set_love_num')):
/*
**	Set the post view number for the current post. This function will be called fonr the "single.php" file
**	and only will set the view if the post is single
**
**	@return	:	Does not return any value
*/
function azoom_set_love_num($post_id = null){
	global $post;
	if(!$post && !$post_id) return;
	if($post_id) $post_id = intval($post_id);
	
	if($post){
		$post_id = $post->ID;	
	}
	
	$count_key = '_entry_love_num';
	$count = get_post_meta($post_id, $count_key, true);
	if ($count == '') {
		$count = 0;
		delete_post_meta($post_id, $count_key);
		add_post_meta($post_id, $count_key, '0');
	} else {
		$count++;
		update_post_meta($post_id, $count_key, $count);
	}
}
endif;


if(!function_exists('azoom_set_love_num_ajax')):
function azoom_set_love_num_ajax(){
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rockthemes_love_nonce') ||
		!check_ajax_referer('rockthemes_love_nonce')) {
			
		//Die
		die('ERROR');		
	}
	
	if(!isset($_REQUEST['data']) ||
		!isset($_REQUEST['data']['post_id'])){
		
		die('ERROR');		
	}
	
	azoom_set_love_num(intval($_REQUEST['data']['post_id']));
	
	echo 'success';
		
	exit;
}
endif;
add_action('wp_ajax_nopriv_azoom_love_ajax', 'azoom_set_love_num_ajax');
add_action('wp_ajax_azoom_love_ajax', 'azoom_set_love_num_ajax');






if(!function_exists('azoom_get_the_excerpt')):
/*
**	Custom Excerpt function to retrieve excerpt from the post
**
**	@param	:	$post_in	Object,		Wordpress Post Object
**	@param	:	$echo		Boolean,	echo or return
**	@param	:	$length		Int,		Excerpt length in words.
**	@return	:	Excerpt of the post
**
*/
function azoom_get_the_excerpt($post_in = '', $echo = false, $length = 10){
	global $post;
	$excerpt = '';
	if(!empty($post_in)) $post = $post_in;

	$excerpt = get_the_excerpt();
	if(empty($excerpt)){
		$excerpt = $post->post_excerpt;
	}

	
	if(!empty($excerpt)){
		$excerpt = explode(' ',$excerpt);
		if(count($excerpt) > $length){
			$excerpt = array_slice($excerpt, 0, $length);
		}
		$excerpt = implode(' ',$excerpt);
		
		if($echo){
			echo rockthemes_escaped_out_render($excerpt);
		}else{
			return $excerpt;
		}
	}
	return '';
}
endif;







if(!function_exists('azoom_get_the_content')):
/*
**	Wordpress's default get_the_content returns unfiltered content. Without <p> and <br/> tags. This function will 
**	recover that issue
**
**	@return	:	The content of the post with filtered tags such as <p> and <br/>
*/
function azoom_get_the_content(){
	global $post;
	$content = get_the_content('',FALSE);
	$content = apply_filters('the_content', $content);
	$content = str_replace(']]>', ']]&gt;', $content);	

	return $content;
}

endif;






if(!function_exists('azoom_get_post_share')):
/*
**	Social share buttons for the blog posts. Currently support 4 social buttons :
**
**	Facebook
**	Twitter
**	Google+
**	Pinterest
**
**	@param	:	$args array with $social_html and $social_js. Allows to add extra entry at the beginning
**	@return	:	Returns the social media button in HTML
*/
function azoom_get_post_share($args=null){
	global $post;
		
	$social_html	=	'';
	$social_js		=	'';
	
	if($args && is_array($args)){
		extract($args);
	}
	
	if(xr_get_option('blog_single_share_facebook', true) === true):
	//Facebook
	$social_html	.=	'<div class="fb-like" data-href="'.get_permalink().'" data-width="90" data-layout="button_count" data-show-faces="false" data-send="false"></div>';	
	$social_js		.=	'
		(function(d, s, id) {
		  var js, fjs = d.getElementsByTagName(s)[0];
		  if (d.getElementById(id)) return;
		  js = d.createElement(s); js.id = id;
		  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
		  fjs.parentNode.insertBefore(js, fjs);
		}(document, "script", "facebook-jssdk"));
	';
	endif;
	
	if(xr_get_option('blog_single_share_twitter', true) === true):
	//Twitter
	$social_html	.=	'<a href="//twitter.com/share" class="twitter-share-button">Tweet</a>';
	$social_js		.=	'!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?"http":"https";if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document, "script", "twitter-wjs");';
	endif;
	
	if(xr_get_option('blog_single_share_google', true) === true):
	//Google+
	$social_html	.=	'<div class="g-plusone" data-size="medium"></div>';
	$social_js		.=	'
	  (function() {
		var po = document.createElement("script"); po.type = "text/javascript"; po.async = true;
		po.src = "https://apis.google.com/js/plusone.js";
		var s = document.getElementsByTagName("script")[0]; s.parentNode.insertBefore(po, s);
	  })();
	';
	endif;
	
	if(xr_get_option('blog_single_share_pinterest', true) === true):
	//Pinterest
	$pinterest_html	=	'<a href="//pinterest.com/pin/create/button/?url='.get_permalink().'&media='.get_permalink().'&description='.get_permalink().'" data-pin-do="buttonPin" data-pin-config="beside"><img src="//assets.pinterest.com/images/pidgets/pin_it_button.png" alt="Pin It" /></a>';
	$pinterest_html = str_replace('&', '&amp;', $pinterest_html);
	
	$social_html 	.=	$pinterest_html;
	endif;
	
	$social_html	=	apply_filters('azoom_post_social_html',$social_html);
	$social_js		=	apply_filters('azoom_post_social_js',$social_js);
	
	$return		=	'';
	
	if($social_html == ''){
		return '';	
	}
	
	$return		.=	'<script type="text/javascript">'.$social_js.'</script>';
	
	$return		.=	'<div class="azoom-post-social">'.$social_html.'</div><div class="clear"></div>';
	
	return $return;
}
endif;







if(!function_exists('azoom_hr_shadow')):
/*
**	Azoom hr object with shadow
**
**	@return	:	Returns the hr element wrapped with div.
*/
function azoom_hr_shadow(){
	return '<div class="hr-shadow-mask"><hr class="hr-shadow active shadow-effect curve curve-hz-1"></div>';	
}

endif;







if(!function_exists('azoom_image_shadow_up')):
/*
**	Azoom hr object with shadow
**
**	@return	:	Returns the hr element wrapped with div.
*/
function azoom_image_shadow_up(){
	return '<div class="shadow-divider-up"><img src="'.esc_url(F_WAY.'/images/shadow-divider-up.png').'" alt="Shadow Divider Up" /></div>';	
}

endif;








if(!function_exists('azoom_image_shadow_down')):
/*
**	Azoom hr object with shadow
**
**	@return	:	Returns the hr element wrapped with div.
*/
function azoom_image_shadow_down(){
	return '<div class="shadow-divider-down"><img src="'.esc_url(F_WAY.'/images/shadow-divider-down.png').'" alt="Shadow Divider Down" /></div>';	
}

endif;





if(!function_exists('rockthemes_loader_motion')):
/*
**	Main Loader Motion of the elements.
**
**	@param	:	$class:String	extra class name to style loader
**	@return	:	Returns the HTML of the loader
**
**	@since	:	1.0
*/
function rockthemes_loader_motion($class = ''){
	$return = '
		<span class="rt_loading '.esc_attr($class).'">
			<span class="rt_spinner">
				<span class="rt_rect1"></span>
				<span class="rt_rect2"></span>
				<span class="rt_rect3"></span>
				<span class="rt_rect4"></span>
				<span class="rt_rect5"></span>
			</span>
		</span>
	';
	
	return $return;
}
endif;












if(!function_exists('azoom_call_portfolio_shortcode')):
/*
**	Calls the Azoom Portfolio Shortcode function and uses the return HTML of Azoom Portfolio Shortcode
**
**	@param	:	$atts Azoom shortcode attributes.
**	@return	:	Does not return any data
**	@echo	:	Echo the return value from Azoom Portfolio Shortcode
*/
	function azoom_call_portfolio_shortcode($atts=null){
		if(!$atts) return;
		
		if(!function_exists('rockthemes_make_swiperslider_shortcode') && $atts['use_swiper_for_thumbnails'] === 'true'){
			$atts['use_swiper_for_thumbnails'] = 'false';
		}
		
		if(function_exists('rockthemes_shortcode_make_portfolio')){
			echo rockthemes_shortcode_make_portfolio($atts);
		}
		
		return;
	}
endif;



if(!function_exists('rockthemes_array_flatten')):
/*
**	Flatten a complex array and return it as a simple array.
**
**	@since	:	1.0
*/
function rockthemes_array_flatten($array) { 
  if (!is_array($array)) { 
    return false; 
  } 
  $result = array(); 
  foreach ($array as $key => $value) { 
    if (is_array($value)) { 
      $result = array_merge($result, rockthemes_array_flatten($value)); 
    } 
    else { 
      $result[$key] = $value; 
    } 
  } 
  return $result; 
} 
endif;








if(!function_exists('rockthemes_is_true')):
/*
**	Checks for both boolean and string true and returns boolean 	
**
**	@param	:	String/Boolean variable to check
**	@return	:	Boolean true/false
**	@since	:	1.3
**
*/
function rockthemes_is_true($is_true = false){
	if(isset($is_true) && !empty($is_true) && $is_true && ($is_true === true || $is_true === 'true')){
		return true;	
	}
	return false;
}
endif;




if(!function_exists('azoom_hover_effect')):
/*
**	Returns HTML codes for hover effect.
**
**	@param	:	$postID 		ID of the current post
**	@param	:	$insert_shadow * DEPRECATED	If there should be shadow under the image
**	@param	:	$new_elem		Array	If there is no post, this element will provide details
**
*/

	function azoom_hover_effect($postID, $hover_obj = array(), $insert_shadow = false, $new_elem = array()){		
		
		$schema = rockthemes_get_product_schema();
		$only_hover = (isset($postID) && $postID === 'only_hover') ? true : false;
		
		/*
		**	Icons
		**	
		**	Hybrid support. 
		*/
		$icons = array(
			'back_icon'		=>	'<i class="icomoon icomoon-icon-undo2"></i>',
			'link_icon'		=>	'<i class="icomoon icomoon-icon-next15 animate-icon animate-to-right"></i>',
			'video_icon'	=>	'<i class="icomoon icomoon-icon-play2"></i>',
			'image_icon'	=>	'<i class="icomoon icomoon-icon-camera"></i>',
			'gallery_icon'	=>	'<i class="icomoon icomoon-icon-images"></i>',
			'like_icon'		=>	'<i class="icomoon icomoon-icon-heart"></i>',
		);
		//Extract icons for shorthand usage
		extract($icons);
		
		
		if(!$only_hover){
			//Post ID is valid
			
			$alt = get_post_meta(get_post_thumbnail_id($postID), '_wp_attachment_image_alt', true);
			$alt_tag = $alt ? $alt : '';
			
			$post_format = get_post_format();

				$post_img_id = get_post_thumbnail_id($postID);
				if($post_img_id){
					$full_image= wp_get_attachment_image_src( $post_img_id, 'full' );
				}else{
					$full_image= wp_get_attachment_image_src( $postID,'full' );
				}

		}
						
		$hover_obj_default = array(
			'activate_hover_box'	=>	false,
			'hover_footer'			=>	true,
			'hover_bg_color'		=>	sanitize_text_field(xr_get_option('hover_color_default', '')),
			'hover_bg_opacity'		=>	(int) xr_get_option('hover_color_opacity', 80),
			'activate_hover'		=>	true,
			'use_link'				=>	true,
			'where_to_link'			=>	false,
			'full_link'				=>	false,
			'use_back_icon'			=>	true,
			'lightbox'				=>	array(
				'image'		=>	false,
				'video'		=>	false,
				'gallery'	=>	false,
			),
			'like'					=>	false,
			'use_schema'			=>	false,
			'content'				=>	array(
				'use_title'		=>	true,
				'link_title'	=>	true,
				'use_cats'		=>	false,
				'use_price'		=>	false,
				'use_excerpt'	=>	true,
				'excerpt_length'	=>	10,
			),
		);
		
		//TO DO : Get changes from Advanced Details here
		
		if(!is_array($hover_obj)){
			$hover_obj = array();	
		}		
		
		//Merge coming settings with default
		$hover_obj = array_merge($hover_obj_default, $hover_obj);
		
		//Shorthand for all our settings
		extract($hover_obj);
				
		$use_schema = (isset($use_schema) && $use_schema) ? true : false;
		
		/*
		**	FULL Link Feature is almost ready. Only need to be added on RPB. Supports WooCommerce too
		**
		**	Full link will not work if category link enabled in RPB.
		**	if($full_link === 'false') $full_link = false;
		*/
		
		$product = false;
		$use_woo_details = false;
		if(!$only_hover){
			//Post ID Valid
			
			if(rockthemes_is_true($content['use_price']) && rockthemes_woocommerce_active()){
				$product = new WC_Product( $postID );
				//var_dump($product->get_data());
				if(isset($product) && $product && get_post($postID)->post_type === 'product' ){
					$use_woo_details = true;
				}
			}
		}
		
		if(!$use_schema){
			$schema = '';	
		}
	
		if(!$only_hover){
			$rad = get_post_meta($postID, 'advanced_post_details', true);
		}
		
		if(strpos($where_to_link, 'external') !== false && isset($rad['external_link']) && $rad['external_link'] !== ''){
			$link_url = $rad['external_link'];
		}elseif(!$only_hover){
			$link_url = get_permalink($postID);
		}elseif(isset($new_elem['link_url'])){
			$link_url = $new_elem['link_url'];	
		}
			
		
		$return = '';
		
		//Escape Link URL
		if(isset($link_url)){
			$link_url = esc_url($link_url);	
		}
		
				
		//If using Woo | or links enabled on categories, disable full_link
		if($use_woo_details) $full_link = false;
		if(isset($content) && isset($content['cats_link']) && strpos($content['cats_link'], 'cat-link') > -1) $full_link = false;

				
		
		//Check if Full Link is active
		if($full_link && ($full_link === true || $full_link === 'true') && !is_single()){
			$return .= '<a href="'.esc_url($link_url).'" class="escapea" '.$schema.'>';	
		}
		//If we will display title/excerpt/categories, we will wrap them in our div
		if(rockthemes_is_true($content['use_title']) || rockthemes_is_true($content['use_cats']) || rockthemes_is_true($content['use_excerpt']) || $only_hover){
			$hover_bg_style = 'rgba('.rockthemes_hex2rgba($hover_bg_color, ((int)$hover_bg_opacity / 100)).')';
			$return .= '<div class="hover-item-details-container '.($use_woo_details ? 'azoom-woo-hover-container' : '').'" style="background:'.$hover_bg_style.';" >';//'.$schema.' was here
		}

		if(rockthemes_is_true($content['use_title'])){
			$return .= '<h2 '.(!(!$full_link && $content['link_title']) && $use_schema ? 'itemprop="name"' : '').'>';
			//Start Title
			if(!rockthemes_is_true($full_link) && $content['link_title'] && !is_single()){
				$return .= '<a href="'.$link_url.'" class="escapea" '.($use_schema ? 'itemprop="name"' : '').'>';
			}
			$return .= ($only_hover && isset($new_elem['title']) ? $new_elem['title'] : get_the_title($postID));
			if(!rockthemes_is_true($full_link) && $content['link_title'] && !is_single()){
				$return .= '</a>';	
			}
			$return .= '</h2>';
			//End of title
		}
			
		if(isset($content['cats_link']) && rockthemes_is_true($content['use_cats'])){
			if(strpos($content['cats_link'], 'cat-link') > -1){
				$content['cats_link'] = str_replace('cat-link', 'escapea cat-link', $content['cats_link']);	
			}
			$return	.= '<span class="grid-hover-categories">'.$content['cats_link'].'</span>';
		}
							
		if(rockthemes_is_true($content['use_excerpt']) && !$only_hover){
			$return .= '<span class="grid-hover-excerpt" '.($use_schema ? 'itemprop="description"' : '').'>'.($only_hover && isset($new_elem['excerpt']) ? $new_elem['excerpt'] : azoom_get_the_excerpt('', false, intval($content['excerpt_length']))).'</span>';
		}
			
		
		if(rockthemes_is_true($content['use_title']) || rockthemes_is_true($content['use_cats']) || rockthemes_is_true($content['use_excerpt']) || $only_hover){
			//Small Hover Element
			$return .= '<span class="small-hover-elem" data-link_url="'.$link_url.'">'.$link_icon.'</span>';
			//End of hover-item-details-container
			$return .= '</div>';
		}
		if(rockthemes_is_true($full_link) && !is_single()){
			$return .= '</a>';	
		}
		
		if(rockthemes_is_true($hover_footer)){
			$return .= '
				<div class="azoom-hover-container azoom-transition '.($use_woo_details ? 'woo-grid-hover' : '').'">
			';
		}
		
		
		if($use_woo_details){
			$is_there_fee = $product->get_price_html();
			if($is_there_fee != ''){
				$return .= '<div class="azoom-woo-grid-hover" '.((isset($hover_bg_style) && $hover_bg_style != '') ? 'style="background:'.$hover_bg_color.'"' : '').' >';
					$return	.= '<div class="grid-price">'.$is_there_fee.'</div>';
				$return .= '</div>';
			}
		}

		
		if(rockthemes_is_true($hover_footer)){
			$return .= '
					<div class="azoom-hover-effect">
						<ul>
			';
		}
		
		if(isset($use_back_icon) && $use_back_icon === 'true'){
			$return .=	'
				<li class="rockthemes-hover-icon hide hover-mobile-back">
					<a>
						'.$back_icon.'
					</a>
				</li>
			';
		}
		
		
		if($use_woo_details){
			$add_to_cart = '';
			ob_start();
			rockthemes_woocommerce_add_to_cart();
			$add_to_cart = ob_get_contents();
			ob_get_clean();
			
			
			if($add_to_cart !== ''){
				$total = substr_count($add_to_cart, 'rockthemes-woo-shop-buttons');
				
				if($total == 2){
					$add_to_cart = str_replace('rockthemes-woo-shop-buttons', 'large-6 medium-6 small-6 columns rockthemes-woo-shop-buttons',$add_to_cart);
					//If item using different color change the border color
					if((isset($hover_bg_style) && $hover_bg_style != '')){
						$add_to_cart = str_replace('right-text centered-text-responsive">', 'right-text centered-text-responsive" style="border-color:'.$hover_bg_color.';">', $add_to_cart);
					}
				}elseif($total === 1){
					$add_to_cart = str_replace('rockthemes-woo-shop-buttons', 'large-12 medium-12 small-12 columns rockthemes-woo-shop-buttons',$add_to_cart);
				}
				
				$add_to_cart = str_replace('rockthemes-woo-buttons-container', 'rockthemes-woo-buttons-container row collapse', $add_to_cart);
				
				$return .= '<li  class="azoom-woo-grid-buttons">'.$add_to_cart.'</li>';
			}
		}
		
		
		if(rockthemes_is_true($lightbox['image']) && isset($full_image) && isset($full_image[0]) && !$use_woo_details){
			$return .= '
				<li class="rockthemes-hover-icon">			
					<a href="'.$full_image[0].'" data-rel="prettyPhoto[lightbox_gallery_'.esc_attr($GLOBALS['lightbox_gallery']).']">
						'.$image_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($lightbox['gallery']) && isset($rad['extra_featured_images']) && !$use_woo_details && 
			is_array($rad['extra_featured_images']) && 
			count($rad['extra_featured_images']) &&
			$rad['extra_featured_images'][0] != ''){
				
			$length = count($rad['extra_featured_images']);
			$i = 0;
			$loop_images_string = '<div class="hide">';
			foreach($rad['extra_featured_images'] as $extra_image){
				if($extra_image == '') continue;
				$g_id = '';
				$g_id = (isset($rad['extra_featured_image_ids']) && isset($rad['extra_featured_image_ids'][$i])) ? $rad['extra_featured_image_ids'] : '';
				if($g_id === ''){
					$g_id = rockthemes_get_image_id_from_url(esc_url($extra_image));
				}
				//$g_meta = wp_get_attachment_metadata($g_id);
				$g_url = wp_get_attachment_image_src( intval($g_id), 'full' );
				
				//If we couldn't find the attachment id or attachment is a Youtube/Vimeo video, we will use the main file (without resized)
				$g_url = (!empty($g_url) && isset($g_url[0])) ? $g_url[0] : $extra_image;

				$loop_images_string .= '
					<a href="'.esc_url($g_url).'" data-rel="prettyPhoto[rockthemes_portfolio_'.esc_attr($GLOBALS['rockthemes_portfolio']).esc_attr($postID).']"></a>
				';
				$i++;
	
			}
			$loop_images_string .= '</div>';

			$return .= '
				<li class="rockthemes-hover-icon">		
					'.$loop_images_string.'	
					<a href="'.esc_url($full_image[0]).'" data-rel="prettyPhoto[rockthemes_portfolio_'.esc_attr($GLOBALS['rockthemes_portfolio']).esc_attr($postID).']">
						'.$gallery_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($lightbox['video']) && isset($rad['video_iframe_code']) && $rad['video_iframe_code'] != '' && !$use_woo_details){
			$return .= '
				<li class="rockthemes-hover-icon">
					<a href="'.$rad['video_iframe_code'].'" data-rel="prettyPhoto">
						'.$video_icon.'
					</a>
				</li>
			';	
		}
		
		if(rockthemes_is_true($like) && !$use_woo_details){
			$return .= '
				<li class="rockthemes-hover-icon azoom-love-icon" data-post-id="'.$postID.'">			
					<a class="azoom-like">
						'.$like_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($use_link) && $link_url != '' && !$use_woo_details && !is_single()){
			$return .=	'
				<li class="rockthemes-hover-icon right link-elem">
					<a href="'.$link_url.'">
						'.$link_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($hover_footer)){
			$return .= '	
					</ul>
				</div>
			';
		}

		if(rockthemes_is_true($hover_footer)){
			$return .= '</div>
			';
		}
		
		return $return;
	}
endif;






if(!function_exists('rockthemes_jpeg_quaility')):
/*
**	Wordpress uses low quality for jpeg resizing. Increase this limit
**
*/
function rockthemes_jpeg_quaility( $quality ) {
    return 95;
}
endif;
add_filter( 'wp_editor_set_quality', 'rockthemes_jpeg_quaility' );




if(!function_exists('rockthemes_comment')):
/*
**	Rockthemes Alter Comments Template
**
**
*/
function rockthemes_comment($comment, $args, $depth) {
	global $post;
		$GLOBALS['rockthemes_comment'] = $comment;
		extract($args, EXTR_SKIP);

		if ( 'div' == $args['style'] ) {
			$tag = 'div';
			$add_below = 'comment';
		} else {
			$tag = 'li';
			$add_below = 'div-comment';
		}
?>
		<<?php echo rockthemes_escaped_out_render($tag) ?> <?php comment_class(empty( $args['has_children'] ) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">	
        
        <?php 
		if ($post) {
            if ($comment->user_id === $post->post_author){
				?>
                <div class="comment-author-badge">
					<span class="badge badge-top-left azoom-small-box-shadow"><?php esc_html_e('AUTHOR', 'azoom'); ?></span>
				</div>
                <?php
			}
        }
		?>
        
		<?php if ( 'div' != $args['style'] ) : ?>
		<div id="div-comment-<?php comment_ID() ?>" class="comment-body boxed-layout padding-2x azoom-small-box-shadow">
		<?php endif; ?>
            <div class="comment-author-image">
                <div class="comment-author">
                    <?php if ($args['avatar_size'] != 0) echo get_avatar( $comment, $args['avatar_size'] ); ?>
                </div>
            </div>
            
			<?php if ($comment->comment_approved == '0') : ?>
                <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.','azoom') ?></em>
                <br />
            <?php endif; ?>

            <div class="comment-meta commentmetadata">
				<div class="comment-header row">
                    <div class="comment-author-date-container large-9 medium-9 small-9 columns">
                        <div class="comment-author vcard">
                            <?php printf(__('<cite class="fn">%s</cite>','azoom'), get_comment_author_link()) ?>
                        </div>
                        <div class="comment-date">
                        <?php
                            /* translators: 1: date, 2: time */
                            printf( esc_html__('%1$s at %2$s','azoom'), get_comment_date(),  get_comment_time()) ?><?php edit_comment_link(esc_html__('(Edit)','azoom'),'  ','' );
                        ?>
                        </div>
                        <div class="comment-text">
							<?php comment_text() ?>
                        </div>
                    </div>
                    
                    <div class="comment-reply-container large-3 medium-4 small-3 columns">
                        <div class="reply">
                        <?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'])));	?>
                        </div>
                    </div>
                </div>
                
            </div>
		<?php if ( 'div' != $args['style'] ) : ?>
		</div>
		<?php endif; ?>
<?php
}
endif;






if(!function_exists('azoom_breadcrumb')):
function azoom_breadcrumb() {
	global $wp_query;
	

	if (xr_get_option('enable_yoast_breadcrumbs','') === true && function_exists( 'yoast_breadcrumb' ) ) {
		yoast_breadcrumb();
		return;
	}


	$delimiter = '<li> | </li>';
	$home = esc_html__('Home', 'azoom'); // text for the 'Home' link
	$before = '<li>'; // tag before the current crumb
	$after = '</li>'; // tag after the current crumb
	$product_parent_page_id = intval(xr_get_option('default_products_page', false));// product page id will be set in theme options
	if(function_exists('icl_link_to_element')){
		ob_start();
		icl_link_to_element($product_parent_page_id);
		$product_parent_page_id = ob_get_contents();
		ob_get_clean();
	}

	$posts_page_id = get_option( 'page_for_posts');
	$blog_page_html = '';
	if($posts_page_id && xr_get_option('blog_link_in_breadcrumbs', false) === true){
		$posts_page = get_page( $posts_page_id);
		$posts_page_title = $posts_page->post_title;
		$posts_page_url = get_page_link($posts_page_id  );
		$blog_page_html = $before.'<a href="'.$posts_page_url.'">'.$posts_page_title.'</a>'.$after.$delimiter;
	}
	

	if (!is_home() && !is_front_page() || is_paged()) {

		echo rockthemes_escaped_out_render('<ul itemprop="breadcrumb" class="azoom-breadcrumbs">');

		global $post;
		$homeLink = home_url();
		echo rockthemes_escaped_out_render('<li><a href="'.$homeLink.'">'.$home.'</a> '.$after.$delimiter.' ');

		if (is_category()) {
			global $wp_query;
			$cat_obj = $wp_query -> get_queried_object();
			$thisCat = $cat_obj -> term_id;
			$thisCat = get_category($thisCat);
			$parentCat = get_category($thisCat -> parent);
			
			echo rockthemes_escaped_out_render($blog_page_html);
			if ($thisCat -> parent != 0) echo rockthemes_escaped_out_render($before.(get_category_parents($parentCat, TRUE, ' '.$delimiter.' ')).$after);
			echo rockthemes_escaped_out_render($before.single_cat_title('', false).$after);
		}
		elseif(is_day()) {
			echo rockthemes_escaped_out_render($blog_page_html);
			echo rockthemes_escaped_out_render($before.'<a href="'.get_year_link(get_the_time('Y')).'">'.get_the_time('Y').'</a> '.$after.$delimiter.' ');
			echo rockthemes_escaped_out_render($before.'<a href="'.get_month_link(get_the_time('Y'), get_the_time('m')).'">'.get_the_time('F').'</a> '.$after.$delimiter.' ');
			echo rockthemes_escaped_out_render($before.get_the_time('d').$after);

		}
		elseif(is_month()) {
			echo rockthemes_escaped_out_render($blog_page_html);
			echo rockthemes_escaped_out_render($before.'<a href="'.get_year_link(get_the_time('Y')).'">'.get_the_time('Y').'</a> '.$after.$delimiter.' ');
			echo rockthemes_escaped_out_render($before.get_the_time('F').$after);

		}
		elseif(is_year()) {
			echo rockthemes_escaped_out_render($blog_page_html);
			echo rockthemes_escaped_out_render($before.get_the_time('Y').$after);

		}
		elseif(is_archive() && !is_tag()){
				
			if(get_post_type() === 'defaultitems'){
				
				if($product_parent_page_id !== ''){
					echo rockthemes_escaped_out_render($before.'<a href="'.get_page_link($product_parent_page_id).'">'.get_the_title($product_parent_page_id).'</a>'.$after.$delimiter);
				}
				
				$q_parents = array();	
				
				$parent = wp_get_post_terms($post->ID, 'defaultitem_cat');
				if($parent && !empty($parent)) $parent = $parent[0];
				echo rockthemes_escaped_out_render($before.$parent->name.$after);
				
				
			}else{
				$post_type = get_post_type_object(get_post_type());
				$slug = $post_type->rewrite;
				echo rockthemes_escaped_out_render($before . '<a href="' .get_permalink($post->post_parent) . '/">' . get_the_title($post->post_parent) . '</a> '.$after . $delimiter);
			}

		}
		elseif(is_single() && !is_attachment()) {
			if (get_post_type() != 'post') {
				
				if(get_post_type() === 'defaultitems'){

					if(isset($product_parent_page_id) && $product_parent_page_id !== '' && $product_parent_page_id){
						//Check if using WPML
						if(function_exists('icl_link_to_element')){
							echo rockthemes_escaped_out_render($before.$product_parent_page_id.$after.$delimiter);
						}else{
							echo rockthemes_escaped_out_render($before.'<a href="'.get_page_link($product_parent_page_id).'">'.get_the_title($product_parent_page_id).'</a>'.$after.$delimiter);
						}
					}
					
					
					$q_parents = array();	
					
					$parent = wp_get_post_terms($post->ID, 'defaultitem_cat');
					if($parent && !empty($parent)) $parent = $parent[0];

					if(!empty($parent)){
						echo rockthemes_escaped_out_render($before.'<a href="'.get_term_link($parent, 'defaultitems').'">'.$parent->name.'</a>'.$after.$delimiter);
					}

				}else{
					$post_type = get_post_type_object(get_post_type());
					$slug = $post_type->rewrite;
					echo rockthemes_escaped_out_render($before . '<a href="' .get_permalink($post->post_parent) . '/">' . get_the_title($post->post_parent) . '</a> '.$after . $delimiter);
				}
				echo rockthemes_escaped_out_render($before.get_the_title().$after);
			} else {
				$cat = get_the_category();
				$cat = $cat[0];
				echo rockthemes_escaped_out_render($blog_page_html);
				
				$cat_list = get_category_parents($cat, TRUE, ' '.$delimiter.' ');
				$cat_list_ar = explode(' '.$delimiter.' ', $cat_list);

				if(isset($cat_list_ar) && !empty($cat_list_ar)){
					foreach($cat_list_ar as $cat_obj){
						if(!empty($cat_obj)){
							echo rockthemes_escaped_out_render($before.$cat_obj.$after.' '.$delimiter.' ');
						}
					}
				}

				echo rockthemes_escaped_out_render($before.get_the_title().$after);
			}

		}
		elseif(!is_single() && !is_page() && get_post_type() != 'post' && !is_404() && !is_search()) {
			$post_type = get_post_type_object(get_post_type());
			if(isset($post_type) && isset($post_type->labels)){
				echo rockthemes_escaped_out_render($before.$post_type -> labels -> singular_name.$after);
			}else{
				//BB Press
			}

		}
		elseif(is_attachment()) {

		}
		elseif(is_page() && !$post -> post_parent) {
			echo rockthemes_escaped_out_render($before.get_the_title().$after);
		}
		elseif(is_page() && $post -> post_parent) {
			
			$parent_id = $post -> post_parent;
			$breadcrumbs = array();
			while ($parent_id) {
				$page = get_page($parent_id);
				$breadcrumbs[] = $before.'<a href="'.get_permalink($page -> ID).'">'.get_the_title($page -> ID).'</a>'.$after;
				$parent_id = $page -> post_parent;
			}
			$breadcrumbs = array_reverse($breadcrumbs);
			foreach($breadcrumbs as $crumb) echo rockthemes_escaped_out_render($crumb.' '.$delimiter.' ');
			echo rockthemes_escaped_out_render($before.get_the_title().$after);

		}
		elseif(is_search()) {
			echo rockthemes_escaped_out_render($before.esc_html__('Search Results For : ', 'azoom').get_search_query().$after);

		}
		elseif(is_tag()) {
			echo rockthemes_escaped_out_render($blog_page_html);
			echo rockthemes_escaped_out_render($before.single_tag_title('', false).$after);

		}
		elseif(is_author()) {
			global $author;
			$userdata = get_userdata($author);
			echo rockthemes_escaped_out_render($before.$userdata -> display_name.$after);

		}
		elseif(is_404()) {
			echo rockthemes_escaped_out_render($before.$after);
		}


		if (get_query_var('paged')) {
			echo rockthemes_escaped_out_render($before);
			if (is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author()) echo ' (';
			echo esc_html__('Page','azoom').' '.get_query_var('paged');
			if (is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author()) echo ')';
			echo rockthemes_escaped_out_render($after);
		}

		echo '</ul>';

	}
}
endif;

if(!function_exists('azoom_is_post_type')):
function azoom_is_post_type($type) {
	global $wp_query;
	if ($type == get_post_type($wp_query -> post -> ID)) return true;
	return false;
}
endif;


if(!function_exists('azoom_strict_sidebars')):
/*
**	Register the Strict Sidebars and Widget Areas. These will not be removed via Custom Sidebar options
**
*/
function azoom_strict_sidebars(){
	
	$total_fls = 0;//Total Footer Large Sidebars
	$large_footer_columns = intval(xr_get_option('large_footer_columns',3));
	if($large_footer_columns === 0){
		$large_footer_columns = 3;
	}
	$total_fls = (int)(12 / $large_footer_columns);
	
	for($i=0; $i<$total_fls; $i++){
		register_sidebar( array(  
			'name'			=>	'Footer Large '.($i+1),  
			'class'			=>	'',
			'id'			=>	'footer-large-'.($i+1),  
			'description'	=>	'Footer Large '.($i+1).' Content',
			'before_widget' =>	'<aside id="%1$s" class="widget %2$s">',
			'after_widget'	=>	'</aside>',
			'before_title'	=>	'<h3 class="widget-title">',  
			'after_title'	=>	'</h3><hr/>',  
		) );  
	}

	//Footer Bottom Widget Area
	register_sidebar( array(  
		'name'			=>	'Footer Bottom',  
		'class'			=>	'',
		'id'			=>	'footer-bottom',  
		'description'	=>	'Footer Bottom Content',
		'before_widget' =>	'<aside class="footer-bottom-widget">',
		'after_widget'	=>	'</aside>',
		'before_title'	=>	'<div class="azoom-heading-icon"></div><h3 class="widget-title">',  
		'after_title'	=>	'</h3>',  
	) );  
	
	if(xr_get_option('enable_header_topr_widget',false)){
		//Header Top Right Sidebar
		register_sidebar( array(  
			'name'			=>	'Header Top Right',  
			'class'			=>	'',
			'id'			=>	'header-top-right',  
			'description'	=>	'Header Top right content',
			'before_widget'	=>	'',
			'after_widget'	=>	'',
			'before_title'	=>	'<h3 class="widget-title">',  
			'after_title'	=>	'</h3>',  
		) );  
	}
}
endif;
// Add strict widget areas
add_action( 'widgets_init', 'azoom_strict_sidebars' );
//Add shortcode to widget text
add_filter( 'widget_text', 'do_shortcode');








if(!function_exists('rockthemes_schema_body')):
/*
**	Structured Data Schemas
**
**	@echo	:	Schema Details
**	@since	:	1.0
*/
function rockthemes_schema_body(){
	$return = ' itemscope="itemscope" itemtype="http://schema.org/WebPage"';
	echo rockthemes_escaped_out_render($return);
}
endif;



if(!function_exists('rockthemes_get_product_schema')):
/*
**	Product Schema
**	http://schema.org/Product
**
**	@return	:	Schema details
**	@since	:	1.0
*/
function rockthemes_get_product_schema(){
	$return = ' itemscope="itemscrope" itemtype="http://schema.org/CreativeWork"';
}
endif;


if(!function_exists('rockthemes_header_models_menu_text_align')):
/*
**	Used in "header-models.php" file at the line 28
**
*/
function rockthemes_header_models_menu_text_align($current_model = 1){
	$return = '';
	if(is_rtl()){
		
	}else{
		switch(intval($current_model)){
			case 1:
			$return = ' right-text ';
			break;
			
			case 2:
			$return = ' left-text ';
			break;
			
			case 3:
			$return = ' centered-text ';
			break;	
		}
	}
	
	return $return;
}
endif;







if(!function_exists('azoom_get_nav_menu')){
/*
**	Check the menu chosen in the Theme Options and add or remove Menu Walker
**	Menu walker is "rock_menu_walker" class below
**
*/
	function azoom_get_nav_menu($echo = true){
		if(!has_nav_menu('primary')) return;
		
		if(!is_bool($echo)) $echo = false;

		if(function_exists('rockthemes_mega_menu') && !xr_get_option('disable_mega_menu', false)):
			return rockthemes_mega_menu(array('echo'=>$echo));
		endif;
		
		
		if($echo):
			wp_nav_menu( array( 'echo' => $echo, 'theme_location' => 'primary', 'menu_class' => 'nav-menu', 'container_id'=>'nav', 'fallback_cb' => 'wp_page_menu' ) );
		else:
			return wp_nav_menu( array( 'echo' => $echo, 'theme_location' => 'primary', 'menu_class' => 'nav-menu', 'container_id'=>'nav', 'fallback_cb' => 'wp_page_menu' ) );
		endif;
		
		return;
	}
}



?>