<?php
/**
 * The template for displaying posts in the Video post format.
 *
 * @package WordPress
 * @subpackage Azoom
 * @since Azoom 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php echo azoom_get_boxed_date(); ?>    
    
    <div class="article-details <?php echo azoom_article_details_class(); ?>">

        <header class="entry-header">
			<?php 
                $video_url = esc_url(rad_get_option('video_iframe_code', $post));
				                        
                if($video_url && $video_url !== ''){
                    if(strpos($video_url, 'vimeo') > -1){
                        echo rockthemes_shortcode_make_vimeo_video(
                            array(
                                'resize_height'	=>	'true',
                                'autoplay'		=>	'false',
                                'api'			=>	'false'
                            ),
							$video_url
                        );
        
                    }elseif(strpos($video_url, 'you') > -1){
                        echo rockthemes_shortcode_make_youtube_video(
                            array(
                                'resize_height'	=>	'true',
                                'autoplay'		=>	'false',
                                'mute'			=>	'false'
                            ),
							$video_url
                        );
                    }else{

						$return = '
							<div class="azoom-iframe-container html5-video">
								<video controls>
								  <source src="'.$video_url.'" type="video/mp4">
								</video>
							</div>
						';
						echo rockthemes_escaped_out_render($return);
                    }
                }
            ?>
            <?php echo azoom_get_title_with_date(); ?>
        </header><!-- .entry-header -->
    
        <?php if ( is_search() || (!is_single() && xr_get_option('post_summary') === 'excerpt')) : // Only display Excerpts for Search ?>
        <div class="entry-summary">
            <?php echo azoom_get_post_loop_description(); ?>
        </div><!-- .entry-summary -->
        <?php else : ?>
        <div class="entry-content">
            <?php echo azoom_get_the_content(); ?>
            <?php azoom_get_link_pages(); ?>
        </div><!-- .entry-content -->
        <?php endif; ?>
		<div class="clear"></div>
    
        <footer class="entry-meta">
            <div class="entry-footer-details">
            	<?php azoom_entry_footer_meta(); ?>
            </div>            
            <?php do_action('rockthemes_single_post_footer'); ?>
        </footer><!-- .entry-meta -->
        <?php do_action('rockthemes_single_post_after_footer'); ?>
        
		<?php if ( is_single() && get_the_author_meta( 'description' )) : ?>
			<?php get_template_part( 'author-bio' ); ?>
		<?php endif; ?>
	</div><!--article-details-->
</article><!-- #post -->
