<?php
/**
 * The template for displaying posts in the Image post format.
 *
 * @package WordPress
 * @subpackage Azoom
 * @since Azoom 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
   
    <?php echo azoom_get_boxed_date(); ?>
    
    <div class="article-details <?php echo azoom_article_details_class(); ?>">
        <header class="entry-header">
            <?php echo azoom_get_entry_header(); ?>
        </header><!-- .entry-header -->
    
    
        <?php if ( is_search() || (!is_single() && xr_get_option('post_summary') === 'excerpt')) : // Only display Excerpts for Search ?>
        <div class="entry-summary">
            <?php echo azoom_get_post_loop_description(); ?>
        </div><!-- .entry-summary -->
        <?php else : ?>
        <div class="entry-content">
            <?php echo azoom_get_the_content(); ?>
            <?php azoom_get_link_pages(); ?>
        </div><!-- .entry-content -->
        <?php endif; ?>
		<div class="clear"></div>
    
        <footer class="entry-meta">
            <div class="entry-footer-details">
            	<?php azoom_entry_footer_meta(); ?>
            </div>            
            <?php do_action('rockthemes_single_post_footer'); ?>
        </footer><!-- .entry-meta -->
        <?php do_action('rockthemes_single_post_after_footer'); ?>
        
		<?php if ( is_single() && get_the_author_meta( 'description' )) : ?>
			<?php get_template_part( 'author-bio' ); ?>
		<?php endif; ?>
	</div><!--.article-details-->
</article><!-- #post -->
