<?php
/**
 * The template for displaying Author bios.
 *
 * @package WordPress
 * @subpackage Azoom
 * @since Azoom 1.0
 */
?>

<div class="author-info azoom-small-box-shadow azoom-transition">
	<div class="author-avatar">
		<?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'azoom_author_bio_avatar_size', 80 ) ); ?>
	</div><!-- .author-avatar -->
	<div class="author-description">
		<h2 class="author-title"><?php printf( esc_html__( 'About %s', 'azoom' ), get_the_author() ); ?></h2>
		<p class="author-bio">
			<?php the_author_meta( 'description' ); ?>
			<a class="author-link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
				<?php printf( esc_html__( 'View all posts by %s <span class="meta-nav">&rarr;</span>', 'azoom' ), get_the_author() ); ?>
			</a>
		</p>
	</div><!-- .author-description -->
</div><!-- .author-info -->