<?php
/**
 * The template for displaying 404 not found page.
 *
 * @package WordPress
 * @subpackage Azoom
 * @since Azoom 1.0
 */
 
 /*
Template Name:	404

*/


get_header(); ?>
<div class="vertical-space-x3"></div>
	<div id="primary" class="content-area large-12 column">
		<div id="content" class="site-content error-404" role="main">
			<div class="row">
            
                <div class="large-9 columns large-centered">
                	<div class="large-10 large-centered columns">
                        <i class="icomoon icomoon-icon-airplane68 error-404-icon"></i>
                        <div class="error-404-details">
                            <h1 class="error-404-header"><?php esc_html_e('404 : PAGE NOT FOUND', 'azoom'); ?></h1>
                            <p class="error-404-description"><?php esc_html_e('Sorry, we couldn\'t find that page.','azoom'); ?></p>
                        </div>
                        <div class="clear"></div>
                    </div>
                    
                    <div class="vertical-space"></div>
                    
                    <p><strong><?php esc_html_e('The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.','azoom'); ?><br/><?php esc_html_e('Please try the following:','azoom'); ?></strong></p>
                    <ul>
                        <li><?php esc_html_e('Make sure that the Web site address displayed in the address bar of your browser is spelled and formatted correctly','azoom'); ?></li>
                        <li><?php esc_html_e('If you reached this page by clicking a link, contact us to alert us that the link is incorrectly formatted','azoom'); ?></li>
                        <li><?php esc_html_e('Forget that this ever happened, and go to our ','azoom'); ?><a href="<?php echo home_url(); ?>"><?php esc_html_e('home page','azoom'); ?></a></li>
                    </ul>
                    <div class="vertical-space-x3"></div>
                </div>
                
            </div>
		</div><!-- #content -->
	</div><!-- #primary -->

</div>
<?php get_footer(); ?>