jQuery(document).ready(function(){
	"use strict";
	
		jQuery(document).on("click", ".add-new-element", function(){
			var chosenElement = jQuery(".select-element").find(":selected").val();
			
			var uniqueID = jQuery.fn.rockthemes_fb_make_uniqueID(chosenElement);
			
			var ajax_prefix = "rockthemes_fb_ajax_";
			
			var element_data = new Object();
			element_data.id		=	uniqueID;
			element_data.type	=	chosenElement;

			jQuery.post(ajaxurl, {data:element_data, action:ajax_prefix+"make_admin_element"}, function(data){
				
				if(jQuery(".form-elements-container").length){
					jQuery(".form-elements-container").last().append(data.element);
				}else{
					jQuery(".form-preview")
					.append("<div class=\"row-fluid\">"+
								"<div class=\"span12 rockthemes_fb_grid\" col-ref=\"12\">"+
									"<ul class=\"form-elements-container ui-sortable\">"+
									"</ul>"+
								"</div>"+
							"<div>");
							
					jQuery(".form-elements-container").append(data.element);
				}
				
				jQuery(".rockthemes_fb_modal_container").append(data.modal);
				
				//Activate default value show/hide effect for text fields and textareas
				if(chosenElement == "text_field" || chosenElement == "text_area"){
					jQuery.fn.rockthemes_fb_activate_input_effects();
				}
				
				//activate sortable list
				jQuery.fn.rockthemes_fb_admin_sortable_elements();
			});
		});
		
		jQuery(document).on("click", "i.close", function(){
			var modalID = jQuery(this).parent().attr("id")+"-modal";
			jQuery("#"+modalID).remove();
			jQuery(this).parent().remove();
		});
		
		jQuery(document).on("click", ".rockthemes_fb_element .type-text-logo", function(){
			var modalID = jQuery(this).parent().attr("id")+"-modal";
			jQuery("#"+modalID).modal();
		});


		jQuery(document).on("click", ".builder-close", function(){
			jQuery(this).parent().parent().modal("hide");
		});

		jQuery(document).on("click",".add-new-grid", function(){
			var columns = jQuery(".select-grid").find(":selected").val();
			
			var ajax_prefix = "rockthemes_fb_ajax_";
			
			var grid_data = new Object();
			grid_data.columns = columns;

			jQuery.post(ajaxurl, {data:grid_data, action:ajax_prefix+"make_grid"}, function(data){
				jQuery(".form-preview").append(data);
				
				//activate sortable list
				jQuery.fn.rockthemes_fb_admin_sortable_elements();
			});
		});
		
		jQuery(document).on("click", ".row-remove-button", function(){
			jQuery(this).parent().find(".rockthemes_fb_grid").each(function(index){
				jQuery(this).find(".rockthemes_fb_element").each(function(index){
					var modalID = jQuery(this).attr("id")+"-modal";
					jQuery("#"+modalID).remove();
					jQuery(this).remove();
				});
			});
			
			jQuery(this).parent().remove();
		});

		//Comments input values
		jQuery.fn.rockthemes_fb_activate_input_effects = function(){
			jQuery(document).find(".rockthemes-fb-element.input-element").each(
				function(){
					jQuery(this).live("focus", function() {
						if ( jQuery(this).val() == jQuery(this).attr("title") ) jQuery(this).val("");
						jQuery(this).addClass("box-shadow-dark");
					});
					jQuery(this).live("blur", function() {
						if ( jQuery(this).val() == "" ) jQuery(this).val(jQuery(this).attr("title"));
						jQuery(this).removeClass("box-shadow-dark");
					});
				}
			);
		}

		jQuery(document).on("click", ".select-element-add-new-option", function(){
			var modalID = jQuery(this).attr("modal-ref");
			var new_option = "<li class=\"row-fluid\">"+
								"<div class=\"span1 drag-holder\">"+
									"<i class=\"fa fa-move\"></i>"+
								"</div>"+
								"<div class=\"span10\">"+
									"<input type=\"text\" class=\"define_select_new_element\" value=\"Select Option Value..\" />"+
								"</div>"+
								"<div class=\"span1 remove-holder\">"+
									"<i class=\"fa fa-times\"></i>"+
								"</div>"+
							"</li>";
		
			jQuery("#"+modalID+" .select_elements").append(new_option);	
		});
		
		jQuery(document).on("click", ".select_elements .fa-times", function(){
			jQuery(this).parent().parent().remove();
		});
		
		jQuery(document).on("change",".define_select", function(){
			var selected = jQuery(this).find(":selected").val();
			if(selected === "new-define"){
				jQuery(this).parent().parent().parent().find(".define_select_new").slideDown();
			}else{
				jQuery(this).parent().parent().parent().find(".define_select_new").slideUp();
			}
		});

		jQuery(document).on("click", ".radio-element-add-new-option", function(){
			var modalID = jQuery(this).attr("modal-ref");
			var new_option = "<li class=\"row-fluid\">"+
								"<div class=\"span1 drag-holder\">"+
									"<i class=\"fa fa-move\"></i>"+
								"</div>"+
								"<div class=\"span10\">"+
									"<input type=\"text\" class=\"define_radio_new_element\" value=\"Radio Option Value..\" />"+
								"</div>"+
								"<div class=\"span1 remove-holder\">"+
									"<i class=\"fa fa-times\"></i>"+
								"</div>"+
							"</li>";
		
			jQuery("#"+modalID+" .radio_elements").append(new_option);	
		});
		
		jQuery(document).on("click", ".radio_elements .fa-times", function(){
			jQuery(this).parent().parent().remove();
		});

		jQuery.fn.rockthemes_fb_make_uniqueID = function(element){
			var prefix = "rfb_";
			if(jQuery("."+prefix+element+"-0").length < 0){
				return prefix+element+0;	
			}else{
				var newID = prefix+element+"-";
				var currentNum = 0;
				while(jQuery("#"+newID+currentNum).length){
					currentNum++;
				}
				

				return newID+currentNum;
			}
		}
		
		jQuery.fn.rockthemes_fb_admin_sortable_elements = function(){
			jQuery( ".form-elements-container" ).sortable({
				handle : "i.drag",
				connectWith : ".form-elements-container",
				helper : function(){
					return "<div class=\"sortable-drag-helper\"><i class=\"fa fa-magnet\"></i></div>";
				}
			}).disableSelection();
			
			jQuery( ".form-preview" ).sortable({
				handle : ".row-drag-button"
			}).disableSelection();
			
			jQuery(".select_elements").sortable({
				handle : ".fa-move"
			});//.disableSelection();
			
			jQuery(".radio_elements").sortable({
				handle : ".fa-move"
			});//.disableSelection();
		}
		
		function get_tinymce_content(id){
				var text;
				text = tinymce.activeEditor.getContent();

				return text;
		}
		
		
		
		

		
		jQuery(document).on("click", ".rock-tinymce-switch-html", function(){
			
			var text;
			if (jQuery(this).parent().parent().hasClass("tmce-active")){
				text = tinyMCE.activeEditor.getContent();
			}else{
				text = jQuery(this).parent().parent().find(".rock-tinymce-textarea").val();
			}
			
			
			if(jQuery(this).parent().parent().hasClass("tmce-active"))
				jQuery(this).parent().parent().removeClass("tmce-active");
				
			jQuery(this).parent().parent().addClass("html-active");
			
			var tiny = jQuery(this).parent().parent().find(".rock-tinymce-textarea");
						
			window.tinyMCE.execCommand("mceRemoveControl", true, tiny.attr("id"));
			
			jQuery(this).parent().parent().find(".rock-tinymce-textarea").val(text);
		});
		
		jQuery(document).on("click", ".rock-tinymce-switch-text", function(){
			if(jQuery(this).parent().parent().hasClass("html-active"))
				jQuery(this).parent().parent().removeClass("html-active");
				
			jQuery(this).parent().parent().addClass("tmce-active");
			
			var tiny = jQuery(this).parent().parent().find(".rock-tinymce-textarea");
			
			window.tinyMCE.execCommand("mceAddControl", true, tiny.attr("id"));
		});		

		jQuery(document).on("click", ".rockthemes_fb_save_form", function(){
			rockthemes_fb_save_form();
		});
		
		function rockthemes_fb_save_form(){
			//Add loading animation
			jQuery(".rockthemes-fb-save-icon").addClass("fa fa-refresh fa-spin");
			
			//Activate TinyMCE if it's in text mode.
			if(jQuery(".wp-core-ui.wp-editor-wrap.html-active").length){
				jQuery("#rockthemes_fb_tinymce_content-tmce").trigger("click");
			}
			
			var data = new Object();
			
			data.id								=	jQuery(".rockthemes-fb-main-container").attr("form-id");
			data.form_name						=	jQuery(".form_name_holder").val();
			data.main_email_address				=	jQuery(".main_email_address").val();
			data.button_class_holder			=	jQuery(".button_class_holder").val();
			data.email_title					=	jQuery(".email_title").val();
			data.recaptcha_public_key			=	jQuery(".recaptcha_public_key").val();
			data.recaptcha_private_key			=	jQuery(".recaptcha_private_key").val();
			data.captcha_activated				=	jQuery(".captcha_activated").find(":selected").val();
			data.activate_auto_reply			=	jQuery(".activate_auto_reply").find(":selected").val();
			data.rockthemes_fb_tinymce_content	=	get_tinymce_content("rockthemes_fb_tinymce_content");
			data.required_error_message			=	jQuery(".required_error_message").val();
			data.email_invalid_message			=	jQuery(".email_invalid_message").val();
			data.captcha_invalid_message		=	jQuery(".captcha_invalid_message").val();
			data.send_button_text				=	jQuery(".send_button_text").val();
			data.email_sent_message				=	jQuery(".email_sent_message").val();
			data.email_sending_error_message	=	jQuery(".email_sending_error_message").val();
			data.after_sent_select				=	jQuery(".after_sent_select").find(":selected").val();
			data.after_sent_url					=	jQuery(".after_sent_url").val();
			data.after_sent_download_url		=	jQuery(".after_sent_download_url").val();
			data.grids							=	new Array();
			data.required						=	new Array();
			data.email							=	new Array();
			
			jQuery(".form-preview > .row-fluid").each(function(index){
				
				var columns = new Array();
				
				jQuery(this).find(".rockthemes_fb_grid").each(function(index){
									
					var elements = new Array();
					
					jQuery(this).find(".form-elements-container .rockthemes_fb_element").each(function(index){
						
						var modalID	= jQuery(this).attr("id")+"-modal";
						var modal 	= jQuery("#"+modalID);
						
						var element 	= 	new Object();
						element.type 	= 	jQuery(this).attr("element-type");
						element.id		=	jQuery(this).attr("id");
						
						switch(jQuery(this).attr("element-type")){
							case "text_field":
							element.element_title	=	modal.find(".element-title").val();
							element.is_required		=	modal.find(".is_required").find(":selected").val();
							element.is_mail			=	modal.find(".is_mail").find(":selected").val();
							break;
							
							case "text_area":
							element.element_title	=	modal.find(".element-title").val();
							element.is_required		=	modal.find(".is_required").find(":selected").val();
							element.is_mail			=	modal.find(".is_mail").find(":selected").val();
							break;
							
							case "checkbox":
							element.element_title	=	modal.find(".element-title").val();
							element.is_required		=	modal.find(".is_required").find(":selected").val();
							break;	
							
							case "select":
							element.element_title	=	modal.find(".element-title").val();
							element.is_required		=	modal.find(".is_required").find(":selected").val();
							element.define_select	=	modal.find(".define_select").find(":selected").val();
							element.select_elements	=	[];
							
								modal.find(".define_select_new_element").each(function(index){
									element.select_elements.push(jQuery(this).val());
								});

							break;
							
							case "radio_button":
							element.element_title	=	modal.find(".element-title").val();
							element.is_required		=	modal.find(".is_required").find(":selected").val();
							element.is_horizontal	=	modal.find(".is_horizontal").find(":selected").val();
							element.radio_elements	=	[];
							
								modal.find(".define_radio_new_element").each(function(index){
									element.radio_elements.push(jQuery(this).val());
								});

							break;
							
							case "datepicker":
							element.element_title	=	modal.find(".element-title").val();
							element.is_required		=	modal.find(".is_required").find(":selected").val();
							break;
							
							case "file_uploader":
							element.element_title	=	modal.find(".element-title").val();
							element.is_required		=	modal.find(".is_required").find(":selected").val();
							break;
							
							case "field_header_text":
							element.element_title	=	modal.find(".element-title").val();
							break;
							
						}
						if(element.is_required === "true"){
							data.required.push(element.id);	
						}
						
						if(element.is_mail === "email-area"){
							data.email.push(element.id);	
						}
						
						elements.push(element);
						
					});
					
					if(!elements.length){
						elements = "Empty Columns";
					}
					
					columns.push(elements);
				
				});
				
				data.grids.push({columns:columns, columns_class:jQuery(this).find(".rockthemes_fb_grid").first().attr("col-ref")});
				
			});
			
			
			var db_info = new Object();
			db_info.db_name	= jQuery(".rockthemes-fb-main-container").attr("form-db-name");
			db_info.form_id	= jQuery(".rockthemes-fb-main-container").attr("form-id");
						
			jQuery.post(ajaxurl, {data:data, db_info:db_info, action:"rockthemes_fb_save"}, function(data){
				jQuery(".rockthemes-fb-save-icon").removeClass("fa fa-refresh fa-spin");
			});
			
		}
});