<?php


/*
**	Azoom Child Theme Functions File
**
**	HOW TO USE THIS FILE
**
**	!Important	:	Do not change anything in CORE AREA
**
**	1.	Modifications
**		
**		To modify anything in this file, simply copy an overridable function and paste it to this file.
**		Then edit the file as you like. You can paste overridable functions in OVERRIDABLE AREA
**
**		Note : Make sure the function is overribable. If a function wrapped with
**			function_exists
**		then that function is overriable 
**			eg : if(function_exists('some_funciton')):
**
**	
**	2.	Language Files
**
**		We strongly recommend using child theme. If you don't use a child theme, language files
**		will be removed on auto update. To avoid this issue, simply use child theme and
**		edit the language files in the child theme. You can find the language files
**		in the /languages/ directory
**
**
**	@version	:	1.0
**	@author		:	XanderRock
**
*/




/*
**	OVERRIDABLE AREA
**
**	You can add your function here
*/

















/*
**	END OF OVERRIDABLE AREA
**
**	Do not add anything below this area.
*/



/*Language File*/
if(!function_exists('azoom_after_setup')):
function azoom_child_after_setup() {
    load_child_theme_textdomain( 'azoom', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'azoom_child_after_setup' );
endif;




function azoom_child_enqueue() {
	
	// enqueue parent styles
	wp_enqueue_style('azoom-main', get_template_directory_uri() .'/style.css');
	
}
add_action('wp_enqueue_scripts', 'azoom_child_enqueue');






/*
**	CORE AREA
**
**	Load the Core System. Do NOT make any changes in the core file.
**	Do not edit the details below.
**	
*/
include_once(get_template_directory().'/functions-core.php');





?>