<?php
/**
 * Adds Rockthemes_Tabs_Widget.
 */
class Rockthemes_Tabs_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		parent::__construct(
	 		'rockthemes_tabs_widget', // Base ID
			'Rockthemes Tabs Widget', // Name
			array( 'description' => esc_html__( 'Rockthemes Tabs Widget', 'azoom' ), ) // Args
		);
	}

	
	public function tabs_select($id = '', $selected = ''){
		$selects = array(
			'None'					=>	'',
			'Latest Posts'			=>	'latest_posts',
			'Like Posts'			=>	'loved_posts',
			'Popular Posts'			=>	'popular_posts',
			'(Woo) Latest Products'		=>	'products_latest',
			'(Woo) Product Price'		=>	'products_price',
			'(Woo) Top Seller Products'	=>	'products_sale',
		);
		
		$return = '<select class="widefat" id="'.esc_attr($this->get_field_id($id)).'" name="'.esc_attr($this->get_field_name($id)).'">';
		
		foreach($selects as $key => $val){
			$return .= '<option value="'.esc_attr($val).'" '.($val === $selected ? 'selected="selected"' : '').'>'.esc_attr($key).'</option>';
		}
		
		$return .= '</select>';
		
		return $return;
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['select_0'] = strip_tags( $new_instance['select_0'] );
		$instance['select_1'] = strip_tags( $new_instance['select_1'] );
		$instance['select_2'] = strip_tags( $new_instance['select_2'] );
		$instance['select_3'] = strip_tags( $new_instance['select_3'] );
		$instance['total'] = strip_tags( (int)$new_instance['total']) ;
				
		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		
		$dv = array(
			'select_0'	=>	'select_0',
			'select_1'	=>	'select_1',
			'select_2'	=>	'select_2',
			'select_3'	=>	'select_3',
			'total'		=>	3,
		);
		

		
		if(!isset($instance) || empty($instance) || !$instance){
			$instance = array();	
		}
		$instance = array_merge($dv, $instance);
		
				
		?>
        <p>
        <strong>First Tab : </strong><br/>
        <?php echo $this->tabs_select('select_0', $instance['select_0']); ?>
        </p>
        <p>
        <strong>Second Tab : </strong><br/>
        <?php echo $this->tabs_select('select_1', $instance['select_1']); ?>
        </p>
        <p>
        <strong>Third Tab : </strong><br/>
        <?php echo $this->tabs_select('select_2', $instance['select_2']); ?>
        </p>
        <p>
        <strong>Fourth Tab : </strong><br/>
        <?php echo $this->tabs_select('select_3', $instance['select_3']); ?>
        </p>
        <p>
        <strong>Total Posts : </strong><br/>
        <select autocomplete="off" id="<?php echo $this->get_field_id('total'); ?>" name="<?php echo $this->get_field_name('total'); ?>">
        <?php 
		$num_selected = (int)($instance['total'] ? $instance['total'] : 3);
		for($i = 1; $i < 11; $i++){
			echo '<option value="'.$i.'" '.($i === $num_selected ? 'selected="selected"' : '').'>'.$i.'</option>';	
		}
		?>
        </select>
        </p>
		<?php 
	}
	
	
	
	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		extract( $args );

		echo $before_widget;
		if ( ! empty( $title ) ){
			echo $before_title . $title . $after_title;
		}
				
		
		$tabs = array();
		for($s = 0; $s < 4; $s++){
			if(isset($instance['select_'.$s]) && $instance['select_'.$s] && $instance['select_'.$s] !== ''){
				$tabs[] = $instance['select_'.$s];
			}
		}

		$shortcode = '[rockthemes_tabs tab_type="tab-top" tab_use_hash="no" use_shadow="false" boxed_layout="false" open_tab_index="0"]';
		
		foreach($tabs as $tab){
			
			$obj = array(
				'post_type'			=>	'post',
				'post_tax'			=>	'',
				'category'			=>	'all',
				'total'				=>	intval($instance['total']),
				'orderby'			=>	'',
				'meta'				=>	'',
			);
			
			$tab_title = '';
			switch($tab){
				case 'latest_posts' :
				$tab_title = esc_html__('Latest','azoom');
				break;
				
				case 'loved_posts' :
				$tab_title = esc_html__('Like','azoom');
				$obj['meta'] = '_entry_love_num';
				break;
				
				case 'popular_posts' :
				$tab_title = esc_html__('Popular','azoom');
				$obj['orderby'] = 'comment_count';
				break;
				
				
				case 'products_latest' :
				$tab_title = esc_html__('Products','azoom');
				$obj['post_type'] = 'product';
				break;
				
				
				case 'products_price' :
				$tab_title = esc_html__('Price','azoom');
				$obj['post_type'] = 'product';
				$obj['meta'] = '_price';
				break;
				
				case 'products_sale':
				$tab_title = esc_html__('Sale', 'azoom');
				$obj['post_type'] = 'product';
				$obj['meta'] = 'total_sales';
				break;
				
				case 'latest_comments':
				$tab_title = esc_html__('Comments', 'azoom');
				break;
			}
			
			
			//Loop Starts Here
			$shortcode .= '[rockthemes_tabs_single title="'.esc_attr($tab_title).'" tab_hash="false" icon_class="" icon_url=""]';
			$shortcode .= $this->get_posts_html($obj);
			$shortcode .= '[/rockthemes_tabs_single]';
			//Loop Ends Here
		}
		
		$shortcode .= '[/rockthemes_tabs]';

		echo do_shortcode($shortcode);

		echo $after_widget;
		
		wp_reset_query();
		wp_reset_postdata();
	}
	
	/*
	**	Frontend function to get posts
	*/
	public function get_posts_html($obj){
		extract($obj);
		
		$tax_list = get_object_taxonomies($post_type);

		$posts = array();

		if($post_type === 'post' && $orderby !== ''){
			$posts = query_posts(array('category_name'=> $category, 'posts_per_page'=>$total, 'orderby' => $orderby));
		}elseif($post_type === 'post' && $meta !== ''){
			$posts = query_posts(array('category_name'=> $category, 'posts_per_page'=>$total, 'orderby' => 'meta_value_num', 'meta_key' => $meta));
		}elseif($post_type === 'post'){
			$posts = query_posts(array('category_name'=> $category, 'posts_per_page'=>$total));
		}
	
		if(!count($posts)){
			$args = array(
				'post_type'			=>	$post_type,
				$post_tax			=>	$category,
				'posts_per_page'	=>	$total,
			);
			
						
			if($meta !== ''){
				$args['meta_key'] = $meta;	
				$args['orderby'] = 'meta_value_num';
				//$args['order'] = 'ASC';
			}
					
			$posts = query_posts($args);
			$post_is_tax = true;
			
		}
		
		$return = '';
		
		if(sizeof($posts)>0){				
			foreach($posts as $post_object){
				setup_postdata($post_object);
								
				$title = '<strong>'.esc_html($post_object->post_title).'</strong>';

				$image = wp_get_attachment_image(get_post_thumbnail_id($post_object->ID), 'rockthemes_small_image');
				if($image !== ''){
					$image = '<div style="width: 60px; height: 60px; float: left; margin: 0 10px 0px 0;">'.$image.'</div>';	
				}
				$date = get_post_time('F j, Y', false, $post_object->ID, true);
				$elem = '<a href="'.get_permalink($post_object->ID).'">'.$image.'<p>'.$title.'<br/>'.$date.'</p></a><div class="clear"></div><hr/>';
				
				$return .= $elem;
				
			}
							
		}
				
		
		return $return;
			
	}
	
	
	function rockthemes_tabs_get_the_excerpt($post_in = '', $echo = false, $length = 10){
		global $post;
		$excerpt = '';
		if(!empty($post_in)) $post = $post_in;
	
		$excerpt = get_the_excerpt();
		if(empty($excerpt)){
			$excerpt = $post->post_excerpt;
		}
	
		
		if(!empty($excerpt)){
			$excerpt = explode(' ',$excerpt);
			if(count($excerpt) > $length){
				$excerpt = array_slice($excerpt, 0, $length);
			}
			$excerpt = implode(' ',$excerpt);
			
			if($echo){
				echo $excerpt;	
			}else{
				return $excerpt;
			}
		}
		return '';
	}
	

} // class 


if(!function_exists('rockthemes_widget_register_tabs')):
function rockthemes_widget_register_tabs(){
	register_widget( "rockthemes_tabs_widget" );
}
endif;
add_action( 'widgets_init', 'rockthemes_widget_register_tabs');


?>