<?php
/**
 * Adds Rockthemes_Payment_Icons.
 */
class Rockthemes_Payment_Icons extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		parent::__construct(
	 		'rockthemes_payment_icons', // Base ID
			'Rockthemes Payment Icons', // Name
			array( 'description' => esc_html__( 'Rockthemes Payment Icons', 'azoom' ), ) // Args
		);
	}

	
	public function tabs_select($id = '', $selected = ''){
		$selects = array(
			'None'			=>	'',
			'Paypal'		=>	'icomoon-icon-fa-paypal',
			'Paypal Card'	=>	'icomoon-icon-fa-cc-paypal',
			'Visa'			=>	'icomoon-icon-fa-cc-visa',
			'Master Card'	=>	'icomoon-icon-fa-cc-mastercard',
			'Discover'		=>	'icomoon-icon-fa-cc-discover',
			'Amex'			=>	'icomoon-icon-fa-cc-amex',			
			'Stripe'		=>	'icomoon-icon-fa-cc-stripe',
			'Google Wallet'	=>	'icomoon-icon-fa-google-wallet',
		);
		
		$return = '<select class="widefat" id="'.esc_attr($this->get_field_id($id)).'" name="'.esc_attr($this->get_field_name($id)).'">';
		
		foreach($selects as $key => $val){
			$return .= '<option value="'.esc_attr($val).'" '.($val === $selected ? 'selected="selected"' : '').'>'.esc_html($key).'</option>';
		}
		
		$return .= '</select>';
		
		return $return;
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['select_0'] = strip_tags( $new_instance['select_0'] );
		$instance['select_1'] = strip_tags( $new_instance['select_1'] );
		$instance['select_2'] = strip_tags( $new_instance['select_2'] );
		$instance['select_3'] = strip_tags( $new_instance['select_3'] );
		$instance['select_4'] = strip_tags( $new_instance['select_4'] );
		$instance['select_5'] = strip_tags( $new_instance['select_5'] );
		$instance['select_6'] = strip_tags( $new_instance['select_6'] );
		$instance['select_7'] = strip_tags( $new_instance['select_7'] );
				
		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		
		$dv = array(
			'select_0'	=>	'select_0',
			'select_1'	=>	'select_1',
			'select_2'	=>	'select_2',
			'select_3'	=>	'select_3',
			'select_4'	=>	'select_4',
			'select_5'	=>	'select_5',
			'select_6'	=>	'select_6',
			'select_7'	=>	'select_7',
		);
		

		
		if(!isset($instance) || empty($instance) || !$instance){
			$instance = array();	
		}
		$instance = array_merge($dv, $instance);
		
				
		?>
        <p>
        <strong>First Icon : </strong><br/>
        <?php echo $this->tabs_select('select_0', $instance['select_0']); ?>
        </p>
        <p>
        <strong>Second Icon : </strong><br/>
        <?php echo $this->tabs_select('select_1', $instance['select_1']); ?>
        </p>
        <p>
        <strong>Third Icon : </strong><br/>
        <?php echo $this->tabs_select('select_2', $instance['select_2']); ?>
        </p>
        <p>
        <strong>Fourth Icon : </strong><br/>
        <?php echo $this->tabs_select('select_3', $instance['select_3']); ?>
        </p>
        <p>
        <strong>Fifth Icon : </strong><br/>
        <?php echo $this->tabs_select('select_4', $instance['select_4']); ?>
        </p>
        <p>
        <strong>Sixth Icon : </strong><br/>
        <?php echo $this->tabs_select('select_5', $instance['select_5']); ?>
        </p>
        <p>
        <strong>Seventh Icon : </strong><br/>
        <?php echo $this->tabs_select('select_6', $instance['select_6']); ?>
        </p>
        <p>
        <strong>Eighth Icon : </strong><br/>
        <?php echo $this->tabs_select('select_7', $instance['select_7']); ?>
        </p>
		<?php 
	}
	
	
	
	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		extract( $args );

		echo $before_widget;
		if ( ! empty( $title ) ){
			echo $before_title . $title . $after_title;
		}
				
		
		$icons = array();
		for($s = 0; $s < 8; $s++){
			if(isset($instance['select_'.$s]) && $instance['select_'.$s] && $instance['select_'.$s] !== ''){
				$icons[] = $instance['select_'.$s];
			}
		}

		echo '<div class="rockthemes-payment-icons">';
		
		foreach($icons as $icon){
			echo '<i class="icomoon '.esc_attr($icon).'"></i>';
		}
		
		echo '</div>';

		echo $after_widget;

	}
	

} // class 




if(!function_exists('rockthemes_widget_register_payment_icons')):
function rockthemes_widget_register_payment_icons(){
	register_widget( "rockthemes_payment_icons" );
}
endif;
add_action( 'widgets_init', 'rockthemes_widget_register_payment_icons');






?>