<?php
/**
 * Adds Rockthemes_Twitter_Widget.
 */
class Rockthemes_Image_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		parent::__construct(
	 		'rockthemes_image_widget', // Base ID
			'Rockthemes Image Widget', // Name
			array( 'description' => esc_html__( 'Rockthemes Image Widget', 'azoom' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		extract( $args );
		extract( $instance );
		$title = apply_filters( 'widget_title', $instance['title'] );

				
		echo $before_widget;
		if ( ! empty( $title ) )
			echo $before_title . $title . $after_title;
			
		$return = '';
		$image = '<img src="'.esc_url($image_url).'" alt="'.esc_attr(isset($image_alt) ? $image_alt : '').'" />';
		
		if('' !== $link_url){
			$image = '<a href="'.esc_url($link_url).'" '.(isset($link_target) && '' !== $link_target ? ' target="'.esc_attr($link_target).'" ' : '').'>'.$image.'</a>';
		}
		
		$return = $image;
		
		echo $return;

		echo $after_widget;
		
		
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['image_url'] = strip_tags( $new_instance['image_url'] );
		$instance['image_alt'] = strip_tags( $new_instance['image_alt'] );
		$instance['link_url'] = strip_tags( $new_instance['link_url'] );
		$instance['link_target'] = strip_tags( $new_instance['link_target'] );

		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		extract($instance);
		wp_enqueue_media();
		?>
        
		<script>
		jQuery(document).ready(function(){
			jQuery(document).on('click', '.rockthemes_widget_image_uploader', function(e){

				e.preventDefault();
				
				var send_attachment_bkp = wp.media.editor.send.attachment,
					that = jQuery(this),
					ref = that.attr('data-ref');
										
				wp.media.editor.send.attachment = function(props, attachment) {
		
						//URL of the image
						jQuery("#"+ref).val(attachment.url);
						//Set an attribute for the image id
						jQuery("#"+ref).attr('image_id', attachment.id);
				}
		
				wp.media.editor.open(that);
		
				return false;
			
			});
		});
        </script>

		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','azoom' ); ?></label> 
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php if(esc_attr( $title )){echo esc_attr( $title );} ?>" />
		</p>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'image_url' )); ?>"><?php esc_html_e( 'Image URL:','azoom' ); ?></label> 
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'image_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'image_url' )); ?>" type="text" value="<?php if(esc_attr( $image_url )){ echo esc_attr( $image_url );} ?>" />
		<a href="#" class="rockthemes_widget_image_uploader" data-ref="<?php echo esc_attr($this->get_field_id( 'image_url' )); ?>">Upload Image</a>
        </p>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'image_alt' )); ?>"><?php esc_html_e( 'Image Alt Tag:','azoom' ); ?></label> 
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'image_alt' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'image_alt' )); ?>" type="text" value="<?php if(esc_attr( $image_alt )){ echo esc_attr( $image_alt );} ?>" />
		</p>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'link_url' )); ?>"><?php esc_html_e( 'Link URL:','azoom' ); ?></label> 
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_url' )); ?>" type="text" value="<?php if(esc_attr( $link_url )){ echo esc_attr( $link_url );} ?>" />
		</p>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'link_target' )); ?>"><?php esc_html_e( 'Link Target:','azoom' ); ?></label> 
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_target' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_target' )); ?>" type="text" value="<?php if(esc_attr( $link_target )){ echo esc_attr( $link_target );} ?>" />
		</p>
		<?php 
	}

} // class 


if(!function_exists('rockthemes_widget_register_image')):
function rockthemes_widget_register_image(){
	register_widget( "rockthemes_image_widget" );
}
endif;
add_action( 'widgets_init', 'rockthemes_widget_register_image');



?>