<?php

/*
**	Rock Page Builder Main File
**
**	Alias	:	Rock Builder UI		Located in "rock-builder/builder-functions.php"
**	Alias	:	Rock Builder		Located in "rock-builder/rock-builder-ui.php"
**	Author	:	Rockthemes.net
**	License	:	Contact to rockthemes.net for further information
**	Version	:	2.0
**
**	Main file of Rock Page Builder
*/




include_once(AZOOM_PLUGIN_DIR.'rock-builder/rock-builder-config.php');
include_once(AZOOM_PLUGIN_DIR.'rock-builder/builder-functions.php');
include_once(AZOOM_PLUGIN_DIR.'rock-builder/builder-validators.php');
if(defined('RPB_FULL_SHORTCODE')){
	include_once(AZOOM_PLUGIN_DIR.'rock-builder/builder-full-shortcode.php');
}



/*
**	TinyMCE Quick Shortcodes 
**
**	@since	:	1.0
*/
if(!function_exists('rockthemes_tinymce_register_button')):
// register button
function rockthemes_tinymce_register_button($buttons) {  
   array_push($buttons, "rockthemes_plugins");   
   return $buttons;  
}  
endif;

if(!function_exists('rockthemes_tinymce_add_plugin')):
// add plugin
function rockthemes_tinymce_add_plugin($plugin_array) {  
    $plugin_array['rockthemes_plugins'] = AZOOM_PLUGIN_URI.'/rock-builder/js/rock-builder-tinymce.js';

   return $plugin_array;  
} 
endif;

if(!function_exists('rockthemes_add_mce_button')):
function rockthemes_add_mce_button(){
	if(function_exists('xr_get_option') && !xr_get_option('disable_rpb', false)){
		add_filter('mce_external_plugins', 'rockthemes_tinymce_add_plugin');  
		add_filter('mce_buttons', 'rockthemes_tinymce_register_button');  
	}
}
endif;
add_action('admin_head', 'rockthemes_add_mce_button');




function load_rock_builder_files(){
	global $pagenow, $rock_page_builder_config, $rpb_post_types;
	
	if(empty($rpb_post_types)){
		$rpb_post_types = rpb_get_post_types();	
	}

	
	if(function_exists('get_current_screen')){
		//Do not load in media edit screen
		$current_screen = get_current_screen();
		if(isset($current_screen) && $current_screen->post_type === 'attachment') return;
		
		if(!empty($current_screen->post_type)){
			$allowed = false;
			
			foreach($rpb_post_types as $allowed_type){
				if($allowed_type == $current_screen->post_type){
					$allowed = true;	
				}
			}
			
			if(!$allowed){
				return;	
			}
		}
	}
	
	$allowed_if_array = $rpb_post_types;
	unset($allowed_if_array['page']);
	unset($allowed_if_array['post']);
	$allowed_if = false;
	
	foreach($allowed_if_array as $aif){
		if($pagenow == 'post-new.php' && !empty($_REQUEST['post_type']) && $_REQUEST['post_type'] == $aif){
			$allowed_if = true;	
		}
	}


	if(($pagenow == 'post.php' && !empty($_REQUEST['action']) && $_REQUEST['action'] == 'edit') || 
		($pagenow == 'post-new.php') /*May cause conflicts*/ ||
		$allowed_if ||
		($pagenow == 'post-new.php' && !empty($_REQUEST['post_type']) && $_REQUEST['post_type'] == 'product') || 
		($pagenow === 'themes.php' && !empty($_REQUEST['page']) && $_REQUEST['page'] === 'rock_options')){


		//Return if RPB disabled
		if(function_exists('xr_get_option')){		
			if(xr_get_option('disable_rpb', false) || !current_user_can(xr_get_option('user_ableto_rpb', 'delete_pages'))){
				
				if(!xr_get_option('disable_advanced_details',false) || current_user_can(xr_get_option('user_ableto_advanced_details', 'delete_pages'))){
					//Enqueue bootstrap for advanced details field
					wp_enqueue_style( 'bootstrap-css', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap/css/bootstrap.css', '', '', 'all' );
					
					//Enqueue fontawesome for advanced details field
					wp_enqueue_style( 'fontawesome', AZOOM_PLUGIN_URI.'/css/font-awesome.css', '', '', 'all' );
				}
				return;
			}
		}
			
		wp_enqueue_script('jquery-ui-core');
		
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_script('json2');
						
		add_editor_style( 'rock-builder/css/editor-style.css');		
		
		//Changed to .min files with 1.3
		wp_enqueue_style( 'bootstrap-css', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap/css/bootstrap.css', '', '', 'all' );
		wp_enqueue_script('bootstrap-min', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap/js/bootstrap.min.js', array('jquery'), '');

		
		//wp_enqueue_style( 'bootstrap-css', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap/css/bootstrap.css', '', '', 'all' );
		//wp_enqueue_script('bootstrap-min', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap/js/bootstrap.js', array('jquery'), '');
		
		wp_enqueue_style( 'fontawesome', AZOOM_PLUGIN_URI.'/icons/css/font-awesome.css', '', '', 'all' );
		
			
		wp_enqueue_style( 'gridster-css', AZOOM_PLUGIN_URI.'/rock-builder/css/jquery.gridster.css', '', '', 'all' );
		wp_enqueue_style( 'rock-builder-css', AZOOM_PLUGIN_URI.'/rock-builder/css/rock-builder-style.css', '', '', 'all' );
		
		wp_enqueue_script('gridster-min', AZOOM_PLUGIN_URI.'/rock-builder/js/jquery.gridster.js', array('jquery'), '');
		wp_enqueue_script('rock-builder-js', AZOOM_PLUGIN_URI.'/rock-builder/js/rock-builder.min.js', array('jquery'), '');
		
		wp_enqueue_style( 'bootstrap-modal-css', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap-modal-master/css/bootstrap-modal.css', '', '', 'all' );
		
		wp_enqueue_script('bootstrap-modal-master', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap-modal-master/js/bootstrap-modalmanager.js', array('jquery'), '');
		wp_enqueue_script('bootstrap-modal-reg', AZOOM_PLUGIN_URI.'/rock-builder/bootstrap-modal-master/js/bootstrap-modal.js', array('jquery'), '');

		
		$rpb_config = array( 
			'ajaxurl' 	=>	admin_url( 'admin-ajax.php' ), 
			'siteurl' 	=>	home_url(),
			'settings'	=>	$rock_page_builder_config['settings'],
			'elements'	=>	$rock_page_builder_config['elements'],
			'nonces'	=>	array(
				'rpb_save'		=>	wp_create_nonce('rpb_save'),
				'rpb_transfer'	=>	wp_create_nonce('rpb_transfer')
			),
		);
		
		// declare the URL to the file that handles the AJAX request (wp-admin/admin-ajax.php)
		wp_localize_script( 'rock-builder-js', 'rockAjax', $rpb_config );

	}
}

add_action('admin_enqueue_scripts', 'load_rock_builder_files');

function init_pagebuilder_to_pages(){
	global $rpb_post_types;
	
	rpb_be_version_check();
	
	if(empty($rpb_post_types)){
		$rpb_post_types = rpb_get_post_types();	
	}
	//Return if RPB disabled
	if(function_exists('xr_get_option') && xr_get_option('disable_rpb', false)) return;
	
	//Return if current user not able to edit it
	if(function_exists('xr_get_option') && !current_user_can(xr_get_option('user_ableto_rpb', 'delete_pages'))) return;
	
	foreach ($rpb_post_types as $type) 
    {
		add_meta_box( 'custom_page', 'Page Builder' , 'rock_pages_ui', $type, 'normal', 'high' );
    }
}

add_action( 'admin_init', 'init_pagebuilder_to_pages' );


function rpb_be_version_check(){
	//iv = Installed Version
	$iv = get_option('_rpb_be_version',false);
	
	if(!$iv){
		update_option('_rpb_be_version', RPB_BE_VERSION);
		return;
	}
	
	return;
		
	if(version_compare($iv, RPB_BE_VERSION, '<')){
		update_option('rpb_be_requires_db_update','yes');
	}
}

if(get_option('rpb_be_requires_db_update', '') === 'yes'){
	include_once(AZOOM_PLUGIN_DIR.'rock-builder/builder-database-updater.php');
}




function rpb_get_category_taxonomy_list_string($post_type){
	$list;
	
	if($post_type == 'post'){
		$list = get_categories();
	}else{
		$tax_list = get_object_taxonomies($post_type);
		foreach($tax_list as $tax){

			if(strpos($tax,'cat') > -1){
				$list = get_terms($tax, array('hide_empty'=>0));
				break;
			}
		}
	}
	
	if(!is_array($list) || empty($list)) return '';
	
	$all_types = '';
	$total = sizeof($list);
	$i = 0;
	foreach($list as $allType){
		$all_types .= $allType->slug;
		
		if($i +1 < $total){
			$all_types .= ',';	
		}
		
		$i++;
	}
	
	return $all_types;
}

function rpb_filters_list_of($hook){
    global $wp_filter;
    if( empty( $hook ) || !isset( $wp_filter[$hook] ) )
        return;
}

function rpb_make_global_post(){
	global $post, $wp_query, $rpb_post_types, $rpb_post;

	if(empty($rpb_post_types)){
		$rpb_post_types = rpb_get_post_types();	
	}

	$qobj = $wp_query->get_queried_object();
		
	$has_term_id = isset($qobj->term_id) ? true : false;
		
	$id = false;
	$content = '';
	
	if(isset($qobj->ID)){
		$id = $qobj->ID;
		$fake_content = get_post_field('post_content',$id);
		$content = isset($fake_content) ? $fake_content : '';
	}
	//rpb_filters_list_of('the_content');
	$post_type = get_post_type();
	$is_archive = rpb_is_archive();
	
	//Check if this is an arhive 
	if($is_archive){
		
		foreach($rpb_post_types as $type){
			if($type == $post_type){
				$exists = function_exists('xr_get_option') && xr_get_option($type.'_archive_layout', false);
				if($exists && $exists !== ''){
					$id = (int)$exists;
				}
				break;
			}
		}
							
		//For portfolio shortcode archive
		if(!isset($GLOBALS['rpb_archive_post_type']) && $id){
			$GLOBALS['rpb_archive_post_type'] = $post_type;
			$GLOBALS['rpb_post_id'] = $id;
			if(isset($qobj) && isset($qobj->slug) && $qobj->slug){
				$GLOBALS['rpb_archive_category'] = $qobj->slug;
			}else{
				$GLOBALS['rpb_archive_category'] = rpb_get_category_taxonomy_list_string($post_type);
			}
			
			if(isset($qobj) && isset($qobj->taxonomy) && $qobj->taxonomy){
				$GLOBALS['rpb_archive_taxonomy'] = $qobj->taxonomy;	
			}
			
			$GLOBALS['rpb_has_term_id'] = $has_term_id;
		}
		
		if(!$id){
			$GLOBALS['rpb_post_id'] = false;	
		}else{
			$content = get_post_field('post_content',$id);
		}
	}
	
		
	//Make the global rpb_post element	
	$rpb_post = array(
		'ID'			=>	$id,
		'post_type'		=>	$post_type,
		'in_use'		=>	false,
		'val'			=>	'',
		'final_val'		=>	'',
		'content'		=>	$content,
		'is_archive'	=>	$is_archive,
		'is_blog'		=>	rpb_is_blog(),
		'has_term_id'	=>	$has_term_id
	);
	
	if(defined('RPB_FULL_SHORTCODE')){
		return;
	}
	
		
	if(!$id) return;
		
	//Check if page-builder in use
	$in_use = get_post_meta($id,'_builder_in_use',true);
	
	$rpb_post['in_use'] = $in_use;
	
    $val = get_post_meta( $id, '_this_r_content', true );  
	
    if( empty( $val ) ) return;  
	
	if(defined('RPB_CONTENT_FILTER')){
		$val = preg_replace( "/\r/", "", $val);
	}else{
		$val = preg_replace( "/\r|\n/", "", $val);
	}
	
	$rpb_post['val'] = $val;
	
	$final_val = (json_decode($val, true));
		
	if(!is_array($final_val)){
		$final_val = json_decode(stripslashes($val), true);
	}
			
	$rpb_post['final_val'] = $final_val;
	
}
//It used to be rockthemes_pb_frontend_before_header
add_action('wp_enqueue_scripts','rpb_make_global_post',1);


/*
**	If the page is main blog page returns tru
**
*/
function rpb_is_blog(){
	global $wp_query, $post;
	
	$page_for_posts = get_option( 'page_for_posts' );
	if($page_for_posts){
		$qobj = $wp_query->get_queried_object();
		if(isset($qobj->ID)){
			return $qobj->ID == $page_for_posts;
		}
	}
	return false;
	return ( ((is_archive()) || (is_author()) || (is_category()) || (is_home()) || (is_single()) || (is_tag())) && ( get_post_type() == 'post')) ? true : false ;
}

function rpb_is_archive(){
	return (is_archive() || rpb_is_blog()) ? true : false;
}




/*
**	Make a global variable to hold inline nav elements. Inline navigation will use this variable
**
**	@since	:	1.3
**
*/
function rockthemes_pb_frontend_gather_nav_grids(){
	//rpb_queried_id();
	
	//Check if inline nav activated
	if(rad_get_option('display_inline_nav') !== 'true') return;
	//Set a global variable to hold special grid id's and titles for inline navigation
	$GLOBALS['rockthemes_frontend_inline_nav'] = array();
}
add_action('rockthemes_pb_frontend_before_header','rockthemes_pb_frontend_gather_nav_grids', 1);



function rockthemes_pb_frontend_display_nosidebar_content_header(){
	global $post, $rpb_post;
	//Check if post exists (For WPML)	
	if(empty($post) && empty($rpb_post)) return;

	/*
	**	Password Protected
	**
	**	@since	:	1.3
	*/
	if(post_password_required()) return;
		
	//Return if not single or page (For custom post types and posts)
	if((!is_single() && !is_page() && !is_archive() && !rpb_is_blog()) || is_search()) return;
	if(is_archive() && !$rpb_post['ID']) return;
	if(rpb_is_blog() && !$rpb_post['ID']) return;

	//Set a global variable to hold special grid id's and titles for inline navigation
	$GLOBALS['rockthemes_frontend_inline_nav'] = array();
	
	//Check if page-builder in use
	$in_use = $rpb_post['in_use'];
	
	if(!isset($in_use) || $in_use === 'false' || defined('RPB_FULL_SHORTCODE')){
		$content_header = array();
		if(defined('RPB_FULL_SHORTCODE')){
			preg_match_all('/\[rpb_sgrid avoid_sidebar\=\"header\".*?\[\/rpb_sgrid\]/s', $rpb_post['content'], $content_header);
		}else{
			preg_match_all('/\[rockthemes_specialgridblock avoid_sidebar\=\"header\".*?\[\/rockthemes_specialgridblock\]/s', $rpb_post['content'], $content_header);
		}
		if(empty($content_header) || empty($content_header[0]) || empty($content_header[0][0])) return;
		
		$rtrn = '';
		foreach($content_header[0] as $cntbfr){
			$rtrn .= do_shortcode($cntbfr);
		}
		
		if(defined('RPB_ENABLE_CRAYON')){
			$rtrn = CrayonWP::highlight($rtrn);
		}
		
		echo rockthemes_escaped_out_render($rtrn);
		
		return;
	}
	
	$val = $rpb_post['val'];

    if( empty( $val ) ) return;  
	
	
	$final_val = $rpb_post['final_val'];	

	$header_final = do_shortcode(rockthemes_pb_parse_content_val($final_val,'header'));
	
	if(defined('RPB_ENABLE_CRAYON')){
		$header_final = CrayonWP::highlight($header_final);
	}
	
	echo rockthemes_escaped_out_render($header_final);

	return;
}
add_action('rockthemes_pb_frontend_before_header','rockthemes_pb_frontend_display_nosidebar_content_header', 10);


/*
**	Add Menu to the Inline Navigation
**
**	@since	:	1.3
*/
function rockthemes_pb_frontend_rin_add_header(){
	$header_id = rad_get_option('rin_header_id', '');	
	$header_title = rad_get_option('rin_header_title', '');

	if($header_id && $header_title){
		$GLOBALS['rockthemes_frontend_inline_nav'][$header_id] = $header_title;
	}
	
	return;
}
add_action('rockthemes_pb_frontend_before_page','rockthemes_pb_frontend_rin_add_header',1);



function rockthemes_pb_frontend_display_nosidebar_content_before(){
	//Get the post element	
	global $post, $rpb_post;
	//Check if post exists (For WPML)	
	if(empty($post) && empty($rpb_post)) return;
	
	/*
	**	Password Protected
	**
	**	@since	:	1.3
	*/
	if(post_password_required()) return;
	
	$post_type = $rpb_post['post_type'];//get_post_type();

	//Return if not single or page (For custom post types and posts)
	if((!is_single() && !is_page() && !is_archive() && !rpb_is_blog()) || is_search()) return;
	if(is_archive() && !$rpb_post['ID']) return;
	if(rpb_is_blog() && !$rpb_post['ID']) return;

	//Check if page-builder in use
	$in_use = $rpb_post['in_use'];
		
	if(!isset($in_use) || $in_use === 'false' || defined('RPB_FULL_SHORTCODE')){
		$content_before = array();
		if(defined('RPB_FULL_SHORTCODE')){
			preg_match_all('/\[rpb_sgrid avoid_sidebar\=\"before\".*?\[\/rpb_sgrid\]/s', $rpb_post['content'], $content_before);
		}else{
			preg_match_all('/\[rockthemes_specialgridblock avoid_sidebar\=\"before\".*?\[\/rockthemes_specialgridblock\]/s', $rpb_post['content'], $content_before);
		}

		if(empty($content_before) || empty($content_before[0]) || empty($content_before[0][0])) return;
		
		$rtrn = '';
		foreach($content_before[0] as $cntbfr){
			$rtrn .= do_shortcode($cntbfr);
		}
		
		if(defined('RPB_ENABLE_CRAYON')){
			$rtrn = CrayonWP::highlight($rtrn);
		}
		
		echo rockthemes_escaped_out_render($rtrn);
		
		return;
	}
	
	$val = $rpb_post['val'];

    if( empty( $val ) ) return;  
	
	
	$final_val = $rpb_post['final_val'];
	
	$before_final = do_shortcode(rockthemes_pb_parse_content_val($final_val,'before'));

	if(defined('RPB_ENABLE_CRAYON')){
		$before_final = CrayonWP::highlight($before_final);
	}	

	echo '</div>'.$before_final.'<div class="row">';
}
add_action('rockthemes_pb_frontend_before_page','rockthemes_pb_frontend_display_nosidebar_content_before', 10);

function rockthemes_pb_frontend_display_nosidebar_content_after(){
	global $post,$rpb_post;
	//Check if post exists (For WPML)	
	if(empty($post) && empty($rpb_post)) return;
	
	/*
	**	Password Protected
	**
	**	@since	:	1.3
	*/
	if(post_password_required()) return;
		
	//Return if not single or page (For custom post types and posts)
	if((!is_single() && !is_page() && !is_archive() && !rpb_is_blog()) || is_search()) return;
	if(is_archive() && !$rpb_post['ID']) return;
	if(rpb_is_blog() && !$rpb_post['ID']) return;
	
	//Check if page-builder in use
	$in_use = $rpb_post['in_use'];
	
	if(!isset($in_use) || $in_use === 'false' || defined('RPB_FULL_SHORTCODE')){
		$content_before = array();
		if(defined('RPB_FULL_SHORTCODE')){
			preg_match_all('/\[rpb_sgrid avoid_sidebar\=\"after\".*?\[\/rpb_sgrid\]/s', $rpb_post['content'], $content_after);
		}else{
			preg_match_all('/\[rockthemes_specialgridblock avoid_sidebar\=\"after\".*?\[\/rockthemes_specialgridblock\]/s', $rpb_post['content'], $content_after);
		}
		if(empty($content_after) || empty($content_after[0]) || empty($content_after[0][0])) return;
		
		$rtrn = '';
		foreach($content_after[0] as $cntbfr){
			$rtrn .= do_shortcode($cntbfr);
		}
		
		if(defined('RPB_ENABLE_CRAYON')){
			$rtrn = CrayonWP::highlight($rtrn);
		}
		
		echo rockthemes_escaped_out_render($rtrn);
		
		return;
	}
	
	$val = $rpb_post['val'];

    if( empty( $val ) ) return;  
	
	$final_val = $rpb_post['final_val'];
	
	$after_final = do_shortcode(rockthemes_pb_parse_content_val($final_val,'after'));
	
	if(defined('RPB_ENABLE_CRAYON')){
		$after_final = CrayonWP::highlight($after_final);
	}		
	
	echo '</div></div>'.$after_final.'<div><div class="row">';

	return;
}
add_action('rockthemes_pb_frontend_after_page','rockthemes_pb_frontend_display_nosidebar_content_after', 10);


function rockthemes_pb_wp_content_filter( $content)  
{  	
    // We're in the loop, so we can grab the $post variable  
    global $post, $rpb_post, $wp_query;  

	//Check if post exists (For WPML)	
	if(empty($post) && empty($rpb_post)) return;
	
	/*
	**	Password Protected
	**
	**	@since	:	1.3
	*/
	if(post_password_required()) return get_the_password_form();

	//Check if page-builder in use
	$in_use = $rpb_post['in_use'];
	

	//TO DO : Bind this to a setting
	//Single Post in Blog Roll Special Situation
    if((!is_single() && !is_page() && !is_search() && !is_feed() && !is_archive())){
		$temp_excerpt = $post->post_excerpt;
		if($temp_excerpt !== ''){
			if(isset($in_use) && $in_use !== 'false' && !empty($in_use)){
				return $temp_excerpt;
			}
		}
	}
	//Special Situation for RPB blog posts in blog roll	
	if(($rpb_post['ID'] !== $post->ID) && $rpb_post['is_archive'] !== true){
		$nin_use = get_post_meta($post->ID,'_builder_in_use',true);
		if(isset($nin_use) && $nin_use !== 'false' && !empty($nin_use)){
			$nexcerpt = $post->post_excerpt;
			if($nexcerpt !== ''){
				return $nexcerpt;	
			}else{
				return '';	
			}
		}else{
			return $content;	
		}
	}

    // We only want this on single posts, bail if we're not in a single post  
    if((!is_single() && !is_page()) || is_search() || is_feed()){
		if($rpb_post['is_archive'] !== true){
			return $content;
		}
	}
	//if(($rpb_post['ID'] !== $post->ID)) return $content;
	//var_dump($post);

	if(!isset($in_use) || $in_use === 'false' || $in_use === '' || defined('RPB_FULL_SHORTCODE') || !defined('ROCKTHEMES_THEME')){
		/*
		**	Remove all of the special grid codes from the general content area.
		**	Special grid block contents will be displayed before/after the content
		**
		**	@since	:	1.3
		*/
		$content_reg = array();
		if(!defined('ROCKTHEMES_THEME')){
			preg_match_all('/\[rpb_sgrid avoid_sidebar\=\"false\".*?\[\/rpb_sgrid\]/s', $content, $content_reg);
		}else{
			preg_match_all('/\[rockthemes_specialgridblock avoid_sidebar\=\"regular\".*?\[\/rockthemes_specialgridblock\]/s', $content, $content_reg);
		}

		if(empty($content_reg) || empty($content_reg[0]) || empty($content_reg[0][0])){
			if(!defined('ROCKTHEMES_THEME')){
				preg_match_all('/\[rpb_sgrid avoid_sidebar="false".*?\[\/rpb_sgrid\]/s', $content, $content_reg);
			}else{
				preg_match_all('/\[rockthemes_specialgridblock avoid_sidebar="regular".*?\[\/rockthemes_specialgridblock\]/s', $content, $content_reg);
			}
			if(empty($content_reg) || empty($content_reg[0]) || empty($content_reg[0][0])){
				if(!defined('ROCKTHEMES_THEME')){
					$filtered = preg_replace('/\[rpb_sgrid.*?\[\/rpb_sgrid\]/s', '', $content);
				}else{
					$filtered = preg_replace('/\[rockthemes_specialgridblock.*?\[\/rockthemes_specialgridblock\]/s', '', $content);
				}
				if(trim(wpautop($filtered)) === '</p>' || trim(wpautop($filtered)) === '<p>'){
					return '';	
				}else{
					
					if(defined('RPB_ENABLE_CRAYON')){
						$filtered = CrayonWP::highlight($filtered);
					}
					
					return $filtered;	
				}
			}
		}
		$rsgr = '';//Rockthemes Special Grid Regular
		foreach($content_reg[0] as $cntbfr){
			$rsgr .= do_shortcode($cntbfr);
		}
		
		if(defined('RPB_ENABLE_CRAYON')){
			$rsgr = CrayonWP::highlight($rsgr);
		}
		
		return $rsgr;
	}

	$val = $rpb_post['val'];

    if( empty( $val ) ){ 
		/*
		**	Remove all of the special grid codes from the general content area.
		**	Special grid block contents will be displayed before/after the content
		**
		**	@since	:	1.3
		*/
		return preg_replace('/\[rockthemes_specialgridblock.*?\[\/rockthemes_specialgridblock\]/s', '', $content);
	}

	$final_val = $rpb_post['final_val'];

	//Regular content may contain special grid and may be free. Thus we will make more than 1 function
	$return = do_shortcode(rockthemes_pb_parse_content_val($final_val));
	$return .= do_shortcode(rockthemes_pb_parse_content_val($final_val, 'regular'));
	
	if(defined('RPB_ENABLE_CRAYON')){
		$return = CrayonWP::highlight($return);
	}			
	
	return $return;// .$content removed
}
//We have to set this to 10 as lowest number. Otherwise Worpdress adds "<br>" elements in shortcodes
add_filter( 'the_content', 'rockthemes_pb_wp_content_filter', 10 );  //was 1




function rpb_get_the_content(){
	global $post, $rpb_post;
	
	if(!rpb_is_blog() && !is_archive()){
		return get_the_content();	
	}else{
		
		//Check if post exists (For WPML)	
		if(empty($post) && empty($rpb_post)) return;
		
		if(!$rpb_post['ID']) return;
		
		/*
		**	Password Protected
		**
		**	@since	:	1.3
		*/
		if(post_password_required()) return get_the_password_form();
		
		$in_use = $rpb_post['in_use'];
		
		if(!isset($in_use) || $in_use === 'false' || $in_use === ''){
			/*
			**	Remove all of the special grid codes from the general content area.
			**	Special grid block contents will be displayed before/after the content
			**
			**	@since	:	1.3
			*/
			
			$content_before = array();
			preg_match_all('/\[rockthemes_specialgridblock avoid_sidebar\=\"regular\".*?\[\/rockthemes_specialgridblock\]/s', $rpb_post['content'], $content_before);
			if(empty($content_before) || empty($content_before[0]) || empty($content_before[0][0])) return $rpb_post['content'];
			$rsgr = '';//Rockthemes Special Grid Regular
			foreach($content_before[0] as $cntbfr){
				$rsgr .= do_shortcode($cntbfr);
			}
			return $rsgr;
		}
	
		$val = $rpb_post['val'];
			
		if( empty( $val ) ){ 
			/*
			**	Remove all of the special grid codes from the general content area.
			**	Special grid block contents will be displayed before/after the content
			**
			**	@since	:	1.3
			*/
			return preg_replace('/\[rockthemes_specialgridblock.*?\[\/rockthemes_specialgridblock\]/s', '', $content);
		}

		$final_val = $rpb_post['final_val'];
	
		//Regular content may contain special grid and may be free. Thus we will make more than 1 function
		$return = do_shortcode(rockthemes_pb_parse_content_val($final_val));
		$return .= do_shortcode(rockthemes_pb_parse_content_val($final_val, 'regular'));
		
		return $return;// .$content removed

	}
}



/**
* @param  $content Content of post
* @return string
*/
function rockthemes_pb_feed_filter($content)
{
	global $post;
	if(!empty($post) && (int) get_option('rss_use_excerpt') === 0){
		return do_shortcode(get_the_content());	
	}
	return $content;
}
add_filter('the_content_feed', 'rockthemes_pb_feed_filter');
add_filter('the_excerpt_rss', 'rockthemes_pb_feed_filter');


/*
//Useful when developing RSS Feed details. This shortens the RSS Refresh time. 
//But browser needs to clear it's cache again.
function rockthemes_pb_update_rss_time($time){
	return 10;
}
add_filter( 'wp_feed_cache_transient_lifetime', 'rockthemes_pb_update_rss_time' );
*/












function rockthemes_pb_parse_content_val($val,$nosidebar_content = 'false'){	
	//return if no value entered or the value is not an array
	if((!isset($val) && !is_array($val)) || empty($val) || $val === '') return;
		
	foreach ($val as $key => $value) {

		$col[$key] = $value['col'];
		
		$row[$key] = $value['row'];
	
	}
	
	array_multisort($row, $col, $val);
	
	$main_return = '';
	$return = '';	
	
	$calcColumn = 0;
	$latestRow = 1;
	$columnsInRow = 1; //Must be 12 for each column
	
	//We change the parallax and background image size without cropping. Thus we use Wordpress size
	$bg_image_size = '';
	
	$fullwidth_colored_active = false;//For fullwidth colored rows
	$fullwidth_slider_active = false;//For full width slider rows
	$fullwidth_screen_slider_active = false;//For full width slider rows
	$background_video_active = false;//For full width video rows
	$all_regular_area_active = false;//For no sidebar content without any width details
	$general_padding = function_exists('xr_get_option') ? rockthemes_fn_px_em_return_num(xr_get_option('content_padding','10px')) : 10;
	$shadow_html = '';
	$last_shadow_html = '';
	$skip_content_in_blocks = false;
	$add_down_arrow = false;
	

		
	foreach($val as $singleVal){
		
		$add_inline_nav = false;
		
		//Open and close special grid block
		if($nosidebar_content !== 'regular'){
			if(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'yes'){
				//$return .= 'OPENED';
				
				if(isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) &&
				   $singleVal['grid_data']['data']['data']['special_grid_html_id'] != '' &&
				   isset($singleVal['grid_data']['data']['data']['special_grid_html_title']) &&
				   $singleVal['grid_data']['data']['data']['special_grid_html_title'] != ''){
					$add_inline_nav = true;
				}
				
				if($singleVal['grid_data']['data']['data']['avoidSidebar'] === $nosidebar_content){
					$GLOBALS['rockthemes_pb_specialgridblocks'] = true;
				}
			}elseif(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'no'){
				//$return .= 'CLOSED';
				if($singleVal['grid_data']['data']['data']['avoidSidebar'] === $nosidebar_content){
					$GLOBALS['rockthemes_pb_specialgridblocks'] = false;
				}
			}
		}else{

			//Not before not after, regular content. But blocks are still exists, these two statements will escape content in blocks
			if(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'yes'){
				//echo 'OPENED';
				$skip_content_in_blocks = true;	
			}elseif(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'no'){
				//echo 'CLOSED';
				$skip_content_in_blocks = false;	
			}

		}
				
		//Do not display if this is no sidebar content
		//if(isset($singleVal['grid_data']['data']['data']['avoidSidebar']) && $nosidebar_content === 'false' && $singleVal['grid_data']['data']['data']['avoidSidebar'] !== 'false' ) continue;
		
		//Not in special grid
		if($nosidebar_content === 'regular' && ((isset($GLOBALS['rockthemes_pb_specialgridblocks']) && $GLOBALS['rockthemes_pb_specialgridblocks']) || $skip_content_in_blocks)) continue;
		
		//Not before not after not header but still in special grid
		if(($nosidebar_content === 'false' ) && (!isset($singleVal['special_grid_block_open']) || $singleVal['special_grid_block_open'] !== 'no') && (!isset($GLOBALS['rockthemes_pb_specialgridblocks']) || !$GLOBALS['rockthemes_pb_specialgridblocks'] ) ) continue;
		
		
		//Display only no sidebar content before header
		if(($nosidebar_content === 'header' ) && (!isset($singleVal['special_grid_block_open']) || $singleVal['special_grid_block_open'] !== 'no') && (!isset($GLOBALS['rockthemes_pb_specialgridblocks']) || !$GLOBALS['rockthemes_pb_specialgridblocks'] ) ) continue;
		
		//Display only no sidebar content before sidebars
		if(($nosidebar_content === 'before' ) && (!isset($singleVal['special_grid_block_open']) || $singleVal['special_grid_block_open'] !== 'no') && (!isset($GLOBALS['rockthemes_pb_specialgridblocks']) || !$GLOBALS['rockthemes_pb_specialgridblocks'] ) ) continue;

		//Display only no sidebar content after sidebars
		if(($nosidebar_content === 'after' ) && (!isset($singleVal['special_grid_block_open']) || $singleVal['special_grid_block_open'] !== 'no') && (!isset($GLOBALS['rockthemes_pb_specialgridblocks']) || !$GLOBALS['rockthemes_pb_specialgridblocks'] )) {continue;}
		
		//Add Inline Nav Element
		if($add_inline_nav){
			$GLOBALS['rockthemes_frontend_inline_nav'][$singleVal['grid_data']['data']['data']['special_grid_html_id']] = $singleVal['grid_data']['data']['data']['special_grid_html_title'];
		}
		
		//Check if using fullwidth for sliders
		$fullwidth_slider = isset($singleVal['grid_data']['data']['data']['grid_special_width_details']) &&
							$singleVal['grid_data']['data']['data']['grid_special_width_details'] === 'full_width_slider' ? true : false;
			
		//Check if using fullwidth and full screen for sliders
		$fullwidth_screen_slider = isset($singleVal['grid_data']['data']['data']['grid_special_width_details']) &&
							$singleVal['grid_data']['data']['data']['grid_special_width_details'] === 'full_width_screen_slider' ? true : false;
		
		//Check if using fullwidth background color
		$fullwidth_colored = isset($singleVal['grid_data']['data']['data']['grid_special_width_details']) &&
							$singleVal['grid_data']['data']['data']['grid_special_width_details'] === 'full_width_colored' ? true : false;
			
		//Check if using parallax
		$parallax_used = isset($singleVal['grid_data']['data']['data']['grid_special_width_details']) &&
							$singleVal['grid_data']['data']['data']['grid_special_width_details'] === 'use_parallax' ? true : false;
		
		//Background Image in Special Blocks
		$background_img_used = isset($singleVal['grid_data']['data']['data']['grid_special_width_details']) &&
							$singleVal['grid_data']['data']['data']['grid_special_width_details'] === 'use_background_img' ? true : false;
		
		//Use Video
		$background_video_used = isset($singleVal['grid_data']['data']['data']['grid_special_width_details']) &&
							$singleVal['grid_data']['data']['data']['grid_special_width_details'] === 'use_background_video' ? true : false;

		
		$background_color = isset($singleVal['grid_data']['data']['data']['background_color']) ?
							esc_attr($singleVal['grid_data']['data']['data']['background_color']) : '';

		$transparent_background = checked("true", (isset($singleVal['grid_data']['data']['data']['transparent_background']) ? $singleVal['grid_data']['data']['data']['transparent_background'] : false ), false);
		
		$all_regular_area = false;
		if(!$fullwidth_slider && !$fullwidth_screen_slider && !$fullwidth_colored && !$parallax_used && !$background_img_used && !$background_video_used && !$all_regular_area_active &&
			isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] !== 'no'){
			$all_regular_area = true;
		}
		
		//Check if added arrow down for the special grid
		if(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'yes' && 
		   isset($singleVal['grid_data']['data']['data']['add_down_arrow']) && 
		   $singleVal['grid_data']['data']['data']['add_down_arrow'] === 'true'){
			$GLOBALS['rockthemes_pb_add_down_arrow'] = true;
			$GLOBALS['rockthemes_pb_down_arrow_color'] = (isset($singleVal['grid_data']['data']['data']['down_arrow_color']) &&
							$singleVal['grid_data']['data']['data']['down_arrow_color']) ? $singleVal['grid_data']['data']['data']['down_arrow_color'] : '#f9f9f9';
		}
		
		
		$light_font_class = '';
		//Check if light font colors added.
		if(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'yes' && 
		   isset($singleVal['grid_data']['data']['data']['use_light_font_colors']) && 
		   $singleVal['grid_data']['data']['data']['use_light_font_colors'] === 'true'){
			
			$light_font_class = 'unique-grid-light-fonts';
		}
		
		$border_bottom_class = '';
		//Check if light font colors added.
		if(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'yes' && 
		   isset($singleVal['grid_data']['data']['data']['use_border_bottom']) && 
		   $singleVal['grid_data']['data']['data']['use_border_bottom'] === 'true'){
			
			$border_bottom_class = 'unique-grid-border-bottom';
		}
		
		
		/*$padding_vertical_html = '';*/
		$padding_class = '';
		
		if(isset($singleVal['grid_data']['data']['data']['activate_padding']) && $singleVal['grid_data']['data']['data']['activate_padding'] === 'true'){
			/*$padding_vertical_html = 'padding-top:'.(4 * $general_padding).'px; padding-bottom:'.(4 * $general_padding).'px;';*/
			$padding_class = 'rsb-vertical-space';
		}

				
		if(intval($singleVal['row']) === intval($latestRow)){

		}else{
			$latestRow = $singleVal['row'];
			
			if($columnsInRow <= 12 && $columnsInRow !== 1)	$return .= '<div class="large-'.(13 - $columnsInRow).' medium-'.(13 - $columnsInRow).' columns"></div>';

			if($fullwidth_colored_active && (!$GLOBALS['rockthemes_pb_specialgridblocks'])){
				$return .= '</div>';
				$return .= $shadow_html;
				$shadow_html = '';
				
				$fullwidth_colored_active = false;	
			}
			
			if($background_video_active && (!$GLOBALS['rockthemes_pb_specialgridblocks'])){
				$return .= '</div></div>';
				$background_video_active = false;	
			}
			
			if($all_regular_area_active && (!$GLOBALS['rockthemes_pb_specialgridblocks'])){
				$return .= '</div></div>';
				$all_regular_area_active = false;
			}

			if($fullwidth_slider_active && ($GLOBALS['rockthemes_pb_specialgridblocks'])){
				//$return .= '</div>';
				//$fullwidth_slider_active = false;	
			}
			
			
			
			
		if(isset($singleVal['special_grid_block_open']) && $singleVal['special_grid_block_open'] === 'no' && 
		   isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow']){
			$GLOBALS['rockthemes_pb_add_down_arrow'] = false;
			$return .= rockthemes_op_make_down_arrow($GLOBALS['rockthemes_pb_down_arrow_color']);
			$GLOBALS['rockthemes_pb_down_arrow_color'] = '#f9f9f9';
		}
		
			
			
			/*
			if($fullwidth_slider_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks']){
				$return .= '</div><div class="row after-fullwidth-slider"><div class="large-'.$singleVal['size_x'].' columns">';	
				$fullwidth_slider_active = false;
			}
			*/
			
			if(!$fullwidth_slider_active && !$fullwidth_screen_slider_active){
				$return .= '</div><div class="row">';
			}

			$columnsInRow = 1;
		}
		
		$animation_used = isset($singleVal['grid_data']['data']['data']['animation_type']) ? $singleVal['grid_data']['data']['data']['animation_type'] : '';

		if($animation_used !== ''){
			$animation_details = ' data-animation-class="'.$animation_used.'" data-animation-delay-time="'.$singleVal['grid_data']['data']['data']['animation_delay_time'].'"';
			$animation_main_class = 'rockthemes-animate';
		}
		
		if(isset($singleVal['grid_data']['data']['data']['use_shadow']) && $singleVal['grid_data']['data']['data']['use_shadow'] === 'true'){
			//$shadow_html = '<div class="hr-shadow-mask rotate-shadow"><hr class="hr-shadow active shadow-effect curve curve-hz-1"></div>';
			$shadow_html = azoom_image_shadow_up();
		}

		$last_shadow_html = $shadow_html;


		//Add Parallax 
		if($parallax_used && !$fullwidth_colored_active && $nosidebar_content !== 'false'){
			$sg_style = '';
			
			$special_grid_html_id_code = '';
			$special_grid_html_id = isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) ? $singleVal['grid_data']['data']['data']['special_grid_html_id'] : false;
			if(!empty($special_grid_html_id) && $special_grid_html_id){
				$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
			}
			
			$image_full_screen_data = '';
			$image_full_screen = (isset($singleVal['grid_data']['data']['data']['image_full_screen']) && $singleVal['grid_data']['data']['data']['image_full_screen'] === 'true') ? $singleVal['grid_data']['data']['data']['image_full_screen'] : false;
			if(!empty($image_full_screen) && $image_full_screen){
				$image_full_screen_data = 'data-rsb-fullscreen="true"';
			}
			
			$bg_style = '';
			if(isset($singleVal['grid_data']['data']['data']['image_bg_color']) &&
				$singleVal['grid_data']['data']['data']['image_bg_color'] !== 0){
				$bg_style = 'background:rgba('.rockthemes_hex2rgba($singleVal['grid_data']['data']['data']['image_bg_color'], (((int) $singleVal['grid_data']['data']['data']['image_bg_color_opacity']) / 100)).');';

				$sg_style .= ' '.str_replace('background','background-color',$bg_style);

				$bg_style = 'data-overlay-color="'.esc_attr($bg_style).'"';
			}
			
			$parallax_model = 'height_specific';//Default value
			if(isset($singleVal['grid_data']['data']['data']['parallax_model']) && $singleVal['grid_data']['data']['data']['parallax_model'] !== ''){
				$parallax_model = $singleVal['grid_data']['data']['data']['parallax_model'];	
			}
			
			$parallax_size = 'azoom-bgimage-cover';//Default value
			if(isset($singleVal['grid_data']['data']['data']['parallax_size']) && $singleVal['grid_data']['data']['data']['parallax_size'] !== ''){
				$parallax_size = 'azoom-bgimage-'.$singleVal['grid_data']['data']['data']['parallax_size'];	
			}
			
			$image_full_screen_ratio = isset($singleVal['grid_data']['data']['data']['image_full_screen_ratio']) ? $singleVal['grid_data']['data']['data']['image_full_screen_ratio'] : '16_9';
			$image_tile = isset($singleVal['grid_data']['data']['data']['image_tile']) ? $singleVal['grid_data']['data']['data']['image_tile'] : 'full';
			
			$image_full_url = esc_url($singleVal['grid_data']['data']['data']['parallax_bg_image']);

			if(isset($singleVal['grid_data']['data']['data']['parallax_bg_image_id']) && !empty($singleVal['grid_data']['data']['data']['parallax_bg_image_id'])){
				
				if(isset($singleVal['grid_data']['data']['data']['image_sizes']) && !empty($singleVal['grid_data']['data']['data']['image_sizes'])){
					$bg_image_size = esc_attr($singleVal['grid_data']['data']['data']['image_sizes']);
				}

				$image_full_url = wp_get_attachment_image_src($singleVal['grid_data']['data']['data']['parallax_bg_image_id'],$bg_image_size);
				if($image_full_url){
					$image_full_url = $image_full_url[0];
				}else{
					$image_full_url = rockthemes_demo_image($bg_image_size,true);	
				}
				
				$sg_style .= ' background-image:url('.$image_full_url.');';
			}
			
			//WP-Retina retina image
			$image_retina = rpb_wr2x_get_retina($image_full_url);
			
			//Close style
			if($sg_style != ''){
				$sg_style = 'style="'.$sg_style.'"';
			}

			//Do not add spaces before closing div. This way we can remove the empty divs.
			$return .= '</div>
			<div '.$special_grid_html_id_code.' class="rockthemes-parallax rockthemes-unique-grid '.esc_attr($parallax_size).' '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.(isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow'] ? 'down-arrow-active' : '').'" 
				data-parallax-model="'.esc_attr($parallax_model).'" 
				data-parallax-bg-image="'.esc_url($image_full_url).'" 
				'.($image_retina !== false ? 'data-parallax-bg-image-retina="'.$image_retina.'" ' : '').'
				data-parallax-mask-height="'.esc_attr($singleVal['grid_data']['data']['data']['parallax_mask_height']).'"
				data-parallax-padding="'.esc_attr($padding_class).'" 
				data-image-ratio="'.esc_attr($image_full_screen_ratio).'" 
				data-image-tile="'.esc_attr($image_tile).'" 
				'.$bg_style.' 
				'.$image_full_screen_data.' 
				'.$sg_style.'>
			<div class="row">';
			$fullwidth_colored_active = true;
		}
		
		//Add Background Image 
		if($background_img_used && !$fullwidth_colored_active && $nosidebar_content !== 'false'){
			$sg_style = '';
			
			$special_grid_html_id_code = '';
			$special_grid_html_id = isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) ? $singleVal['grid_data']['data']['data']['special_grid_html_id'] : false;
			if(!empty($special_grid_html_id)){
				$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
			}
			
			$image_full_screen_data = '';
			$image_full_screen = (isset($singleVal['grid_data']['data']['data']['image_full_screen']) && $singleVal['grid_data']['data']['data']['image_full_screen'] === 'true') ? $singleVal['grid_data']['data']['data']['image_full_screen'] : false;
			if(!empty($image_full_screen) && $image_full_screen){
				$image_full_screen_data = 'data-rsb-fullscreen="true"';
			}
			
			$bg_style = '';
			if(isset($singleVal['grid_data']['data']['data']['image_bg_color']) &&
				$singleVal['grid_data']['data']['data']['image_bg_color'] !== 0){
				$bg_style = 'background:rgba('.rockthemes_hex2rgba($singleVal['grid_data']['data']['data']['image_bg_color'], (((int) $singleVal['grid_data']['data']['data']['image_bg_color_opacity']) / 100)).');';
				
				$sg_style .= ' '.str_replace('background','background-color',$bg_style);
				
				$bg_style = 'data-overlay-color="'.esc_attr($bg_style).'"';
			}
			
			$image_full_url = $singleVal['grid_data']['data']['data']['parallax_bg_image'];

			if(isset($singleVal['grid_data']['data']['data']['parallax_bg_image_id']) && !empty($singleVal['grid_data']['data']['data']['parallax_bg_image_id'])){
				
				if(isset($singleVal['grid_data']['data']['data']['image_sizes']) && !empty($singleVal['grid_data']['data']['data']['image_sizes'])){
					$bg_image_size = $singleVal['grid_data']['data']['data']['image_sizes'];
				}

				$image_full_url = wp_get_attachment_image_src($singleVal['grid_data']['data']['data']['parallax_bg_image_id'],$bg_image_size);
				if($image_full_url){
					$image_full_url = $image_full_url[0];
				}else{
					$image_full_url = rockthemes_demo_image($bg_image_size, true);	
				}
				
				$sg_style .= ' background-image:url('.$image_full_url.');';
			}
			
			$image_full_screen_ratio = isset($singleVal['grid_data']['data']['data']['image_full_screen_ratio']) ? $singleVal['grid_data']['data']['data']['image_full_screen_ratio'] : '16_9';
			$image_tile = isset($singleVal['grid_data']['data']['data']['image_tile']) ? $singleVal['grid_data']['data']['data']['image_tile'] : 'full';

			//WP-Retina retina image
			$image_retina = rpb_wr2x_get_retina($image_full_url);
			
			//Close style
			if($sg_style != ''){
				$sg_style = 'style="'.$sg_style.'"';
			}
					
			//Do not add spaces before closing div. This way we can remove the empty divs.
			$return .= '</div>
			<div '.$special_grid_html_id_code.' class="rockthemes-static-bg-image rockthemes-unique-grid '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.(isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow'] ? 'down-arrow-active' : '').'" 
				data-static-bg-image="'.esc_url($image_full_url).'" 
				'.($image_retina !== false ? 'data-static-bg-image-retina="'.$image_retina.'" ' : '').'
				data-static-mask-height="'.esc_attr($singleVal['grid_data']['data']['data']['parallax_mask_height']).'" 
				data-padding="'.esc_attr($padding_class).'" 
				data-image-ratio="'.esc_attr($image_full_screen_ratio).'" 
				data-image-tile="'.esc_attr($image_tile).'" 
				'.$bg_style.' 
				'.$sg_style.' 
				'.$image_full_screen_data.'>
			<div class="row">';
			$fullwidth_colored_active = true;
		}
		
		//Add Background Video 
		if($background_video_used && !$fullwidth_colored_active && $nosidebar_content !== 'false'){
			$special_grid_html_id_code = '';
			$special_grid_html_id = isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) ? $singleVal['grid_data']['data']['data']['special_grid_html_id'] : false;
			if(!empty($special_grid_html_id)){
				$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
			}
			
			$video_bg_fallback_url = isset($singleVal['grid_data']['data']['data']['video_bg_fallback_url']) ? 'data-video_bg_fallback_url="'.$singleVal['grid_data']['data']['data']['video_bg_fallback_url'].'" ' : '';
			
			$video_bg_mute = '';
			if(isset($singleVal['grid_data']['data']['data']['video_bg_mute']) &&
				$singleVal['grid_data']['data']['data']['video_bg_mute'] &&
				$singleVal['grid_data']['data']['data']['video_bg_mute'] === 'true'){
				$video_bg_mute = 'mute="true"';
			}
			
			$video_html = '
				<video data-autoplay="true" loop '.($video_bg_mute !== '' ? 'muted' : '').' '.(isset($singleVal['grid_data']['data']['data']['video_bg_fallback_url']) ? 'poster="'.$singleVal['grid_data']['data']['data']['video_bg_fallback_url'].'"' : '').'>
				  <source src="'.esc_url($singleVal['grid_data']['data']['data']['video_bg_url']).'" type="video/mp4">
				</video>
			';
			
			//Check if it's a Youtube Video
			if(isset($singleVal['grid_data']['data']['data']['video_bg_youtube_url']) &&
				$singleVal['grid_data']['data']['data']['video_bg_youtube_url'] !== ''){
				$video_html = '[rockthemes_youtube_video autoplay="true" '.$video_bg_mute.']'.esc_url($singleVal['grid_data']['data']['data']['video_bg_youtube_url']).'[/rockthemes_youtube_video]';
			}

			//Check if it's a Vimeo Video
			if(isset($singleVal['grid_data']['data']['data']['video_bg_vimeo_url']) &&
				$singleVal['grid_data']['data']['data']['video_bg_vimeo_url'] !== ''){
				$video_html = '[rockthemes_vimeo_video autoplay="true" '.$video_bg_mute.']'.esc_attr($singleVal['grid_data']['data']['data']['video_bg_vimeo_url']).'[/rockthemes_vimeo_video]';
			}

			
			$bg_style = '';
			if(isset($singleVal['grid_data']['data']['data']['video_bg_color']) &&
				$singleVal['grid_data']['data']['data']['video_bg_color'] !== 0){
				
				$bg_style = 'background:rgba('.rockthemes_hex2rgba($singleVal['grid_data']['data']['data']['video_bg_color'], (((int) $singleVal['grid_data']['data']['data']['video_bg_color_opacity']) / 100)).');';

			}
			
			$data_details = '';
			if(isset($singleVal['grid_data']['data']['data']['video_bg_fullscreen']) &&
				$singleVal['grid_data']['data']['data']['video_bg_fullscreen'] == 'true'){
				$data_details = 'data-rsb-fullscreen="true"';//rsb Rockthemes Special Block
			}
			
			$data_ratio = 'data-rsb-ratio="16_9"';
			if(isset($singleVal['grid_data']['data']['data']['video_bg_ratio']) &&
				$singleVal['grid_data']['data']['data']['video_bg_ratio'] != ''){
				$data_ratio = 'data-rsb-ratio="'.esc_attr($singleVal['grid_data']['data']['data']['video_bg_ratio']).'"';//rsb Rockthemes Special Block
			}
			
			//Do not add spaces before closing div. This way we can remove the empty divs.
			$return .= '</div>
			<div '.$special_grid_html_id_code.' '.$data_details.' '.$data_ratio.' '.$video_bg_fallback_url.' class="rockthemes-video-bg rockthemes-unique-grid '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow'] ? 'down-arrow-active' : '').'">
				<div class="rockthemes-background-video">
					'.$video_html.'
				</div>
			<div class="rockthemes-video-background-content" style="'.esc_attr($bg_style).'"><div>';
			$background_video_active = true;
		}

		//Add Fullwidth colored (Colored Background)
		if($fullwidth_colored && !$fullwidth_colored_active && $nosidebar_content !== 'false'){
			$special_grid_html_id_code = '';
			$special_grid_html_id = isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) ? $singleVal['grid_data']['data']['data']['special_grid_html_id'] : false;
			if(!empty($special_grid_html_id)){
				$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
			}
			
			$bgcolor_fullscreen_data = '';
			$bgcolor_fullscreen = (isset($singleVal['grid_data']['data']['data']['bgcolor_fullscreen']) && $singleVal['grid_data']['data']['data']['bgcolor_fullscreen'] === 'true') ? $singleVal['grid_data']['data']['data']['bgcolor_fullscreen'] : false;
			if(!empty($bgcolor_fullscreen) && $bgcolor_fullscreen){
				$bgcolor_fullscreen_data = 'data-rsb-fullscreen="true"';
			}
			
			//Double background color
			$double_bg = (isset($singleVal['grid_data']['data']['data']['enable_double_bg_colors']) && 
							$singleVal['grid_data']['data']['data']['enable_double_bg_colors'] === 'true') ? true : false;
			$double_bg_data = '';
			$double_bg_class = '';
			if($double_bg){
				$double_bg_color = isset($singleVal['grid_data']['data']['data']['enable_double_bg_colors']) ? 
								esc_attr($singleVal['grid_data']['data']['data']['double_bg_color']) : '#f9f9f9';
				$double_bg_class = 'multi-bg-colors';
				$double_bg_data = 'data-multibg-colors="'.$background_color.','.$double_bg_color.'"';
				$background_color = rockthemes_make_split_bg_color($background_color, $double_bg_color);
			}else{
				$background_color = 'background:'.esc_attr($background_color).';';	
			}
						
			//Do not add spaces before closing div. This way we can remove the empty divs.
			$return .= '</div>
			<div '.$special_grid_html_id_code.' 
				class="rockthemes-fullwidth-colored rockthemes-unique-grid '.esc_attr($double_bg_class).' '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow'] ? 'down-arrow-active' : '').'" 
				style="'.(!$transparent_background ? $background_color : '').'"  
				'.$bgcolor_fullscreen_data.' 
				'.$double_bg_data.'>
					<div class="row">';
			$fullwidth_colored_active = true;
			
		}
		
		//Add Fullwidth for slider
		if($fullwidth_slider && !$fullwidth_slider_active && $nosidebar_content !== 'false'){
			$special_grid_html_id_code = '';
			$special_grid_html_id = isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) ? $singleVal['grid_data']['data']['data']['special_grid_html_id'] : false;
			if(!empty($special_grid_html_id)){
				$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
			}
			
			$full_bg_style = '';
			$enable_bg_color = isset($singleVal['grid_data']['data']['data']['fullbg_enable_color']) ? $singleVal['grid_data']['data']['data']['fullbg_enable_color'] : false;			
			if($enable_bg_color && $enable_bg_color !== 'false'){
				$full_bg_style = 'background:'.esc_attr($singleVal['grid_data']['data']['data']['full_bg_color']).';';
			}

			
			$return .= '</div><div '.$special_grid_html_id_code.' class="rockthemes-unique-grid rockthemes-fullwidth row collapse '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow'] ? 'down-arrow-active' : '').'" style="'.esc_attr($full_bg_style).'">';	
			$fullwidth_slider_active = true;
			//$return .= 'ADDED THE FULL WIDTH';
		}
		
		
		//Add Fullwidth Full Screen for slider
		if($fullwidth_screen_slider && !$fullwidth_screen_slider_active && $nosidebar_content !== 'false'){
			$special_grid_html_id_code = '';
			$special_grid_html_id = isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) ? $singleVal['grid_data']['data']['data']['special_grid_html_id'] : false;
			if(!empty($special_grid_html_id)){
				$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
			}
			
			$full_bg_style = '';
			$enable_bg_color = isset($singleVal['grid_data']['data']['data']['fullbg_enable_color']) ? $singleVal['grid_data']['data']['data']['fullbg_enable_color'] : false;
			if($enable_bg_color){
				$full_bg_style = 'background:'.esc_attr($singleVal['grid_data']['data']['data']['full_bg_color']).';';
			}
			
			$return .= '</div><div '.$special_grid_html_id_code.' class="rockthemes-unique-grid rockthemes-fullscreen row collapse '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow'] ? 'down-arrow-active' : '').'" data-rsb-fullscreen="true" style="'.esc_attr($full_bg_style).'">';	
			$fullwidth_screen_slider_active = true;
			//$return .= 'ADDED THE FULL WIDTH';
		}

		//Add All Regular Area
		//There was another rule in this 
		// && $nosidebar_content === 'false'
		// it removed.
		if($all_regular_area && !$all_regular_area_active){
			$special_grid_html_id_code = '';
			$special_grid_html_id = isset($singleVal['grid_data']['data']['data']['special_grid_html_id']) ? $singleVal['grid_data']['data']['data']['special_grid_html_id'] : false;
			if(!empty($special_grid_html_id)){
				$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
			}
			
			$return .= '<div '.$special_grid_html_id_code.' class="rockthemes-unique-grid large-12 columns '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($GLOBALS['rockthemes_pb_add_down_arrow']) && $GLOBALS['rockthemes_pb_add_down_arrow'] ? 'down-arrow-active' : '').'"><div>';	
			$all_regular_area_active = true;
		}
		
		
		//Escape values
		$singleVal['size_x'] = esc_attr($singleVal['size_x']);
		$singleVal['col'] = esc_attr($singleVal['col']);
		//Columns Div
		if((!$fullwidth_slider_active && !$fullwidth_screen_slider_active)|| (isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks'] !== 'open')){
		if($columnsInRow < intval($singleVal['col']) && $columnsInRow !== 0){
			if($animation_used !== ''){
				$return .= '<div class="large-'.$singleVal['size_x'].' large-offset-'.(intval($singleVal['col']) - $columnsInRow).' medium-'.$singleVal['size_x'].' medium-offset-'.(intval($singleVal['col']) - $columnsInRow).' columns '.$animation_main_class.'" '.$animation_details.'>';
			}else{
				$return .= '<div class="large-'.$singleVal['size_x'].' large-offset-'.(intval($singleVal['col']) - $columnsInRow).' medium-'.$singleVal['size_x'].' medium-offset-'.(intval($singleVal['col']) - $columnsInRow).' columns">';
			}
			
			$columnsInRow = intval($singleVal['size_x']) + intval($singleVal['col']);

		}else{
			if($animation_used !== ''){
				$return .= '<div class="large-'.$singleVal['size_x'].' medium-'.$singleVal['size_x'].' columns '.$animation_main_class.'" '.$animation_details.'>';
			}else{
				$return .= '<div class="large-'.$singleVal['size_x'].' medium-'.$singleVal['size_x'].' columns">';
			}
			
			$columnsInRow = $columnsInRow + intval($singleVal['size_x']);
		}
		}
		
			

		if(isset($singleVal['elems']) && !empty($singleVal['elems']) ){
			
			foreach($singleVal['elems'] as $singleElem){
				$return .= makeObjectWithDetails($singleElem);
			}
						
		}
		
		
		//Add Fullwidth for slider
		if($fullwidth_slider_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks']){
			$return .= '</div></div><div class="row after-fullwidth-slider"><div class="large-'.$singleVal['size_x'].' medium-'.$singleVal['size_x'].' columns">';	
			$fullwidth_slider_active = false;
		}


		if($fullwidth_screen_slider_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks']){
			$return .= '</div></div><div class="row after-fullwidth-slider"><div class="large-'.$singleVal['size_x'].' medium-'.$singleVal['size_x'].' columns">';	
			$fullwidth_screen_slider_active = false;
		}


		
		//Add Fullwidth colored (Colored Background)
		if($fullwidth_colored){
			//$return .= '</div>';	
		}

		//if(!$fullwidth_slider_active){
			//close columns div
			$return .= '</div>';
		//}
		
	}
	
	if($columnsInRow <= 12 && $columnsInRow !== 1)	$return .= '<div class="large-'.(13 - $columnsInRow).' medium-'.(13 - $columnsInRow).' columns"></div>';
	
	if($return !== ''){
		$main_return = '<div class="row">'.$return.'</div>';
	}
	
	
	if($fullwidth_colored_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks']){
		$main_return .= $last_shadow_html;
		$main_return .= '</div>';
		$fullwidth_colored_active = false;	
	}
	
	if($fullwidth_slider_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks']){
		$main_return .= '</div></div>';
		$fullwidth_slider_active = false;	
	}
	
	if($fullwidth_screen_slider_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks']){
		$main_return .= '</div></div>';
		$fullwidth_screen_slider_active = false;	
	}
	
	if($background_video_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && !$GLOBALS['rockthemes_pb_specialgridblocks']){
		$main_return .= '</div></div>';
		$background_video_active = false;	
	}
	
	if($all_regular_area_active && isset($GLOBALS['rockthemes_pb_specialgridblocks']) && (!$GLOBALS['rockthemes_pb_specialgridblocks'])){
		$all_regular_area_active = false;
	}
	
	/*
	**	Remove empty rows and empty columns
	**
	**	@since	:	1.3
	**
	*/
	$main_return = str_replace('<div class="large-12 medium-12 columns"></div>','',$main_return);
	$main_return = str_replace('<div class="row"></div>','',$main_return);
	
	return $main_return;
}




/*
**	Generates object with details.
**
**	@TO DO	:	This function name will be changed
**	@since	:	1.0
*/
function makeObjectWithDetails($elem){
	$frontend_editor = true;
	$return = '';
	
	//There wasn't any $return variable. Values was using direct "return" to return the value. Variable used for frontend editor
	switch($elem['descType']){
		case 'textarea':
		
		$txt = $elem['desc'];
		
		if(defined('RPB_FULL_SHORTCODE')){
			//rpb_rtext = RPB Rich Text
			$txt = '[rpb_rtext]'.$txt.'[/rpb_rtext]';
		}else{
			//Disable paragraphs around shortcodes
			$txt = str_replace('<p>[', '[', $txt);
			$txt = str_replace(']</p>', ']', $txt);
			$txt = rpb_filtered_content($txt);
			$txt = '<div class="azoom-text-details">'.$txt.'</div>';
		}
		$return .= $txt;
		break;	
		
		case 'textfield':
		$return .= $elem['desc'];
		break;
		
		case 'ajaxfiltered':
		$return .= $elem['desc'];
		break;
		
		case 'swiperslider':
		$return .= $elem['desc'];
		break;
		
		case 'sidebar':
		/*This is not shortcode for now. According to Themeforest new rules, this can be turn into a shortcode*/
		ob_start();
		dynamic_sidebar($elem['desc']);
		$return .= '<div class="sidebar-area">'.ob_get_clean().'</div>';
		break;
		
		case 'toggles':
		$return .= $elem['desc'];
		break;
		
		case 'tabs':
		$return .= $elem['desc'];
		break;
		
		case 'iconictext':
		$return .= $elem['desc'];
		break;
		
		case 'button':
		$return .= $elem['desc'];
		break;
		
		case 'rockformbuilder':
		$return .= $elem['desc'];
		break;
				
		default :
		$return .= $elem['desc'];
		break;
	}
/*
	if(defined('RPB_CONTENT_FILTER')){
		rockthemes_pb_the_content_filter_disable();
		$return = apply_filters('the_content', $return);
		rockthemes_pb_the_content_filter_enable();	
	}
*/
	//TO DO : This return will be removed and the below code will be activated for frontend editor
	return $return;
	
	//Frontend editor codes
	if($frontend_editor){
		$return = '<div class="relative-container"><div class="awesome-editor"></div>'.$return.'</div>';
		return $return;	
	}elseif($return !== ''){
		return $return;	
	}
	return '';
}










/*
**	DEPRECATED. New version of RPB saves raw data in post meta, saves content in Wordpress's TinyMCE text area.
**	Yoast Fix for RPB Content.
**	Currently Disabled because of Yoast didn't make the filter work for Keyword count in "General"
**
**	https://github.com/Yoast/wordpress-seo/issues/393
**
**	@since	:	1.3
**
*/
function rockthemes_pb_yoast_af($content, $post_in){
	global $post;
	if(empty($post)){
		if(!empty($post_in)){
			$post = $post_in;	
		}else{
			$post = get_post(get_queried_object_id());	
		}
	}
	
	

	//$GLOBALS['post'] = $post_in;//get_post(get_queried_object_id());
	$rpb_data = '';

	ob_start();
	
	rockthemes_pb_frontend_display_nosidebar_content_header(true); //do_action('rockthemes_pb_frontend_before_header');
	rockthemes_pb_frontend_display_nosidebar_content_before(true); //do_action('rockthemes_pb_frontend_before_page');
	echo rockthemes_pb_wp_content_filter(get_the_content(), true);
	rockthemes_pb_frontend_display_nosidebar_content_after(true); //do_action('rockthemes_pb_frontend_after_page');
	
	$rpb_data = ob_get_contents();
	ob_get_clean();
	
	
	//remove_filter('wpseo_pre_analysis_post_content','rockthemes_pb_yoast_af');

	return $rpb_data;
	
	//return $content;
	
}
//add_filter('wpseo_pre_analysis_post_content', 'rockthemes_pb_yoast_af', 100, 2);




/*
**	This filter applies any page template not related to this theme. If Rock Page Builder contains Featured Image
**	This function will remove the regular featured image
*/
function rockthemes_pb_thumbail_filter($html) {
	global $post;
	
	if(is_admin()){
		return $html;	
	}
	
	$qo = get_queried_object();
		
   	if(rockthemes_pb_featured_in_builder() === "true" && !empty($qo) && isset($qo->ID) && $qo->ID == $post->ID){
		$in_use = get_post_meta($post->ID,'_builder_in_use',true);
		
		if(isset($in_use) && $in_use !== 'false' && is_single($post)) return;
	}
	return $html;
}

add_filter('post_thumbnail_html', 'rockthemes_pb_thumbail_filter', 99, 1);


/*
**	Add the inlinve navigation. 
**
**	@Alias	:	rockthemes_pb_frontend_gather_nav_grids
**
**	@echo	:	HTML formatted inline navigation
**	@since	:	1.3
*/
function rockthemes_pb_frontend_make_inline_nav(){
	global $post;

	if(empty($post)) return;
	
    if(!is_single() && !is_page()) return;
	
	//Check if page-builder in use
	
	if(!defined('RPB_FULL_SHORTCODE')){
		$in_use = get_post_meta($post->ID,'_builder_in_use',true);
		if(!isset($in_use) || $in_use === 'false'){
			$GLOBALS['rockthemes_frontend_inline_nav'] = get_post_meta($post->ID, '_rockthemes_inline_nav');
			if($GLOBALS['rockthemes_frontend_inline_nav'] !== false && is_array($GLOBALS['rockthemes_frontend_inline_nav']) && isset($GLOBALS['rockthemes_frontend_inline_nav'][0])){
				$GLOBALS['rockthemes_frontend_inline_nav'] = $GLOBALS['rockthemes_frontend_inline_nav'][0];	
			}
		}
	}


	//Check if inline nav activated
	if(rad_get_option('display_inline_nav') !== 'true') return;
	
	if(empty($GLOBALS['rockthemes_frontend_inline_nav']) || !is_array($GLOBALS['rockthemes_frontend_inline_nav']) || count($GLOBALS['rockthemes_frontend_inline_nav']) < 1) return;
	$return = '<div id="rockthemes-inline-nav"><ul>';
	
	foreach($GLOBALS['rockthemes_frontend_inline_nav'] as $key => $val){
		$return .= '<li id="rin-'.esc_attr($key).'" class="rockthemes-inline-nav-elem azoom-transition-fast deactive"><span class="rin-title azoom-transition-fast">'.esc_html($val).'</span><span class="rin-handler"></span></li>';
	}
	
	$return .= '</ul></div>';//rockthemes-inline-nav
	
	
	echo rockthemes_escaped_out_render($return);
}
add_action('rockthemes_pb_frontend_after_page','rockthemes_pb_frontend_make_inline_nav', 99);





function rockthemes_pb_frontend_make_gototop(){

	//If go to top is not enabled, then return
	if(function_exists('xr_get_option') && xr_get_option('enable_gototop', false) === false) return;

	//If go to top with inline navigation is disabled, and inline navigation has menu items, then return,
	if(function_exists('xr_get_option') && xr_get_option('enable_gototop_with_rin', false) === false && isset($GLOBALS['rockthemes_frontend_inline_nav']) && count($GLOBALS['rockthemes_frontend_inline_nav']) > 0) return;
	
	//Go to Top button.
	$return = '<div id="azoom-go-to-top" class="azoom-transition-fast"><i class="icomoon icomoon-icon-arrow-up6"></i></div>';
	echo rockthemes_escaped_out_render($return);
}
add_action('rockthemes_pb_frontend_after_page','rockthemes_pb_frontend_make_gototop', 99);







/*
**	Add Footer to the Inline Navigation
**
**	@since	:	1.3
*/
/*
function rockthemes_pb_frontend_rin_add_footer(){
	$footer_id = rad_get_option('rin_footer_id', '');	
	$footer_title = rad_get_option('rin_footer_title', '');
	if($footer_id && $footer_title){
		$GLOBALS['rockthemes_frontend_inline_nav'][$footer_id] = $footer_title;
	}	
}
add_action('rockthemes_pb_frontend_after_page','rockthemes_pb_frontend_rin_add_footer', 35);
*/






if(!function_exists('rockthemes_pb_num_to_string')):
function rockthemes_pb_num_to_string($num){
	$numArray = array(1,2,3,4,5,6,7,8,9,10,11,12);
	$stringArray = array('one','two','three','four','five','six','seven','eight','nine','ten','eleven','twelve');
	
	return str_replace($numArray,$stringArray,(int)$num);
}
endif;

if(!function_exists('rockthemes_pb_string_to_num')):
function rockthemes_pb_string_to_num($str){
	$numArray = array(1,2,3,4,5,6,7,8,9,10,11,12);
	$stringArray = array('one','two','three','four','five','six','seven','eight','nine','ten','eleven','twelve');
	
	return str_replace($stringArray,$numArray,$str);
}
endif;

if(!function_exists('rockthemes_pb_element_to_string')):
function rockthemes_pb_element_to_string($element){
	$return = '';
	switch($element){
		case 'textfield':
		$return = 'Text Field';
		break;


		case 'textarea':
		$return = 'Text Area';
		break;


		case 'image':
		$return = 'Image';
		break;
		
		
		case 'ajaxfiltered':
		$return = 'Ajax Filtered Gallery';
		break;
		
		
		case 'featuredimage':
		$return = 'Featured Image';
		break;		
		
		case 'swiperslider':
		$return = "Swiper Slider";
		break;
		
		case "pricingtable":
		$return = "Pricing Table";
		break;
		
		case "curvyslider":
		$return = "Curvy Slider";
		break;
		
		case "sidebar":
		$return = "Sidebar";
		break;
		
		case "toggles":
		$return = "Toggles";
		break;
		
		case "tabs":
		$return = "Tabs";
		break;
		
		case "iconictext":
		$return = "Iconic Text";
		break;
		
		case "button":
		$return = "Button";
		break;
				
		case "skill":
		$return = "Skill";
		break;
		
		case "horizontalrule":
		$return = "HR";
		break;
		
		case "verticalspace":
		$return = "Vertical Space";
		break;
		
		case "portfolio":
		$return = "Portfolio";
		break;
		
		case "rockformbuilder":
		$return = "Rock Form Builder";
		break;
		
		case "googlemap":
		$return = "Google Map";
		break;

		case "leafletmap":
		$return = "LeafLet Map";
		break;

		case "promotionbox":
		$return = "Promotion Box";
		break;
		
		case "alertbox":
		$return = "Alert Box";
		break;
		
		case "referencesbuilder":
		$return = "References Builder";
		break;
		
		case "testimonialsbuilder":
		$return = "Testimonials Builder";
		break;
		
		case "socialicons":
		$return = "Social Icons";
		break;
		
		case "teammembers":
		$return = "Team Members";
		break;
		
		case "beforeafterslider":
		$return = "Before After Slider";
		break;
		
		case "externalshortcode":
		$return = "External Code";
		break;
		
		case "regularblog":
		$return = "Regular Blog";
		break;
		
		case "hoverelement";
		$return = "Hover Element";
		break;
		
		case "achievement":
		$return = "Achievement";
		break;
		
		case "heading":
		$return = "Heading";
		break;
		
		case "stepselement":
		$return = "Steps";
		break;
		
		case "singleimage":
		$return = "Image";
		break;
		
		case "youtube":
		$return = "Youtube";
		break;
		
		case "vimeo":
		$return = "Vimeo";
		break;
		
		case "htmlvideo":
		$return = "HTML5 Video";
		break;
		
		case "gallery":
		$return = "Gallery";
		break;
		
		case "revolutionslider":
		$return = "Revolution Slider";
		break;
	}
		
	return $return;
}
endif;


?>