<?php

/*
**	Rock Page Builder UI
**
**	Alias	:	Rock Builder UI		Located in "rock-builder/builder-functions.php"
**	Alias	:	Rock Builder		Located in "rock-builder/rock-builder.php"
**	Author	:	Rockthemes.net
**	License	:	Contact to rockthemes.net for further information
**	Version	:	1.3
**
**	Generates the layout and the modals of the Rock Page Builder
*/

//Return if not in WP Admin - Higher Performance optimization
if ( !(defined( 'WP_ADMIN' ) && WP_ADMIN ) &&  !( defined( 'DOING_AJAX' ) && DOING_AJAX )) return;

/*
**	Returns the data of the saved page builder templates.
**
**	@return	:	The data will be json_encoded
*/
function rockthemes_pb_get_export_data(){
	$references	=	get_option('rock_builder_references',false);
	if(!$references) return false;
		
	$datas				=	array();		
	
	foreach($references as $ref){
		$datas[] = get_option($ref['database_name'],array());
	}
	
	return json_encode(
				array(
					'references'	=>	($references),
					'datas'			=>	$datas,
					'site_url'		=>	home_url(),
					'media_url'		=>	wp_upload_dir()
				)
			);
}



function rockthemes_pb_import($data){
	
	if(!is_array($data)){
		$main_decoded = json_decode(($data),true);
		if(!is_array($main_decoded)){
			$main_decoded = json_decode(stripslashes($data),true);
		}

		$data = $main_decoded;
	}	
	
	$old_site_url = $data['site_url'];
	$current_site_url = home_url();
	
	if(isset($data['media_url']) && isset($data['media_url']['baseurl']) && $data['media_url']['baseurl'] !== ''){
		$omu = $data['media_url']['baseurl'];	
	}
	
	if(isset($omu) && $omu && $omu !== ''){
		$old_site_url = $omu;
		$nmu = wp_upload_dir();
		$current_site_url = $nmu['baseurl'];
	}
	
	$old_site_url_slashed = str_replace('/', '\\/', $old_site_url);
	$current_site_url_slashed = str_replace('/', '\\/', $current_site_url);
	
	$old_references = get_option('rock_builder_references', array());
	$database_id = 0;
	if(count($old_references) <= 0){
		$database_id = 0;
		$old_references = array();
	}else{
		$last = end($old_references);
		$database_id = (intval(str_replace("rock_builder_template_","",$last['database_name'])) + 1);
	}
	
	//Import references
	//$references_imported = update_option('rock_builder_references', ($data['references']));
			
	//Import form datas
	$count = 0;
	foreach($data['datas'] as $page_template){
		
		if(is_array($page_template)){
			$page_template = json_encode($page_template);	
		}
		
		$database_name = 'rock_builder_template_'.$database_id;
		$template_name = $data['references'][$count]['name'];
		
		foreach($old_references as $or){
			if($or['name'] === $template_name){
				$template_name .= ' 1';	
			}
		}
		
		$old_references[] = array('database_name' =>$database_name, 'name' => $template_name);
		
		$page_template = str_replace($old_site_url, $current_site_url, $page_template);
		$page_template = str_replace($old_site_url_slashed, $current_site_url_slashed, $page_template);
		
				
		update_option($database_name, ($page_template));
		
		$database_id++;
		$count++;
		
	}
	
	update_option('rock_builder_references', ($old_references));
	
	echo "success";
}




function get_saved_rock_builders_as_list($selected = null,$echo = null){
	
	if(isset($_REQUEST['selected'])) $selected = $_REQUEST['selected'];
	
	$builderReferences = get_option("rock_builder_references",false);
	
	if(!$builderReferences) return;
	
	$return = '';
	
	$return = '<select class="rock-builder-template-list" autocomplete="off">';
	
	$return .= '<option value="no_template" '.(!$selected ? 'selected="selected"' : '').'>Choose a Template</option>';
	
	
	
	foreach ($builderReferences as $key => $value) {

		$ref_name[$key] = $value['name'];
			
	}
	
	array_multisort($ref_name, $builderReferences);
	
	
	foreach($builderReferences as $ref){
		if($selected == $ref['database_name']){
			$return .= '<option value="'.$ref['database_name'].'" selected>'.$ref['name'].'</option>';
		}else{
			$return .= '<option value="'.$ref['database_name'].'">'.$ref['name'].'</option>';
		}
	}
	
	$return .= '</select>';
	
	if($echo){
		echo rockthemes_escaped_out_render($return);
	}else{
		return $return;
	}
	
	exit;
}
function get_saved_rock_builders_as_list_ajax(){
	get_saved_rock_builders_as_list('',true);	
	exit;
}
add_action('wp_ajax_get_rock_builder_references_list', 'get_saved_rock_builders_as_list_ajax');


function rock_builder_save_template(){
	if(!rpb_is_admin()) die();
	if(!isset($_REQUEST['data']) || !isset($_REQUEST['template'])) die();
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rpb_save') ||
		!check_ajax_referer('rpb_save')) {
			
		//Die
		die();
	}

	$data = rpb_admin_save_validate_data($_REQUEST['data']);
	if($data === false) die();
	$data = json_encode($data);
	
	$template = $_REQUEST['template'];
	
	$templateName = sanitize_text_field($template['name']);
	$templateDBName = 'rock_builder_template_'.intval($template['database_name']);
		
	update_option($templateDBName, $data);
	
	$builderReferences = get_option("rock_builder_references",array());
	
	$i = 0;
	foreach($builderReferences as $ref){
		if($ref['database_name'] == $templateDBName){
			$builderReferences[$i]['name'] = $templateName;
			update_option("rock_builder_references",$builderReferences);
			break;
		}
		$i++;
	}
	
	exit;
}
add_action("wp_ajax_rockAjax_save_builder_template","rock_builder_save_template");


function rock_builder_delete_template(){
	if(!rpb_is_admin()) die();
	if(!isset($_REQUEST['database_name'])) die();
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rpb_save') ||
		!check_ajax_referer('rpb_save')) {
			
		//Die
		die();
	}
	
	$templateDBName = 'rock_builder_template_'.intval($_REQUEST['database_name']);
		
	$builderReferences = get_option("rock_builder_references",array());
	
	$i = 0;
	foreach($builderReferences as $ref){
		if($ref['database_name'] == $templateDBName){
			array_splice($builderReferences, $i, 1);
			update_option("rock_builder_references",$builderReferences);
			break;
		}
		$i++;
	}
	
	delete_option($templateDBName);
	
	echo "SUCCESS";
	
	exit;
}
add_action("wp_ajax_rockAjax_delete_builder_template","rock_builder_delete_template");


function rock_builder_add_new_template(){
	if(!rpb_is_admin()) die();
	if(!isset($_REQUEST['data']) || !isset($_REQUEST['name'])) die();
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rpb_save') ||
		!check_ajax_referer('rpb_save')) {
			
		//Die
		die();
	}
	
	//Sanitize data
	$data = rpb_admin_save_validate_data($_REQUEST['data']);
	if($data === false) die();
	
	$data = json_encode($data);
	
	$name = esc_html(sanitize_text_field($_REQUEST['name']));
	
	$databaseName = '';
	
	$builderReferences = get_option("rock_builder_references",array());
	
	if(count($builderReferences) <= 0){
		$builderReferences[] = array('database_name' => 'rock_builder_template_0', 'name'=>$name);	
		$databaseName = "rock_builder_template_0";
	}else{
		$last = end($builderReferences);
		$databaseName = "rock_builder_template_".(intval(str_replace("rock_builder_template_","",$last['database_name'])) + 1);
		$builderReferences[] = array('database_name' =>$databaseName, 'name' => $name);
	}
	
	update_option("rock_builder_references",$builderReferences);
			
	update_option($databaseName, ($data));
	
	echo "Success";
	
	exit;
}
add_action("wp_ajax_rockAjax_add_new_builder_template","rock_builder_add_new_template");



function rock_builder_load_template(){
	if(!rpb_is_admin()) die();
	if(!isset($_REQUEST['postID']) || !isset($_REQUEST['loadTemplateDatabaseName']) || !isset($_REQUEST['_featured_image_in_builder'])) die();
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rpb_save') ||
		!check_ajax_referer('rpb_save')) {
			
		//Die
		die();
	}
	
	$postID = intval($_REQUEST['postID']);
	if(!is_string( get_post_status( $postID ))) die('POST DOES NOT EXISTS');
	
	$loadTemplateDatabaseName = 'rock_builder_template_'.intval($_REQUEST['loadTemplateDatabaseName']);
	$_featured_image_in_builder = $_REQUEST['_featured_image_in_builder'] === 'true' ? 'true' : 'false';
	
	$data = get_option($loadTemplateDatabaseName, false);
		
	if(!$data) return "ERROR : Data not exists";
	
   	update_post_meta($postID, '_this_r_content', addslashes($data) );  
	update_post_meta($postID, '_builder_in_use', 'true');
	update_post_meta($postID, '_featured_image_in_builder', $_featured_image_in_builder);
	
	echo "Success";
	
	exit;
}
add_action("wp_ajax_rockAjax_load_builder_template","rock_builder_load_template");



function rock_pages_ui(){
	global $post;
	
	
    $val = get_post_meta( $post->ID, '_this_r_content', true );
	
	//Remove any additional line breaks. Some PHP versions adds line breaks during json_encode / json_decode	
	$val = preg_replace( "/\r|\n/", "", $val);
	
	//Try to decode the value. Some servers automatically strips slashes
	$decode_val = (json_decode(($val), true));

	//If value is not turned into an array with json_decode then stripslashes and decode. This server do not automatically removes slashes
	if(!is_array($decode_val)){
		$decode_val = (json_decode(stripslashes($val), true));
	}

	//Set final array value to regular $val variable
	$val = $decode_val;
		
	
	//Check if val is empty after decode
	if(!empty($val)):

	foreach ($val as $key => $value) {

		$col[$key] = $value['col'];
		
		$row[$key] = $value['row'];
	
	}
	
	array_multisort($row, $col, $val);
	endif;
	$modals = array();
	$gridModals = array();
	
	//960 Grid or 1090 Grid
	$chosen_layout_width = 1060;
	$chosen_layout_padding = 15;
	
	//Start special grid block modals holder as an array
	$specialGridBlockModals = array();
	
	$widget_move = defined('RPB_S_WIDGET_MOVE') ? '<i title="Quick Move This Grid" class="fa fa-external-link-square rpb-move-widget-from"></i><i title="Leave Grid Here" class="fa fa-map-marker rpb-move-widget-to"></i> ' : '';

	echo '
	<div class="rock-builder-actions" ref="'.$post->ID.'">
		<div class="row-fluid">
			<div class="span4">
				<h4>Choose A Custom Page</h4>
			</div>
			<div class="span3">
				<h4>Template Name</h4>
			</div>
			<div class="span5">
				<h4>Actions</h4>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span4 template-list-holder">
				'.get_saved_rock_builders_as_list().'
			</div>
			<div class="span3">
				<input autocomplete="off" type="text" autocomplete="off" name="template_name" class="template_name" val="" />
			</div>
			<div class="span5">
				<div class="btn btn-success btn-mini save_current_template_button" data-toggle="tooltip-main" title="Save the changes of current template">Save</div>
				<div class="btn btn-danger btn-mini delete_current_template_button" data-toggle="tooltip-main" title="Delete current template">Delete</div>
				<div class="btn btn-primary btn-mini load_current_template_button" data-toggle="tooltip-main" title="Load and bind the current template">Load</div>
				<div class="btn btn-mini add_new_template_button" data-toggle="tooltip-main" title="Add new template. (Make sure you have filled the template name)"><i class="fa fa-plus"></i> Add New</div>
			</div>
		</div>
	</div>
	<br/>
	
				
	<div class="main_page_builder" layout_width="'.$chosen_layout_width.'" layout_padding="'.$chosen_layout_padding.'" >
		<div class="gridster">
			<ul>';
				$elemID = 0;
				$gridID = 0;
				$specialGridID = 1;

				if(!empty($val)):
					foreach($val as $element){
						$hidden = '';
						$gridElems = '';
						//Escape any saving errors (Connection loss, data loss during save)
						if(!isset($element['grid_data'])) continue;
						if(isset($element['elems']) && !empty($element['elems'])):
							
						foreach($element['elems'] as $elem){
							if(!isset($elem['id'])){
								$elemID++;
							}else{
								$elemID = str_replace('modal-','',$elem['id']);
							}
								
							if(isset($elem)){
								if($elem['descType'] == 'textarea'){
									$hidden = $elem ? $elem : "";
									$hidden = $elem['desc'];
								}else{
									$modals[] = array('id' => 'modal-'.$elemID, 'modal' => $elem);
								}
								$descType = rockthemes_pb_element_to_string($elem['descType']);

							}
							$gridElems .= '<div id="elem-'.$elemID.'" class="builder-element" elem-type="'.$elem['descType'].'"><div class="hide secret-desc" data-text="'.esc_attr($hidden).'"></div><div class="elem-content"><span class="elem-name"><i class="drag fa fa-arrows"></i> '.rockthemes_pb_element_to_string($elem['descType']).'</span><span class="alignright"><i class="fa fa-edit icon-black element-edit-btn"></i><i class="fa fa-copy element-copy-btn"></i><i class="fa fa-times icon-black element-remove-btn"></i></span><div class="clear"></div></div></div>';
						}//End of $element['elems'] loop
						endif;//Check if $element['elems'] exists and not empty
						
						if(isset($element['special_grid_block']) && $element['special_grid_block'] === 'yes'){
							$specialGridBlockID = str_replace('specialgridblock-open-', '', $element['id']);
							$specialGridBlockID = str_replace('specialgridblock-close-', '', $specialGridBlockID);
							
							if($element['special_grid_block_open'] === 'yes'){
								//Open Special Block
								echo '<li id="specialgridblock-open-'.$specialGridBlockID.'" class="gridsterli specialgridblock block-open" data-row="'.$element['row'].'" data-col="'.$element['col'].'" data-sizex="12" data-sizey="1"><div class="grid-header"><strong>Special Grid Open - <span class="columns-num">Block : '.$specialGridBlockID.'</span></strong><span class="alignright ">'.$widget_move.'<i class="fa fa-gear icon-black specialgridblock-edit-btn"></i> <i class="fa fa-times icon-black specialgridblock-remove-btn"></i></span></div></li>';
							
								$specialGridBlockModals[] = array('id'=> 'modal-specialgridblock-'.$specialGridBlockID, 'modal'=>$element['grid_data']);
							}else{
								//Open Special Block
								echo '<li id="specialgridblock-close-'.$specialGridBlockID.'" class="gridsterli specialgridblock block-close" data-row="'.$element['row'].'" data-col="'.$element['col'].'" data-sizex="12" data-sizey="1"><div class="grid-header"><strong>Special Grid Close - <span class="columns-num">Block : '.$specialGridBlockID.'</span></strong><span class="alignright ">'.$widget_move.' <i class="fa fa-times icon-black specialgridblock-remove-btn"></i></span></div></li>';
								$specialGridID++;
							}
						}else{
							echo '<li id="grid-'.$gridID.'" class="gridsterli" data-row="'.$element['row'].'" data-col="'.$element['col'].'" data-sizex="'.$element['size_x'].'" data-sizey="3"><div class="grid-header"><span class="columns-num">'.rockthemes_pb_string_to_num($element['size_x']).'</span> <i class="fa fa-chevron-left columns-minus"></i> <i class="fa fa-chevron-right columns-plus"></i><span class="alignright ">'.$widget_move.'<i class="fa fa-gear icon-black grid-edit-btn"></i> <i class="fa fa-copy icon-black grid-copy-btn"></i> <i class="fa fa-times icon-black columns-remove-btn"></i></span></div><div class="grid-content">'.$gridElems.'<i class="fa fa-plus fa-2x add-element-in-grid-btn"></i></div></li>';
							$grid=array();
	
							$gridModals[] = array('id'=> 'modal-grid-'.$gridID, 'modal'=>$element['grid_data']);
									
							$gridID++;
						}
					}//End of $val loop
				else:
					if(function_exists('xr_get_option') && xr_get_option('auto_add_featured_image_to_builder','YES')){
									
						$singleElem = '<div id="elem-'.$elemID.'" class="builder-element" elem-type="featuredimage"><div class="hide secret-desc"></div><div class="elem-content"><span class="elem-name"><i class="drag fa fa-arrows"></i> Featured Image</span><span class="alignright"><i class="fa fa-edit icon-black element-edit-btn"></i><i class="fa fa-copy element-copy-btn"></i><i class="fa fa-times icon-black element-remove-btn"></i></span><div class="clear"></div></div></div>';
						echo '<li id="grid-'.$gridID.'" class="gridsterli" data-row="1" data-col="1" data-sizex="8" data-sizey="3"><div class="grid-header"><span class="columns-num">'.rockthemes_pb_string_to_num(8).'</span> <i class="fa fa-chevron-left columns-minus"></i> <i class="fa fa-chevron-right columns-plus"></i><span class="alignright ">'.$widget_move.'<i class="fa fa-gear icon-black grid-edit-btn"></i> <i class="fa fa-copy icon-black grid-copy-btn"></i> <i class="fa fa-times icon-black columns-remove-btn"></i></span></div><div class="grid-content">'.$singleElem.'<i class="fa fa-plus fa-2x add-element-in-grid-btn"></i></div></li>';
								
						$modals[] = array('id' => 'modal-'.$elemID, 'modal' => array('id'=>'elem'.$elemID,'descType'=>'featuredimage','data' => array('data' =>'large')));
								
						$grid_data = array('id'=>$gridID,'data'=>array('avoid_sidebar'=>false));
						$gridModals[] = array('id'=> 'modal-grid-'.$gridID, 'modal'=>$grid_data);
						$gridID++;
						$elemID++;							
					}
				endif;
								
	echo '
			</ul>
		</div>
	</div>';
			
			
	echo '
	<div class="builder-menu">
		'.rock_pages_builder_menu().'
	</div>
	<br/>
	';

	echo '<div id="modal-holder">';

	//get all modals 
	echo rockthemes_pb_make_modals($modals);
	echo rockthemes_pb_make_grid_modals($gridModals);
	echo rockthemes_pb_make_specialgridblock_modals($specialGridBlockModals);
	echo rockthemes_pb_element_list_modal();
	
	if(isset($GLOBALS['xr_colorpickers']) && is_array($GLOBALS['xr_colorpickers']) && count($GLOBALS['xr_colorpickers'])){
		$colorpickerScript = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					var ids = '.json_encode($GLOBALS['xr_colorpickers']).';

					for (var i=0; i<ids.length; i++){
						jQuery("#"+ids[i]).wpColorPicker();	
					}
				});
			</script>
		';	
		
		echo rockthemes_escaped_out_render($colorpickerScript);
	}
	
	echo '</div>';//Close modal holder
	
	echo '<div class="hide rpb-tiny-default-settings">';
	wp_editor('', 'rpb_gutenberg_tinymce');
    \_WP_Editors::enqueue_scripts();
	\_WP_Editors::editor_js();
	echo '</div>';
	
	echo '<div id="text-area-modal-holder" class="row hide">';
	
	echo '
			<div id="text-area-modal" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-header">
					<div class="close builder-close"><i class="fa fa-times"></i></div>
					<h3>Text Area</h3>
				</div>
				<div class="modal-body" data-saved="false">
		';

	//New TinyMCE
	echo '											
					<div class="rock-tinymce-container wp-core-ui wp-editor-wrap tmce-active">
						<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
							<div class="wp-editor-tabs">
								<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
								<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
							</div>
							<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="main-textarea-modal" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
						</div>
						<div class="wp-content-editor-container wp-editor-container">
							<textarea autocomplete="off" rows="8" cols="40" name="main-textarea-modal" id="main-textarea-modal" class="rock-tinymce-textarea wp-editor-area"></textarea>
						</div>
					</div>
	';
	
	echo '
				</div>
				<div class="modal-footer">
					<div class="btn builder-close">Close</div>
					<div id="save-textarea-data" class="btn btn-primary" ref="text-area-modal">Save changes</div>
				</div>
	';				
		echo '</div>';
	echo '</div>';
	
	$_builder_in_use_data = get_post_meta($post->ID, '_builder_in_use', true);
	$_builder_in_use = checked("true", ($_builder_in_use_data), false);
		
	//Clear any unwanted floats
	echo '<div class="clearfix"></div>';
	
	//Save All Settings
	echo '
	<div class="rockthemes-pb-save-button-container hide">
		<input autocomplete="off" autocomplete="off" type="checkbox" value="1" name="_builder_in_use" id="_builder_in_use" '.$_builder_in_use.' />
		<strong>
			<label for="_builder_in_use" style="color:#ff0000;"> Use Rock Page Builder</label>
		</strong>
		<br/>
		<p>If you are using Rock Page Builder, make sure this option is checked. If this option is not checked, you will be using the regular content area </p>
		<br/>
		<div class="rockthemes-pb-save-important-notice">
			<strong>!Important</strong>
			<br/>
			You need to click "Save" button to save Rock Page Builder Content
		</div>
		<div class="rockthemes-pb-save-container">
			<strong class="alignleft" style="margin-top:4px;">Save Page Builder :</strong>
			<div way="'.AZOOM_PLUGIN_URI.'" data-page-id="'.esc_attr($GLOBALS['post']->ID).'" id="save-current-settings-btn" class="btn btn-success alignright">Save</div>
			<div class="clearfix"></div>
		</div>
	</div>';
	
}

function rockthemes_pb_make_modals($arr){
	$return = '';
	foreach($arr as $modal){
		
		if($modal['modal']['descType'] == 'textfield'){
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
			$return .= '<div id="'.$id.'" modalType="'.$modal['modal']['descType'].'" class="rpb_modal hide fade" tabindex="-1" role="dialog" aria-labelledby="'.$id.'" aria-hidden="true">
				<div>
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
						<h3>Text Field</h3>
					</div>
					<div class="modal-body">
						<textarea rows="10" cols="50" style="width:100%">'.$modal['modal']['desc'].'</textarea>
					</div>
					<div class="modal-footer">
						<button class="button" data-dismiss="modal" aria-hidden="true">Close</button>
						<div class="button-primary">Save changes</div>
					</div>
				</div>
			</div>';
		}elseif($modal['modal']['descType'] == 'ajaxfiltered'){
		/*
		**	Ajax Filtered Elem (Portfolio Showcase)
		*/
			$totalItemsToShow = '<div class="total_show_holder"><h4>Select Total Item To Show</h4><select class="total_show" autocomplete="off">';
			for($i = 1; $i< 100; $i++){
				if($modal['modal']['data']['data']['total'] == $i){
					$totalItemsToShow .= '<option value="'.$i.'" selected>'.$i.'</option>';
				}else{
					$totalItemsToShow .= '<option value="'.$i.'">'.$i.'</option>';
				}
			}
			$totalItemsToShow .= '</select></div>';
			
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
			
			$chosenCategory = isset($modal['modal']['data']['data']['category']) ? $modal['modal']['data']['data']['category'] : '';
			$activate_hover_box = checked("true", (isset($modal['modal']['data']['data']['activate_hover_box']) ? $modal['modal']['data']['data']['activate_hover_box'] : false ), false);
			$activate_hover = checked("true", (isset($modal['modal']['data']['data']['activate_hover']) ? $modal['modal']['data']['data']['activate_hover'] : false ), false);
			$small_thumb_hover = checked("true", (isset($modal['modal']['data']['data']['small_thumb_hover']) ? $modal['modal']['data']['data']['small_thumb_hover'] : false ), false);
			
			$boxed_layout = checked("true", (isset($modal['modal']['data']['data']['boxed_layout']) ? $modal['modal']['data']['data']['boxed_layout'] : false ), false);
			$use_shadow = checked("true", (isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : false ), false);
			$disable_hover_link = checked("true", (isset($modal['modal']['data']['data']['disable_hover_link']) ? $modal['modal']['data']['data']['disable_hover_link'] : false ), false);
			$activate_category_link = isset($modal['modal']['data']['data']['activate_category_link']) ? $modal['modal']['data']['data']['activate_category_link'] : "";
			$header_title = isset($modal['modal']['data']['data']['header_title']) ? $modal['modal']['data']['data']['header_title'] : "";
			$excerpt_length = isset($modal['modal']['data']['data']['excerpt_length']) ? $modal['modal']['data']['data']['excerpt_length'] : 18;
			
			$use_border_on_categories = isset($modal['modal']['data']['data']['use_border_on_categories']) ? $modal['modal']['data']['data']['use_border_on_categories'] : "";
			
			
			$excerpt_length_html = '<select class="excerpt_length" autocomplete="off">';
			for($e = 0; $e<150; $e++){
				if($e == $excerpt_length){
					$excerpt_length_html .= '<option value="'. $e .'" selected="selected">'.$e.'</option>';
				}else{
					$excerpt_length_html .= '<option value="'. $e .'">'.$e.'</option>';
				}
			}
			$excerpt_length_html .= '</select>';
			
			
			$return .= '
			<div id="'.$id.'" modalType="'.$modal['modal']['descType'].'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Grid" aria-hidden="true">
					<div class="modal-header">
						<div class="close builder-close"><i class="fa fa-times"></i></div>
						'.rock_builder_item_trans_btn(array(
							'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
						)).'
						<h3>Filtered Ajax Gallery</h3>
					</div>
					<div class="modal-body">
						'.rpb_admin_el_select_image_size(array(
							'modal_id'	=>	$id,
							'class'		=>	'image_sizes_column',
							'calc'		=>	true,
							'default'	=>	'',
							'title'		=>	'',
							'desc'		=>	'',
							'hr'		=>	true
						)).'
						<div class="row-fluid post_type_tax_holder">
							<div class="span6">
								'.rock_builder_get_customposttypes($modal['modal']['data']['data']['postType'], $id, '').'
								'.rock_builder_get_taxonomies($chosenCategory, $modal['modal']['data']['data']['postType'], '').'
							</div>
							<div class="span6">
								<strong>Choose A Post Type</strong></br>
								<p>Choose the post type</p><br/>
								<strong>Choose Taxonomies/Categories to Display</strong></br>
								<p>Choose categories/taxonomies. You can choose multiple categories/taxonomies or just single taxonomy/category. You can also choose all categories/taxonomies by choosing the "All".</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<input autocomplete="off" autocomplete="off" type="text" class="header_title" value="'.$header_title.'" />
							</div>
							<div class="span6">
								<strong>Header Title</strong>
								<p>You can choose to use a header title for filtered ajax portfolio. If you leave this area empty, header title will not be displayed.</p>
							</div>
						</div>
						<hr/>
						'.rock_builder_get_block_grid_list(
							(isset($modal['modal']['data']['data']['block_grid_large']) ? intval($modal['modal']['data']['data']['block_grid_large']) : ''),
							(isset($modal['modal']['data']['data']['block_grid_medium']) ? intval($modal['modal']['data']['data']['block_grid_medium']) : ''),
							(isset($modal['modal']['data']['data']['block_grid_small']) ? intval($modal['modal']['data']['data']['block_grid_small']) : '')
						).'
						<div class="row-fluid">
							<div class="span6">
								'.$totalItemsToShow.'
							</div>
							<div class="span6">
								<strong>Total Products to Show</strong></br>
								<p>This will set up the total products for each category. If you choose 18, you will be showing 18 products for each category.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<select class="activate_category_link"  autocomplete="off">
									<option value="active" '.($activate_category_link == "active" ? "selected" : "").'>Activate</option>
									<option value="deactive" '.($activate_category_link == "deactive" ? "selected" : ""). '>Deactivate</option>
								</select>
							</div>
							<div class="span6">
								<strong>Activate Category Link</strong></br>
								<p>If you activate this option, there will be a link under the products for the chosen category.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								'.$excerpt_length_html.'
							</div>
							<div class="span6">
								<strong>Excerpt Length</strong>
								<p>You can adjust the excerpt length in words. Which means if you choose 10, your excerpt will show up to 10 words from your originial excerpt.</p>
							</div>
						</div>
						<hr/>

						<div class="row-fluid">
							<div class="span6">
								<select class="use_border_on_categories"  autocomplete="off">
									<option value="active" '.($use_border_on_categories == "active" ? "selected" : "").'>Use Border On Category Names</option>
									<option value="deactive" '.($use_border_on_categories == "deactive" ? "selected" : ""). '>Do Not Use Border On Category Names</option>
								</select>
							</div>
							<div class="span6">
								<strong>Use Border On Category Names</strong></br>
								<p>If you want to add a border around category names choose this option.</p>
							</div>
						</div>
						<hr/>

						<div class="row-fluid">
							<div class="span6">
								<div class="activate_hover_box_holder">
									<input autocomplete="off" autocomplete="off" class="activate_hover_box" type="checkbox" value="true" name="activate_hover_box" '.$activate_hover_box.' /><label for="activate_hover_box"> Activate Hover Box</label>
								</div>
							</div>
							<div class="span6">
								<strong>Activate Hover Box Effect</strong></br>
								<p>If you activate hover box effect, your thumbnails will show a bigger image with excerpt when hovered</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<div class="activate_hover_holder">
									<input autocomplete="off" autocomplete="off" class="activate_hover" type="checkbox" value="true" name="activate_hover" '.$activate_hover.' /><label for="activate_hover"> Activate Hover Effect</label>
								</div>
							</div>
							<div class="span6">
								<strong>Activate Regular Hover Effect</strong></br>
								<p>This option will show the regular hover effect with PrettyPhoto (lightbox). If you activate this option, you can not activate the hover box option. Two option can not be activated.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<div class="disable_hover_link_holder">
									<input autocomplete="off" autocomplete="off" class="disable_hover_link" type="checkbox" value="true" name="disable_hover_link" '.$disable_hover_link.' /><label for="activate_hover"> Disable Hover Link</label>
								</div>
							</div>
							<div class="span6">
								<strong>Disable Hover Link</strong></br>
								<p>If you want to disable the link in the hover effect check this option.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<div class="use_shadow_holder">
									<input autocomplete="off" autocomplete="off" class="use_shadow" type="checkbox" value="true" name="use_shadow" '.$use_shadow.' /><label for="use_shadow"> Use Shadow</label>
								</div>
							</div>
							<div class="span6">
								<strong>Activate Shadow Under Thumbnails</strong></br>
								<p>If you want a shadow under thumbnail images check this option. This shadow will be under the thumbnail images not hover box images.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<div class="small_thumb_hover_holder">
									<input autocomplete="off" autocomplete="off" class="small_thumb_hover" type="checkbox" value="true" name="small_thumb_hover" '.$small_thumb_hover.' /><label for="small_thumb_hover"> Small Thumbnail Hover Effect</label>
								</div>
							</div>
							<div class="span6">
								<strong>Activate Small Thumbnail Hover Effect</strong></br>
								<p>If you are using "Regular Hover Effect" and your thumbnails are smaller than 100px, you should activate this option.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<div class="boxed_layout_holder">
									<input autocomplete="off" autocomplete="off" class="boxed_layout" type="checkbox" value="true" name="boxed_layout" '.$boxed_layout.' /><label for="boxed_layout"> Use Boxed Layout</label>
								</div>
							</div>
							<div class="span6">
								<strong>Activate Boxed Layout</strong></br>
								<p>You can easily activate/deactivate boxed layout.</p>
							</div>
						</div>
						<hr/>
					</div>
					<div class="modal-footer">
						<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button><div class="btn btn-primary builder-close ajaxfiltered-save">Save changes</div>
					</div>
			</div>';
		}elseif($modal['modal']['descType'] == 'featuredimage'){
		/*
		**	Featured Image Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
			
			$return .= '			
				<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" aria-hidden="true">
					<div class="modal-header">
						<div class="close builder-close"><i class="fa fa-times"></i></div>
						'.rock_builder_item_trans_btn(array(
							'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
						)).'
						<h3>Featured Image</h3>
					</div>
					<div class="modal-body">
						'.rpb_admin_el_select_image_size(array(
							'modal_id'	=>	$id,
							'class'		=>	'featured_element_holder',
							'calc'		=>	true,
							'default'	=>	isset($modal['modal']['data']['data']['imageSize']) ? $modal['modal']['data']['data']['imageSize'] : '',
							'title'		=>	'',
							'desc'		=>	'You need to upload your featured image to use this element. You can choose different image sizes for your featured image. You can also adjust image sizes in Theme Options.',
							'hr'		=>	false
						)).'
					</div>
					<div class="modal-footer">
						<div class="btn builder-close">Close</div>
						<div class="btn btn-primary featuredimage-save builder-close" ref="'.$id.'">Save changes</div>
					</div>
				</div>
			';
			
			
		}elseif($modal['modal']['descType'] == 'swiperslider'){
		/*
		**	Swiper Slider Elem
		*/

			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
			
			$linkString = '';
			$activate_auto_play = checked("true", (isset($modal['modal']['data']['data']['activate_auto_play']) ? $modal['modal']['data']['data']['activate_auto_play'] : false ), false);
			$auto_play_time = $modal['modal']['data']['data']['auto_play_time'];
			$arrow_nav = $modal['modal']['data']['data']['arrow_nav'];
			
			
			$images = '';
			
			if($modal['modal']['data']['data']['images']){
				$current_img_num = 0;
				foreach($modal['modal']['data']['data']['images'] as $image){
					$images .= '
						<div class="swiperslider-modal-image" ref="'.esc_attr($id).'">
							<h4>Choose an Image</h4>
							<div class="hide image-data"></div>
							<label for="upload_image"> <input autocomplete="off" autocomplete="off" modalID="'.esc_attr($id).'" id="'.esc_attr($id).'_'.esc_attr($current_img_num).'" class="upload_image_button" size="36" name="upload_image" type="text" image_id="'.esc_attr($image['id']).'" value="'.esc_url($image['url']).'" /> <input autocomplete="off" autocomplete="off" class="button image_uploader_class" value="Upload Image" type="button" /> </label>
							'.$linkString.'
							<div class="button delete-image-button" ref="'.esc_attr($id).'">Delete Image</div>
							<br />
						</div>
					';	
				}
			}
			
			
			

						
			$return .= '
				<div id="'.esc_attr($id).'" modalType="'.esc_attr($modal['modal']['descType']).'" class="rpb_modal container hide fade" tabindex="-1" aria-hidden="true">
					<div class="modal-header">
						<div class="close builder-close"><i class="fa fa-times"></i></div>
						'.rock_builder_item_trans_btn(array(
							'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
						)).'
						<h3>Swiper Slider</h3>
					</div>
					<div class="modal-body" data-saved="false">
						<div class="row-fluid">
							<div class="span6 image_sizes_holder">
								'.rock_builder_get_image_sizes(isset($modal['modal']['data']['data']['imageSize']) ? $modal['modal']['data']['data']['imageSize'] : '', $id, 'Choose an Image Size').'
							</div>
							<div class="span6">
								<strong>Choose a Size</strong></br>
								<p>You can choose different image sizes for your featured image. You can also adjust image sizes in Theme Options</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6 images_holder">
								'.$images.'
							</div>
							<div class="span6">
								<h4>Add New Image</h4>
								<p>You can add images to Swiper Slider by clicking to "Add New Image" button</p>
								<div class="button add-new-image">Add New Image</div>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<strong>Auto Play Time</strong><br/>
								<input autocomplete="off" autocomplete="off" name="auto_play_time" class="auto_play_time" type="text" value="'.intval($auto_play_time).'" />
								<div class="activate_auto_play">
									<input autocomplete="off" autocomplete="off" class="activate_auto_play" type="checkbox" value="true" name="activate_auto_play" '.$activate_auto_play.' /><label for="activate_auto_play"> Activate Auto Play</label>
								</div>
							</div>
							<div class="span6">
								<strong>Auto Play</strong></br>
								<p>You can choose to activate autoplay. Set a time in milliseconds.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<select class="arrow_nav"  autocomplete="off">
									<option value="arrows" '.($arrow_nav == "arrows" ? "selected" : ""). '>Activate Arrows</option>
									<option value="pagination" '.($arrow_nav == "pagination" ? "selected" : "").'>Activate Pagination</option>
								</select>
							</div>
							<div class="span6">
								<strong>Navigation</strong></br>
								<p>You can choose to activate pagination or arrows for navigating between slides.</p>
							</div>
						</div>
						<hr/>
					</div>
					<div class="modal-footer">
						<div class="btn builder-close">Close</div>
						<div class="btn btn-primary swiperslider-save builder-close" ref="'.esc_attr($id).'">Save changes</div>
					</div>
				</div>';
		}elseif($modal['modal']['descType'] == 'pricingtable'){
		/*
		**	Pricing Table Elem
		*/
		
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
			
			$linkString = '';
			$max_width = '';
			$featured_text = $modal['modal']['data']['data']['featuredText'];
			$show_details_in_tables = checked("true", (isset($modal['modal']['data']['data']['show_details_in_tables']) ? $modal['modal']['data']['data']['show_details_in_tables'] : false ), false);
			$currency_field = isset($modal['modal']['data']['data']['currency_field']) ? $modal['modal']['data']['data']['currency_field'] : '$';


			$i = 0;
			
			$optionNames = '';
			
			if($modal['modal']['data']['data']['optionNames']){
				$i = 0;
				foreach($modal['modal']['data']['data']['optionNames'] as $optionName){
					$optionNames .= '
						<div class="new-option new-option-'.$i.'">
							<div class="row-fluid escape_hover">
							<div class="btn btn-mini btn-danger span3 remove_option_button" ref="new-option-'.intval($i).'"><i class="fa fa-times"></i></div><input autocomplete="off" autocomplete="off" type="text" class="span9" value="'.esc_attr($optionName).'" data-toggle="tooltip" data-placement="right" title="Enter your option name (i.e. Bandwidth, Traffic, OS)" />
							</div>
							<h4 style="margin:'.($i===0 ? '0.41em 0;' : '0.41em 0;').'">Option Icon : </h4>
						</div>';
					
					$i++;
				}
			}
			
			$tables = '';
			$total_tables = 0;
			
			if($modal['modal']['data']['data']['tables']){
				foreach($modal['modal']['data']['data']['tables'] as $table){
					
					$is_featured = checked("true", (isset($table['packageFeatured']) ? $table['packageFeatured'] : false ), false);
					
					$button_json_data = isset($table['button_json_data']) ? $table['button_json_data'] : '';
					$button_shortcode = isset($table['button_shortcode']) ? $table['button_shortcode'] : '';
					
					
					$columns = '';
					$t = 0;
					
					foreach($table['packageOptions'] as $detail){
						$icon_class = isset($detail['icon_class']) ? $detail['icon_class'] : '';
						$icon_url = isset($detail['icon_url']) ? $detail['icon_url'] : '';
						$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;
						
						$columns .= '
						<div class="new-option new-option-'.$t.'">
							<input autocomplete="off" autocomplete="off" type="text" value="'.esc_attr($detail['value']).'" data-toggle="tooltip" data-placement="right" title="Enter your option name (i.e. Bandwidth, Traffic, OS)" />
							<div class="elem-icon">
								<div class="icon-holder add-elem-icon-btn" style="font-size:4px !important;" icon-ref="'.esc_attr($icon_class).'">'.(($icon_class != "") ? '<i class="'.esc_attr($icon_class).' fa-4x"></i>' : '').'</div>
								<input autocomplete="off" autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.esc_attr($icon_url != "" ? $icon_url : "").'"/>
								'.(!$icon_used ? '<div class="add-elem-icon-btn btn btn-small">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
								'.($icon_used ? '<div class="remove-elem-icon-btn btn btn-small">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn btn-small hide">Remove Icon</div>').'
							</div>
						</div>';	
						$t++;
					}
					

					
										
					$tables .= '
						<div class="span2 table-elem">
							<input autocomplete="off" autocomplete="off" type="text" name="package_name" class="pt-package-name" value="'.esc_attr($table['packageName']).'" data-toggle="tooltip" data-placement="bottom" title="Enter your package name (i.e. Basic, Platinum, Gold)" />
							<input autocomplete="off" autocomplete="off" type="text" name="package_detail" class="pt-package-detail" value="'.esc_attr(isset($table['packageDetail']) ? $table['packageDetail'] : '').'" data-toggle="tooltip" data-placement="bottom" title="Enter your package small detail (i.e. Classic Plan)" />
							<div class="set_featured_holder" style="padding:6px 0px 2px;" data-toggle="tooltip" data-placement="bottom" title="Set featured package (You can only set one featured package)">
								<label for="set_featured"><input autocomplete="off" autocomplete="off" type="checkbox" value="1" class="set_featured" name="set_featured" ref="'.esc_attr($id).'" '.$is_featured.' /> Set Featured</label>
							</div>
							<input autocomplete="off" type="text" name="package_time" class="pt-package-time" value="'.esc_attr($table['packageTime']).'" data-toggle="tooltip" data-placement="bottom" title="Package\'s time amount (i.e. Monthly, Yearly)" />
							<hr / >
							<input autocomplete="off" type="text" class="price" value="'.esc_attr($table['packagePrice']).'" data-toggle="tooltip" data-placement="bottom" title="Enter the price (i.e. 29.9, 18.40)" />
							<hr />
							'.$columns.'
							<hr class="pt-footer" />
							
							<div class="pricing-table-button" id-ref="'.esc_attr($total_tables).'">
								<input autocomplete="off" id="button_data_'.esc_attr($total_tables).'" class="button_json_data" type="hidden" value="'.esc_attr($button_json_data).'" />
								<input autocomplete="off" id="button_shortcode_'.esc_attr($total_tables).'" class="button_shortcode" type="hidden" value="'.esc_attr($button_shortcode).'" />
								<div class="btn btn-small btn-block advanced_details_make_button_modal" id_ref="button_shortcode_'.esc_attr($total_tables).'" id_data_ref="button_data_'.$total_tables.'"><i class="fa fa-gear"></i> Edit Button</div>
							</div>
							
							<hr />
							<div class="button pt-remove-package-button" style="width:100%;" data-toggle="tooltip" title="Delete current package" ref="'.esc_attr($id).'"><i class="icon-trash"></i> Delete Package</div>
						</div>';
						
					$total_tables++;
				}
			}
						
			$return .= '<div id="'.esc_attr($id).'" class="rpb_modal container hide fade" tabindex="-1" aria-hidden="true">
							<div class="modal-header">
								<div class="close builder-close"><i class="fa fa-times"></i></div>
								'.rock_builder_item_trans_btn(array(
									'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
								)).'
								<h3>Pricing Table</h3>
							</div>
								<div class="modal-body" data-saved="false">
									<br />
									<div class="pricing-table-modal">
										<div class="pt-demo row-fluid">
											<div class="span2 main-details header-details" style="background-color:#006dcc; color:#fff; border:1px solid #0044cc; border-radius:4px;">
												<h4 style="margin:0.60em 0;">Package Name : </h4>
												<h4 style="margin:0.60em 0;">Package Detail : </h4>
												<h4 style="margin:0.60em 0;">Featured : </h4>
												<h4 style="margin:0.70em 0;">Package Time : </h4>
												<hr />
												<h4 style="margin:0.9em 0;">Price :</h4>
												<hr style="margin-top:0.68em;" />
												<div class="option-name-holder">
												'.$optionNames.'
												</div>
												<hr />
												<h4 style="margin:0.8em 0;">Button :</h4>
												<h4 style="margin:0.8em 0;">Button Name :</h4>
												<h4 style="margin:0.8em 0;">Button Link :</h4>
												<hr />
												<h4>Add New Option</h4>
												<div class="button pt-add-new-option" ref="'.esc_attr($id).'" data-toggle="tooltip" title="Add a new option field"><i class="fa fa-plus"></i> New Option</div>
											</div>
											'.$tables;
							if($total_tables < 5){
								$return .= '<div class="span2 main-details new-package-button-holder" style="background-color:#006dcc; color:#fff; border:1px solid #0044cc; border-radius:4px; text-align:center;">
												<h4>Add New Package</h4>
												<div class="button pt-add-new-package" ref="'.esc_attr($id).'" data-toggle="tooltip" title="Add a new package"><i class="fa fa-plus"></i> New Package</div>
												<br />
												<br />
											</div>';
							}
								$return .= '</div>
										<br />
										<hr />
										<h2 style="margin-bottom:0px;">General Settings</h2>
										<div class="pt-general-settings row-fluid">
											<div class="span2">
												<h4>Currency</h4>
												<input autocomplete="off" type="text" class="currency_field" name="currency_field" ref="'.esc_attr($id).'" value="'.esc_attr($currency_field).'" />
											</div>
											<div class="span2">
												<h4>Featured Text</h4>
												<input autocomplete="off" name="featured_text" class="featured_text" type="text" value="'.esc_attr($featured_text).'" data-toggle="tooltip" data-placement="top" title="Featured text (i.e. Hot!, Featured, Recommended)" />
											</div>
											<div class="span2">
												<h4>Show Details in Tables</h4>
												<label for="show_details_in_tables"><input autocomplete="off" type="checkbox" value="1" class="show_details_in_tables" name="show_details_in_tables" ref="'.esc_attr($id).'" '.$show_details_in_tables.' /> Activate</label>
											</div>
										</div>
										<br />
									</div>
								</div>
								<div class="modal-footer row-fluid" style="padding:0px; text-align:left;">
									<div class="span8" style="padding:14px 15px 15px; text-align:left;">
										<div class="btn turnonoff-tooltips">
											<i class="fa fa-gear"></i>
											<span class="tooltipstext">Turn Off Tooltips</span>
										</div>
									</div>
									<div class="span4" style="padding:14px 15px 15px; text-align:right;">
										<div class="btn builder-close">Close</div>
										<div class="btn btn-primary pricingtable-save" ref="'.esc_attr($id).'">Save changes</div>
									</div>
								</div>
							</div>';
			
			//Activate tooltips
			$script = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery("[data-toggle=tooltip]").tooltip({html:true});
				});
			</script>
			';
			
			$return .= $script;
		
		}elseif($modal['modal']['descType'] == 'curvyslider'){
		/*
		**	Curvy Slider Elem
		*/

			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
			
			
			$auto_play = checked("true", (isset($modal['modal']['data']['data']['autoPlay']) ? $modal['modal']['data']['data']['autoPlay'] : false ), false);
			$side_navigation = checked("true", (isset($modal['modal']['data']['data']['side_navigation']) ? $modal['modal']['data']['data']['side_navigation'] : false ), false);
			$slider_bottom_divider = isset($modal['modal']['data']['data']['slider_bottom_divider']) ? $modal['modal']['data']['data']['slider_bottom_divider'] : '';
			$slider_navigation = isset($modal['modal']['data']['data']['slider_navigation']) ? $modal['modal']['data']['data']['slider_navigation'] : '';
			
			$curvy_list = '';
			if(function_exists('curvy_get_slider_list')){
				$curvy_list = curvy_get_slider_list(isset($modal['modal']['data']['data']['slider_basic_shortcode']) ? $modal['modal']['data']['data']['slider_basic_shortcode'] : '', $id, false);
			}

			$return .= '
				<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
					<div class="modal-header">
						<div class="close builder-close"><i class="fa fa-times"></i></div>
						'.rock_builder_item_trans_btn(array(
							'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
						)).'
						<h3>Curvy Slider</h3>
					</div>
					<div class="modal-body" data-saved="false">
						<div class="row-fluid">
							<div class="span6 curvyslider_list_holder">
								'.$curvy_list.'
							</div>
							<div class="span6">
								<strong>Choose Curvy Slider</strong><br/>
								<p>You can choose any of your saved Curvy Sliders.</p>
							</div>
						</div>
						<hr />
						
						<div class="row-fluid">
							<div class="span6">
								<div class="slider_navigation_holder">
									<select class="slider_navigation" autocomplete="off">
										<option value="no_nav" '.($slider_navigation === 'no_nav' ? 'selected="selected"' : '').'>Disable Navigation</option>
										<option value="replay" '.($slider_navigation === 'replay' ? 'selected="selected"' : '').'>Replay Button</option>
										<option value="nav_regular" '.($slider_navigation === 'nav_regular' ? 'selected="selected"' : '').'>Enable Navigation</option>
									</select>
								</div>
							</div>
							<div class="span6">
								<strong>Slider Navigation</strong><br/>
								<p>You can choose navigation model for this slider.</p>
							</div>
						</div>
						<hr/>
						
						
						<div class="row-fluid">
							<div class="span6">
								<div class="activate_autoplay_holder">
									<input autocomplete="off" type="checkbox" value="1" class="activate_autoplay" name="activate_autoplay" '.$auto_play.' /><label for="activate_autoplay"> Activate Autoplay</label>
								</div>
							</div>
							<div class="span6">
								<strong>Auto Play</strong><br/>
								<p>If you check this option, slider will start to play automatically.</p>
							</div>
						</div>
						<hr/>
						
						<div class="row-fluid">
							<div class="span6">
								<div class="side_navigation_holder">
									<input autocomplete="off" type="checkbox" value="1" class="side_navigation" name="side_navigation" '.$side_navigation.' /><label for="side_navigation"> Enable Side Navigation</label>
								</div>
							</div>
							<div class="span6">
								<strong>Side Navigation</strong><br/>
								<p>Enable side navigation arrows.</p>
							</div>
						</div>
						<hr/>
						<div class="row-fluid">
							<div class="span6">
								<div class="slider_width_holder">
									<select class="slider_bottom_divider" autocomplete="off">
										<option value="" '.($slider_bottom_divider === '' ? 'selected="selected"' : '').'>Empty</option>
										<option value="use_border" '.($slider_bottom_divider === 'use_border' ? 'selected="selected"' : '').'>Add Border Under Slider</option>
										<option value="use_shadow" '.($slider_bottom_divider === 'use_shadow' ? 'selected="selected"' : '').'>Add Shadow Under Slider</option>
									</select>
								</div>
							</div>
							<div class="span6">
								<strong>Border, Shadow Details</strong><br/>
								<p>You can choose to add border or shadow at the bottom of the slider. If you don\'t want both of them, you can choose "Empty"</p>
							</div>
						</div>
						<hr/>
						
					</div>
					<div class="modal-footer">
						<div class="btn builder-close">Close</div>
						<div class="btn btn-primary curvyslider-save builder-close" ref="'.$id.'">Save changes</div>
					</div>
			</div>';
			
			
		}elseif($modal['modal']['descType'] == 'sidebar'){
		/*
		**	Sidebar Elem
		*/

			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
						
			$return .= '
			<div id="'.esc_attr($id).'" class="rpb_modal container hide fade" tabindex="-1"  aria-hidden="true">
				<div class="modal-header">
					<div class="close builder-close"><i class="fa fa-times"></i></div>
					'.rock_builder_item_trans_btn(array(
						'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
					)).'
					<h3>Sidebar</h3>
				</div>
				<div class="modal-body" data-saved="false">
					<div class="row-fluid">
						<div class="span6 sidebar_list_holder">
							'.rock_builder_get_sidebar_list($modal['modal']['data']['data']['id']).'
						</div>
						<div class="span6">
							<strong>Choose a Sidebar</strong><br/>
							<p>You can insert widgets into your sidebars and use these sidebars in your page layout</p>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<div class="btn builder-close">Close</div>
					<div class="btn btn-primary sidebar-save builder-close" ref="'.esc_attr($id).'">Save changes</div>
				</div>
			</div>';
			
			
		}elseif($modal['modal']['descType'] == 'toggles'){
		/*
		**	Toggles Elem
		*/

			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];
			
			$avoid_sidebar = checked("true", (isset($modal['modal']['data']['data']['avoidSidebar']) ? $modal['modal']['data']['data']['avoidSidebar'] : false ), false);
			$toggleType = $modal['modal']['data']['data']['toggleType'];
			$toggle_use_hash = isset($modal['modal']['data']['data']['toggle_use_hash']) ? $modal['modal']['data']['data']['toggle_use_hash'] : 'no';
			$boxed_layout = checked("true", (isset($modal['modal']['data']['data']['boxed_layout']) ? $modal['modal']['data']['data']['boxed_layout'] : false ), false);
			$use_shadow = checked("true", (isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : false ), false);
			$open_toggle_index = intval(isset($modal['modal']['data']['data']['openToggleIndex']) ? $modal['modal']['data']['data']['openToggleIndex'] : 0);
			
			$togglesString = '';

			if(isset($modal['modal']['data']['data']['toggles']) && is_array($modal['modal']['data']['data']['toggles'])){
				foreach($modal['modal']['data']['data']['toggles'] as $toggle){
					$togglesString .= '
						<li class="toggles-block">
							<div class="hide secret-desc" toggle_hash="'.esc_attr(isset($toggle['toggle_hash']) ? $toggle['toggle_hash'] : '').'" toggle-title="'.esc_attr($toggle['title']).'" icon_class="'.esc_attr($toggle['icon_class']).'" icon_url="'.$toggle['icon_url'].'" data-text="'.esc_attr($toggle['text']).'"></div>
							<i class="drag fa fa-arrows"></i>
							<span class="toggle-name" ref="'.$id.'">'.esc_html($toggle['title']).'</span>
							<i class="close fa fa-times"></i>
						</li>';
				}
			}
						
			$return .= 
			'<div id="'.$id.'" modalType="toggles" class="rpb_modal container hide fade" >
								<div class="modal-header">
									<div class="builder-close close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></div>
									'.rock_builder_item_trans_btn(array(
										'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
									)).'
									<h3>Add Toggle</h3>
								</div>
								<div class="modal-body" data-saved="false">
									<div class="row-fluid">
										<div class="toggles-elements-holder span6">
											<ul class="toggles-list">
												'.$togglesString.'
											</ul>
											<div class="btn btn-small add-new-toggle-btn" ref="'.esc_attr($id).'"><i class="fa fa-plus"></i> Add</div>
										</div>
										<div class="span6">
											<strong>Add/Remove Toggles</strong><br/>
											<p>You can easily add remove toggles by clicking to add new button</p>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<select class="toggle-type" autocomplete="off">
												<option value="single-mode" '.($toggleType == "single-mode" ? 'selected="selected"' : '').'>Toggle Single</option>
												<option value="multiple-mode" '.($toggleType == "multiple-mode" ? 'selected="selected"' : '').'>Toggle Multiple (Accordion)</option>
											</select>
										</div>
										<div class="span6">
											<strong>Choose Toggle Type</strong><br/>
											<p>You can choose multiple mode or single mode. If you choose multiple mode, when a toggle opens, it will close other toggles.</p>
										</div>										
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span6">
											<select class="toggle_use_hash" autocomplete="off">
												<option value="no" '.($toggle_use_hash == "no" ? 'selected="selected"' : '').'>Do not use deeplinking</option>
												<option value="yes" '.($toggle_use_hash == "yes" ? 'selected="selected"' : '').'>Use ID for deeplinking</option>
											</select>
										</div>
										<div class="span6">
											<strong>Toggle Deeplinking (Mostly for FAQ)</strong><br/>
											<p>You can choose to activate deeplinking for Toggles. This if very useful if you are making FAQ. If you activate this option you will need to enter ID for your toggle items.</p>
										</div>										
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span6">
											<div class="open_toggle_index_holder">
												<input autocomplete="off" type="text" value="'.esc_attr($open_toggle_index).'" class="open_toggle_index" name="open_toggle_index" />
											</div>
										</div>
										<div class="span6">
											<strong>Open Toggle Index</strong><br/>
											<p>Index of the toggle will be open. If you want your first toggle to be open enter 0. If you want all toggles to be closed enter -1</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<div class="boxed_layout_holder">
												<input autocomplete="off" class="boxed_layout" type="checkbox" value="true" name="boxed_layout" '.$boxed_layout.' /><label for="activate_hover"> Use Boxed Layout</label>
											</div>
										</div>
										<div class="span6">
											<strong>Boxed Layout</strong><br/>
											<p>If you want to wrap a boxed layout around this element, check this option.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<div class="use_shadow_holder">
												<input autocomplete="off" class="use_shadow" type="checkbox" value="true" name="use_shadow" '.$use_shadow.' /><label for="activate_hover"> Use Shadow</label>
											</div>
										</div>
										<div class="span6">
											<strong>Use Header Shadow</strong><br/>
											<p>This option will activate/deactivate the shadows under the header text.</p>
										</div>										
									</div>
								</div>
								<div class="modal-footer">
									<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
									<div class="btn btn-primary toggles-save builder-close">Save changes</div>
								</div>
							</div>';
							
			$return .= '
				<script type="text/javascript">
					jQuery(document).ready(function(){
						jQuery("#'.$id.' .toggles-list" ).sortable({
							handle : "i.drag",
						});
					});
				</script>';
			
		}elseif($modal['modal']['descType'] == 'tabs'){
		/*
		**	Tabs Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_tabs_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'iconictext'){
		/*
		**	Iconic Text Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_iconictext_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'button'){
		/*
		**	Button Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_button_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'skill'){
		/*
		**	Skill Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_skill_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'horizontalrule'){
		/*
		**	Horizontal Rule Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_hr_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'verticalspace'){
		/*
		**	Vertical Space Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_verticalspace_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'portfolio'){
		/*
		**	Portfolio Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_portfolio_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'googlemap'){
		/*
		**	Google Map Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_googlemap_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'leafletmap'){
		/*
		**	Leaflet Map Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_leafletmap_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'promotionbox'){
		/*
		**	Promotion Box Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_promotionbox_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'alertbox'){
		/*
		**	Alert Box Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_alertbox_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'referencesbuilder'){
		/*
		**	References Builder Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_referencesbuilder_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'testimonialsbuilder'){
		/*
		**	Testimonials Builder Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_testimonialsbuilder_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'socialicons'){
		/*
		**	Social Icons
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_socialicons_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'teammembers'){
		/*
		**	Team Members
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_teammembers_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'beforeafterslider'){
		/*
		**	Before After Slider
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_beforeafterslider_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'externalshortcode'){
		/*
		**	External Shortcode
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_externalshortcode_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'regularblog'){
		/*
		**	Regular Blog
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_regularblog_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'gallery'){
		/*
		**	Gallery
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_gallery_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'hoverelement'){
		/*
		**	Hover Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_hoverelement_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'achievement'){
		/*
		**	Achievement Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_achievement_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'heading'){
		/*
		**	Heading Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_heading_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'stepselement'){
		/*
		**	Steps Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_steps_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'singleimage'){
		/*
		**	Single Image Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_singleimage_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'youtube'){
		/*
		**	Youtube Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_youtube_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'vimeo'){
		/*
		**	Vimeo Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_vimeo_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'htmlvideo'){
		/*
		**	HTML5 Video Element
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_htmlvideo_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'rockformbuilder'){
		/*
		**	Rock Form Builder Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_rockformbuilder_modal($modal,$id);
		}elseif($modal['modal']['descType'] == 'revolutionslider'){
		/*
		**	Revolution Slider Elem
		*/
			$id = explode('-',$modal['id']);
			$id = 'modal-'.$id[1];

			$return .= xr_make_revolutionslider_modal($modal,$id);
		}
	}

	return $return;
}



if(defined('RPB_ELEM_TRANSFER')):
if(!function_exists('rock_page_builder_make_elem_transfer')):

function rock_page_builder_make_elem_transfer(){
	if(!rpb_is_admin()) die();
	if(!isset($_REQUEST['import_elem_data'])) die();
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rpb_transfer') ||
		!check_ajax_referer('rpb_transfer')) {
			
		//Die
		die();
	}
	//var_dump(json_decode(stripslashes($_REQUEST['data']),true));
	
	$new_data = array(
			json_decode(stripslashes($_REQUEST['import_elem_data']),true)
	);
	

	//exit;
	echo rockthemes_pb_make_modals($new_data);
	exit;
}
endif;
add_action('wp_ajax_rock_page_builder_make_elem_transfer', 'rock_page_builder_make_elem_transfer');
endif;






/*
**	HTML5 Video Modal
**
*/
function xr_make_htmlvideo_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	//Default Values
	$video_url				=	'';
	$image_url				=	'';
	$image_id				=	'';
	$extra_style			=	'';
	$extra_class			=	'';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}

	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>HTML5 Video</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<div class="single_image_holder">
						<div class="hide image-data"></div>
						<label for="upload_image">
							<input autocomplete="off" id="'.$id.'single_image" class="upload_image_button video_url" size="36" name="upload_image" type="text" value="'.esc_url($video_url).'" />
							<input autocomplete="off" class="image_uploader_class btn" value="Upload Video" type="button" />
						</label>
						<br/>
					</div>
				</div>
				<div class="span6">
					<strong>Upload Video</strong><br/>
					<p>Choose your video.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="single_image_holder">
						<div class="hide image-data"></div>
						<label for="upload_image">
							<input autocomplete="off" id="'.$id.'placeholder" class="upload_image_button placeholder" size="36" name="upload_image" type="text" value="'.esc_url($image_url).'" image_id="'.(isset($image_id) ? $image_id : '').'" />
							<input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" />
						</label>
						<br/>
					</div>
				</div>
				<div class="span6">
					<strong>Upload Image</strong><br/>
					<p>Choose your image</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_style" value="'.esc_attr($extra_style).'" />
				</div>
				<div class="span6">
					<strong>Extra Style</strong><br/>
					<p>Video will be wrapped with a container with this extra style.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_class" value="'.esc_attr($extra_class).'" />
				</div>
				<div class="span6">
					<strong>Extra Class</strong><br/>
					<p>You can add an extra class to the wrapper.</p>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary htmlvideo-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_htmlvideo_modal_ajax(){
	echo xr_make_htmlvideo_modal();
	exit;
}
add_action('wp_ajax_xr_make_htmlvideo_modal','xr_make_htmlvideo_modal_ajax');










/*
**	Vimeo Modal
**
*/
function xr_make_vimeo_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	//Default Values
	$video_url				=	'';
	$extra_style			=	'';
	$extra_class			=	'';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Vimeo Video</h3>
		</div>
		<div class="modal-body" data-saved="false">

			<div class="row-fluid">
				<div class="span6">
					<div class="video_url_holder">
						<input autocomplete="off" class="video_url" type="text" value="'.esc_url($video_url).'" />
					</div>
				</div>
				<div class="span6">
					<strong>Vimeo Video URL</strong><br/>
					<p>Enter your Vimeo Video URL.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_style" value="'.esc_attr($extra_style).'" />
				</div>
				<div class="span6">
					<strong>Extra Style</strong><br/>
					<p>Video will be wrapped with a container with this extra style.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_class" value="'.esc_attr($extra_class).'" />
				</div>
				<div class="span6">
					<strong>Extra Class</strong><br/>
					<p>You can add an extra class to the wrapper.</p>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary vimeo-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_vimeo_modal_ajax(){
	echo xr_make_vimeo_modal();
	exit;
}
add_action('wp_ajax_xr_make_vimeo_modal','xr_make_vimeo_modal_ajax');










/*
**	Youtube Modal
**
*/
function xr_make_youtube_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	//Default Values
	$video_url				=	'';
	$extra_style			=	'';
	$extra_class			=	'';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Youtube Video</h3>
		</div>
		<div class="modal-body" data-saved="false">

			<div class="row-fluid">
				<div class="span6">
					<div class="video_url_holder">
						<input autocomplete="off" class="video_url" type="text" value="'.esc_url($video_url).'" />
					</div>
				</div>
				<div class="span6">
					<strong>Youtube Video URL</strong><br/>
					<p>Enter your Youtube Video URL.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_style" value="'.esc_attr($extra_style).'" />
				</div>
				<div class="span6">
					<strong>Extra Style</strong><br/>
					<p>Video will be wrapped with a container with this extra style.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_class" value="'.esc_attr($extra_class).'" />
				</div>
				<div class="span6">
					<strong>Extra Class</strong><br/>
					<p>You can add an extra class to the wrapper.</p>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary youtube-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_youtube_modal_ajax(){
	echo xr_make_youtube_modal();
	exit;
}
add_action('wp_ajax_xr_make_youtube_modal','xr_make_youtube_modal_ajax');









/*
**	Single Image Modal
**
*/
function xr_make_singleimage_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	//Default Values
	$image_sizes			=	'large';
	$image_url				=	'';
	$image_align			=	'';
	$image_id				=	'';
	$extra_style			=	'';
	$extra_class			=	'';
	$overflow_image			=	'false';
	$overflow_image_size	=	'';
	$tax_name				=	'';
	$url					=	'';
	$post_id				=	'';
	$is_tax					=	'';
	$image_link_target		=	'';
	$link_html				=	'';
	$enable_hover			=	'';
	$hover_title			=	'';
	$hover_color			=	'';
	$hover_bg_color			=	'';
	$snap_image				=	'';

	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);
		if(isset($link_details)){
			extract($link_details);	
		}
	}
	
	$is_page = 'no';
	if($is_tax === 'false' || !$is_tax) $is_page = 'yes';

	if($url && $url !== ''){
		$link_html = '<input autocomplete="off" class="link_custom_input" type="text" value="'.$url.'" />';
	}elseif($post_id && $post_id !== 'false'){
		$link_html = rock_builder_get_linkposts_cats_posts(array('is_page'=> $is_page, 'category'=>$tax_name, 'selected'=>$post_id));	
	}	
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Image</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6 image_sizes_holder">
					'.rock_builder_get_image_sizes($image_sizes, $id, '').'
				</div>
				<div class="span6">
					<strong>Choose a Size</strong></br>
					<p>You can choose different image sizes for your image. You can also adjust image sizes in Theme Options</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="single_image_holder">
						<strong>Choose an Image</strong><br/>
						<div class="hide image-data"></div>
						<label for="upload_image">
							<input autocomplete="off" id="'.$id.'single_image" class="upload_image_button single_image" size="36" name="upload_image" type="text" value="'.esc_url($image_url).'" image_id="'.esc_attr(isset($image_id) ? $image_id : '').'" />
							<input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" />
						</label>
						<br/>
					</div>
				</div>
				<div class="span6">
					<strong>Upload Image</strong><br/>
					<p>Choose your image</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select autocomplete="off" class="image_align">
						<option value="" '.($image_align === '' ? 'selected="selected"' : '').'>Default</option>
						<option value="left" '.($image_align === 'left' ? 'selected="selected"' : '').'>Left</option>
						<option value="right" '.($image_align === 'right' ? 'selected="selected"' : '').'>Right</option>
						<option value="center" '.($image_align === 'center' ? 'selected="selected"' : '').'>Center</option>
					</select>
				</div>
				<div class="span6">
					<strong>Image Align</strong><br/>
					<p>Where to align image.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					'.rock_builder_get_linkposts_cats($tax_name,$id).'
					'.$link_html.'
				</div>
				<div class="span6">
					<strong>Link</strong><br/>
					<p>If you want to link to a page or to a custom link address you can set up your link here.</p>
				</div>										
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="image_link_target" autocomplete="off">
						<option value="" '.($image_link_target == '' ? 'selected="selected"' : '').'>Self</option>
						<option value="_blank" '.($image_link_target == '_blank' ? 'selected="selected"' : '').'>New Window</option>
						<option value="modal" '.($image_link_target == 'modal' ? 'selected="selected"' : '').'>Lightbox (will use full image)</option>
						<option value="inline" '.($image_link_target == 'inline' ? 'selected="selected"' : '').'>Inline (For inline hash # navigaiton)</option>
					</select>
				</div>
				<div class="span6">
					<strong>Image Link Target</strong><br/>
					<p>You can choose link to same page or a new page. If you choose lightbox, full image will be displayed in lightbox.</p>
				</div>
			</div>
			<hr/>
			
			
			<div class="row-fluid">
				<div class="span6">
					<select class="enable_hover" autocomplete="off">
						<option value="false" '.($enable_hover == 'false' ? 'selected="selected"' : '').'>Disable Hover</option>
						<option value="true" '.($enable_hover == 'true' ? 'selected="selected"' : '').'>Enable Hover</option>
					</select>
				</div>
				<div class="span6">
					<strong>Enable Hover</strong><br/>
					<p>You can easily enable disable hover effect.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="hover_bg_color">
						'.rockbuilder_make_colorpicker($id.'-hover_bg', $hover_bg_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Background Color</strong><br/>
					<p>Background color of the title area in hover.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="hover_color">
						'.rockbuilder_make_colorpicker($id.'-color', $hover_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Title Color</strong><br/>
					<p>Title color in hover.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="hover_title_holder">
						<input autocomplete="off" class="hover_title" type="text" value="'.esc_attr($hover_title).'" />
					</div>
				</div>
				<div class="span6">
					<strong>Hover Title</strong><br/>
					<p>Enter title for the hover.</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<select class="overflow_image" autocomplete="off">
						<option value="false" '.($overflow_image == 'false' ? 'selected="selected"' : '').'>Disable Image Overflow</option>
						<option value="true" '.($overflow_image == 'true' ? 'selected="selected"' : '').'>Enable Image Overflow</option>
					</select><br/>
					<p>Enter a number without px/em (i.e. 75)</p>
					<input autocomplete="off" type="text" class="overflow_image_size" value="'.esc_attr($overflow_image_size).'" />
				</div>
				<div class="span6">
					<strong>Enable Image Overflow</strong><br/>
					<p>This feature will overflow this image under the grid. You can enable this if you want to overflow your image. This feature will not work on Parallax and Video backgrounds.</p>
				</div>
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6">
					<select class="snap_image" autocomplete="off">
						<option value="false" '.($snap_image == 'false' ? 'selected="selected"' : '').'>Disable Image Snap</option>
						<option value="left" '.($snap_image == 'left' ? 'selected="selected"' : '').'>Snap To Left</option>
						<option value="right" '.($snap_image == 'right' ? 'selected="selected"' : '').'>Snap To Right</option>
					</select>
				</div>
				<div class="span6">
					<strong>Enable Image Snap</strong><br/>
					<p>This feature will snap to image to left or right side of the grid. If you enable this feature we advise you to use Snap To Right for images in right columns and Snap To Left for images in left columns.</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_style" value="'.esc_attr($extra_style).'" />
				</div>
				<div class="span6">
					<strong>Extra Style</strong><br/>
					<p>Image will be wrapped with a container with this extra style.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_class" value="'.esc_attr($extra_class).'" />
				</div>
				<div class="span6">
					<strong>Extra Class</strong><br/>
					<p>You can add an extra class to the wrapper.</p>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary singleimage-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_singleimage_modal_ajax(){
	echo xr_make_singleimage_modal();
	exit;
}
add_action('wp_ajax_xr_make_singleimage_modal','xr_make_singleimage_modal_ajax');











/*
**	Steps Modal
*/

function xr_make_steps_modal($modal=null,$id=null){
	$is_ajax = false;

	
	$return = '';
	
	
	$steps_mode = '';
	$steps_bg_color = '#787878';
	$min_width = '1140px';
	$start_steps = 'first';
	$margin_top = '160px';
	$margin_bottom = '190px';
	
	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
		extract($modal_obj);
	}
	
	$stepsString = '												
		<li class="step-block active">
			<div class="hide secret-desc" step_color="#787878" step_title="Step 1" icon_class="" icon_url="" external_url="" member_image_url="">You can follow our easy steps.</div>
			<i class="drag fa fa-arrows"></i>
			<span class="step_title" ref="'.$id.'" step-index="0">Step 1</span>
			<i class="close fa fa-times"></i>
		</li>
		<li class="step-block active">
			<div class="hide secret-desc" step_color="#787878" step_title="Step 2" icon_class="" icon_url="" external_url="" member_image_url="">You can follow our easy steps.</div>
			<i class="drag fa fa-arrows"></i>
			<span class="step_title" ref="'.$id.'" step-index="1">Step 2</span>
			<i class="close fa fa-times"></i>
		</li>
		';
	
	if(!$is_ajax){
		extract($modal['modal']['data']['data']);
			
		$stepsString = '';
		$i = 0;

		if(isset($modal['modal']['data']['data']['steps']) && is_array($modal['modal']['data']['data']['steps'])){
			foreach($modal['modal']['data']['data']['steps'] as $steps){
				$stepsString .= '
					<li class="step-block">
						<div class="hide secret-desc" step_color="'.esc_attr($steps['step_color']).'" step_title="'.esc_attr($steps['step_title']).'"  external_url="" data-text="'.esc_attr($steps['step_content']).'"></div>
						<i class="drag fa fa-arrows"></i>
						<span class="step_title" ref="'.$id.'" step-index="'.$i.'">'.esc_html($steps['step_title']).'</span>
						<i class="close fa fa-times"></i>
					</li>';						
					
				$i++;
			}
		}
			
		$script = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery("#'.$id.' .steps_list" ).sortable({
						handle : "i.drag",
					});
				});
			</script>';
	}
	
						
	$return .= '
		<div id="'.$id.'" modalType="steps" class="rpb_modal container hide fade" >
			<div class="modal-header">
				<div class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></div>
				'.rock_builder_item_trans_btn(array(
					'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
				)).'
				<h3>Steps</h3>
			</div>
			<div class="modal-body" data-saved="false">
				<div class="row-fluid">
					<div class="span6">
						<div class="steps_bg_color">
							'.rockbuilder_make_colorpicker($id.'-steps-bg', $steps_bg_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Steps Background Color</strong><br/>
						<p>Choose steps background color.</p>
					</div>
				</div>
				<hr/>
			
				<div class="row-fluid">
					<div class="steps_list_holder span6">
						<ul class="steps_list">
							'.$stepsString.'
						</ul>
						<div class="btn btn-small add-new-step-btn" ref="'.$id.'"><i class="fa fa-plus"></i> Add</div>
					</div>
					<div class="span6">
						<strong>Add/Remove Step</strong><br/>
						<p>You can easily add remove steps</p>
					</div>
				</div>
				<hr/>
				
				<div class="row-fluid">
					<div class="span6">
						<select autocomplete="off" class="steps_mode">
							<option value="jump" '.($steps_mode === 'jump' ? 'selected="selected"' : '').'>Free Mode</option>
							<option value="connect" '.($steps_mode === 'connect' ? 'selected="selected"' : '').'>Connect Mode</option>
						</select>
					</div>
					<div class="span6">
						<strong>Steps Mode</strong><br/>
						<p>You can connect steps to each other to only allow next/previous stepping. You can also choose free mode which will open the step clicked</p>
					</div>
				</div>
				<hr/>
				
				<div class="row-fluid">
					<div class="span6">
						<select autocomplete="off" class="start_steps">
							<option value="none" '.($start_steps === 'none' ? 'selected="selected"' : '').'>Do Not Start Steps</option>
							<option value="first" '.($start_steps === 'first' ? 'selected="selected"' : '').'>Start First Step</option>
							<option value="all" '.($start_steps === 'all' ? 'selected="selected"' : '').'>Start All Steps</option>
						</select>
					</div>
					<div class="span6">
						<strong>Start Step</strong><br/>
						<p>You can choose the start first step, all steps or you can disable the steps at the beginning.</p>
					</div>
				</div>
				<hr/>
				
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" name="min_width" class="min_width" type="text" value="'.esc_attr(stripslashes($min_width)).'" />
					</div>
					<div class="span6">
						<strong>Steps Min Width</strong><br/>
						<p>Steps will be turn into responsive mode under this width. Enter a valid px value. (i.e. 960px)</p>
					</div>
				</div>
				<hr/>



				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" name="margin_top" class="margin_top" type="text" value="'.esc_attr(stripslashes($margin_top)).'" />
					</div>
					<div class="span6">
						<strong>Margin Top</strong><br/>
						<p>You must enter a margin top value. This value will be the main margin starting from the steps line to the top. Default value is 160px.</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" name="margin_bottom" class="margin_bottom" type="text" value="'.esc_attr(stripslashes($margin_bottom)).'" />
					</div>
					<div class="span6">
						<strong>Margin Bottom</strong><br/>
						<p>You must enter a margin top value. This value will be the main margin starting from the steps line to the top. Default value is 190px.</p>
					</div>
				</div>
				<hr/>
				
			</div>
			<div class="modal-footer">
				<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
				<div class="btn btn-primary steps-save">Save changes</div>
			</div>
		</div>';
					
	return $return;
	
	exit;
}

function xr_make_steps_modal_ajax(){
	echo xr_make_steps_modal();
	exit;
}
add_action('wp_ajax_xr_make_steps_modal', 'xr_make_steps_modal_ajax');





function rock_make_single_step_modal($stepObj=null, $id=null){
	
	
	if(isset($_REQUEST['step_obj'])){
		$step_obj = $_REQUEST['step_obj'];	
		$id = $step_obj['id'];
	}
		
	
	$return = '
		<div id="step-single-modal" modalType="step_single" class="rpb_modal container hide fade">
			<div class="modal-header">
				<div class="close close-step-single"><i class="fa fa-times"></i></div>
					<h3>Add Step</h3>
				</div>
				<div class="modal-body" data-saved="false">
					<div class="row-fluid">
						<div class="span6">
							<div class="step_color">
								'.rockbuilder_make_colorpicker($id.'-step', $step_obj['step_color']).'
							</div>
						</div>
						<div class="span6">
							<strong>Step Active Color</strong><br/>
							<p>Choose step active color.</p>
						</div>
					</div>
					<hr/>
					<div class="row-fluid">
						<div class="span6">
							<input autocomplete="off" name="step_title" class="step_title" type="text" value="'.esc_attr(stripslashes($step_obj['step_title'])).'" />
						</div>
						<div class="span6">
							<strong>Step Title</strong><br/>
							<p>Enter the step title</p>
						</div>
					</div>
					<hr/>
					<div class="row-fluid">
						<div class="span6">
							<input autocomplete="off" name="step_content" class="step_content" type="text" value="'.esc_attr($step_obj['step_content']).'" />
						</div>
						<div class="span6">
							<strong>Step Content</strong><br/>
							<p>Enter the content of this step. (10 words most for visuality)</p>
						</div>
					</div>
					<hr/>
				</div>
				<div class="modal-footer">
					<div class="btn close-step-single">Close</div>
					<div class="btn btn-primary step-single-save" ref="'.esc_attr($step_obj['index']).'" modal-ref="'.$id.'">Save changes</div>
				</div>
			</div>';


	return $return;
}

function rock_make_single_step_modal_ajax(){
	echo rock_make_single_step_modal();	
	exit;
}

add_action('wp_ajax_rock_make_single_step_modal', 'rock_make_single_step_modal_ajax');










/*
**	Gallery Modal
*/

function xr_make_gallery_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	$image_sizes = isset($modal['modal']['data']['data']['imageSize']) ? $modal['modal']['data']['data']['imageSize'] : '';
	
	$totalProducts = isset($modal['modal']['data']['data']['total']) ? $modal['modal']['data']['data']['total'] : 18;
	
	$chosenCategory = isset($modal['modal']['data']['data']['category']) ? $modal['modal']['data']['data']['category'] : '';
	$chosenPostType = isset($modal['modal']['data']['data']['postType']) ? $modal['modal']['data']['data']['postType'] : '';
	
	$header_title = isset($modal['modal']['data']['data']['header_title']) ? $modal['modal']['data']['data']['header_title'] : "";
	
	$activate_hover_box = checked("true", (isset($modal['modal']['data']['data']['activate_hover_box']) ? $modal['modal']['data']['data']['activate_hover_box'] : false ), false);
	$activate_hover = checked("true", (isset($modal['modal']['data']['data']['activate_hover']) ? $modal['modal']['data']['data']['activate_hover'] : false ), false);
	$disable_hover_link = checked("true", (isset($modal['modal']['data']['data']['disable_hover_link']) ? $modal['modal']['data']['data']['disable_hover_link'] : false ), false);
			
	$boxed_layout = checked("true", (isset($modal['modal']['data']['data']['boxed_layout']) ? $modal['modal']['data']['data']['boxed_layout'] : false ), false);

	$excerpt_title_option = isset($modal['modal']['data']['data']['excerpt_title_option']) ? $modal['modal']['data']['data']['excerpt_title_option'] : '';
	$excerpt_length = isset($modal['modal']['data']['data']['excerpt_length']) ? $modal['modal']['data']['data']['excerpt_length'] : 18;
	
	$pagination = checked("true", (isset($modal['modal']['data']['data']['pagination']) ? $modal['modal']['data']['data']['pagination'] : false ), false);
	$masonry = checked("true", (isset($modal['modal']['data']['data']['masonry']) ? $modal['modal']['data']['data']['masonry'] : false ), false);
	$load_more = checked("true", (isset($modal['modal']['data']['data']['load_more']) ? $modal['modal']['data']['data']['load_more'] : false ), false);
	
	$activate_category_link = isset($modal['modal']['data']['data']['activate_category_link']) ? $modal['modal']['data']['data']['activate_category_link'] : "";
	$activate_header_link = isset($modal['modal']['data']['data']['activate_header_link']) ? $modal['modal']['data']['data']['activate_header_link'] : "";
	
	$use_shadow = checked("true", (isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : false ), false);
	
	$excerpt_length_html = '<select class="excerpt_length" autocomplete="off">';
	for($e = 0; $e<150; $e++){
		if($e == $excerpt_length){
			$excerpt_length_html .= '<option value="'. $e .'" selected="selected">'.$e.'</option>';
		}else{
			$excerpt_length_html .= '<option value="'. $e .'">'.$e.'</option>';
		}
	}
	$excerpt_length_html .= '</select>';
	
	
	$totalItemsToShow = '<div class="total_show_holder"><h4>Select Total Item To Show</h4><select class="total_show" autocomplete="off">';
	for($i = 1; $i< 100; $i++){
		if($totalProducts == $i){
			$totalItemsToShow .= '<option value="'.$i.'" selected>'.$i.'</option>';
		}else{
			$totalItemsToShow .= '<option value="'.$i.'">'.$i.'</option>';
		}
	}
	$totalItemsToShow .= '</select></div>';
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Gallery" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Gallery</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6 image_sizes_column"  bind="'.$id.'" calc="true">
					'.rock_builder_get_image_sizes($image_sizes, $id, '').'
				</div>
				<div class="span6">
					<strong>Choose image size</strong><br/>
					<p>You can choose any image sizes for Gallery.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid post_type_tax_holder">
				<div class="span6">
					'.rock_builder_get_customposttypes($chosenPostType, $id, '').'
					'.rock_builder_get_taxonomies($chosenCategory, $chosenPostType, '').'
				</div>
				<div class="span6">
					<strong>Choose A Post Type</strong></br>
					<p>Choose the post type</p><br/>
					<strong>Choose Taxonomies/Categories to Display</strong></br>
					<p>Choose categories/taxonomies. You can choose multiple categories/taxonomies or just single taxonomy/category. You can also choose all categories/taxonomies by choosing the "All".</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					'.rockthemes_excerpt_title_option($excerpt_title_option).'
				</div>
				<div class="span6">
					<strong>Description</strong>
					<p>You can choose the description details.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					'.$excerpt_length_html.'
				</div>
				<div class="span6">
					<strong>Excerpt Length</strong>
					<p>You can adjust the excerpt length in words. Which means if you choose 10, your excerpt will show up to 10 words from your originial excerpt.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="header_title" value="'.$header_title.'" />
				</div>
				<div class="span6">
					<strong>Header Title</strong>
					<p>You can choose to use a header title for gallery. If you leave this area empty, header title will not be displayed.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="activate_header_link" autocomplete="off">
						<option value="true" '.($activate_header_link === 'true' ? 'selected="selected"' : '').'>Activate Header Link</option>
						<option value="false" '.($activate_header_link === 'false' ? 'selected="selected"' : '').'>Deactivate Header Link</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Header Link</strong>
					<p>If you activate header link, header will link to the gallery.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="activate_category_link" autocomplete="off">
						<option value="true" '.($activate_category_link === 'true' ? 'selected="selected"' : '').'>Activate Category Link</option>
						<option value="false" '.($activate_category_link === 'false' ? 'selected="selected"' : '').'>Deactivate Category Link</option>
					</select>
				</div>
				<div class="span6">
					<strong>Category Links</strong>
					<p>You can activate the category link under the title. This will show the links of the categories for the gallery.</p>
				</div>
			</div>
			<hr/>
			'.rock_builder_get_block_grid_list(
				(isset($modal['modal']['data']['data']['block_grid_large']) ? intval($modal['modal']['data']['data']['block_grid_large']) : ''),
				(isset($modal['modal']['data']['data']['block_grid_medium']) ? intval($modal['modal']['data']['data']['block_grid_medium']) : ''),
				(isset($modal['modal']['data']['data']['block_grid_small']) ? intval($modal['modal']['data']['data']['block_grid_small']) : '')
			).'
			<div class="row-fluid">
				<div class="span6">
					'.$totalItemsToShow.'
				</div>
				<div class="span6">
					<strong>Total Gallery Image to Show</strong></br>
					<p>This will set up the total gallery image per page. If you choose 18, you will be showing 18 products for each page. If you activate this option, load more option will be disabled</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="pagination_holder">
						<input autocomplete="off" class="pagination" type="checkbox" value="true" name="pagination" '.$pagination.' /><label for="activate_hover_box"> Activate Pagination</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Pagination</strong></br>
					<p>You can activate / deactivate the pagination. If you want to activate the pagination check this option.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="masonry_holder">
						<input autocomplete="off" class="masonry" type="checkbox" value="true" name="masonry" '.$masonry.' /><label for="activate_hover_box"> Activate Masonry</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Masonry</strong></br>
					<p>You can activate / deactivate the masonry. If you activated pagination, masonry will not work. You need uncheck pagination if you want to use masonry.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="load_more_holder">
						<input autocomplete="off" class="load_more" type="checkbox" value="true" name="load_more" '.$load_more.' /><label for="activate_hover_box"> Activate Load More</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Load More</strong></br>
					<p>You can activate / deactivate the load more. Load more option will only work if you have activated the masonry.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="activate_hover_holder">
						<input autocomplete="off" class="activate_hover" type="checkbox" value="true" name="activate_hover" '.$activate_hover.' /><label for="activate_hover"> Activate Hover Effect</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Regular Hover Effect</strong></br>
					<p>This option will show the regular hover effect with PrettyPhoto (lightbox).</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="disable_hover_link_holder">
						<input autocomplete="off" autocomplete="off" class="disable_hover_link" type="checkbox" value="true" name="disable_hover_link" '.$disable_hover_link.' /><label for="activate_hover"> Disable Hover Link</label>
					</div>
				</div>
				<div class="span6">
					<strong>Disable Hover Link</strong></br>
					<p>If you want to disable the link in the hover effect check this option.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="boxed_layout_holder">
						<input autocomplete="off" class="boxed_layout" type="checkbox" value="true" name="boxed_layout" '.$boxed_layout.' /><label for="boxed_layout"> Use Boxed Layout</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Boxed Layout</strong></br>
					<p>You can easily activate/deactivate boxed layout.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="use_shadow_holder">
						<input autocomplete="off" class="use_shadow" type="checkbox" value="true" name="use_shadow" '.$use_shadow.' /><label for="use_shadow"> Use Shadow</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Shadow</strong></br>
					<p>If you activate shadow, there will be a shadow under images.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary gallery-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
		

	return $return;
}

function xr_make_gallery_modal_ajax(){
	echo xr_make_gallery_modal();
	exit;
}
add_action('wp_ajax_xr_make_gallery_modal','xr_make_gallery_modal_ajax');













/*
**	Regular Blog
**
*/
function xr_make_regularblog_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	//Default Values
	$regular_content = 'true';
	$image_size = 'thumbnail';
	$hover_active = 'false';
	$image_col = '3';
	$excerpt_length = 30;
	$header_link = 'true';
	$show_categories = 'true';
	$show_tags = 'true';
	$show_date = 'true';
	$space_height = '15px';
	$pagination = 'true';
	$total = 5;
	$sticky_first = 'false';
	$category = '';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
	
	
	$excerpt_length_html = '<select class="excerpt_length" autocomplete="off">';
	for($e = 0; $e<150; $e++){
		if($e == $excerpt_length){
			$excerpt_length_html .= '<option value="'. $e .'" selected="selected">'.$e.'</option>';
		}else{
			$excerpt_length_html .= '<option value="'. $e .'">'.$e.'</option>';
		}
	}
	$excerpt_length_html .= '</select>';
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Regular Blog</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid regularblog">
				<div class="span6">
					'.rock_builder_get_taxonomies($category, 'post', '').'
				</div>
				<div class="span6">
					<strong>Post Category</strong><br/>
					<p>You can choose post category.</p>
				</div>
			</div>
			<hr/>
		
			<div class="row-fluid regularblog">
				<div class="span6">
					<select class="regular_content" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($regular_content == 'true' ? 'selected="selected"' : '').'>Use Regular Content (Supports Different Blog Post Types)</option>
						<option value="false" '.($regular_content == 'false' ? 'selected="selected"' : '').'>Do Not Use Regular Content (Displays Plain Content)</option>
					</select>
				</div>
				<div class="span6">
					<strong>Use Regular Blog Content</strong><br/>
					<p>You can choose to if you want to display regular blog content with blog post types such as "gallery", "video" and "image".</p>
				</div>
			</div>
			<hr/>
			<span class="regular-content-details toggle-span" '.($regular_content === 'true' ? 'style="display:none;"' : '').'>
			
			<div class="row-fluid">
				<div class="span6 image_sizes_holder">
					'.rock_builder_get_image_sizes($image_size, $id, '').'
				</div>
				<div class="span6">
					<strong>Choose a Size</strong></br>
					<p>You can choose different image sizes for your image. You can also adjust image sizes in Theme Options</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="hover_active" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($hover_active == 'true' ? 'selected="selected"' : '').'>Activate Image Hover Effect</option>
						<option value="false" '.($hover_active == 'false' ? 'selected="selected"' : '').'>Do Not Activate Image Hover Effect</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Hover Effect</strong><br/>
					<p>You can choose to activate or deactivate hover effect of the image.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					'.rock_builder_get_block_grid_large_list($image_col).'
				</div>
				<div class="span6">
					<strong>Image Column</strong><br/>
					<p>You can choose a column 1 to 12 for the image area. If you want to display a big image, you may want to use a higher image columns</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					'.$excerpt_length_html.'
				</div>
				<div class="span6">
					<strong>Excerpt Length</strong>
					<p>You can adjust the excerpt length in words. Which means if you choose 10, your excerpt will show up to 10 words from your originial excerpt.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="header_link" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($header_link == 'true' ? 'selected="selected"' : '').'>Activate Header Link</option>
						<option value="false" '.($header_link == 'false' ? 'selected="selected"' : '').'>Do Not Activate Header Link</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Header Link</strong><br/>
					<p>You can choose to activate or deactivate header link.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="show_categories" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($show_categories == 'true' ? 'selected="selected"' : '').'>Show Categories</option>
						<option value="false" '.($show_categories == 'false' ? 'selected="selected"' : '').'>Do Not Show Categories</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Categories</strong><br/>
					<p>You can choose to display or hide categories</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="show_tags" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($show_tags == 'true' ? 'selected="selected"' : '').'>Show Tags</option>
						<option value="false" '.($show_tags == 'false' ? 'selected="selected"' : '').'>Do Not Show Tags</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Tags</strong><br/>
					<p>You can choose to display or hide tags</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="show_date" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($show_date == 'true' ? 'selected="selected"' : '').'>Show Date</option>
						<option value="false" '.($show_date == 'false' ? 'selected="selected"' : '').'>Do Not Show Date</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Date</strong><br/>
					<p>You can choose to display or hide date</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="space_height" value="'.$space_height.'" />
				</div>
				<div class="span6">
					<strong>Space Height</strong><br/>
					<p>Height of the space between posts</p>
				</div>
			</div>
			<hr/>
			
			</span>
			
			<div class="row-fluid">
				<div class="span6">
					<select class="pagination" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($pagination == 'true' ? 'selected="selected"' : '').'>Activate Pagination</option>
						<option value="false" '.($pagination == 'false' ? 'selected="selected"' : '').'>Do Not Activate Pagination</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Pagination</strong><br/>
					<p>You can choose to activate / deactivate pagination</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="total" value="'.$total.'" />
				</div>
				<div class="span6">
					<strong>Total Posts</strong><br/>
					<p>How many posts will be displayed? If you use "pagination", this will show how many posts will be displayed per page.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="sticky_first" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($sticky_first == 'true' ? 'selected="selected"' : '').'>Show Sticky At First</option>
						<option value="false" '.($sticky_first == 'false' ? 'selected="selected"' : '').'>Do Not Show Sticky At First</option>
					</select>
				</div>
				<div class="span6">
					<strong>Show Sticky First</strong><br/>
					<p>You can choose to display sticky as first or not</p>
				</div>
			</div>
			<hr/>
			
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary regularblog-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_regularblog_modal_ajax(){
	echo xr_make_regularblog_modal();
	exit;
}
add_action('wp_ajax_xr_make_regularblog_modal', 'xr_make_regularblog_modal_ajax');









/*
**	External Code Modal
**
**	Makes a text area without TinyMCE to insert any code / shortcode
*/
function xr_make_externalshortcode_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	//Default Values
	$shortcode				=	'';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>External Code</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6 shortcode_holder">
					<textarea rows="4" cols="50" class="shortcode">'.esc_textarea($shortcode).'</textarea>
				</div>
				<div class="span6">
					<strong>Enter Your Shortcode / Code</strong></br>
					<p>You can use this element to enter your external shortcode or code</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary externalshortcode-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_externalshortcode_modal_ajax(){
	echo xr_make_externalshortcode_modal();
	exit;
}
add_action('wp_ajax_xr_make_externalshortcode_modal', 'xr_make_externalshortcode_modal_ajax');










/*
**	Before After Slider Modal
**
**	Makes a special presentation with two images as before and after
*/
function xr_make_beforeafterslider_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	//Default Values
	$image_size				=	'large';
	$before_image_url		=	'';
	$after_image_url		=	'';
	$height					=	'400px';
	$min_width				=	'540px';
	$activate_navigation	=	'true';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Before After Slider</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6 image_sizes_holder">
					'.rock_builder_get_image_sizes($image_size, $id, '').'
				</div>
				<div class="span6">
					<strong>Choose a Size</strong></br>
					<p>You can choose different image sizes for your image. You can also adjust image sizes in Theme Options</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="beforeafter-before-image" ref="beforeafter-image-uploader">
						<strong>Choose an Image</strong><br/>
						<div class="hide image-data"></div>
						<label for="upload_image">
							<input autocomplete="off" id="'.$id.'before_image_url" class="upload_image_button before_image_url" size="36" name="upload_image" type="text" value="'.esc_url($before_image_url).'" image_id="'.esc_attr(isset($before_image_id) ? $before_image_id : '').'" />
							<input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" />
						</label>
						<br/>
					</div>
				</div>
				<div class="span6">
					<strong>Before Image</strong><br/>
					<p>This image will be displayed as before image at the left side</p>
				</div>
			</div>
			<div class="row-fluid">
				<div class="span6">
					<div class="beforeafter-after-image" ref="beforeafter-image-uploader">
						<strong>Choose an Image</strong><br/>
						<div class="hide image-data"></div>
						<label for="upload_image">
							<input autocomplete="off" id="'.$id.'after_image_url" class="upload_image_button after_image_url" size="36" name="upload_image" type="text" value="'.esc_url($after_image_url).'" image_id="'.esc_attr(isset($after_image_id) ? $after_image_id : '').'" />
							<input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" />
						</label>
						<br/>
					</div>
				</div>
				<div class="span6">
					<strong>After Image</strong><br/>
					<p>This image will be displayed as after image at the right side</p>
				</div>
			</div>
			<div class="row-fluid hide">
				<div class="span6">
					<input autocomplete="off" type="text" class="height" value="'.esc_attr($height).'" />
				</div>
				<div class="span6">
					<strong>Height</strong><br/>
					<p>Height of the image field</p>
				</div>
			</div>
			<div class="row-fluid hide">
				<div class="span6">
					<input autocomplete="off" type="text" class="min_width" value="'.esc_attr($min_width).'" />
				</div>
				<div class="span6">
					<strong>Min Width</strong><br/>
					<p>Min width value for responsive screen size. Regular width will be setted according to the column width</p>
				</div>
			</div>
			<div class="row-fluid hide">
				<div class="span6">
					<select class="activate_navigation" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($activate_navigation == 'true' ? 'selected="selected"' : '').'>Activate Navigation</option>
						<option value="false" '.($activate_navigation == 'false' ? 'selected="selected"' : '').'>Do Not Activate Navigation</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Navigation</strong><br/>
					<p>If you activate navigation, there will be two buttons to go to next and previous logo groups.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary beforeafterslider-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_beforeafterslider_modal_ajax(){
	echo xr_make_beforeafterslider_modal();
	exit;
}
add_action('wp_ajax_xr_make_beforeafterslider_modal','xr_make_beforeafterslider_modal_ajax');







/*
**	Team Members Modal
*/

function xr_make_teammembers_modal($modal=null,$id=null){
	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$script = '';
	$return = '';

	
	$teammembersString = '												
		<li class="teammembers-block active">
			<div class="hide secret-desc" company="RockthemesNet" teammembers-title="teammembers Awesome" icon_class="" icon_url="" external_url="" member_image_url="" member_image_id="" data-text=""></div>
			<div class="hide social_data"></div>
			<div class="hide social_shortcode"></div>
			<i class="drag fa fa-arrows"></i>
			<span class="teammembers-name" ref="'.$id.'" teammembers-index="0">teammembers Awesome</span>
			<i class="close fa fa-times"></i>
		</li>
		<li class="teammembers-block active">
			<div class="hide secret-desc" company="RockthemesNet" teammembers-title="teammembers Awesome" icon_class="" icon_url="" external_url="" member_image_url="" member_image_id="" data-text=""></div>
			<div class="hide social_data"></div>
			<div class="hide social_shortcode"></div>
			<i class="drag fa fa-arrows"></i>
			<span class="teammembers-name" ref="'.$id.'" teammembers-index="1">teammembers Awesome</span>
			<i class="close fa fa-times"></i>
		</li>
		';
	
	if(!$is_ajax){
		extract($modal['modal']['data']['data']);
			
		$teammembersString = '';

		if(isset($modal['modal']['data']['data']['teammembers']) && is_array($modal['modal']['data']['data']['teammembers'])){
			foreach($modal['modal']['data']['data']['teammembers'] as $teammembers){
				$image_id = isset($teammembers['member_image_id']) ? $teammembers['member_image_id'] : '';
				$teammembersString .= '
					<li class="teammembers-block">
						<div class="hide secret-desc" company="'.esc_attr($teammembers['company']).'" teammembers-title="'.esc_attr($teammembers['title']).'"  external_url="'.esc_url($teammembers['external_url']).'" member_image_url="'.esc_url($teammembers['member_image_url']).'" member_image_id="'.esc_attr($image_id).'" data-text="'.esc_attr(isset($teammembers['text']) ? $teammembers['text'] : '').'"></div>
						<div class="hide social_data">'.esc_html($teammembers['social_data']).'</div>
						<div class="hide social_shortcode">'.esc_html($teammembers['social_shortcode']).'</div>
						<i class="drag fa fa-arrows"></i>
						<span class="teammembers-name" ref="'.$id.'">'.esc_html($teammembers['title']).'</span>
						<i class="close fa fa-times"></i>
					</li>';						
			}
		}
			
		$script = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery("#'.$id.' .teammembers-list" ).sortable({
						handle : "i.drag",
					});
				});
			</script>';
	}
	

						
	$return .= '
		<div id="'.$id.'" modalType="teammembers" class="rpb_modal container hide fade" >
			<div class="modal-header">
				<div class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></div>
				'.rock_builder_item_trans_btn(array(
					'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
				)).'
				<h3>Add Team Members</h3>
			</div>
			<div class="modal-body" data-saved="false">
				<div class="row-fluid">
					<div class="teammembers-elements-holder span6">
						<ul class="teammembers-list">
							'.$teammembersString.'
						</ul>
						<div class="btn btn-small add-new-teammembers-btn" ref="'.$id.'"><i class="fa fa-plus"></i> Add</div>
					</div>
					<div class="span6">
						<strong>Add/Remove teammembers</strong><br/>
						<p>You can easily add remove teammembers by clicking to add new button</p>
					</div>
				</div>
				<hr/>
				'.rock_builder_get_block_grid_list(
					(isset($modal['modal']['data']['data']['block_grid_large']) ? intval($modal['modal']['data']['data']['block_grid_large']) : ''),
					(isset($modal['modal']['data']['data']['block_grid_medium']) ? intval($modal['modal']['data']['data']['block_grid_medium']) : ''),
					(isset($modal['modal']['data']['data']['block_grid_small']) ? intval($modal['modal']['data']['data']['block_grid_small']) : '')
				).'
			</div>
			<div class="modal-footer">
				<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
				<div class="btn btn-primary teammembers-save">Save changes</div>
			</div>
		</div>';
					
	return $return.$script;
	
	exit;
}

function xr_make_teammembers_modal_ajax(){
	echo xr_make_teammembers_modal();
	exit;
}
add_action('wp_ajax_xr_make_teammembers_modal', 'xr_make_teammembers_modal_ajax');





function rock_make_single_teammembers_modal($teammembersObj=null, $id=null){
	
	$social = (array('social_data' => '', 'social_shortcode' => ''));
	$member_image_url = '';
	$member_image_id = '';
	
	if(isset($_REQUEST['teammembers_obj'])){
		$teammembersObj = $_REQUEST['teammembers_obj'];	
		$id = $teammembersObj['id'];
		extract($teammembersObj);
		
		$social = array(
			'social_data' => (stripslashes($teammembersObj['social_data'])), 
			'social_shortcode' => stripslashes($teammembersObj['social_shortcode']),
		);
		
		/*
		if(isset($teammembersObj['member_image_url'])){
			$member_image_url = $teammembersObj['member_image_url'];
		}
		*/
	}
		
	
	$return = '
		<div id="teammembers-single-modal" modalType="teammembers" class="rpb_modal container hide fade">
			<div class="modal-header">
				<div class="close close-teammembers-single"><i class="fa fa-times"></i></div>
					<h3>Add Team Member</h3>
				</div>
				<div class="modal-body" data-saved="false">
					<div class="row-fluid">
						<div class="span6">
							<input autocomplete="off" name="teammembers_header" class="teammembers_header" type="text" value="'.esc_attr(stripslashes($teammembersObj['title'])).'" />
						</div>
						<div class="span6">
							<strong>Name</strong><br/>
							<p>Name area</p>
						</div>
					</div>
					<hr/>
					<div class="row-fluid">
						<div class="span6">
							<input autocomplete="off" name="company" class="company" type="text" value="'.esc_attr($teammembersObj['company']).'" />
						</div>
						<div class="span6">
							<strong>Company / Position</strong><br/>
							<p>Company name or the position of the user</p>
						</div>
					</div>
					<hr/>
					<div class="row-fluid">
						<div class="span6">
							<input autocomplete="off" name="external_url" class="external_url" type="text" value="'.esc_url($teammembersObj['external_url']).'" />
						</div>
						<div class="span6">
							<strong>External URL</strong><br/>
							<p>If you want to add an external URL, you can enter your URL here.</p>
						</div>
					</div>
					<hr/>
					<div class="row-fluid">
						<div class="span6">
							<div class="member-modal-image" ref="member-image-uploader">
								<h4>Choose an Image</h4>
								<div class="hide image-data"></div>
								<label for="upload_image"> <input autocomplete="off" id="member-image-uploader" class="upload_image_button member_image_url" size="36" name="upload_image" type="text" value="'.esc_url($member_image_url).'" image_id="'.esc_attr($member_image_id).'" /> <input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" /> </label><br/>
							</div>
						</div>
						<div class="span6">
							<strong>Member Image</strong><br/>
							<p>You can easily upload your team member image.</p>
						</div>
					</div>
					<hr/>
					<div class="row-fluid">
						<div class="span6">
							<div class="social_icons_class" ref="0">
								<input autocomplete="off" class="social_data" id="social-'.$id.'" type="hidden" value="'.esc_attr(($social['social_data'])).'" />
								<input autocomplete="off" class="social_shortcode" id="social-'.$id.'-shortcode" type="text" value="'.esc_attr(($social['social_shortcode'])).'" />
								<div class="button call_social_icons_external" id_ref="social-'.$id.'-shortcode" id_data_ref="social-'.$id.'">Add Social Icons</div>
							</div>
						</div>
						<div class="span6">
							<strong>Social Icons</strong><br/>
							<p>You can add social icons to your team member with their social media links</p>
						</div>
					</div>
					<hr/>
					<div class="row-fluid">
						<div class="span12 teammembers-list">
							<strong>Team member Content</strong><br/>
							<p>Enter your content here. You can use the Rich Text Editor for your content.</p>
							<br/>
							<div class="rock-tinymce-container wp-core-ui wp-editor-wrap tmce-active">
								<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
									<div class="wp-editor-tabs">
										<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
										<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
									</div>
									<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="teammembers-single-modal-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
								</div>
								<div class="wp-content-editor-container wp-editor-container">
									<textarea rows="8" cols="40" class="rock-tinymce-textarea description" initialized="true" name="teammembers-single-modal-editor" id="teammembers-single-modal-editor" class="wp-editor-area"></textarea>
								</div>
							</div>
						</div>
					</div>
				<hr/>
			</div>
			<div class="modal-footer">
				<div class="btn close-teammembers-single">Close</div>
				<div class="btn btn-primary teammembers-single-save" ref="'.esc_attr($teammembersObj['index']).'" modal-ref="'.$id.'">Save changes</div>
			</div>
		</div>';


	return $return;
}

function rock_make_single_teammembers_modal_ajax(){
	echo rock_make_single_teammembers_modal();	
	exit;
}

add_action('wp_ajax_rock_make_single_teammembers_modal', 'rock_make_single_teammembers_modal_ajax');






/*
**	Social Icons Modal
*/

function xr_make_socialicons_modal($modal=null,$id=null){
	$is_ajax = false;

	$remove_modal_after = false;
	$return_to = '';
	
	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
		$remove_modal_after = (isset($modal_obj['remove_modal_after']) && $modal_obj['remove_modal_after']) == 'true' ? true : false;
		$return_to = isset($modal_obj['return_to']) ? $modal_obj['return_to'] : '';
		$return_data_to = isset($modal_obj['return_data_to']) ? $modal_obj['return_data_to'] : '';
	}
	
	
	$socialiconsString = '												
		<li class="socialicons-block active">
			<div class="hide secret-desc" socialicons-title="http://www.facebook.com" icon_class="icomoon icomoon-icon-facebook" icon_url=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="socialicons-name" ref="'.$id.'" socialicons-index="0">http://www.facebook.com</span>
			<i class="close fa fa-times"></i>
		</li>
		<li class="socialicons-block">
			<div class="hide secret-desc"  socialicons-title="http://www.twitter.com" icon_class="icomoon icomoon-icon-twitter" icon_url=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="socialicons-name" ref="'.$id.'" socialicons-index="1">http://www.twitter.com</span>
			<i class="close fa fa-times"></i>
		</li>
		<li class="socialicons-block active">
			<div class="hide secret-desc" socialicons-title="http://www.youtube.com" icon_class="icomoon icomoon-icon-youtube" icon_url=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="socialicons-name" ref="'.$id.'" socialicons-index="2">http://www.youtube.com</span>
			<i class="close fa fa-times"></i>
		</li>
		<li class="socialicons-block">
			<div class="hide secret-desc"  socialicons-title="http://www.dribbble.com" icon_class="icomoon icomoon-icon-dribbble" icon_url=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="socialicons-name" ref="'.$id.'" socialicons-index="3">http://www.dribbble.com</span>
			<i class="close fa fa-times"></i>
		</li>';

	
	
		if(isset($modal_obj['saved_data']) && !empty($modal_obj['saved_data'])){
					
			$saved_data = json_decode(stripslashes($modal_obj['saved_data']), true);
			
			if(isset($saved_data) && !empty($saved_data) && isset($saved_data['data']) && !empty($saved_data['data'])){
				extract($saved_data['data']);	
				
				$socialiconsString = '';
				
				foreach($socialicons as $icon){					
					$socialiconsString .= '
						<li class="socialicons-block">
							<div class="hide secret-desc" socialicons-title="'.esc_attr($icon['title']).'" icon_class="'.esc_attr($icon['icon_class']).'" icon_url="'.esc_url($icon['icon_url']).'"></div>
							<i class="drag fa fa-arrows"></i>
							<span class="socialicons-name" ref="'.$id.'">'.esc_html($icon['title']).'</span>
							<i class="close fa fa-times"></i>
						</li>';						
				}
			}
		}

	
	$return = '';
	
	$boxed_layout = 'false';
	$script = '';
	
	
		if(!$is_ajax){
			extract($modal['modal']['data']['data']);
								
			$socialiconsString = '';

			if(isset($modal['modal']['data']['data']['socialicons']) && is_array($modal['modal']['data']['data']['socialicons'])){
				foreach($modal['modal']['data']['data']['socialicons'] as $socialicons){
					$socialiconsString .= '
						<li class="socialicons-block">
							<div class="hide secret-desc" socialicons-title="'.esc_attr($socialicons['title']).'" icon_class="'.esc_attr($socialicons['icon_class']).'" icon_url="'.esc_url($socialicons['icon_url']).'"></div>
							<i class="drag fa fa-arrows"></i>
							<span class="socialicons-name" ref="'.$id.'">'.esc_html($socialicons['title']).'</span>
							<i class="close fa fa-times"></i>
						</li>';						
				}
			}
			
		}
		
		
		$script = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery(".socialicons-list" ).sortable({
						handle : "i.drag"
					});
				});
			</script>
		';
		
						
		$return .= 
			'<div id="'.$id.'" modalType="socialicons" class="rpb_modal container hide fade '.(!$remove_modal_after ? '' : 'external-modal-call' ).'" >
				<div class="modal-header">
					<div class="close '.(!$remove_modal_after ? 'builder-close' : 'close-grid-modal' ).'"><i class="fa fa-times"></i></div>
					'.rock_builder_item_trans_btn(array(
						'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
					)).'
					<h3>Add Social Icon</h3>
				</div>
				<div class="modal-body" data-saved="false">				
					<div class="row-fluid">
						<div class="socialicons-elements-holder span6">
							<ul class="socialicons-list">
								'.$socialiconsString.'
							</ul>
						<div class="btn btn-small add-new-socialicons-btn" ref="'.$id.'"><i class="fa fa-plus"></i> Add</div>
					</div>
					<div class="span6">
						<strong>Add/Remove Social Icons</strong><br/>
						<p>You can easily add remove social icons by clicking to add new button</p>
					</div>
				</div>
				<hr/>
			</div>
			<div class="modal-footer">
				<div class="btn '.(!$remove_modal_after ? 'builder-close' : 'close-grid-modal' ).'">Close</div>
				<div class="btn btn-primary '.(!$remove_modal_after ? 'socialicons-modal-save builder-close' : 'save-remove-socialicons-modal' ).'" '.($remove_modal_after ? 'return_to="'.esc_attr($return_to).'" return_data_to="'.esc_attr($return_data_to).'"' : '').' ref="'.$id.'">Save changes</div>
			</div>
		</div>';
					
		return $return.$script;
	
	exit;
}

function xr_make_socialicons_modal_ajax(){
	echo xr_make_socialicons_modal();
	exit;
}
add_action('wp_ajax_xr_make_socialicons_modal', 'xr_make_socialicons_modal_ajax');





function rock_make_single_socialicons_modal($socialiconsObj=null, $id=null){
			
	$icon_class = '';
	$icon_url = '';
		
	
	if(isset($_REQUEST['socialicons_obj'])){
		$socialiconsObj = $_REQUEST['socialicons_obj'];	
		$id = $socialiconsObj['id'];
		if(!empty($socialiconsObj)){
			extract($socialiconsObj);	
		}
	}
				
	$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;
	
	
	
	$return = '
		<div id="socialicons-single-modal" modalType="socialicons" class="rpb_modal container hide fade">
			<div class="modal-header">
				<div class="close close-socialicons-single"><i class="fa fa-times"></i></div>
					<h3>Add Social Icon</h3>
				</div>
			<div class="modal-body" data-saved="false">
				<div class="row-fluid">
					<div class="span6 elem-icon">
						<div class="icon-holder add-elem-icon-btn" icon-ref="'.esc_attr($icon_class).'">'.(($icon_class != "") ? '<i class="'.esc_attr($icon_class).' fa-4x"></i>' : '').'</div><br/>
						<input autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.($icon_url != "" ? esc_url($icon_url) : "").'"/>
						'.(!$icon_used ? '<div class="add-elem-icon-btn btn">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
						'.($icon_used ? '<div class="remove-elem-icon-btn btn">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn hide">Remove Icon</div>').'
					</div>
					<div class="span6">
						<strong>Button Icon</strong><br/>
						<p>Choose an icon (Optional)</p>
					</div>
				</div>
				<hr/>									
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" name="socialicons_header" class="socialicons_header" type="text" value="'.esc_attr($socialiconsObj['title']).'" />
					</div>
					<div class="span6">
						<strong>URL</strong><br/>
						<p>Enter your link url</p>
					</div>
				</div>
				<hr/>
			</div>
			<div class="modal-footer">
				<div class="btn close-socialicons-single">Close</div>
				<div class="btn btn-primary socialicons-single-save" ref="'.esc_attr($socialiconsObj['index']).'" modal-ref="'.$id.'">Save changes</div>
			</div>
		</div>';


	return $return;
}

function rock_make_single_socialicons_modal_ajax(){
	echo rock_make_single_socialicons_modal();	
	exit;
}

add_action('wp_ajax_rock_make_single_socialicons_modal', 'rock_make_single_socialicons_modal_ajax');




/*
**	Testimonials Builder Modal
*/

function xr_make_testimonialsbuilder_modal($modal=null,$id=null){
	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$return = '';
	
	$boxed_layout = 'false';
	$use_shadow = 'false';
	$auto_slide = 'true';
	$duration_time = 5000;
	$activate_navigation = 'true';
	$script = '';
	
	$testimonialsString = '												
		<li class="testimonialsbuilder-block active">
			<div class="hide secret-desc" company="RockthemesNet" testimonialsbuilder-title="Testimonials Awesome" icon_class="" icon_url="" testimonials_image="" testimonials_image_id="" data-text=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="testimonialsbuilder-name" ref="'.$id.'" testimonialsbuilder-index="0">Testimonials Awesome</span>
			<i class="close fa fa-times"></i>
		</li>
		<li class="testimonialsbuilder-block">
			<div class="hide secret-desc" company="RockthemesNet" testimonialsbuilder-title="Testimonials Awesome" icon_class="" icon_url="" testimonials_image="" testimonials_image_id="" data-text=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="testimonialsbuilder-name" ref="'.$id.'" testimonialsbuilder-index="1">Testimonials Awesome</span>
			<i class="close fa fa-times"></i>
		</li>';
	
		if(!$is_ajax){
			extract($modal['modal']['data']['data']);
			
			$boxed_layout = checked("true", (isset($modal['modal']['data']['data']['boxed_layout']) ? $modal['modal']['data']['data']['boxed_layout'] : false ), false);
		
			$testimonialsString = '';

			if(isset($modal['modal']['data']['data']['testimonials']) && is_array($modal['modal']['data']['data']['testimonials'])){
				foreach($modal['modal']['data']['data']['testimonials'] as $testimonials){
					$t_img = isset($testimonials['testimonials_image']) ? $testimonials['testimonials_image'] : '';
					$t_img_id = isset($testimonials['testimonials_image_id']) ? $testimonials['testimonials_image_id'] : '';
					$testimonialsString .= '
						<li class="testimonialsbuilder-block">
							<div class="hide secret-desc" company="'.esc_attr($testimonials['company']).'" testimonialsbuilder-title="'.esc_attr($testimonials['title']).'" testimonials_image="'.esc_url($t_img).'" testimonials_image_id="'.esc_attr($t_img_id).'" data-text="'.esc_attr($testimonials['text']).'"></div>
							<i class="drag fa fa-arrows"></i>
							<span class="testimonialsbuilder-name" ref="'.$id.'">'.esc_html($testimonials['title']).'</span>
							<i class="close fa fa-times"></i>
						</li>';						
				}
			}
			
			$script = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery("#'.$id.' .testimonialsbuilder-list" ).sortable({
						handle : "i.drag",
					});
				});
			</script>';
		}
						
			$return .= 
			'<div id="'.$id.'" modalType="testimonialsbuilder" class="rpb_modal container hide fade" >
								<div class="modal-header">
									<div class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></div>
									'.rock_builder_item_trans_btn(array(
										'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
									)).'
									<h3>Testimonials Builder</h3>
								</div>
								<div class="modal-body" data-saved="false">
								
									<div class="row-fluid">
										<div class="testimonialsbuilder-elements-holder span6">
											<ul class="testimonialsbuilder-list">
												'.$testimonialsString.'
											</ul>
											<div class="btn btn-small add-new-testimonialsbuilder-btn" ref="'.$id.'"><i class="fa fa-plus"></i> Add</div>
										</div>
										<div class="span6">
											<strong>Add/Remove Testimonials</strong><br/>
											<p>You can easily add remove testimonials by clicking to add new button</p>
										</div>
									</div>
									<hr/>
									
									
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="duration_time" value="'.esc_attr($duration_time).'" />
				</div>
				<div class="span6">
					<strong>Duration</strong><br/>
					<p>Duration time between two slides. An integer in milliseconds</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<select class="activate_navigation" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($activate_navigation == 'true' ? 'selected="selected"' : '').'>Activate Navigation</option>
						<option value="false" '.($activate_navigation == 'false' ? 'selected="selected"' : '').'>Do Not Activate Navigation</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Navigation</strong><br/>
					<p>If you activate navigation, there will be two buttons to go to next and previous logo groups.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="auto_slide" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($auto_slide == 'true' ? 'selected="selected"' : '').'>Activate Auto Slide</option>
						<option value="false" '.($auto_slide == 'false' ? 'selected="selected"' : '').'>Do Not Activate Auto Slide</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Auto Slide</strong><br/>
					<p>If you activate auto slide, references will be sliding automatically.</p>
				</div>
			</div>
			<hr/>
									
									<div class="row-fluid">
										<div class="span6">
											<div class="boxed_layout_holder">
												<input autocomplete="off" class="boxed_layout" type="checkbox" value="true" name="boxed_layout" '.$boxed_layout.' /><label for="activate_hover"> Use Boxed Layout</label>
											</div>
										</div>
										<div class="span6">
											<strong>Boxed Layout</strong><br/>
											<p>If you want to wrap a boxed layout around this element, check this option.</p>
										</div>										
									</div>
									<hr/>
								</div>
								<div class="modal-footer">
									<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
									<div class="btn btn-primary testimonialsbuilder-save">Save changes</div>
								</div>
							</div>';
					
		return $return.$script;
	
	exit;
}

function xr_make_testimonialsbuilder_modal_ajax(){
	echo xr_make_testimonialsbuilder_modal();
	exit;
}
add_action('wp_ajax_xr_make_testimonialsbuilder_modal', 'xr_make_testimonialsbuilder_modal_ajax');





function rock_make_single_testimonialsbuilder_modal($testimonialsbuilderObj=null, $id=null){
	
	$testimonials_image = '';
	$testimonials_image_id = '';
	
	if(isset($_REQUEST['testimonials_obj'])){
		$testimonialsbuilderObj = $_REQUEST['testimonials_obj'];	
		$id = $testimonialsbuilderObj['id'];
		/*
		$testimonials_image = $testimonialsbuilderObj['testimonials_image'];
		$testimonials_image_id = $testimonialsbuilderObj['testimonials_image_id'];
		*/
		extract($testimonialsbuilderObj);
	}
	
	
	$return = '<div id="testimonialsbuilder-single-modal" modalType="testimonialsbuilder" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Testimonials Builder" aria-hidden="true" data-focus-on="input:first">
								<div class="modal-header">
									<div class="close close-testimonialsbuilder-single"><i class="fa fa-times"></i></div>
					  				<h3>Add Testimonials</h3>
								</div>
								<div class="modal-body" data-saved="false">
									<div class="row-fluid">
										<div class="span6">
											<input autocomplete="off" name="testimonialsbuilder_header" class="testimonialsbuilder_header" type="text" value="'.esc_attr(stripslashes($testimonialsbuilderObj['title'])).'" />
										</div>
										<div class="span6">
											<strong>Name</strong><br/>
											<p>Name area</p>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<input autocomplete="off" name="company" class="company" type="text" value="'.esc_attr($testimonialsbuilderObj['company']).'" />
										</div>
										<div class="span6">
											<strong>Company / Position</strong><br/>
											<p>Company name or the position of the user</p>
										</div>
									</div>
									<hr/>
									
				<div class="row-fluid">
					<div class="span6">
						<div class="testimonials_image_holder" ref="parallax-bg-image-holder">
							<div class="hide image-data"></div>
							<label for="upload_image"> 
								<input autocomplete="off" id="testimonial_image-'.$id.'" class="upload_image_button testimonials_image" size="36" name="upload_image" type="text" value="'.esc_attr($testimonials_image).'" image_id="'.esc_attr($testimonials_image_id).'" />
								<input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" /> 
							</label>
							<br/>
						</div>
					</div>
					<div class="span6">
						<strong>Image</strong><br/>
						<p>You can choose to upload an image (Optional)</p>
					</div>
				</div>
				<hr/>
									<div class="row-fluid">
										<div class="span12 testimonialsbuilder-list">
											<strong>Testimonials Content</strong><br/>
											<p>Enter your content here. You can use the Rich Text Editor for your content.</p>
											<br/>
											<div class="rock-tinymce-container wp-core-ui wp-editor-wrap tmce-active">
												<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
													<div class="wp-editor-tabs">
														<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
														<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
													</div>
													<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="testimonialsbuilder-single-modal-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
												</div>
												<div class="wp-content-editor-container wp-editor-container">
													<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" initialized="true" name="testimonialsbuilder-single-modal-editor" id="testimonialsbuilder-single-modal-editor"></textarea>
												</div>
											</div>
										</div>
									</div>
									<hr/>
								</div>
								<div class="modal-footer"><div class="btn close-testimonialsbuilder-single">Close</div><div class="btn btn-primary testimonialsbuilder-single-save" ref="'.esc_attr($testimonialsbuilderObj['index']).'" modal-ref="'.$id.'">Save changes</div></div></div>';


	return $return;
}

function rock_make_single_testimonialsbuilder_modal_ajax(){
	echo rock_make_single_testimonialsbuilder_modal();	
	exit;
}

add_action('wp_ajax_rock_make_single_testimonialsbuilder_modal', 'rock_make_single_testimonialsbuilder_modal_ajax');






/*
**	References Builder Modal
**
**	Named as "References Builder". Because there will be another references with Custom Post Types
*/
function xr_make_referencesbuilder_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$saved_logos = '
		<div class="references-single-item" item-ref="0">
			<div class="row-fluid">
				<div class="span6">
					<div class="hr-modal-image" ref="icon-image-uploader">
						<div class="hide image-data"></div>
						<label for="upload_image"> <input autocomplete="off" id="icon-image-uploader-'.$id.'0" class="upload_image_button" size="36" name="upload_image" type="text" image_id="" value="" /> <input autocomplete="off" class="image_uploader_class button" value="Upload Image" type="button" /> </label><br/>
					</div>
				</div>
				<div class="span6">
					<input autocomplete="off" type="text" class="link_url" value="" />
					<div class="button references-single-item-remove"><i class="fa fa-times"></i> Remove References</div>
				</div>
			</div>
			<hr class="no-margin"/>
			<br/>
		</div>
	';
	
	//Default Values
	$duration_time			=	5000;
	$activate_navigation	=	'true';
	$auto_slide				=	'true';
	$image_size				=	'medium';
	
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
	
	if(isset($saved_logo_data) && !empty($saved_logo_data)){
		$saved_logos = '';
		$logo_counter = 0;
		foreach($saved_logo_data as $logo){
			$saved_logos .= '
				<div class="references-single-item" item-ref="'.$logo_counter.'">
					<div class="row-fluid">
						<div class="span6">
							<div class="hr-modal-image" ref="icon-image-uploader">
								<div class="hide image-data"></div>
								<label for="upload_image">
									<input autocomplete="off" id="icon-image-uploader-'.$id.$logo_counter.'" class="upload_image_button" size="36" name="upload_image" type="text" value="'.$logo['img_url'].'" image_id="'.(isset($logo['img_id']) ? $logo['img_id'] : '').'" />
									<input autocomplete="off" class="image_uploader_class button" value="Upload Image" type="button" />
								</label>
								<br/>
							</div>
						</div>
						<div class="span6">
							<input autocomplete="off" type="text" class="link_url" value="'.$logo['link_url'].'" />
							<div class="button references-single-item-remove"><i class="fa fa-times"></i> Remove References</div>
						</div>
					</div>
					<hr class="no-margin"/>
					<br/>
				</div>
			';
			
			$logo_counter++;
		}
	}
	
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>References Builder</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6 image_sizes_holder">
					'.rock_builder_get_image_sizes($image_size, $id, '').'
				</div>
				<div class="span6">
					<strong>Choose a Size</strong></br>
					<p>You can choose different image sizes for your image. You can also adjust image sizes in Theme Options</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6 references-container">
					'.$saved_logos.'
				</div>
				<div class="span6">
					<strong>Add /  Remove References</strong><br/>
					<p>You can add / remove references as you want. You can also add link to your references.</p>
					<p><strong>Left Text Field : </strong> Image URL
					<br/>
					<strong>Right Text Field : </strong> Link URL</p>
					<div class="button references-single-item-add" ref="'.$id.'"><i class="fa fa-plus"></i> Add New Reference</div>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="duration_time" value="'.$duration_time.'" />
				</div>
				<div class="span6">
					<strong>Duration</strong><br/>
					<p>Duration time between two slides. An integer in milliseconds</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="activate_navigation" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($activate_navigation == 'true' ? 'selected="selected"' : '').'>Activate Navigation</option>
						<option value="false" '.($activate_navigation == 'false' ? 'selected="selected"' : '').'>Do Not Activate Navigation</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Navigation</strong><br/>
					<p>If you activate navigation, there will be two buttons to go to next and previous logo groups.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="auto_slide" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($auto_slide == 'true' ? 'selected="selected"' : '').'>Activate Auto Slide</option>
						<option value="false" '.($auto_slide == 'false' ? 'selected="selected"' : '').'>Do Not Activate Auto Slide</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Auto Slide</strong><br/>
					<p>If you activate auto slide, references will be sliding automatically.</p>
				</div>
			</div>
			<hr/>
			'.rock_builder_get_block_grid_list(
				(isset($modal['modal']['data']['data']['block_grid_large']) ? intval($modal['modal']['data']['data']['block_grid_large']) : ''),
				(isset($modal['modal']['data']['data']['block_grid_medium']) ? intval($modal['modal']['data']['data']['block_grid_medium']) : ''),
				(isset($modal['modal']['data']['data']['block_grid_small']) ? intval($modal['modal']['data']['data']['block_grid_small']) : '')
			).'
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary googlemap-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_referencesbuilder_modal_ajax(){
	echo xr_make_referencesbuilder_modal();
	exit;
}
add_action('wp_ajax_xr_make_referencesbuilder_modal','xr_make_referencesbuilder_modal_ajax');





/*
**	Alert Box Modal
*/
function xr_make_alertbox_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	//Default Values
	$content			=	'';
	$background_color	=	'';
	$font_color			=	'';
	$border_color		=	'';
	$alertbox_style		=	'info';
	$iconClass			=	'';
	$iconURL			=	'';
	$use_close_button	=	'true';
	
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
	
			
	$icon_class = $iconClass;
	$icon_url = $iconURL;
	$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;



	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Alert Box" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Alert Box</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<select class="alertbox_style" autocomplete="off" ref="'.$id.'">
						<option value="alert" '.($alertbox_style == 'alert' ? 'selected="selected"' : '').'>Alert (Red)</option>
						<option value="success" '.($alertbox_style == 'success' ? 'selected="selected"' : '').'>Success (Green)</option>
						<option value="info" '.($alertbox_style == 'info' ? 'selected="selected"' : '').'>Info (Blue)</option>
						<option value="caution" '.($alertbox_style == 'caution' ? 'selected="selected"' : '').'>Caution (Orange)</option>
						<option value="custom" '.($alertbox_style == 'custom' ? 'selected="selected"' : '').'>Custom Style</option>
					</select>
				</div>
				<div class="span6">
					<strong>Choose Alert Box Model</strong><br/>
					<p>There are different predeifned alert boxes you can easily select. If you want to change colors, you can always use Custom Style to adjust colors.</p>
				</div>
			</div>
			<hr/>
			<div class="custom_alertbox_style row-fluid '.($alertbox_style != 'custom' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<div class="background_color">
							'.rockbuilder_make_colorpicker($id.'-bg-colorpicker', $background_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Background Color</strong><br/>
						<p>Choose alert box background color</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<div class="font_color">
							'.rockbuilder_make_colorpicker($id.'-font-colorpicker', $font_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Font Color</strong><br/>
						<p>Choose alert box font color</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<div class="border_color">
							'.rockbuilder_make_colorpicker($id.'-border-colorpicker', $border_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Border Color</strong><br/>
						<p>Choose alert box border color</p>
					</div>
				</div>
				<hr/>
			</div>
			<div class="row-fluid">
				<div class="span12 textarea-holder">
					<strong>Alert Box Text</strong><br/>
					<p>Enter your alert box text.</p>
					<br/>
					<div class="rock-tinymce-container wp-core-ui wp-editor-wrap html-active">
						<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
							<div class="wp-editor-tabs">
								<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
								<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
							</div>
							<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="'.$id.'-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
						</div>
						<div class="wp-content-editor-container wp-editor-container">
							<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" name="'.$id.'-editor" id="'.$id.'-editor">'.($content).'</textarea>
						</div>
						<div class="tinymce-hidden-data hide" data-text="'.esc_attr($content).'"></div>
					</div>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="use_close_button" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($use_close_button == 'true' ? 'selected="selected"' : '').'>Use Close Symbol</option>
						<option value="false" '.($use_close_button == 'false' ? 'selected="selected"' : '').'>Do not Use Close Symbol</option>
					</select>
				</div>
				<div class="span6">
					<strong>Use Close Symbol</strong><br/>
					<p>Close symbol will add a close icon at the right top. When clicked it will close the alert box.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6 elem-icon">
					<div class="icon-holder add-elem-icon-btn" icon-ref="'.esc_attr($icon_class).'">'.(($icon_class != "") ? '<i class="'.esc_attr($icon_class).' fa-4x"></i>' : '').'</div><br/>
					<input autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.($icon_url != "" ? esc_url($icon_url) : "").'"/>
					'.(!$icon_used ? '<div class="add-elem-icon-btn btn">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
					'.($icon_used ? '<div class="remove-elem-icon-btn btn">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn hide">Remove Icon</div>').'
				</div>
				<div class="span6">
					<strong>Button Icon</strong><br/>
					<p>Choose an icon (Optional)</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary googlemap-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';



	return $return;
}
function xr_make_alertbox_modal_ajax(){
	echo xr_make_alertbox_modal();
	exit;
}
add_action('wp_ajax_xr_make_alertbox_modal','xr_make_alertbox_modal_ajax');






/*
**	Promotion Box Modal
*/
function xr_make_promotionbox_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	//Default Values
	$content			=	'';
	$button_json_data	=	'';
	$button_shortcode	=	json_encode('');
	$background_color	=	'#333333';
	$font_color			=	'#FFFFFF';
	
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
		
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Promotion Box" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Promotion Box</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<div class="background_color">
						'.rockbuilder_make_colorpicker($id.'-bg-colorpicker', $background_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Background Color</strong><br/>
					<p>Choose promotion box background color</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="font_color">
						'.rockbuilder_make_colorpicker($id.'-font-colorpicker', $font_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Font Color</strong><br/>
					<p>Choose promotion box font color</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6 promotion-box-button">
					<input autocomplete="off" id="'.$id.'_button_data" class="button_json_data" type="hidden" value="'.esc_attr($button_json_data).'" />
					<input autocomplete="off" id="'.$id.'_button_shortcode" class="button_shortcode" type="hidden" value="'.esc_attr($button_shortcode).'" />
					<div class="btn advanced_details_make_button_modal" id_ref="'.$id.'_button_shortcode" id_data_ref="'.$id.'_button_data"><i class="fa fa-gear"></i> Edit Button</div>
				</div>
				<div class="span6">
					<strong>Button</strong><br/>
					<p>Edit the button settings of the Promotion Box</p>
				</div>
			</div>
			<hr/>			
			<div class="row-fluid">
				<div class="span12 textarea-holder">
					<strong>Promotion Box Text</strong><br/>
					<p>Enter your promotion box text.</p>
					<br/>
					<div class="rock-tinymce-container wp-core-ui wp-editor-wrap html-active">
						<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
							<div class="wp-editor-tabs">
								<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
								<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
							</div>
							<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="'.$id.'-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
						</div>
						<div class="wp-content-editor-container wp-editor-container">
							<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" name="'.$id.'-editor" id="'.$id.'-editor">'.($content).'</textarea>
						</div>
						<div class="tinymce-hidden-data hide" data-text="'.esc_html($content).'"></div>
					</div>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary googlemap-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	return $return;
}
function xr_make_promotionbox_modal_ajax(){
	echo xr_make_promotionbox_modal();
	exit;
}
add_action('wp_ajax_xr_make_promotionbox_modal','xr_make_promotionbox_modal_ajax');





/*
**	Google Map Modal
*/

function xr_make_googlemap_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$api_key		=	'';
	$lat			=	'';
	$lng			=	'';
	$zoom_level		=	14;
	$marker_title	=	'';
	$height			=	400;
	$fullscreen		=	'false';
	$content		=	'';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}


	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Google Map" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Google Map (*Google Map is a Paid Service)</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="api_key" value="'.esc_attr($api_key).'" />
				</div>
				<div class="span6">
					<strong>Google Map Api Key</strong><br/>
					<p>You can get your Google Map Api Key from <a href="//code.google.com/apis/console" target="_blank">here</a></p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="lat" value="'.esc_attr($lat).'" />
				</div>
				<div class="span6">
					<strong>Latitude</strong><br/>
					<p>Enter your Latitude value</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="lng" value="'.esc_attr($lng).'" />
				</div>
				<div class="span6">
					<strong>Longitude</strong><br/>
					<p>Enter your Longitude value</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="zoom_level" value="'.esc_attr($zoom_level).'" />
				</div>
				<div class="span6">
					<strong>Zoom</strong><br/>
					<p>Enter your Zoom value</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="map_type" autocomplete="off">
						<option value="ROADMAP" '.($map_type == 'ROADMAP' ? 'selected="selected"' : '').'>ROADMAP</option>
						<option value="SATELLITE" '.($map_type == 'SATELLITE' ? 'selected="selected"' : '').'>SATELLITE</option>
						<option value="HYBRID" '.($map_type == 'HYBRID' ? 'selected="selected"' : '').'>HYBRID</option>
						<option value="TERRAIN" '.($map_type == 'TERRAIN' ? 'selected="selected"' : '').'>TERRAIN</option>
					</select>
				</div>
				<div class="span6">
					<strong>Map Type</strong><br/>
					<p>Choose your map type</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="mouse_wheel" autocomplete="off">
						<option value="true" '.($mouse_wheel == 'true' ? 'selected="selected"' : '').'>Enable Mouse Wheel To Zoom</option>
						<option value="false" '.($mouse_wheel == 'false' ? 'selected="selected"' : '').'>Disable Mouse Wheel</option>
					</select>
				</div>
				<div class="span6">
					<strong>Mouse Wheel To Zoom?</strong><br/>
					<p>You can choose to enable/disable mouse-wheel for zoom</p>
				</div>
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6">
					<select class="sensor" autocomplete="off">
						<option value="false" '.($sensor == 'false' ? 'selected="selected"' : '').'>Do Not Use Sensor</option>
						<option value="true" '.($sensor == 'true' ? 'selected="selected"' : '').'>Use Sensor</option>
					</select>
				</div>
				<div class="span6">
					<strong>Use Sensor</strong><br/>
					<p>Sensor will activate your visitor\'s GPS</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="marker_title" value="'.esc_attr($marker_title).'" />
				</div>
				<div class="span6">
					<strong>Marker Title</strong><br/>
					<p>This is the title when you hover your marker.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span12 textarea-holder">
					<strong>Info Box Description</strong><br/>
					<p>You can add info box description for your marker.</p>
					<br/>
					<div class="rock-tinymce-container wp-core-ui wp-editor-wrap html-active">
						<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
							<div class="wp-editor-tabs">
								<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
								<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
							</div>
							<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="'.$id.'-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
						</div>
						<div class="wp-content-editor-container wp-editor-container">
							<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" name="'.$id.'-editor" id="'.$id.'-editor">'.esc_textarea($content).'</textarea>
						</div>
						<div class="tinymce-hidden-data hide" data-text="'.esc_attr($content).'"></div>
					</div>
				</div>
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6 style_obj_holder">
					<textarea rows="4" cols="50" class="style_obj">'.(esc_js($style_obj)).'</textarea>
				</div>
				<div class="span6">
					<strong>Map Style</strong><br/>
					<p>You can style the map just as you like. To use this feature you will need a style object. You can get the style object from <a href="//snazzymaps.com/" target="_blank">here</a>. After you choose your map style simply copy the <strong>JavaScript Style Array</strong>.</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="height" value="'.esc_attr($height).'" />
				</div>
				<div class="span6">
					<strong>Height</strong><br/>
					<p>Enter your map height value as number. (Without px or em)</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="fullscreen" autocomplete="off">
						<option value="false" '.($fullscreen == 'false' ? 'selected="selected"' : '').'>Disable Fullscreen</option>
						<option value="true" '.($fullscreen == 'true' ? 'selected="selected"' : '').'>Enable Fullscreen</option>
					</select>
				</div>
				<div class="span6">
					<strong>Fullscreen</strong><br/>
					<p>You can enable fullscreen feature to display map in fullscreen.</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<select class="resize_height" autocomplete="off">
						<option value="false" '.($resize_height == 'false' ? 'selected="selected"' : '').'>Do Not Resize Height</option>
						<option value="true" '.($resize_height == 'true' ? 'selected="selected"' : '').'>Resize Height</option>
					</select>
				</div>
				<div class="span6">
					<strong>Resize Height</strong><br/>
					<p>If you choose to resize the map height, map will resize itself with same aspect ratio.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary googlemap-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	return $return;
}
function xr_make_googlemap_modal_ajax(){
	echo xr_make_googlemap_modal();
	exit;
}
add_action('wp_ajax_xr_make_googlemap_modal','xr_make_googlemap_modal_ajax');






/*
**	Leaflet Map Modal
*/

function xr_make_leafletmap_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$api_key		=	'';
	$lat			=	'';
	$lng			=	'';
	$zoom_level		=	8;
	$map_type		=	'ROADMAP';
	$marker_title	=	'';
	$mouse_wheel	=	'true';
	$sensor			=	'false';
	$height			=	400;
	$resize_height	=	'false';
	$style_obj		=	'';
	$fullscreen		=	'false';
	$content		=	'';
	
	if(!empty($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}


	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Leaflet Map" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>LeafLet Map</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="api_key" value="'.esc_attr($api_key).'" />
				</div>
				<div class="span6">
					<strong>LeafLet Map Api Key</strong><br/>
					<p>You can get your LeafLet Map Api Key from <a href="//www.mapbox.com/studio/account/tokens/" target="_blank">here</a></p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="lat" value="'.esc_attr($lat).'" />
				</div>
				<div class="span6">
					<strong>Latitude</strong><br/>
					<p>Enter your Latitude value</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="lng" value="'.esc_attr($lng).'" />
				</div>
				<div class="span6">
					<strong>Longitude</strong><br/>
					<p>Enter your Longitude value</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="zoom_level" value="'.esc_attr($zoom_level).'" />
				</div>
				<div class="span6">
					<strong>Zoom</strong><br/>
					<p>Enter your Zoom value</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span12 textarea-holder">
					<strong>Info Box Description</strong><br/>
					<p>You can add info box description for your marker.</p>
					<br/>
					<div class="rock-tinymce-container wp-core-ui wp-editor-wrap html-active">
						<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
							<div class="wp-editor-tabs">
								<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
								<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
							</div>
							<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="'.$id.'-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
						</div>
						<div class="wp-content-editor-container wp-editor-container">
							<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" name="'.$id.'-editor" id="'.$id.'-editor">'.esc_textarea($content).'</textarea>
						</div>
						<div class="tinymce-hidden-data hide" data-text="'.esc_attr($content).'"></div>
					</div>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="height" value="'.esc_attr($height).'" />
				</div>
				<div class="span6">
					<strong>Height</strong><br/>
					<p>Enter your map height value as number. (Without px or em)</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="fullscreen" autocomplete="off">
						<option value="false" '.($fullscreen == 'false' ? 'selected="selected"' : '').'>Disable Fullscreen</option>
						<option value="true" '.($fullscreen == 'true' ? 'selected="selected"' : '').'>Enable Fullscreen</option>
					</select>
				</div>
				<div class="span6">
					<strong>Fullscreen</strong><br/>
					<p>You can enable fullscreen feature to display map in fullscreen.</p>
				</div>
			</div>
			<hr/>

		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary leafletmap-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	return $return;
}
function xr_make_leafletmap_modal_ajax(){
	echo xr_make_leafletmap_modal();
	exit;
}
add_action('wp_ajax_xr_make_leafletmap_modal','xr_make_leafletmap_modal_ajax');









/*
**	Rock Form Builder Modal
*/
function xr_make_rockformbuilder_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$selected = isset($modal['modal']['data']['data']['shortcode']) ? $modal['modal']['data']['data']['shortcode'] : '';
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Rock Form Builder" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Rock Form Builder</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					'.rockthemes_fb_get_references_list($selected, $id, false).'
				</div>
				<div class="span6">
					<strong>Choose a Rock Form Builder</strong><br/>
					<p>You can choose any of your saved Rock Form Builder.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary rockformbuilder-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	return $return;
}
function xr_make_rockformbuilder_modal_ajax(){
	echo xr_make_rockformbuilder_modal();
	exit;
}
add_action('wp_ajax_xr_make_rockformbuilder_modal','xr_make_rockformbuilder_modal_ajax');







/*
**	Revolution Slider Modal
**
**	TO DO : This function has not finished.
*/
function xr_make_revolutionslider_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$selected = isset($modal['modal']['data']['data']['shortcode']) ? $modal['modal']['data']['data']['shortcode'] : '';
	
	
	$rs_slider = new RevSlider();
	$sliders = $rs_slider->getArrSliders();
	
	//Make a list element
	$slider_list = '<select class="revolution_slider_list" autocomplete="off">';
	
	foreach($sliders as $slider){
		$this_selected = '';
		if($selected === $slider->getShortcode()){
			$this_selected = ' selected="selected" ';	
		}
		$slider_list .= '<option value="'.esc_attr($slider->getShortcode()).'"'.$this_selected.'>'.$slider->getTitle().'</option>';
	}
		
	$slider_list .= '</select>';
	
			
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Revolution Slider" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Revolution Slider</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					'.$slider_list.'
				</div>
				<div class="span6">
					<strong>Choose a Revolution Slider</strong><br/>
					<p>You can choose any of your saved Revolution Slider.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary revolutionslider-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	return $return;
}
function xr_make_revolutionslider_modal_ajax(){
	echo xr_make_revolutionslider_modal();
	exit;
}
add_action('wp_ajax_xr_make_revolutionslider_modal','xr_make_revolutionslider_modal_ajax');









/*
**	Portfolio Modal
*/

function xr_make_portfolio_modal($modal=null,$id=null){
	global $rock_page_builder_config;
	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	$image_sizes = isset($modal['modal']['data']['data']['imageSize']) ? $modal['modal']['data']['data']['imageSize'] : '';
	
	$totalProducts = isset($modal['modal']['data']['data']['total']) ? $modal['modal']['data']['data']['total'] : 18;
	
	$chosenCategory = isset($modal['modal']['data']['data']['category']) ? $modal['modal']['data']['data']['category'] : '';
	$chosenPostType = isset($modal['modal']['data']['data']['postType']) ? $modal['modal']['data']['data']['postType'] : '';
	
	//$header_title = isset($modal['modal']['data']['data']['header_title']) ? $modal['modal']['data']['data']['header_title'] : "";
	
	$activate_hover_box = checked("true", (isset($modal['modal']['data']['data']['activate_hover_box']) ? $modal['modal']['data']['data']['activate_hover_box'] : false ), false);
	$activate_hover = checked("true", (isset($modal['modal']['data']['data']['activate_hover']) ? $modal['modal']['data']['data']['activate_hover'] : false ), false);
	$hover_bg_change_elem = checked("true", (isset($modal['modal']['data']['data']['hover_bg_change_elem']) ? $modal['modal']['data']['data']['activate_hover'] : false ), false);
	
	//$disable_hover_link = checked("true", (isset($modal['modal']['data']['data']['disable_hover_link']) ? $modal['modal']['data']['data']['disable_hover_link'] : false ), false);
			
	$boxed_layout = checked("true", (isset($modal['modal']['data']['data']['boxed_layout']) ? $modal['modal']['data']['data']['boxed_layout'] : false ), false);

	$excerpt_title_option = isset($modal['modal']['data']['data']['excerpt_title_option']) ? $modal['modal']['data']['data']['excerpt_title_option'] : '';
	$excerpt_length = isset($modal['modal']['data']['data']['excerpt_length']) ? $modal['modal']['data']['data']['excerpt_length'] : 18;
	
	//$pagination = checked("true", (isset($modal['modal']['data']['data']['pagination']) ? $modal['modal']['data']['data']['pagination'] : false ), false);
	
	$portfolio_model = isset($modal['modal']['data']['data']['portfolio_model']) ? $modal['modal']['data']['data']['portfolio_model'] : "";
	
	
	/*
	**	Switch Between Grid and List Models. This can be activated in RPB config file
	**
	**	@since 	:	1.3
	*/
	$portfolio_model_switch_select = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['switch_models']) && $rock_page_builder_config['elements']['portfolio_settings']['switch_models'] === 'yes'){	
		$portfolio_model_switch = isset($modal['modal']['data']['data']['portfolio_model_switch']) ? $modal['modal']['data']['data']['portfolio_model_switch'] : "";

		$portfolio_model_switch_select = '
				<div class="row-fluid">
				<div class="span6">
					<select class="portfolio_model_switch" autocomplete="off">
						<option value="true" '.($portfolio_model_switch == 'true' ? 'selected="selected"' : '').' >Switch Portfolio Models</option>
						<option value="false" '.($portfolio_model_switch == 'false' ? 'selected="selected"' : '').' >Do not Switch Portfolio Models</option>
					</select>
				</div>
				<div class="span6">
					<strong>Switch Between Portfolio Models</strong>
					<p>If you choose "Switch Portfolio Models" there will be buttons at the top of the portfoliio to switch between list and grid model.</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	
	$activate_category_link = isset($modal['modal']['data']['data']['activate_category_link']) ? $modal['modal']['data']['data']['activate_category_link'] : "";
	$activate_header_link = isset($modal['modal']['data']['data']['activate_header_link']) ? $modal['modal']['data']['data']['activate_header_link'] : "";
	
	$use_shadow = checked("true", (isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : false ), false);
	
	
	/*
	**	New Features
	**
	**	@since	:	1.3
	*/
	$details_in_hover_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['details_in_hover']) && $rock_page_builder_config['elements']['portfolio_settings']['details_in_hover'] === 'yes'){	
		$details_in_hover = isset($modal['modal']['data']['data']['details_in_hover']) ? $modal['modal']['data']['data']['details_in_hover'] : "";

		$details_in_hover_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="details_in_hover" autocomplete="off">
						<option value="din_hover" '.($details_in_hover == 'din_hover' ? 'selected="selected"' : '').' >Display Details On Hover</option>
						<option value="dunder_image" '.($details_in_hover == 'dunder_image' ? 'selected="selected"' : '').' >Display Details Under Image</option>
					</select>
				</div>
				<div class="span6">
					<strong>Where to Display Details?</strong>
					<p>You can choose to display details (title, excerpt, categories) on image when hovered or under the image. If you choose to display details on hover, you must activate hover effect too. If you choose to display details under image, you will need to choose grid mode.</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	//WooCommerce Price Field
	$display_price_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['display_price']) && $rock_page_builder_config['elements']['portfolio_settings']['display_price'] === 'yes'){	
		$display_price = isset($modal['modal']['data']['data']['display_price']) ? $modal['modal']['data']['data']['display_price'] : "";

		$display_price_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="display_price" autocomplete="off">
						<option value="false" '.($display_price == 'false' ? 'selected="selected"' : '').' >Do Not Display Price</option>
						<option value="true" '.($display_price == 'true' ? 'selected="selected"' : '').' >Display Price</option>
					</select>
				</div>
				<div class="span6">
					<strong>Display Price?</strong>
					<p>WooCommerce Only. If you want to display WooCommerce Price, choose "Display Price"</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	//Date Field
	$display_date_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['display_date']) && $rock_page_builder_config['elements']['portfolio_settings']['display_date'] === 'yes'){	
		$display_date = isset($modal['modal']['data']['data']['display_date']) ? $modal['modal']['data']['data']['display_date'] : "";

		$display_date_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="display_date" autocomplete="off">
						<option value="false" '.($display_date == 'false' ? 'selected="selected"' : '').' >Do Not Display Date</option>
						<option value="true" '.($display_date == 'true' ? 'selected="selected"' : '').' >Display Date</option>
					</select>
				</div>
				<div class="span6">
					<strong>Display Date?</strong>
					<p>You can choose to display date of each item. If the item is a post it will also display post type</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	
	//Hover Icons
	$hover_icons_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['hover_icons']) && $rock_page_builder_config['elements']['portfolio_settings']['hover_icons'] === 'yes'){	
		$use_back_icon = checked("true", (isset($modal['modal']['data']['data']['use_back_icon']) ? $modal['modal']['data']['data']['use_back_icon'] : false ), false);
		$use_link_icon = checked("true", (isset($modal['modal']['data']['data']['use_link_icon']) ? $modal['modal']['data']['data']['use_link_icon'] : false ), false);
		$use_lightbox_image = checked("true", (isset($modal['modal']['data']['data']['use_lightbox_image']) ? $modal['modal']['data']['data']['use_lightbox_image'] : false ), false);
		$use_lightbox_video = checked("true", (isset($modal['modal']['data']['data']['use_lightbox_video']) ? $modal['modal']['data']['data']['use_lightbox_video'] : false ), false);
		$use_lightbox_gallery = checked("true", (isset($modal['modal']['data']['data']['use_lightbox_gallery']) ? $modal['modal']['data']['data']['use_lightbox_gallery'] : false ), false);
		$use_like = checked("true", (isset($modal['modal']['data']['data']['use_like']) ? $modal['modal']['data']['data']['use_like'] : false ), false);
		
		$hover_icons_elem = '
			<div class="row-fluid">
				<div class="span6">
					<div class="use_back_icon_holder">
						<input autocomplete="off" class="use_back_icon" type="checkbox" value="true" name="use_back_icon" '.$use_back_icon.' /><label for="use_back_icon"> Add Responsive Back Icon (Required For Responsivity)</label>
					</div><br/>
					<div class="use_link_icon_holder">
						<input autocomplete="off" class="use_link_icon" type="checkbox" value="true" name="use_link_icon" '.$use_link_icon.' /><label for="use_link_icon"> Add Link Icon</label>
					</div><br/>
					<div class="use_lightbox_image_holder">
						<input autocomplete="off" class="use_lightbox_image" type="checkbox" value="true" name="use_lightbox_image" '.$use_lightbox_image.' /><label for="use_lightbox_image"> Add Lightbox Image Icon (Links to Featured Image)</label>
					</div><br/>
					<div class="use_lightbox_gallery_holder">
						<input autocomplete="off" class="use_lightbox_gallery" type="checkbox" value="true" name="use_lightbox_gallery" '.$use_lightbox_gallery.' /><label for="use_lightbox_gallery"> Add Gallery Icon (Multiple Images)</label>
					</div><br/>
					<div class="use_lightbox_video_holder">
						<input autocomplete="off" class="use_lightbox_video" type="checkbox" value="true" name="use_lightbox_video" '.$use_lightbox_video.' /><label for="use_lightbox_video"> Add Video Icon (Multiple Images)</label>
					</div><br/>
					<div class="use_like_holder">
						<input autocomplete="off" class="use_like" type="checkbox" value="true" name="use_like" '.$use_like.' /><label for="use_like"> Add Like Icon</label>
					</div><br/>
				</div>
				<div class="span6">
					<strong>Hover Icons</strong>
					<p>Choose which icons to display when hovered. You must activate hover for this feature.</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	//Activate links to the external address chosen in advanced details External Link field
	$where_to_link_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['where_to_link']) && $rock_page_builder_config['elements']['portfolio_settings']['where_to_link'] === 'yes'){	
		$where_to_link = isset($modal['modal']['data']['data']['where_to_link']) ? $modal['modal']['data']['data']['where_to_link'] : "";

		$where_to_link_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="where_to_link" autocomplete="off">
						<option value="" '.($where_to_link == '' ? 'selected="selected"' : '').' >No Linking</option>
						<option value="items" '.($where_to_link == 'items' ? 'selected="selected"' : '').' >Link To Items</option>
						<option value="external" '.($where_to_link == 'external' ? 'selected="selected"' : '').' >Link To External Links/Items</option>
					</select>
				</div>
				<div class="span6">
					<strong>Enable Links</strong>
					<p>If you enable external links, linking will check the Advanced Details area first. If you enter a link in Advanced Details area then that item will link to that address.</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	//Wall Mode (For Fullwidth no margin, no padding)
	$wall_mode_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['wall_mode']) && $rock_page_builder_config['elements']['portfolio_settings']['wall_mode'] === 'yes'){	
		$wall_mode = isset($modal['modal']['data']['data']['wall_mode']) ? $modal['modal']['data']['data']['wall_mode'] : "";

		$wall_mode_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="wall_mode" autocomplete="off">
						<option value="" '.($wall_mode == '' ? 'selected="selected"' : '').' >Regular Mode</option>
						<option value="true" '.($wall_mode == 'true' ? 'selected="selected"' : '').' >Wall Mode</option>
					</select>
				</div>
				<div class="span6">
					<strong>Wall Mode</strong>
					<p>If you choose Wall Mode, it will remove the spaces between items. Only for grid mode</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	
	//Masonry
	$masonry_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['masonry']) && $rock_page_builder_config['elements']['portfolio_settings']['masonry'] === 'yes'){	
		$masonry = isset($modal['modal']['data']['data']['masonry']) ? $modal['modal']['data']['data']['masonry'] : "";

		$masonry_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="masonry" autocomplete="off">
						<option value="" '.($masonry == '' ? 'selected="selected"' : '').' >Regular Order</option>
						<option value="true" '.($masonry == 'true' ? 'selected="selected"' : '').' >Masonry Mode</option>
					</select>
				</div>
				<div class="span6">
					<strong>Masonry Mode</strong>
					<p>If you want to use masonry mode, choose Masonry Mode. Only for grid mode</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	
	//More Items (Load More & Pagination)
	$more_items_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['more_items']) && $rock_page_builder_config['elements']['portfolio_settings']['more_items'] === 'yes'){	
		$more_items = isset($modal['modal']['data']['data']['more_items']) ? $modal['modal']['data']['data']['more_items'] : "";

		$more_items_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="more_items" autocomplete="off">
						<option value="" '.($more_items == '' ? 'selected="selected"' : '').' >No More Items</option>
						<option value="pagination" '.($more_items == 'pagination' ? 'selected="selected"' : '').' >Activate Pagination</option>
						<option value="load_more" '.($more_items == 'load_more' ? 'selected="selected"' : '').' >Activate Load More Button</option>';
						
		if(isset($rock_page_builder_config['elements']['portfolio_settings']['ajax_cat_filter']) && $rock_page_builder_config['elements']['portfolio_settings']['ajax_cat_filter'] === 'yes'){	
			//If more items elem activated in config file, add it to more items select	
			$more_items_elem .= '			
						<option value="ajax_cats" '.($more_items == 'ajax_cats' ? 'selected="selected"' : '').' >Ajax Category Filter</option>
						<option value="load_more_ajax_cats" '.($more_items == 'load_more_ajax_cats' ? 'selected="selected"' : '').' >Ajax Category Filter & Load More</option>
						';
		}
		
		if(isset($rock_page_builder_config['elements']['portfolio_settings']['more_items_swipe']) && $rock_page_builder_config['elements']['portfolio_settings']['more_items_swipe'] === 'yes'){	
			//If more items elem activated in config file, add it to more items select	
			$more_items_elem .= '			
						<option value="more_items_swipe" '.($more_items == 'more_items_swipe' ? 'selected="selected"' : '').' >Activate Swipe Navigation</option>
						';
		}
		
		$more_items_elem .= '
					</select>
				</div>
				<div class="span6">
					<strong>More Items?</strong>
					<p>How to display more items?</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	//More items button
	$more_items_button = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['more_items_button']) && $rock_page_builder_config['elements']['portfolio_settings']['more_items_button'] === 'yes'){	
		$more_button_json_data	=	isset($modal['modal']['data']['data']['more_button_json_data']) ? $modal['modal']['data']['data']['more_button_json_data'] : '';
		$more_button_shortcode	=	isset($modal['modal']['data']['data']['more_button_shortcode']) ? $modal['modal']['data']['data']['more_button_shortcode'] : json_encode('');
		
		$more_items_button .= '
			<div class="row-fluid">
				<div class="span6 more-items-button">
					<input autocomplete="off" id="'.$id.'_more_button_data" class="more_button_json_data" type="hidden" value="'.esc_attr($more_button_json_data).'" />
					<input autocomplete="off" id="'.$id.'_more_button_shortcode" class="more_button_shortcode" type="hidden" value="'.esc_attr($more_button_shortcode).'" />
					<div class="btn advanced_details_make_button_modal" id_ref="'.$id.'_more_button_shortcode" id_data_ref="'.$id.'_more_button_data"><i class="fa fa-gear"></i> Edit Button</div>
				</div>
				<div class="span6">
					<strong>Button</strong><br/>
					<p>Edit the button settings of load more. This button will be only visible if load more feature is enabled</p>
				</div>
			</div>
			<hr/>';
	}
	
	
	//Total Number Of items for swiper
	$swiper_nav_number_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['swiper_nav_number']) && $rock_page_builder_config['elements']['portfolio_settings']['swiper_nav_number'] === 'yes'){	
		$swiper_nav_number = isset($modal['modal']['data']['data']['swiper_nav_number']) ? $modal['modal']['data']['data']['swiper_nav_number'] : "";

		
		$swiperElemsToShow = '<div class="swiper_nav_number_holder"><h4>Select Total Item To Show for Each Swipe</h4><select class="swiper_nav_number" autocomplete="off">';
		for($i = 1; $i< 100; $i++){
			if($swiper_nav_number == $i){
				$swiperElemsToShow .= '<option value="'.$i.'" selected>'.$i.'</option>';
			}else{
				$swiperElemsToShow .= '<option value="'.$i.'">'.$i.'</option>';
			}
		}
		$swiperElemsToShow .= '</select></div>';
		
		
		$swiper_nav_number_elem = '
			<div class="row-fluid">
				<div class="span6">
					'.$swiperElemsToShow.'
				</div>
				<div class="span6">
					<strong>How many items will be displayed?</strong>
					<p>Choose how many items will be displayed for each swipe.</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	
	
	//List mode image columns
	$list_image_col_large_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['list_image_col_large']) && $rock_page_builder_config['elements']['portfolio_settings']['list_image_col_large'] === 'yes'){	
		$list_image_col_large = isset($modal['modal']['data']['data']['list_image_col_large']) ? $modal['modal']['data']['data']['list_image_col_large'] : "";

		$list_image_col_large_elem = '
			<div class="row-fluid">
				<div class="span6">
					'.rock_builder_get_columns_grid_large_list($list_image_col_large).'
				</div>
				<div class="span6">
					<strong>List Mode Image Columns</strong>
					<p>Choose columns for the image area in list mode</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	
	
	$excerpt_length_html = '<select class="excerpt_length" autocomplete="off">';
	for($e = 0; $e<150; $e++){
		if($e == $excerpt_length){
			$excerpt_length_html .= '<option value="'. $e .'" selected="selected">'.$e.'</option>';
		}else{
			$excerpt_length_html .= '<option value="'. $e .'">'.$e.'</option>';
		}
	}
	$excerpt_length_html .= '</select>';
	
	
	$totalItemsToShow = '<div class="total_show_holder"><h4>Select Total Item To Show</h4><select class="total_show" autocomplete="off">';
	for($i = 1; $i< 100; $i++){
		if($totalProducts == $i){
			$totalItemsToShow .= '<option value="'.$i.'" selected>'.$i.'</option>';
		}else{
			$totalItemsToShow .= '<option value="'.$i.'">'.$i.'</option>';
		}
	}
	$totalItemsToShow .= '</select></div>';
		
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Portfolio" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Portfolio</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6 image_sizes_column"  bind="'.$id.'" calc="true">
					'.rock_builder_get_image_sizes($image_sizes, $id, '').'
				</div>
				<div class="span6">
					<strong>Choose image size</strong><br/>
					<p>You can choose any image sizes for Portfolio. But we recommend using cropped image sizes.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid post_type_tax_holder">
				<div class="span6">
					'.rock_builder_get_customposttypes($chosenPostType, $id, '').'
					'.rock_builder_get_taxonomies($chosenCategory, $chosenPostType, '').'
				</div>
				<div class="span6">
					<strong>Choose A Post Type</strong></br>
					<p>Choose the post type</p><br/>
					<strong>Choose Taxonomies/Categories to Display</strong></br>
					<p>Choose categories/taxonomies. You can choose multiple categories/taxonomies or just single taxonomy/category. You can also choose all categories/taxonomies by choosing the "All".</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="portfolio_model" autocomplete="off">
						<option value="grid" '.($portfolio_model == 'grid' ? 'selected="selected"' : '').' >Portfolio Grid</option>
						<option value="list" '.($portfolio_model == 'list' ? 'selected="selected"' : '').' >Portfolio List</option>
					</select>
				</div>
				<div class="span6">
					<strong>Portfolio Model</strong>
					<p>You can choose grid or list model for the portfolio. If you are using WooCommerce List Mode will not work with WooCommerce</p>
				</div>
			</div>
			<hr/>
			'.$portfolio_model_switch_select.'
			<div class="row-fluid">
				<div class="span6">
					'.rockthemes_excerpt_title_option($excerpt_title_option).'
				</div>
				<div class="span6">
					<strong>Description</strong>
					<p>You can choose the description details. This will only effect to the grid model. List model will always display all details.</p>
				</div>
			</div>
			<hr/>
			'.$details_in_hover_elem.'
			'.$display_price_elem.'
			'.$display_date_elem.'
			<div class="row-fluid">
				<div class="span6">
					<div class="activate_hover_holder">
						<input autocomplete="off" class="activate_hover" type="checkbox" value="true" name="activate_hover" '.$activate_hover.' /><label for="activate_hover"> Activate Hover Effect</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Regular Hover Effect</strong></br>
					<p>This option will show the regular hover effect with PrettyPhoto (lightbox).</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="hover_bg_change_elem_holder">
						<input autocomplete="off" class="hover_bg_change_elem" type="checkbox" value="true" name="hover_bg_change_elem" '.$hover_bg_change_elem.' /><label for="hover_bg_change_elem"> Use Item Color for Hover</label>
					</div>
				</div>
				<div class="span6">
					<strong>Use Item Hover Color</strong></br>
					<p>In Advanced Details area you can choose a color for the hover background. If you check this option, hover will use the color for the item.</p>
				</div>
			</div>
			<hr/>
			'.$hover_icons_elem.'
			'.$where_to_link_elem.'
			'.$wall_mode_elem.'
			'.$masonry_elem.'
			<div class="row-fluid">
				<div class="span6">
					'.$excerpt_length_html.'
				</div>
				<div class="span6">
					<strong>Excerpt Length</strong>
					<p>You can adjust the excerpt length in words. Which means if you choose 10, your excerpt will show up to 10 words from your originial excerpt.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="activate_header_link" autocomplete="off">
						<option value="true" '.($activate_header_link === 'true' ? 'selected="selected"' : '').'>Activate Header Link</option>
						<option value="false" '.($activate_header_link === 'false' ? 'selected="selected"' : '').'>Deactivate Header Link</option>
					</select>
				</div>
				<div class="span6">
					<strong>Activate Header Link</strong>
					<p>If you activate header link, header title will be wrapper with link.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="activate_category_link" autocomplete="off">
						<option value="true" '.($activate_category_link === 'true' ? 'selected="selected"' : '').'>Activate Category Link</option>
						<option value="false" '.($activate_category_link === 'false' ? 'selected="selected"' : '').'>Deactivate Category Link</option>
					</select>
				</div>
				<div class="span6">
					<strong>Category Links</strong>
					<p>You can activate the category link under the title. This will show the links of the categories for the product.</p>
				</div>
			</div>
			<hr/>
			'.rock_builder_get_block_grid_list(
				(isset($modal['modal']['data']['data']['block_grid_large']) ? intval($modal['modal']['data']['data']['block_grid_large']) : ''),
				(isset($modal['modal']['data']['data']['block_grid_medium']) ? intval($modal['modal']['data']['data']['block_grid_medium']) : ''),
				(isset($modal['modal']['data']['data']['block_grid_small']) ? intval($modal['modal']['data']['data']['block_grid_small']) : '')
			).'
			<div class="row-fluid">
				<div class="span6">
					'.$totalItemsToShow.'
				</div>
				<div class="span6">
					<strong>Total Products to Show</strong></br>
					<p>This will set up the total products per page. If you choose 18, you will be showing 18 products for each page.</p>
				</div>
			</div>
			<hr/>
			'.$more_items_elem.'
			'.$more_items_button.'
			'.$swiper_nav_number_elem.'
			<div class="row-fluid">
				<div class="span6">
					<div class="boxed_layout_holder">
						<input autocomplete="off" class="boxed_layout" type="checkbox" value="true" name="boxed_layout" '.$boxed_layout.' /><label for="boxed_layout"> Use Boxed Layout</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Boxed Layout</strong></br>
					<p>You can easily activate/deactivate boxed layout. If you choose "No Description" for description boxed layout will not be active for "Grid Model"</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="use_shadow_holder">
						<input autocomplete="off" class="use_shadow" type="checkbox" value="true" name="use_shadow" '.$use_shadow.' /><label for="use_shadow"> Use Shadow</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Shadow</strong></br>
					<p>If you activate shadow, there will be a shadow under images.</p>
				</div>
			</div>
			<hr/>
			'.$list_image_col_large_elem.'
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary portfolio-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	/*
	TO DO : Hover Box effect for regular portfolio
	
			<div class="row-fluid">
				<div class="span6">
					<div class="activate_hover_box_holder">
						<input autocomplete="off" class="activate_hover_box" type="checkbox" value="true" name="activate_hover_box" '.$activate_hover_box.' /><label for="activate_hover_box"> Activate Hover Box</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Hover Box Effect</strong></br>
					<p>If you activate hover box effect, your thumbnails will show a bigger image with excerpt when hovered</p>
				</div>
			</div>
			<hr/>
	
	*/
	

	return $return;
}

function xr_make_portfolio_modal_ajax(){
	echo xr_make_portfolio_modal();
	exit;
}
add_action('wp_ajax_xr_make_portfolio_modal','xr_make_portfolio_modal_ajax');





/*
**	Horizontal Rule Modal
*/


function xr_make_hr_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$hr_is_image='use_html';
	$tile_image='no';
	$image_url = '';
	$image_id = '';
	$hr_html_model = 'solid';
	$hr_height = '15px';
	
	$return = '';	
	
	
	if(!empty($modal) && !$is_ajax){
		$hr_is_image  = isset($modal['modal']['data']['data']['hr_is_image']) ? $modal['modal']['data']['data']['hr_is_image'] : 'use_html';
		$tile_image  = isset($modal['modal']['data']['data']['tile_image']) ? $modal['modal']['data']['data']['tile_image'] : 'no';
		$image_url  = isset($modal['modal']['data']['data']['image_url']) ? $modal['modal']['data']['data']['image_url'] : '';
		$image_id  = isset($modal['modal']['data']['data']['image_id']) ? $modal['modal']['data']['data']['image_id'] : '';
		$hr_html_model  = isset($modal['modal']['data']['data']['hr_html_model']) ? $modal['modal']['data']['data']['hr_html_model'] : 'solid';
		$hr_height  = isset($modal['modal']['data']['data']['hr_height']) ? $modal['modal']['data']['data']['hr_height'] : $hr_height;
	}
	
	
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Skill" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>HR (Horizontal Rule)</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<select class="hr_is_image" autocomplete="off" ref="'.$id.'">
						<option value="use_html" '.($hr_is_image == 'use_html' ? 'selected="selected"' : '').'>Use Html Regular HR</option>
						<option value="use_image" '.($hr_is_image == 'use_image' ? 'selected="selected"' : '').'>Use Image</option>
					</select>
				</div>
				<div class="span6">
					<strong>Choose HR Model</strong><br/>
					<p>If you choose "Html Regular HR" system will render regular hr tag with the chosen style. If you choose "Use Image" system will use the image you have uploaded.</p>
				</div>
			</div>
			<hr/>
			<div class="use_image_mode row-fluid '.($hr_is_image != 'use_image' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<div class="hr-modal-image" ref="icon-image-uploader">
							<h4>Choose an Image</h4>
							<div class="hide image-data"></div>
							<label for="upload_image">
								<input autocomplete="off" id="'.$id.'-image-uploader" class="upload_image_button" size="36" name="upload_image" type="text" value="'.esc_url($image_url).'" image_id="'.esc_attr(intval($image_id)).'" />
								<input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" />
							</label>
							<br/>
						</div>
					</div>
					<div class="span6">
						<h3>HR With Image</h3>
						<p>If you don\'t want to use regular HTML HR you can use an image</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<select class="tile_image" autocomplete="off">
							<option value="yes" '.($tile_image == 'yes' ? 'selected="selected"' : '').'>Yes</option>
							<option value="no" '.($tile_image == 'no' ? 'selected="selected"' : '').'>No</option>
						</select>
					</div>
					<div class="span6">
						<h3>Tile Image</h3>
						<p>If you choose "yes" your image will repeat along the column.</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="text" class="hr_height" value="'.esc_attr($hr_height).'" />
					</div>
					<div class="span6">
						<h3>Height</h3>
						<p>Enter the height of the horizontal rule in px or em.</p>
					</div>
				</div>
				<hr/>
			</div>
			<div class="use_html_mode row-fluid '.($hr_is_image != 'use_html' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<select class="hr_html_model" autocomplete="off">
							<option value="solid" '.($hr_html_model == 'solid' ? 'selected="selected"' : '').'>Solid</option>
							<option value="dotted" '.($hr_html_model == 'dotted' ? 'selected="selected"' : '').'>Dotted</option>
							<option value="dashed" '.($hr_html_model == 'dashed' ? 'selected="selected"' : '').'>Dashed</option>
						</select>
					</div>
					<div class="span6">
						<h3>HR Model</h3>
						<p>Choose hr html tag model.</p>
					</div>
				</div>
				<hr/>
			</div>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary hr-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	

	return $return;
}

function xr_make_hr_modal_ajax(){
	echo xr_make_hr_modal();
	exit;
}
add_action('wp_ajax_xr_make_hr_modal','xr_make_hr_modal_ajax');


/*
**	End of Horizontal Rule Modal
*/




/*
**	Vertical Space Modal
*/


function xr_make_verticalspace_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$vertical_space_height='default';
	$custom_value='60px';
	
	$return = '';	
	
	
	if(!empty($modal) && !$is_ajax){
		$vertical_space_height  = isset($modal['modal']['data']['data']['vertical_space_height']) ? $modal['modal']['data']['data']['vertical_space_height'] : 'default';
		$custom_value  = isset($modal['modal']['data']['data']['custom_value']) ? $modal['modal']['data']['data']['custom_value'] : '60px';
	}
	
	
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Skill" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>HR (Horizontal Rule)</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<select class="vertical_space_height" autocomplete="off" ref="'.$id.'">
						<option value="default" '.($vertical_space_height == 'default' ? 'selected="selected"' : '').'>Default (60px)</option>
						<option value="x_grid" '.($vertical_space_height == 'x_grid' ? 'selected="selected"' : '').'>Default Grid (90px)</option>
						<option value="x_2" '.($vertical_space_height == 'x_2' ? 'selected="selected"' : '').'>Default x2 (120px)</option>
						<option value="x_3" '.($vertical_space_height == 'x_3' ? 'selected="selected"' : '').'>Default x3 (180px)</option>
						<option value="d_2" '.($vertical_space_height == 'd_2' ? 'selected="selected"' : '').'>Default /2 (30px)</option>
						<option value="custom" '.($vertical_space_height == 'custom' ? 'selected="selected"' : '').'>Custom Value</option>
					</select>
				</div>
				<div class="span6">
					<strong>Space Height</strong><br/>
					<p>Choose the vertical space</p>
				</div>
			</div>
			<hr/>

			<div class="use_custom_value row-fluid '.($vertical_space_height != 'custom' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="text" class="custom_value" value="'.$custom_value.'" />
					</div>
					<div class="span6">
						<strong>Height Custom Value</strong><br/>
						<p>Enter the height value (i.e. 60px 120px)</p>
					</div>
				</div>
				<hr/>
			</div>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary button-verticalspace-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	

	return $return;
}

function xr_make_verticalspace_modal_ajax(){
	echo xr_make_verticalspace_modal();
	exit;
}
add_action('wp_ajax_xr_make_verticalspace_modal','xr_make_verticalspace_modal_ajax');


/*
**	End of Vertical Space Modal
*/








function rockbuilder_make_colorpicker($id,$defaultColor=null){
	if(!isset($GLOBALS['xr_colorpickers'])){
		$GLOBALS['xr_colorpickers'] = array();	
	}
	
	$GLOBALS['xr_colorpickers'][] = $id;
	$colorPicker = '<input autocomplete="off" type="text" id="'.$id.'" value="'.esc_attr($defaultColor ? $defaultColor : "#FFFFFF").'" class="xr_color_field" data-default-color="'.esc_attr($defaultColor ? $defaultColor : "#FFFFFF").'" />';
	return $colorPicker;
}


/*
**	Skill Modal
*/

function xr_make_skill_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$skill_title='';
	$skill_current_value='';
	$skill_color='';
	$skill_bg_color='';
	
	$return = '';	
	
	
	if(!empty($modal) && !$is_ajax){
		$skill_title  = isset($modal['modal']['data']['data']['skill_title']) ? $modal['modal']['data']['data']['skill_title'] : '';
		$skill_current_value  = isset($modal['modal']['data']['data']['skill_current_value']) ? $modal['modal']['data']['data']['skill_current_value'] : '';
		$skill_color  = isset($modal['modal']['data']['data']['skill_color']) ? $modal['modal']['data']['data']['skill_color'] : '';
		$skill_bg_color  = isset($modal['modal']['data']['data']['skill_bg_color']) ? $modal['modal']['data']['data']['skill_bg_color'] : '';
	}
	
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Skill" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Skill</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<div class="skill_color">
						'.rockbuilder_make_colorpicker($id.'-colorpicker', $skill_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Skill Color</strong><br/>
					<p>Choose your skill color</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="skill_bg_color">
						'.rockbuilder_make_colorpicker($id.'-colorpicker-bg', $skill_bg_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Skill Background Color</strong><br/>
					<p>Choose your skill background color</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="skill_title" value="'.esc_attr($skill_title).'" />
				</div>
				<div class="span6">
					<strong>Skill Title</strong><br/>
					<p>Enter the title</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="skill_current_value" value="'.esc_attr($skill_current_value).'" />
				</div>
				<div class="span6">
					<strong>Skill Current Value</strong><br/>
					<p>Enter the current value of the skill with % symbol. (i.e. 70%)</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary skill-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	/*
	TODO : Skill sizes removed cause of IE8 issues
				<div class="row-fluid">
				<div class="span6">
					<select class="skill_size" autocomplete="off">
						<option value="" '.($skill_size == '' ? 'selected="selected"' : '').'>Default Size</option>
						<option value="small" '.($skill_size == 'small' ? 'selected="selected"' : '').'>Small</option>
						<option value="large" '.($skill_size == 'large' ? 'selected="selected"' : '').'>Large (Only for non-responsive design)</option>
					</select>
				</div>
				<div class="span6">
					<strong>Skill Size</strong><br/>
					<p>Choose your skill size</p>
				</div>
			</div>
			<hr/>
*/

	return $return;
}

function xr_make_skill_modal_ajax(){
	echo xr_make_skill_modal();
	exit;
}
add_action('wp_ajax_xr_make_skill_modal','xr_make_skill_modal_ajax');


/*
**	End of Skill Modal
*/





/*
**	Button Modal
*/

function xr_make_button_modal($modal=null,$id=null){

	$is_ajax = false;

	$remove_modal_after = false;
	$return_to = '';
	
	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
		$remove_modal_after = (isset($modal_obj['remove_modal_after']) && $modal_obj['remove_modal_after']) == 'true' ? true : false;
		$return_to = isset($modal_obj['return_to']) ? $modal_obj['return_to'] : '';
		$return_data_to = isset($modal_obj['return_data_to']) ? $modal_obj['return_data_to'] : '';
	}
	
	$button_size = '';
	$button_shadow = '';
	$button_shape = '';
	$button_wrap = '';
	$button_color = '';
	$button_link_target = '';
	$icon_class = '';
	$icon_url = '';
	$icon_used = false;
	$iconAlign = '';
	
	$bg_color_default = '';
	$bg_color_hover = '';
	$text_color_default = '';
	$text_color_hover = '';
	$border_color = '';
	$border_color_hover = '';
	$button_bg_border = '';

	$title='Awesome Button';
	$extra_class = '';
	$tax_name = '';
	$link_url = '';
	$post_id = '';
	$link_html = '';
	$is_tax = 'false';
	$is_page = 'no';
	$button_align = '';
	
	//For SEO
	$attr_title = '';
	
	$return = '';	
	
	
	//If loading from ajax with saved data. (For editing button)
	if($is_ajax){
		
		if(isset($modal_obj['saved_data']) && !empty($modal_obj['saved_data'])){
		
			$saved_data = json_decode(stripslashes($modal_obj['saved_data']), true);
			
			if(isset($saved_data) && !empty($saved_data) && isset($saved_data['data']) && !empty($saved_data['data'])){
				extract($saved_data['data']);	
				
				$icon_class = $iconClass;
				$icon_url = $iconURL;
				$iconAlign = $iconAlign;
				
				if(isset($link_details)){
					$tax_name = isset($link_details['tax_name']) ? $link_details['tax_name'] : '';
					$link_url =  isset($link_details['url']) ? $link_details['url'] : '';
					$post_id =  isset($link_details['post_id']) ? $link_details['post_id'] : '';
					$is_tax =  isset($link_details['is_tax']) ? $link_details['is_tax'] : 'false';
				}
		
				if($is_tax === 'false' || !$is_tax) $is_page = 'yes';
		
				if($link_url && $link_url !== ''){
					$link_html = '<input autocomplete="off" class="link_custom_input" type="text" value="'.esc_url($link_url).'" />';
				}elseif($post_id && $post_id !== 'false'){
					$link_html = rock_builder_get_linkposts_cats_posts(array('is_page'=> $is_page, 'category'=>$tax_name, 'selected'=>$post_id));	
				}
			}
		}
	}
	
	$avoid_sidebar = checked("true", (isset($modal['modal']['data']['data']['avoidSidebar']) ? $modal['modal']['data']['data']['avoidSidebar'] : false ), false);
	
	if(!empty($modal) && !$is_ajax){
		$icon_class = isset($modal['modal']['data']['data']['iconClass']) ? $modal['modal']['data']['data']['iconClass'] : '';
		$icon_url = isset($modal['modal']['data']['data']['iconURL']) ? $modal['modal']['data']['data']['iconURL'] : '';
		$iconAlign = isset($modal['modal']['data']['data']['iconAlign']) ? $modal['modal']['data']['data']['iconAlign'] : '';

		$title = isset($modal['modal']['data']['data']['title']) ? $modal['modal']['data']['data']['title'] : '';
		$extra_class = isset($modal['modal']['data']['data']['extra_class']) ? $modal['modal']['data']['data']['extra_class'] : '';
	
		$button_color = isset($modal['modal']['data']['data']['button_color']) ? $modal['modal']['data']['data']['button_color'] : '';
		$button_size = isset($modal['modal']['data']['data']['button_size']) ? $modal['modal']['data']['data']['button_size'] : '';
		$button_link_target = isset($modal['modal']['data']['data']['button_link_target']) ? $modal['modal']['data']['data']['button_link_target'] : '';
		$button_shadow  = isset($modal['modal']['data']['data']['button_shadow']) ? $modal['modal']['data']['data']['button_shadow'] : '';
		$button_shape  = isset($modal['modal']['data']['data']['button_shape']) ? $modal['modal']['data']['data']['button_shape'] : '';
		$button_wrap  = isset($modal['modal']['data']['data']['button_wrap']) ? $modal['modal']['data']['data']['button_wrap'] : '';
		$button_align  = isset($modal['modal']['data']['data']['button_align']) ? $modal['modal']['data']['data']['button_align'] : '';

		$bg_color_default = isset($modal['modal']['data']['data']['bg_color_default']) ? $modal['modal']['data']['data']['bg_color_default'] : $bg_color_default;
		$bg_color_hover = isset($modal['modal']['data']['data']['bg_color_hover']) ? $modal['modal']['data']['data']['bg_color_hover'] : $bg_color_hover;
		$text_color_default = isset($modal['modal']['data']['data']['text_color_default']) ? $modal['modal']['data']['data']['text_color_default'] : $text_color_default;
		$text_color_hover = isset($modal['modal']['data']['data']['text_color_hover']) ? $modal['modal']['data']['data']['text_color_hover'] : $text_color_hover;
		$border_color = isset($modal['modal']['data']['data']['border_color']) ? $modal['modal']['data']['data']['border_color'] : $border_color;
		$border_color_hover = isset($modal['modal']['data']['data']['border_color_hover']) ? $modal['modal']['data']['data']['border_color_hover'] : $border_color_hover;
		$button_bg_border = isset($modal['modal']['data']['data']['button_bg_border']) ? $modal['modal']['data']['data']['button_bg_border'] : $button_bg_border;

		$attr_title = isset($modal['modal']['data']['data']['attr_title']) ? $modal['modal']['data']['data']['attr_title'] : $attr_title;
		
		$icon_box_model = isset($modal['modal']['data']['data']['icon_box_model']) ? $modal['modal']['data']['data']['icon_box_model'] : '';
		$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;
		
					
		if(isset($modal['modal']['data']['data']['link_details'])){
			$tax_name = isset($modal['modal']['data']['data']['link_details']['tax_name']) ? $modal['modal']['data']['data']['link_details']['tax_name'] : '';
			$link_url =  isset($modal['modal']['data']['data']['link_details']['url']) ? $modal['modal']['data']['data']['link_details']['url'] : '';
			$post_id =  isset($modal['modal']['data']['data']['link_details']['post_id']) ? $modal['modal']['data']['data']['link_details']['post_id'] : '';
			$is_tax =  isset($modal['modal']['data']['data']['link_details']['is_tax']) ? $modal['modal']['data']['data']['link_details']['is_tax'] : 'false';
		}
		

		if($is_tax === 'false' || !$is_tax) $is_page = 'yes';

		if($link_url && $link_url !== ''){
			$link_html = '<input autocomplete="off" class="link_custom_input" type="text" value="'.esc_url($link_url).'" />';
		}elseif($post_id && $post_id !== 'false'){
			$link_html = rock_builder_get_linkposts_cats_posts(array('is_page'=> $is_page, 'category'=>$tax_name, 'selected'=>$post_id));	
		}
		
	}
	

	/*
	
	Button Circle removed temporarily
	<option value="button-circle" '.($button_shape == 'button-circle' ? 'selected="selected"' : '').'>Button Circle (Only works with default button size)</option>
	*/
	
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade '.(!$remove_modal_after ? '' : 'external-modal-call' ).'" tabindex="-1" role="dialog" aria-labelledby="Button" aria-hidden="true">
		<div class="modal-header">
			<div class="close '.(!$remove_modal_after ? 'builder-close' : 'close-grid-modal' ).'"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Button</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="button_title" value="'.esc_attr($title).'" />
				</div>
				<div class="span6">
					<strong>Button Text</strong><br/>
					<p>Enter the button title</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="button_color" autocomplete="off" ref="'.$id.'">
						<option value="" '.($button_color == '' ? 'selected="selected"' : '').'>Default Color</option>
						<option value="custom" '.($button_color == 'custom' ? 'selected="selected"' : '').'>Custom</option>
						<option value="primary" '.($button_color == 'primary' ? 'selected="selected"' : '').'>Blue</option>
						<option value="darkblue" '.($button_color == 'darkblue' ? 'selected="selected"' : '').'>Dark Blue</option>
						<option value="yellow" '.($button_color == 'yellow' ? 'selected="selected"' : '').'>Yellow</option>
						<option value="action" '.($button_color == 'action' ? 'selected="selected"' : '').'>Green</option>
						<option value="highlight" '.($button_color == 'highlight' ? 'selected="selected"' : '').'>Orange</option>
						<option value="caution" '.($button_color == 'caution' ? 'selected="selected"' : '').'>Red</option>
						<option value="royal" '.($button_color == 'royal' ? 'selected="selected"' : '').'>Purple</option>
						<option value="maroon" '.($button_color == 'maroon' ? 'selected="selected"' : '').'>Maroon</option>
					</select>
				</div>
				<div class="span6">
					<strong>Button Color</strong><br/>
					<p>Choose your button color</p>
				</div>
			</div>
			<hr/>
			
			
			<span class="custom_button_color_mode row-fluid '.($button_color !== 'custom' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<div class="row-fluid">
							<div class="span6">
								<strong>Background Default Color</strong>
								<div class="bg_color_default">
									'.rockbuilder_make_colorpicker($id.'-bg_color_default', $bg_color_default).'
								</div>
								<br/>
								<strong>Background Hover Color</strong>
								<div class="bg_color_hover">
									'.rockbuilder_make_colorpicker($id.'-bg_color_hover', $bg_color_hover).'
								</div>
							</div>
							<div class="span6">
								<strong>Text Default Color</strong>
								<div class="text_color_default">
									'.rockbuilder_make_colorpicker($id.'-text_color_default', $text_color_default).'
								</div>
								<br/>
								<strong>Text Hover Color</strong>
								<div class="text_color_hover">
									'.rockbuilder_make_colorpicker($id.'-text_color_hover', $text_color_hover).'
								</div>
							</div>
						</div>
						<div class="row-fluid">
							<div class="span12">
								<strong>Border / 3D Button Color</strong><br/>
								<span>(Only For Rounded Button or Transparent Background)</span><br/>
								<div class="border_color">
									'.rockbuilder_make_colorpicker($id.'-border_color', $border_color).'
								</div>
							</div>
						</div>
						<div class="row-fluid">
							<div class="span12">
								<strong>Border / 3D Button Color Hover</strong><br/>
								<span>(Only For Rounded Button or Transparent Background)</span><br/>
								<div class="border_color_hover">
									'.rockbuilder_make_colorpicker($id.'-border_color_hover', $border_color_hover).'
								</div>
							</div>
						</div>
					</div>
					<div class="span6">
						<strong>Button Custom Colors</strong><br/>
						<p>Change button colors</p>
					</div>
				</div>
				<hr/>
			</span>
			<div class="row-fluid">
				<div class="span6">
					<select class="button_bg_border" autocomplete="off">
						<option value="use_bg_color" '.($button_bg_border == 'use_bg_color' ? 'selected="selected"' : '').'>Use Background Color</option>
						<option value="use_border" '.($button_bg_border == 'use_border' ? 'selected="selected"' : '').'>Use Border</option>
						<option value="use_bg_color_use_border" '.($button_bg_border == 'use_bg_color_use_border' ? 'selected="selected"' : '').'>Use 3D Button</option>
					</select>
				</div>
				<div class="span6">
					<strong>Button Background / Border</strong><br/>
					<p>You can use background color or disable background color and use border for button. If you choose "Use Background Color with Border" you need to choose Button Rounded as well.</p>
				</div>
			</div>
			<hr/>

			
			<div class="row-fluid">
				<div class="span6">
					'.rock_builder_get_linkposts_cats($tax_name,$id).'
					'.$link_html.'
				</div>
				<div class="span6">
					<strong>Link</strong><br/>
					<p>If you want to link to a page or to a custom link address you can set up your link here.</p>
				</div>										
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="button_link_target" autocomplete="off">
						<option value="" '.($button_link_target == '' ? 'selected="selected"' : '').'>Self</option>
						<option value="_blank" '.($button_link_target == '_blank' ? 'selected="selected"' : '').'>New Window</option>
						<option value="modal" '.($button_link_target == 'modal' ? 'selected="selected"' : '').'>Iframe (Only with prettyPhoto)</option>
						<option value="inline" '.($button_link_target == 'inline' ? 'selected="selected"' : '').'>Inline (For inline hash # navigaiton)</option>
					</select>
				</div>
				<div class="span6">
					<strong>Button Link Target</strong><br/>
					<p>You can choose link to same page or a new page.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="button_align" autocomplete="off">
						<option value="center" '.($button_align == 'center' ? 'selected="selected"' : '').'>Center</option>
						<option value="left" '.($button_align == 'left' ? 'selected="selected"' : '').'>Left</option>
						<option value="right" '.($button_align == 'right' ? 'selected="selected"' : '').'>Right</option>
						<option value="block" '.($button_align == 'block' ? 'selected="selected"' : '').'>Block</option>
					</select>
				</div>
				<div class="span6">
					<strong>Button Align</strong><br/>
					<p>You can align the button to the left or right. Or if you want your button to fill the parent width choose "Block".</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="button_size" autocomplete="off">
						<option value="" '.($button_size == '' ? 'selected="selected"' : '').'>Default Size</option>
						<option value="button-big" '.($button_size == 'button-big' ? 'selected="selected"' : '').'>Big</option>
						<option value="button-large" '.($button_size == 'button-large' ? 'selected="selected"' : '').'>Large</option>
						<option value="button-small" '.($button_size == 'button-small' ? 'selected="selected"' : '').'>Small</option>
					</select>
				</div>
				<div class="span6">
					<strong>Button Size</strong><br/>
					<p>Choose a button size</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="button_shadow" autocomplete="off">
						<option value="no" '.($button_shadow == 'no' ? 'selected="selected"' : '').'>No</option>
						<option value="yes" '.($button_shadow == 'yes' ? 'selected="selected"' : '').'>Yes</option>
					</select>
				</div>
				<div class="span6">
					<strong>Button Shadow</strong><br/>
					<p>You can enable/disable button shadow.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="button_shape" autocomplete="off">
						<option value="" '.($button_shape == '' ? 'selected="selected"' : '').'>Default Shape</option>
						<option value="button-rounded" '.($button_shape == 'button-rounded' ? 'selected="selected"' : '').'>Button Rounded</option>
						<option value="button-pill" '.($button_shape == 'button-pill' ? 'selected="selected"' : '').'>Button Pill</option>
					</select>
				</div>
				<div class="span6">
					<strong>Button Shape</strong><br/>
					<p>You can easily choose the button shape</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6 elem-icon">
					<div class="icon-holder add-elem-icon-btn" icon-ref="'.esc_attr($icon_class).'">'.(($icon_class != "") ? '<i class="'.esc_attr($icon_class).' fa-4x"></i>' : '').'</div><br/>
					<input autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.($icon_url != "" ? esc_url($icon_url) : "").'"/>
					'.(!$icon_used ? '<div class="add-elem-icon-btn btn">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
					'.($icon_used ? '<div class="remove-elem-icon-btn btn">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn hide">Remove Icon</div>').'
				</div>
				<div class="span6">
					<strong>Button Icon</strong><br/>
					<p>Choose an icon (Optional)</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="icon_align" autocomplete="off">
						<option value="left" '.($iconAlign == "left" ? 'selected="selected"' : '').'>Icon Left</option>
						<option value="right" '.($iconAlign == "right" ? 'selected="selected"' : '').'>Icon Right</option>
					</select>
				</div>
				<div class="span6">
					<strong>Icon Alignment</strong><br/>
					<p>You can set up your icon position to left or to top.</p>
				</div>										
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="extra_class" value="'.esc_attr($extra_class).'" />
				</div>
				<div class="span6">
					<strong>Extra Class</strong><br/>
					<p>If you want to add an extra class you can enter it here.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="attr_title" value="'.esc_attr($attr_title).'" />
				</div>
				<div class="span6">
					<strong>Title Attribute</strong><br/>
					<p>You can add title attribute here.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn '.(!$remove_modal_after ? 'builder-close' : 'close-grid-modal' ).'">Close</div>
			<div class="btn btn-primary '.(!$remove_modal_after ? 'button-modal-save builder-close' : 'save-remove-button-modal' ).'" '.($remove_modal_after ? 'return_to="'.esc_attr($return_to).'" return_data_to="'.esc_attr($return_data_to).'"' : '').' ref="'.$id.'">Save changes</div>
		</div>
	</div>';

	return $return;
}

function xr_make_button_modal_ajax(){
	echo xr_make_button_modal();
	exit;
}
add_action('wp_ajax_xr_make_button_modal','xr_make_button_modal_ajax');


/*
**	End of Button Modal
*/











/*
**	Special Grid Block Modal
**
*/

function rockthemes_pb_make_specialgridblock_modals($arr = array()){
	if(empty($arr)) return;
	
	$return = '';
	foreach($arr as $modal){
		$return .= rockthemes_pb_make_specialgridblock_modal($modal,$modal['id']);
	}
	
	return $return;
}


function rockthemes_pb_make_specialgridblock_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = 'modal-'.$modal_obj['id'];
	}
	
	$return = '';	
	
	$avoid_sidebar = isset($modal['modal']['data']['data']['avoidSidebar']) ? $modal['modal']['data']['data']['avoidSidebar'] : 'false';
	$grid_special_width_details = isset($modal['modal']['data']['data']['grid_special_width_details']) ? $modal['modal']['data']['data']['grid_special_width_details'] : 'regular';
	$background_color = isset($modal['modal']['data']['data']['background_color']) ? $modal['modal']['data']['data']['background_color'] : '#00aae8';
	$bgcolor_fullscreen = checked("true", (isset($modal['modal']['data']['data']['bgcolor_fullscreen']) ? $modal['modal']['data']['data']['bgcolor_fullscreen'] : false ), false);
	
	$use_shadow = isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : 'false';
	$activate_padding = isset($modal['modal']['data']['data']['activate_padding']) ? $modal['modal']['data']['data']['activate_padding'] : 'true';
	$transparent_background = checked("true", (isset($modal['modal']['data']['data']['transparent_background']) ? $modal['modal']['data']['data']['transparent_background'] : false ), false);
	$add_down_arrow = checked("true", (isset($modal['modal']['data']['data']['add_down_arrow']) ? $modal['modal']['data']['data']['add_down_arrow'] : false ), false);
	$down_arrow_color = isset($modal['modal']['data']['data']['down_arrow_color']) ? $modal['modal']['data']['data']['down_arrow_color'] : '#f9f9f9';
	$special_grid_html_id = isset($modal['modal']['data']['data']['special_grid_html_id']) ? $modal['modal']['data']['data']['special_grid_html_id'] : '';
	$special_grid_html_title = isset($modal['modal']['data']['data']['special_grid_html_title']) ? $modal['modal']['data']['data']['special_grid_html_title'] : '';
	
	/*
	$animation_type = isset($modal['modal']['data']['data']['animation_type']) ? $modal['modal']['data']['data']['animation_type'] : 'true';
	$animation_delay_time = isset($modal['modal']['data']['data']['animation_delay_time']) ? $modal['modal']['data']['data']['animation_delay_time'] : 0;
	*/
	//var_dump($grid_special_width_details);
	
	//Video Background
	$video_bg_url = isset($modal['modal']['data']['data']['video_bg_url']) ? $modal['modal']['data']['data']['video_bg_url'] : '';
	$video_bg_color_opacity = isset($modal['modal']['data']['data']['video_bg_color_opacity']) ? $modal['modal']['data']['data']['video_bg_color_opacity'] : 0;
	$video_bg_color = isset($modal['modal']['data']['data']['video_bg_color']) ? $modal['modal']['data']['data']['video_bg_color'] : '#00aae8';
	$video_bg_fullscreen = checked("true", (isset($modal['modal']['data']['data']['video_bg_fullscreen']) ? $modal['modal']['data']['data']['video_bg_fullscreen'] : false ), false);
	$video_bg_youtube_url = isset($modal['modal']['data']['data']['video_bg_youtube_url']) ? $modal['modal']['data']['data']['video_bg_youtube_url'] : '';
	$video_bg_vimeo_url = isset($modal['modal']['data']['data']['video_bg_vimeo_url']) ? $modal['modal']['data']['data']['video_bg_vimeo_url'] : '';
	$video_bg_ratio = isset($modal['modal']['data']['data']['video_bg_ratio']) ? $modal['modal']['data']['data']['video_bg_ratio'] : '';
	$video_bg_mute = checked("true", (isset($modal['modal']['data']['data']['video_bg_mute']) ? $modal['modal']['data']['data']['video_bg_mute'] : false ), false);
	$video_bg_fallback_url = isset($modal['modal']['data']['data']['video_bg_fallback_url']) ? $modal['modal']['data']['data']['video_bg_fallback_url'] : '';
	
	//Parallax Details
	$parallax_model = isset($modal['modal']['data']['data']['parallax_model']) ? $modal['modal']['data']['data']['parallax_model'] : '';
	$parallax_mask_height = isset($modal['modal']['data']['data']['parallax_mask_height']) ? $modal['modal']['data']['data']['parallax_mask_height'] : 0;
	$parallax_size = isset($modal['modal']['data']['data']['parallax_size']) ? $modal['modal']['data']['data']['parallax_size'] : '';
	$parallax_bg_image = isset($modal['modal']['data']['data']['parallax_bg_image']) ? $modal['modal']['data']['data']['parallax_bg_image'] : '';
	$parallax_bg_image_id = isset($modal['modal']['data']['data']['parallax_bg_image_id']) ? $modal['modal']['data']['data']['parallax_bg_image_id'] : '';
	$image_full_screen = checked("true", (isset($modal['modal']['data']['data']['image_full_screen']) ? $modal['modal']['data']['data']['image_full_screen'] : false ), false);
	$image_full_screen_ratio = isset($modal['modal']['data']['data']['image_full_screen_ratio']) ? $modal['modal']['data']['data']['image_full_screen_ratio'] : '';
	$image_bg_color_opacity = isset($modal['modal']['data']['data']['image_bg_color_opacity']) ? $modal['modal']['data']['data']['image_bg_color_opacity'] : 0;
	$image_bg_color = isset($modal['modal']['data']['data']['image_bg_color']) ? $modal['modal']['data']['data']['image_bg_color'] : '#f9f9f9';
	$image_tile = isset($modal['modal']['data']['data']['image_tile']) ? $modal['modal']['data']['data']['image_tile'] : 'full';
	$image_sizes = isset($modal['modal']['data']['data']['image_sizes']) ? $modal['modal']['data']['data']['image_sizes'] : '';

	//Full Width Slider - Full Screen Slider Mode Background Details
	$full_bg_color = isset($modal['modal']['data']['data']['full_bg_color']) ? $modal['modal']['data']['data']['full_bg_color'] : '';
	$fullbg_enable_color = checked("true", (isset($modal['modal']['data']['data']['fullbg_enable_color']) ? $modal['modal']['data']['data']['fullbg_enable_color'] : false ), false);
	$enable_double_bg_colors = checked("true", (isset($modal['modal']['data']['data']['enable_double_bg_colors']) ? $modal['modal']['data']['data']['enable_double_bg_colors'] : false ), false);
	$double_bg_color = isset($modal['modal']['data']['data']['double_bg_color']) ? $modal['modal']['data']['data']['double_bg_color'] : '';

	//Light Font Colors (For dark background
	$use_light_font_colors = checked("true", (isset($modal['modal']['data']['data']['use_light_font_colors']) ? $modal['modal']['data']['data']['use_light_font_colors'] : false ), false);
	$use_border_bottom = checked("true", (isset($modal['modal']['data']['data']['use_border_bottom']) ? $modal['modal']['data']['data']['use_border_bottom'] : false ), false);

	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade grid-modal" tabindex="-1" role="dialog" aria-labelledby="Grid" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			<h3>Special Grid Settings</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="avoid_sidebar_not_false row-fluid '.($avoid_sidebar === 'false' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<select class="grid_special_width_details" autocomplete="off" ref="'.$id.'">
							<option value="regular" '.($grid_special_width_details === "regular" ? 'selected="selected"' : '').'>No Details (Regular Grid)</option>
							<option value="use_parallax" '.($grid_special_width_details == "use_parallax" ? 'selected="selected"' : '').'>Use Parallax</option>
							<option value="use_background_img" '.($grid_special_width_details == "use_background_img" ? 'selected="selected"' : '').'>Use Background Image</option>
							<option value="use_background_video" '.($grid_special_width_details == "use_background_video" ? 'selected="selected"' : '').'>Use Background Video</option>
							<option value="full_width_slider" '.($grid_special_width_details == "full_width_slider" ? 'selected="selected"' : '').'>Full Width Grid (Mostly For Sliders)</option>
							<option value="full_width_screen_slider" '.($grid_special_width_details == "full_width_screen_slider" ? 'selected="selected"' : '').'>Full Screen Grid (Mostly For Sliders)</option>
							<option value="full_width_colored" '.($grid_special_width_details == "full_width_colored" ? 'selected="selected"' : '').'>Full Colored Background (Content in row, background is full)</option>
						</select>				
					</div>
					<div class="span6">
						<strong>Special Width Details</strong><br/>
						<p>You can use some special grid types. If you choose Full Width For Sliders it will display a fullwidth slider (works best with Curvy Slider). If you choose Full Colored Background, your background will be full sized but your content will be inside the regular grid.</p>
					</div>
				</div>		
			</div>
			<hr />		
			
			<span class="full_width_slider_mode row-fluid '.(($grid_special_width_details !== 'full_width_slider' && $grid_special_width_details !== 'full_width_screen_slider') ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="checkbox" value="1" class="fullbg_enable_color" name="fullbg_enable_color" '.$fullbg_enable_color.' /><label for="fullbg_enable_color"> Enable Background Color</label>
						<br/><br/>
						<div class="full_bg_color">
							'.rockbuilder_make_colorpicker($id.'-fullbg-colorpicker', $full_bg_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Background Color</strong><br/>
						<p>Choose a background color</p>
					</div>
				</div>
				<hr/>
			</span>
			
			
			
			
			<span class="use_parallax_mode row-fluid '.(($grid_special_width_details !== 'use_parallax' && $grid_special_width_details !== 'use_background_img') ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<div class="parallax-bg-image-holder" ref="parallax-bg-image-holder">
							<div class="hide image-data"></div>
							<label for="upload_image"> <input autocomplete="off" id="parallax-bg-image-'.$id.'" class="upload_image_button parallax-bg-image-'.$id.'" size="36" name="upload_image" type="text" value="'.$parallax_bg_image.'" image_id="'.$parallax_bg_image_id.'" /> <input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" /> </label><br/>
						</div>
					</div>
					<div class="span6">
						<strong>Parallax / Background Image</strong><br/>
						<p>Upload your background image for parallax effect</p>
					</div>
				</div>
				<hr/>
				
				<div class="row-fluid">
					<div class="span6 image_sizes"  bind="'.$id.'" calc="true">
						'.rock_builder_get_image_sizes($image_sizes, $id, '').'
					</div>
					<div class="span6">
						<strong>Choose image size</strong><br/>
						<p>You can choose any image sizes. If you leave it as default, it will display the image without resizing.</p>
					</div>
				</div>
				<hr/>
				
				<div class="row-fluid">
					<div class="span6">
						'.rock_builder_get_parallax_models($parallax_model).'
					</div>
					<div class="span6">
						<strong>Parallax model</strong><br/>
						<p>You can easily choose a parallax model for this block. Only for parallax background.</p>
					</div>
				</div>		
				
				<div class="row-fluid">
					<div class="span6">
						<select class="parallax_size " autocomplete="off" ref="'.$id.'">
							<option value="cover" '.($parallax_size === "cover" ? 'selected="selected"' : '').'>Fit (Default)</option>
							<option value="scroll" '.($parallax_size  == "scroll" ? 'selected="selected"' : '').'>Use Full Size</option>
						</select>				
					</div>
					<div class="span6">
						<strong>Parallax Attachment Mode</strong><br/>
						<p>By default, background image will fit on grid width. You can also choose to display entire image by choosing full size. If you choose full size, make sure your image height is bigger than your image width.</p>
					</div>
				</div>		


				<hr class="hide"/>	
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="text" name="parallax_mask_height" class="parallax_mask_height" value="'.$parallax_mask_height.'" />
					</div>
					<div class="span6">
						<strong>Parallax / Background Height</strong><br/>
						<p>Enter a height height value without "px". (i.e. 480). This feature will be disabled if the image is tiled.</p>
					</div>
				</div>		
				<hr/>	
				<div class="row-fluid">
					<div class="span6">
						<select class="image_tile " autocomplete="off" ref="'.$id.'">
							<option value="full" '.($image_tile === "full" ? 'selected="selected"' : '').'>Full Image</option>
							<option value="tile" '.($image_tile  == "tile" ? 'selected="selected"' : '').'>Tile Image</option>
						</select>				
					</div>
					<div class="span6">
						<strong>Image Repeat</strong><br/>
						<p>You can choose to tile your image. This feature will be disabled for parallax</p>
					</div>
				</div>		
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="checkbox" value="1" class="image_full_screen" name="image_full_screen" '.$image_full_screen.' /><label for="image_full_screen"> Fullscreen</label>
						<br/><br/>
						<strong>Image Ratio (Only For Fullscreen)</strong><br/><br/>
						'.rockthemes_pb_ratio_list($image_full_screen_ratio, 'image_full_screen_ratio').'
					</div>
					<div class="span6">
						<strong>Size Details</strong><br/>
						<p>You can set up size details.</p>
					</div>
				</div>		
				<hr/>	
				
				
				
				<div class="row-fluid">
					<div class="span6">
						<div class="image_bg_color">
							'.rockbuilder_make_colorpicker($id.'-imagebg-colorpicker', $image_bg_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Image Background Overlay Color</strong><br/>
						<p>Choose your image background overlay color</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="text" name="image_bg_color_opacity" class="image_bg_color_opacity" value="'.$image_bg_color_opacity.'" />
					</div>
					<div class="span6">
						<strong>Image Overlay Color Opacity</strong><br/>
						<p>Enter a value between 0 to 100.</p>
					</div>
				</div>		
				<hr/>	
				
			</span>			
			
			
			
			
			<span class="use_video_mode row-fluid '.($grid_special_width_details !== 'use_background_video' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<div class="video-bg-holder" ref="video-bg-holder">
							<div class="hide media-data"></div>
							<label for="upload_image"> <input autocomplete="off" id="video_bg_url-'.$id.'" class="upload_image_button video_bg_url video_bg_url-'.$id.'" size="36" name="upload_image" type="text" value="'.$video_bg_url.'" /> <input autocomplete="off" class="image_uploader_class btn" value="Upload Video" type="button" /> </label><br/>
						</div>
					</div>
					<div class="span6">
						<strong>Background Video</strong><br/>
						<p>Upload your video for background</p>
					</div>
				</div>		
				<hr/>	
				
				<div class="row-fluid">
					<div class="span6">
						<div class="video_bg_fallback_url-holder" ref="video_bg_fallback_url-holder">
							<div class="hide media-data"></div>
							<label for="upload_image"> <input autocomplete="off" id="video_bg_fallback_url-'.$id.'" class="upload_image_button video_bg_fallback_url video_bg_fallback_url-'.$id.'" size="36" name="upload_image" type="text" value="'.$video_bg_fallback_url.'" /> <input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" /> </label><br/>
						</div>
					</div>
					<div class="span6">
						<strong>Background Video Fallback Image</strong><br/>
						<p>This fallback image will be displayed for touch devices.</p>
					</div>
				</div>		
				<hr/>	
				
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="text" name="video_bg_youtube_url" class="video_bg_youtube_url" value="'.$video_bg_youtube_url.'" />
					</div>
					<div class="span6">
						<strong>Use Youtube Video</strong><br/>
						<p>If you want to use a Youtube video, enter your video URL here. If you enter a Youtube video URL, it will your Youtube video.</p>
					</div>
				</div>		
				<hr/>	
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="text" name="video_bg_vimeo_url" class="video_bg_vimeo_url" value="'.$video_bg_vimeo_url.'" />
					</div>
					<div class="span6">
						<strong>Use Vimeo Video</strong><br/>
						<p>If you want to use a Vimeo video, enter your video URL here. If you enter a Vimeo video URL, it will your Vimeo video.</p>
					</div>
				</div>		
				<hr/>	
				
				<div class="row-fluid">
					<div class="span6">
						<select class="video_bg_ratio " autocomplete="off" ref="'.$id.'">
							<option value="16_9" '.($video_bg_ratio === "16_9" ? 'selected="selected"' : '').'>16 / 9</option>
							<option value="4_3" '.($video_bg_ratio  == "4_3" ? 'selected="selected"' : '').'>4 / 3</option>
						</select>				
					</div>
					<div class="span6">
						<strong>Video Ratio</strong><br/>
						<p>Choose your video ratio.</p>
					</div>
				</div>		
				<div class="row-fluid">
					<div class="span6">
						<div class="video_bg_color">
							'.rockbuilder_make_colorpicker($id.'-videobg-colorpicker', $video_bg_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Video Background Overlay Color</strong><br/>
						<p>Choose your video background overlay color</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<input autocomplete="off" type="text" name="video_bg_color_opacity" class="video_bg_color_opacity" value="'.$video_bg_color_opacity.'" />
					</div>
					<div class="span6">
						<strong>Video Overlay Color Opacity</strong><br/>
						<p>Enter a value between 0 to 100.</p>
					</div>
				</div>		
				<hr/>					
				<div class="row-fluid">
					<div class="span6">
						<div class="video_bg_fullscreen_holder">
							<input autocomplete="off" type="checkbox" value="1" class="video_bg_fullscreen" name="video_bg_fullscreen" '.$video_bg_fullscreen.' /><label for="video_bg_fullscreen"> Fullscreen Video</label>
						</div>
					</div>
					<div class="span6">
						<strong>Make It Fullscreen</strong><br/>
						<p>If you check this, video will be displayed as fullscreen</p>
					</div>										
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<div class="video_bg_mute_holder">
							<input autocomplete="off" type="checkbox" value="1" class="video_bg_mute" name="video_bg_mute" '.$video_bg_mute.' /><label for="video_bg_mute"> Mute Video</label>
						</div>
					</div>
					<div class="span6">
						<strong>Mute Video</strong><br/>
						<p>This will mute the video</p>
					</div>										
				</div>
				<hr/>
			</span>			






			<span class="full_width_colored_mode row-fluid '.($grid_special_width_details !== 'full_width_colored' ? 'hide' : '').'">
				<div class="row-fluid">
					<div class="span6">
						<div class="background_color">
							'.rockbuilder_make_colorpicker($id.'-colorpicker', $background_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Background Color</strong><br/>
						<p>Choose your color</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<div class="enable_double_bg_colors_holder">
							<input autocomplete="off" type="checkbox" value="1" class="enable_double_bg_colors" name="enable_double_bg_colors" '.$enable_double_bg_colors.' /><label for="enable_double_bg_colors"> Enable Right Side Background Color</label>
						</div><br/>
						<div class="double_bg_color">
							'.rockbuilder_make_colorpicker($id.'-colorpicker', $double_bg_color).'
						</div>
					</div>
					<div class="span6">
						<strong>Split Screen Colors</strong><br/>
						<p>You can split background colors. You can enable this feature and set a different color here for split screens.</p>
					</div>
				</div>
				<hr/>
				<div class="row-fluid">
					<div class="span6">
						<div class="transparent_background_holder">
							<input autocomplete="off" type="checkbox" value="1" class="transparent_background" name="transparent_background" '.$transparent_background.' /><label for="transparent_background"> Transparent Background</label>
						</div>
					</div>
					<div class="span6">
						<strong>Transparent Background</strong><br/>
						<p>If you check transparent background, the background will be transparent.</p>
					</div>										
				</div>
				<hr/>
				
				<div class="row-fluid">
					<div class="span6">
						<div class="bgcolor_fullscreen_holder">
							<input autocomplete="off" type="checkbox" value="1" class="bgcolor_fullscreen" name="bgcolor_fullscreen" '.$bgcolor_fullscreen.' /><label for="bgcolor_fullscreen"> Fullscreen</label>
						</div>
					</div>
					<div class="span6">
						<strong>Make It Fullscreen</strong><br/>
						<p>If you check this, it will be displayed as fullscreen</p>
					</div>										
				</div>
				<hr/>
				
			</span>
			<div class="row-fluid">
				<div class="span6">
					<select class="avoid_sidebar" autocomplete="off" ref="'.$id.'">
						<option value="false" '.($avoid_sidebar == "false" ? 'selected="selected"' : '').'>Do not Avoid Sidebars</option>
						<option value="header" '.($avoid_sidebar == "header" ? 'selected="selected"' : '').'>Insert Content Before Header</option>
						<option value="before" '.($avoid_sidebar == "before" ? 'selected="selected"' : '').'>Insert Content Before Sidebars</option>
						<option value="after" '.($avoid_sidebar == "after" ? 'selected="selected"' : '').'>Insert Content After Sidebars</option>
					</select>				
				</div>
				<div class="span6">
					<strong>Avoid Sidebar</strong><br/>
					<p>You can add this element before the sidebars. If you want to add this element before the sidebar, check this option.</p>
				</div>
			</div>		
			<hr/>	
			<div class="row-fluid">
				<div class="span6">
					<select class="use_shadow" autocomplete="off" ref="'.$id.'">
						<option value="false" '.($use_shadow == "false" ? 'selected="selected"' : '').'>Do Not Use Shadow</option>
						<option value="true" '.($use_shadow == "true" ? 'selected="selected"' : '').'>Use Shadow</option>
					</select>				
				</div>
				<div class="span6">
					<strong>Use Shadow</strong><br/>
					<p>If you want to display shadow under content, choose "Use Shadow" option.</p>
				</div>
			</div>		
			<hr/>	
			
			<div class="row-fluid">
				<div class="span6">
					<div class="use_border_bottom_holder">
						<input autocomplete="off" type="checkbox" value="1" class="use_border_bottom" name="use_border_bottom" '.$use_border_bottom.' /><label for="use_border_bottom"> Use Border Bottom</label>
					</div>
				</div>
				<div class="span6">
					<strong>Use Border Bottom</strong><br/>
					<p>You can easily add a border bottom to this grid.</p>
				</div>										
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6">
					<select class="activate_padding" autocomplete="off" ref="'.$id.'">
						<option value="true" '.($activate_padding == "true" ? 'selected="selected"' : '').'>Activate Padding</option>
						<option value="false" '.($activate_padding == "false" ? 'selected="selected"' : '').'>Do Not Activate Padding</option>
					</select>				
				</div>
				<div class="span6">
					<strong>Activate Vertical Padding</strong><br/>
					<p>If you want to activate vertical padding choose "Activate Padding" option. This option only applies if you choose "Full Colored Background"</p>
				</div>
			</div>		
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="add_down_arrow_holder">
						<input autocomplete="off" type="checkbox" value="1" class="add_down_arrow" name="add_down_arrow" '.$add_down_arrow.' /><label for="add_down_arrow"> Add Down Arrow (For Navigation)</label>
					</div>
				</div>
				<div class="span6">
					<strong>Add Down Arrow</strong><br/>
					<p>If you choose to add a "Down Arrow" it will add a down arrow icon at the bottom of this special grid block. When clicked on this arrow, it will scroll to the next element under this.</p>
				</div>										
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6">
					<div class="down_arrow_color">
						'.rockbuilder_make_colorpicker($id.'-down_arrow-colorpicker', $down_arrow_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Down Arrow Color</strong><br/>
					<p>Choose the color of down arrow</p>
				</div>
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6">
					<div class="use_light_font_colors_holder">
						<input autocomplete="off" type="checkbox" value="1" class="use_light_font_colors" name="use_light_font_colors" '.$use_light_font_colors.' /><label for="use_light_font_colors"> Use Light Font Colors</label>
					</div>
				</div>
				<div class="span6">
					<strong>Light Font Colors</strong><br/>
					<p>If you are using dark background color enable this feature. This will set light font colors to most elements in this grid</p>
				</div>										
			</div>
			<hr/>
		
			
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" name="special_grid_html_id" class="special_grid_html_id" value="'.$special_grid_html_id.'" />
				</div>
				<div class="span6">
					<strong>Special Grid ID</strong><br/>
					<p>Enter a unique id for this special grid. Do not use uppercase and special characters. You can use alphanumeric characters and - symbol. This field is optional, you can leave this empty.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" name="special_grid_html_title" class="special_grid_html_title" value="'.$special_grid_html_title.'" />
				</div>
				<div class="span6">
					<strong>Special Grid Title</strong><br/>
					<p>Name your special grid field. This name will be used at the side navigation as a link to this grid.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary grid-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';

	return $return;
}

function rockthemes_pb_make_specialgridblock_modal_ajax(){
	echo rockthemes_pb_make_specialgridblock_modal();
	exit;
}
add_action('wp_ajax_rockthemes_pb_make_specialgridblock_modal','rockthemes_pb_make_specialgridblock_modal_ajax');
/*
*/







/*
**	GRID MODAL (MAIN MODAL FOR ALL OF THE GRID DETAILS)
*/

function rockthemes_pb_make_grid_modals($arr){
	$return = '';
	foreach($arr as $modal){
		$return .= xr_make_grid_modal($modal,$modal['id']);
	}
	
	return $return;
}


function xr_make_grid_modal($modal=null,$id=null){

	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = 'modal-'.$modal_obj['id'];
	}
	
	$return = '';	
	
	/*
	$avoid_sidebar = isset($modal['modal']['data']['data']['avoidSidebar']) ? $modal['modal']['data']['data']['avoidSidebar'] : 'false';
	$grid_special_width_details = isset($modal['modal']['data']['data']['grid_special_width_details']) ? $modal['modal']['data']['data']['grid_special_width_details'] : 'regular';
	$background_color = isset($modal['modal']['data']['data']['background_color']) ? $modal['modal']['data']['data']['background_color'] : '#00aae8';
	$use_shadow = isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : 'false';
	$activate_padding = isset($modal['modal']['data']['data']['activate_padding']) ? $modal['modal']['data']['data']['activate_padding'] : 'true';
	$transparent_background = checked("true", (isset($modal['modal']['data']['data']['transparent_background']) ? $modal['modal']['data']['data']['transparent_background'] : false ), false);
	*/
	$animation_type = isset($modal['modal']['data']['data']['animation_type']) ? $modal['modal']['data']['data']['animation_type'] : 'true';
	$animation_delay_time = isset($modal['modal']['data']['data']['animation_delay_time']) ? $modal['modal']['data']['data']['animation_delay_time'] : 0;

	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade grid-modal" tabindex="-1" role="dialog" aria-labelledby="Grid" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			<h3>Grid Settings</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					'.rock_builder_get_animation_classes($animation_type).'
				</div>
				<div class="span6">
					<strong>Grid Animation Type</strong><br/>
					<p>You can easily choose an animation type for this grid. If you choose "None" no animation will be attend to this grid. Any chosen animation will be activated when the grid is in the viewport.</p>
				</div>
			</div>		
			<hr/>	
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" name="animation_delay_time" class="animation_delay_time" value="'.$animation_delay_time.'" />
				</div>
				<div class="span6">
					<strong>Grid Animation Delay Time</strong><br/>
					<p>Enter a number in milliseconds to delay the grid animation.</p>
				</div>
			</div>		
			<hr/>	
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary grid-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';

	return $return;
}

function xr_make_grid_modal_ajax(){
	echo xr_make_grid_modal();
	exit;
}
add_action('wp_ajax_xr_make_grid_modal','xr_make_grid_modal_ajax');






/*
**	ICONIC TEXT MODAL
*/

function xr_make_iconictext_modal($modal=null,$id=null){
	$is_ajax = false;
	
	$icon_class = '';
	$icon_url = '';
	$icon_used = false;
	$title = '';
	$content = '';
	$use_shadow = 'false';
	$iconAlign = '';
	$boxed_layout = 'false';
	$iconSize = '';
	$icon_box_model = '';
	$tax_name = '';
	$link_url = '';
	$post_id = '';
	$link_html = '';
	$is_tax = 'false';
	$is_page = 'no';
	$icon_box_ratio = '16_5';
	$icon_box_fill = '';
	
	$icon_box_color_default = function_exists('xr_get_option') ? xr_get_option('iconic_text_icon_box_default_color', '') : '';
	$icon_box_color_hover = function_exists('xr_get_option') ? xr_get_option('iconic_text_icon_box_hover_color', '') : '';
	$icon_color_default = function_exists('xr_get_option') ? xr_get_option('iconic_text_icon_default_color', '') : '';
	$icon_color_hover = function_exists('xr_get_option') ? xr_get_option('iconic_text_icon_hover_color', '') : '';
	
	
	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	
	if(!empty($modal) && !$is_ajax){
		$icon_class = $modal['modal']['data']['data']['iconClass'];
		$icon_url = $modal['modal']['data']['data']['iconURL'];
		$content = $modal['modal']['data']['data']['content'];
		$title = $modal['modal']['data']['data']['title'];
		$iconSize = $modal['modal']['data']['data']['iconSize'];
		$icon_box_model = isset($modal['modal']['data']['data']['icon_box_model']) ? $modal['modal']['data']['data']['icon_box_model'] : '';
		$icon_box_fill = isset($modal['modal']['data']['data']['icon_box_fill']) ? $modal['modal']['data']['data']['icon_box_fill'] : '';
		$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;
		
		if(isset($modal['modal']['data']['data']['link_details'])){
			$tax_name = isset($modal['modal']['data']['data']['link_details']['tax_name']) ? $modal['modal']['data']['data']['link_details']['tax_name'] : '';
			$link_url =  isset($modal['modal']['data']['data']['link_details']['url']) ? $modal['modal']['data']['data']['link_details']['url'] : '';
			$post_id =  isset($modal['modal']['data']['data']['link_details']['post_id']) ? $modal['modal']['data']['data']['link_details']['post_id'] : '';
			$is_tax =  isset($modal['modal']['data']['data']['link_details']['is_tax']) ? $modal['modal']['data']['data']['link_details']['is_tax'] : 'false';
		}
		
		$icon_box_ratio = isset($modal['modal']['data']['data']['icon_box_ratio']) ? $modal['modal']['data']['data']['icon_box_ratio'] : '16_5';
		
		$icon_box_color_default = isset($modal['modal']['data']['data']['icon_box_color_default']) ? $modal['modal']['data']['data']['icon_box_color_default'] : $icon_box_color_default;
		$icon_box_color_hover = isset($modal['modal']['data']['data']['icon_box_color_hover']) ? $modal['modal']['data']['data']['icon_box_color_hover'] : $icon_box_color_hover;
		$icon_color_default = isset($modal['modal']['data']['data']['icon_color_default']) ? $modal['modal']['data']['data']['icon_color_default'] : $icon_color_default;
		$icon_color_hover = isset($modal['modal']['data']['data']['icon_color_hover']) ? $modal['modal']['data']['data']['icon_color_hover'] : $icon_color_hover;
		
		
		if($is_tax === 'false' || !$is_tax) $is_page = 'yes';
		
		if($link_url && $link_url !== ''){
			$link_html = '<input autocomplete="off" class="link_custom_input" type="text" value="'.esc_url($link_url).'" />';
		}elseif($post_id && $post_id !== 'false'){
			$link_html = rock_builder_get_linkposts_cats_posts(array('is_page'=> $is_page, 'category'=>$tax_name, 'selected'=>$post_id));	
		}
		
	
		$iconAlign = $modal['modal']['data']['data']['iconAlign'];
		$boxed_layout = checked("true", (isset($modal['modal']['data']['data']['boxed_layout']) ? $modal['modal']['data']['data']['boxed_layout'] : false ), false);		
		$use_shadow = checked("true", (isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : false ), false);
	}
	
	
	$return = '';	
							
			$return .= 
			'<div id="'.$id.'" modalType="iconictext" class="rpb_modal container hide fade" tabindex="-1">
								<div class="modal-header">
									<div class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></div>
									'.rock_builder_item_trans_btn(array(
										'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
									)).'
									<h3>Add Iconic Text</h3>
								</div>
								<div class="modal-body" data-saved="false">
									<div class="row-fluid">
										<div class="span6">
											<div class="row-fluid">
												<div class="span6">
													<strong>Icon Box Default Color</strong>
													<div class="icon_box_color_default">
														'.rockbuilder_make_colorpicker($id.'-icon_box_color_default', $icon_box_color_default).'
													</div>
													<br/>
													<strong>Icon Box Hover Color</strong>
													<div class="icon_box_color_hover">
														'.rockbuilder_make_colorpicker($id.'-icon_box_color_hover', $icon_box_color_hover).'
													</div>
												</div>
												<div class="span6">
													<strong>Icon Defult Color</strong>
													<div class="icon_color_default">
														'.rockbuilder_make_colorpicker($id.'-icon_color_default', $icon_color_default).'
													</div>
													<br/>
													<strong>Icon Hover Color</strong>
													<div class="icon_color_hover">
														'.rockbuilder_make_colorpicker($id.'-icon_color_hover', $icon_color_hover).'
													</div>
												</div>
											</div>
										</div>
										<div class="span6">
											<strong>Color Settings</strong><br/>
											<p>Change Colors</p>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<input autocomplete="off" type="text" class="iconic-title" value="'.esc_attr($title).'" />
										</div>
										<div class="span6">
											<strong>Icon Title</strong><br/>
											<p>You can enter a title for your header text.</p>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span12 textarea-holder">
											<strong>Content</strong><br/>
											<p>Enter your content here. You can use the Rich Text Editor for your content.</p>
											<br/>
											<div class="rock-tinymce-container wp-core-ui wp-editor-wrap html-active">
												<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
													<div class="wp-editor-tabs">
														<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
														<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
													</div>
													<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="'.$id.'-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
												</div>
												<div class="wp-content-editor-container wp-editor-container">
													<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" name="'.$id.'-editor" id="'.$id.'-editor">'.stripslashes($content).'</textarea>
												</div>
												<div class="tinymce-hidden-data hide" data-text="'.esc_attr($content).'"></div>
											</div>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6 elem-icon">
											<div class="icon-holder add-elem-icon-btn" icon-ref="'.esc_attr($icon_class).'">'.(($icon_class != "") ? '<i class="'.esc_attr($icon_class).' fa-4x"></i>' : '').'</div><br/>
											<input autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.($icon_url != "" ? esc_url($icon_url) : "").'"/>
											'.(!$icon_used ? '<div class="add-elem-icon-btn btn">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
											'.($icon_used ? '<div class="remove-elem-icon-btn btn">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn hide">Remove Icon</div>').'
										</div>
										<div class="span6">
											<strong>Icon</strong><br/>
											<p>Choose an icon</p>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<select class="icon_align" autocomplete="off">
												<option value="top" '.($iconAlign == "top" ? 'selected="selected"' : '').'>Icon Top</option>
												<option value="left" '.($iconAlign == "left" ? 'selected="selected"' : '').'>Icon Left</option>
												<option value="right" '.($iconAlign == "right" ? 'selected="selected"' : '').'>Icon Right</option>
											</select>
										</div>
										<div class="span6">
											<strong>Icon Alignment</strong><br/>
											<p>You can set up your icon position to left or to top.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<select class="icon_size" autocomplete="off">
												<option value="" '.($iconSize === "" ? 'selected="selected"' : '').'>Default</option>
												<option value="icon-2" '.($iconSize === "icon-2" ? 'selected="selected"' : '').'>Icon 2</option>
												<option value="icon-3" '.($iconSize === "icon-3" ? 'selected="selected"' : '').'>Icon 3 (Best for boxed icons)</option>
												<option value="icon-4" '.($iconSize === "icon-4" ? 'selected="selected"' : '').'>Icon 4</option>
											</select>
										</div>
										<div class="span6">
											<strong>Choose an icon size</strong><br/>
											<p>There are 4 different icon size. You can choose any icon size you want. Ensure your icon size is not larger than your content area</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											'.rock_builder_get_linkposts_cats($tax_name,$id).'
											'.$link_html.'
										</div>
										<div class="span6">
											<strong>Link</strong><br/>
											<p>If you want to link to a page or to a custom link address you can set up your link here.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<select class="icon_box_model" autocomplete="off">
												<option value="no-box" '.($icon_box_model === '' ? 'selected="selected"' : '').'>No Icon Box</option>
												<option value="full-width-box" '.($icon_box_model === 'full-width-box' ? 'selected="selected"' : '').'>Full Width Box (Only for Icon Top)</option>
												<option value="circle-box" '.($icon_box_model === 'circle-box' ? 'selected="selected"' : '').'>Circle Box</option>
												<option value="rounded-box" '.($icon_box_model === 'rounded-box' ? 'selected="selected"' : '').'>Rounded Box</option>
												<option value="cornered-box" '.($icon_box_model === 'cornered-box' ? 'selected="selected"' : '').'>Cornered Box</option>
												<option value="raindrop-box" '.($icon_box_model === 'raindrop-box' ? 'selected="selected"' : '').'>Raindrop Box</option>
											</select>
										</div>
										<div class="span6">
											<strong>Use Box for Icons</strong><br/>
											<p>You can choose a box model for your icons. If you specify a box model, your icons will be inside the box. Any uploaded icon via uploader will fit in the icon box. If you are using our font icons, set icon size to "Icon 3" for box layouts.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<select class="icon_box_fill" autocomplete="off">
												<option value="background_only" '.($icon_box_fill == "background_only" ? 'selected="selected"' : '').'>Background</option>
												<option value="border_only" '.($icon_box_fill == "border_only" ? 'selected="selected"' : '').'>Border</option>
											</select>
										</div>
										<div class="span6">
											<strong>Icon Box Fill</strong><br/>
											<p>You can use background or border mode for the icon box.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											'.rockthemes_pb_ratio_list($icon_box_ratio, 'icon_box_ratio').'
										</div>
										<div class="span6">
											<strong>Full Width Box Ratio (Only for Icon Top)</strong><br/>
											<p>Full width box will resize itself according to the ratio.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<div class="boxed_layout_holder">
												<input autocomplete="off" class="boxed_layout" type="checkbox" value="true" name="boxed_layout" '.$boxed_layout.' /><label for="activate_hover"> Use Boxed Layout</label>
											</div>
										</div>
										<div class="span6">
											<strong>Boxed Layout</strong><br/>
											<p>If you want to wrap a boxed layout around this element, check this option.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<div class="use_shadow_holder">
												<input autocomplete="off" class="use_shadow" type="checkbox" value="true" name="use_shadow" '.$use_shadow.' /><label for="activate_hover"> Use Shadow</label>
											</div>
										</div>
										<div class="span6">
											<strong>Use Header Shadow</strong><br/>
											<p>This option will activate/deactivate the shadows under the header text.</p>
										</div>										
									</div>
								</div>
								<div class="modal-footer">
									<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
									<div class="btn btn-primary iconictext-save">Save changes</div>
								</div>
							</div>';
					
		return $return;
}

function xr_make_iconictext_modal_ajax(){
	echo xr_make_iconictext_modal();
	exit;
}
add_action('wp_ajax_xr_make_iconictext_modal', 'xr_make_iconictext_modal_ajax');

/*
**	END OF ICONIC TEXT MODAL
*/




/*
**	TOGGLE SINGLE NOW USES AJAX
*/
function rock_make_single_toggle_modal($tabObj=null, $id=null){
	
	$icon_class = '';
	$icon_url = '';
	$icon_used = false;
	
	if(isset($_REQUEST['toggle_obj'])){
		$toggleObj = $_REQUEST['toggle_obj'];	
		$id = $toggleObj['id'];
		$icon_class = isset($toggleObj['icon_class']) ? $toggleObj['icon_class'] : '';
		$icon_url = isset($toggleObj['icon_url']) ? $toggleObj['icon_url'] : '';
		$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;
	}
	
		
	$return = '<div id="toggles-single-modal" modalType="toggles" class="rpb_modal container hide fade" tabindex="-1" role="dialog" style="width:1024px; margin-left:-512px;" aria-labelledby="Toggles" aria-hidden="true" data-focus-on="input:first">
								<div class="modal-header">
									<div class="close close-toggle-single"><i class="fa fa-times"></i></div>
					  				<h3>Add Toggle</h3>
								</div>
								<div class="modal-body" data-saved="false">
									<div class="row-fluid">
										<div class="span6">
											<input autocomplete="off" name="toggle_header" class="toggle_header" type="text" value="'.esc_attr(stripslashes($toggleObj['title'])).'" />
										</div>
										<div class="span6">
											<strong>Toggle Header</strong><br/>
											<p>Enter the header text of your tab</p>
										</div>
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span6">
											<input autocomplete="off" name="toggle_hash" class="toggle_hash" type="text" value="'.esc_attr(isset($toggleObj['toggle_hash']) ? (stripslashes($toggleObj['toggle_hash'])) : '').'" />
										</div>
										<div class="span6">
											<strong>Toggle ID</strong><br/>
											<p>Enter a unique id for this toggle. Do not use uppercase and special characters. You can use alphanumeric characters and - symbol. This field is optional, you can leave this empty.</p>
										</div>
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span12 toggles-list">
											<strong>Toggle Content</strong><br/>
											<p>Enter your toggle content here. You can use the Rich Text Editor for your toggle content.</p>
											<br/>
											<div class="rock-tinymce-container wp-core-ui wp-editor-wrap tmce-active">
												<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
													<div class="wp-editor-tabs">
														<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
														<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
													</div>
													<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="toggles-single-modal-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
												</div>
												<div class="wp-content-editor-container wp-editor-container">
													<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" initialized="true" name="toggles-single-modal-editor" id="toggles-single-modal-editor"></textarea>
												</div>
											</div>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6 elem-icon">
											<div class="icon-holder add-elem-icon-btn" icon-ref="'.$icon_class.'">'.(($icon_class != "") ? '<i class="'.$icon_class.' fa-4x"></i>' : '').'</div><br/>
											<input autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.($icon_url != "" ? $icon_url : "").'"/>
											'.(!$icon_used ? '<div class="add-elem-icon-btn btn">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
											'.($icon_used ? '<div class="remove-elem-icon-btn btn">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn hide">Remove Icon</div>').'
										</div>
										<div class="span6">
											<strong>Toggle Icon</strong><br/>
											<p>Choose an icon for your toggle header</p>
										</div>
									</div>
									<hr/>
								</div>
								<div class="modal-footer"><div class="btn close-toggle-single">Close</div><div class="btn btn-primary toggles-single-save" ref="'.$toggleObj['index'].'" modal-ref="'.$id.'">Save changes</div></div></div>';


	return $return;
}

function rock_make_single_toggle_modal_ajax(){
	echo rock_make_single_toggle_modal();	
	exit;
}

add_action('wp_ajax_rock_make_single_toggle_modal', 'rock_make_single_toggle_modal_ajax');











function xr_make_tabs_modal($modal=null,$id=null){
	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];

		$id = $modal_obj['id'];
	}
	
	$return = '';
	
	$tabType = '';
	$tab_use_hash = 'no';
	$boxed_layout = 'false';
	$open_tab_index = 0;
	$use_shadow = 'false';
	$script = '';
	
	$tabsString = '												
		<li class="tabs-block active">
			<div class="hide secret-desc" tab-title="Tabs Awesome" icon_class="" icon_url="" data-text=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="tab-name" ref="'.$id.'" tab-index="0">Tabs Awesome</span>
			<i class="close fa fa-times"></i>
		</li>
		<li class="tabs-block">
			<div class="hide secret-desc" tab-title="Tabs Awesome" icon_class="" icon_url="" data-text=""></div>
			<i class="drag fa fa-arrows"></i>
			<span class="tab-name" ref="'.$id.'" tab-index="1">Tabs Awesome</span>
			<i class="close fa fa-times"></i>
		</li>';
	
		if(!$is_ajax){
			$tabType = $modal['modal']['data']['data']['tabType'];
			$tab_use_hash = isset($modal['modal']['data']['data']['tab_use_hash']) ? $modal['modal']['data']['data']['tab_use_hash'] : 'no';
			$boxed_layout = checked("true", (isset($modal['modal']['data']['data']['boxed_layout']) ? $modal['modal']['data']['data']['boxed_layout'] : false ), false);
			$use_shadow = checked("true", (isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : false ), false);
			$open_tab_index = intval(isset($modal['modal']['data']['data']['opentabIndex']) ? $modal['modal']['data']['data']['opentabIndex'] : 0);
		
			$tabsString = '';

			if(isset($modal['modal']['data']['data']['tabs']) && is_array($modal['modal']['data']['data']['tabs'])){
				$tab_index = 0;
				foreach($modal['modal']['data']['data']['tabs'] as $tab){
					$tabsString .= '
						<li class="tabs-block">
							<div class="hide secret-desc" tab_hash="'.esc_attr(isset($tab['tab_hash']) ? $tab['tab_hash'] : '').'" tab-title="'.esc_attr($tab['title']).'" icon_class="'.esc_attr($tab['icon_class']).'" icon_url="'.esc_attr($tab['icon_url']).'" data-text="'.esc_attr(isset($tab['text']) ? $tab['text'] : '').'"></div>
							<i class="drag fa fa-arrows"></i>
							<span class="tab-name" ref="'.$id.'" tab-index="'.esc_attr($tab_index).'">'.esc_html($tab['title']).'</span>
							<i class="close fa fa-times"></i>
						</li>';
						
					$tab_index++;
				}
			}
			
			$script = '
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery("#'.$id.' .tabs-list" ).sortable({
						handle : "i.drag",
					});
				});
			</script>';
		}
						
			$return .= 
			'<div id="'.$id.'" modalType="tabs" class="rpb_modal container hide fade" >
								<div class="modal-header">
									<div class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></div>
									'.rock_builder_item_trans_btn(array(
										'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
									)).'
									<h3>Add tab</h3>
								</div>
								<div class="modal-body" data-saved="false">
									<div class="row-fluid">
										<div class="tabs-elements-holder span12">
											<ul class="tabs-list">
												'.$tabsString.'
											</ul>
											<div class="tabs-block add-new-tab-btn" ref="'.$id.'">
												<i class="drag fa fa-plus"></i>
											</div>
											<div class="clear"></div>
											<div class="tab-textarea-holder" tab-index="0" ref="'.$id.'">
												<div rows="10" cols="50" class="alignleft" contenteditable="true" disabled="disabled"></div>
											</div>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<select class="tab-type" autocomplete="off">
												<option value="tab-top" '.($tabType == "tab-top" ? 'selected="selected"' : '').'>Tab Top</option>
												<option value="tab-left" '.($tabType == "tab-left" ? 'selected="selected"' : '').'>Tab Left</option>
												<option value="tab-right" '.($tabType == "tab-right" ? 'selected="selected"' : '').'>Tab Right </option>
											</select>
										</div>
										<div class="span6">
											<strong>Choose Tab Type</strong><br/>
											<p>You can set up your tabs with 3 different mode. Tab Top will display the tab headers at the top, tab left will display at the left and tab right will be display at the right.</p>
										</div>										
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span6">
											<select class="tab_use_hash" autocomplete="off">
												<option value="no" '.($tab_use_hash == "no" ? 'selected="selected"' : '').'>Do not use deeplinking</option>
												<option value="yes" '.($tab_use_hash == "yes" ? 'selected="selected"' : '').'>Use ID for deeplinking</option>
											</select>
										</div>
										<div class="span6">
											<strong>Tabs Deeplinking (Mostly for FAQ)</strong><br/>
											<p>You can choose to activate deeplinking for Tabs. If you activate this option you will need to enter ID for your tab items.</p>
										</div>										
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span6">
											<div class="open_tab_index_holder">
												<input autocomplete="off" type="text" value="'.esc_attr($open_tab_index).'" class="open_tab_index" name="open_tab_index" />
											</div>
										</div>
										<div class="span6">
											<strong>Open Tab Index</strong><br/>
											<p>Index of the tab will be open. If you want your first tab to be open enter 0. If you want all tabs to be closed enter -1</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<div class="boxed_layout_holder">
												<input autocomplete="off" class="boxed_layout" type="checkbox" value="true" name="boxed_layout" '.$boxed_layout.' /><label for="activate_hover"> Use Boxed Layout</label>
											</div>
										</div>
										<div class="span6">
											<strong>Boxed Layout</strong><br/>
											<p>If you want to wrap a boxed layout around this element, check this option.</p>
										</div>										
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<div class="use_shadow_holder">
												<input autocomplete="off" class="use_shadow" type="checkbox" value="true" name="use_shadow" '.$use_shadow.' /><label for="activate_hover"> Use Shadow</label>
											</div>
										</div>
										<div class="span6">
											<strong>Use Header Shadow</strong><br/>
											<p>This option will activate/deactivate the shadows under the header text.</p>
										</div>										
									</div>
								</div>
								<div class="modal-footer">
									<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
									<div class="btn btn-primary tabs-save">Save changes</div>
								</div>
							</div>';
					
		return $return.$script;
	
	exit;
}

function xr_make_tabs_modal_ajax(){
	echo xr_make_tabs_modal();
	exit;
}
add_action('wp_ajax_xr_make_tabs_modal', 'xr_make_tabs_modal_ajax');





function rock_make_single_tab_modal($tabObj=null, $id=null){
	
	$icon_class = '';
	$icon_url = '';
	$icon_used = false;
	
	if(isset($_REQUEST['tab_obj'])){
		$tabObj = $_REQUEST['tab_obj'];	
		$id = $tabObj['id'];
		$icon_class = isset($tabObj['icon_class']) ? $tabObj['icon_class'] : '';
		$icon_url = isset($tabObj['icon_url']) ? $tabObj['icon_url'] : '';
		$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;
	}
	
		
	$return = '<div id="tabs-single-modal" modalType="tabs" class="rpb_modal container hide fade" tabindex="-1" role="dialog" style="width:1024px; margin-left:-512px;" aria-labelledby="Tabs" aria-hidden="true" data-focus-on="input:first">
								<div class="modal-header">
									<div class="close close-tab-single"><i class="fa fa-times"></i></div>
					  				<h3>Add Tab</h3>
								</div>
								<div class="modal-body" data-saved="false">
									<div class="row-fluid">
										<div class="span6">
											<input autocomplete="off" name="tab_header" class="tab_header" type="text" value="'.esc_attr(stripslashes($tabObj['title'])).'" />
										</div>
										<div class="span6">
											<strong>Tab Header</strong><br/>
											<p>Enter the header text of your tab</p>
										</div>
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span6">
											<input autocomplete="off" name="tab_hash" class="tab_hash" type="text" value="'.esc_attr(isset($tabObj['tab_hash']) ? stripslashes($tabObj['tab_hash']) : '').'" />
										</div>
										<div class="span6">
											<strong>Tab ID</strong><br/>
											<p>Enter a unique id for this tab. Do not use uppercase and special characters. You can use alphanumeric characters and - symbol. This field is optional, you can leave this empty.</p>
										</div>
									</div>
									<hr/>
									
									<div class="row-fluid">
										<div class="span12 tabs-list">
											<strong>Tab Content</strong><br/>
											<p>Enter your tab content here. You can use the Rich Text Editor for your tab content.</p>
											<br/>
											<div class="rock-tinymce-container wp-core-ui wp-editor-wrap tmce-active">
												<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
													<div class="wp-editor-tabs">
														<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
														<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
													</div>
													<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="tabs-single-modal-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
												</div>
												<div class="wp-content-editor-container wp-editor-container">
													<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" initialized="true" name="tabs-single-modal-editor" id="tabs-single-modal-editor"></textarea>
												</div>
											</div>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6 elem-icon">
											<div class="icon-holder add-elem-icon-btn" icon-ref="'.esc_attr($icon_class).'">'.(($icon_class != "") ? '<i class="'.esc_attr($icon_class).' fa-4x"></i>' : '').'</div><br/>
											<input autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.($icon_url != "" ? esc_url($icon_url) : "").'"/>
											'.(!$icon_used ? '<div class="add-elem-icon-btn btn">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
											'.($icon_used ? '<div class="remove-elem-icon-btn btn">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn hide">Remove Icon</div>').'
										</div>
										<div class="span6">
											<strong>Tab Icon</strong><br/>
											<p>Choose an icon for your tab header</p>
										</div>
									</div>
									<hr/>
								</div>
								<div class="modal-footer"><div class="btn close-tab-single">Close</div><div class="btn btn-primary tabs-single-save" ref="'.esc_attr($tabObj['index']).'" modal-ref="'.$id.'">Save changes</div></div></div>';


	return $return;
}

function rock_make_single_tab_modal_ajax(){
	echo rock_make_single_tab_modal();	
	exit;
}

add_action('wp_ajax_rock_make_single_tab_modal', 'rock_make_single_tab_modal_ajax');








/*
**	Hover Element Modal
*/

function xr_make_hoverelement_modal($modal=null,$id=null){
	global $rock_page_builder_config;
	$is_ajax = false;

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
	}
	
	$image_url  = isset($modal['modal']['data']['data']['image_url']) ? $modal['modal']['data']['data']['image_url'] : '';
	$image_id  = isset($modal['modal']['data']['data']['image_id']) ? $modal['modal']['data']['data']['image_id'] : '';
	$image_sizes = isset($modal['modal']['data']['data']['imageSize']) ? $modal['modal']['data']['data']['imageSize'] : '';
	$box_ratio = isset($modal['modal']['data']['data']['box_ratio']) ? $modal['modal']['data']['data']['box_ratio'] : '';

	$background_color = isset($modal['modal']['data']['data']['background_color']) ? $modal['modal']['data']['data']['background_color'] : '';
	$hover_color = isset($modal['modal']['data']['data']['hover_color']) ? $modal['modal']['data']['data']['hover_color'] : '';
	$hover_color_opacity = isset($modal['modal']['data']['data']['hover_color_opacity']) ? $modal['modal']['data']['data']['hover_color_opacity'] : '';
	
	$activate_hover = checked("true", (isset($modal['modal']['data']['data']['activate_hover']) ? $modal['modal']['data']['data']['activate_hover'] : false ), false);
	$use_shadow = checked("true", (isset($modal['modal']['data']['data']['use_shadow']) ? $modal['modal']['data']['data']['use_shadow'] : false ), false);
	$activate_bg_color = checked("true", (isset($modal['modal']['data']['data']['activate_bg_color']) ? $modal['modal']['data']['data']['activate_bg_color'] : false ), false);
	$change_hover_color = checked("true", (isset($modal['modal']['data']['data']['change_hover_color']) ? $modal['modal']['data']['data']['change_hover_color'] : false ), false);
	
	
	$content = isset($modal['modal']['data']['data']['content']) ? $modal['modal']['data']['data']['content'] : '';
	
	$link_url = isset($modal['modal']['data']['data']['link_url']) ? $modal['modal']['data']['data']['link_url'] : '';
	
	
	/*
	**	New Features
	**
	**	@since	:	1.3
	*/
	
	//WooCommerce Price Field
	$display_price_elem = '';
	if(isset($rock_page_builder_config['elements']['portfolio_settings']['display_price']) && $rock_page_builder_config['elements']['portfolio_settings']['display_price'] === 'yes'){	
		$display_price = isset($modal['modal']['data']['data']['display_price']) ? $modal['modal']['data']['data']['display_price'] : "";

		$display_price_elem = '
			<div class="row-fluid">
				<div class="span6">
					<select class="display_price" autocomplete="off">
						<option value="false" '.($display_price == 'false' ? 'selected="selected"' : '').' >Do Not Display Price</option>
						<option value="true" '.($display_price == 'true' ? 'selected="selected"' : '').' >Display Price</option>
					</select>
				</div>
				<div class="span6">
					<strong>Display Price?</strong>
					<p>WooCommerce Only. If you want to display WooCommerce Price, choose "Display Price"</p>
				</div>
			</div>
			<hr/>
		';
	}
	
	
	
	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Hover Element" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Hover Element</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<div class="hr-modal-image" ref="icon-image-uploader">
						<h4>Choose an Image</h4>
						<div class="hide image-data"></div>
						<label for="upload_image">
							<input autocomplete="off" id="'.$id.'-image-uploader" class="upload_image_button" size="36" name="upload_image" type="text" value="'.$image_url.'" image_id="'.$image_id.'" />
							<input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" />
						</label>
						<br/>
					</div>
				</div>
				<div class="span6">
					<strong>Background Image</strong><br/>
					<p>If you don\'t want to use background image, leave this area empty</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6 image_sizes_column"  bind="'.$id.'" calc="true">
					'.rock_builder_get_image_sizes($image_sizes, $id, '').'
				</div>
				<div class="span6">
					<strong>Choose image size</strong><br/>
					<p>You can choose any image sizes for Portfolio. But we recommend using cropped image sizes.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					'.rockthemes_pb_ratio_list($box_ratio, 'box_ratio').'
				</div>
				<div class="span6">
					<strong>Box Ratio</strong><br/>
					<p>Box will resize itself according to the ratio.</p>
				</div>										
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6">
					<div class="activate_bg_color_holder">
						<input autocomplete="off" class="activate_bg_color" type="checkbox" value="true" name="activate_bg_color" '.$activate_bg_color.' />
						<label for="activate_bg_color"> Activate Background Color</label>
					</div>
					<br/>
					<div class="background_color">
						'.rockbuilder_make_colorpicker($id.'-bg-colorpicker', $background_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Background Color</strong><br/>
					<p>Choose background color</p>
				</div>
			</div>
			<hr/>

			<div class="row-fluid">
				<div class="span6">
					<div class="change_hover_color_holder">
						<input autocomplete="off" class="change_hover_color" type="checkbox" value="true" name="change_hover_color" '.$change_hover_color.' />
						<label for="activate_bg_color"> Change Hover Background Color</label>
					</div>
					<br/>
					<div>
						<input autocomplete="off" type="text" placeholder="Hover Color Opacity (0 - 100)" class="hover_color_opacity" value="'.$hover_color_opacity.'" />
					</div>
					<br/>
					<div class="hover_color">
						'.rockbuilder_make_colorpicker($id.'-bg-hover-colorpicker', $hover_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Hover Background Color</strong><br/>
					<p>Choose hover background color</p>
				</div>
			</div>
			<hr/>

			
			
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="link_url" value="'.$link_url.'" />
				</div>
				<div class="span6">
					<strong>Link URL</strong>
					<p>Enter link URL</p>
				</div>
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span12 textarea-holder">
					<strong>Hover Element Text</strong><br/>
					<p>Enter your text.</p>
					<br/>
					<div class="rock-tinymce-container wp-core-ui wp-editor-wrap html-active">
						<div id="wp-content-editor-tools" class="wp-editor-tools hide-if-no-js">
							<div class="wp-editor-tabs">
								<a class="rock-tinymce-switch-text wp-switch-editor switch-tmce" >Visual</a>
								<a class="rock-tinymce-switch-html wp-switch-editor switch-html" >Text</a>
							</div>
							<div id="wp-content-media-buttons" class="wp-media-buttons"><a href="#" id="insert-media-button" class="button insert-media add_media" data-editor="'.$id.'-editor" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a></div>
						</div>
						<div class="wp-content-editor-container wp-editor-container">
							<textarea rows="8" cols="40" class="rock-tinymce-textarea description wp-editor-area" name="'.$id.'-editor" id="'.$id.'-editor">'.($content).'</textarea>
						</div>
						<div class="tinymce-hidden-data hide">'.$content.'</div>
					</div>
				</div>
			</div>
			<hr/>			
			
			<div class="row-fluid">
				<div class="span6">
					<div class="use_shadow_holder">
						<input autocomplete="off" class="use_shadow" type="checkbox" value="true" name="use_shadow" '.$use_shadow.' /><label for="use_shadow"> Use Shadow</label>
					</div>
				</div>
				<div class="span6">
					<strong>Activate Shadow</strong></br>
					<p>If you activate shadow, there will be a shadow under images.</p>
				</div>
			</div>
			<hr/>
		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary hoverelement-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	

	return $return;
}

function xr_make_hoverelement_modal_ajax(){
	echo xr_make_hoverelement_modal();
	exit;
}
add_action('wp_ajax_xr_make_hoverelement_modal','xr_make_hoverelement_modal_ajax');

//End of Hover Element Modal






/*
**	Achievement Element Modal
*/

function xr_make_achievement_modal($modal=null,$id=null){
	global $rock_page_builder_config;
	$is_ajax = false;
	
	$icon_class = '';
	$icon_url = '';
	$icon_bg_color = '#56CCC8';
	$icon_color = '#ffffff';
	
	if(isset($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
	
	$number_color = isset($modal['modal']['data']['data']['number_color']) ? $modal['modal']['data']['data']['number_color'] : '#56CCC8';
	$text_color = isset($modal['modal']['data']['data']['text_color']) ? $modal['modal']['data']['data']['text_color'] : '#787878';
	
	
	$detail_text = isset($modal['modal']['data']['data']['detail_text']) ? $modal['modal']['data']['data']['detail_text'] : '';
	
	$mode = isset($modal['modal']['data']['data']['mode']) ? $modal['modal']['data']['data']['mode'] : '';

	$static_number = isset($modal['modal']['data']['data']['static_number']) ? $modal['modal']['data']['data']['static_number'] : '';
	$function_php = isset($modal['modal']['data']['data']['function_php']) ? $modal['modal']['data']['data']['function_php'] : '';
	$function_js = isset($modal['modal']['data']['data']['function_js']) ? $modal['modal']['data']['data']['function_js'] : '';
	$external_url = isset($modal['modal']['data']['data']['external_url']) ? $modal['modal']['data']['data']['external_url'] : '';
	
	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
		extract($modal_obj);
	}
	
	$icon_used = ($icon_class != "" || $icon_url != "") ? true : false;
	
		

	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Achievement Element" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Achievement Element</h3>
		</div>
		<div class="modal-body" data-saved="false">
			<div class="row-fluid">
				<div class="span6">
					<div class="number_color">
						'.rockbuilder_make_colorpicker($id.'-number-color', $number_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Number Color</strong><br/>
					<p>Choose number color</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="text_color">
						'.rockbuilder_make_colorpicker($id.'-text-color', $text_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Text Color</strong><br/>
					<p>Choose text color</p>
				</div>
			</div>
			<hr/>	
			
			<div class="row-fluid">
				<div class="span6">
					<div class="icon_bg_color">
						'.rockbuilder_make_colorpicker($id.'-icon-bg-color', $icon_bg_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Icon Background Color</strong><br/>
					<p>Choose icon background color</p>
				</div>
			</div>
			<hr/>			
			<div class="row-fluid">
				<div class="span6">
					<div class="icon_color">
						'.rockbuilder_make_colorpicker($id.'-icon-color', $icon_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Icon Color</strong><br/>
					<p>Choose icon color</p>
				</div>
			</div>
			<hr/>			
			
					
			
			<div class="row-fluid">
				<div class="span6 elem-icon">
					<div class="icon-holder add-elem-icon-btn" icon-ref="'.esc_attr($icon_class).'">'.(($icon_class != "") ? '<i class="'.esc_attr($icon_class).' fa-4x"></i>' : '').'</div><br/>
					<input autocomplete="off" type="text" size="36" class="add-elem-icon-text" '.($icon_url != "" ? "": 'style="display:none;"').' value="'.($icon_url != "" ? esc_url($icon_url) : "").'"/>
					'.(!$icon_used ? '<div class="add-elem-icon-btn btn">Add Icon</div>' : '<div class="add-elem-icon-btn btn hide">Add Icon</div>').'
					'.($icon_used ? '<div class="remove-elem-icon-btn btn">Remove Icon</div>' : '<div class="remove-elem-icon-btn btn hide">Remove Icon</div>').'
				</div>
				<div class="span6">
					<strong>Button Icon</strong><br/>
					<p>Choose an icon (Optional)</p>
				</div>
			</div>
			<hr/>									
			
			
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="detail_text" value="'.esc_attr($detail_text).'" />
				</div>
				<div class="span6">
					<strong>Element Details</strong>
					<p>Enter the text.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="static_number" value="'.esc_attr($static_number).'" />
				</div>
				<div class="span6">
					<strong>Achievement Static Number</strong>
					<p>Enter a number. Number must not contain any "," or "." characters. Only enter numberic characters (0 - 9)</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="mode" autocomplete="off">
						<option value="static" '.($mode == "top" ? 'selected="selected"' : '').'>Static Mode</option>
						<option value="function_php" '.($mode == "function_php" ? 'selected="selected"' : '').'>Use PHP function</option>
						<option value="function_js" '.($mode == "function_js" ? 'selected="selected"' : '').'>Use Javascript function</option>
						<option value="function_ajax" '.($mode == "function_ajax" ? 'selected="selected"' : '').'>Use PHP function via Ajax</option>
						<option value="url" '.($mode == "url" ? 'selected="selected"' : '').'>Use URL</option>
					</select>
				</div>
				<div class="span6">
					<strong>Achievement Mode</strong><br/>
					<p>Static Mode will use the number you enter here. If you will use a php/javascript function or a url, make sure that function/url returns a valid number.</p>
				</div>										
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="function_php" value="'.esc_attr($function_php).'" />
				</div>
				<div class="span6">
					<strong>Use PHP Function</strong>
					<p>Enter the PHP function name. Make sure that function is included (inside functions.php file) and returns a valid number.</p>
					<p>If you are using Ajax, your function name should start with "rockthemes_achievement_ajax_". For example "rockthemes_achievement_ajax_test".</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="function_js" value="'.esc_attr($function_js).'" />
				</div>
				<div class="span6">
					<strong>Use Javascript Function</strong>
					<p>Enter the javascript function name. Make sure that function can be called globally and returns a valid number</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="external_url" value="'.esc_url($external_url).'" />
				</div>
				<div class="span6">
					<strong>Use External URL</strong>
					<p>Enter an external URL. Make sure that URL is accessible and returns a valid number</p>
				</div>
			</div>
			<hr/>

		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary achievement-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	

	return $return;
}

function xr_make_achievement_modal_ajax(){
	echo xr_make_achievement_modal();
	exit;
}
add_action('wp_ajax_xr_make_achievement_modal','xr_make_achievement_modal_ajax');

//End of achievement element







/*
**	Heading Element Modal
*/

function xr_make_heading_modal($modal=null,$id=null){
	global $rock_page_builder_config;
	$is_ajax = false;
	
	$bold_color = function_exists('xr_get_option') ? xr_get_option('heading_bold_color','') : '';
	$regular_color = function_exists('xr_get_option') ? xr_get_option('heading_light_color','') : '';
	$details_color = function_exists('xr_get_option') ? xr_get_option('heading_desc_color','') : '';
	
	$bold_text = '';
	$light_text = '';
	$details_text = '';
	
	$html_tag = '';
	$align = '';
	$heading_font_size = '';
	$use_icon = '';
	
	$disable_margin = 'no';
	$border_bottom = 'yes';
	
	if(isset($modal['modal']['data']['data'])){
		extract($modal['modal']['data']['data']);	
	}
	

	if(isset($_REQUEST['ajax_object'])){
		$is_ajax = true;
		$modal_obj = $_REQUEST['ajax_object'];
		$id = $modal_obj['id'];
		extract($modal_obj);
	}
	
	
	

	$return = '
	<div id="'.$id.'" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Heading Element" aria-hidden="true">
		<div class="modal-header">
			<div class="close builder-close"><i class="fa fa-times"></i></div>
			'.rock_builder_item_trans_btn(array(
				'type'			=>	(isset($modal) && isset($modal['modal']) && isset($modal['modal']['descType']) ? $modal['modal']['descType'] : ''),
			)).'
			<h3>Heading Element</h3>
		</div>
		<div class="modal-body" data-saved="false">
		
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="bold_text" value="'.esc_attr($bold_text).'" />
				</div>
				<div class="span6">
					<strong>Bold Heading Text</strong>
					<p>Enter the text.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="light_text" value="'.esc_attr($light_text).'" />
				</div>
				<div class="span6">
					<strong>Light Heading Text</strong>
					<p>Enter the text.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="details_text" value="'.esc_attr($details_text).'" />
				</div>
				<div class="span6">
					<strong>Heading Details Text</strong>
					<p>Enter the detail text under heading.</p>
				</div>
			</div>
			<hr/>
		
		
			<div class="row-fluid">
				<div class="span6">
					<div class="bold_color">
						'.rockbuilder_make_colorpicker($id.'-bold-color', $bold_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Bold Font Color</strong><br/>
					<p>Choose a color</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<div class="regular_color">
						'.rockbuilder_make_colorpicker($id.'-regular-color', $regular_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Light Font & Icon Color</strong><br/>
					<p>Choose a color for light text and the icon</p>
				</div>
			</div>
			<hr/>			
			<div class="row-fluid">
				<div class="span6">
					<div class="details_color">
						'.rockbuilder_make_colorpicker($id.'-details-color', $details_color).'
					</div>
				</div>
				<div class="span6">
					<strong>Details Color</strong><br/>
					<p>Choose a color</p>
				</div>
			</div>
			<hr/>		

			<div class="row-fluid">
				<div class="span6">
					<select class="html_tag" autocomplete="off">
						<option value="h1" '.($html_tag == "h1" ? 'selected="selected"' : '').'>H1</option>
						<option value="h2" '.($html_tag == "h2" ? 'selected="selected"' : '').'>H2</option>
						<option value="h3" '.($html_tag == "h3" ? 'selected="selected"' : '').'>H3</option>
						<option value="h4" '.($html_tag == "h4" ? 'selected="selected"' : '').'>H4</option>
						<option value="h5" '.($html_tag == "h5" ? 'selected="selected"' : '').'>H5</option>
						<option value="h6" '.($html_tag == "h6" ? 'selected="selected"' : '').'>H6</option>
						<option value="span" '.($html_tag == "span" ? 'selected="selected"' : '').'>Span</option>
						<option value="div" '.($html_tag == "div" ? 'selected="selected"' : '').'>Div</option>
					</select>
				</div>
				<div class="span6">
					<strong>Heading HTML Tag</strong><br/>
					<p>Choose an HTML tag for heading. This will increase the SEO according to the heading usage.</p>
				</div>										
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<input autocomplete="off" type="text" class="heading_font_size" value="'.esc_attr($heading_font_size).'" />
				</div>
				<div class="span6">
					<strong>Heading Font Size</strong>
					<p>Font size, will avoid any html tag used. You should enter a valid value like 74px.</p>
				</div>
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="align" autocomplete="off">
						<option value="left" '.($align == "left" ? 'selected="selected"' : '').'>Left</option>
						<option value="right" '.($align == "right" ? 'selected="selected"' : '').'>Right</option>
						<option value="center" '.($align == "center" ? 'selected="selected"' : '').'>Center</option>
					</select>
				</div>
				<div class="span6">
					<strong>Align</strong><br/>
					<p>Choose the align of heading</p>
				</div>										
			</div>
			<hr/>
			
			<div class="row-fluid">
				<div class="span6">
					<select class="use_icon" autocomplete="off">
						<option value="yes" '.($use_icon == "yes" ? 'selected="selected"' : '').'>Use Heading Icon</option>
						<option value="no" '.($use_icon == "no" ? 'selected="selected"' : '').'>Disable Icon</option>
					</select>
				</div>
				<div class="span6">
					<strong>Heading Icon</strong><br/>
					<p>You can enable/disable heading icon</p>
				</div>										
			</div>
			<hr/>
			<div class="row-fluid">
				<div class="span6">
					<select class="border_bottom" autocomplete="off">
						<option value="yes" '.($border_bottom == "yes" ? 'selected="selected"' : '').'>Enable Border Bottom</option>
						<option value="no" '.($border_bottom == "no" ? 'selected="selected"' : '').'>Disable Border Bottom</option>
					</select>
				</div>
				<div class="span6">
					<strong>Border Bottom</strong><br/>
					<p>You can enable/disable border bottom</p>
				</div>										
			</div>
			<hr/>
			
			
			<div class="row-fluid">
				<div class="span6">
					<select class="disable_margin" autocomplete="off">
						<option value="no" '.($disable_margin == "no" ? 'selected="selected"' : '').'>Use Margin</option>
						<option value="yes" '.($disable_margin == "yes" ? 'selected="selected"' : '').'>Disable Margin</option>
					</select>
				</div>
				<div class="span6">
					<strong>Use Margin</strong><br/>
					<p>You can enable/disable margin bottom for the heading.</p>
				</div>										
			</div>
			<hr/>

		</div>
		<div class="modal-footer">
			<div class="btn builder-close">Close</div>
			<div class="btn btn-primary heading-modal-save builder-close" ref="'.$id.'">Save changes</div>
		</div>
	</div>';
	
	

	return $return;
}

function xr_make_heading_modal_ajax(){
	echo xr_make_heading_modal();
	exit;
}
add_action('wp_ajax_xr_make_heading_modal','xr_make_heading_modal_ajax');

//End of Heading element









/*
**	Rock Font Awesome List and Icon Modal
**	This function is very extendable with new icons
**	This also supports 3rd party icons with their link
**
**	@since	:	Version 2
*/

function rock_icon_list_modal(){
	//We declare icon list in another function to make it all expandable without touching core codes.
	$icon_list = rockthemes_get_icon_list();	
	
	$icon_html = '';
	

	foreach($icon_list as $icon){

		$icon_html .= '<i class="'.$icon.' fa-3x rock-choose-icon" ref="'.$icon.'"></i>';
		
	}
	
	$return = '<div id="rock-icon-list-modal" modalType="iconlist" class="rpb_modal container hide fade" tabindex="-1" role="dialog" aria-labelledby="Tabs" aria-hidden="true">
								<div class="modal-header">
									<div class="close close-tab-single"><i class="fa fa-times"></i></div>
					  				<h3>Choose an Icon</h3>
								</div>
								<div class="modal-body" data-saved="false">
									<div class="row-fluid">
										<div class="span12">
											<input autocomplete="off" type="text" class="rock-search-fontawesome-icons" value="" placeholder="Search :" />
											<div class="rock-fontawesome-icons" >
												'.$icon_html.'
											</div>
										</div>
									</div>
									<hr/>
									<div class="row-fluid">
										<div class="span6">
											<div class="swiperslider-modal-image" ref="icon-image-uploader">
												<h4>Choose an Image</h4>
												<div class="hide image-data"></div>
												<label for="upload_image"> <input autocomplete="off" id="icon-image-uploader" class="upload_image_button" size="36" name="upload_image" type="text" value="" /> <input autocomplete="off" class="image_uploader_class btn" value="Upload Image" type="button" /> </label><br/>
											</div>
										</div>
										<div class="span6">
											<h3>External Icon</h3>
											<p>If you don\'t want to use our font icons, you can either enter a link of an icon or upload your own icon file.But we strongly recommend using our font icons for Retina Support.</p>
										</div>
									</div>
									<hr/>
								</div>
								<div class="modal-footer">
									<div class="btn close-tab-single">Close</div>
									<div class="btn btn-primary iconlist-save" modal-ref="rock-icon-list-modal">Save changes</div>
								</div>
							</div>';
		
	return $return;
}

function rock_icon_list_modal_ajax(){
	echo rock_icon_list_modal();
	exit;
}
add_action('wp_ajax_rock_icon_list_modal','rock_icon_list_modal_ajax');





if(!function_exists('rockthemes_pb_make_columns_list')){
/*
**	Rock Builder Uses 12 Columns Grid system
**	This function generates a list object for 12 column
**	@param $selected = selected column value
*/
	function rockthemes_pb_make_columns_list($selected = null){
		
		
		$return = '<div class="columns_select_holder">
						<h4>Select Columns</h4>
						<select class="columns_select">';
		
		if($selected === 1){
			$return .= '<option value="1" selected>One Column</option>';
		}else{
			$return .= '<option value="1">One Column</option>';
		}
		
		if($selected === 2){
			$return .= '<option value="2" selected>Two Column</option>';
		}else{
			$return .= '<option value="2">Two Column</option>';
		}
		
		if($selected === 3){
			$return .= '<option value="3" selected>Three Column</option>';
		}else{
			$return .= '<option value="3">Three Column</option>';
		}
		
		if($selected === 4){
			$return .= '<option value="4" selected>Four Column</option>';
		}else{
			$return .= '<option value="4">Four Column</option>';
		}
		
		if($selected === 5){
			$return .= '<option value="5" selected>Five Column</option>';
		}else{
			$return .= '<option value="5">Five Column</option>';
		}
		
		if($selected === 6){
			$return .= '<option value="6" selected>Six Column</option>';
		}else{
			$return .= '<option value="6">Six Column</option>';
		}
		
		if($selected === 7){
			$return .= '<option value="7" selected>Seven Column</option>';
		}else{
			$return .= '<option value="7">Seven Column</option>';
		}
	
		if($selected === 8){
			$return .= '<option value="8" selected>Eight Column</option>';
		}else{
			$return .= '<option value="8">Eight Column</option>';
		}
	
		if($selected === 9){
			$return .= '<option value="9" selected>Nine Column</option>';
		}else{
			$return .= '<option value="9">Nine Column</option>';
		}
	
		if($selected === 10){
			$return .= '<option value="10" selected>Ten Column</option>';
		}else{
			$return .= '<option value="10">Ten Column</option>';
		}
	
		if($selected === 11){
			$return .= '<option value="11" selected>Eleven Column</option>';
		}else{
			$return .= '<option value="11">Eleven Column</option>';
		}
	
		if($selected === 12){
			$return .= '<option value="12" selected>Twelve Column</option>';
		}else{
			$return .= '<option value="12">Twelve Column</option>';
		}
	
		$return .= '</select></div>';
		
		return $return;
	}
}

function rockthemes_pb_element_list_modal(){
	global $post;
	
	$elements = '
		<ul id="add-element-element" class="rockthems-pb-elements-list">';
		
	$options = '
		  <li element="specialgridblock" class="special-grid-elem-class"><i class="fa fa-inbox"></i><br/>Special Grid Blocks</li>
		  <li element="textarea"><i class="fa fa-text-width"></i><br/>Text Area</li>
		  <li element="featuredimage"><i class="fa fa-image"></i><br/>Featured Image</li>
	';
	
	//If Steps element is active and added via config file, include it to elements.
	if(defined('RPB_SINGLE_IMAGE')){
		$options .= '<li element="singleimage"><i class="fa fa-image"></i><br/>Image</li>';
	}
	
	$options .= '
		  <li element="swiperslider"><i class="fa fa-hand-o-up"></i><br/>Swiper Slider</li>
		  <li element="pricingtable"><i class="fa fa-dollar"></i><br/>Pricing Table</li>
		  <li element="curvyslider"><div class="regular-font">C</div><br/>Curvy Slider</li>
		  <li element="sidebar"><i class="fa fa-columns"></i><br/>Sidebar</li>
		  <li element="toggles"><i class="fa fa-align-justify"></i><br/>Toggles</li>
		  <li element="tabs"><i class="fa fa-credit-card"></i><br/>Tabs</li>
		  <li element="iconictext"><i class="fa fa-indent"></i><br/>Iconic Text</li>
		  <li element="button"><i class="fa fa-link"></i><br/>Button</li>
		  <li element="skill"><i class="fa fa-tasks"></i><br/>Skill</li>
		  <li element="horizontalrule"><i class="fa fa-arrows-h"></i><br/>HR</li>
	';
	
	//If Vertical Space Element is active and added via config file, include it to elements.
	if(defined('RPB_VERTICAL_SPACE')){
		$options .= '<li element="verticalspace"><i class="fa fa-arrows-v"></i><br/>Vertical Space</li>';
	}
	
	$options .= '
		  <li element="portfolio"><i class="fa fa-th-list"></i><br/>Portfolio</li>
		  <li element="googlemap"><i class="fa fa-map-marker"></i><br/>Google Map (*Paid)</li>
		  <li element="leafletmap"><i class="fa fa-map-marker"></i><br/>LeafLet Map</li>
		  <li element="promotionbox"><i class="fa fa-bullhorn"></i><br/>Promotion Box</li>
		  <li element="alertbox"><i class="fa fa-warning"></i><br/>Alert Box</li>
		  <li element="referencesbuilder"><i class="fa fa-user"></i><br/>References Builder</li>
		  <li element="testimonialsbuilder"><i class="fa fa-comments-o"></i><br/>Testimonials Builder</li>
		  <li element="socialicons"><i class="fa fa-share"></i><br/>Social Icons</li>
		  <li element="teammembers"><i class="fa fa-group"></i><br/>Team Members</li>
		  <li element="beforeafterslider"><i class="fa fa-exchange"></i><br/>Before After Slider</li>
		  <li element="externalshortcode"><i class="fa fa-code"></i><br/>External Code</li>
		  <li element="regularblog"><i class="fa fa-archive"></i><br/>Regular Blog</li>
	';
	
	$rock_form_builder = get_option('rockthemes_fb_references',array());
	
	
	//If Steps element is active and added via config file, include it to elements.
	if(defined('RPB_STEPS')){
		$options .= '<li element="stepselement"><i class="fa fa-ellipsis-h"></i><br/>Steps</li>';
	}
	
	//If Ajax Filtered Gallery Element is active and added via config file, include it to elements.
	if(defined('RPB_HEADING')){
		$options .= '<li element="heading"><i class="fa fa-font"></i><br/>Heading</li>';
	}
	
	//If Ajax Filtered Gallery Element is active and added via config file, include it to elements.
	if(defined('RPB_AJAX_FILTERED_PORTFOLIO')){
		$options .= '<li element="ajaxfiltered"><i class="fa fa-th"></i><br/>Ajax Filtered Gallery</li>';
	}
	
	//If Regular Gallery Element is active and added via config file, include it to elements.
	if(defined('RPB_GALLERY')){
		$options .= '<li element="gallery"><i class="fa fa-camera-retro"></i><br/>Gallery</li>';
	}
	
	//If Hover Element is active and added via config file, include it to elements.
	if(defined('RPB_HOVER_ELEMENT')){
		$options .= '<li element="hoverelement"><i class="fa fa-paw"></i><br/>Hover Element</li>';
	}
	
	//If Youtube Element is active and added via config file, include it to elements.
	if(defined('RPB_YOUTUBE_ELEMENT')){
		$options .= '<li element="youtube"><i class="fa fa-youtube"></i><br/>Youtube</li>';
	}
	
	//If Vimeo Element is active and added via config file, include it to elements.
	if(defined('RPB_VIMEO_ELEMENT')){
		$options .= '<li element="vimeo"><i class="fa fa-vimeo-square"></i><br/>Vimeo</li>';
	}
	
	//If HTML5 Element is active and added via config file, include it to elements.
	if(defined('RPB_HTML5_VIDEO')){
		$options .= '<li element="htmlvideo"><i class="fa fa-video-camera"></i><br/>HTML5 Video</li>';
	}
	
	//If Hover Element is active and added via config file, include it to elements.
	if(defined('RPB_HOVER_ACHIEVEMENT')){
		$options .= '<li element="achievement"><i class="fa fa-flag-checkered"></i><br/>Achievement</li>';
	}
	
	//If Element Transfer Mode is active and added via config file, include it to elements.
	if(defined('RPB_ELEM_TRANSFER')){
		$options .= '<li element="importelement"><i class="fa fa-magic"></i><br/>Import Element</li>';
	}
	
	//If Rock Form Builder active, include it to elements.
	if(!empty($rock_form_builder)){
		$options .= '<li element="rockformbuilder"><i class="fa fa-list-alt"></i><br/>Rock Form Builder</li>';
	}
	
	//If Revolution Slider active and added via config file, include it to elements.
	if(class_exists('RevSlider') && defined('RPB_REVOLUTION_SLIDER')){
		$options .= '<li element="revolutionslider"><i class="fa fa-random"></i><br/>Revolution Slider</li>';
	}
	
	
	
	$options = apply_filters('rockthemes_pb_element_list',$options);
	
	$elements .= $options.'
		</ul>
		<div class="clear"></div>
	';	
	
	
	$columns = '<div class="add-elem-modal-columns">';
	$columns .= '<strong>Columns :</strong><br/>';
	
	$columns .= '<ul class="rockthemes-pb-columns-list">';
	$column = '';
	
	for($c = 1; $c < 13; $c++){
		$column .= '<li class="col">'.$c.' / 12</li>';
	}
	
	$columns .= $column;

	$columns .= '</ul>';
	
	$columns .= '<div class="clear"></div><hr/></div>';
	
	
	$modal = '
		<div id="rockthemes-pb-elements-modal" class="rpb_modal container hide">
			<div class="modal-header">
				<div class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></div>
					<h3>Add Page Builder Element</h3>
				</div>
			<div class="modal-body" data-saved="false">
				'.$columns.'
				'.$elements.'
			</div>
		</div>
	';

	
	
	return $modal;
}

function rock_pages_builder_menu(){
	global $post;

	$buttons = '
	<div id="send_content_to_tinymce" postID="'.$post->ID.'" class="btn btn-small alignright main-action-button"><i class="fa fa-signin"></i> Add Content to Text Editor</div>
	<div class="rockthemes-pb-add-element-main-button btn btn-small alignleft main-action-button"><i class="fa fa-plus-circle"></i> Add Element</div>
	<div class="clear"></div>
	';
	
	//return $elements.'<br/>'.$layouts.'<br/>'.$buttons.'</br>';
	return $buttons;
}



/*

	This function will be moved to another file

*/

function getDefinedButtonColors($returnList = null,$selected = null){
	if($returnList != null){
		$returnSelect = 	'<select class="button_type" style="width:100%;" autocomplete="off">';

		if($selected == "no-button"){
			$returnSelect .= '<option value="no-button" selected>No Button</option>';
		}else{
			$returnSelect .= '<option value="no-button">No Button</option>';
		}
		
		if($selected == "red"){
			$returnSelect .= '<option value="red" selected>Red Button</option>';
		}else{
			$returnSelect .= '<option value="red">Red Button</option>';
		}
		
		if($selected == "green"){
			$returnSelect .= '<option value="green" selected>Green Button</option>';
		}else{
			$returnSelect .= '<option value="green">Green Button</option>';
		}

		if($selected == "yellow"){
			$returnSelect .= '<option value="yellow" selected>Yellow Button</option>';
		}else{
			$returnSelect .= '<option value="yellow">Yellow Button</option>';
		}

		$returnSelect .= '</select>';	
							
		return $returnSelect;
	}
}


?>