<?php

/*
**	Rock Page Builder Config File
**
**	Alias	:	Rock Builder UI		Located in "rock-builder/builder-functions.php"
**	Alias	:	Rock Builder		Located in "rock-builder/rock-builder-ui.php"
**	Author	:	Rockthemes.net
**	License	:	Contact to rockthemes.net for further information
**	Version	:	1.3
**
**	Rock Page Builder Config file
**
**	Config file will contains Constants of settins related to the theme
**
*/


/*
**	Main variable that holds all of the configurations in array.
**	This array will be used to send these configurations to javascript
**
**	Array elements will use "yes" instead of "true/false". This will avoid Boolean/String 
**	conflict between PHP and Javascript
**
**	General settings will be on root level of $rock_page_builder_config
**
**	Elements will be in "elements" array in $rock_page_builder_config
**	$rock_page_builder_config['elements']
**
**	@since	:	1.3
*/

$rock_page_builder_config = array('elements' => array());


/*
**	GENERAL CONFIGURATION
**
**	General Library Rules and Configurations
**
**	Configuration variable $rock_page_builder_config will add "use_" for general configurations
**
**	@since 1.3
*/




/*
**	Rock Builder Version
**	Version is not overriable. This will be static for the current version
**
**	@since	:	1.3
*/
define('RPB_BE_VERSION','2.0.0');
define('RPB_VERSION', '2.0.0');
$rock_page_builder_config['rpb_version'] = '2.0.0';




/*
**	Rock Builder Settings
**
**	Define settings as an array to store default settings
*/
$rock_page_builder_config['settings'] = array();







/*
**	Rock Builder Responsive Design Breakpoints. Must use the same values in responsivity breakpoints.
**	We use Zurb Foundation for responsive design with external changes. 
**	This is strict rule and can't change
**
**	HD Block Grid		:	Bigger than 1828px / 114.286em
**	Large Block Grid	:	Bigger than 768px
**	Medium Block Grid	:	Smaller than 768px & bigger than 540px
**	Small Block Grid	:	Smaller than 540px
**
**	Large Columns		:	Bigger than 1024px / 64em // Was Bigger than 1025px / 64.063em
**	Medium Columns		:	Smaller than 1024px & bigger than 800px (800px included)
**	Small Columns		:	Smaller than 800px
**
**	@since	:	1.3
*/
$rock_page_builder_config['settings']['medium_block_size'] = '800';
$rock_page_builder_config['settings']['small_block_size'] = '540';







/*
**	Use Gridster Widget Move : RPB S - RPB SETTINGS
*/
if(!defined('RPB_S_WIDGET_MOVE')){
	define('RPB_S_WIDGET_MOVE', true);
	$rock_page_builder_config['settings']['RPB_S_WIDGET_MOVE'] = 'yes';
}




/*
**	ELEMENT TRANSFER
**
*/
/*
if(!defined('RPB_ELEM_TRANSFER')){
	define('RPB_ELEM_TRANSFER', true);
	$rock_page_builder_config['settings']['RPB_ELEM_TRANSFER'] = 'yes';
}
*/





/*
**	CONTENT FILTER
**
*/
/*
if(!defined('RPB_CONTENT_FILTER')){
	define('RPB_CONTENT_FILTER', true);
	$rock_page_builder_config['settings']['RPB_CONTENT_FILTER'] = 'yes';
}
*/



/*
**	CRAYON CODE HIGHLIGHTER 
**
*/
/*
if(!defined('RPB_ENABLE_CRAYON')){
	if(class_exists('CrayonWP')){
		define('RPB_ENABLE_CRAYON', true);
		$rock_page_builder_config['settings']['RPB_ENABLE_CRAYON'] = 'yes';
	}
}
*/





/*
**	CONTENT FULL SHORTCODE
**
*/
/*
if(!defined('RPB_FULL_SHORTCODE')){
	define('RPB_FULL_SHORTCODE', true);
	$rock_page_builder_config['settings']['RPB_FULL_SHORTCODE'] = 'yes';
}
*/







/*
**	Icomoon Library
*/
if(!defined('RPB_USE_ICOMOON')){
	define('RPB_USE_ICOMOON', true);
	$rock_page_builder_config['use_icomoon'] = 'yes';
}

/*
**	FontAwesome Library
*/
if(!defined('RPB_USE_FONTAWESOME')){
	//define('RPB_USE_FONTAWESOME', true);
	//$rock_page_builder_config['use_fontawesome'] = 'yes';
}









/*
**	ROCK PAGE BUILDER ELEMENTS
**
**	Used elements will use "define" to activate
**	
**	$rock_page_builder_config['elements'] : Elements will be added into "elements" variable in $rock_page_builder_config 
**
*/




/*
**	AJAX FILTERED
**
*/
if(!defined('RPB_AJAX_FILTERED_PORTFOLIO')){
	//define('RPB_AJAX_FILTERED_PORTFOLIO', true);
	//$rock_page_builder_config['elements']['ajax_filtered_portfolio'] = 'yes';
}


/*
**	FEATURED IMAGE 
**
*/
if(!defined('RPB_FEATURED_IMAGE')){
	define('RPB_FEATURED_IMAGE', true);
	$rock_page_builder_config['elements']['featured_image'] = 'yes';
}


/*
**	SWIPER SLIDER
**
*/
if(!defined('RPB_SWIPER_SLIDER')){
	define('RPB_SWIPER_SLIDER', true);
	$rock_page_builder_config['elements']['swiper_slider'] = 'yes';
}

/*
**	PRICING TABLE
**
*/
if(!defined('RPB_PRICING_TABLE')){
	define('RPB_PRICING_TABLE', true);
	$rock_page_builder_config['elements']['pricing_table'] = 'yes';
}



/*
**	CURVY SLIDER
**
*/
if(!defined('RPB_CURVY_SLIDER')){
	define('RPB_CURVY_SLIDER', true);
	$rock_page_builder_config['elements']['curvy_slider'] = 'yes';
}



/*
**	SIDEBAR
**
*/
if(!defined('RPB_SIDEBAR')){
	define('RPB_SIDEBAR', true);
	$rock_page_builder_config['elements']['sidebar'] = 'yes';
}



/*
**	VERTICAL SPACE
**
*/
if(!defined('RPB_VERTICAL_SPACE')){
	define('RPB_VERTICAL_SPACE', true);
	$rock_page_builder_config['elements']['verticalspace'] = 'yes';
}




/*
**	TOGGLES
**
*/
if(!defined('RPB_TOGGLES')){
	define('RPB_TOGGLES', true);
	$rock_page_builder_config['elements']['toggles'] = 'yes';
}



/*
**	TABS
**
*/
if(!defined('RPB_TABS')){
	define('RPB_TABS', true);
	$rock_page_builder_config['elements']['tabs'] = 'yes';
}



/*
**	ICONIC TEXT
**
*/
if(!defined('RPB_ICONIC_TEXT')){
	define('RPB_ICONIC_TEXT', true);
	$rock_page_builder_config['elements']['iconic_text'] = 'yes';
}


/*
**	BUTTON
**
*/
if(!defined('RPB_BUTTON')){
	define('RPB_BUTTON', true);
	$rock_page_builder_config['elements']['button'] = 'yes';
}




/*
**	SKILL
**
*/
if(!defined('RPB_SKILL')){
	define('RPB_SKILL', true);
	$rock_page_builder_config['elements']['skill'] = 'yes';
}



/*
**	HORIZONTAL RULE
**
*/
if(!defined('RPB_HORIZONTAL_RULE')){
	define('RPB_HORIZONTAL_RULE', true);
	$rock_page_builder_config['elements']['horizontal_rule'] = 'yes';
}



/*
**	PORTFOLIO
**
*/
if(!defined('RPB_PORTFOLIO')){
	define('RPB_PORTFOLIO', true);
	$rock_page_builder_config['elements']['portfolio'] = 'yes';
	$rock_page_builder_config['elements']['portfolio_settings'] = array(
		'switch_models'				=>	'no',
		'details_in_hover'			=>	'yes',
		'display_price'				=>	'yes',
		'display_date'				=>	'yes',
		'hover_icons'				=>	'yes',
		'where_to_link'				=>	'yes',
		'wall_mode'					=>	'yes',
		'masonry'					=>	'yes',
		'more_items'				=>	'yes',
		'more_items_button'			=>	'yes',
		'ajax_cat_filter'			=>	'yes',
		'list_image_col_large'		=>	'yes',
		'more_items_swipe'			=>	'yes',
		'swiper_nav_number'			=>	'yes',
	);
}





/*
**	GOOGLE MAP
**
*/
if(!defined('RPB_GOOGLE_MAP')){
	define('RPB_GOOGLE_MAP', true);
	$rock_page_builder_config['elements']['google_map'] = 'yes';
}



/*
**	LeafLet MAP
**
*/
if(!defined('RPB_LEAFLET_MAP')){
	define('RPB_LEAFLET_MAP', true);
	$rock_page_builder_config['elements']['leaflet_map'] = 'yes';
}




/*
**	PROMOTION BOX
**
*/
if(!defined('RPB_PROMOTION_BOX')){
	define('RPB_PROMOTION_BOX', true);
	$rock_page_builder_config['elements']['promotion_box'] = 'yes';
}



/*
**	ALERT BOX
**
*/
if(!defined('RPB_ALERT_BOX')){
	define('RPB_ALERT_BOX', true);
	$rock_page_builder_config['elements']['alert_box'] = 'yes';
}



/*
**	REFERENCES BUILDER
**
*/
if(!defined('RPB_REFERENCES_BUILDER')){
	define('RPB_REFERENCES_BUILDER', true);
	$rock_page_builder_config['elements']['references_builder'] = 'yes';
}



/*
**	TESTIMONIALS BUILDER
**
*/
if(!defined('RPB_TESTIMONIALS_BUILDER')){
	define('RPB_TESTIMONIALS_BUILDER', true);
	$rock_page_builder_config['elements']['testimonials_builder'] = 'yes';
}



/*
**	SOCIAL ICONS
**
*/
if(!defined('RPB_SOCIAL_ICONS')){
	define('RPB_SOCIAL_ICONS', true);
	$rock_page_builder_config['elements']['social_icons'] = 'yes';
}



/*
**	TEAM MEMBERS
**
*/
if(!defined('RPB_TEAM_MEMBERS')){
	define('RPB_TEAM_MEMBERS', true);
	$rock_page_builder_config['elements']['team_members'] = 'yes';
}



/*
**	BEFORE AFTER SLIDER
**
*/
if(!defined('RPB_BEFORE_AFTER_SLIDER')){
	define('RPB_BEFORE_AFTER_SLIDER', true);
	$rock_page_builder_config['elements']['before_after_slider'] = 'yes';
}



/*
**	EXTERNAL SHORTCODE
**
*/
if(!defined('RPB_EXTERNAL_SHORTCODE')){
	define('RPB_EXTERNAL_SHORTCODE', true);
	$rock_page_builder_config['elements']['external_shortcode'] = 'yes';
}



/*
**	REGULAR BLOG
**
*/
if(!defined('RPB_REGULAR_BLOG')){
	define('RPB_REGULAR_BLOG', true);
	$rock_page_builder_config['elements']['regular_blog'] = 'yes';
}



/*
**	GALLERY
**
*/
if(!defined('RPB_GALLERY')){
	//define('RPB_GALLERY', true);
	//$rock_page_builder_config['elements']['gallery'] = 'yes';
}



/*
**	HOVER ELEMENT
**	Still In Development
*/
/*
if(!defined('RPB_HOVER_ELEMENT')){
	define('RPB_HOVER_ELEMENT', true);
	$rock_page_builder_config['elements']['hover_element'] = 'yes';
}
*/



/*
**	ACHIEVEMENT ELEMENT
**
*/
if(!defined('RPB_HOVER_ACHIEVEMENT')){
	define('RPB_HOVER_ACHIEVEMENT', true);
	$rock_page_builder_config['elements']['achievement'] = 'yes';
}



/*
**	HEADING ELEMENT
**
*/
if(!defined('RPB_HEADING')){
	define('RPB_HEADING', true);
	$rock_page_builder_config['elements']['heading'] = 'yes';
}




/*
**	STEPS ELEMENT
**
*/
if(!defined('RPB_STEPS')){
	define('RPB_STEPS', true);
	$rock_page_builder_config['elements']['stepselement'] = 'yes';
}




/*
**	SINGLE IMAGE ELEMENT
**
*/
if(!defined('RPB_SINGLE_IMAGE')){
	define('RPB_SINGLE_IMAGE', true);
	$rock_page_builder_config['elements']['singleimage'] = 'yes';
}



/*
**	YOUTUBE ELEMENT
**
*/
if(!defined('RPB_YOUTUBE_ELEMENT')){
	define('RPB_YOUTUBE_ELEMENT', true);
	$rock_page_builder_config['elements']['youtube'] = 'yes';
}

/*
**	VIMEO ELEMENT
**
*/
if(!defined('RPB_VIMEO_ELEMENT')){
	define('RPB_VIMEO_ELEMENT', true);
	$rock_page_builder_config['elements']['vimeo'] = 'yes';
}

/*
**	HTML5 VIDEO ELEMENT
**
*/
if(!defined('RPB_HTML5_VIDEO')){
	define('RPB_HTML5_VIDEO', true);
	$rock_page_builder_config['elements']['htmlvideo'] = 'yes';
}








/*
**	ROCK FORM BUILDER
**
*/
if(!defined('RPB_ROCK_FORM_BUILDER')){
	define('RPB_ROCK_FORM_BUILDER', true);
	$rock_page_builder_config['elements']['rock_form_builder'] = 'yes';
}




/*
**	REVOLUTION SLIDER
**
*/
if(!defined('RPB_REVOLUTION_SLIDER')){
	define('RPB_REVOLUTION_SLIDER', true);
	$rock_page_builder_config['elements']['revolution_slider'] = 'yes';
}









/*
**	Post Types that will use RPB. This variable will enable to use for these post types.
**	Advanced Details area also use this global variable and function.
**
**	@since	:	1.0
**
*/
function rpb_get_post_types(){
	global $rpb_post_types;
	
	$rpb_post_types = array(
			'page',
			'post',
			'defaultitems',
			'product',
	);
		
	return $rpb_post_types;
}
rpb_get_post_types();






if ((defined( 'WP_ADMIN' ) && WP_ADMIN ) ||  ( defined( 'DOING_AJAX' ) && DOING_AJAX )):
/*
**	Rockthemes Icon List
**
**	Systems using this function
**		#ROCK PAGE BUILDER
**		#ROCK THEME OPTIONS
**		#ROCK MEGA MENU
**		#ROCK MOBILE MENU
**
**	@return	:	Array	- List of icon classes
**	@since	:	Version 2
*/
function rockthemes_get_icon_list(){
	$icon_list = array();
	
	$rockthemes_icon_list = array();

	
	$icomoon_list = array(
		'icomoon icomoon-icon-home',
		'icomoon icomoon-icon-home2',
		'icomoon icomoon-icon-home3',
		'icomoon icomoon-icon-office',
		'icomoon icomoon-icon-newspaper',
		'icomoon icomoon-icon-pencil',
		'icomoon icomoon-icon-pencil2',
		'icomoon icomoon-icon-quill',
		'icomoon icomoon-icon-pen',
		'icomoon icomoon-icon-blog',
		'icomoon icomoon-icon-droplet',
		'icomoon icomoon-icon-paint-format',
		'icomoon icomoon-icon-image',
		'icomoon icomoon-icon-image2',
		'icomoon icomoon-icon-images',
		'icomoon icomoon-icon-camera',
		'icomoon icomoon-icon-music',
		'icomoon icomoon-icon-headphones',
		'icomoon icomoon-icon-play',
		'icomoon icomoon-icon-film',
		'icomoon icomoon-icon-camera2',
		'icomoon icomoon-icon-dice',
		'icomoon icomoon-icon-pacman',
		'icomoon icomoon-icon-spades',
		'icomoon icomoon-icon-clubs',
		'icomoon icomoon-icon-diamonds',
		'icomoon icomoon-icon-pawn',
		'icomoon icomoon-icon-bullhorn',
		'icomoon icomoon-icon-connection',
		'icomoon icomoon-icon-podcast',
		'icomoon icomoon-icon-feed',
		'icomoon icomoon-icon-book',
		'icomoon icomoon-icon-books',
		'icomoon icomoon-icon-library',
		'icomoon icomoon-icon-file',
		'icomoon icomoon-icon-profile',
		'icomoon icomoon-icon-file2',
		'icomoon icomoon-icon-file3',
		'icomoon icomoon-icon-file4',
		'icomoon icomoon-icon-copy',
		'icomoon icomoon-icon-copy2',
		'icomoon icomoon-icon-copy3',
		'icomoon icomoon-icon-paste',
		'icomoon icomoon-icon-paste2',
		'icomoon icomoon-icon-paste3',
		'icomoon icomoon-icon-stack',
		'icomoon icomoon-icon-folder',
		'icomoon icomoon-icon-folder-open',
		'icomoon icomoon-icon-tag',
		'icomoon icomoon-icon-tags',
		'icomoon icomoon-icon-barcode',
		'icomoon icomoon-icon-qrcode',
		'icomoon icomoon-icon-ticket',
		'icomoon icomoon-icon-cart',
		'icomoon icomoon-icon-cart2',
		'icomoon icomoon-icon-cart3',
		'icomoon icomoon-icon-coin',
		'icomoon icomoon-icon-credit',
		'icomoon icomoon-icon-calculate',
		'icomoon icomoon-icon-support',
		'icomoon icomoon-icon-phone',
		'icomoon icomoon-icon-phone-hang-up',
		'icomoon icomoon-icon-address-book',
		'icomoon icomoon-icon-notebook',
		'icomoon icomoon-icon-envelope',
		'icomoon icomoon-icon-pushpin',
		'icomoon icomoon-icon-location',
		'icomoon icomoon-icon-location2',
		'icomoon icomoon-icon-compass',
		'icomoon icomoon-icon-map',
		'icomoon icomoon-icon-map2',
		'icomoon icomoon-icon-history',
		'icomoon icomoon-icon-clock',
		'icomoon icomoon-icon-clock2',
		'icomoon icomoon-icon-alarm',
		'icomoon icomoon-icon-alarm2',
		'icomoon icomoon-icon-bell',
		'icomoon icomoon-icon-stopwatch',
		'icomoon icomoon-icon-calendar',
		'icomoon icomoon-icon-calendar2',
		'icomoon icomoon-icon-print',
		'icomoon icomoon-icon-keyboard',
		'icomoon icomoon-icon-screen',
		'icomoon icomoon-icon-laptop',
		'icomoon icomoon-icon-mobile',
		'icomoon icomoon-icon-mobile2',
		'icomoon icomoon-icon-tablet',
		'icomoon icomoon-icon-tv',
		'icomoon icomoon-icon-cabinet',
		'icomoon icomoon-icon-drawer',
		'icomoon icomoon-icon-drawer2',
		'icomoon icomoon-icon-drawer3',
		'icomoon icomoon-icon-box-add',
		'icomoon icomoon-icon-box-remove',
		'icomoon icomoon-icon-download',
		'icomoon icomoon-icon-upload',
		'icomoon icomoon-icon-disk',
		'icomoon icomoon-icon-storage',
		'icomoon icomoon-icon-undo',
		'icomoon icomoon-icon-redo',
		'icomoon icomoon-icon-flip',
		'icomoon icomoon-icon-flip2',
		'icomoon icomoon-icon-undo2',
		'icomoon icomoon-icon-redo2',
		'icomoon icomoon-icon-forward',
		'icomoon icomoon-icon-reply',
		'icomoon icomoon-icon-bubble',
		'icomoon icomoon-icon-bubbles',
		'icomoon icomoon-icon-bubbles2',
		'icomoon icomoon-icon-bubble2',
		'icomoon icomoon-icon-bubbles3',
		'icomoon icomoon-icon-bubbles4',
		'icomoon icomoon-icon-user',
		'icomoon icomoon-icon-users',
		'icomoon icomoon-icon-user2',
		'icomoon icomoon-icon-users2',
		'icomoon icomoon-icon-user3',
		'icomoon icomoon-icon-user4',
		'icomoon icomoon-icon-quotes-left',
		'icomoon icomoon-icon-busy',
		'icomoon icomoon-icon-spinner',
		'icomoon icomoon-icon-spinner2',
		'icomoon icomoon-icon-spinner3',
		'icomoon icomoon-icon-spinner4',
		'icomoon icomoon-icon-spinner5',
		'icomoon icomoon-icon-spinner6',
		'icomoon icomoon-icon-binoculars',
		'icomoon icomoon-icon-search',
		'icomoon icomoon-icon-zoomin',
		'icomoon icomoon-icon-zoomout',
		'icomoon icomoon-icon-expand',
		'icomoon icomoon-icon-contract',
		'icomoon icomoon-icon-expand2',
		'icomoon icomoon-icon-contract2',
		'icomoon icomoon-icon-key',
		'icomoon icomoon-icon-key2',
		'icomoon icomoon-icon-lock',
		'icomoon icomoon-icon-lock2',
		'icomoon icomoon-icon-unlocked',
		'icomoon icomoon-icon-wrench',
		'icomoon icomoon-icon-settings',
		'icomoon icomoon-icon-equalizer',
		'icomoon icomoon-icon-cog',
		'icomoon icomoon-icon-cogs',
		'icomoon icomoon-icon-cog2',
		'icomoon icomoon-icon-hammer',
		'icomoon icomoon-icon-wand',
		'icomoon icomoon-icon-aid',
		'icomoon icomoon-icon-bug',
		'icomoon icomoon-icon-pie',
		'icomoon icomoon-icon-stats',
		'icomoon icomoon-icon-bars',
		'icomoon icomoon-icon-bars2',
		'icomoon icomoon-icon-gift',
		'icomoon icomoon-icon-trophy',
		'icomoon icomoon-icon-glass',
		'icomoon icomoon-icon-mug',
		'icomoon icomoon-icon-food',
		'icomoon icomoon-icon-leaf',
		'icomoon icomoon-icon-rocket',
		'icomoon icomoon-icon-meter',
		'icomoon icomoon-icon-meter2',
		'icomoon icomoon-icon-dashboard',
		'icomoon icomoon-icon-hammer2',
		'icomoon icomoon-icon-fire',
		'icomoon icomoon-icon-lab',
		'icomoon icomoon-icon-magnet',
		'icomoon icomoon-icon-remove',
		'icomoon icomoon-icon-remove2',
		'icomoon icomoon-icon-briefcase',
		'icomoon icomoon-icon-airplane',
		'icomoon icomoon-icon-truck',
		'icomoon icomoon-icon-road',
		'icomoon icomoon-icon-accessibility',
		'icomoon icomoon-icon-target',
		'icomoon icomoon-icon-shield',
		'icomoon icomoon-icon-lightning',
		'icomoon icomoon-icon-switch',
		'icomoon icomoon-icon-powercord',
		'icomoon icomoon-icon-signup',
		'icomoon icomoon-icon-list',
		'icomoon icomoon-icon-list2',
		'icomoon icomoon-icon-numbered-list',
		'icomoon icomoon-icon-menu',
		'icomoon icomoon-icon-menu2',
		'icomoon icomoon-icon-tree',
		'icomoon icomoon-icon-cloud',
		'icomoon icomoon-icon-cloud-download',
		'icomoon icomoon-icon-cloud-upload',
		'icomoon icomoon-icon-download2',
		'icomoon icomoon-icon-upload2',
		'icomoon icomoon-icon-download3',
		'icomoon icomoon-icon-upload3',
		'icomoon icomoon-icon-globe',
		'icomoon icomoon-icon-earth',
		'icomoon icomoon-icon-link',
		'icomoon icomoon-icon-flag',
		'icomoon icomoon-icon-attachment',
		'icomoon icomoon-icon-eye',
		'icomoon icomoon-icon-eye-blocked',
		'icomoon icomoon-icon-eye2',
		'icomoon icomoon-icon-bookmark',
		'icomoon icomoon-icon-bookmarks',
		'icomoon icomoon-icon-brightness-medium',
		'icomoon icomoon-icon-brightness-contrast',
		'icomoon icomoon-icon-contrast',
		'icomoon icomoon-icon-star',
		'icomoon icomoon-icon-star2',
		'icomoon icomoon-icon-star3',
		'icomoon icomoon-icon-heart',
		'icomoon icomoon-icon-heart2',
		'icomoon icomoon-icon-heart-broken',
		'icomoon icomoon-icon-thumbs-up',
		'icomoon icomoon-icon-thumbs-up2',
		'icomoon icomoon-icon-happy',
		'icomoon icomoon-icon-happy2',
		'icomoon icomoon-icon-smiley',
		'icomoon icomoon-icon-smiley2',
		'icomoon icomoon-icon-tongue',
		'icomoon icomoon-icon-tongue2',
		'icomoon icomoon-icon-sad',
		'icomoon icomoon-icon-sad2',
		'icomoon icomoon-icon-wink',
		'icomoon icomoon-icon-wink2',
		'icomoon icomoon-icon-grin',
		'icomoon icomoon-icon-grin2',
		'icomoon icomoon-icon-cool',
		'icomoon icomoon-icon-cool2',
		'icomoon icomoon-icon-angry',
		'icomoon icomoon-icon-angry2',
		'icomoon icomoon-icon-evil',
		'icomoon icomoon-icon-evil2',
		'icomoon icomoon-icon-shocked',
		'icomoon icomoon-icon-shocked2',
		'icomoon icomoon-icon-confused',
		'icomoon icomoon-icon-confused2',
		'icomoon icomoon-icon-neutral',
		'icomoon icomoon-icon-neutral2',
		'icomoon icomoon-icon-wondering',
		'icomoon icomoon-icon-wondering2',
		'icomoon icomoon-icon-point-up',
		'icomoon icomoon-icon-point-right',
		'icomoon icomoon-icon-point-down',
		'icomoon icomoon-icon-point-left',
		'icomoon icomoon-icon-warning',
		'icomoon icomoon-icon-notification',
		'icomoon icomoon-icon-question',
		'icomoon icomoon-icon-info',
		'icomoon icomoon-icon-info2',
		'icomoon icomoon-icon-blocked',
		'icomoon icomoon-icon-cancel-circle',
		'icomoon icomoon-icon-checkmark-circle',
		'icomoon icomoon-icon-spam',
		'icomoon icomoon-icon-close',
		'icomoon icomoon-icon-checkmark',
		'icomoon icomoon-icon-checkmark2',
		'icomoon icomoon-icon-spell-check',
		'icomoon icomoon-icon-minus',
		'icomoon icomoon-icon-plus',
		'icomoon icomoon-icon-enter',
		'icomoon icomoon-icon-exit',
		'icomoon icomoon-icon-play2',
		'icomoon icomoon-icon-pause',
		'icomoon icomoon-icon-stop',
		'icomoon icomoon-icon-backward',
		'icomoon icomoon-icon-forward2',
		'icomoon icomoon-icon-play3',
		'icomoon icomoon-icon-pause2',
		'icomoon icomoon-icon-stop2',
		'icomoon icomoon-icon-backward2',
		'icomoon icomoon-icon-forward3',
		'icomoon icomoon-icon-first',
		'icomoon icomoon-icon-last',
		'icomoon icomoon-icon-previous',
		'icomoon icomoon-icon-next',
		'icomoon icomoon-icon-eject',
		'icomoon icomoon-icon-volume-high',
		'icomoon icomoon-icon-volume-medium',
		'icomoon icomoon-icon-volume-low',
		'icomoon icomoon-icon-volume-mute',
		'icomoon icomoon-icon-volume-mute2',
		'icomoon icomoon-icon-volume-increase',
		'icomoon icomoon-icon-volume-decrease',
		'icomoon icomoon-icon-loop',
		'icomoon icomoon-icon-loop2',
		'icomoon icomoon-icon-loop3',
		'icomoon icomoon-icon-shuffle',
		'icomoon icomoon-icon-arrow-up-left',
		'icomoon icomoon-icon-arrow-up',
		'icomoon icomoon-icon-arrow-up-right',
		'icomoon icomoon-icon-arrow-right',
		'icomoon icomoon-icon-arrow-down-right',
		'icomoon icomoon-icon-arrow-down',
		'icomoon icomoon-icon-arrow-down-left',
		'icomoon icomoon-icon-arrow-left',
		'icomoon icomoon-icon-arrow-up-left2',
		'icomoon icomoon-icon-arrow-up2',
		'icomoon icomoon-icon-arrow-up-right2',
		'icomoon icomoon-icon-arrow-right2',
		'icomoon icomoon-icon-arrow-down-right2',
		'icomoon icomoon-icon-arrow-down2',
		'icomoon icomoon-icon-arrow-down-left2',
		'icomoon icomoon-icon-arrow-left2',
		'icomoon icomoon-icon-arrow-up-left3',
		'icomoon icomoon-icon-arrow-up3',
		'icomoon icomoon-icon-arrow-up-right3',
		'icomoon icomoon-icon-arrow-right3',
		'icomoon icomoon-icon-arrow-down-right3',
		'icomoon icomoon-icon-arrow-down3',
		'icomoon icomoon-icon-arrow-down-left3',
		'icomoon icomoon-icon-arrow-left3',
		'icomoon icomoon-icon-tab',
		'icomoon icomoon-icon-checkbox-checked',
		'icomoon icomoon-icon-checkbox-unchecked',
		'icomoon icomoon-icon-checkbox-partial',
		'icomoon icomoon-icon-radio-checked',
		'icomoon icomoon-icon-radio-unchecked',
		'icomoon icomoon-icon-crop',
		'icomoon icomoon-icon-scissors',
		'icomoon icomoon-icon-filter',
		'icomoon icomoon-icon-filter2',
		'icomoon icomoon-icon-font',
		'icomoon icomoon-icon-text-height',
		'icomoon icomoon-icon-text-width',
		'icomoon icomoon-icon-bold',
		'icomoon icomoon-icon-underline',
		'icomoon icomoon-icon-italic',
		'icomoon icomoon-icon-strikethrough',
		'icomoon icomoon-icon-omega',
		'icomoon icomoon-icon-sigma',
		'icomoon icomoon-icon-table',
		'icomoon icomoon-icon-table2',
		'icomoon icomoon-icon-insert-template',
		'icomoon icomoon-icon-pilcrow',
		'icomoon icomoon-icon-lefttoright',
		'icomoon icomoon-icon-righttoleft',
		'icomoon icomoon-icon-paragraph-left',
		'icomoon icomoon-icon-paragraph-center',
		'icomoon icomoon-icon-paragraph-right',
		'icomoon icomoon-icon-paragraph-justify',
		'icomoon icomoon-icon-paragraph-left2',
		'icomoon icomoon-icon-paragraph-center2',
		'icomoon icomoon-icon-paragraph-right2',
		'icomoon icomoon-icon-paragraph-justify2',
		'icomoon icomoon-icon-indent-increase',
		'icomoon icomoon-icon-indent-decrease',
		'icomoon icomoon-icon-newtab',
		'icomoon icomoon-icon-embed',
		'icomoon icomoon-icon-code',
		'icomoon icomoon-icon-console',
		'icomoon icomoon-icon-share',
		'icomoon icomoon-icon-mail',
		'icomoon icomoon-icon-mail2',
		'icomoon icomoon-icon-mail3',
		'icomoon icomoon-icon-mail4',
		'icomoon icomoon-icon-google',
		'icomoon icomoon-icon-googleplus',
		'icomoon icomoon-icon-googleplus2',
		'icomoon icomoon-icon-googleplus3',
		'icomoon icomoon-icon-googleplus4',
		'icomoon icomoon-icon-google-drive',
		'icomoon icomoon-icon-facebook',
		'icomoon icomoon-icon-facebook2',
		'icomoon icomoon-icon-facebook3',
		'icomoon icomoon-icon-instagram',
		'icomoon icomoon-icon-twitter',
		'icomoon icomoon-icon-twitter2',
		'icomoon icomoon-icon-twitter3',
		'icomoon icomoon-icon-feed2',
		'icomoon icomoon-icon-feed3',
		'icomoon icomoon-icon-feed4',
		'icomoon icomoon-icon-youtube',
		'icomoon icomoon-icon-youtube2',
		'icomoon icomoon-icon-vimeo',
		'icomoon icomoon-icon-vimeo2',
		'icomoon icomoon-icon-vimeo3',
		'icomoon icomoon-icon-lanyrd',
		'icomoon icomoon-icon-flickr',
		'icomoon icomoon-icon-flickr2',
		'icomoon icomoon-icon-flickr3',
		'icomoon icomoon-icon-flickr4',
		'icomoon icomoon-icon-picassa',
		'icomoon icomoon-icon-picassa2',
		'icomoon icomoon-icon-dribbble',
		'icomoon icomoon-icon-dribbble2',
		'icomoon icomoon-icon-dribbble3',
		'icomoon icomoon-icon-forrst',
		'icomoon icomoon-icon-forrst2',
		'icomoon icomoon-icon-deviantart',
		'icomoon icomoon-icon-deviantart2',
		'icomoon icomoon-icon-steam',
		'icomoon icomoon-icon-steam2',
		'icomoon icomoon-icon-github',
		'icomoon icomoon-icon-github2',
		'icomoon icomoon-icon-github3',
		'icomoon icomoon-icon-github4',
		'icomoon icomoon-icon-github5',
		'icomoon icomoon-icon-wordpress',
		'icomoon icomoon-icon-wordpress2',
		'icomoon icomoon-icon-joomla',
		'icomoon icomoon-icon-blogger',
		'icomoon icomoon-icon-blogger2',
		'icomoon icomoon-icon-tumblr',
		'icomoon icomoon-icon-tumblr2',
		'icomoon icomoon-icon-yahoo',
		'icomoon icomoon-icon-tux',
		'icomoon icomoon-icon-apple',
		'icomoon icomoon-icon-finder',
		'icomoon icomoon-icon-android',
		'icomoon icomoon-icon-windows',
		'icomoon icomoon-icon-windows8',
		'icomoon icomoon-icon-soundcloud',
		'icomoon icomoon-icon-soundcloud2',
		'icomoon icomoon-icon-skype',
		'icomoon icomoon-icon-reddit',
		'icomoon icomoon-icon-linkedin',
		'icomoon icomoon-icon-lastfm',
		'icomoon icomoon-icon-lastfm2',
		'icomoon icomoon-icon-delicious',
		'icomoon icomoon-icon-stumbleupon',
		'icomoon icomoon-icon-stumbleupon2',
		'icomoon icomoon-icon-stackoverflow',
		'icomoon icomoon-icon-pinterest',
		'icomoon icomoon-icon-pinterest2',
		'icomoon icomoon-icon-xing',
		'icomoon icomoon-icon-xing2',
		'icomoon icomoon-icon-flattr',
		'icomoon icomoon-icon-foursquare',
		'icomoon icomoon-icon-foursquare2',
		'icomoon icomoon-icon-paypal',
		'icomoon icomoon-icon-paypal2',
		'icomoon icomoon-icon-paypal3',
		'icomoon icomoon-icon-yelp',
		'icomoon icomoon-icon-libreoffice',
		'icomoon icomoon-icon-file-pdf',
		'icomoon icomoon-icon-file-openoffice',
		'icomoon icomoon-icon-file-word',
		'icomoon icomoon-icon-file-excel',
		'icomoon icomoon-icon-file-zip',
		'icomoon icomoon-icon-file-powerpoint',
		'icomoon icomoon-icon-file-xml',
		'icomoon icomoon-icon-file-css',
		'icomoon icomoon-icon-html5',
		'icomoon icomoon-icon-html52',
		'icomoon icomoon-icon-css3',
		'icomoon icomoon-icon-chrome',
		'icomoon icomoon-icon-firefox',
		'icomoon icomoon-icon-IE',
		'icomoon icomoon-icon-opera',
		'icomoon icomoon-icon-safari',
		'icomoon icomoon-icon-IcoMoon',
		'icomoon icomoon-icon-azoom-arrow-down',
		'icomoon icomoon-icon-list3',
		'icomoon icomoon-icon-arrow-left4',
		'icomoon icomoon-icon-arrow-down4',
		'icomoon icomoon-icon-arrow-up4',
		'icomoon icomoon-icon-arrow-right4',
		'icomoon icomoon-icon-arrow-left5',
		'icomoon icomoon-icon-arrow-down5',
		'icomoon icomoon-icon-arrow-up5',
		'icomoon icomoon-icon-arrow-right5',
		'icomoon icomoon-icon-arrow-left6',
		'icomoon icomoon-icon-arrow-down6',
		'icomoon icomoon-icon-arrow-up6',
		'icomoon icomoon-icon-uniE7CF',
		'icomoon icomoon-icon-heart3',
		'icomoon icomoon-icon-cloud2',
		'icomoon icomoon-icon-star4',
		'icomoon icomoon-icon-tv2',
		'icomoon icomoon-icon-sound',
		'icomoon icomoon-icon-video',
		'icomoon icomoon-icon-trash',
		'icomoon icomoon-icon-user5',
		'icomoon icomoon-icon-key3',
		'icomoon icomoon-icon-search2',
		'icomoon icomoon-icon-settings2',
		'icomoon icomoon-icon-camera3',
		'icomoon icomoon-icon-tag2',
		'icomoon icomoon-icon-lock3',
		'icomoon icomoon-icon-bulb',
		'icomoon icomoon-icon-pen2',
		'icomoon icomoon-icon-diamond',
		'icomoon icomoon-icon-display',
		'icomoon icomoon-icon-location3',
		'icomoon icomoon-icon-eye3',
		'icomoon icomoon-icon-bubble3',
		'icomoon icomoon-icon-stack2',
		'icomoon icomoon-icon-cup',
		'icomoon icomoon-icon-phone2',
		'icomoon icomoon-icon-news',
		'icomoon icomoon-icon-mail5',
		'icomoon icomoon-icon-like',
		'icomoon icomoon-icon-photo',
		'icomoon icomoon-icon-note',
		'icomoon icomoon-icon-clock3',
		'icomoon icomoon-icon-paperplane',
		'icomoon icomoon-icon-params',
		'icomoon icomoon-icon-banknote',
		'icomoon icomoon-icon-data',
		'icomoon icomoon-icon-music2',
		'icomoon icomoon-icon-megaphone',
		'icomoon icomoon-icon-study',
		'icomoon icomoon-icon-lab2',
		'icomoon icomoon-icon-food2',
		'icomoon icomoon-icon-t-shirt',
		'icomoon icomoon-icon-fire2',
		'icomoon icomoon-icon-clip',
		'icomoon icomoon-icon-shop',
		'icomoon icomoon-icon-calendar3',
		'icomoon icomoon-icon-wallet',
		'icomoon icomoon-icon-vynil',
		'icomoon icomoon-icon-truck2',
		'icomoon icomoon-icon-world',
		'icomoon icomoon-icon-30',
		'icomoon icomoon-icon-45',
		'icomoon icomoon-icon-601',
		'icomoon icomoon-icon-a1',
		'icomoon icomoon-icon-abacus',
		'icomoon icomoon-icon-academic',
		'icomoon icomoon-icon-adn1',
		'icomoon icomoon-icon-alphabet1',
		'icomoon icomoon-icon-amount',
		'icomoon icomoon-icon-avi1',
		'icomoon icomoon-icon-bag',
		'icomoon icomoon-icon-big52',
		'icomoon icomoon-icon-big55',
		'icomoon icomoon-icon-big56',
		'icomoon icomoon-icon-chemical',
		'icomoon icomoon-icon-chemistry',
		'icomoon icomoon-icon-cinema2',
		'icomoon icomoon-icon-clock4',
		'icomoon icomoon-icon-clock5',
		'icomoon icomoon-icon-competition',
		'icomoon icomoon-icon-computer12',
		'icomoon icomoon-icon-correct2',
		'icomoon icomoon-icon-desktop',
		'icomoon icomoon-icon-dotplot',
		'icomoon icomoon-icon-download4',
		'icomoon icomoon-icon-download8',
		'icomoon icomoon-icon-education',
		'icomoon icomoon-icon-fifteen',
		'icomoon icomoon-icon-file32',
		'icomoon icomoon-icon-flag4',
		'icomoon icomoon-icon-football1',
		'icomoon icomoon-icon-glasses',
		'icomoon icomoon-icon-graph',
		'icomoon icomoon-icon-guitar',
		'icomoon icomoon-icon-hand',
		'icomoon icomoon-icon-insignia',
		'icomoon icomoon-icon-mathematical',
		'icomoon icomoon-icon-meeting',
		'icomoon icomoon-icon-molecules1',
		'icomoon icomoon-icon-online',
		'icomoon icomoon-icon-physical',
		'icomoon icomoon-icon-physics',
		'icomoon icomoon-icon-picture5',
		'icomoon icomoon-icon-pie3',
		'icomoon icomoon-icon-placard',
		'icomoon icomoon-icon-play6',
		'icomoon icomoon-icon-play7',
		'icomoon icomoon-icon-quarter',
		'icomoon icomoon-icon-research',
		'icomoon icomoon-icon-schedule',
		'icomoon icomoon-icon-school1',
		'icomoon icomoon-icon-school4',
		'icomoon icomoon-icon-science1',
		'icomoon icomoon-icon-science2',
		'icomoon icomoon-icon-science',
		'icomoon icomoon-icon-set1',
		'icomoon icomoon-icon-shake',
		'icomoon icomoon-icon-shelf',
		'icomoon icomoon-icon-shopping7',
		'icomoon icomoon-icon-small54',
		'icomoon icomoon-icon-smartphone2',
		'icomoon icomoon-icon-smartphone',
		'icomoon icomoon-icon-tablet2',
		'icomoon icomoon-icon-tactil1',
		'icomoon icomoon-icon-talking',
		'icomoon icomoon-icon-teacher',
		'icomoon icomoon-icon-teach',
		'icomoon icomoon-icon-telescope',
		'icomoon icomoon-icon-time2',
		'icomoon icomoon-icon-university2',
		'icomoon icomoon-icon-university',
		'icomoon icomoon-icon-wall3',
		'icomoon icomoon-icon-window8',
		'icomoon icomoon-icon-working1',
		'icomoon icomoon-icon-2440',
		'icomoon icomoon-icon-air6',
		'icomoon icomoon-icon-airplane68',
		'icomoon icomoon-icon-black331',
		'icomoon icomoon-icon-call36',
		'icomoon icomoon-icon-call37',
		'icomoon icomoon-icon-clipboard52',
		'icomoon icomoon-icon-delivery21',
		'icomoon icomoon-icon-delivery23',
		'icomoon icomoon-icon-delivery25',
		'icomoon icomoon-icon-delivery26',
		'icomoon icomoon-icon-delivery29',
		'icomoon icomoon-icon-delivery30',
		'icomoon icomoon-icon-delivery39',
		'icomoon icomoon-icon-international11',
		'icomoon icomoon-icon-international12',
		'icomoon icomoon-icon-international14',
		'icomoon icomoon-icon-logistics2',
		'icomoon icomoon-icon-logistics3',
		'icomoon icomoon-icon-logistics4',
		'icomoon icomoon-icon-ocean3',
		'icomoon icomoon-icon-package13',
		'icomoon icomoon-icon-phone322',
		'icomoon icomoon-icon-placeholder8',
		'icomoon icomoon-icon-triangular42',
		'icomoon icomoon-icon-verification5',
		'icomoon icomoon-icon-woman93',
		'icomoon icomoon-icon-shopping109',
		'icomoon icomoon-icon-shopping110',
		'icomoon icomoon-icon-shopping111',
		'icomoon icomoon-icon-shopping113',
		'icomoon icomoon-icon-shopping114',
		'icomoon icomoon-icon-finger2',
		'icomoon icomoon-icon-finger5',
		'icomoon icomoon-icon-finger',
		'icomoon icomoon-icon-hand8',
		'icomoon icomoon-icon-mobiletuxedo2',
		'icomoon icomoon-icon-ring2',
		'icomoon icomoon-icon-two33',
		'icomoon icomoon-icon-collapse3',
		'icomoon icomoon-icon-down44',
		'icomoon icomoon-icon-down45',
		'icomoon icomoon-icon-expand22',
		'icomoon icomoon-icon-left126',
		'icomoon icomoon-icon-left127',
		'icomoon icomoon-icon-left128',
		'icomoon icomoon-icon-left129',
		'icomoon icomoon-icon-next15',
		'icomoon icomoon-icon-previous11',
		'icomoon icomoon-icon-right103',
		'icomoon icomoon-icon-right104',
		'icomoon icomoon-icon-right105',
		'icomoon icomoon-icon-right106',
		'icomoon icomoon-icon-right107',
		'icomoon icomoon-icon-thin35',
		'icomoon icomoon-icon-thin36',
		'icomoon icomoon-icon-up76',
		'icomoon icomoon-icon-up77',
		'icomoon icomoon-icon-up78',
		'icomoon icomoon-icon-fa-credit-card',
		'icomoon icomoon-icon-fa-money',
		'icomoon icomoon-icon-uniF1B4',
		'icomoon icomoon-icon-uniF1B5',
		'icomoon icomoon-icon-fa-paypal',
		'icomoon icomoon-icon-fa-google-wallet',
		'icomoon icomoon-icon-fa-cc-visa',
		'icomoon icomoon-icon-fa-cc-mastercard',
		'icomoon icomoon-icon-fa-cc-discover',
		'icomoon icomoon-icon-fa-cc-amex',
		'icomoon icomoon-icon-fa-cc-paypal',
		'icomoon icomoon-icon-fa-cc-stripe',
	);
	
	$rockthemes_icon_list = array_merge($rockthemes_icon_list, $icomoon_list);
	
	if(xr_get_option('enable_fontawesome', false)){
		$fontawesome_list = array(
			'fa fa-glass',
			'fa fa-music',
			'fa fa-search',
			'fa fa-envelope-o',
			'fa fa-heart',
			'fa fa-star',
			'fa fa-star-o',
			'fa fa-user',
			'fa fa-film',
			'fa fa-th-large',
			'fa fa-th',
			'fa fa-th-list',
			'fa fa-check',
			'fa fa-remove',
			'fa fa-close',
			'fa fa-times',
			'fa fa-search-plus',
			'fa fa-search-minus',
			'fa fa-power-off',
			'fa fa-signal',
			'fa fa-gear',
			'fa fa-cog',
			'fa fa-trash-o',
			'fa fa-home',
			'fa fa-file-o',
			'fa fa-clock-o',
			'fa fa-road',
			'fa fa-download',
			'fa fa-arrow-circle-o-down',
			'fa fa-arrow-circle-o-up',
			'fa fa-inbox',
			'fa fa-play-circle-o',
			'fa fa-rotate-right',
			'fa fa-repeat',
			'fa fa-refresh',
			'fa fa-list-alt',
			'fa fa-lock',
			'fa fa-flag',
			'fa fa-headphones',
			'fa fa-volume-off',
			'fa fa-volume-down',
			'fa fa-volume-up',
			'fa fa-qrcode',
			'fa fa-barcode',
			'fa fa-tag',
			'fa fa-tags',
			'fa fa-book',
			'fa fa-bookmark',
			'fa fa-print',
			'fa fa-camera',
			'fa fa-font',
			'fa fa-bold',
			'fa fa-italic',
			'fa fa-text-height',
			'fa fa-text-width',
			'fa fa-align-left',
			'fa fa-align-center',
			'fa fa-align-right',
			'fa fa-align-justify',
			'fa fa-list',
			'fa fa-dedent',
			'fa fa-outdent',
			'fa fa-indent',
			'fa fa-video-camera',
			'fa fa-photo',
			'fa fa-image',
			'fa fa-picture-o',
			'fa fa-pencil',
			'fa fa-map-marker',
			'fa fa-adjust',
			'fa fa-tint',
			'fa fa-edit',
			'fa fa-pencil-square-o',
			'fa fa-share-square-o',
			'fa fa-check-square-o',
			'fa fa-arrows',
			'fa fa-step-backward',
			'fa fa-fast-backward',
			'fa fa-backward',
			'fa fa-play',
			'fa fa-pause',
			'fa fa-stop',
			'fa fa-forward',
			'fa fa-fast-forward',
			'fa fa-step-forward',
			'fa fa-eject',
			'fa fa-chevron-left',
			'fa fa-chevron-right',
			'fa fa-plus-circle',
			'fa fa-minus-circle',
			'fa fa-times-circle',
			'fa fa-check-circle',
			'fa fa-question-circle',
			'fa fa-info-circle',
			'fa fa-crosshairs',
			'fa fa-times-circle-o',
			'fa fa-check-circle-o',
			'fa fa-ban',
			'fa fa-arrow-left',
			'fa fa-arrow-right',
			'fa fa-arrow-up',
			'fa fa-arrow-down',
			'fa fa-mail-forward',
			'fa fa-share',
			'fa fa-expand',
			'fa fa-compress',
			'fa fa-plus',
			'fa fa-minus',
			'fa fa-asterisk',
			'fa fa-exclamation-circle',
			'fa fa-gift',
			'fa fa-leaf',
			'fa fa-fire',
			'fa fa-eye',
			'fa fa-eye-slash',
			'fa fa-warning',
			'fa fa-exclamation-triangle',
			'fa fa-plane',
			'fa fa-calendar',
			'fa fa-random',
			'fa fa-comment',
			'fa fa-magnet',
			'fa fa-chevron-up',
			'fa fa-chevron-down',
			'fa fa-retweet',
			'fa fa-shopping-cart',
			'fa fa-folder',
			'fa fa-folder-open',
			'fa fa-arrows-v',
			'fa fa-arrows-h',
			'fa fa-bar-chart-o',
			'fa fa-bar-chart',
			'fa fa-twitter-square',
			'fa fa-facebook-square',
			'fa fa-camera-retro',
			'fa fa-key',
			'fa fa-gears',
			'fa fa-cogs',
			'fa fa-comments',
			'fa fa-thumbs-o-up',
			'fa fa-thumbs-o-down',
			'fa fa-star-half',
			'fa fa-heart-o',
			'fa fa-sign-out',
			'fa fa-linkedin-square',
			'fa fa-thumb-tack',
			'fa fa-external-link',
			'fa fa-sign-in',
			'fa fa-trophy',
			'fa fa-github-square',
			'fa fa-upload',
			'fa fa-lemon-o',
			'fa fa-phone',
			'fa fa-square-o',
			'fa fa-bookmark-o',
			'fa fa-phone-square',
			'fa fa-twitter',
			'fa fa-facebook-f',
			'fa fa-facebook',
			'fa fa-github',
			'fa fa-unlock',
			'fa fa-credit-card',
			'fa fa-rss',
			'fa fa-hdd-o',
			'fa fa-bullhorn',
			'fa fa-bell',
			'fa fa-certificate',
			'fa fa-hand-o-right',
			'fa fa-hand-o-left',
			'fa fa-hand-o-up',
			'fa fa-hand-o-down',
			'fa fa-arrow-circle-left',
			'fa fa-arrow-circle-right',
			'fa fa-arrow-circle-up',
			'fa fa-arrow-circle-down',
			'fa fa-globe',
			'fa fa-wrench',
			'fa fa-tasks',
			'fa fa-filter',
			'fa fa-briefcase',
			'fa fa-arrows-alt',
			'fa fa-group',
			'fa fa-users',
			'fa fa-chain',
			'fa fa-link',
			'fa fa-cloud',
			'fa fa-flask',
			'fa fa-cut',
			'fa fa-scissors',
			'fa fa-copy',
			'fa fa-files-o',
			'fa fa-paperclip',
			'fa fa-save',
			'fa fa-floppy-o',
			'fa fa-square',
			'fa fa-navicon',
			'fa fa-reorder',
			'fa fa-bars',
			'fa fa-list-ul',
			'fa fa-list-ol',
			'fa fa-strikethrough',
			'fa fa-underline',
			'fa fa-table',
			'fa fa-magic',
			'fa fa-truck',
			'fa fa-pinterest',
			'fa fa-pinterest-square',
			'fa fa-google-plus-square',
			'fa fa-google-plus',
			'fa fa-money',
			'fa fa-caret-down',
			'fa fa-caret-up',
			'fa fa-caret-left',
			'fa fa-caret-right',
			'fa fa-columns',
			'fa fa-unsorted',
			'fa fa-sort',
			'fa fa-sort-down',
			'fa fa-sort-desc',
			'fa fa-sort-up',
			'fa fa-sort-asc',
			'fa fa-envelope',
			'fa fa-linkedin',
			'fa fa-rotate-left',
			'fa fa-undo',
			'fa fa-legal',
			'fa fa-gavel',
			'fa fa-dashboard',
			'fa fa-tachometer',
			'fa fa-comment-o',
			'fa fa-comments-o',
			'fa fa-flash',
			'fa fa-bolt',
			'fa fa-sitemap',
			'fa fa-umbrella',
			'fa fa-paste',
			'fa fa-clipboard',
			'fa fa-lightbulb-o',
			'fa fa-exchange',
			'fa fa-cloud-download',
			'fa fa-cloud-upload',
			'fa fa-user-md',
			'fa fa-stethoscope',
			'fa fa-suitcase',
			'fa fa-bell-o',
			'fa fa-coffee',
			'fa fa-cutlery',
			'fa fa-file-text-o',
			'fa fa-building-o',
			'fa fa-hospital-o',
			'fa fa-ambulance',
			'fa fa-medkit',
			'fa fa-fighter-jet',
			'fa fa-beer',
			'fa fa-h-square',
			'fa fa-plus-square',
			'fa fa-angle-double-left',
			'fa fa-angle-double-right',
			'fa fa-angle-double-up',
			'fa fa-angle-double-down',
			'fa fa-angle-left',
			'fa fa-angle-right',
			'fa fa-angle-up',
			'fa fa-angle-down',
			'fa fa-desktop',
			'fa fa-laptop',
			'fa fa-tablet',
			'fa fa-mobile-phone',
			'fa fa-mobile',
			'fa fa-circle-o',
			'fa fa-quote-left',
			'fa fa-quote-right',
			'fa fa-spinner',
			'fa fa-circle',
			'fa fa-mail-reply',
			'fa fa-reply',
			'fa fa-github-alt',
			'fa fa-folder-o',
			'fa fa-folder-open-o',
			'fa fa-smile-o',
			'fa fa-frown-o',
			'fa fa-meh-o',
			'fa fa-gamepad',
			'fa fa-keyboard-o',
			'fa fa-flag-o',
			'fa fa-flag-checkered',
			'fa fa-terminal',
			'fa fa-code',
			'fa fa-mail-reply-all',
			'fa fa-reply-all',
			'fa fa-star-half-empty',
			'fa fa-star-half-full',
			'fa fa-star-half-o',
			'fa fa-location-arrow',
			'fa fa-crop',
			'fa fa-code-fork',
			'fa fa-unlink',
			'fa fa-chain-broken',
			'fa fa-question',
			'fa fa-info',
			'fa fa-exclamation',
			'fa fa-superscript',
			'fa fa-subscript',
			'fa fa-eraser',
			'fa fa-puzzle-piece',
			'fa fa-microphone',
			'fa fa-microphone-slash',
			'fa fa-shield',
			'fa fa-calendar-o',
			'fa fa-fire-extinguisher',
			'fa fa-rocket',
			'fa fa-maxcdn',
			'fa fa-chevron-circle-left',
			'fa fa-chevron-circle-right',
			'fa fa-chevron-circle-up',
			'fa fa-chevron-circle-down',
			'fa fa-html5',
			'fa fa-css3',
			'fa fa-anchor',
			'fa fa-unlock-alt',
			'fa fa-bullseye',
			'fa fa-ellipsis-h',
			'fa fa-ellipsis-v',
			'fa fa-rss-square',
			'fa fa-play-circle',
			'fa fa-ticket',
			'fa fa-minus-square',
			'fa fa-minus-square-o',
			'fa fa-level-up',
			'fa fa-level-down',
			'fa fa-check-square',
			'fa fa-pencil-square',
			'fa fa-external-link-square',
			'fa fa-share-square',
			'fa fa-compass',
			'fa fa-toggle-down',
			'fa fa-caret-square-o-down',
			'fa fa-toggle-up',
			'fa fa-caret-square-o-up',
			'fa fa-toggle-right',
			'fa fa-caret-square-o-right',
			'fa fa-euro',
			'fa fa-eur',
			'fa fa-gbp',
			'fa fa-dollar',
			'fa fa-usd',
			'fa fa-rupee',
			'fa fa-inr',
			'fa fa-cny',
			'fa fa-rmb',
			'fa fa-yen',
			'fa fa-jpy',
			'fa fa-ruble',
			'fa fa-rouble',
			'fa fa-rub',
			'fa fa-won',
			'fa fa-krw',
			'fa fa-bitcoin',
			'fa fa-btc',
			'fa fa-file',
			'fa fa-file-text',
			'fa fa-sort-alpha-asc',
			'fa fa-sort-alpha-desc',
			'fa fa-sort-amount-asc',
			'fa fa-sort-amount-desc',
			'fa fa-sort-numeric-asc',
			'fa fa-sort-numeric-desc',
			'fa fa-thumbs-up',
			'fa fa-thumbs-down',
			'fa fa-youtube-square',
			'fa fa-youtube',
			'fa fa-xing',
			'fa fa-xing-square',
			'fa fa-youtube-play',
			'fa fa-dropbox',
			'fa fa-stack-overflow',
			'fa fa-instagram',
			'fa fa-flickr',
			'fa fa-adn',
			'fa fa-bitbucket',
			'fa fa-bitbucket-square',
			'fa fa-tumblr',
			'fa fa-tumblr-square',
			'fa fa-long-arrow-down',
			'fa fa-long-arrow-up',
			'fa fa-long-arrow-left',
			'fa fa-long-arrow-right',
			'fa fa-apple',
			'fa fa-windows',
			'fa fa-android',
			'fa fa-linux',
			'fa fa-dribbble',
			'fa fa-skype',
			'fa fa-foursquare',
			'fa fa-trello',
			'fa fa-female',
			'fa fa-male',
			'fa fa-gittip',
			'fa fa-gratipay',
			'fa fa-sun-o',
			'fa fa-moon-o',
			'fa fa-archive',
			'fa fa-bug',
			'fa fa-vk',
			'fa fa-weibo',
			'fa fa-renren',
			'fa fa-pagelines',
			'fa fa-stack-exchange',
			'fa fa-arrow-circle-o-right',
			'fa fa-arrow-circle-o-left',
			'fa fa-toggle-left',
			'fa fa-caret-square-o-left',
			'fa fa-dot-circle-o',
			'fa fa-wheelchair',
			'fa fa-vimeo-square',
			'fa fa-turkish-lira',
			'fa fa-try',
			'fa fa-plus-square-o',
			'fa fa-space-shuttle',
			'fa fa-slack',
			'fa fa-envelope-square',
			'fa fa-wordpress',
			'fa fa-openid',
			'fa fa-institution',
			'fa fa-bank',
			'fa fa-university',
			'fa fa-mortar-board',
			'fa fa-graduation-cap',
			'fa fa-yahoo',
			'fa fa-google',
			'fa fa-reddit',
			'fa fa-reddit-square',
			'fa fa-stumbleupon-circle',
			'fa fa-stumbleupon',
			'fa fa-delicious',
			'fa fa-digg',
			'fa fa-pied-piper',
			'fa fa-pied-piper-alt',
			'fa fa-drupal',
			'fa fa-joomla',
			'fa fa-language',
			'fa fa-fax',
			'fa fa-building',
			'fa fa-child',
			'fa fa-paw',
			'fa fa-spoon',
			'fa fa-cube',
			'fa fa-cubes',
			'fa fa-behance',
			'fa fa-behance-square',
			'fa fa-steam',
			'fa fa-steam-square',
			'fa fa-recycle',
			'fa fa-automobile',
			'fa fa-car',
			'fa fa-cab',
			'fa fa-taxi',
			'fa fa-tree',
			'fa fa-spotify',
			'fa fa-deviantart',
			'fa fa-soundcloud',
			'fa fa-database',
			'fa fa-file-pdf-o',
			'fa fa-file-word-o',
			'fa fa-file-excel-o',
			'fa fa-file-powerpoint-o',
			'fa fa-file-photo-o',
			'fa fa-file-picture-o',
			'fa fa-file-image-o',
			'fa fa-file-zip-o',
			'fa fa-file-archive-o',
			'fa fa-file-sound-o',
			'fa fa-file-audio-o',
			'fa fa-file-movie-o',
			'fa fa-file-video-o',
			'fa fa-file-code-o',
			'fa fa-vine',
			'fa fa-codepen',
			'fa fa-jsfiddle',
			'fa fa-life-bouy',
			'fa fa-life-buoy',
			'fa fa-life-saver',
			'fa fa-support',
			'fa fa-life-ring',
			'fa fa-circle-o-notch',
			'fa fa-ra',
			'fa fa-rebel',
			'fa fa-ge',
			'fa fa-empire',
			'fa fa-git-square',
			'fa fa-git',
			'fa fa-hacker-news',
			'fa fa-tencent-weibo',
			'fa fa-qq',
			'fa fa-wechat',
			'fa fa-weixin',
			'fa fa-send',
			'fa fa-paper-plane',
			'fa fa-send-o',
			'fa fa-paper-plane-o',
			'fa fa-history',
			'fa fa-genderless',
			'fa fa-circle-thin',
			'fa fa-header',
			'fa fa-paragraph',
			'fa fa-sliders',
			'fa fa-share-alt',
			'fa fa-share-alt-square',
			'fa fa-bomb',
			'fa fa-soccer-ball-o',
			'fa fa-futbol-o',
			'fa fa-tty',
			'fa fa-binoculars',
			'fa fa-plug',
			'fa fa-slideshare',
			'fa fa-twitch',
			'fa fa-yelp',
			'fa fa-newspaper-o',
			'fa fa-wifi',
			'fa fa-calculator',
			'fa fa-paypal',
			'fa fa-google-wallet',
			'fa fa-cc-visa',
			'fa fa-cc-mastercard',
			'fa fa-cc-discover',
			'fa fa-cc-amex',
			'fa fa-cc-paypal',
			'fa fa-cc-stripe',
			'fa fa-bell-slash',
			'fa fa-bell-slash-o',
			'fa fa-trash',
			'fa fa-copyright',
			'fa fa-at',
			'fa fa-eyedropper',
			'fa fa-paint-brush',
			'fa fa-birthday-cake',
			'fa fa-area-chart',
			'fa fa-pie-chart',
			'fa fa-line-chart',
			'fa fa-lastfm',
			'fa fa-lastfm-square',
			'fa fa-toggle-off',
			'fa fa-toggle-on',
			'fa fa-bicycle',
			'fa fa-bus',
			'fa fa-ioxhost',
			'fa fa-angellist',
			'fa fa-cc',
			'fa fa-shekel',
			'fa fa-sheqel',
			'fa fa-ils',
			'fa fa-meanpath',
			'fa fa-buysellads',
			'fa fa-connectdevelop',
			'fa fa-dashcube',
			'fa fa-forumbee',
			'fa fa-leanpub',
			'fa fa-sellsy',
			'fa fa-shirtsinbulk',
			'fa fa-simplybuilt',
			'fa fa-skyatlas',
			'fa fa-cart-plus',
			'fa fa-cart-arrow-down',
			'fa fa-diamond',
			'fa fa-ship',
			'fa fa-user-secret',
			'fa fa-motorcycle',
			'fa fa-street-view',
			'fa fa-heartbeat',
			'fa fa-venus',
			'fa fa-mars',
			'fa fa-mercury',
			'fa fa-transgender',
			'fa fa-transgender-alt',
			'fa fa-venus-double',
			'fa fa-mars-double',
			'fa fa-venus-mars',
			'fa fa-mars-stroke',
			'fa fa-mars-stroke-v',
			'fa fa-mars-stroke-h',
			'fa fa-neuter',
			'fa fa-facebook-official',
			'fa fa-pinterest-p',
			'fa fa-whatsapp',
			'fa fa-server',
			'fa fa-user-plus',
			'fa fa-user-times',
			'fa fa-hotel',
			'fa fa-bed',
			'fa fa-viacoin',
			'fa fa-train',
			'fa fa-subway',
			'fa fa-medium',
		);
		$rockthemes_icon_list = array_merge($rockthemes_icon_list, $fontawesome_list);
	}
	
	if(xr_get_option('enable_pestroke7', false)){
		$pestroke7_list = array(
			'pe-7s pe-7s-album',
			'pe-7s pe-7s-arc',
			'pe-7s pe-7s-back-2',
			'pe-7s pe-7s-bandaid',
			'pe-7s pe-7s-car',
			'pe-7s pe-7s-diamond',
			'pe-7s pe-7s-door-lock',
			'pe-7s pe-7s-eyedropper',
			'pe-7s pe-7s-female',
			'pe-7s pe-7s-gym',
			'pe-7s pe-7s-hammer',
			'pe-7s pe-7s-headphones',
			'pe-7s pe-7s-helm',
			'pe-7s pe-7s-hourglass',
			'pe-7s pe-7s-leaf',
			'pe-7s pe-7s-magic-wand',
			'pe-7s pe-7s-male',
			'pe-7s pe-7s-map-2',
			'pe-7s pe-7s-next-2',
			'pe-7s pe-7s-paint-bucket',
			'pe-7s pe-7s-pendrive',
			'pe-7s pe-7s-photo',
			'pe-7s pe-7s-piggy',
			'pe-7s pe-7s-plugin',
			'pe-7s pe-7s-refresh-2',
			'pe-7s pe-7s-rocket',
			'pe-7s pe-7s-settings',
			'pe-7s pe-7s-shield',
			'pe-7s pe-7s-smile',
			'pe-7s pe-7s-usb',
			'pe-7s pe-7s-vector',
			'pe-7s pe-7s-wine',
			'pe-7s pe-7s-cloud-upload',
			'pe-7s pe-7s-cash',
			'pe-7s pe-7s-close',
			'pe-7s pe-7s-bluetooth',
			'pe-7s pe-7s-cloud-download',
			'pe-7s pe-7s-way',
			'pe-7s pe-7s-close-circle',
			'pe-7s pe-7s-id',
			'pe-7s pe-7s-angle-up',
			'pe-7s pe-7s-wristwatch',
			'pe-7s pe-7s-angle-up-circle',
			'pe-7s pe-7s-world',
			'pe-7s pe-7s-angle-right',
			'pe-7s pe-7s-volume',
			'pe-7s pe-7s-angle-right-circle',
			'pe-7s pe-7s-users',
			'pe-7s pe-7s-angle-left',
			'pe-7s pe-7s-user-female',
			'pe-7s pe-7s-angle-left-circle',
			'pe-7s pe-7s-up-arrow',
			'pe-7s pe-7s-angle-down',
			'pe-7s pe-7s-switch',
			'pe-7s pe-7s-angle-down-circle',
			'pe-7s pe-7s-scissors',
			'pe-7s pe-7s-wallet',
			'pe-7s pe-7s-safe',
			'pe-7s pe-7s-volume2',
			'pe-7s pe-7s-volume1',
			'pe-7s pe-7s-voicemail',
			'pe-7s pe-7s-video',
			'pe-7s pe-7s-user',
			'pe-7s pe-7s-upload',
			'pe-7s pe-7s-unlock',
			'pe-7s pe-7s-umbrella',
			'pe-7s pe-7s-trash',
			'pe-7s pe-7s-tools',
			'pe-7s pe-7s-timer',
			'pe-7s pe-7s-ticket',
			'pe-7s pe-7s-target',
			'pe-7s pe-7s-sun',
			'pe-7s pe-7s-study',
			'pe-7s pe-7s-stopwatch',
			'pe-7s pe-7s-star',
			'pe-7s pe-7s-speaker',
			'pe-7s pe-7s-signal',
			'pe-7s pe-7s-shuffle',
			'pe-7s pe-7s-shopbag',
			'pe-7s pe-7s-share',
			'pe-7s pe-7s-server',
			'pe-7s pe-7s-search',
			'pe-7s pe-7s-film',
			'pe-7s pe-7s-science',
			'pe-7s pe-7s-disk',
			'pe-7s pe-7s-ribbon',
			'pe-7s pe-7s-repeat',
			'pe-7s pe-7s-refresh',
			'pe-7s pe-7s-add-user',
			'pe-7s pe-7s-refresh-cloud',
			'pe-7s pe-7s-paperclip',
			'pe-7s pe-7s-radio',
			'pe-7s pe-7s-note2',
			'pe-7s pe-7s-print',
			'pe-7s pe-7s-network',
			'pe-7s pe-7s-prev',
			'pe-7s pe-7s-mute',
			'pe-7s pe-7s-power',
			'pe-7s pe-7s-medal',
			'pe-7s pe-7s-portfolio',
			'pe-7s pe-7s-like2',
			'pe-7s pe-7s-plus',
			'pe-7s pe-7s-left-arrow',
			'pe-7s pe-7s-play',
			'pe-7s pe-7s-key',
			'pe-7s pe-7s-plane',
			'pe-7s pe-7s-joy',
			'pe-7s pe-7s-photo-gallery',
			'pe-7s pe-7s-pin',
			'pe-7s pe-7s-phone',
			'pe-7s pe-7s-plug',
			'pe-7s pe-7s-pen',
			'pe-7s pe-7s-right-arrow',
			'pe-7s pe-7s-paper-plane',
			'pe-7s pe-7s-delete-user',
			'pe-7s pe-7s-paint',
			'pe-7s pe-7s-bottom-arrow',
			'pe-7s pe-7s-notebook',
			'pe-7s pe-7s-note',
			'pe-7s pe-7s-next',
			'pe-7s pe-7s-news-paper',
			'pe-7s pe-7s-musiclist',
			'pe-7s pe-7s-music',
			'pe-7s pe-7s-mouse',
			'pe-7s pe-7s-more',
			'pe-7s pe-7s-moon',
			'pe-7s pe-7s-monitor',
			'pe-7s pe-7s-micro',
			'pe-7s pe-7s-menu',
			'pe-7s pe-7s-map',
			'pe-7s pe-7s-map-marker',
			'pe-7s pe-7s-mail',
			'pe-7s pe-7s-mail-open',
			'pe-7s pe-7s-mail-open-file',
			'pe-7s pe-7s-magnet',
			'pe-7s pe-7s-loop',
			'pe-7s pe-7s-look',
			'pe-7s pe-7s-lock',
			'pe-7s pe-7s-lintern',
			'pe-7s pe-7s-link',
			'pe-7s pe-7s-like',
			'pe-7s pe-7s-light',
			'pe-7s pe-7s-less',
			'pe-7s pe-7s-keypad',
			'pe-7s pe-7s-junk',
			'pe-7s pe-7s-info',
			'pe-7s pe-7s-home',
			'pe-7s pe-7s-help2',
			'pe-7s pe-7s-help1',
			'pe-7s pe-7s-graph3',
			'pe-7s pe-7s-graph2',
			'pe-7s pe-7s-graph1',
			'pe-7s pe-7s-graph',
			'pe-7s pe-7s-global',
			'pe-7s pe-7s-gleam',
			'pe-7s pe-7s-glasses',
			'pe-7s pe-7s-gift',
			'pe-7s pe-7s-folder',
			'pe-7s pe-7s-flag',
			'pe-7s pe-7s-filter',
			'pe-7s pe-7s-file',
			'pe-7s pe-7s-expand1',
			'pe-7s pe-7s-exapnd2',
			'pe-7s pe-7s-edit',
			'pe-7s pe-7s-drop',
			'pe-7s pe-7s-drawer',
			'pe-7s pe-7s-download',
			'pe-7s pe-7s-display2',
			'pe-7s pe-7s-display1',
			'pe-7s pe-7s-diskette',
			'pe-7s pe-7s-date',
			'pe-7s pe-7s-cup',
			'pe-7s pe-7s-culture',
			'pe-7s pe-7s-crop',
			'pe-7s pe-7s-credit',
			'pe-7s pe-7s-copy-file',
			'pe-7s pe-7s-config',
			'pe-7s pe-7s-compass',
			'pe-7s pe-7s-comment',
			'pe-7s pe-7s-coffee',
			'pe-7s pe-7s-cloud',
			'pe-7s pe-7s-clock',
			'pe-7s pe-7s-check',
			'pe-7s pe-7s-chat',
			'pe-7s pe-7s-cart',
			'pe-7s pe-7s-camera',
			'pe-7s pe-7s-call',
			'pe-7s pe-7s-calculator',
			'pe-7s pe-7s-browser',
			'pe-7s pe-7s-box2',
			'pe-7s pe-7s-box1',
			'pe-7s pe-7s-bookmarks',
			'pe-7s pe-7s-bicycle',
			'pe-7s pe-7s-bell',
			'pe-7s pe-7s-battery',
			'pe-7s pe-7s-ball',
			'pe-7s pe-7s-back',
			'pe-7s pe-7s-attention',
			'pe-7s pe-7s-anchor',
			'pe-7s pe-7s-albums',
			'pe-7s pe-7s-alarm',
			'pe-7s pe-7s-airplay',
		);
		$rockthemes_icon_list = array_merge($rockthemes_icon_list, $pestroke7_list);
	}
	
	$rockthemes_icon_list = apply_filters('rockthemes_icon_list', $rockthemes_icon_list);

	return $rockthemes_icon_list;
}
endif;
















?>