<?php

//Return if accessing directly
if(!defined('ABSPATH')) exit;

//Return if not admin
if ( !(defined( 'WP_ADMIN' ) && WP_ADMIN ) &&  !( defined( 'DOING_AJAX' ) && DOING_AJAX )) return;


/*
**	Rock Page Builder new system functions
**
**	@since	:	2.0
*/






/*
**	Validation of the datas sent from Javascript. This function will parse all datas
**	into their content and validate them one by one. 
**
**	@param	:	$data : Data sent by javascript / Could be decoded, encoded, slashed
**
**	@return	:	Array : Validated data for the save
**
**	@since	:	1.5
*/
function rpb_admin_save_validate_data($data=array()){
	global $allowedposttags;
	
	if(empty($data)) return false;
		
	//Turn the data into the array, so we can use it
	$data = rpb_admin_main_save_data_to_array($data);
	
	if($data === '') return '';
	
	//Check if that data was valid and not false
	if(false === $data || !is_array($data)) return false;
	
	//Extend allowed post tags with iframe tag
	$allowedposttags['iframe'] = array('src'=> true,'scrolling'=>true,'height'=>true,'width'=>true);
	$allowedposttags['a']['data-rel'] = true;

	
	for($i=0; $i<count($data); $i++){
		
		if(isset($data[$i]['special_grid_block']) && $data[$i]['special_grid_block'] === 'yes'){
			//Special grid starter. 
			if(isset($data[$i]['special_grid_block_open']) && $data[$i]['special_grid_block_open'] === 'yes'){
				$data[$i]['grid_data']['data']['data']['avoidSidebar'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['avoidSidebar']);
				$data[$i]['grid_data']['data']['data']['grid_special_width_details'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['grid_special_width_details']);
				$data[$i]['grid_data']['data']['data']['background_color'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['background_color']);
				$data[$i]['grid_data']['data']['data']['bgcolor_fullscreen'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['bgcolor_fullscreen']);
				$data[$i]['grid_data']['data']['data']['use_shadow'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['use_shadow']);
				$data[$i]['grid_data']['data']['data']['use_border_bottom'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['use_border_bottom']);
				$data[$i]['grid_data']['data']['data']['activate_padding'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['activate_padding']);
				$data[$i]['grid_data']['data']['data']['transparent_background'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['transparent_background']);
				$data[$i]['grid_data']['data']['data']['add_down_arrow'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['add_down_arrow']);
				$data[$i]['grid_data']['data']['data']['down_arrow_color'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['down_arrow_color']);
				$data[$i]['grid_data']['data']['data']['special_grid_html_id'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['special_grid_html_id']);
				$data[$i]['grid_data']['data']['data']['special_grid_html_title'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['special_grid_html_title']);
				
				//Video Details
				$data[$i]['grid_data']['data']['data']['video_bg_url'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_url']);
				$data[$i]['grid_data']['data']['data']['video_bg_color'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_color']);
				$data[$i]['grid_data']['data']['data']['video_bg_color_opacity'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_color_opacity']);
				$data[$i]['grid_data']['data']['data']['video_bg_fullscreen'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_fullscreen']);
				$data[$i]['grid_data']['data']['data']['video_bg_youtube_url'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_youtube_url']);
				$data[$i]['grid_data']['data']['data']['video_bg_vimeo_url'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_vimeo_url']);
				$data[$i]['grid_data']['data']['data']['video_bg_ratio'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_ratio']);
				$data[$i]['grid_data']['data']['data']['video_bg_mute'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_mute']);
				$data[$i]['grid_data']['data']['data']['video_bg_fallback_url'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['video_bg_fallback_url']);
				
				//Parallax Details
				$data[$i]['grid_data']['data']['data']['parallax_model'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['parallax_model']);
				$data[$i]['grid_data']['data']['data']['parallax_mask_height'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['parallax_mask_height']);
				$data[$i]['grid_data']['data']['data']['parallax_size'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['parallax_size']);
				$data[$i]['grid_data']['data']['data']['parallax_bg_image'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['parallax_bg_image']);
				$data[$i]['grid_data']['data']['data']['parallax_bg_image_id'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['parallax_bg_image_id']);
				$data[$i]['grid_data']['data']['data']['image_full_screen'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['image_full_screen']);
				$data[$i]['grid_data']['data']['data']['image_bg_color'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['image_bg_color']);
				$data[$i]['grid_data']['data']['data']['image_bg_color_opacity'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['image_bg_color_opacity']);
				$data[$i]['grid_data']['data']['data']['image_tile'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['image_tile']);
				$data[$i]['grid_data']['data']['data']['image_sizes'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['image_sizes']);
				
				//Full width 
				$data[$i]['grid_data']['data']['data']['full_bg_color'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['full_bg_color']);
				$data[$i]['grid_data']['data']['data']['fullbg_enable_color'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['fullbg_enable_color']);
				$data[$i]['grid_data']['data']['data']['enable_double_bg_colors'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['enable_double_bg_colors']);
				$data[$i]['grid_data']['data']['data']['double_bg_color'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['double_bg_color']);
				$data[$i]['grid_data']['data']['data']['use_light_font_colors'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['use_light_font_colors']);
			}
			
			//Special grids does not have any elements init, so the elems "$data[$i]['elems']" not set
			continue;	
		}
		
		//Regular Grid
		if(isset($data[$i]['special_grid_block']) && $data[$i]['special_grid_block'] === 'no'){
			$data[$i]['grid_data']['data']['data']['animation_type'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['animation_type']);
			$data[$i]['grid_data']['data']['data']['animation_delay_time'] = sanitize_text_field($data[$i]['grid_data']['data']['data']['animation_delay_time']);
		}
		
		//Grids
		for($j=0; $j<count($data[$i]['elems']); $j++){
			
			//Elements
			switch($data[$i]['elems'][$j]['descType']){
				
				case 'textarea':
				$data[$i]['elems'][$j]['desc'] = wp_kses($data[$i]['elems'][$j]['desc'], $allowedposttags);
				break;
				
				
				case 'featuredimage':
				$data[$i]['elems'][$j]['data']['data']['imageSize'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['imageSize']);
				break;
				
				case 'swiperslider':
				$data[$i]['elems'][$j]['data']['data']['imageSize'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['imageSize']);
				$data[$i]['elems'][$j]['data']['data']['auto_play_time'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['auto_play_time']);
				$data[$i]['elems'][$j]['data']['data']['activate_auto_play'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_auto_play']);
				$data[$i]['elems'][$j]['data']['data']['arrow_nav'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['arrow_nav']);
				$data[$i]['elems'][$j]['data']['data']['imageSize'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['imageSize']);
				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['images']); $t++){
					$data[$i]['elems'][$j]['data']['data']['images'][$t]['url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['images'][$t]['url']));
					$data[$i]['elems'][$j]['data']['data']['images'][$t]['id'] = intval(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['images'][$t]['id']));
				}
				break;
				
				case 'pricingtable':
				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['tables']); $t++){
					$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageName'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageName']);
					$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageDetail'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageDetail']);
					$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageFeatured'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageFeatured']);
					$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageTime'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageTime']);
					$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packagePrice'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packagePrice']);
					$data[$i]['elems'][$j]['data']['data']['tables'][$t]['featuredText'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['featuredText']);
					for($o=0; $o<count($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions']); $o++){
						$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['name'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['name']);
						$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['value'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['value']);
						$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['icon_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['icon_class']);
						$data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['icon_url'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tables'][$t]['packageOptions'][$o]['icon_url']);						
					}
				}
				break;
				
				case 'curvyslider':
				$data[$i]['elems'][$j]['data']['data']['autoPlay'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['autoPlay']);
				$data[$i]['elems'][$j]['data']['data']['side_navigation'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['side_navigation']);
				$data[$i]['elems'][$j]['data']['data']['slider_bottom_divider'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['slider_bottom_divider']);
				$data[$i]['elems'][$j]['data']['data']['slider_navigation'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['slider_navigation']);
				$data[$i]['elems'][$j]['data']['data']['slider_basic_shortcode'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['slider_basic_shortcode']);
				break;
				
				case 'sidebar':
				$data[$i]['elems'][$j]['data']['data']['id'] = esc_attr(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['id']));
				$data[$i]['elems'][$j]['data']['data']['name'] = esc_attr(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['name']));
				break;
				
				case 'toggles':
				$data[$i]['elems'][$j]['data']['data']['toggleType'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['toggleType']);
				$data[$i]['elems'][$j]['data']['data']['toggle_use_hash'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['toggle_use_hash']);
				$data[$i]['elems'][$j]['data']['data']['boxed_layout'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['boxed_layout']);
				$data[$i]['elems'][$j]['data']['data']['use_shadow'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_shadow']);
				$data[$i]['elems'][$j]['data']['data']['openToggleIndex'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['openToggleIndex']);

				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['toggles']); $t++){
					$data[$i]['elems'][$j]['data']['data']['toggles'][$t]['title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['toggles'][$t]['title']);
					$data[$i]['elems'][$j]['data']['data']['toggles'][$t]['toggle_hash'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['toggles'][$t]['toggle_hash']);
					$data[$i]['elems'][$j]['data']['data']['toggles'][$t]['text'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['toggles'][$t]['text']);
					$data[$i]['elems'][$j]['data']['data']['toggles'][$t]['icon_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['toggles'][$t]['icon_class']);
					$data[$i]['elems'][$j]['data']['data']['toggles'][$t]['icon_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['toggles'][$t]['icon_url']));
				}
				break;
				
				case 'tabs':
				$data[$i]['elems'][$j]['data']['data']['tabType'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tabType']);
				$data[$i]['elems'][$j]['data']['data']['tab_use_hash'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tab_use_hash']);
				$data[$i]['elems'][$j]['data']['data']['boxed_layout'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['boxed_layout']);
				$data[$i]['elems'][$j]['data']['data']['use_shadow'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_shadow']);
				$data[$i]['elems'][$j]['data']['data']['openTabIndex'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['openTabIndex']);

				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['tabs']); $t++){
					$data[$i]['elems'][$j]['data']['data']['tabs'][$t]['title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tabs'][$t]['title']);
					$data[$i]['elems'][$j]['data']['data']['tabs'][$t]['tab_hash'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tabs'][$t]['tab_hash']);
					$data[$i]['elems'][$j]['data']['data']['tabs'][$t]['text'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['tabs'][$t]['text']);
					$data[$i]['elems'][$j]['data']['data']['tabs'][$t]['icon_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tabs'][$t]['icon_class']);
					$data[$i]['elems'][$j]['data']['data']['tabs'][$t]['icon_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tabs'][$t]['icon_url']));
				}
				break;
								
				case 'iconictext':
				$data[$i]['elems'][$j]['data']['data']['iconAlign'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconAlign']);
				$data[$i]['elems'][$j]['data']['data']['boxed_layout'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['boxed_layout']);
				$data[$i]['elems'][$j]['data']['data']['use_shadow'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_shadow']);
				$data[$i]['elems'][$j]['data']['data']['iconClass'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconClass']);
				$data[$i]['elems'][$j]['data']['data']['iconURL'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconURL']);
				$data[$i]['elems'][$j]['data']['data']['iconSize'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconSize']);
				$data[$i]['elems'][$j]['data']['data']['title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['title']);
				$data[$i]['elems'][$j]['data']['data']['content'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['content']);
				$data[$i]['elems'][$j]['data']['data']['icon_box_model'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_box_model']);
				$data[$i]['elems'][$j]['data']['data']['icon_box_ratio'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_box_ratio']);
				$data[$i]['elems'][$j]['data']['data']['icon_box_color_default'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_box_color_default']);
				$data[$i]['elems'][$j]['data']['data']['icon_box_color_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_box_color_hover']);
				$data[$i]['elems'][$j]['data']['data']['icon_color_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_color_hover']);
				$data[$i]['elems'][$j]['data']['data']['icon_box_fill'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_box_fill']);
				$data[$i]['elems'][$j]['data']['data']['icon_color_default'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_color_default']);

				$data[$i]['elems'][$j]['data']['data']['link_details']['url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['url']));
				$data[$i]['elems'][$j]['data']['data']['link_details']['post_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['post_id']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['is_tax'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['is_tax']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['tax_name'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['tax_name']);
				break;
				
				case 'button':
				$data[$i]['elems'][$j]['data']['data']['button_align'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_align']);
				$data[$i]['elems'][$j]['data']['data']['button_size'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_size']);
				$data[$i]['elems'][$j]['data']['data']['button_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_color']);
				$data[$i]['elems'][$j]['data']['data']['button_shadow'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_shadow']);
				$data[$i]['elems'][$j]['data']['data']['button_shape'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_shape']);
				//$data[$i]['elems'][$j]['data']['data']['button_wrap'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_wrap']);
				$data[$i]['elems'][$j]['data']['data']['button_link_target'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_link_target']);
				$data[$i]['elems'][$j]['data']['data']['iconAlign'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconAlign']);
				$data[$i]['elems'][$j]['data']['data']['bg_color_default'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['bg_color_default']);
				$data[$i]['elems'][$j]['data']['data']['bg_color_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['bg_color_hover']);
				$data[$i]['elems'][$j]['data']['data']['text_color_default'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['text_color_default']);
				$data[$i]['elems'][$j]['data']['data']['text_color_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['text_color_hover']);
				$data[$i]['elems'][$j]['data']['data']['border_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['border_color']);
				$data[$i]['elems'][$j]['data']['data']['border_color_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['border_color_hover']);
				$data[$i]['elems'][$j]['data']['data']['button_bg_border'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_bg_border']);
				$data[$i]['elems'][$j]['data']['data']['iconClass'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconClass']);
				$data[$i]['elems'][$j]['data']['data']['iconURL'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconURL']));
				$data[$i]['elems'][$j]['data']['data']['title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['title']);
				$data[$i]['elems'][$j]['data']['data']['attr_title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['attr_title']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['url']));
				$data[$i]['elems'][$j]['data']['data']['link_details']['post_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['post_id']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['is_tax'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['is_tax']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['tax_name'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['tax_name']);
				break;		
				
				case 'skill':
				$data[$i]['elems'][$j]['data']['data']['skill_title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['skill_title']);
				$data[$i]['elems'][$j]['data']['data']['skill_current_value'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['skill_current_value']);
				$data[$i]['elems'][$j]['data']['data']['skill_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['skill_color']);
				$data[$i]['elems'][$j]['data']['data']['skill_bg_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['skill_bg_color']);
				break;
				
				case 'horizontalrule':
				$data[$i]['elems'][$j]['data']['data']['hr_is_image'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hr_is_image']);
				$data[$i]['elems'][$j]['data']['data']['image_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_url']));
				$data[$i]['elems'][$j]['data']['data']['image_id'] = intval(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_id']));
				$data[$i]['elems'][$j]['data']['data']['tile_image'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['tile_image']);
				$data[$i]['elems'][$j]['data']['data']['hr_html_model'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hr_html_model']);
				$data[$i]['elems'][$j]['data']['data']['hr_height'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hr_height']);
				break;
				
				case 'verticalspace':
				$data[$i]['elems'][$j]['data']['data']['vertical_space_height'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['vertical_space_height']);
				$data[$i]['elems'][$j]['data']['data']['custom_value'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['custom_value']);
				break;
				
				case 'portfolio':
				$data[$i]['elems'][$j]['data']['data']['postType'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['postType']);
				$data[$i]['elems'][$j]['data']['data']['imageSize'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['imageSize']);
				for($t=0; $t < count($data[$i]['elems'][$j]['data']['data']['category']); $t++){
					$data[$i]['elems'][$j]['data']['data']['category'][$t] = esc_attr(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['category'][$t]));
				}
				$data[$i]['elems'][$j]['data']['data']['activate_hover_box'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_hover_box']);
				$data[$i]['elems'][$j]['data']['data']['activate_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_hover']);
				$data[$i]['elems'][$j]['data']['data']['hover_bg_change_elem'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hover_bg_change_elem']);
				$data[$i]['elems'][$j]['data']['data']['boxed_layout'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['boxed_layout']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_large'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_large']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_medium'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_medium']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_small'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_small']);
				$data[$i]['elems'][$j]['data']['data']['excerpt_title_option'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['excerpt_title_option']);
				$data[$i]['elems'][$j]['data']['data']['excerpt_length'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['excerpt_length']);
				$data[$i]['elems'][$j]['data']['data']['total'] = intval(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['total']));
				$data[$i]['elems'][$j]['data']['data']['portfolio_model'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['portfolio_model']);
				$data[$i]['elems'][$j]['data']['data']['portfolio_model_switch'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['portfolio_model_switch']);
				$data[$i]['elems'][$j]['data']['data']['activate_category_link'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_category_link']);
				$data[$i]['elems'][$j]['data']['data']['activate_header_link'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_header_link']);
				$data[$i]['elems'][$j]['data']['data']['use_shadow'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_shadow']);
				$data[$i]['elems'][$j]['data']['data']['details_in_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['details_in_hover']);
				$data[$i]['elems'][$j]['data']['data']['use_back_icon'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_back_icon']);
				$data[$i]['elems'][$j]['data']['data']['use_link_icon'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_link_icon']);
				$data[$i]['elems'][$j]['data']['data']['use_lightbox_image'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_lightbox_image']);
				$data[$i]['elems'][$j]['data']['data']['use_lightbox_video'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_lightbox_video']);
				$data[$i]['elems'][$j]['data']['data']['use_lightbox_gallery'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_lightbox_gallery']);
				$data[$i]['elems'][$j]['data']['data']['use_like'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_like']);
				$data[$i]['elems'][$j]['data']['data']['where_to_link'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['where_to_link']);
				$data[$i]['elems'][$j]['data']['data']['display_price'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['display_price']);
				$data[$i]['elems'][$j]['data']['data']['display_date'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['display_date']);
				$data[$i]['elems'][$j]['data']['data']['wall_mode'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['wall_mode']);
				$data[$i]['elems'][$j]['data']['data']['masonry'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['masonry']);
				$data[$i]['elems'][$j]['data']['data']['more_items'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['more_items']);
				$data[$i]['elems'][$j]['data']['data']['swiper_nav_number'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['swiper_nav_number']);
				$data[$i]['elems'][$j]['data']['data']['more_button_json_data'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['more_button_json_data']);
				$data[$i]['elems'][$j]['data']['data']['more_button_shortcode'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['more_button_shortcode']);
				$data[$i]['elems'][$j]['data']['data']['more_button_shortcode'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['more_button_shortcode']);
				$data[$i]['elems'][$j]['data']['data']['list_image_col_large'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['list_image_col_large']);
				break;
				

				case 'rockformbuilder':
				//No data used in Rock Form Builder. Only shortcode
				break;
				
				case 'googlemap':
				$data[$i]['elems'][$j]['data']['data']['api_key'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['api_key']);
				$data[$i]['elems'][$j]['data']['data']['marker_title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['marker_title']);
				$data[$i]['elems'][$j]['data']['data']['lat'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['lat']);
				$data[$i]['elems'][$j]['data']['data']['lng'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['lng']);
				$data[$i]['elems'][$j]['data']['data']['zoom_level'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['zoom_level']);
				$data[$i]['elems'][$j]['data']['data']['map_type'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['map_type']);
				$data[$i]['elems'][$j]['data']['data']['sensor'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['sensor']);
				$data[$i]['elems'][$j]['data']['data']['mouse_wheel'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['mouse_wheel']);
				$data[$i]['elems'][$j]['data']['data']['height'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['height']);
				$data[$i]['elems'][$j]['data']['data']['resize_height'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['resize_height']);
				$data[$i]['elems'][$j]['data']['data']['fullscreen'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['fullscreen']);
				$data[$i]['elems'][$j]['data']['data']['content'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['content']);
				$data[$i]['elems'][$j]['data']['data']['style_obj'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['style_obj']);
				break;
				
				case 'promotionbox':
				$data[$i]['elems'][$j]['data']['data']['button_json_data'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['button_json_data']);
				$data[$i]['elems'][$j]['data']['data']['button_shortcode'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['button_shortcode']);
				$data[$i]['elems'][$j]['data']['data']['content'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['content']);
				$data[$i]['elems'][$j]['data']['data']['background_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['background_color']);
				$data[$i]['elems'][$j]['data']['data']['font_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['font_color']);
				break;
				
				case 'alertbox':
				$data[$i]['elems'][$j]['data']['data']['content'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['content']);
				$data[$i]['elems'][$j]['data']['data']['background_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['background_color']);
				$data[$i]['elems'][$j]['data']['data']['font_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['font_color']);
				$data[$i]['elems'][$j]['data']['data']['border_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['border_color']);
				$data[$i]['elems'][$j]['data']['data']['alertbox_style'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['alertbox_style']);
				$data[$i]['elems'][$j]['data']['data']['iconClass'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconClass']);
				$data[$i]['elems'][$j]['data']['data']['iconURL'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['iconURL']);
				$data[$i]['elems'][$j]['data']['data']['use_close_button'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_close_button']);
				break;
				
				case 'referencesbuilder':
				$data[$i]['elems'][$j]['data']['data']['duration_time'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['duration_time']);
				$data[$i]['elems'][$j]['data']['data']['activate_navigation'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_navigation']);
				$data[$i]['elems'][$j]['data']['data']['auto_slide'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['auto_slide']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_large'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_large']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_medium'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_medium']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_small'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_small']);
				$data[$i]['elems'][$j]['data']['data']['image_size'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_size']);
				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['saved_logo_data']); $t++){
					$data[$i]['elems'][$j]['data']['data']['saved_logo_data'][$t]['img_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['saved_logo_data'][$t]['img_url']));
					$data[$i]['elems'][$j]['data']['data']['saved_logo_data'][$t]['img_id'] = intval(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['saved_logo_data'][$t]['img_id']));
					$data[$i]['elems'][$j]['data']['data']['saved_logo_data'][$t]['link_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['saved_logo_data'][$t]['link_url']));
				}
				break;
				
				case 'testimonialsbuilder':
				$data[$i]['elems'][$j]['data']['data']['boxed_layout'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['boxed_layout']);
				$data[$i]['elems'][$j]['data']['data']['duration_time'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['duration_time']);
				$data[$i]['elems'][$j]['data']['data']['activate_navigation'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_navigation']);
				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['testimonials']); $t++){
					$data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['title']);
					$data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['text'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['text']);
					$data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['company'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['company']);
					$data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['testimonials_image'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['testimonials_image']);
					$data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['testimonials_image_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['testimonials'][$t]['testimonials_image_id']);
				}
				break;
				
				case 'socialicons':
				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['socialicons']); $t++){
					$data[$i]['elems'][$j]['data']['data']['socialicons'][$t]['title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['socialicons'][$t]['title']);
					$data[$i]['elems'][$j]['data']['data']['socialicons'][$t]['icon_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['socialicons'][$t]['icon_class']);
					$data[$i]['elems'][$j]['data']['data']['socialicons'][$t]['icon_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['socialicons'][$t]['icon_url']));
				}
				break;
				
				case 'teammembers':
				$data[$i]['elems'][$j]['data']['data']['block_grid_large'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_large']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_medium'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_medium']);
				$data[$i]['elems'][$j]['data']['data']['block_grid_small'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['block_grid_small']);
				for($t = 0; $t<count($data[$i]['elems'][$j]['data']['data']['teammembers']); $t++){
					$data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['title']);
					if(isset($data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['text'])){
						$data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['text'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['text']);
					}
					$data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['company'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['company']);
					$data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['member_image_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['member_image_url']));
					$data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['member_image_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['member_image_id']);
					$data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['social_data'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['teammembers'][$t]['social_data']);
				}
				break;
				
				case 'beforeafterslider':
				$data[$i]['elems'][$j]['data']['data']['image_size'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_size']);
				$data[$i]['elems'][$j]['data']['data']['before_image_url'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['before_image_url']);
				$data[$i]['elems'][$j]['data']['data']['before_image_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['before_image_id']);
				$data[$i]['elems'][$j]['data']['data']['after_image_url'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['after_image_url']);
				$data[$i]['elems'][$j]['data']['data']['after_image_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['after_image_id']);
				$data[$i]['elems'][$j]['data']['data']['height'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['height']);
				$data[$i]['elems'][$j]['data']['data']['min_width'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['min_width']);
				$data[$i]['elems'][$j]['data']['data']['activate_navigation'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['activate_navigation']);
				break;
				
				case 'externalshortcode':
				$data[$i]['elems'][$j]['data']['data']['shortcode'] = wp_kses_post($data[$i]['elems'][$j]['data']['data']['shortcode']);
				break;
				
				case 'regularblog':
				$data[$i]['elems'][$j]['data']['data']['regular_content'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['regular_content']);
				$data[$i]['elems'][$j]['data']['data']['image_size'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_size']);
				$data[$i]['elems'][$j]['data']['data']['hover_active'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hover_active']);
				$data[$i]['elems'][$j]['data']['data']['image_col'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_col']);
				$data[$i]['elems'][$j]['data']['data']['excerpt_length'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['excerpt_length']);
				$data[$i]['elems'][$j]['data']['data']['header_link'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['header_link']);
				$data[$i]['elems'][$j]['data']['data']['show_categories'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['show_categories']);
				$data[$i]['elems'][$j]['data']['data']['show_tags'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['show_tags']);
				$data[$i]['elems'][$j]['data']['data']['show_date'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['show_date']);
				$data[$i]['elems'][$j]['data']['data']['pagination'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['pagination']);
				$data[$i]['elems'][$j]['data']['data']['sticky_first'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['sticky_first']);
				$data[$i]['elems'][$j]['data']['data']['total'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['total']);
				$data[$i]['elems'][$j]['data']['data']['space_height'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['space_height']);
				for($t=0; $t < count($data[$i]['elems'][$j]['data']['data']['category']); $t++){
					$data[$i]['elems'][$j]['data']['data']['category'][$t] = esc_attr(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['category'][$t]));
				}
				break;
				
				case 'achievement':
				$data[$i]['elems'][$j]['data']['data']['number_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['number_color']);
				$data[$i]['elems'][$j]['data']['data']['text_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['text_color']);
				$data[$i]['elems'][$j]['data']['data']['icon_bg_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_bg_color']);
				$data[$i]['elems'][$j]['data']['data']['icon_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_color']);
				$data[$i]['elems'][$j]['data']['data']['icon_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_class']);
				$data[$i]['elems'][$j]['data']['data']['icon_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['icon_url']));
				$data[$i]['elems'][$j]['data']['data']['detail_text'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['detail_text']);
				$data[$i]['elems'][$j]['data']['data']['mode'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['mode']);
				$data[$i]['elems'][$j]['data']['data']['static_number'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['static_number']);
				$data[$i]['elems'][$j]['data']['data']['function_php'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['function_php']);
				$data[$i]['elems'][$j]['data']['data']['function_js'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['function_js']);
				$data[$i]['elems'][$j]['data']['data']['external_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['external_url']));
				break;
				
				case 'heading':
				$data[$i]['elems'][$j]['data']['data']['bold_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['bold_color']);
				$data[$i]['elems'][$j]['data']['data']['regular_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['regular_color']);
				$data[$i]['elems'][$j]['data']['data']['details_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['details_color']);
				$data[$i]['elems'][$j]['data']['data']['bold_text'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['bold_text']);
				$data[$i]['elems'][$j]['data']['data']['light_text'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['light_text']);
				$data[$i]['elems'][$j]['data']['data']['details_text'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['details_text']);
				$data[$i]['elems'][$j]['data']['data']['heading_font_size'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['heading_font_size']);
				$data[$i]['elems'][$j]['data']['data']['html_tag'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['html_tag']);
				$data[$i]['elems'][$j]['data']['data']['align'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['align']);
				$data[$i]['elems'][$j]['data']['data']['use_icon'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['use_icon']);
				$data[$i]['elems'][$j]['data']['data']['disable_margin'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['disable_margin']);
				break;
				
				case 'stepselement':
				$data[$i]['elems'][$j]['data']['data']['steps_mode'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['steps_mode']);
				$data[$i]['elems'][$j]['data']['data']['start_steps'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['start_steps']);
				$data[$i]['elems'][$j]['data']['data']['steps_bg_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['steps_bg_color']);
				$data[$i]['elems'][$j]['data']['data']['min_width'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['min_width']);
				$data[$i]['elems'][$j]['data']['data']['margin_top'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['margin_top']);
				$data[$i]['elems'][$j]['data']['data']['margin_bottom'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['margin_bottom']);
				if(isset($data[$i]['elems'][$j]['data']['data']['category'])){
					for($t=0; $t < count($data[$i]['elems'][$j]['data']['data']['category']); $t++){
						$data[$i]['elems'][$j]['data']['data']['category'][$t] = esc_attr(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['category'][$t]));
					}
				}
				break;
				
				case 'singleimage':
				$data[$i]['elems'][$j]['data']['data']['image_sizes'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_sizes']);
				$data[$i]['elems'][$j]['data']['data']['image_url'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_url']);
				$data[$i]['elems'][$j]['data']['data']['image_align'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_align']);
				$data[$i]['elems'][$j]['data']['data']['image_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_id']);
				$data[$i]['elems'][$j]['data']['data']['extra_style'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_style']);
				$data[$i]['elems'][$j]['data']['data']['extra_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_class']);
				$data[$i]['elems'][$j]['data']['data']['image_link_target'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_link_target']);
				$data[$i]['elems'][$j]['data']['data']['enable_hover'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['enable_hover']);
				$data[$i]['elems'][$j]['data']['data']['hover_bg_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hover_bg_color']);
				$data[$i]['elems'][$j]['data']['data']['hover_color'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hover_color']);
				$data[$i]['elems'][$j]['data']['data']['hover_title'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['hover_title']);
				$data[$i]['elems'][$j]['data']['data']['overflow_image'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['overflow_image']);
				$data[$i]['elems'][$j]['data']['data']['overflow_image_size'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['overflow_image_size']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['url']));
				$data[$i]['elems'][$j]['data']['data']['link_details']['post_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['post_id']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['is_tax'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['is_tax']);
				$data[$i]['elems'][$j]['data']['data']['link_details']['tax_name'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['link_details']['tax_name']);
				break;
				
				case 'youtube':
				$data[$i]['elems'][$j]['data']['data']['video_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['video_url']));
				$data[$i]['elems'][$j]['data']['data']['extra_style'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_style']);
				$data[$i]['elems'][$j]['data']['data']['extra_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_class']);
				break;
				
				case 'vimeo':
				$data[$i]['elems'][$j]['data']['data']['video_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['video_url']));
				$data[$i]['elems'][$j]['data']['data']['extra_style'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_style']);
				$data[$i]['elems'][$j]['data']['data']['extra_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_class']);
				break;
				
				case 'htmlvideo':
				$data[$i]['elems'][$j]['data']['data']['video_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['video_url']));
				$data[$i]['elems'][$j]['data']['data']['image_url'] = esc_url(sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_url']));
				$data[$i]['elems'][$j]['data']['data']['image_id'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['image_id']);
				$data[$i]['elems'][$j]['data']['data']['extra_style'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_style']);
				$data[$i]['elems'][$j]['data']['data']['extra_class'] = sanitize_text_field($data[$i]['elems'][$j]['data']['data']['extra_class']);
				break;
				
				case 'revolutionslider':
				$data[$i]['elems'][$j]['data']['shortcode'] = sanitize_text_field($data[$i]['elems'][$j]['data']['shortcode']);
				break;
			}
			
			//If not text area, then sanitize the shortcode
			if($data[$i]['elems'][$j]['descType'] !== 'textarea'){
				$data[$i]['elems'][$j]['data']['shortcode'] = wp_kses_post($data[$i]['elems'][$j]['data']['shortcode']);
				$data[$i]['elems'][$j]['desc'] = $data[$i]['elems'][$j]['data']['shortcode'];
			}
		}
	}
	
	return $data;
}



/*
**	RPB save data is encoded with json and also uses slashes. This function gets that data
**	and turns it into an Array. Even if it's using slashes or not, json or not, this function
**	will turn that data into array. If the data is not valid, this will return false.
**
**	@param	:	$data:String 	: json coded, slashed string
**	@return	:	Array/Boolean	: will return array if data is valid, if not will return false
**
**	@since	:	2.0
*/
function rpb_admin_main_save_data_to_array($data=''){
	if($data == '\\"\\"') return '';
	
	if(!is_array($data)){
		
		$test_data = json_decode($data, true);
		if(!is_array($test_data)){
			
			$test_data = json_decode(stripslashes($data),true);
			if(!is_array($test_data)){
		
				$test_data = preg_replace( '/\r|\n/', '', $data);
				if(!is_array($test_data)){
					
					$test_data_0 = json_decode($test_data,true);
					if(!is_array($test_data)){
							
						$test_data_0 = json_decode(stripslashes($test_data),true);
						if(!is_array($test_data_0)){
							return false;			
						}else{
							$data = $test_data_0;	
						}
							
					}else{
						$data = $test_data_0;	
					}
					
				}else{
					$data = $test_data;	
				}
			
			}else{
				$data = $test_data;
			}
			
		}else{
			$data = $test_data;
		}
	}
	
	if(is_array($data)){
		return $data;	
	}
	
	return false;
}


















?>