<?php
/*
**	Rock Page Builder Functions
**
**	Alias	:	Rock Builder UI		Located in "rock-builder/rock-builder-ui.php"
**	Alias	:	Rock Builder		Located in "rock-builder/rock-builder.php"
**	Author	:	Rockthemes.net
**	License	:	Contact to rockthemes.net for further information
**	Version	:	1.3
**
**	This file contains all of the ajax based and regular functions of the Rock Page Builder
*/




/*
**	Rock Ajax Save Function
*/
if(!function_exists('rockthemes_pb_save')):
function rockthemes_pb_save() {
	if(!rpb_is_admin()) return;

	if(!isset($_POST['serializedArray'])) return;
	
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rpb_save') ||
		!check_ajax_referer('rpb_save')) {
	
		//Die
		die('ERROR');		
	}
	
	// get the submitted parameters
	$postID = intval($_POST['postID']);
	if(!is_string( get_post_status( $postID ))) die('POST DOES NOT EXISTS');
		
	$rpb_data = rpb_admin_save_validate_data($_POST['serializedArray']);
	
	if(false === $rpb_data) die('DATA NOT VALID');
	
	$rpb_data = json_encode($rpb_data);
	
	
	$_builder_in_use = isset($_POST['_builder_in_use']) ? $_POST['_builder_in_use'] : 'false';
	$_featured_image_in_builder = $_POST['featuredInBuilder'];
	$enqueue_libs = isset($_POST['enqueue']) ? $_POST['enqueue'] : array();
	
		
   	update_post_meta($postID, '_this_r_content', ((addslashes($rpb_data))) );  
	update_post_meta($postID, '_builder_in_use', $_builder_in_use);
	update_post_meta($postID, '_featured_image_in_builder', $_featured_image_in_builder);
	update_post_meta($postID, '_enqueue_libs', $enqueue_libs);

	//Didn't work well
	if($_builder_in_use !== 'false' || defined('RPB_FULL_SHORTCODE')){
		global $allowedposttags;
		
		$val = get_post_meta( $postID, '_this_r_content', true );  
		
		
		if(defined('RPB_CONTENT_FILTER')){
			$val = preg_replace( '/\r/', '', $val);
		}else{
			$val = preg_replace( '/\r|\n/', '', $val);
		}
		$final_val = (json_decode($val, true));
			
		if(!is_array($final_val)){
			$final_val = json_decode(stripslashes($val), true);
		}
		
		$rpb_content = '';
		
		//Before Header Area
		$header_content = '';
		if(defined('RPB_FULL_SHORTCODE')){
			//$header_content = (rpb_be_parse_to_full_shortcode($final_val,'header'));
		}else{
			$header_content = (rockthemes_pb_parse_content_val($final_val,'header'));
		}
		if(strlen($header_content) > 0){
			$header_content = '
				[rockthemes_specialgridblock avoid_sidebar="header" skip_sg="true"]
				'.$header_content.'
				[/rockthemes_specialgridblock]
			';
			$rpb_content .= $header_content;
		}
		
		
		
		//For inline_navigation
		$rad_post = (object) array('ID'=>$postID);
		$header_id = function_exists('rad_get_option') ? rad_get_option('rin_header_id', $rad_post) : '';
		$header_title = function_exists('rad_get_option') ? rad_get_option('rin_header_title', $rad_post) : '';
		if($header_id && $header_title){
			$GLOBALS['rockthemes_frontend_inline_nav'][$header_id] = $header_title;
		}
		
		
		//Before Sidebars
		$before_content = '';
		if(defined('RPB_FULL_SHORTCODE')){
			//$before_content = (rpb_be_parse_to_full_shortcode($final_val,'before'));
		}else{
			$before_content = (rockthemes_pb_parse_content_val($final_val,'before'));
		}
		if(strlen($before_content) > 0){
			$before_content = '
				[rockthemes_specialgridblock avoid_sidebar="before" skip_sg="true"]
				</div>'.$before_content.'<div class="row">
				[/rockthemes_specialgridblock]
			';
			$rpb_content .= $before_content;
		}
		
		
		//Regular Area
		$regular_content = '';
		if(defined('RPB_FULL_SHORTCODE')){
			//$regular_content = (rpb_be_parse_to_full_shortcode($final_val)).(rpb_be_parse_to_full_shortcode($final_val, 'regular'));
		}else{
			$regular_content = (rockthemes_pb_parse_content_val($final_val)).(rockthemes_pb_parse_content_val($final_val, 'regular'));
		}
		//$regular_content = (rockthemes_pb_parse_content_val($final_val)).(rockthemes_pb_parse_content_val($final_val, 'regular'));
		if(strlen($regular_content) > 0){
			$regular_content = '
				[rockthemes_specialgridblock avoid_sidebar="regular" skip_sg="true"]
				'.$regular_content.'
				[/rockthemes_specialgridblock]
			';
			$rpb_content .= $regular_content;
		}
		
		
		//After Sidebars
		$after_content = '';
		if(defined('RPB_FULL_SHORTCODE')){
			//$after_content = (rpb_be_parse_to_full_shortcode($final_val,'after'));
		}else{
			$after_content = (rockthemes_pb_parse_content_val($final_val,'after'));
		}
		$after_content = (rockthemes_pb_parse_content_val($final_val,'after'));
		if(strlen($after_content) > 0){
			$after_content = '
				[rockthemes_specialgridblock avoid_sidebar="after" skip_sg="true"]
				</div></div>'.$after_content.'<div><div class="row">
				[/rockthemes_specialgridblock]
			';
			$rpb_content .= $after_content;
		}
		
		//Extend Allowed tags with Special Grid tags
		$allowedposttags['div']['data-animation-class'] = true;
		$allowedposttags['div']['data-animation-delay-time'] = true;
		$allowedposttags['div']['data-rsb-fullscreen'] = true;
		$allowedposttags['div']['data-overlay-color'] = true;
		$allowedposttags['div']['data-parallax-model'] = true;
		$allowedposttags['div']['data-parallax-bg-image'] = true;
		$allowedposttags['div']['data-parallax-bg-image-retina'] = true;
		$allowedposttags['div']['data-parallax-mask-height'] = true;
		$allowedposttags['div']['data-parallax-padding'] = true;
		$allowedposttags['div']['data-image-ratio'] = true;
		$allowedposttags['div']['data-image-tile'] = true;
		$allowedposttags['div']['data-static-bg-image'] = true;
		$allowedposttags['div']['data-static-bg-image-retina'] = true;
		$allowedposttags['div']['data-static-mask-height'] = true;
		$allowedposttags['div']['data-padding'] = true;
		$allowedposttags['div']['data-image-ratio'] = true;
		$allowedposttags['div']['data-image-tile'] = true;
		$allowedposttags['div']['data-video_bg_fallback_url'] = true;
		$allowedposttags['div']['data-rsb-ratio'] = true;
		$allowedposttags['div']['data-multibg-colors'] = true;
		$allowedposttags['video']['data-autoplay'] = true;
		
		
		if(defined('RPB_FULL_SHORTCODE')){
			$rpb_content = rpb_be_parse_to_full_shortcode($final_val);
		}
		
		if(defined('RPB_CONTENT_FILTER')){
			$rpb_content = preg_replace( '/\r/', '', wp_kses($rpb_content, $allowedposttags));
		}else{
			$rpb_content = preg_replace( '/\r|\n/', '', wp_kses($rpb_content, $allowedposttags));
		}

		wp_update_post(array('ID'=>$postID, 'post_content'=>$rpb_content));	
		
		if(isset($GLOBALS['rockthemes_frontend_inline_nav']) && count($GLOBALS['rockthemes_frontend_inline_nav']) > 0){
			update_post_meta($postID, '_rockthemes_inline_nav', $GLOBALS['rockthemes_frontend_inline_nav']);	
		}
	}
	
	 
	// generate the response
	$response = json_encode( array( 'success' => true ) );

	// response output
	echo rockthemes_escaped_out_render($response);

	exit;
}
add_action( 'wp_ajax_rpb_save', 'rockthemes_pb_save' );
endif;

if(!function_exists('rockthemes_pb_featured_in_builder')):
function rockthemes_pb_featured_in_builder(){
	global $post;
	if($post && $post->ID){
		return get_post_meta($post->ID, '_featured_image_in_builder',true);
	}
	return 'false';
}
endif;












/*
**	Rockthemes Wordpress Import / Export Hook
**
**	Wordpress export successfully exports all of the data in the database without changes.
**
**	Wordpress import breaks some codes in Rock Page Builder. This function hooks into Wordpress Import Plugin
**	and remap the data as needed
*/
function rockthemes_pb_wp_import_hook( $post_id, $key, $value){
	global $wp_import;
	
	//Only remap Rock Page Builder Content and Advanced Post Details
	if($key !== '_this_r_content' && $key !== 'advanced_post_details') return;
	
	$old_url_found = false;
	
	//Get the imported datas old url
	if(isset($GLOBALS['wp_import'])){
		$old_url = $GLOBALS['wp_import']->base_url;
		$old_url_found = true;
	}elseif(!empty($wp_import) && isset($wp_import->base_url)){
		$old_url = $wp_import->base_url;	
		$old_url_found = true;
	}
	
	//Get current url
	$current_site_url = home_url();
	
	if(isset($GLOBALS['rockthemes_export_settings'])){
		$omu_data = $GLOBALS['rockthemes_export_settings'];
		if(is_array($omu_data) && isset($omu_data['media_url']) && isset($omu_data['media_url']['baseurl'])){
			$omu = $omu_data['media_url']['baseurl'];
		}
	}else{
		$omu = get_option('rockthemes_migrate_omu',false);
	}
		
	if(isset($omu) && $omu && $omu !== ''){
		$old_url = $omu;	
		$nmu = wp_upload_dir();
		$current_site_url = $nmu['baseurl'];
		$old_url_found = true;
	}
	
	if(!$old_url_found) {return;}
	
	
	//Encode URLs
	$old_url_encoded = str_replace('/', '\\/', $old_url);
	$current_site_url_encoded = str_replace('/', '\\/', $current_site_url);


	if($key === 'advanced_post_details'){
		$encoded_details = json_encode($value);
		
		//replace all of the old urls 	
		$encoded_details_replaced = str_replace($old_url, $current_site_url, ($encoded_details));
		//replace all of the old urls 	
		$encoded_details_replaced = str_replace($old_url_encoded, $current_site_url_encoded, ($encoded_details_replaced));
		
		$decoded_details_replaced = json_decode($encoded_details_replaced, true);
		
		update_post_meta($post_id, $key, $decoded_details_replaced);
	}
	
	if($key === '_this_r_content'){		
		//replace all of the old urls 	
		$replaced = str_replace($old_url, $current_site_url, $value);
		
		$replaced = str_replace($old_url_encoded, $current_site_url_encoded, $replaced);
		
		if(is_array(json_decode($replaced, true))){
			//echo 'OMU '.$old_url. ' POST_ID '.$post_id.'\n';
			//var_dump(strpos($value,$old_url));
			//If exported server escapes slashes in the XML, read slashes to the datas
			$replaced = addslashes($replaced);	
		}
		
		//Update the registered post meta with new url values
		update_post_meta($post_id, $key, ($replaced));
	}
}
add_action('import_post_meta','rockthemes_pb_wp_import_hook', 10, 3);


function rockthemes_pb_wp_import_end_hook(){
	//Some additional hooks to import end can be added here if needed
}
//add_action('import_end', 'rockthemes_pb_wp_import_end_hook', 10);

/*
**	Rock Builder Media URL Edit
**
**	This function edits the media URLS to match with the new media folder. 
**
*/
function rockthemes_migrate_old_media_url(){
	global $pagenow;
		
	//Return if you are not in the admin	
	if($pagenow !== 'admin.php' && $pagenow !== 'admin'){
		return;	
	}
	//Return if you are not in the wordpress import
	if(!isset($_REQUEST['import']) || !$_REQUEST['import'] || $_REQUEST['import'] !== 'wordpress'){
		return;	
	}
	//Only display on 0 step. greet() in Wordpress Importer
	if(isset($_REQUEST['step']) && $_REQUEST['step'] !== 0){
		return;	
	}
	
	$return = '<h3>Your Old Site Media Library URL</h3>';
	
	$omu = get_option('rockthemes_migrate_omu','');//omu = Old Media URL

	//Omu Not Entered
	if(!$omu || '' === $omu){
		$return .= '<p>You must enter your old site Media Library URL for media migration. You can get your old site Media Library URL in :</p>
		<strong>Appearance > Theme Options > Server Details</strong> named as <strong>Your Media Library URL</strong><br/><br/>
		Click on "Save URL" button after you enter your old Media Library URL. Then you can continue for importing XML data.<br/><br/>';
	}else{
		$return .= '
		<div class="rockthemes_migrate_user_omu">
			<strong>You have entered this URL for your old site Media Library URL</strong>
			<p>'.$omu.'</p>
			<br/>
			<p>If you want to change this old URL, simply re-enter your old URL here and click on "Save URL"</p>
		</div>
		';
	}
	
	//Add The form
	$return .= '<input type="text" class="rockthemes_migrate_omu" name="rockthemes_migrate_omu" value="'.$omu.'" style="min-width:480px;" /><br/><br/>';
	
	//Add the button
	$return .= '<div class="rockthemes_migrate_omu_save button">Save URL</div><br/><br/><hr/>';
	
	$script = '
	<script type="text/javascript">
		jQuery(document).ready(function(){
			jQuery(document).on("click", ".rockthemes_migrate_omu_save", function(e){
				e.preventDefault();
				var that = jQuery(this);
				that.append(jQuery("<span> Saving...</span>"));
				
				var omu = jQuery(".rockthemes_migrate_omu").val();
				jQuery.post("'.admin_url('admin-ajax.php').'", {rockthemes_omu:omu, action:"rockthemes_migrate_omu_save"}, function(data){
					console.log(data);
					that.find("span").remove();
				});
			});
		});
	</script>';
	
	echo rockthemes_escaped_out_render($return.$script);
}
add_action('admin_notices', 'rockthemes_migrate_old_media_url');

function rockthemes_migrate_omu_save(){
	if(!isset($_REQUEST['rockthemes_omu'])){
		die('error');
	}
	
	if($_REQUEST['rockthemes_omu'] === ''){
		delete_option('rockthemes_migrate_omu');	
	}
	
	//Update the omu
	$update = update_option('rockthemes_migrate_omu', sanitize_text_field($_REQUEST['rockthemes_omu']));
	
	echo rockthemes_escaped_out_render($update);
	
	exit;
}
add_action('wp_ajax_rockthemes_migrate_omu_save', 'rockthemes_migrate_omu_save');







/*
**	Get Custom Post types
*/

function rock_builder_get_customposttypes($selected = null, $modal_ID = null, $header=null) {
	
	$post_types = get_post_types(array('_builtin'=>false));

	if(sizeof($post_types) <= 0) {echo "empty"; return;}
	
	$return = '<div class="custom_post_types_holder">';
	
	if(isset($_REQUEST['header'])) $return .= '<h4>'.esc_html($_REQUEST['header']).'</h4>';
	if(isset($header)) $return .= '<h4>'.esc_html($header).'</h4>';
	
	$modalID = isset($modal_ID) ? $modal_ID : $_REQUEST['modal_ID'];
		
	$return .= '<select class="custom_post_types" bind="'.esc_attr($modalID).'" autocomplete="off">';
	
	if($selected == "no-selected"){
		$return .= '<option value="no-selected" selected>Choose a Post Type</option>';
	}else{
		$return .= '<option value="no-selected">Choose a Post Type</option>';
	}
	
	if($selected == 'post'){
		$return .= '<option value="post" selected>post</option>';
	}else{
		$return .= '<option value="post">post</option>';
	}
	
	foreach($post_types as $type){
		//Remove the unlrelated post types.
		if($type == 'product_variation'
		   || $type == 'shop_order'
		   || $type == 'shop_coupon'
		   || $type == '' ){
			//Do Nothing	
		}else{
			//If post type is allowed in our list and not unrelated add them to select item
			if($selected == $type){
				$return .= '<option value="'.$type.'" selected>'.$type.'</option>';
			}else{
				$return .= '<option value="'.$type.'">'.$type.'</option>';
			}
		}
	}
	
	$return .= '</select>';
	
	$return .= '</div>';
	
	if(isset($selected)){
		return $return;
	}else{
		echo rockthemes_escaped_out_render($return);
	}

	exit;
}

function rock_builder_get_customposttypes_ajax(){
	rock_builder_get_customposttypes();
	exit;
}
add_action( 'wp_ajax_rockAjax_get_customposttypes', 'rock_builder_get_customposttypes_ajax' );



/*
**	Get Taxonomies/Categories 
*/

function rock_builder_get_taxonomies($selected=null, $incoming_type = null, $header = null) {
		
	if(!isset($_REQUEST['post_type']) && !isset($incoming_type)) return;
	
	$post_type = isset($_REQUEST['post_type']) ? $_REQUEST['post_type'] : $incoming_type;
		
	$list = null;
	
	//If default wordpress post types in use (such as post, page) this variable will be setted to true
	$postTypeDefault = false;
	
	if($post_type == 'post'){
		$list = get_categories();
		$postTypeDefault = true;
	}else{
		$tax_list = get_object_taxonomies($post_type);
		foreach($tax_list as $tax){

			if(strpos($tax,'cat') > -1){
				$list = get_terms($tax, array('hide_empty'=>0));
				break;
			}
		}
	}
	
				
	if(!$list || (is_array($list) && sizeof($list) <= 0)) {echo ""; return;}
		
	$return = '<div class="category_taxonomy_holder">';
	
	if(isset($_REQUEST['header'])) $return .= '<h4>'.esc_html($_REQUEST['header']).'</h4>';
	if(isset($header)) $return .= '<h4>'.esc_html($header).'</h4>';
		
	$return .= '<select multiple class="category_taxonomy" autocomplete="off">';
	
	$all_types = '';
	$total = sizeof($list);
	$i = 0;
	foreach($list as $allType){
		$all_types .= $allType->slug;
		
		if($i +1 < $total){
			$all_types .= ',';	
		}
		
		$i++;
	}
	
	$all_types = urldecode($all_types);
	
	if(isset($selected) && $selected !== '' && $selected){
		$totalEqual = 0;
		foreach($selected as $sel){
			foreach($list as $elem){
				if($elem->slug == $sel){
					$totalEqual++;
					break;
				}
			}
		}

		if($totalEqual === $total){
			$return .= '<option value="'.esc_attr($all_types).'" selected>All</option>';
		}else{
			$return .= '<option value="'.esc_attr($all_types).'">All</option>';
		}
	}else{
		$return .= '<option value="'.esc_attr($all_types).'" selected>All</option>';
	}
	
	foreach($list as $type){
		
		$type->slug = urldecode($type->slug);
		
		if(isset($selected) && $selected !== '' && $selected && is_array($selected)){
			$exists = false;
						
			foreach($selected as $sel){
				if($sel == $type->slug){
					$exists = true;
				}
			}
						
			if($exists){
				if($postTypeDefault){
					$return .= '<option value="'.$type->slug.'" selected>'.$type->name.'</option>';
				}else{
					$return .= '<option value="'.$type->slug.'" selected>'.$type->name.'</option>';
				}
			}else{
				if($postTypeDefault){
					$return .= '<option value="'.$type->slug.'">'.$type->name.'</option>';
				}else{
					$return .= '<option value="'.$type->slug.'">'.$type->name.'</option>';
				}
			}
		}else{
			if($postTypeDefault){
				$return .= '<option value="'.$type->slug.'">'.$type->name.'</option>';
			}else{
				$return .= '<option value="'.$type->slug.'">'.$type->name.'</option>';
			}
		}
	}
	
	$return .= '</select>';
	
	$return .= '</div>';
	
	if(isset($selected)){
		return $return;
	}else{
		echo rockthemes_escaped_out_render($return);
	}

	exit;
}
function rock_builder_get_taxonomies_ajax(){
	rock_builder_get_taxonomies();	
	exit;
}
add_action( 'wp_ajax_rockAjax_get_taxonomies', 'rock_builder_get_taxonomies_ajax' );



/*
**	Get All Image Types (thumbnail, medium, large etc..)
*/

function rock_builder_get_image_sizes($selected = null, $modal_ID = null, $header = null){
	global $_wp_additional_image_sizes;
	
	$sizes = array();
	foreach( get_intermediate_image_sizes() as $s ){
 		$sizes[ $s ] = array( 0, 0 );
 		if( in_array( $s, array( 'thumbnail', 'medium', 'large' ) ) ){
 			$sizes[ $s ][0] = get_option( $s . '_size_w' );
 			$sizes[ $s ][1] = get_option( $s . '_size_h' );
 		}else{
 			if( isset( $_wp_additional_image_sizes ) && isset( $_wp_additional_image_sizes[ $s ] ) )
 				$sizes[ $s ] = array( $_wp_additional_image_sizes[ $s ]['width'], $_wp_additional_image_sizes[ $s ]['height'], );
 		}
 	}
		
	if(sizeof($sizes) <= 0) {echo "empty"; return;}
	
	$return = '<div class="image_sizes_holder">';
	
	if(isset($_REQUEST['header'])) $return .= '<h4>'.esc_html($_REQUEST['header']).'</h4>';
	if(isset($header)) $return .= '<h4>'.esc_html($header).'</h4>';
	
	$modalID = isset($modal_ID) ? $modal_ID : $_REQUEST['modal_ID'];
		
	$return .= '<select class="image_sizes" bind="'.esc_attr($modalID).'" autocomplete="off">';
	
	if($selected == "no-selected"){
		$return .= '<option value="no-selected" selected>Choose an Image Size</option>';
	}else{
		$return .= '<option value="no-selected">Choose an Image Size</option>';
	}
	
	
	foreach($sizes as $size => $atts){
		//Remove the unlrelated image sizes.
		if($size == '' ){
			//Do Nothing	
		}else{
			//If post type is allowed in our list and not unrelated add them to select item
			if($selected == $size){
				$return .= '<option value="'.$size.'" sizes="' . implode( 'x', $atts ) .'" selected>'.$size. ' ' . implode( 'x', $atts ) .'</option>';
			}else{
				$return .= '<option value="'.$size.'" sizes="' . implode( 'x', $atts ) .'">'.$size. ' ' . implode( 'x', $atts ) .'</option>';
			}
		}
	}
	
	$return .= '</select>';
	
	$return .= '</div>';
	
	// response output
	if(isset($selected)){
		return $return;
	}else{
		echo rockthemes_escaped_out_render($return);
	}

	exit;
}

function rock_builder_get_image_sizes_ajax(){
	rock_builder_get_image_sizes();	
	exit;
}
add_action( 'wp_ajax_rockAjax_get_image_sizes', 'rock_builder_get_image_sizes_ajax' );






/*
**	Get Image IDs according to image URLs
*/

function rock_builder_get_image_ids($imageURLs = null){
	
	$images = isset($_REQUEST['imageURLs']) ? ($_REQUEST['imageURLs']) : $imageURLs;
			
	if(sizeof($images) <= 0) {echo "empty"; return;}	
	
	$returnArray = array();
	
	foreach($images as $image){
		$returnArray[] = rockthemes_get_image_id_from_url($image);
	}
		
	echo json_encode($returnArray);
		
	exit;
}

function rock_builder_get_image_ids_ajax(){
	rock_builder_get_image_ids();	
	exit;
}
add_action( 'wp_ajax_rockAjax_get_image_ids', 'rock_builder_get_image_ids_ajax' );






/*
**	Get All Registered Sidebars
*/

function rock_builder_get_sidebar_list($selected=null, $echo_value=false, $header = null){
	global $wp_registered_sidebars;
	
	$return = '';
	
	if(isset($_REQUEST['header'])) $return .= '<h4>'.esc_html($_REQUEST['header']).'</h4>';
	if(isset($header)) $return .= '<h4>'.esc_html($header).'</h4>';
	
	$emptyReturn = '<p>No sidebar found</p>';
	
	if(!$wp_registered_sidebars || !is_array($wp_registered_sidebars) || sizeof($wp_registered_sidebars) <= 0) return $emptyReturn;
	
	$echo = isset($_REQUEST['echo_value']) ? true : $echo_value;
	
	$return = '<select class="sidebar-list-select" autocomplete="off">';
	
	foreach($wp_registered_sidebars as $sidebar){
		if($sidebar['id'] === $selected){
			$return .= '<option value="'.$sidebar['id'].'" selected>'.$sidebar['name'].'</option>';
		}else{
			$return .= '<option value="'.$sidebar['id'].'">'.$sidebar['name'].'</option>';
		}
	}
	
	$return .= '</select>';
	
	if($echo){
		echo rockthemes_escaped_out_render($return);
	}else{
		return $return;	
	}
		
	exit;
}

function rock_builder_get_sidebar_list_ajax(){
	rock_builder_get_sidebar_list();	
	exit;
}
add_action( 'wp_ajax_rockAjax_get_sidebar_list', 'rock_builder_get_sidebar_list_ajax' );



/*
**	Get all post types for Linking
*/

function rock_builder_get_linkposts_cats($selected = null, $modal_ID = null, $header=null) {
	
	$post_types = get_post_types(array('_builtin'=>false));
			
	//if(sizeof($post_types) <= 0) {echo "empty"; return;}
	
	$return = '<div class="link_select_holder">';
	
	if(isset($_REQUEST['header'])) $return .= '<h4>'.esc_html($_REQUEST['header']).'</h4>';
	if(isset($header)) $return .= '<h4>'.esc_html($header).'</h4>';
	
	$modalID = isset($modal_ID) ? $modal_ID : $_REQUEST['modal_ID'];
		
	$return .= '<select class="link_select" bind="'.esc_attr($modalID).'" autocomplete="off">';
	
	if($selected == "no-selected"){
		$return .= '<option value="no-selected" selected>No Link</option>';
	}else{
		$return .= '<option value="no-selected">No Link</option>';
	}
	
	if($selected == "custom-link"){
		$return .= '<option value="custom-link" selected>Custom Link</option>';
	}else{
		$return .= '<option value="custom-link">Custom Link</option>';
	}
	
	$return .= '<optgroup label="Single Entry">';
	
	if($selected == 'post'){
		$return .= '<option value="post" is_page="yes" selected>post</option>';
	}else{
		$return .= '<option value="post" is_page="yes">post</option>';
	}
	
	if($selected == 'page'){
		$return .= '<option value="page" is_page="yes" selected>page</option>';
	}else{
		$return .= '<option value="page" is_page="yes">page</option>';
	}
	
	foreach($post_types as $type){
		//Remove the unlrelated post types.
		if($type == 'product_variation'
		   || $type == 'shop_order'
		   || $type == 'shop_coupon'
		   || $type == '' ){
			//Do Nothing	
		}else{
			//If post type is allowed in our list and not unrelated add them to select item
			if($selected == $type){
				$return .= '<option value="'.$type.'" is_page="yes" selected>'.$type.'</option>';
			}else{
				$return .= '<option value="'.$type.'" is_page="yes">'.$type.'</option>';
			}
		}
	}
	
	$return .= '</optgroup>';
	
	$return .= '<optgroup label="Taxonomy / Category">';
	
	$list = get_taxonomies('','objects');
	
	foreach($list as $tax){
		$return .= '<option value="'.$tax->name.'" is_page="no" '.($tax->name === $selected ? 'selected' : '').'>'.$tax->label.'</option>';
	}
	
	$return .= '</optgroup>';
	
	$return .= '</select>';
	
	$return .= '</div>';
	
	if(isset($selected)){
		return $return;
	}else{
		echo rockthemes_escaped_out_render($return);
	}

	exit;
}

function rock_builder_get_linkposts_cats_ajax(){
	rock_builder_get_linkposts_cats();
	exit;
}
add_action( 'wp_ajax_rockAjax_get_linkposts_cats', 'rock_builder_get_linkposts_cats_ajax' );

/*
	$obj 
	@category = incoming post type or taxonomy
	@selected = selected list item
	@is_page = if its a page then we will get the page list if not we will get the categories instead pages for archives
	@modal_ID = just for reference
*/

function rock_builder_get_linkposts_cats_posts($obj=null){
	if(empty($obj) && !isset($_REQUEST['data'])) return;
	if(isset($_REQUEST['data'])) $obj = $_REQUEST['data'];

	$category = $obj['category'];
	$is_page = $obj['is_page'];
	
	
	$selected = '';
	if(isset($obj['selected'])){
		
		$selected = $obj['selected'];	
		
		if($is_page === 'yes'){
			$selected = intval($selected);	
		}
	}
	
	if($category == 'page'){
		$posts = get_pages();
	}elseif($is_page == 'yes'){
		$posts = get_posts(array('post_type'=>$category, 'posts_per_page'=>-1));
	}elseif($is_page != 'yes'){
		if($category == 'category' || 
		   $category == 'post_tag' || 
		   $category == 'nav_menu' || 
		   $category == 'link_category' || 
		   $category == 'post_format'){
			$posts = get_categories(array('taxonomy'=>$category));
		}else{
			$posts = get_terms($category, array('hide_empty'=>0));
		}
	}

	$return = '';
	
	$return .= '<select class="link_select_page" autocomplete="off">';
		
	foreach($posts as $post){

		if($is_page === 'yes'){
			if($selected === $post->ID){
				$return .= '<option value="'.$post->ID.'" selected>'.$post->post_title.'</option>';
			}else{
				$return .= '<option value="'.$post->ID.'">'.$post->post_title.'</option>';
			}
		}else{
			if($selected === $post->slug){
				$return .= '<option value="'.$post->slug.'" selected>'.$post->name.'</option>';
			}else{
				$return .= '<option value="'.$post->slug.'">'.$post->name.'</option>';
			}
		}
	}
	
	$return .= '</select>';
	
	return $return;
}


function rock_builder_get_linkposts_cats_posts_ajax(){
	echo rock_builder_get_linkposts_cats_posts();
	exit;
}
add_action( 'wp_ajax_rockAjax_get_linkposts_cats_posts', 'rock_builder_get_linkposts_cats_posts_ajax' );













/*
**	Animation Classes based on animate.css
**
**	This function will generate a select (dropdown) element with all used animations.
**
**	@param	:	$selected:String	selected animation
**	@return	:	Returns a select element of animation classes
*/
function rock_builder_get_animation_classes($selected = ''){
	
	$return = '';
	
	$classes = array(
		array('name' => 'None', 'class' => ''),
		array('name' => 'To Left', 'class' => 'fadeInRight'),
		array('name' => 'To Right', 'class' => 'fadeInLeft'),
		array('name' => 'To Top', 'class' => 'fadeInUp'),
		array('name' => 'To Top Big', 'class' => 'fadeInUpBig'),
		array('name' => 'To Bottom', 'class' => 'fadeInDown'),
		array('name' => 'Alpha', 'class' => 'fadeIn'),
	);
	
	$return = '<select class="animation_type">';
	
	foreach($classes as $class){
		$return .= '<option value="'.$class['class'].'" '.($class['class'] === $selected ? 'selected="selected"' : '').'>'.$class['name'].'</option>';
	}
	
	$return .= '</select>';
	
	return $return;
		
}




/*
**	Parallax Models
**
**	This function will generate a select (dropdown) element with all parallax models.
**
**	@param	:	$selected:String	selected parallax model
**	@return	:	Returns a select element of parallax models
*/
function rock_builder_get_parallax_models($selected = ''){
	
	$return = '';
	
	$classes = array(
		array('name' => 'Fixed Parallax (Height Specific)', 'class' => 'height_specific'),
		array('name' => 'Advanced Parallax', 'class' => 'advanced_parallax'),
	);
	
	$return = '<select class="parallax_model">';
	
	foreach($classes as $class){
		$return .= '<option value="'.$class['class'].'" '.($class['class'] === $selected ? 'selected="selected"' : '').'>'.$class['name'].'</option>';
	}
	
	$return .= '</select>';
	
	return $return;
		
}







/*
**	Columns Grid Large
*/

function rock_builder_get_columns_grid_large_list($selected=''){
	$return = '';
	
	$return .= '<select class="columns_grid_large autocomplete="off"">';
	
	for($i = 1; $i<13; $i++){
		$return .= '<option value="'.$i.'" '.(intval($selected) == $i ? 'selected="selected"' : '').'>'.$i.' Columns</option>';
	}
	
	$return .= '</select>';
	
	return $return;

};

function rock_builder_get_columns_grid_large_list_ajax(){
	echo rock_builder_get_columns_grid_large_list();
	exit;
}
add_action('wp_ajax_get_columns_grid_large_list','rock_builder_get_columns_grid_large_list_ajax');


/*
**	Columns Grid Medium
*/

function rock_builder_get_columns_grid_medium_list($selected=''){
	$return = '';
	
	$return .= '<select class="columns_grid_medium autocomplete="off"">';
	
	for($i = 1; $i<13; $i++){
		$return .= '<option value="'.$i.'" '.(intval($selected) == $i ? 'selected="selected"' : '').'>'.$i.' Columns</option>';
	}
	
	$return .= '</select>';
	
	return $return;

};

function rock_builder_get_columns_grid_medium_list_ajax(){
	echo rock_builder_get_columns_grid_medium_list();
	exit;
}
add_action('wp_ajax_get_columns_grid_medium_list','rock_builder_get_columns_grid_medium_list_ajax');



/*
**	Columns Grid Small
*/

function rock_builder_get_columns_grid_small_list($selected=''){
	$return = '';
	
	$return .= '<select class="columns_grid_small autocomplete="off"">';
	
	for($i = 1; $i<13; $i++){
		$return .= '<option value="'.$i.'" '.(intval($selected) == $i ? 'selected="selected"' : '').'>'.$i.' Columns</option>';
	}
	
	$return .= '</select>';
	
	return $return;

};

function rock_builder_get_columns_grid_small_list_ajax(){
	echo rock_builder_get_columns_grid_small_list();
	exit;
}
add_action('wp_ajax_get_columns_grid_small_list','rock_builder_get_columns_grid_small_list_ajax');



/*
**	Columns Grids List 
**	Contains : Large, Medium and Small Columns
**
**	Returns builder element with list.
*/

function rock_builder_get_columns_grid_list($selectedLarge='',$selectedMedium='',$selectedSmall=''){
	//Set default values if no value entered
	$selectedLarge = $selectedLarge !== '' ? $selectedLarge : 4;
	$selectedMedium = $selectedMedium !== '' ? $selectedMedium : 2;
	$selectedSmall = $selectedSmall !== '' ? $selectedSmall : 1;
	
	$return = '';
	
	//Large Block Grid
	$return .= '						
		<div class="row-fluid">
			<div class="span6">
				'.rock_builder_get_columns_grid_large_list($selectedLarge).'
			</div>
			<div class="span6">
				<strong>Columns Large (Only bigger than 768px) - Desktop Screen</strong></br>
				<p>You can choose 1 - 12 columns for each row. If you choose 3 columns, system will show 4 in a row. ( 12 / 3 = 4) </p>
			</div>
		</div>
		<hr/>
	';
	
	//Medium Block Grid
	$return .= '						
		<div class="row-fluid">
			<div class="span6">
				'.rock_builder_get_columns_grid_medium_list($selectedMedium).'
			</div>
			<div class="span6">
				<strong>Columns Medium (Only smaller than 768px and bigger than '.$rock_page_builder_config['settings']['small_block_size'].'px) - Tablet Screen</strong></br>
				<p>You can choose 1 - 12 columns for each row. If you choose 3 columns, system will show 4 in a row. ( 12 / 3 = 4) </p>
			</div>
		</div>
		<hr/>
	';
	
	//Small Block Grid
	$return .= '						
		<div class="row-fluid">
			<div class="span6">
				'.rock_builder_get_columns_grid_small_list($selectedSmall).'
			</div>
			<div class="span6">
				<strong>Columns Small (Only smaller than '.$rock_page_builder_config['settings']['small_block_size'].'px) - Mobile Screen</strong></br>
				<p>You can choose 1 - 12 columns for each row. If you choose 3 columns, system will show 4 in a row. ( 12 / 3 = 4) </p>
			</div>
		</div>
		<hr/>
	';
		
	return $return;

};

function rock_builder_get_columns_grid_list_ajax(){
	echo rock_builder_get_columns_grid_list();
	exit;
}
add_action('wp_ajax_get_columns_grid_list','rock_builder_get_columns_grid_list_ajax');








/*
**	Block Grid Large
*/

function rock_builder_get_block_grid_large_list($selected=''){
	$return = '';
	
	$return .= '<select class="block_grid_large autocomplete="off"">';
	
	for($i = 1; $i<13; $i++){
		$return .= '<option value="'.$i.'" '.(intval($selected) == $i ? 'selected="selected"' : '').'>'.$i.' Block</option>';
	}
	
	$return .= '</select>';
	
	return $return;

};

function rock_builder_get_block_grid_large_list_ajax(){
	echo rock_builder_get_block_grid_large_list();
	exit;
}
add_action('wp_ajax_get_block_grid_large_list','rock_builder_get_block_grid_large_list_ajax');


/*
**	Block Grid Medium
*/

function rock_builder_get_block_grid_medium_list($selected=''){
	$return = '';
	
	$return .= '<select class="block_grid_medium autocomplete="off"">';
	
	for($i = 1; $i<13; $i++){
		$return .= '<option value="'.$i.'" '.(intval($selected) == $i ? 'selected="selected"' : '').'>'.$i.' Block</option>';
	}
	
	$return .= '</select>';
	
	return $return;

};

function rock_builder_get_block_grid_medium_list_ajax(){
	echo rock_builder_get_block_grid_medium_list();
	exit;
}
add_action('wp_ajax_get_block_grid_medium_list','rock_builder_get_block_grid_medium_list_ajax');



/*
**	Block Grid Small
*/

function rock_builder_get_block_grid_small_list($selected=''){
	$return = '';
	
	$return .= '<select class="block_grid_small autocomplete="off"">';
	
	for($i = 1; $i<13; $i++){
		$return .= '<option value="'.$i.'" '.(intval($selected) == $i ? 'selected="selected"' : '').'>'.$i.' Block</option>';
	}
	
	$return .= '</select>';
	
	return $return;

};

function rock_builder_get_block_grid_small_list_ajax(){
	echo rock_builder_get_block_grid_small_list();
	exit;
}
add_action('wp_ajax_get_block_grid_small_list','rock_builder_get_block_grid_small_list_ajax');



/*
**	Block Grids List 
**	Contains : Large, Medium and Small Block Grids
**
**	Returns builder element with list.
*/

function rock_builder_get_block_grid_list($selectedLarge='',$selectedMedium='',$selectedSmall=''){
	global $rock_page_builder_config;
	//Set default values if no value entered
	$selectedLarge = $selectedLarge !== '' ? $selectedLarge : 4;
	$selectedMedium = $selectedMedium !== '' ? $selectedMedium : 2;
	$selectedSmall = $selectedSmall !== '' ? $selectedSmall : 1;
	
	
	$conf_medium_size = ((int)$rock_page_builder_config['settings']['medium_block_size']) + 1;//+ 1 for explanation field only
	$conf_small_size = $rock_page_builder_config['settings']['small_block_size'];
	
	$return = '';
	
	//Large Block Grid
	$return .= '						
		<div class="row-fluid">
			<div class="span6">
				'.rock_builder_get_block_grid_large_list($selectedLarge).'
			</div>
			<div class="span6">
				<strong>Blocks Large (Only bigger than '.$conf_medium_size.'px) - Desktop Screen</strong></br>
				<p>You can choose 1 - 12 block for each row. If you set to 6 system will show 6 images per row.</p>
			</div>
		</div>
		<hr/>
	';
	
	//Medium Block Grid
	$return .= '						
		<div class="row-fluid">
			<div class="span6">
				'.rock_builder_get_block_grid_medium_list($selectedMedium).'
			</div>
			<div class="span6">
				<strong>Blocks Medium (Only smaller than '.$conf_medium_size.'px and bigger than '.$conf_small_size.'px) - Tablet Screen</strong></br>
				<p>You can choose 1 - 12 block for each row. If you set to 6 system will show 6 images per row.</p>
			</div>
		</div>
		<hr/>
	';
	
	//Small Block Grid
	$return .= '						
		<div class="row-fluid">
			<div class="span6">
				'.rock_builder_get_block_grid_small_list($selectedSmall).'
			</div>
			<div class="span6">
				<strong>Blocks Small (Only smaller than '.$conf_small_size.'px) - Mobile Screen</strong></br>
				<p>You can choose 1 - 12 block for each row. If you set to 6 system will show 6 images per row.</p>
			</div>
		</div>
		<hr/>
	';
		
	return $return;

};

function rock_builder_get_block_grid_list_ajax(){
	echo rock_builder_get_block_grid_list();
	exit;
}
add_action('wp_ajax_get_block_grid_list','rock_builder_get_block_grid_list_ajax');




/*
**	Get Chosen Small and Medium Block Grid
*/

function rock_builder_get_chosen_small_block_grid(){
	if(function_exists('xr_get_option')) {return intval(xr_get_option('small_block_grid','2'));}
	return '';
}
function rock_builder_get_chosen_medium_block_grid(){
	if(function_exists('xr_get_option')) {return intal(xr_get_option('medium_block_grid','3'));}
	return '';
}


/*
**	Get Chosen Block Grid Class (Contains small and medium block grids
**	return	: string with class names
*/
if(!function_exists('rock_builder_get_small_medium_block_grid_class')):
function rock_builder_get_small_medium_block_grid_class(){
	return 	'small-block-grid-'.rock_builder_get_chosen_small_block_grid().
			' medium-block-grid-'.rock_builder_get_chosen_medium_block_grid().' ';
}
endif;










/*
**	Rockthemes Portfolio Excerpt / Title Option
**	@return : A select (dropdown) HTML element with options
*/
function rockthemes_excerpt_title_option($selected=''){
	$return = '';
	
	$return .= '
		<select class="excerpt_title_option">
			<option value="no_description" '.($selected == 'no_description' ? 'selected="selected"' : '').'>No Description</option>
			<option value="title" '.($selected == 'title' ? 'selected="selected"' : '').'>Only Title</option>
			<option value="excerpt" '.($selected == 'excerpt' ? 'selected="selected"' : '').'>Only Excerpt</option>
			<option value="cats" '.($selected == 'cats' ? 'selected="selected"' : '').'>Only Categories</option>
			<option value="title_excerpt" '.($selected == 'title_excerpt' ? 'selected="selected"' : '').'>Title and Excerpt</option>
			<option value="title_cats" '.($selected == 'title_cats' ? 'selected="selected"' : '').'>Title and Categories</option>
			<option value="cats_excerpt" '.($selected == 'cats_excerpt' ? 'selected="selected"' : '').'>Categories and Excerpt</option>
			<option value="title_cats_excerpt" '.($selected == 'title_cats_excerpt' ? 'selected="selected"' : '').'>Title, Categories and Excerpt</option>
	';
	
	//Check if WooCommerce is activated
	//WooCommerce currently disabled for better visualization
	if(rockthemes_woocommerce_active() && 1==0){
		$return .= '
			<option value="price" '.($selected == 'price' ? 'selected="selected"' : '').'>Only Price</option>
			<option value="title_price" '.($selected == 'title_price' ? 'selected="selected"' : '').'>Title and Price</option>
			<option value="excerpt_price" '.($selected == 'excerpt_price' ? 'selected="selected"' : '').'>Excerpt and Price</option>
			<option value="title_excerpt_price" '.($selected == 'title_excerpt_price' ? 'selected="selected"' : '').'>Title, Excerpt and Price</option>
		';	
	}
	
	$return .= '</select>';
	
	return $return;
}



if(!function_exists('rockthemes_excerpt')):
/*
**	Rockthemes Custom Excerpt Length
**
**	@param $excerpt		:	Originial Excerpt text.
**	@param $length		:	Custom word length for the excerpt. (Not character length, word length uses spaces)
**	@return : excerpt string sliced with spaces
**
**	@since				:	1.0
*/
function rockthemes_excerpt($excerpt='',$length=10){
	$excerpt = explode(' ',$excerpt, ($length + 1));
	
	if (count($excerpt)>=$length) {
		array_pop($excerpt);
		$excerpt = implode(" ",$excerpt);
	} else {
		$excerpt = implode(" ",$excerpt);
	} 
	
	$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
	return $excerpt;
}
endif;



/*
**	Some of our special elements allow you to choose different image size. This function will
**	retrive the "image id" according to the image url. This function is also 
**	located in the "functions.php" file in the theme.
**
**	@param	:	$image_url:String	URL of the image to get id from
**	@return	:	$attachment[0]:String	ID of the image
*/

/*
if(!function_exists('rockthemes_get_image_id_from_url')):
function rockthemes_get_image_id_from_url($image_url) {
	global $wpdb;
	$prefix = $wpdb->prefix;
	
	if(!is_string($image_url)) return;
	
	$image_url = $wpdb->esc_like(esc_url($image_url));
	$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM " . $prefix . "posts" . " WHERE guid='%s';", $image_url )); 
	
	if(!empty($attachment) && $attachment[0]){
        return $attachment[0]; 
	}else{
		$new_image_url = '';
		
		if(strpos($image_url, 'https') > -1){
			$new_image_url = str_replace('https', 'http', $image_url);
		}elseif(strpos($image_url, 'http') > -1){
			$new_image_url = str_replace('http', 'https', $image_url);
		}

		$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM " . $prefix . "posts" . " WHERE guid='%s';", $new_image_url)); 

		if(!empty($attachment) && $attachment[0]){
        		return $attachment[0]; 
		}	

	}
	return '';
}
endif;
*/



if(!function_exists('rock_check_p')):
/*
**	To use TinyMCE in full power, we check if the string wrapped with "<p>" tags correctly. This function is also 
**	located in the "functions.php" file in the theme.
**
**	@param	:	$string:String	String to check if wrapped correctly
**	@return	:	$string:String	String wrapped with "<p>" tags
*/
function rock_check_p($string){
	return wpautop($string);
	
	if(substr($string,0,2) != '<p') return '<p>'.$string.'</p>';
	return $string;
}
endif;











function rockthemes_fb_get_references_list($selected=null, $modal_ID = null, $echo = true){
	
	$form_builder_references = get_option('rockthemes_fb_references', array());
	
	
	$return = '';
	
	if(!empty($form_builder_references)){
	
	$return .= '<select class="rockthemes_fb_list">';
	
	foreach($form_builder_references as $ref){
		if($selected == $ref['shortcode']){
			$return .= '<option value="'.esc_attr(htmlentities($ref['shortcode'])).'" selected>'.esc_html($ref['name']).'</option>';
		}else{
			$return .= '<option value="'.esc_attr(htmlentities($ref['shortcode'])).'">'.esc_html($ref['name']).'</option>';
		}
	}
	
	$return .= '</select>';
	
	}else{
		
		$return .= 'No Rock Form Found!';
			
	}
	
	if($echo){
		echo rockthemes_escaped_out_render($return);
	}else{
		return $return;
	}
	
	exit;
}




if(!function_exists('rpb_filtered_content')):
function rpb_filtered_content( $value = '' ) {
	global $wp_filter, $merged_filters;
	
	$tag = 'the_content';
	$removed_filters = array('rockthemes_pb_wp_content_filter');

	$args = array();

	// Do 'all' actions first.
	if ( isset($wp_filter['all']) ) {
		$args = func_get_args();
		_wp_call_all_hook($args);
	}

	if ( !isset($wp_filter[$tag]) ) {
		return $value;
	}

	//WordPress 4.7 WP_Hook Class
	if ( class_exists( 'WP_Hook' ) ) {
		$filter = $wp_filter[ $tag ]->callbacks;
	}else{
		$filter = &$wp_filter[ $tag ];
		// Sort.
		if ( !isset( $merged_filters[ $tag ] ) ) {
			ksort($wp_filter[$tag]);
			$merged_filters[ $tag ] = true;
		}
	}

	reset( $filter );

	if ( empty($args) )
		$args = func_get_args();

	do {
		foreach( (array) current($filter) as $the_ )
			if ( !is_null($the_['function']) && !in_array($the_['function'], $removed_filters) ){
				$args[1] = $value;
				$value = call_user_func_array($the_['function'], array_slice($args, 1, (int) $the_['accepted_args']));
			}

	} while ( next($filter) !== false );


	return $value;

}
endif;




/*
**	Ratio List. Generates an HTML list element for ratios
**	
**	@param	:	$selected String - Selected element value
**	@param	:	$class_name	String - Class name for selector
**	@return	:	returns HTML list element 
**
**	@since	:	1.3
*/
function rockthemes_pb_ratio_list($selected = '', $class_name = 'ratio_list'){
	
	//You can extend the ratio list just by adding a new key => value here
	$lists = array(
		'16_9'	=>	'16 : 9',
		'16_5'	=>	'16 : 5',
		'4_3'	=>	'4 : 3',
		'3_2'	=>	'3 : 2',
	);	
	
	$class_name = $class_name != '' ? $class_name : 'ratio_list';
	
	if(count($lists) < 1) return '';
	
	
	$return = '<select autocomplete="off" class="'.$class_name.'">';
	
	foreach($lists as $key => $val){	
		$return .= '<option value="'.$key.'" '.($selected === $key ? 'selected="selected"' : '').'>'.$val.'</option>';
	}
	
	$return .= '</select>';
	
	
	return $return;	
}











/*
**	Wordpress 3.9 resize handle fix
**
**	Wordpress 3.9 changed the resize to "false" as default. We set it to "vertical"
**	This way the "Visual" editor will contain resize handle to resize the Text Editor
**
**	@since	:	1.3
*/
function rockthemes_pb_tinymce_before_init($settings){
	$settings['resize'] = 'vertical';
	return $settings;
}

add_filter('tiny_mce_before_init','rockthemes_pb_tinymce_before_init');





/*
**	Generates a linear gradient background to split screen.
**
**	@since	:	1.3
*/
function rockthemes_make_split_bg_color($bg1='#f9f9f9', $bg2='#f9f9f9', $bg3='#f9f9f9'){
	
	if(!isset($bg1) || !isset($bg2)) return '';
	$bg1 = esc_attr($bg1);
	$bg2 = esc_attr($bg2);
	
	
	$bg = '
		background: '.$bg1.';
		background: -moz-linear-gradient(left, '.$bg1.' 50%, '.$bg2.' 50%);
		background: -webkit-gradient(linear, left top, right top, color-stop(50%,'.$bg1.'), color-stop(50%,'.$bg2.'));
		background: -webkit-linear-gradient(left, '.$bg1.' 50%,'.$bg2.' 50%);
		background: -o-linear-gradient(left, '.$bg1.' 50%,'.$bg2.' 50%);
		background: -ms-linear-gradient(left, '.$bg1.' 50%,'.$bg2.' 50%); 
		background: linear-gradient(to right, '.$bg1.' 50%,'.$bg2.' 50%); 
	';
	return $bg;
}





/*
**	General function to turn hex to rbga. Also exists in options_loader.php file
**
**	@since	:	1.3
*/
if(!function_exists('rockthemes_hex2rgba')):
function rockthemes_hex2rgba($hex, $opacity = 1) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return implode(",", $rgb).','.$opacity; // returns the rgb values separated by commas
   //return $rgb; // returns an array with the rgb values
}
endif;










/* ########################################################################################################
**
**					ADMIN UI	
**
** ########################################################################################################
*/


/*
**	Builds a modal section for image sizes.
**
**	@atts	:	array(
		$modal_id	: String, ID of the modal to bind
		$class		: String, class for selector				
		$calc		: Boolean, Calculate columns for this modal
		$default	: String, Selected element
		$title		: Title for html
		$desc		: Description for html
		$hr			: Boolean, To add hr under the field
**	)
*/
function rpb_admin_el_select_image_size($atts = array()){	
	if(empty($atts)) return '';
	
	$defaults = array(
		'modal_id'	=>	'',
		'class'		=>	'image_sizes_column',
		'calc'		=>	true,
		'default'	=>	'',
		'title'		=>	'Select Image Size',
		'desc'		=>	'Select an image size for this element.',
		'hr'		=>	true
	);
	
	extract(array_merge($defaults, $atts));
	
	$return = '
		<div class="row-fluid">
			<div class="span6 '.(isset($class) ? esc_attr($class) : '').'" '.(isset($modal_id) ? 'bind="'.esc_attr($modal_id).'"' : '').' '.(isset($calc) && $calc === true ? 'calc="true"' : '').'>
				'.rock_builder_get_image_sizes($default, $modal_id, '').'
			</div>
			<div class="span6">
				<strong>'.esc_attr($title).'</strong><br/>
				<p>'.esc_attr($desc).'</p>
			</div>
		</div>
		'.($hr === true ? '<hr/>' : '').'
	';
	
	return $return;
}




/*
**	This funciton checks if the current user got required level to use RPB
**
**	@return	:	Boolean; true, if user can user RPB
**
**	@since	:	2.0
*/
if(!function_exists('rpb_is_admin')):
function rpb_is_admin(){
	$user_do = function_exists('xr_get_option') ? esc_attr(xr_get_option('user_ableto_rpb', 'delete_pages')) : 'delete_pages';
	return current_user_can($user_do) === true ? true : false;
}
endif;





/*
**	Transfer Item Button
**
**
*/
if(!function_exists('rock_builder_item_trans_btn')){
	function rock_builder_item_trans_btn($attr){
		if(!defined('RPB_ELEM_TRANSFER') || !isset($attr) || !isset($attr['type'])) return '';
		
		$return = '<div class="rpb_modal-header-rightside"><a class="rock-builder-element-transfer" data-elem_type="'.$attr['type'].'"><i class="fa fa-magic"></i> Export Element</a> | </div>';
		return $return;
	}
}






function rpb_wr2x_get_retina($url=''){
	
	if(!function_exists('wr2x_get_pathinfo_from_image_src') ||
		!function_exists('wr2x_get_wordpress_upload_root') ||
		!function_exists('wr2x_get_retina') ||
		!function_exists('wr2x_cdn_this') ||
		!function_exists('wr2x_from_system_to_url') ){
		
		//Retina plugin is not activated
		return false;
	}
	
	$img_pathinfo = wr2x_get_pathinfo_from_image_src( $url);
	$filepath = trailingslashit( wr2x_get_wordpress_upload_root() ) . $img_pathinfo;
	
	// Those comments were added to help the BedRock user to find a solution to their issue
	// Please refrain to modify the current function, instead try to modify wr2x_get_wordpress_upload_root
	// error_log( "From URL: " . $element->src );
	// error_log( "We build wr2x_get_wordpress_upload_root + wr2x_get_pathinfo_from_image_src" );
	// error_log( wr2x_get_wordpress_upload_root() . " + " . wr2x_get_pathinfo_from_image_src( $element->src ) );
	// error_log( "Result is filepath : " . $filepath );
	
	$potential_retina = wr2x_get_retina( $filepath );
	if ( $potential_retina != null ) {
		$retina_url = wr2x_cdn_this( wr2x_from_system_to_url( $potential_retina ) );
		if(is_string($retina_url)){
			return $retina_url;	
		}
	}
	
	return false;
}






?>