<?php
/*
**	Rock Page Builder Full Shortcode
**
**	Alias	:	Rock Builder UI		Located in "rock-builder/rock-builder-ui.php"
**	Alias	:	Rock Builder		Located in "rock-builder/rock-builder.php"
**	Author	:	Rockthemes.net
**	License	:	Contact to rockthemes.net for further information
**	Version	:	2.0
**
*/


function rpb_be_parse_to_full_shortcode($val,$nosidebar_content = 'false'){	
	//return if no value entered or the value is not an array
	if((!isset($val) && !is_array($val)) || empty($val) || $val === '') return;
		
	foreach ($val as $key => $value) {

		$col[$key] = $value['col'];
		
		$row[$key] = $value['row'];
	
	}
	
	array_multisort($row, $col, $val);
	
	$cols_in_row	=	1;
	$total_cols		=	12;
	$row_enabled	=	false;
	$last_row		=	0;
	$remove_rows	=	false;//When full width grids added, we will remove grids.
	$full_width_sg_list	=	array(
		'full_width_screen_slider',
		'full_width_slider'
	);
		
	/*
	**	Full Shortcodes will be stored in this variable.
	**	
	**
	*/
	$full_shortcode = '';
	
	foreach($val as $grid){
		
		$only_sgrid = false;
		
		if($last_row < intval($grid['row'])){
			if($row_enabled){
				
				if($cols_in_row < 12 && $cols_in_row !== 0){
					$full_shortcode .= '[rpb_columns large="'.(13 - $cols_in_row).'" medium="'.(13 - $cols_in_row).'"][/rpb_columns]';
				}
				
				if(!$remove_rows){
					$full_shortcode .= '[/rpb_row]';
					$row_enabled = false;
				}
			}
		}
		
		if($last_row < intval($grid['row'])){
			$cols_in_row = intval($grid['size_x']) + (intval($grid['col']) - 1);
			$offset = (intval($grid['col']) - 1);
		}else{
			$offset = intval($grid['col']) - 1 - $cols_in_row;
			$cols_in_row += $offset + intval($grid['size_x']);
		}
		
		
				
		$grid_cols = 'large="'.$grid['size_x'].'" medium="'.$grid['size_x'].'" r="'.$grid['row'].'" '.((intval($offset) !== 0 ) ? 'c="'.$offset.'"' : '');
				
		//Special Grid
		if($grid['special_grid_block'] == 'yes'){
			
			//Start the special grid
			if($grid['special_grid_block_open'] == 'yes'){
				
				/*
				**	Special grids don't have contents init. So we set this to true, to skip this turn
				*/
				$only_sgrid = true;
				
				/*
				**	sgs = special grid shortcode
				*/
				$sgs = $grid['shortcode'];
				
				/*
				**	Default shortcode does not contain columsn details. We need these details for
				**	setting our backend grid.
				*/
				$sgs = str_replace(']', ' '.$grid_cols.']', $sgs);
				
				
				/*
				**	Double Background Color feature was missing from shortcode. We will add it
				**	by extending the shortcode
				*/
				if(isset($grid['grid_data']['data']['data']['enable_double_bg_colors'])){
					$double_bg_extend = 'enable_double_bg_colors="'.$grid['grid_data']['data']['data']['enable_double_bg_colors'].'" ';
					$double_bg_extend .= 'double_bg_color="'.$grid['grid_data']['data']['data']['double_bg_color'].'"';
					$sgs = str_replace(']', ' '.$double_bg_extend.']', $sgs);
				}
				
				/*
				**	Javascript makes the shortcode by using the old "rockthemes_specialgridblock" 
				**	shortcode name. We have replaced it with "rpb_sgrid"
				*/
				$sgs = str_replace('rockthemes_specialgridblock', 'rpb_sgrid', $sgs);
				
				
				/*
				**	If we are using full width grids, we will not add rows and remove them. Because
				**	full width Special Grids, adds row.collapse automatically.
				*/
				if(in_array($grid['grid_data']['data']['data']['grid_special_width_details'], $full_width_sg_list)){
					$remove_rows = true;
				}
				
				$sgrid_shortcode = $sgs;
			
			}else{
				
				/*
				**	Special grids don't have contents init. So we set this to true, to skip this turn
				*/
				$only_sgrid = true;


				$sgs = $grid['shortcode'];	
				/*
				**	Javascript makes the shortcode by using the old "rockthemes_specialgridblock" 
				**	shortcode name. We have replaced it with "rpb_sgrid"
				*/
				$sgs = str_replace('rockthemes_specialgridblock', 'rpb_sgrid', $sgs);
								
				
				/*
				**	If we are using full width grids, we have removed the rows. Now the Special Grid
				**	tag closed. So we can start the rows again.
				*/
				$remove_rows = false;
				
				$sgrid_shortcode = $sgs;
				
			}
			
		}else{
						
			$grid_shortcode_start = '[rpb_columns '.$grid_cols.' animation_type="'.$grid['grid_data']['data']['data']['animation_type'].'" animation_delay_time="'.$grid['grid_data']['data']['data']['animation_delay_time'].'"]';
			
			$grid_shortcode_end = '[/rpb_columns]';
		
		}
		
		
		if($only_sgrid){
			
			$full_shortcode .= $sgrid_shortcode;
			
			continue;
			
		}
		
		if($last_row < intval($grid['row']) && !$row_enabled && !$remove_rows){
			$full_shortcode .= '[rpb_row]';
			$row_enabled = true;			
		}
						
		$full_shortcode .= $grid_shortcode_start;
		
		
		if(isset($grid['elems'])){
			
			foreach($grid['elems'] as $elem){

				$full_shortcode .= makeObjectWithDetails($elem);

			}
	
		}
		
		$full_shortcode .= $grid_shortcode_end;
		
		$last_row = intval($grid['row']);
		
	}
	
	
	if($row_enabled){
		$full_shortcode .= '[/rpb_row]';
		$row_enabled = false;	
	}
	
		
	return $full_shortcode;
		
}









?>