<?php

/*
**	Rock Page Builder Database Updater
**
**	Alias	:	Rock Builder UI		Located in "rock-builder/builder-functions.php"
**	Alias	:	Rock Builder		Located in "rock-builder/rock-builder-ui.php"
**	Author	:	Rockthemes.net
**	License	:	Contact to rockthemes.net for further information
**	Version	:	2.0
**
**	Databse Updater of Rock Page Builder
*/

defined( 'ABSPATH' ) or die( 'Not Allowed' );




function rpb_be_data_update_notice() {
	if(isset($_GET['start']) && $_GET['start'] == 'true' && current_user_can(xr_get_option('user_ableto_rpb', 'delete_pages'))) {
		$update = rpb_be_database_updater_function();
		
		if($update){
			//main action group
			echo '<div class="updated">
					<h3>Rock Page Builder Version '.RPB_BE_VERSION.' Database Updated</h3>
					<p>You have updated the Rock Page Builder version '.RPB_BE_VERSION.' database.</p>
				</div>';
			
			update_option('rpb_be_requires_db_update','no');
			delete_option('rpb_be_requires_db_update');
			update_option('_rpb_be_version', RPB_BE_VERSION);
			
		}else{
			//main action group
			echo '<div class="error">
					<h3>An Error Occured</h3>
					<p>An error occured during the Rock Page Builder version '.RPB_BE_VERSION.' database update. Try again.</p>
				</div>';
		}
		
		return;
	}	
	
	
	$class = "update-nag";
	echo '<div class="'.$class.'">
			<h3>!Attention : Rock Page Builder Version '.RPB_BE_VERSION.' Requires Database Update</h3>
			<p>You have just updated the Rock Page Builder. Your new version '.RPB_BE_VERSION.' requires a database update. It should all work smoothly, but we advise getting a database backup before running the update.</p>
			<p><a href="'.admin_url('options-general.php?page=rpb_be_database_updater').'">Run Database Updater</a></p>
		</div>'; 
}
add_action('admin_notices', 'rpb_be_data_update_notice'); 






function rpb_be_run_data_updater_menu(){
	add_submenu_page('options-general.php', 
					'Rock Page Builder Databse Updater', 
					'RPB Update', 
					xr_get_option('user_ableto_rpb', 'delete_pages'), 
					'rpb_be_database_updater', 
					'rpb_be_database_updater_ui' );
}
add_action('admin_menu', 'rpb_be_run_data_updater_menu');




function rpb_be_database_updater_ui(){
	
	echo '<div class="wrap"><div id="icon-tools" class="icon32"></div>';
		echo '<h2>Rock Page Builder Database Updater</h2>';
		echo '<p>You have just updated the Rock Page Builder. Your new version '.RPB_BE_VERSION.' requires a database update. It should all work smoothly, but we advise getting a database backup before running the update. Click on the Start Updater button below to start database update. ';
		
		echo '<form action="'.admin_url('options-general.php?page=rpb_be_database_updater').'&start=true" method="post">';
		echo '<input type="hidden" name="rpb_be_start_db_update" id="rpb_be_start_db_update" value="yes" />';
		submit_button( 'Start Updater', 'primary');
		echo '</form>';
	echo '</div>';
}




function rpb_be_database_updater_function(){
	global $allowedposttags;
	
	//Extend Allowed tags with Special Grid tags
	$allowedposttags['div']['data-animation-class'] = true;
	$allowedposttags['div']['data-animation-delay-time'] = true;
	$allowedposttags['div']['data-rsb-fullscreen'] = true;
	$allowedposttags['div']['data-overlay-color'] = true;
	$allowedposttags['div']['data-parallax-model'] = true;
	$allowedposttags['div']['data-parallax-bg-image'] = true;
	$allowedposttags['div']['data-parallax-bg-image-retina'] = true;
	$allowedposttags['div']['data-parallax-mask-height'] = true;
	$allowedposttags['div']['data-parallax-padding'] = true;
	$allowedposttags['div']['data-image-ratio'] = true;
	$allowedposttags['div']['data-image-tile'] = true;
	$allowedposttags['div']['data-static-bg-image'] = true;
	$allowedposttags['div']['data-static-bg-image-retina'] = true;
	$allowedposttags['div']['data-static-mask-height'] = true;
	$allowedposttags['div']['data-padding'] = true;
	$allowedposttags['div']['data-image-ratio'] = true;
	$allowedposttags['div']['data-image-tile'] = true;
	$allowedposttags['div']['data-video_bg_fallback_url'] = true;
	$allowedposttags['div']['data-rsb-ratio'] = true;
	$allowedposttags['div']['data-multibg-colors'] = true;
	$allowedposttags['video']['data-autoplay'] = true;
	
	$post_types = rpb_get_post_types();
		
	$query = new WP_Query(array('post_type'=>$post_types, 'nopaging'=>'true'));
	
	echo '<h3>Starting the database Update</h3>';
	
	if ( $query->have_posts() ) :

		while ( $query->have_posts() ) : $query->the_post();
		
			$id = $query->post->ID;
			
			$rpb_data=get_post_meta($id, '_this_r_content',true); 
			if(empty($rpb_data)) continue;//Return if it don't use RPB

			$in_use = get_post_meta($id, '_builder_in_use', false);
			if(empty($in_use) || $in_use === 'false') continue;//Return if RPB was not activated
			
			$post_content = $query->post->post_content;
			if(strpos($post_content, 'rpb_columns') !== false) continue;//Return if we already updated this

			if(defined('RPB_CONTENT_FILTER')){
				$rpb_data = preg_replace( '/\r/', '', $rpb_data);
			}else{
				$rpb_data = preg_replace( '/\r|\n/', '', $rpb_data);
			}
			$final_val = (json_decode($rpb_data, true));
				
			if(!is_array($final_val)){
				$final_val = json_decode(stripslashes($rpb_data), true);
			}
			
			if(defined('RPB_FULL_SHORTCODE')){
				$rpb_content = rpb_be_parse_to_full_shortcode($final_val);
			}
			
			
			if(defined('RPB_CONTENT_FILTER')){
				$rpb_content = preg_replace( '/\r/', '', wp_kses($rpb_content, $allowedposttags));
			}else{
				$rpb_content = preg_replace( '/\r|\n/', '', wp_kses($rpb_content, $allowedposttags));
			}
			
			wp_update_post(array('ID'=>$id, 'post_content'=>$rpb_content));	
			
			/*
			**
			**	Do not enable this.
			**
			if(isset($GLOBALS['rockthemes_frontend_inline_nav']) && count($GLOBALS['rockthemes_frontend_inline_nav']) > 0){
				update_post_meta($id, '_rockthemes_inline_nav', $GLOBALS['rockthemes_frontend_inline_nav']);	
			}
			*/
			
			echo rockthemes_escaped_out_render($query->post->post_title.' has been updated.<br/>');
			
		endwhile;

	wp_reset_postdata();

	endif;
	
	return true;
}



?>