<?php

/*
**	Rockthemes installation helper
**
**	@since	:	1.3
*/
function rockthemes_enqueue_installation_helper() {

	// Don't run on WP < 3.3
    if ( get_bloginfo( 'version' ) < '3.3' )
        return;
 
    $screen = get_current_screen();

    $current_url = "http" . ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on') ? "s://" : "://") . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	$screen_id = $screen->id;
 
    // Get pointers for this screen
    $pointers = apply_filters( 'rockthemes_admin_pointers-' . $screen_id, array() );
	$pointers = apply_filters('rockthemes_ih_steps', $pointers);
 
    if ( ! $pointers || ! is_array( $pointers ) )
        return;
 
    // Get dismissed pointers
    $dismissed = explode( ',', (string) get_user_meta( get_current_user_id(), 'dismissed_wp_pointers', true ) );
	

	/*
	**	Re-add the pointer if it's dismissed
	**
	**	TO DO	:	Will be removed
	*/
	if( in_array( 'rockthemes_ih_welcome', $dismissed ) ) {
		array_splice($dismissed, array_search('rockthemes_ih_welcome', $dismissed), 1);
	}
	
	if( in_array( 'rockthemes_ih_import_xml', $dismissed ) ) {
		array_splice($dismissed, array_search('rockthemes_ih_import_xml', $dismissed), 1);
	}
	
	
    $valid_pointers = array();
    // Check pointers and remove dismissed ones.
    foreach ( $pointers as $pointer_id => $pointer ) {

        $pointer['pointer_id'] = $pointer_id;
 
        // Add the pointer to $valid_pointers array
        $valid_pointers['pointers'][] =  $pointer;
    }
    // No valid pointers? Stop here.
    if ( empty( $valid_pointers ) )
        return;
		

	$current_pointer = 0;
	$i = 0;
	$charlen = 0;

	$valid_pointers['latest_step_was'] = get_option('rockthemes_ih_last_step', 0);
		
	foreach($valid_pointers['pointers'] as $valid){

		//Skip it if we already passed this step
		if((int)$i < (int)$valid_pointers['latest_step_was']){ $i++; continue;}
		
		if(strpos($current_url, $valid['location']) > -1 && strlen($valid['location']) > $charlen){
			$current_pointer = $i;
			$charlen = strlen($valid['location']);
			//Do not break the loop. There can be a closer match in the next step
		}
		$i++;
	}
	
	$valid_pointers['current_pointer'] = $current_pointer;
 
 	//Enqueue Wordpress icons
	wp_enqueue_style( 'dashicons' ); 
 	//Enqueue pointer script
 	wp_enqueue_script( 'wp-pointer' );
    // Add pointers style to queue.
    wp_enqueue_style( 'wp-pointer' );
 
	
	wp_enqueue_script('rockthemes-installation-helper', AZOOM_PLUGIN_URI.'/ie/rock-installation-helper.js', array('wp-pointer'));
	
    // Add pointer options to script.
    wp_localize_script( 'rockthemes-installation-helper', 'rockthemes_ih', $valid_pointers );
}
add_action( 'admin_enqueue_scripts', 'rockthemes_enqueue_installation_helper' );



function rockthemes_ih_last_step() {
	if(!is_admin()) die();
	
	if(!isset($_POST['pointer']) || !isset($_POST['steps'])) return;
	
	$rockthemes_ih_steps = $_POST['steps'];
	
	$last_step = $_POST['pointer'];
	
	if(isset($_POST['rih_finished']) && $_POST['rih_finished'] === 'yes'){
		update_option('rockthemes_ih_dismiss', 'yes');
		update_option('rockthemes_ih_last_step', 0);
		echo '';
		exit;
	}

	
	$i = 0;
	foreach($rockthemes_ih_steps['pointers'] as $val){
		$i++;
		if($val['pointer_id'] == $last_step){
			break; 
		}
	}
	
	update_option('rockthemes_ih_last_step', $i);
	
	echo $i;
	exit;	
}
add_action( 'wp_ajax_rockthemes_ih_last_step', 'rockthemes_ih_last_step' );



function rockthemes_ih_dismiss(){
	if(!is_admin()) die();
	update_option('rockthemes_ih_dismiss', 'yes');
	update_option('rockthemes_ih_last_step', 0);
	echo 0;
	exit;
}
add_action('wp_ajax_rockthemes_ih_dismiss', 'rockthemes_ih_dismiss');


/*
**	Reset values to the default. 
**
**	@since	:	1.3
*/
function rockthemes_ih_reset_all_function(){
	update_option('rockthemes_ih_dismiss', 'no');
	update_option('rockthemes_ih_last_step', 0);
}
add_action('rockthemes_ih_reset_all', 'rockthemes_ih_reset_all_function');





/*	
**	Installation helper steps
**
**	@param	:	$incoming Array, Structured array for helper steps
**	@return	:	Array, Structured array of helper steps
**
**	@since	:	1.3
*/
function rockthemes_register_installation_helpers( $incoming ) {
	global $rockthemes_globals;	
	/*
	Old and not used. We use One Click Installer 
	$rockthemes_ih_steps = array(
		
		'rockthemes_ih_import_xml'	=>	array(
			'target' => '#general_settings_button',
			'location' => admin_url('themes.php?page=rock_options'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Welcome to Azoom' ,'azoom'),
					__( 'You have successfully installed Azoom. This helper will guide you through importing XML data and theme demo datas. You can easily follow our steps. If you already know how to do the rest, you can dismiss this helper','azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'Importing XML Data',
					'link'	=>	admin_url( 'admin.php?import=wordpress' )
				)
			)
		),
		
		'rockthemes_ih_import_xml_file_browse'	=>	array(
			'target' => '#import-upload-form #upload',
			'location' => admin_url('admin.php?import=wordpress'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Browse The XML File' ,'azoom'),
					__( 'You can find our demo XML file in your downloaded package. If you do not see "Demo Data" directory, then you will need to download the all files. Go to your Themeforest account and click on Download next to '.$rockthemes_globals['theme_name_formatted'].' and choose "All Files & Documentation. After your download unzip the file and you will see "Demo Data" directory. You will find our XML file inside that directory.', 'azoom')
				),
				'position' => array( 'edge' => 'top', 'align' => 'right' ),
				'button' => array(
					'text'	=>	'Next',
					'link'	=>	''
				)
			)
		),
		
		'rockthemes_ih_import_xml_file_upload'	=>	array(
			'target' => '#import-upload-form #submit',
			'location' => admin_url('admin.php?import=wordpress'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Upload The XML File' ,'azoom'),
					__( 'Click here to upload XML file.', 'azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'right' ),
				'button' => array(
					'text'	=>	'Next',
					'link'	=>	''
				)
			)
		),
		
		'rockthemes_ih_import_xml_attachment_1'	=>	array(
			'target' => '#import-attachments',
			'location' => admin_url('admin.php?import=wordpress&step=1'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Download and Import Images' ,'azoom'),
					__( 'If you check this box, it will upload all of our demo attachments to your server (i.e. our images and media files). However, if your server\'s <strong style="color:#FF0000;">PHP Execution Time is not enough</strong> for this process, this may fail. You can either contact to your hosting provider to increase this limit, or choose to leave this box unchecked. If you leave this box unchecked, it will not upload attachments.', 'azoom')
				),
				'position' => array( 'edge' => 'top', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'I Understand',
					'link'	=>	''
				)
			)
		),
		
		'rockthemes_ih_import_xml_attachment_2'	=>	array(
			'target' => '#menu-media',
			'location' => admin_url('admin.php?import=wordpress&step=2'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'WAIT!..' ,'azoom'),
					__( 'This process might take longer than just a few minutes. (1 to 15 minutes) Wait till this finishes. If it successfully completes this process you will see a message saying <strong>"All Done"</strong>. If you do not see this message but you think it should have finished, you can check it by clicking on Media menu. Then check if you see our images there.', 'azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'I Understand',
					'link'	=>	''
				)
			)
		),
		
		'rockthemes_ih_import_media_check'	=>	array(
			'target' => '#menu-pages',
			'location' => admin_url('upload'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Is Media Empty?' ,'azoom'),
					__( 'If you can see our images here, then images imported. On next step, we will check if the pages are imported too. <br/><br/>
					<strong>!Important : </strong> If you do not see demo pages here, it means an error occured during XML import. This is mostly caused of low PHP Execution Time. Contact to your hosting provider and demand them to increase your PHP Execution Time limit or try to import demo data without images.', 'azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'Next',
					'link'	=>	admin_url('edit.php?post_type=page')
				)
			)
		),
		
		'rockthemes_ih_import_page_check'	=>	array(
			'target' => '#menu-appearance',
			'location' => admin_url('edit.php?post_type=page'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Do You See Pages?' ,'azoom'),
					__( 'If you can see out pages here, then XML imported should be completed. Now we can go to next step and import our demo datas. Click on "Next" to easily skip to the next step. <br/><br/>
					<strong>!Important : </strong> If you do not see demo pages here, it means an error occured during XML import. This is mostly caused of low PHP Execution Time. Contact to your hosting provider and demand them to increase your PHP Execution Time limit or try to import demo data without images.', 'azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'Next (Demo Data Load)',
					'link'	=>	admin_url('themes.php?page=rock_options')
				)
			)
		),
		
		'rockthemes_ih_import_datas'	=>	array(
			'target' => '.import_all_default_data',
			'location' => admin_url('themes.php?page=rock_options'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Load Demo Datas' ,'azoom'),
					__( 'Now we will load our demo data including Theme Options, Rock Page Builder templates, Curvy Sliders, Rock Form Builder templates widgets etc.', 'azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'Next (Load Demo Data)',
					'link'	=>	admin_url('themes.php?page=rock_options&rockthemes_to_import_export_page=true')
				)
			)
		),
		
		'rockthemes_ih_import_datas_start'	=>	array(
			'target' => '.rockthemes_to_import_predefined_data_button',
			'location' => admin_url('themes.php?page=rock_options&rockthemes_to_import_export_page=true'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Start Loading' ,'azoom'),
					__( 'You need to click on "Load Demo Data" button in order to start loading datas. It may take a while to finish. (Wait for 1 to 15 minutes). After this step completed, you will be all done for loading datas.<br/><br/>
					<strong>!Important : </strong>If you are not able to start this process or you see an error, that means your server has an admin_ajax issue. There are several reasons for this issue. Most known is low PHP and Wordpress memory limit. You may want to contact to your hosting to demand them to increase these limits.
					However, you can skip this step and start to use Azoom as you like. But if you want demo datas, you should complete this step', 'azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'Finish',
					'link'	=>	'finish'
				)
			)
		),
		
	);
	*/
	
	$rockthemes_ih_steps = array(
		
		'rockthemes_ih_tgm_start'	=>	array(
			'target' => '#setting-error-tgmpa > p:last-child',
			'location' => admin_url('themes.php?page=rock_options'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Welcome to Azoom' ,'azoom'),
					__( '<p>You have successfully installed Azoom. This helper will guide you through <strong>Installing Plugins</strong> and <strong>demo data</strong>. If you already know how to do the rest, you can dismiss this helper</p><p>To get started click on the <strong>Install / Activate Plugins</strong> link above</p>','azoom')
				),
				'position' => array( 'edge' => 'top', 'align' => 'left' ),
			)
		),
		
		'rockthemes_ih_tgm_select'	=>	array(
			'target' => '#doaction',
			'location' => admin_url('themes.php?page=install-required-plugins'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Install and Activate Plugins' ,'azoom'),
					__( '<p>To install plugins, select all of these plugins. Then in the action selector choose <strong>Install Plugins</strong> and click on <strong>Apply</strong> button.</p><p>After you click on "Apply" button and it has finished the installing plugins, click on blue <strong>Return to Required Plugins Installer</strong> link to continue. And select all plugins again but this time choose <strong>Activate</strong></p><p>Then you can click Ok</p>','azoom')
				),
				'position' => array( 'edge' => 'top', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'Ok',
					'link'	=>	''
				)
			)
		),
				
		'rockthemes_ih_import_datas'	=>	array(
			'target' => '.start_one_click_install',
			'location' => admin_url('themes.php?page=rock_options'),
			'options' => array(
				'content' => sprintf( '<h3> %s </h3> <p> %s </p>',
					__( 'Load Demo' ,'azoom'),
					__( '<p>You can now use our one click demo installer button to start installing demo data. Keep in mind demo data should be loaded before starting to edit your site.</p><p><strong>IMPORTANT :</strong> If you see an error or unable to complete loading demo datas contact to your hosting provider and demand them to <strong>Increase Maximum PHP Execution Time and make sure your server allows ".txt" file read</strong></p>', 'azoom')
				),
				'position' => array( 'edge' => 'left', 'align' => 'left' ),
				'button' => array(
					'text'	=>	'Finish',
					'link'	=>	'finish'
				)
			)
		),
		
	);

	
	
	
	$incoming = array_merge($incoming, $rockthemes_ih_steps);
	
	
    return $incoming;
}
add_filter('rockthemes_ih_steps', 'rockthemes_register_installation_helpers');


?>