<?php


if(!defined('F_WAY')):
define('F_WAY', get_template_directory_uri());
endif;


if(!defined('AZOOM_PLUGIN_DIR')):
define('AZOOM_PLUGIN_DIR', plugin_dir_path(__FILE__));
endif;


if(!defined('AZOOM_PLUGIN_URI')):
define('AZOOM_PLUGIN_URI', plugins_url('',(__FILE__)));
endif;




if(!function_exists('rock_check_p')):
/*
**	To use TinyMCE in full power, we check if the string wrapped with "<p>" tags correctly
**
**	@param	:	$string:String	String to check if wrapped correctly
**	@return	:	$string:String	String wrapped with "<p>" tags
*/
function rock_check_p($string){
	return wpautop($string);
	
	if(substr($string,0,2) != '<p') return '<p>'.$string.'</p>';
	return $string;
}
endif;


if(!function_exists('rockthemes_get_product_schema')):
/*
**	Product Schema
**	http://schema.org/Product
**
**	@return	:	Schema details
**	@since	:	1.0
*/
function rockthemes_get_product_schema(){
	$return = ' itemscope="itemscrope" itemtype="http://schema.org/CreativeWork"';
}
endif;






if(!function_exists('rockthemes_demo_image')):
/*
**	We use a demo image when demo data loaded. This feature can be turned off in Theme Options.
**
**	@attr	:	$size:String Image Size. Since the demo image is the same for all size
**						this will only affect img width, height attributes
**
**	@attr	:	$only_url:Boolean, If true, only URL of the image will be returned. Otherwise
**						HTML img element will be returned
**
**	@since	:	1.0
*/
function rockthemes_demo_image($size = '', $only_url = false){
	if(!function_exists('xr_get_option')) return '';

	if(xr_get_option('enable_demo_image', false) !== true) return '';
	
	$alt = esc_html__('Demo Image', 'azoom');

	$image = esc_url(xr_get_option('demo_image_url',''));
	
	if($image === '') return '';
	
	
	if(function_exists('rockthemes_get_image_id_from_url')){
		$upload_dir = wp_upload_dir();
		$image_id = rockthemes_get_image_id_from_url($upload_dir['url'].'/'.basename($image));

		if($image_id != ''){
			$image_test = wp_get_attachment_image_src($image_id, esc_attr($size));
			if($image_test){
				$image = $image_test[0];	
			}
		}
	}
	
	if(!$only_url){
		$image = '<img src="'.esc_url($image).'" alt="'.esc_attr($alt).'"';
		
		if(!xr_get_option('remove_image_wh', true) && $size !== ''){
			$sizes = rockthemes_demo_image_sizes(esc_attr($size));
			
			if($sizes && isset($sizes['width']) && isset($sizes['height'])){
				$image .= ' width="'.esc_attr($sizes['width']).'" height="'.esc_attr($sizes['height']).'"';
			}
		}
		
		$image .= ' />';
	}
	
	return $image;
}
endif;




if(!function_exists('rockthemes_demo_image_sizes')):
/*
**	Only for demo images. This function is the same functions at Wordpress. Ref ;
**
**	http://codex.wordpress.org/Function_Reference/get_intermediate_image_sizes
**
*/
function rockthemes_demo_image_sizes( $size = '' ) {

	global $_wp_additional_image_sizes;

	if(isset($size)){
		$size = esc_attr($size);	
	}
		
	$sizes = array();
	$get_intermediate_image_sizes = get_intermediate_image_sizes();

	// Create the full array with sizes and crop info
	foreach( $get_intermediate_image_sizes as $_size ) {

		if ( in_array( $_size, array( 'thumbnail', 'medium', 'large' ) ) ) {

			$sizes[ $_size ]['width'] = get_option( $_size . '_size_w' );
			$sizes[ $_size ]['height'] = get_option( $_size . '_size_h' );
			$sizes[ $_size ]['crop'] = (bool) get_option( $_size . '_crop' );

		} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {

			$sizes[ $_size ] = array( 
				'width' => $_wp_additional_image_sizes[ $_size ]['width'],
				'height' => $_wp_additional_image_sizes[ $_size ]['height'],
				'crop' =>  $_wp_additional_image_sizes[ $_size ]['crop']
			);

		}

	}

	// Get only 1 size if found
	if ( $size ) {

		if( isset( $sizes[ $size ] ) ) {
			return $sizes[ $size ];
		} else {
			return false;
		}

	}

	return $sizes;
}
endif;







if(!function_exists('rockthemes_get_custom_image_size')):
/*
**	Get custom image size.
**
**	@since	:	1.3
*/
function rockthemes_get_custom_image_size($selected = ''){
	global $_wp_additional_image_sizes;
	
	$sizes = array();
	foreach( get_intermediate_image_sizes() as $s ){
 		$sizes[ $s ] = array( 0, 0 );
 		if( in_array( $s, array( 'thumbnail', 'medium', 'large' ) ) ){
 			$sizes[ $s ][0] = get_option( $s . '_size_w' );
 			$sizes[ $s ][1] = get_option( $s . '_size_h' );
 		}else{
 			if( isset( $_wp_additional_image_sizes ) && isset( $_wp_additional_image_sizes[ $s ] ) )
 				$sizes[ $s ] = array( $_wp_additional_image_sizes[ $s ]['width'], $_wp_additional_image_sizes[ $s ]['height'], );
 		}
 	}
	
	if(empty($sizes)) return false;
	
	foreach($sizes as $size => $atts){
		//Remove the unlrelated image sizes.
		if($size == '' ){
			//Do Nothing	
		}else{
			//If post type is allowed in our list and not unrelated add them to select item
			if($selected == $size){
				return $atts;
			}
		}
	}
	
	return false;
	
}
endif;











if(!function_exists('azoom_featured_empty_icons')):
/*
**	List of featured icons for different post types and pages
**
**	@param	:	$post_type String,
**	@param	:	$line_height String
**	@return	:	HTML element with an icon for the post type
**	@since	:	1.0
*/

function azoom_featured_empty_icons($post_type='', $placeholder = array(), $use_box = false){

	if(!function_exists('xr_get_option')) return '';

	global $post;
	if(empty($post_type)) {
		$post_type = get_post_type();
	}else{
		$post_type = sanitize_text_field($post_type);	
	}
	
	//Default args
	$placeholder_main = array('line_height' => '60px', 'font_size' => '40px', 'width' => '80px', 'max_width'=>'80px');
	
	$placeholder = array_merge($placeholder_main, $placeholder);
	
	if(!empty($placeholder)) extract($placeholder);
	
	if(!isset($height)){
		$height = $line_height;	
	}

	$lib = 'icomoon'; //fa fa- font awesome;
	
	$return = '<span style="font-size:'.esc_attr($font_size).'; line-height:'.esc_attr($line_height).'; text-align:center; width:'.esc_attr($width).'; max-width:'.esc_attr($max_width).'; height:100%; max-height:'.esc_attr($height).'; background:'.esc_attr(xr_get_option('site_general_color','#56CCC8')).'; color:#fff; position:relative; display:block;">';

	
	if($use_box){
		$return = '<div class="rectangle-box" style="font-size:'.esc_attr($font_size).'; line-height:'.esc_attr($line_height).'; max-width:'.esc_attr($width).'; background:'.esc_attr(xr_get_option('site_general_color','#56CCC8')).';"><div class="rectangle-content"><div><span>';	
	}
	
	switch($post_type){
		case 'page':
		$return .= '<i class="'.$lib.' icomoon-icon-file4"></i>';
		break;
		
		case 'post':
		$return .= '<i class="'.esc_attr(azoom_get_post_type_icon_class($post_type)).'"></i>';
		break;
		
		case 'product':
		if(rockthemes_woocommerce_active()){
			//WooCommerce Product
			$return = '<span>';
			
			if ( version_compare( WOOCOMMERCE_VERSION, "2.3" ) >= 0 ) {
				$return .= wc_placeholder_img();
			}else{
				$return .= woocommerce_placeholder_img();
			}
		}
		//$use_box = false;
		break;
		
		case 'defaultitems':
		$return .= '<i class="'.$lib.' icomoon-icon-briefcase"></i>';
		break;
		
		default:
		$return .= '<i class="'.esc_attr(azoom_get_post_type_icon_class($post_type)).'"></i>';
		break;
	}
	
	if($use_box){
		$return .= '</span></div></div></div>';
	}else{
		$return .= '</span>';
	}
	
	return $return;
}

endif;






if(!function_exists('rockthemes_woocommerce_active')):
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/*
**	Rockthemes WooCommerce Integration
**	@return : true if WooCommerce installed and activated, false if not activated
*/
function rockthemes_woocommerce_active(){

	if(class_exists('WooCommerce')) return true;

	return false;

}
endif;



if(!function_exists('rockthemes_bbpress_active')):
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/*
**	Rockthemes WooCommerce Integration
**	@return : true if WooCommerce installed and activated, false if not activated
*/
function rockthemes_bbpress_active(){

	if(class_exists('bbPress')) return true;

	return false;

}
endif;





/*
	This function should be moved to another file
*/
if(!function_exists('rockthemes_fn_px_em_return_num')):
function rockthemes_fn_px_em_return_num($val){
	$val = str_replace('px','',$val);
	$val = str_replace('em','',$val);
	return intval($val);
}
endif;







if(!function_exists('rockthemes_escaped_out_render')):
function rockthemes_escaped_out_render($val){
	return $val;
}
endif;









if(!function_exists('azoom_hover_effect')):
/*
**	Returns HTML codes for hover effect.
**
**	@param	:	$postID 		ID of the current post
**	@param	:	$insert_shadow * DEPRECATED	If there should be shadow under the image
**	@param	:	$new_elem		Array	If there is no post, this element will provide details
**
*/

	function azoom_hover_effect($postID, $hover_obj = array(), $insert_shadow = false, $new_elem = array()){		
		
		$schema = rockthemes_get_product_schema();
		$only_hover = (isset($postID) && $postID === 'only_hover') ? true : false;
		
		/*
		**	Icons
		**	
		**	Hybrid support. 
		*/
		$icons = array(
			'back_icon'		=>	'<i class="icomoon icomoon-icon-undo2"></i>',
			'link_icon'		=>	'<i class="icomoon icomoon-icon-next15 animate-icon animate-to-right"></i>',
			'video_icon'	=>	'<i class="icomoon icomoon-icon-play2"></i>',
			'image_icon'	=>	'<i class="icomoon icomoon-icon-camera"></i>',
			'gallery_icon'	=>	'<i class="icomoon icomoon-icon-images"></i>',
			'like_icon'		=>	'<i class="icomoon icomoon-icon-heart"></i>',
		);
		//Extract icons for shorthand usage
		extract($icons);
		
		
		if(!$only_hover){
			//Post ID is valid
			
			$alt = get_post_meta(get_post_thumbnail_id($postID), '_wp_attachment_image_alt', true);
			$alt_tag = $alt ? $alt : '';
			
			$post_format = get_post_format();

				$post_img_id = get_post_thumbnail_id($postID);
				if($post_img_id){
					$full_image= wp_get_attachment_image_src( $post_img_id, 'full' );
				}else{
					$full_image= wp_get_attachment_image_src( $postID,'full' );
				}

		}
						
		$hover_obj_default = array(
			'activate_hover_box'	=>	false,
			'hover_footer'			=>	true,
			'hover_bg_color'		=>	function_exists('xr_get_option') ? sanitize_text_field(xr_get_option('hover_color_default', '')) : '',
			'hover_bg_opacity'		=>	function_exists('xr_get_option') ? (int) xr_get_option('hover_color_opacity', 80) : 80,
			'activate_hover'		=>	true,
			'use_link'				=>	true,
			'where_to_link'			=>	false,
			'full_link'				=>	false,
			'use_back_icon'			=>	true,
			'lightbox'				=>	array(
				'image'		=>	false,
				'video'		=>	false,
				'gallery'	=>	false,
			),
			'like'					=>	false,
			'use_schema'			=>	false,
			'content'				=>	array(
				'use_title'		=>	true,
				'link_title'	=>	true,
				'use_cats'		=>	false,
				'use_price'		=>	false,
				'use_excerpt'	=>	true,
				'excerpt_length'	=>	10,
			),
		);
		
		//TO DO : Get changes from Advanced Details here
		
		if(!is_array($hover_obj)){
			$hover_obj = array();	
		}		
		
		//Merge coming settings with default
		$hover_obj = array_merge($hover_obj_default, $hover_obj);
		
		//Shorthand for all our settings
		extract($hover_obj);
				
		$use_schema = (isset($use_schema) && $use_schema) ? true : false;
		
		/*
		**	FULL Link Feature is almost ready. Only need to be added on RPB. Supports WooCommerce too
		**
		**	Full link will not work if category link enabled in RPB.
		**	if($full_link === 'false') $full_link = false;
		*/
		
		$product = false;
		$use_woo_details = false;
		if(!$only_hover){
			//Post ID Valid
			
			if(rockthemes_is_true($content['use_price']) && rockthemes_woocommerce_active()){
				$product = new WC_Product( $postID );
				//var_dump($product->get_data());
				if(isset($product) && $product && get_post($postID)->post_type === 'product' ){
					$use_woo_details = true;
				}
			}
		}
		
		if(!$use_schema){
			$schema = '';	
		}
	
		if(!$only_hover){
			$rad = get_post_meta($postID, 'advanced_post_details', true);
		}
		
		if(strpos($where_to_link, 'external') !== false && isset($rad['external_link']) && $rad['external_link'] !== ''){
			$link_url = $rad['external_link'];
		}elseif(!$only_hover){
			$link_url = get_permalink($postID);
		}elseif(isset($new_elem['link_url'])){
			$link_url = $new_elem['link_url'];	
		}
			
		
		$return = '';
		
		//Escape Link URL
		if(isset($link_url)){
			$link_url = esc_url($link_url);	
		}
		
				
		//If using Woo | or links enabled on categories, disable full_link
		if($use_woo_details) $full_link = false;
		if(isset($content) && isset($content['cats_link']) && strpos($content['cats_link'], 'cat-link') > -1) $full_link = false;

				
		
		//Check if Full Link is active
		if($full_link && ($full_link === true || $full_link === 'true') && !is_single()){
			$return .= '<a href="'.esc_url($link_url).'" class="escapea" '.$schema.'>';	
		}
		//If we will display title/excerpt/categories, we will wrap them in our div
		if(rockthemes_is_true($content['use_title']) || rockthemes_is_true($content['use_cats']) || rockthemes_is_true($content['use_excerpt']) || $only_hover){
			$hover_bg_style = 'rgba('.rockthemes_hex2rgba($hover_bg_color, ((int)$hover_bg_opacity / 100)).')';
			$return .= '<div class="hover-item-details-container '.($use_woo_details ? 'azoom-woo-hover-container' : '').'" style="background:'.$hover_bg_style.';" >';//'.$schema.' was here
		}

		if(rockthemes_is_true($content['use_title'])){
			$return .= '<h2 '.(!(!$full_link && $content['link_title']) && $use_schema ? 'itemprop="name"' : '').'>';
			//Start Title
			if(!rockthemes_is_true($full_link) && $content['link_title'] && !is_single()){
				$return .= '<a href="'.$link_url.'" class="escapea" '.($use_schema ? 'itemprop="name"' : '').'>';
			}
			$return .= ($only_hover && isset($new_elem['title']) ? $new_elem['title'] : get_the_title($postID));
			if(!rockthemes_is_true($full_link) && $content['link_title'] && !is_single()){
				$return .= '</a>';	
			}
			$return .= '</h2>';
			//End of title
		}
			
		if(isset($content['cats_link']) && rockthemes_is_true($content['use_cats'])){
			if(strpos($content['cats_link'], 'cat-link') > -1){
				$content['cats_link'] = str_replace('cat-link', 'escapea cat-link', $content['cats_link']);	
			}
			$return	.= '<span class="grid-hover-categories">'.$content['cats_link'].'</span>';
		}
							
		if(rockthemes_is_true($content['use_excerpt']) && !$only_hover){
			$return .= '<span class="grid-hover-excerpt" '.($use_schema ? 'itemprop="description"' : '').'>'.($only_hover && isset($new_elem['excerpt']) ? $new_elem['excerpt'] : azoom_get_the_excerpt('', false, intval($content['excerpt_length']))).'</span>';
		}
			
		
		if(rockthemes_is_true($content['use_title']) || rockthemes_is_true($content['use_cats']) || rockthemes_is_true($content['use_excerpt']) || $only_hover){
			//Small Hover Element
			$return .= '<span class="small-hover-elem" data-link_url="'.$link_url.'">'.$link_icon.'</span>';
			//End of hover-item-details-container
			$return .= '</div>';
		}
		if(rockthemes_is_true($full_link) && !is_single()){
			$return .= '</a>';	
		}
		
		if(rockthemes_is_true($hover_footer)){
			$return .= '
				<div class="azoom-hover-container azoom-transition '.($use_woo_details ? 'woo-grid-hover' : '').'">
			';
		}
		
		
		if($use_woo_details){
			$is_there_fee = $product->get_price_html();
			if($is_there_fee != ''){
				$return .= '<div class="azoom-woo-grid-hover" '.((isset($hover_bg_style) && $hover_bg_style != '') ? 'style="background:'.$hover_bg_color.'"' : '').' >';
					$return	.= '<div class="grid-price">'.$is_there_fee.'</div>';
				$return .= '</div>';
			}
		}

		
		if(rockthemes_is_true($hover_footer)){
			$return .= '
					<div class="azoom-hover-effect">
						<ul>
			';
		}
		
		if(isset($use_back_icon) && $use_back_icon === 'true'){
			$return .=	'
				<li class="rockthemes-hover-icon hide hover-mobile-back">
					<a>
						'.$back_icon.'
					</a>
				</li>
			';
		}
		
		
		if($use_woo_details){
			$add_to_cart = '';
			ob_start();
			rockthemes_woocommerce_add_to_cart();
			$add_to_cart = ob_get_contents();
			ob_get_clean();
			
			
			if($add_to_cart !== ''){
				$total = substr_count($add_to_cart, 'rockthemes-woo-shop-buttons');
				
				if($total == 2){
					$add_to_cart = str_replace('rockthemes-woo-shop-buttons', 'large-6 medium-6 small-6 columns rockthemes-woo-shop-buttons',$add_to_cart);
					//If item using different color change the border color
					if((isset($hover_bg_style) && $hover_bg_style != '')){
						$add_to_cart = str_replace('right-text centered-text-responsive">', 'right-text centered-text-responsive" style="border-color:'.$hover_bg_color.';">', $add_to_cart);
					}
				}elseif($total === 1){
					$add_to_cart = str_replace('rockthemes-woo-shop-buttons', 'large-12 medium-12 small-12 columns rockthemes-woo-shop-buttons',$add_to_cart);
				}
				
				$add_to_cart = str_replace('rockthemes-woo-buttons-container', 'rockthemes-woo-buttons-container row collapse', $add_to_cart);
				
				$return .= '<li  class="azoom-woo-grid-buttons">'.$add_to_cart.'</li>';
			}
		}
		
		
		if(rockthemes_is_true($lightbox['image']) && isset($full_image) && isset($full_image[0]) && !$use_woo_details){
			$return .= '
				<li class="rockthemes-hover-icon">			
					<a href="'.$full_image[0].'" data-rel="prettyPhoto[lightbox_gallery_'.esc_attr($GLOBALS['lightbox_gallery']).']">
						'.$image_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($lightbox['gallery']) && isset($rad['extra_featured_images']) && !$use_woo_details && 
			is_array($rad['extra_featured_images']) && 
			count($rad['extra_featured_images']) &&
			$rad['extra_featured_images'][0] != ''){
				
			$length = count($rad['extra_featured_images']);
			$i = 0;
			$loop_images_string = '<div class="hide">';
			foreach($rad['extra_featured_images'] as $extra_image){
				if($extra_image == '') continue;
				$g_id = '';
				$g_id = (isset($rad['extra_featured_image_ids']) && isset($rad['extra_featured_image_ids'][$i])) ? $rad['extra_featured_image_ids'] : '';
				if($g_id === ''){
					$g_id = rockthemes_get_image_id_from_url(esc_url($extra_image));
				}
				//$g_meta = wp_get_attachment_metadata($g_id);
				$g_url = wp_get_attachment_image_src( intval($g_id), 'full' );
				
				//If we couldn't find the attachment id or attachment is a Youtube/Vimeo video, we will use the main file (without resized)
				$g_url = (!empty($g_url) && isset($g_url[0])) ? $g_url[0] : $extra_image;

				$loop_images_string .= '
					<a href="'.esc_url($g_url).'" data-rel="prettyPhoto[rockthemes_portfolio_'.esc_attr($GLOBALS['rockthemes_portfolio']).esc_attr($postID).']"></a>
				';
				$i++;
	
			}
			$loop_images_string .= '</div>';

			$return .= '
				<li class="rockthemes-hover-icon">		
					'.$loop_images_string.'	
					<a href="'.esc_url($full_image[0]).'" data-rel="prettyPhoto[rockthemes_portfolio_'.esc_attr($GLOBALS['rockthemes_portfolio']).esc_attr($postID).']">
						'.$gallery_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($lightbox['video']) && isset($rad['video_iframe_code']) && $rad['video_iframe_code'] != '' && !$use_woo_details){
			$return .= '
				<li class="rockthemes-hover-icon">
					<a href="'.$rad['video_iframe_code'].'" data-rel="prettyPhoto">
						'.$video_icon.'
					</a>
				</li>
			';	
		}
		
		if(rockthemes_is_true($like) && !$use_woo_details){
			$return .= '
				<li class="rockthemes-hover-icon azoom-love-icon" data-post-id="'.$postID.'">			
					<a class="azoom-like">
						'.$like_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($use_link) && $link_url != '' && !$use_woo_details && !is_single()){
			$return .=	'
				<li class="rockthemes-hover-icon right link-elem">
					<a href="'.$link_url.'">
						'.$link_icon.'
					</a>
				</li>
			';
		}
		
		if(rockthemes_is_true($hover_footer)){
			$return .= '	
					</ul>
				</div>
			';
		}

		if(rockthemes_is_true($hover_footer)){
			$return .= '</div>
			';
		}
		
		return $return;
	}
endif;






if(!function_exists('rockthemes_jpeg_quaility')):
/*
**	Wordpress uses low quality for jpeg resizing. Increase this limit
**
*/
function rockthemes_jpeg_quaility( $quality ) {
    return 95;
}
endif;
add_filter( 'wp_editor_set_quality', 'rockthemes_jpeg_quaility' );




if(!function_exists('rockthemes_is_true')):
/*
**	Checks for both boolean and string true and returns boolean 	
**
**	@param	:	String/Boolean variable to check
**	@return	:	Boolean true/false
**	@since	:	1.3
**
*/
function rockthemes_is_true($is_true = false){
	if(isset($is_true) && !empty($is_true) && $is_true && ($is_true === true || $is_true === 'true')){
		return true;	
	}
	return false;
}
endif;







/*
**	General function to turn hex to rbga. Also exists in options_loader.php file
**
**	@since	:	1.3
*/
if(!function_exists('rockthemes_hex2rgba')):
function rockthemes_hex2rgba($hex, $opacity = 1) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return implode(",", $rgb).','.$opacity; // returns the rgb values separated by commas
   //return $rgb; // returns an array with the rgb values
}
endif;













if(!function_exists('rockthemes_woocommerce_add_to_cart')):
/*
**	WooCommerce loop only shows Add to Cart Button. We will add "read more" button
**
**
*/
function rockthemes_woocommerce_add_to_cart(){
	global $product;

	if ($product->is_type('bundle') ){
		$product = new WC_Product_Bundle($product->get_id());
	}
	
	$icons = array(
		'icon_variable'	=>	'icomoon icomoon-icon-settings',
		'icon_cart'		=>	'icomoon icomoon-icon-shopping114',
		'icon_details'	=>	'icomoon icomoon-icon-attachment',
		'icon_link'		=>	'icomoon icomoon-icon-next15',
	);
	
	$loader_motion = function_exists('rockthemes_loader_motion') ? rockthemes_loader_motion('woocommerce-loader') : '';
	
	extract($icons);

	$return = '';


	ob_start();
	woocommerce_template_loop_add_to_cart();
	$return = ob_get_clean();
	
	$is_there_fee = $product->get_price_html();

	if(!empty($return)){
		$find_close = strpos($return, '>');

		if ($find_close !== false) {
			if($product->is_type('grouped')){
				$return = substr_replace($return,'><i class="'.$icon_variable.'"></i> ', $find_close , strlen(1));
				$return = '<span class="rockthemes-woo-shop-buttons-full center-text centered-text-responsive">'.$return.'</span>';
				
			}elseif($product->is_type('simple')){
				$return = substr_replace($return,'><i class="'.$icon_cart.'"></i> ', $find_close , strlen(1));
				$return = '<span class="rockthemes-woo-shop-buttons left-text centered-text-responsive">'.$return.'</span>';
				
			}elseif($product->is_type('external')){
				$return = substr_replace($return,'><i class="'.$icon_link.'"></i> ', $find_close , strlen(1));
				$return = '<span class="rockthemes-woo-shop-buttons-full left-text centered-text-responsive">'.$return.'</span>';
			}
		}
		
		//Start to check button classes. To make it safe first check with double space and so on
		if(strpos($return, ' button ') > -1){
			$return = str_replace(' button ', ' button escape_button_style escapea ', $return);
		}elseif(strpos($return, ' button') > -1){
			$return = str_replace(' button', ' button escape_button_style escapea', $return);
		}elseif(strpos($return, 'button ') > -1){
			$return = str_replace('button ', 'button escape_button_style escapea ', $return);
		}elseif(strpos($return, 'button') > -1){
			$return = str_replace('button', 'button escape_button_style escapea', $return);
		}
	
		$return = str_replace('</i>','</i> <span class="text">',$return);
		if(!$product->is_type('external') && $is_there_fee != ''){
			$return = str_replace('</a>','</span>'.$loader_motion.'</a>',$return);
		}
	}


	if($product->is_type('variable')){
		$return = '
		<span class="center-text rockthemes-woo-shop-buttons-full">
			<a class="escapea add_to_cart_button escape_button_style product_type_variable center-text" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_variable.'"></i> <span class="text">'.__('Options','azoom').'</span></a>
		</span>
		';
	}

	if($product->is_type('simple')){
		if( $is_there_fee != ''){
			$return .= '
			<span class="rockthemes-woo-shop-buttons right-text centered-text-responsive">	
				<a class="show_details_button escape_button_style escapea" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_details.'"></i> <span class="text">'.__('Details','azoom').'</span></a>
			</span>	
			';
		}else{
			$return = '
			<span class="rockthemes-woo-shop-buttons right-text centered-text-responsive">	
				<a class="show_details_button escape_button_style escapea" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_details.'"></i> <span class="text">'.__('Details','azoom').'</span></a>
			</span>	
			';
		}
	}
	
	if($product->is_type('external')){
		$return .= '
		<span class="rockthemes-woo-shop-buttons right-text centered-text-responsive">	
			<a class="show_details_button escape_button_style escapea" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_details.'"></i> <span class="text">'.__('Details','azoom').'</span></a>
		</span>	
		';
	}
	
	$return = '<div class="rockthemes-woo-buttons-container">'.$return.'</div>';

	echo $return;
}
endif;








if(!function_exists('azoom_ex_enqueue_frontend_files')):
/*
**	Enqueue all frontend files. All default styles and javascript files enqueued here. 
**
**	Some feature specific files are not enqueued here for better performance
**
*/
function azoom_ex_enqueue_frontend_files(){

	if(defined('AZOOM_MAIN_STYLE')) return;

	global $rock_page_builder_config;	

	//Foundation normalize
	wp_enqueue_style( 'foundation-normalize', AZOOM_PLUGIN_URI.'/css/normalize.css', '', '', 'all' );
		
	//Responsive Foundation Layout
	wp_enqueue_style( 'foundation', AZOOM_PLUGIN_URI.'/css/foundation.css', '', '', 'all' );
	
	//Foundation extra features like hd blocks
	wp_enqueue_style( 'foundation-extra', AZOOM_PLUGIN_URI.'/css/foundation-extra.css', '', '', 'all' );
	
	//Animate CSS
	wp_enqueue_style( 'animate-css', AZOOM_PLUGIN_URI.'/css/animate.css', '', '', 'all' );
	
	//Lightbox Effect
	wp_enqueue_style('prettyPhoto', AZOOM_PLUGIN_URI.'/css/prettyPhoto.css');
		
	//Load swiper as default. It's file size is very low.
	wp_enqueue_style('swiper-css', AZOOM_PLUGIN_URI.'/css/idangerous.swiper-2.css', '', '', 'all' );
	
	//Load swiper as default. It's file size is very low.
	wp_enqueue_style('rpb-main', AZOOM_PLUGIN_URI.'/css/style.css', '', '', 'all' );

	//if(function_exists('rockthemes_enqueue_external_style')) rockthemes_enqueue_external_style();
			
	if(function_exists('rockthemes_browser_ie9') && rockthemes_browser_ie9()){
		wp_enqueue_style( 'ie9-fix', AZOOM_PLUGIN_URI.'/css/ie9.css', '', '', 'all' );
	}
	
		
	$ajax_call = array(
				   'ajaxurl' => admin_url('admin-ajax.php'), 
				   'colors'		=> array(
				   		'main_color'	=>	function_exists('xr_get_option') ? xr_get_option('site_general_color','#56CCC8') : '#56ccc8',
				   ),
				   'ajax_nonce' => wp_create_nonce("rockthemes_security_nonce"), 
				   'f_way' => AZOOM_PLUGIN_URI,
				   'nonces'		=> array(
				   		'portfolio'		=>	wp_create_nonce('rockthemes_portfolio_nonce'),
						'asearch'		=>	wp_create_nonce('rockthemes_asearch_nonce'),
						'achievement'	=>	wp_create_nonce('rockthemes_achievement_nonce'),
						'love'			=>	wp_create_nonce('rockthemes_love_nonce'),
				   ),
				   'home_url' => get_home_url(),
				   'gif_loader'	=>	'<img src="'.AZOOM_PLUGIN_URI.'/images/ajax-loader.gif" class="gif-loader" alt="'.__('Loading','azoom').'" />',
				   'frontend_options' => array(
				   		'activate_smooth_scroll' 		=>	function_exists('xr_get_option') && xr_get_option('activate_smooth_scroll', false) ? 'true' : 'false',
						'nicescroll_style_enabled'		=>	function_exists('xr_get_option') && xr_get_option('nicescroll_style_enabled', false) ? 'yes' : 'false',
						'is_admin_bar_showing'			=>	is_admin_bar_showing(),
						'display_inline_nav'			=>	function_exists('rad_get_option') ? rad_get_option('display_inline_nav') : 'false',
						'header_location'				=>	function_exists('xr_get_option') ? xr_get_option('header_location', 'top_navigation') : 'top_navigation',
				   ),
				   'hover_details'	=>	array(
				   		'hover_width_min_large'			=>	function_exists('xr_get_option') ? xr_get_option('hover_width_min_large',250) : 250,
						'hover_height_min_large'		=>	function_exists('xr_get_option') ? xr_get_option('hover_height_min_large', 225) : 225,
				   		'hover_width_min_medium'		=>	function_exists('xr_get_option') ? xr_get_option('hover_width_min_medium',160) : 160,
						'hover_height_min_medium'		=>	function_exists('xr_get_option') ? xr_get_option('hover_height_min_medium', 100) : 100,
				   ),
				   'fonts'	=> array(
						'use_icomoon'						=>	(defined('RPB_USE_ICOMOON') ? 'true' : 'false'),
						'icomoon_url'						=>	AZOOM_PLUGIN_URI.'/icons/css/icomoon.css',
						'menu_font_family'					=>	function_exists('xr_get_option') ? xr_get_option('menu_font_family','') : '',
						'activate_font_loading'				=>	function_exists('xr_get_option') && xr_get_option('font_loading_active', true) ? 'true' : 'false',
				   		'font_families'						=>	function_exists('rockthemes_get_user_fonts_array') ? rockthemes_get_user_fonts_array() : '',
				   ),
				   'is_rtl' => (is_rtl() ? 'rtl' : 'ltr'),
				   'mobile_menu' => array(
				   		'main_title'	=>	__('Menu', 'azoom'),
						'back_text'		=>	__('Back', 'azoom'),
				   ),
				   'menu'		=>	array(
				   		'regular_height'	=>	function_exists('xr_get_option') ? rockthemes_fn_px_em_return_num(xr_get_option('header_regular_line_height',98)) : 98,
						'sticky_height'		=>	function_exists('xr_get_option') ? rockthemes_fn_px_em_return_num(xr_get_option('header_sticky_line_height',50)) : 50,
				   		'enable_menu_hash_navigation'	=>	function_exists('xr_get_option') && xr_get_option('enable_menu_hash_navigation',false) ? 'true' : 'false',
				   		'main_menu_model'	=>	function_exists('xr_get_option') ? xr_get_option('main_menu_model', 'regular') : 'regular',
				   ),
				   'resposivity' =>	function_exists('xr_get_option') && xr_get_option('disable_responsivity',false) ? 'false' : 'true',
				   'grid'		=> array(
				   		/*Block Grid Size*/
						'block'	=> array(
							'medium'	=>	$rock_page_builder_config['settings']['medium_block_size'],
							'small'		=>	$rock_page_builder_config['settings']['small_block_size']
						)
				   ),
				   'woocommerce' => array(),
			   );


	if(rockthemes_woocommerce_active() && function_exists('xr_get_option')){
		$ajax_call['woocommerce'] = array(
			'auto_display_cart_after_refresh' => xr_get_option('auto_display_cart_after_refresh', true)
		);
	}


	
	wp_enqueue_script('modernizr-js', AZOOM_PLUGIN_URI.'/js/modernizr.js', '');
	
	wp_enqueue_script('jquery');
	
	if(function_exists('rockthemes_enqueue_icon_fonts')) rockthemes_enqueue_icon_fonts($ajax_call);
		
	//Required for color based elements such as buttons
	wp_enqueue_script('jquery-color');
	
	wp_enqueue_script('jquery-effects-core');
	
	wp_enqueue_script('underscore');	
	
	wp_enqueue_script('images-loaded', AZOOM_PLUGIN_URI.'/js/imagesloaded.pkgd.min.js', array('jquery'), '3.1.8', false);
	
	
	wp_enqueue_script('smartresize-js', AZOOM_PLUGIN_URI.'/js/jquery.smartresize.js', array('jquery'), '1.0.0', false);
	
	
	wp_enqueue_script('jquery.prettyPhoto', AZOOM_PLUGIN_URI.'/js/jquery.prettyPhoto.js', array('jquery'), '3.1.6', false);
	
	if(function_exists('xr_get_option') && xr_get_option('activate_smooth_scroll', false)){
		wp_enqueue_script('nice-scroll', AZOOM_PLUGIN_URI.'/js/jquery.nicescroll.min.js', array('jquery'), '3.6.0', false);	
	}
		
	wp_enqueue_script('inview-js', AZOOM_PLUGIN_URI.'/js/isInViewport.min.js', array('jquery'), '1.0.0', false);
	
	wp_enqueue_script('jquery-appear', AZOOM_PLUGIN_URI.'/js/jquery.appear.js', array('jquery'), '1.0.0', false);
	
	wp_enqueue_script('azoom-jquery', AZOOM_PLUGIN_URI.'/js/azoom.jquery.js', array('jquery'), '1.0.0', false);
	
	if(isset($ajax_call)){
		wp_localize_script('azoom-jquery', 'rockthemes', $ajax_call);
	}
	
		
}
endif;
add_action('wp_enqueue_scripts','azoom_ex_enqueue_frontend_files');








if(!function_exists('rockthemes_enqueue_icon_fonts')):
/*
**	Icon List Enqueue System.
**
**	For both backend and frontend, font icons will be enqueued here.
**
**	@attr	:	$ajax_call:Array	-	This array comes from functions-core.php file. Contains javascript
**										based details as array.
**
*/
function rockthemes_enqueue_icon_fonts($ajax_call = false){
	
	/*
	**	This commented field will be used for extra font families.
	*/
	//Font Awesome
	if(function_exists('xr_get_option') && xr_get_option('enable_fontawesome', false)){
		$ajax_call['fonts']['libs'][] = array('name' => 'FontAwesome', 'url' => AZOOM_PLUGIN_URI.'/icons/css/font-awesome.css');
	}
	//Pixed Stroke 7 icon set - http://www.pixeden.com/icon-fonts/stroke-7-icon-font-set
	if(function_exists('xr_get_option') && xr_get_option('enable_pestroke7', false)){
		$ajax_call['fonts']['libs'][] = array('name' => 'Pe-icon-7-stroke', 'url' => AZOOM_PLUGIN_URI.'/icons/css/pe-icon-7-stroke.css');
	}
	

	//This library does not need jQuery in order to work
	if(function_exists('xr_get_option') && xr_get_option('font_loading_active', true) && $ajax_call !== false && !is_admin()){
		//wp_enqueue_script('webfontloader', '//ajax.googleapis.com/ajax/libs/webfont/1.5.0/webfont.js');
		wp_enqueue_script('webfontloader', AZOOM_PLUGIN_URI.'/js/webfont.js');
		wp_enqueue_script('rockthemes-font-loader', AZOOM_PLUGIN_URI.'/js/rockthemes_font_load.js', array('webfontloader','jquery'));
		wp_localize_script('rockthemes-font-loader', 'rockthemes', $ajax_call);
	}else{
		//Azoom uses icomoon
		wp_enqueue_style('rock-icomoon-css',  AZOOM_PLUGIN_URI.'/icons/css/icomoon.css', '','', 'all');
				
		//External Libraries coming from theme options.
		if(isset($ajax_call['fonts']['libs']) && count($ajax_call['fonts']['libs']) > 0){
			foreach($ajax_call['fonts']['libs'] as $font){
				wp_enqueue_style('rock-'.$font['name'],  $font['url'], '','', 'all');
			}
		}
	}
}
endif;




if(!function_exists('rockthemes_enqueue_icon_fonts_hook')):
/*
**	Enqueue Icon files for admin area.
**
**	$attr	:	$hook:String, the page name for the admin area.
**	$source	:	http://codex.wordpress.org/Plugin_API/Action_Reference/admin_enqueue_scripts
**
**	@since	:	1.0
*/
function rockthemes_enqueue_icon_fonts_hook($hook=''){
	rockthemes_enqueue_icon_fonts();	
}
endif;
add_action('admin_enqueue_scripts','rockthemes_enqueue_icon_fonts_hook');








if(!function_exists('rpb_be_sgrid')):
/*
**	FULL SHORTCODES FOR THE GRIDS AND SPECIAL GRIDS AND COLUMNS
**
**
*/
if(!function_exists('rpb_be_sgrid')){
	function rpb_be_sgrid($atts, $content = null){	
		extract( shortcode_atts( array(
			'avoid_sidebar'					=>	'',
			'grid_special_width_details'	=>	'',
			'background_color'				=>	'',
			'bgcolor_fullscreen'			=>	'',
			'use_shadow'					=>	'',
			'use_border_bottom'				=>	'',
			'activate_padding'				=>	'',
			'transparent_background'		=>	'',
			'add_down_arrow'				=>	'',
			'down_arrow_color'				=>	'',
			'special_grid_html_id'			=>	'',
			'special_grid_html_title'		=>	'',
			'video_bg_url'					=>	'',
			'video_bg_youtube_url'			=>	'',
			'video_bg_vimeo_url'			=>	'',
			'video_bg_color'				=>	'',
			'video_bg_color_opacity'		=>	'',
			'video_bg_fullscreen'			=>	'',
			'video_bg_ratio'				=>	'',
			'video_bg_mute'					=>	'',
			'video_bg_fallback_url'			=>	'',
			'parallax_model'				=>	'',
			'parallax_size'					=>	'',
			'parallax_mask_height'			=>	'',
			'image_full_screen'				=>	'',
			'image_full_screen_ratio'		=>	'',
			'image_bg_color'				=>	'',
			'image_bg_color_opacity'		=>	'',
			'image_tile'					=>	'',
			'image_sizes'					=>	'',
			'full_bg_color'					=>	'',
			'fullbg_enable_color'			=>	'',
			'enable_double_bg_colors'		=>	'',
			'double_bg_color'				=>	'',
			'use_light_font_colors'			=>	'',
			'parallax_bg_image_id'			=>	'',
			'parallax_bg_image'				=>	''
		), $atts ) );
		
		$return = '';
		
		/*
		**	Extended Details
		*/
		$ed = array(
			'rpb_grid_tag'						=>	'div',
			'special_grid_html_id_code'			=>	'',
			'border_bottom_class'				=>	'',
			'light_font_class'					=>	'',
			'padding_class'						=>	'',
		);

		//Add this to inline navigation elements.
		if(!empty($special_grid_html_id) && $special_grid_html_id){
			$ed['special_grid_html_id_code'] = 'id="'.esc_attr($special_grid_html_id).'" ';
			$GLOBALS['rockthemes_frontend_inline_nav'][esc_attr($special_grid_html_id)] = $special_grid_html_title;
		}
		if(isset($use_border_bottom) && $use_border_bottom === 'true'){
			$ed['border_bottom_class'] = 'unique-grid-border-bottom';
		}
		if(isset($use_light_font_colors) && $use_light_font_colors === 'true'){
			$ed['light_font_class'] = 'unique-grid-light-fonts';
		}
		if(isset($activate_padding) && $activate_padding === 'true'){
			$ed['padding_class'] = 'rsb-vertical-space';
		}

		
		$return .= '<!-- Grid Start -->';
		switch($grid_special_width_details){
			case 'use_parallax' :
			$return .= rpb_be_sg_parallax($atts, $content, $ed);
			break;	
			
			case 'use_background_img' :
			$return .= rpb_be_sg_bgimage($atts, $content, $ed);
			break;
			
			case 'use_background_video' :
			$return .= rpb_be_sg_bgvideo($atts, $content, $ed);
			break;	
			
			case 'full_width_colored' :
			$return .= rpb_be_sg_fullwidth_colored($atts, $content, $ed);
			break;	
			
			case 'full_width_slider' :
			$return .= rpb_be_sg_fullwidth($atts, $content, $ed);
			break;	
			
			case 'full_width_screen_slider' :
			$return .= rpb_be_sg_fullwidth_screen($atts, $content, $ed);
			break;
			
			default :
			$return .= rpb_be_sg_regular($atts, $content, $ed);
			break;
		}
		$return .= '<!-- /End of Grid -->';
		
		return $return;
	}
}
endif;
add_shortcode('rpb_sgrid', 'rpb_be_sgrid');




/*
**	Rockthemes Special Grid Block Shortcode
**	This shortcode function is not for editing. Thus it's not located in shortcodes.php
**	-	If the system will change this function will be moved to "shortcodes.php" file
**	RPB (Rock Page Builder) uses special grid block. New version contains a shortcode method
**	for special grid block. 
**
**	@since	:	1.3
*/
if(!function_exists('rockthemes_shortcode_make_specialgridblock')){
	function rockthemes_shortcode_make_specialgridblock($atts, $content=null){
		extract(shortcode_atts(array(
			'avoid_sidebar' => 'false',
			'grid_special_width_details' => '',
			'background_color' => '',
			'use_shadow' => '',
			'activate_padding' => '',
			'transparent_background' => '',
			'special_grid_html_id' => '',
			'add_down_arrow' => 'false',
			'parallax_model' => '',
			'parallax_mask_height' => '',
			'parallax_bg_image' => '',
			'skip_sg'			=>	'false',
		), $atts));
		
		
		if($skip_sg === 'true'){return do_shortcode($content);}
		
		$transparent_background = $transparent_background === 'true' ? true : false;
		$general_padding = rockthemes_fn_px_em_return_num(xr_get_option('content_padding','10px'));
		$padding_vertical_html = '';
		if(isset($activate_padding) && $activate_padding === 'true'){
			$padding_vertical_html = 'padding-top:'.(4 * $general_padding).'px; padding-bottom:'.(4 * $general_padding).'px;';
		}

		$return = '';
				
		$special_grid_html_id_code = '';
		
		if(!empty($special_grid_html_id)){
			$special_grid_html_id_code = 'id="'.$special_grid_html_id.'" ';
		}
				
		$down_arrow = '';
		if($add_down_arrow === 'true'){
			$down_arrow = rockthemes_op_make_down_arrow();	
		}
		
		switch($grid_special_width_details){
			case 'use_parallax':
			$content = '<div '.$special_grid_html_id_code.' class="rockthemes-parallax rockthemes-unique-grid" 
				parallax-model="height_specific" 
				parallax-bg-image="'.esc_attr($parallax_bg_image).'" 
				parallax-mask-height="'.esc_attr($parallax_mask_height).'">
			<div class="row">'.$content.$down_arrow.'</div>';

			break;
			
			case 'use_background_img' :
			$content = '<div '.$special_grid_html_id_code.' class="rockthemes-parallax rockthemes-unique-grid" 
				parallax-model="no_parallax_only_image" 
				parallax-bg-image="'.esc_attr($parallax_bg_image).'" 
				parallax-mask-height="'.esc_attr($parallax_mask_height).'">
			<div class="row">'.$content.$down_arrow.'</div>';
			break;	
			
			case 'full_width_slider':
			$content = '<div><div><div class="rockthemes-unique-grid row collapse">'.$content.$down_arrow.'';
			break;
			
			case 'full_width_colored':
			$content = '<div '.$special_grid_html_id_code.' class="rockthemes-fullwidth-colored rockthemes-unique-grid" style="'.(!$transparent_background ? 'background:'.$background_color.';' : '').' '.$padding_vertical_html.'">
							<div class="row">'.$content.$down_arrow.'</div>';
			break;
		}
		
		
		switch($avoid_sidebar){
			
			case 'false':
			//Do Nothing
			break;
			
			case 'header':
			$return = '<div class="rockthemes-before-header">'.do_shortcode($content).'</div></div></div>';
			break;
			
			case 'before':
			$return = '</div>'.do_shortcode($content).'</div><div class="row">';
			break;
			
			case 'after':
			$return = '</div></div>'.do_shortcode($content).'</div><div><div class="row">';
			break;
			
		}
		return $return;

	}
}
add_shortcode('rockthemes_specialgridblock', 'rockthemes_shortcode_make_specialgridblock');



if(!function_exists('rpb_be_sg_footer')):
/*
**	Builds the footer for the special grids. Elements : shadow, arrow down or border.
**
*/
function rpb_be_sg_footer($atts=array(), $ed=array()){
	
	extract($atts);
	extract($ed);
	
	$return = '';
	
	if(isset($add_down_arrow) && $add_down_arrow == 'true'){
		$return .= rockthemes_op_make_down_arrow($down_arrow_color);
	}
	if(isset($use_shadow) && $use_shadow === 'true'){
		$return .= azoom_image_shadow_up();
	}
	
	return $return;
}
endif;










if(!function_exists('rpb_be_sg_fullwidth_colored')):
/*
**	Rock Page Builder BE, Special Grid Full Width Colored
**
*/
function rpb_be_sg_fullwidth_colored($atts=array(), $content='', $ed=array()){
		
	extract($atts);
	extract($ed);

	$return = '';

	//Add Fullwidth colored (Colored Background)
	$bgcolor_fullscreen_data = '';
	$bgcolor_fullscreen = (isset($bgcolor_fullscreen) && $bgcolor_fullscreen === 'true') ? $bgcolor_fullscreen : false;
	if(!empty($bgcolor_fullscreen) && $bgcolor_fullscreen){
		$bgcolor_fullscreen_data = 'data-rsb-fullscreen="true"';
	}
	
	//Double background color
	$double_bg = (isset($enable_double_bg_colors) && $enable_double_bg_colors === 'true') ? true : false;
	$double_bg_data = '';
	$double_bg_class = '';
	if($double_bg){
		$double_bg_color = isset($enable_double_bg_colors) ? 
						esc_attr($double_bg_color) : '#f9f9f9';
		$double_bg_class = 'multi-bg-colors';
		$double_bg_data = 'data-multibg-colors="'.$background_color.','.$double_bg_color.'"';
		$background_color = rockthemes_make_split_bg_color($background_color, $double_bg_color);
	}else{
		$background_color = 'background:'.esc_attr($background_color).';';	
	}

	//Do not add spaces before closing div. This way we can remove the empty divs.
	$return .= '<'.$rpb_grid_tag.' '.$special_grid_html_id_code.' class="rockthemes-fullwidth-colored rockthemes-unique-grid '.esc_attr($double_bg_class).' '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($add_down_arrow) && $add_down_arrow == 'true' ? 'down-arrow-active' : '').'" ';
	$return .= 'style="'.($transparent_background === 'false' ? $background_color : '').'" ';
	$return .= $bgcolor_fullscreen_data.' ';
	$return .= $double_bg_data.'>';
		$return .= '<div class="row">'.do_shortcode($content).'</div>';
		
	$return .= rpb_be_sg_footer($atts, $ed);
	
	$return .= '</'.$rpb_grid_tag.'>';
		
	return $return;
}
endif;






if(!function_exists('rpb_be_sg_regular')):

/*
**	Rock Page Builder BE, Special Grid Regular
**
*/
function rpb_be_sg_regular($atts=array(), $content='', $ed=array()){
		
	extract($atts);
	extract($ed);

	$return = '';
	
	$return .= '<'.$rpb_grid_tag.' '.$special_grid_html_id_code.' class="rockthemes-unique-grid rockthemes-fullscreen row collapse '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($add_down_arrow) && $add_down_arrow == 'true' ? 'down-arrow-active' : '').'" data-rsb-fullscreen="true">';	
	$return .= do_shortcode($content);
	
	$return .= rpb_be_sg_footer($atts, $ed);
	
	$return .= '</'.$rpb_grid_tag.'>';
	
	return $return;
}
endif;






if(!function_exists('rpb_be_sg_fullwidth_screen')):

/*
**	Rock Page Builder BE, Special Grid Full Width Screen
**
*/
function rpb_be_sg_fullwidth_screen($atts=array(), $content='', $ed=array()){
		
	extract($atts);
	extract($ed);

	$return = '';

	//Add Fullwidth Full Screen for slider	
	$full_bg_style = '';
	$enable_bg_color = isset($fullbg_enable_color) ? $fullbg_enable_color : false;
	if($enable_bg_color){
		$full_bg_style = 'background:'.esc_attr($full_bg_color).';';
	}
	
	$return .= '<'.$rpb_grid_tag.' '.$special_grid_html_id_code.' class="rockthemes-unique-grid rockthemes-fullscreen row collapse '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($add_down_arrow) && $add_down_arrow == 'true' ? 'down-arrow-active' : '').'" data-rsb-fullscreen="true" style="'.esc_attr($full_bg_style).'">';	
	$return .= do_shortcode($content);
	
	$return .= rpb_be_sg_footer($atts, $ed);
	
	$return .= '</'.$rpb_grid_tag.'>';
	
	return $return;
}
endif;






if(!function_exists('rpb_be_sg_fullwidth')):

/*
**	Rock Page Builder BE, Special Grid Full Width
**
*/
function rpb_be_sg_fullwidth($atts=array(), $content='', $ed=array()){
		
	extract($atts);
	extract($ed);

	$return = '';
	
	//Fullwidth for slider
	$full_bg_style = '';
	$enable_bg_color = isset($fullbg_enable_color) ? $fullbg_enable_color : false;			
	if($enable_bg_color && $enable_bg_color !== 'false'){
		$full_bg_style = 'background:'.esc_attr($full_bg_color).';';
	}
	
	$return .= '<'.$rpb_grid_tag.' '.$special_grid_html_id_code.' class="rockthemes-unique-grid rockthemes-fullwidth row collapse '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($add_down_arrow) && $add_down_arrow == 'true' ? 'down-arrow-active' : '').'" style="'.esc_attr($full_bg_style).'">';	
	$return .= do_shortcode($content);
	
	$return .= rpb_be_sg_footer($atts, $ed);
	
	$return .= '</'.$rpb_grid_tag.'>';
	
	return $return;
	
}
endif;



if(!function_exists('rpb_be_sg_bgvideo')):

/*
**	Rock Page Builder BE, Special Grid Background Video
**
*/
function rpb_be_sg_bgvideo($atts=array(), $content='', $ed=array()){
		
	extract($atts);
	extract($ed);
	
	$return = '';
	
	//Add Background Video 
	$video_bg_fallback_url_data = isset($video_bg_fallback_url) ? 'data-video_bg_fallback_url="'.$video_bg_fallback_url.'" ' : '';
	
	$video_bg_mute = '';
	if(isset($video_bg_mute) &&
		$video_bg_mute &&
		$video_bg_mute === 'true'){
		$video_bg_mute = 'mute="true"';
	}
	
	$video_html = '
		<video data-autoplay="true" loop '.($video_bg_mute !== '' ? 'muted' : '').' '.(isset($video_bg_fallback_url) ? 'poster="'.$video_bg_fallback_url.'"' : '').'>
		  <source src="'.esc_url($video_bg_url).'" type="video/mp4">
		</video>
	';
	
	//Check if it's a Youtube Video
	if(isset($video_bg_youtube_url) &&
		$video_bg_youtube_url !== ''){
		$video_html = '[rockthemes_youtube_video autoplay="true" '.$video_bg_mute.']'.esc_url($video_bg_youtube_url).'[/rockthemes_youtube_video]';
	}

	//Check if it's a Vimeo Video
	if(isset($video_bg_vimeo_url) &&
		$video_bg_vimeo_url !== ''){
		$video_html = '[rockthemes_vimeo_video autoplay="true" '.$video_bg_mute.']'.esc_attr($video_bg_vimeo_url).'[/rockthemes_vimeo_video]';
	}

	
	$bg_style = '';
	if(isset($video_bg_color) &&
		$video_bg_color !== 0){
		
		$bg_style = 'background:rgba('.rockthemes_hex2rgba($video_bg_color, (((int) $video_bg_color_opacity) / 100)).');';

	}
	
	$data_details = '';
	if(isset($video_bg_fullscreen) &&
		$video_bg_fullscreen == 'true'){
		$data_details = 'data-rsb-fullscreen="true"';//rsb Rockthemes Special Block
	}
	
	$data_ratio = 'data-rsb-ratio="16_9"';
	if(isset($video_bg_ratio) &&
		$video_bg_ratio != ''){
		$data_ratio = 'data-rsb-ratio="'.esc_attr($video_bg_ratio).'"';//rsb Rockthemes Special Block
	}
	
	//Do not add spaces before closing div. This way we can remove the empty divs.
	$return .= '<'.$rpb_grid_tag.' '.$special_grid_html_id_code.' '.$data_details.' '.$data_ratio.' '.$video_bg_fallback_url_data.' class="rockthemes-video-bg rockthemes-unique-grid '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.esc_attr($padding_class).' '.(isset($add_down_arrow) && $add_down_arrow == 'true' ? 'down-arrow-active' : '').'">';
		$return .= '<div class="rockthemes-background-video">';
			$return .= do_shortcode($video_html);
		$return .= '</div>';
		$return .= '<div class="rockthemes-video-background-content" style="'.esc_attr($bg_style).'">';
			$return .= do_shortcode($content);
		$return .= '<div>';

	$return .= rpb_be_sg_footer($atts, $ed);
	
	$return .= '</'.$rpb_grid_tag.'>';

	return $return;	
}
endif;



if(!function_exists('rpb_be_sg_bgimage')):

/*
**	Rock Page Builder BE, Special Grid Background Image
**
*/
function rpb_be_sg_bgimage($atts=array(), $content='', $ed=array()){
		
	extract($atts);
	extract($ed);
	
	$return = '';
	
	//Add Background Image 
	$image_full_screen_data = '';
	$image_full_screen = (isset($image_full_screen) && $image_full_screen === 'true') ? $image_full_screen : false;
	if(!empty($image_full_screen) && $image_full_screen){
		$image_full_screen_data = 'data-rsb-fullscreen="true"';
	}
	
	$bg_style = '';
	if(isset($image_bg_color) &&
		$image_bg_color !== 0){
		$bg_style = 'background:rgba('.rockthemes_hex2rgba($image_bg_color, (((int) $image_bg_color_opacity) / 100)).');';
		$bg_style = 'data-overlay-color="'.esc_attr($bg_style).'"';
	}
	
	$image_full_url = $parallax_bg_image;

	if(isset($parallax_bg_image_id) && !empty($parallax_bg_image_id)){
		
		if(isset($image_sizes) && !empty($image_sizes)){
			$bg_image_size = $image_sizes;
		}

		$image_full_url = wp_get_attachment_image_src($parallax_bg_image_id,$bg_image_size);
		if($image_full_url){
			$image_full_url = $image_full_url[0];
		}else{
			$image_full_url = rockthemes_demo_image($bg_image_size, true);	
		}

	}
	
	$image_full_screen_ratio = isset($image_full_screen_ratio) ? $image_full_screen_ratio : '16_9';
	$image_tile = isset($image_tile) ? $image_tile : 'full';

	//WP-Retina retina image
	$image_retina = rpb_wr2x_get_retina($image_full_url);
			
	//Do not add spaces before closing div. This way we can remove the empty divs.
	$return .= '<'.$rpb_grid_tag.' '.$special_grid_html_id_code.' class="rockthemes-static-bg-image rockthemes-unique-grid '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.(isset($add_down_arrow) && $add_down_arrow == 'true' ? 'down-arrow-active' : '').'" ';
	$return .= 'data-static-bg-image="'.esc_url($image_full_url).'" ';
	$return .= ($image_retina !== false ? 'data-static-bg-image-retina="'.$image_retina.'" ' : '').' ';
	$return .= 'data-static-mask-height="'.esc_attr($parallax_mask_height).'" ';
	$return .= 'data-padding="'.esc_attr($padding_class).'" ';
	$return .= 'data-image-ratio="'.esc_attr($image_full_screen_ratio).'" ';
	$return .= 'data-image-tile="'.esc_attr($image_tile).'" ';
	$return .= $bg_style.' ';
	$return .= $image_full_screen_data.'>';
	$return .= do_shortcode($content);
	
	$return .= rpb_be_sg_footer($atts, $ed);
	
	$return .= '</'.$rpb_grid_tag.'>';

	
	return $return;
}
endif;




if(!function_exists('rpb_be_sg_parallax')):

/*
**	Rock Page Builder BE, Special Grid Parallax
**
*/
function rpb_be_sg_parallax($atts = array(), $content='', $ed=array()){
	
	$bg_image_size = '';
	
	extract($atts);
	extract($ed);
	
	$return = '';
	
	$special_grid_html_id_code = '';
	$special_grid_html_id = isset($special_grid_html_id) ? $special_grid_html_id : false;
	if(!empty($special_grid_html_id) && $special_grid_html_id){
		$special_grid_html_id_code = 'id="'.esc_attr($special_grid_html_id).'" ';
	}
	
	$image_full_screen_data = '';
	$image_full_screen = (isset($image_full_screen) && $image_full_screen === 'true') ? $image_full_screen : false;
	if(!empty($image_full_screen) && $image_full_screen){
		$image_full_screen_data = 'data-rsb-fullscreen="true"';
	}
	
	$bg_style = '';
	if(isset($image_bg_color) && $image_bg_color !== 0){
		$bg_style = 'background:rgba('.rockthemes_hex2rgba($image_bg_color, (((int) $image_bg_color_opacity) / 100)).');';
		$bg_style = 'data-overlay-color="'.esc_attr($bg_style).'"';
	}
	
	$parallax_model = 'height_specific';//Default value
	if(isset($parallax_model) && $parallax_model !== ''){
		$parallax_model = $parallax_model;	
	}
	
	$parallax_size = 'azoom-bgimage-cover';//Default value
	if(isset($parallax_size) && $parallax_size !== ''){
		$parallax_size = 'azoom-bgimage-'.$parallax_size;	
	}
	
	$image_full_screen_ratio = isset($image_full_screen_ratio) ? $image_full_screen_ratio : '16_9';
	$image_tile = isset($image_tile) ? $image_tile : 'full';
	
	$image_full_url = esc_url($parallax_bg_image);
	
	if(isset($parallax_bg_image_id) && !empty($parallax_bg_image_id)){
		
		if(isset($image_sizes) && !empty($image_sizes)){
			$bg_image_size = esc_attr($image_sizes);
		}
	
		$image_full_url = wp_get_attachment_image_src($parallax_bg_image_id, $bg_image_size);
		if($image_full_url){
			$image_full_url = $image_full_url[0];
		}else{
			$image_full_url = rockthemes_demo_image($bg_image_size,true);	
		}
	
	}
	
	//WP-Retina retina image
	$image_retina = rpb_wr2x_get_retina($image_full_url);
	
	
	//Do not add spaces before closing div. This way we can remove the empty divs.
	//$return .= '</div>
	$return .= '<'.$rpb_grid_tag.' '.$special_grid_html_id_code.' class="rockthemes-parallax rockthemes-unique-grid '.esc_attr($parallax_size).' '.esc_attr($border_bottom_class).' '.esc_attr($light_font_class).' '.(isset($add_down_arrow) && $add_down_arrow == 'true' ? 'down-arrow-active' : '').'" ';
	$return .= 'data-parallax-model="'.esc_attr($parallax_model).'" ';
	$return .= 'data-parallax-bg-image="'.esc_url($image_full_url).'" ';
	$return .= ($image_retina !== false ? 'data-parallax-bg-image-retina="'.$image_retina.'" ' : '').' ';
	$return .= 'data-parallax-mask-height="'.esc_attr($parallax_mask_height).'" ';
	$return .= 'data-parallax-padding="'.esc_attr($padding_class).'" ';
	$return .= 'data-image-ratio="'.esc_attr($image_full_screen_ratio).'" ';
	$return .= 'data-image-tile="'.esc_attr($image_tile).'" ';
	$return .= $bg_style.' ';
	$return .= $image_full_screen_data.'>';
	$return .= do_shortcode($content);
	
	$return .= rpb_be_sg_footer($atts, $ed);
	
	$return .= '</'.$rpb_grid_tag.'>';
	
	return $return;
}
endif;



if(!function_exists('rpb_be_columns')){
	function rpb_be_columns($atts, $content = null){	
		extract( shortcode_atts( array(
			'large'		=>	'1',
			'medium'	=>	'1',
			'r'			=>	'',
			'c'			=>	'',
		), $atts ) );
		
		$return = '<div class="large-'.$large.' medium-'.$medium.''.(isset($c) && $c != '' ? ' large-offset-'.$c.' ' : ' ').'columns">'.do_shortcode($content).'</div>';
		
		return $return;
	}
}
add_shortcode('rpb_columns', 'rpb_be_columns');




if(!function_exists('rpb_be_rows')){
	function rpb_be_rows($atts, $content = null){	
		extract( shortcode_atts( array(
			'large'		=>	'',
		), $atts ) );
		
		$return = '<div class="row">'.do_shortcode($content).'</div>';
		
		return $return;
	}
}
add_shortcode('rpb_row', 'rpb_be_rows');






if(!function_exists('rpb_be_rich_text')){
	function rpb_be_rich_text($atts, $content = null){	
		extract( shortcode_atts( array(
			'large'		=>	'',
		), $atts ) );
		
		$content = str_replace('<p>[', '[', $content);
		$content = str_replace(']</p>', ']', $content);

		
		$return = do_shortcode($content);
		
		return $return;
	}
}
add_shortcode('rpb_rtext', 'rpb_be_rich_text');









if(!function_exists('rpb_woo_get_order_box_func')):
function rpb_woo_get_order_box_func(){
	if(!function_exists('woocommerce_catalog_ordering')) return '';
	$return = '';
	ob_start();
	woocommerce_catalog_ordering();
	$return = ob_get_clean();
	
	return '<div class="rpb-woo-sorting-box">'.$return.'</div>';
}
add_shortcode('rpb_woo_get_order_box','rpb_woo_get_order_box_func');
endif;






/*
**	Rock Installation Helper
**
**	This will be included if we logged in or we are doing ajax. It will also check if it's dismissed or finished before
**
**	@since	:	1.3
*/
if ( (defined( 'WP_ADMIN' ) && WP_ADMIN ) ||  ( defined( 'DOING_AJAX' ) && DOING_AJAX )){
	if(get_option('rockthemes_ih_dismiss', 'no') !== 'yes'){
		include_once(AZOOM_PLUGIN_DIR.'ie/rock-installation-helper.php');
	}
}


/*
**	Rock Installation Helper
**
**	This will be included if we logged in or we are doing ajax. It will also check if it's dismissed or finished before
**
**	@since	:	1.3
*/
function xr_one_click_demo_install_ajax(){
	include_once(AZOOM_PLUGIN_DIR.'ie/rock-one_click_install.php');
	
	$GLOBALS['xroc_demo_details'] = isset($_REQUEST['demo_details']) ? $_REQUEST['demo_details'] : array(); 
	
	if(!isset($GLOBALS['rockthemes_export_settings'])){
		xr_one_click_make_export_global();
	}
		
	$return = xroc_progress($_REQUEST['step_data']);
	
	echo $return;
	
	exit;
}
add_action('wp_ajax_xr_one_click_demo_install', 'xr_one_click_demo_install_ajax');


function xr_one_click_make_export_global(){
	
	$saved_settings = get_option('rockthemes_export_settings',false);
	//var_dump($saved_settings);
	
	if($saved_settings){
		echo 'SAVED SETTINGS EXISTS';
		if(is_array($saved_settings)){
			echo 'GLOBAL ON FIRST';
			$GLOBALS['rockthemes_export_settings'] = maybe_unserialize($saved_settings);	
			return;	
		}else{
			if(is_string($saved_settings)){
				$saved_settings = stripslashes($saved_settings);	
			}
			$saved_settings = maybe_unserialize($saved_settings);
			if(is_array($saved_settings)){
				echo 'GLOBAL ON BOTTOM';
				$GLOBALS['rockthemes_export_settings'] = maybe_unserialize($saved_settings);	
				return;	
			}
		}
	}
	
	
	$filename = AZOOM_PLUGIN_DIR.'ie/rockthemes-to-predefined-import-data.txt';
	
	//var_dump($GLOBALS['xroc_demo_details']);
	if(isset($GLOBALS['xroc_demo_details']) && null !== OPTIONS_DIR){
		$filename = OPTIONS_DIR.'demos/'.$GLOBALS['xroc_demo_details']['dir_name'].'/'.$GLOBALS['xroc_demo_details']['xr_filename'];
	}

    WP_Filesystem();

    global $wp_filesystem;

    $data = $wp_filesystem->get_contents( $filename );

    /*	
	$handle = fopen($filename, "r");
	$rockthemes_to_predefined_data = fread($handle, filesize($filename));
	fclose($handle);

	
	$data = $rockthemes_to_predefined_data;
	*/
	
	$data = mb_convert_encoding($data, "UTF-8", "Windows-1252");
	
	$data = preg_replace( "/\r|\n/", "", $data);
		
	$array_data = json_decode($data, true);
	
	if(!is_array($array_data)){
		//echo 'its not an array';
		$array_data = json_decode(stripslashes($data), true);	
	}
	
	//var_dump($array_data['rockthemes_export_settings']);
		
	if(isset($array_data['rockthemes_export_settings'])){
		
		if(!is_array($array_data['rockthemes_export_settings'])){
			$array_data['rockthemes_export_settings'] = stripslashes($array_data['rockthemes_export_settings']);
		}

		$GLOBALS['rockthemes_export_settings'] = json_decode(stripslashes($array_data['rockthemes_export_settings']),true);	
		update_option('rockthemes_export_settings', $array_data['rockthemes_export_settings']);
	}
}






$widget_libs = array('tabs', 'payment_icons', 'image', 'rockthemes_twitter_widget');
foreach($widget_libs as $wl){
	include_once(AZOOM_PLUGIN_DIR.'wp-widgets/'.$wl.'.php');
}





?>