<?php
/*
This file will be holding all of the general functions of the Curvy Slider on the server side.
*/

if(defined('CURVY_STANDALONE')){
	if(isset($_POST['action'])){
		if(function_exists('wp_ajax_' . $_POST['action'])){
			do_action( 'wp_ajax_' . $_POST['action'] );
		}
	}
}




function curvy_save_animation() {
	$user_able_to = function_exists('xr_get_option') ? xr_get_option('user_ableto_curvy_slider','manage_options') : 'manage_options';
	if(!current_user_can($user_able_to)) return;
	// get the submitted parameters
	$incomingData = json_decode(stripslashes($_POST['curvyAnimationData']));
	$incomingData = curvy_validate_save_data($incomingData);
	if(false === $incomingData) die('ERROR : DATA NOT VALID');
	
	$sliderDBName = 'curvy_slider_'.intval($incomingData->id);
	$animationName = $incomingData->animationName;
	$array = $incomingData->scenes;
	
	update_option( $sliderDBName, json_encode($incomingData) ); 

	
	$curvy_slider_references = (json_decode(get_option('curvy_slider_references'),true));
	foreach($curvy_slider_references as $key => $value){
		echo esc_html($curvy_slider_references[$key]['id'].' / '.$incomingData->id);
		if($curvy_slider_references[$key]['id'] == $incomingData->id){
			echo esc_html($curvy_slider_references[$key]['name'].' / '.$incomingData->animationName);
			$curvy_slider_references[$key]['name'] = 	sanitize_text_field($incomingData->animationName);
			$curvy_slider_references[$key]['modified'] = date('m/d/Y');
			break;
		}
	}
	update_option('curvy_slider_references', json_encode($curvy_slider_references));
	
	exit;
}
//IN USE Azoom Animation Builder Save Function
add_action( 'wp_ajax_curvy_save_animation', 'curvy_save_animation' );



function curvy_validate_sanitize_fields($data){
	foreach($data as $key => $val){
		if(is_object($val)){
			$val = curvy_validate_sanitize_fields($val);
		}
		if($key !== 'fonts' && is_string($val)){
			$data->$key = wp_kses($val, array());
		}
	}
	
	return $data;
}


function curvy_validate_save_data($data=array()){
	if(empty($data)) return '';
	if(!is_object($data)){
		$data = json_decode(stripslashes($data));	
	}
	
	if(!is_object($data)) return false;
	
	return curvy_validate_sanitize_fields($data);
}




function curvy_get_slider_list($selected=null, $modal_ID = null, $echo = true){
	$user_able_to = function_exists('xr_get_option') ? xr_get_option('user_ableto_curvy_slider','manage_options') : 'manage_options';
	if(!current_user_can($user_able_to)) return;
	
	$curvy_slider_references = (json_decode(get_option('curvy_slider_references'),true));
	
	$return = '';//'<h4>Choose a Curvy Slider</h4>';
	
	if(!empty($curvy_slider_references)){
	
	$return .= '<select class="curvy_slider_list">';
	
	foreach($curvy_slider_references as $ref){
		if($selected == $ref['shortcode']){
			$return .= '<option value="'.esc_attr(htmlentities($ref['shortcode'])).'" selected>'.esc_html($ref['name']).'</option>';
		}else{
			$return .= '<option value="'.esc_attr(htmlentities($ref['shortcode'])).'">'.esc_html($ref['name']).'</option>';
		}
	}
	
	$return .= '</select>';
	
	}else{
		
		$return .= 'No Curvy Slider Found!';
			
	}
	
	if($echo){
		echo rockthemes_escaped_out_render($return);
	}else{
		return $return;
	}
	
	exit;
}

function curvy_get_slider_list_ajax(){
	curvy_get_slider_list();	
	exit;
}

add_action('wp_ajax_curvy_get_slider_list', 'curvy_get_slider_list');







function curvy_merge_sliders($slider_details, $slider_ids){
	
	$merged_slider_data = array(
		'id'					=>	$slider_details['id'],
		'animationName'			=>	$slider_details['name'],
		'sliderDBName'			=>	'curvy_slider_'.$slider_details['id'],
		'slider_width'			=>	'1440',
		'slider_height'			=>	'800',
		'slider_size_mode'		=>	'responsive',
		'scenes'				=>	array(),
		'fonts'					=>	array(),
  	);
	
	$merged_slider_data = (object) $merged_slider_data;
	
	
	if(!empty($slider_ids) && count($slider_ids)){
		foreach($slider_ids as $id){
			
			$data = json_decode(get_option('curvy_slider_'.intval($id)));
			
			//Update the fonts of the merged slider
			foreach($data->fonts as $font){
				if(empty($merged_slider_data->fonts[$font])){
					$merged_slider_data->fonts[] = $font;
				}
			}
			
			//Update the scenes
			foreach($data->scenes as $scene){
				$merged_slider_data->scenes[] = $scene;	
			}
					
		}
	}

	
	update_option($merged_slider_data->sliderDBName, json_encode($merged_slider_data));
			
}




?>