<?php

/*
**	Main Import / Export UI 
**
**	This function will display the UI of the main import/export 
**
**	@since	:	1.0
**	@return	:	Returns the Import / Export UI 
**
*/
function curvy_slider_import_export_ui(){
	
	//FontAwesome 
	wp_enqueue_style('font-awesome-css',  CURVY_URI.'css/font-awesome.min.css', '','', 'all');
	
	$return = '<div class="curvyslider-main-container">';
	
	$return .= '<h2><img src="'.CURVY_URI.'images/curvy-logo.png" /></h2><br/>';

	
	//Import Field
	$import = '';
	
	$import .= '
		<div class="main-import-area">
			<h3>Load Data <div class="button predefined_import_button">Load Sample Sliders</div></h3>
			<p>Paste your exported data and then click to "Load" button</p>
			<textarea class="import-area"></textarea>
			<div class="button main_import_button">Load</div>
		</div>
		<br/>
	';
	
	//Export Field
	$export = '
		<div class="main-export-area">
			<h3>Export Data</h3>
			<p>Copy the content of this text area. Save it somewhere to import it later</p>
			<textarea class="export-area">'.curvy_slider_get_export_data().'</textarea>
		</div>
	';
		
	$return .= $import;
	
	$return .= '<hr/>';
	
	$return .= $export;
	
	$return .= '</div>';
	
	echo rockthemes_escaped_out_render($return);
	
	curvy_slider_import_export_js();
	curvy_slider_import_export_css();
}


/*
**	Returns the data of the saved sliders.
**
**	@return	:	The data will be json_encoded
*/
function curvy_slider_get_export_data(){
	$references	=	json_decode(get_option('curvy_slider_references',false),true);
	if(!$references) return false;
	
	$datas				=	array();
	
	$database_name		=	'curvy_slider_';
		
	
	foreach($references as $ref){
		$datas[] = get_option($database_name.$ref['id'],array());
	}
	
	return json_encode(
				array(
					'references'	=>	($references),
					'datas'			=>	$datas,
					'site_url'		=>	home_url(),
					'media_url'		=>	wp_upload_dir(),
				)
			);
}

function curvy_slider_import($data){
		
	$data = json_decode(stripslashes($data),true);
	
	//Old version cover
	$old_site_url = $data['site_url'];
	if(isset($data['media_url'])){
		$old_site_url = $data['media_url']['baseurl'];
	}
	
	
	$current_site_url = home_url();
	if(isset($data['media_url'])){
		$current_site_media_url = wp_upload_dir();
		$current_site_url = $current_site_media_url['baseurl'];
	}
	
	//Import references
	$references_imported = update_option('curvy_slider_references', json_encode($data['references']));
		
	//Import form datas
	foreach($data['datas'] as $slider){
		$slider = (str_replace($old_site_url, $current_site_url, stripslashes($slider)));
		$slider = json_decode(($slider), true);
		$database_name = 'curvy_slider_'.intval($slider['id']);
		
		$slider = json_encode($slider);

		update_option($database_name, $slider);
	}
	
	echo "success";
}

function curvy_slider_import_ajax(){
	if(!isset($_POST['data']) || empty($_POST['data'])){
		die( 'error');
	}else{
		echo curvy_slider_import($_POST['data']);
	}
	exit;
}

add_action("wp_ajax_curvy_slider_import", "curvy_slider_import_ajax");

function curvy_slider_import_predefined_data($incoming_data=null){
	global $predefined_import_data;
	
	add_filter( 'intermediate_image_sizes', '__return_empty_array' );

	
	$curvy_sample_dir = CURVY_URI.'images/samples/';
	$new_images = array();
	
	if($incoming_data){
		$data = json_decode(stripslashes($incoming_data),true);
	}else{
		
		$filename = CURVY_DIR.'curvy-slider-predefined-import-data.txt';	

	    WP_Filesystem();

	    global $wp_filesystem;

	    $data = $wp_filesystem->get_contents( $filename );			
		
		/*
		$handle = fopen($filename, "r");
		$data = fread($handle, filesize($filename));
		fclose($handle);
		*/
		
		$data = json_decode(($data),true);		
	}
	
		//Import references
		$references_imported = update_option('curvy_slider_references', json_encode($data['references']));
		
		//Import form datas
		foreach($data['datas'] as $slider){
			$string = (stripslashes($slider));
			
			preg_match_all('/https?\:\/\/[^\" ]+/i', $string, $match);
						
			$URLs = array();
			$editedURLs = array();
			
			foreach ($match as $key => $value){
				foreach ($value as $key2 => $TheUrl){

					$u_exists = false;
					foreach($URLs as $uk => $uv){
						if($uv == $TheUrl){
							$u_exists = true;	
						}
					}

					$e_exists = false;
					foreach($editedURLs as $ek => $ev){
						if($ev == $editedURLs){
							$e_exists = true;	
						}
					}
					if(!$e_exists && !$u_exists){
						$URLs[] = $TheUrl;
						$editedURLs[] = $curvy_sample_dir.basename(($TheUrl));
					}

				}
			}
			
			
			for ($i=0;$i<count($URLs);$i++){
				$pos = strpos($string,$URLs[$i]);
				if ($pos !== false) {
					$uploaded_src = $editedURLs[$i];
					preg_match('/[^\?]+\.(jpg|jpe|jpeg|gif|png)/i', $editedURLs[$i], $img_match);
					if(!empty($img_match) && count($img_match) > 0){
						
						$image_already_loaded = false;
						if(!empty($new_images)){
							foreach($new_images as $ni){
								if($ni['old'] == $editedURLs[$i]){
									$uploaded_src = $ni['new'];
									$image_already_loaded = true;	
								}
							}
						}
						
						if(!$image_already_loaded){
							$uploaded_src = ((string)curvy_demo_upload_images($editedURLs[$i]));
							$new_images[] = array('old'=>$editedURLs[$i],'new'=>$uploaded_src);
						}
					}

					$string = str_replace($URLs[$i], $uploaded_src, $string);
				}
			}
			

						
			$slider = json_decode(($string), true);
			$database_name = 'curvy_slider_'.$slider['id'];
			
			$slider = json_encode($slider);

			update_option($database_name, $slider);
		}
		
	return "success";
	
}
add_action("wp_ajax_curvy_slider_import_predefined_data", "curvy_slider_import_predefined_data");

function curvy_slider_import_predefined_data_ab(){
	echo curvy_slider_import_predefined_data();
	exit;	
}
add_action('wp_ajax_curvy_slider_import_predefined_data_ab', 'curvy_slider_import_predefined_data_ab');




/*
**	Upload Curvy Files to the Media Directory
**
*/
function curvy_demo_upload_images($url = '',$desc=''){
	if(empty($url)) return 'no-image';
	$url = esc_url(sanitize_text_field($url));
	if(!is_string($url) || $url == '' || (strpos($url, '.jpg') === false && strpos($url, '.png') === false &&
		strpos($url, '.gif') === false && strpos($url, '.svg') === false)) return 'no-image';
		

	$tmp = download_url( $url );
	$post_id = 0;//0 will not attach to any post id
	$file_array = array();

	// Set variables for storage
	// fix file filename for query strings
	preg_match('/[^\?]+\.(jpg|jpe|jpeg|gif|png)/i', $url, $matches);
	$file_array['name'] = basename($matches[0]);
	$file_array['tmp_name'] = $tmp;

	// If error storing temporarily, unlink
	if ( is_wp_error( $tmp ) ) {
		@unlink($file_array['tmp_name']);
		$file_array['tmp_name'] = '';
	}
	// do the validation and storage stuff
	$id = media_handle_sideload( $file_array, $post_id, $desc );

	// If error storing permanently, unlink
	if ( is_wp_error($id) ) {
		@unlink($file_array['tmp_name']);
		return '';//was $id - Removed to skip missed images errors;
	}
	
	$src = wp_get_attachment_url( $id );
	//var_dump($src);	
	return $src;
}



function curvy_slider_import_export_js(){
	
?>
<script type="text/javascript">

jQuery(document).ready(function(){
	jQuery(document).on("click",".main_import_button", function(){
		
		var that = jQuery(this);
		var button_content = that.html();
		that.html(button_content+' <i class="fa fa-refresh fa-spin"></i>');
		
		var data = jQuery(".import-area").val();

		jQuery.post(ajaxurl, {data:data, action:"curvy_slider_import"}, function(data){
			//console.log(data);
			if(that.find(".fa fa-refresh").length) that.find(".fa fa-refresh").remove();
			
			
			if(data == 'success'){
				var newLink = "?page=curvy_slider";
				var siteLocation = document.location.toString().substr(0,document.location.toString().lastIndexOf("?"))
				document.location = siteLocation+newLink;
			}
		});
	});
	
	jQuery(document).on("click",".predefined_import_button", function(){
		var that = jQuery(this);
		var button_content = that.html();
		that.html(button_content+' <i class="fa fa-refresh fa-spin"></i>');
		var nonce = "<?php echo wp_create_nonce('curvy_slider_image_nonce'); ?>";

		jQuery.post(ajaxurl, {action:"curvy_slider_import_predefined_data_ab", curvy_slider_image_nonce:nonce}, function(data){
			console.log("DATA "+data);
			if(that.find(".fa fa-refresh").length) that.find(".fa fa-refresh").remove();
			
			if(data == 'success'){
				var newLink = "?page=curvy_slider";
				var siteLocation = document.location.toString().substr(0,document.location.toString().lastIndexOf("?"))
				document.location = siteLocation+newLink;
			}
		});
	});
});

</script>

<?php
}

function curvy_slider_import_export_css(){
?>	
	<style type="text/css">
	.curvyslider-main-container{margin-right:20px;}
	.import-area, .export-area{
		width:100%;
		min-height:240px;	
	}
	</style>
<?php
}

?>