<?php


//Curvy Slider FrontEnd URL
if(!defined('CURVY_FE_URI')):
define('CURVY_FE_URI', plugins_url('',(__FILE__)));
endif;


function curvy_frontend_shortcode($atts){
	extract( shortcode_atts( array(
			'id'					=> '',
			'auto_play'				=> 'true',
			'slider_navigation'		=> 'nav_regular',
			'side_navigation'		=> 'false',
			'slider_bottom_divider' => ''
	), $atts ) );	
	
	if($id === '') return;
		
	$dec = '';
	if(!defined('ROCK_DEBUG') || !ROCK_DEBUG) $dec = '.min';
	
	$sliderDBName = 'curvy_slider_'.intval($id);
	$saved_settings = (get_option($sliderDBName, array()));
	
	if(empty($saved_settings)) return;
	
	$GLOBALS['curvy_html_id'] = isset($GLOBALS['curvy_html_id']) ? $GLOBALS['curvy_html_id'] + 1 : 0;
	
	$curvy_html_id = $GLOBALS['curvy_html_id'];

	$canvasID = "curvy-canvas-".esc_attr($curvy_html_id);
	
	$loader = CURVY_FE_URI.'/images/ajax-loader.gif';
	
	if('' !== $loader){
		$loader = '<img src="'.esc_url($loader).'" alt="Loader" />';
	}
	
	if($loader !== ''){
		$loader = '
			<div class="loader-container">
				<div style="text-align:center; display: inline-block;position: relative;">
					'.$loader.'
				</div>
			</div>
		';		
			
	}
	
	if(function_exists('rockthemes_loader_motion')){
		$loader = rockthemes_loader_motion();	
		
		if(rockthemes_browser_ie9()){
			$loader = '<img src="'.esc_url(F_WAY.'/images/ajax-loader.gif').'" class="gif-loader" alt="Loader" />';
		}
		
		if($loader !== ''){
			$loader = '
				<div class="loader-container rockthemes-css-loader">
					<div style="text-align:center; display: inline-block;position: relative;">
						'.$loader.'
					</div>
				</div>
			';		
				
		}
	}
		
	
	$canvas_supported = true;
		
	wp_enqueue_script('rockthemes-curvy-slider-caat', CURVY_FE_URI.'/frontend/js/caat.min.js', array('jquery'));

	$ssl = is_ssl() ? 'https' : 'http';
	
	wp_enqueue_script('google-webfont-api', $ssl.'://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js', array());
	
	wp_enqueue_script('rockthemes-curvy-slider-js', CURVY_FE_URI.'/frontend/js/curvy-slider-frontend.min.js', array('jquery', 'google-webfont-api'));
	
	wp_enqueue_style('rockthemes-curvy-slider-style',  CURVY_FE_URI.'/frontend/css/curvy-slider-style.css', '','', 'all');

	//For fullwidth slider
	$full_width = "false";
	
	//For small screens remove the padding to make the slider look fullwidth
	$responsive_full_width = "true";
	
	$row_max_width = '62.5em';
	
	$return = '';
		
	if($canvas_supported){
		$return .= '
		<div class="rockthemes-curvy-slider curvy-inline-nav">
			'.$loader.'
			<div id="curvy-slider-main-container-'.intval($curvy_html_id).'" class="curvy-slider" style="opacity:0">
				<div id="azoom-animID">
					<div id="experiment-holder">
						<canvas id="'.esc_attr($canvasID).'"></canvas>
						<div class="clear"></div>
					</div>
				</div>
		';
	}else{
		$return .= '
		<div class="rockthemes-curvy-slider curvy-inline-nav" style="opacity:0;">
			<div id="curvy-slider-main-container-'.intval($curvy_html_id).'" class="rockthemes-curvy-slider">
				<div class="curvy-slider-fallback-canvas"></div>
		';
	}
	
	if($full_width == "true"){
		$return .= '<div class="row">';
	}
	
	$style = '';
	
	
	if(!$canvas_supported) $style = '';
	
	$navigation = '';
	switch($slider_navigation){
		case 'nav_regular':
		$navigation = '
			<div class="curvy-slider-nav-container">
				<div class="curvy-slider-nav">
					<div class="curvy-start-button curvy-main-nav-elem" data-ref="curvy-slider-main-container-'.intval($curvy_html_id).'"><i id="playAllScenesBtn" class="'.(defined('RPB_USE_ICOMOON') ? 'icomoon icomoon-icon-play3' : 'fa fa-play').'"></i></div>
					<div id="stopAllScenesBtn" class="curvy-stop-button curvy-main-nav-elem" data-ref="curvy-slider-main-container-'.intval($curvy_html_id).'"><i class="'.(defined('RPB_USE_ICOMOON') ? 'icomoon icomoon-icon-stop2' : 'fa fa-pause').'"></i></div>
				</div>
			</div>
		';
		break;
		
		case 'replay':
		$navigation = '
			<div class="curvy-slider-nav-container">
				<div class="curvy-slider-nav">
					<div class="curvy-replay-button curvy-main-nav-elem" data-ref="curvy-slider-main-container-'.intval($curvy_html_id).'"><i class="'.(defined('RPB_USE_ICOMOON') ? 'icomoon icomoon-icon-loop2' : 'fa fa-play').'"></i></div>
				</div>
			</div>
		';
		break;
	}
	
	//$arrow_navigation = true;
	if($side_navigation === 'true'){
		$arrow_nav_html = '
			<div class="curvy-slider-side-nav-container">
				<a class="curvy-side-nav-left escapea" data-ref="curvy-slider-main-container-'.intval($curvy_html_id).'">
					<i class="'.(defined('RPB_USE_ICOMOON') ? 'icomoon animate-icon animate-to-left icomoon-icon-previous11' : '').'"></i>
				</a>
				<a class="curvy-side-nav-right escapea" data-ref="curvy-slider-main-container-'.intval($curvy_html_id).'">
					<i class="'.(defined('RPB_USE_ICOMOON') ? 'icomoon animate-icon animate-to-right icomoon-icon-next15' : '').'"></i>
				</a>
			</div>
		';
		
		$navigation .= $arrow_nav_html;//.$navigation;
	}
	
	$script = '';
	if($curvy_html_id === 1 || 1==1){
	$script .= '
		<script type="text/javascript">
			jQuery(document).ready(function(){
				jQuery.curvySlider("'.esc_attr($id).'","curvy-slider-main-container-'.intval($curvy_html_id).'", "'.esc_attr($canvasID).'", "'.esc_attr($auto_play).'", "'.esc_attr($slider_navigation).'", '.$saved_settings.');
			});
		</script>
	';
	}
	
	$under_curvy_slider = '';
	
	switch($slider_bottom_divider){
		case '':
		
		break;
		
		case 'use_border':
		$under_curvy_slider = '<div class="curvy-slider-bottom curvy-border-margin"><div class="curvy-border-bottom"></div></div>';
		break;
		
		case 'use_shadow':
		$under_curvy_slider = '<div class="curvy-slider-bottom"><div class="shadow-divider-down"><img src="'.esc_url(CURVY_FE_URI.'images/shadow-divider-down.png').'" alt="Divider" /></div></div>';
		break;	
	}
	
	$under_curvy_slider = apply_filters('under_curvy_slider', $under_curvy_slider);
	
	return $return.$navigation.'</div>'.$under_curvy_slider.'</div>'.$style.$script;
	//This closing div is closing the main container id div

}


add_shortcode('curvyslider','curvy_frontend_shortcode');




?>