<?php
/*
Plugin Name: Azoom Main
Plugin URI:  http://curvyslider.com
Description: Main Plugin of Azoom Theme
Version:     1.1
Author:      Rockthemes
Author URI:  http://themeforest.net/user/XanderRock?ref=XanderRock
*/

require dirname( __FILE__ ) . '/global-functions.php';
require dirname( __FILE__ ) . '/curvy-slider/curvy-shortcode.php';


/*
**	Config File of RPB
**
**	This file will be also included in RPB in rock-builder.php file. But RPB now has a feature to be disabled
**	If RPB is disabled this will include the file as well
**	include_once statement will not cause any conflict for multiple use http://www.php.net/manual/en/function.include-once.php
**
**	@since	:	1.3
*/
include_once(AZOOM_PLUGIN_DIR.'rock-builder/rock-builder-config.php');

//Rock Page Builder
include_once(AZOOM_PLUGIN_DIR .'rock-builder/rock-builder.php');

//Rock Page Builder
include_once(AZOOM_PLUGIN_DIR .'rock-builder/rock-builder-ui.php');

//Curvy Slider
include_once(AZOOM_PLUGIN_DIR.'curvy-slider/load-curvy.php');



/*
**	Regular Featured Image Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_featuredimage')){
	function rockthemes_shortcode_make_featuredimage($atts){
		extract( shortcode_atts( array(
				'size' => 'large',
		), $atts ) );	

		global $post;

		if(empty($post)) return;
		
		$size = (string) $size;
		
		$thumbnail = azoom_get_featured_image(false, esc_attr($size), false);

		$return = $thumbnail;
		return $return;
	}
}

add_shortcode('rockthemes_featuredimage','rockthemes_shortcode_make_featuredimage');

/*
**	End of Regular Featured Image Shortcode
*/



/*
**	Swiper Slider Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_swiperslider')){
	function rockthemes_shortcode_make_swiperslider($atts){
		
		extract( shortcode_atts( array(
				'images'				=>	'',
				'size'					=>	'thumbnail',
				'max_width'				=>	'480px',
				'activate_auto_play'	=>	'false',
				'auto_play_time'		=>	0,
				'arrow_nav'				=>	'arrows',
		), $atts ) );	
		
		
		global $rockthemes_wordpress_url;

		if(empty($images) || strpos($images,',') < -1) return;
		
		wp_enqueue_script('jquery');
		wp_enqueue_style( 'swiper-css', AZOOM_PLUGIN_URI.'/css/idangerous.swiper-2.css', '', '', 'all' );
		wp_enqueue_script('swiper-js', AZOOM_PLUGIN_URI.'/js/idangerous.swiper-2.7.js', array('jquery'), '2.7.0', true);
		
		if(isset($GLOBALS['rockthemes_swiperslider'])){
			$GLOBALS['rockthemes_swiperslider']++;
		}else{
			$GLOBALS['rockthemes_swiperslider'] = 1;
		}
		
		$id = esc_attr('swiper'.$GLOBALS['rockthemes_swiperslider']);
		$pagination = esc_attr('pagination'.$GLOBALS['rockthemes_swiperslider']);
		$sliderClassName = esc_attr('azoom-swiperslider-main-'.$GLOBALS['rockthemes_swiperslider']);
				
		$imagesArray = explode(',',$images);
		
		$return = '';
				
		$max_width = $max_width != "" ? $max_width : '480px';
				
		$return .= '<div class="azoom-swiperslider swiper-single-element '.esc_attr($sliderClassName).'" '.($activate_auto_play === 'true' ? 'data-auto-play="true" data-auto-play-time="'.esc_attr($auto_play_time).'" ' : '').'>';
		if($arrow_nav === 'arrows'){
			$return .= '
				<a id="swiper-arrow-left" class="side-arrow-left azoom-transition escapea" href="#"><i class="icomoon icomoon-icon-previous11"></i></a>
    			<a id="swiper-arrow-right" class="side-arrow-right azoom-transition escapea" href="#"><i class="icomoon icomoon-icon-next15"></i></a>';	
		}
		$return .= '<div class="swiper-container '.esc_attr($id).'">';
		$return .= '<div class="swiper-wrapper">';
		
		$width = 0;
		$height = 5000;
		foreach($imagesArray as $image){
			$image_obj = '';
			if(strpos($image, 'rockthemes_image_ids') > -1){
				$image_obj = explode('rockthemes_image_ids', $image);
			}
						
			$image_id = '';
			if(isset($image_obj) && isset($image_obj[1]) && !empty($image_obj[1]) && $image_obj[1]){
				$image_id = $image_obj[1];
			}elseif(isset($image_obj) && isset($image_obj[0])){
				$image_id = rockthemes_get_image_id_from_url($image_obj[0]);
			}else{
				$image_id = rockthemes_get_image_id_from_url($image);
			}
			
			$this_image = '';
			if(!xr_get_option('remove_image_wh', true)){
				$this_image = wp_get_attachment_image($image_id, $size);
			}else{
				$src = wp_get_attachment_image_src($image_id, $size);
				
				//If the image file do not have an ID or the attachment is not an image, skip it. Swiper does not support videos.
				if(!isset($src) || !isset($src[0])) continue;
				
				$this_image = '<img src="'.esc_attr($src[0]).'" alt="'.get_post_meta(esc_attr($image_id), '_wp_attachment_image_alt', true).'" />';
			}
			
			if((!$this_image && $image_id && $image_id != '') || (!$image_id && $image && $image_obj == '')){
				$this_image = rockthemes_demo_image($size);
			}
			
			$return .= '<div class="swiper-slide">'.$this_image.'</div>';	
		}
		
		$return .= '</div>';
		$return .= '</div>';
		$return .= '<div class="swiper-pagination '.esc_attr($pagination).'"></div>';
		$return .= '</div>';
		
		$use_shadow = 'false';
		if($use_shadow === 'true'){
			$return .= '<div class="hr-shadow-mask shadow-dark"><hr class="hr-shadow active shadow-effect curve curve-hz-1"></div>';
		}
		
		//End of HTML
		
		return $return;
	}
}

add_shortcode('rockthemes_swiperslider','rockthemes_shortcode_make_swiperslider');

/*
**	End of Swiper Slider Shortcode
*/





/*
**	Pricing Table Shortcode
*/
//Pricing table inside table
if(!function_exists('rockthemes_shortcode_make_pricingtable_table')){
function rockthemes_shortcode_make_pricingtable_table($atts, $content=null){
	extract( shortcode_atts( array(
			'package_name'		=>	'Standard',
			'package_detail'	=>	'Classic Plan',
			'package_featured'	=>	'false',
			'package_time'		=>	'',
			'package_price'		=>	'',
			'button_type'		=>	'green',
			'button_name'		=>	'Buy Now!',
			'button_link'		=>	'',
			'featured_text'		=>	'Featured',
			'max_width'			=>	'480px',
			'show_details'		=>	'true',
			'currency'			=>	'$'
	), $atts ) );	
	
	$table_columns = $GLOBALS['rockthemes_pt_table_columns'];
	
	switch($table_columns){
		case 12:
		$button_width = 30;
		break;
		
		case 6:
		$button_width = 50;
		break;
		
		case 4:
		$button_width = 60;
		break;
		
		case 3:
		$button_width = 80;
		break;
		
		default;
		$button_width = 100;
		break;
	}
	
	$link = $button_link != '' ? true : false;

	$options = '';
	
	$i=0;
	while(!empty($atts['option_name'.$i])){
		$icon_html = '';
		
		if(isset($atts['icon_class'.$i]) && !empty($atts['icon_class'.$i])){
			$icon_html = '<i class="'.esc_attr($atts['icon_class'.$i]).'"></i>';
		}
		
		if(isset($atts['icon_url'.$i]) && !empty($atts['icon_url'.$i])){
			$icon_html = '<img src="'.esc_attr($atts['icon_url'.$i]).'" />';
		}
		
		$options .= '<div class="azoom-pt-option">'.$icon_html.''.esc_attr($atts['option_value'.$i]).' '.($show_details === 'true' ? '<span class="azoom-pt-option-desc">'.esc_attr($atts['option_name'.$i]).'</span>' : '').'</div>';
		$i++;	
	}
	
	//Start columns div regular columns for tables
	$return = '<li>';
	
	if($package_featured != "true") $return .= '<br />';
	
	//Start azoom columns
	$return .= '<div class="azoom-pt-columns border-with-radius  center-element full-element" style="max-width:'.esc_attr($max_width).'">';
	
	$return .= '<div class="azoom-pt-header">';
	
	//Check if featured
	if($package_featured === "true"){
		$return .= '<div class="azoom-pt-featured"><i class="icomoon icomoon-icon-star3"></i> '.esc_attr($featured_text).'</div>';
	}

	$return .= '<div class="azoom-pt-package-name"><h3>'.esc_attr($package_name).'</h3></div>';
	
	$return .= '
	<h4 class="price-details">
	<span class="currency">'.esc_attr($currency).'</span>
	<span class="price">'.esc_attr($package_price).'</span>
	<span class="time">'.esc_attr($package_time).'</span>
	<span class="detail">'.esc_attr($package_detail).'</span>
	</h4>';
			
	$return .= do_shortcode($content);

	
	$return .= '</div>'; //Close header div
	
	$return .= $options;
	
	
	$return .= '</div>'; //Close azoom columns div
	
	$return .= '<br/></li>'; //Close columns div
		
	return $return;
}
}//end of if function exists
add_shortcode('rockthemes_pricingtable_table','rockthemes_shortcode_make_pricingtable_table');

if(!function_exists('rockthemes_shortcode_make_pricingtable')){
function rockthemes_shortcode_make_pricingtable($atts, $content=null){	
	extract( shortcode_atts( array(
			'total_tables' => 3,
			'max_width' => '480px',
	), $atts ) );	
	
	//Find columns of each table element
	$table_columns = rockthemes_shortcode_find_total_columns_for_pricingtable(intval($total_tables));
	$GLOBALS['rockthemes_pt_table_columns'] = $table_columns;
		
	
	$tables = do_shortcode($content);
	
	$return = '<div class="azoom-pt">';
	
	
	$return .= '<ul class="large-block-grid-'.esc_attr($total_tables).' medium-block-grid-1 small-block-grid-1">'.$tables.'</ul>';
	
	
	$return .= '</div>';
	
	return $return;
}
}//end of if function exists
add_shortcode('rockthemes_pricingtable','rockthemes_shortcode_make_pricingtable');

if(!function_exists('rockthemes_shortcode_find_total_columns_for_pricingtable')){
function rockthemes_shortcode_find_total_columns_for_pricingtable($tables){
	switch($tables){
		case 1:
		return 12;
		break;
		
		case 2:
		return 6;
		break;
		
		case 3:
		return 4;
		break;
		
		case 4:
		return 3;
		break;
		
		case 5:
		return 2;
		break;	
	}
	
	return 0;
}
}
/*
**	End of Pricing Table Shortcode
*/




/*
**	Toggles Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_toggles')){
	function rockthemes_shortcode_make_toggles($atts, $content = null){
		//toggle_type refers to "single-mode" or "multiple-mode"
		extract( shortcode_atts( array(
				'toggle_type' => 'single-mode',
				'toggle_use_hash'	=>	'no',
				'open_toggle_index' => '0',
				'boxed_layout' => 'false'
		), $atts ) );	
				
		if(isset($GLOBALS['rockthemes_toggles'])){
			$GLOBALS['rockthemes_toggles']++;
		}else{
			$GLOBALS['rockthemes_toggles'] = 1;
		}
		
		$GLOBALS['rockthemes_toggles_open_counter'] = 0;
		$GLOBALS['rockthemes_open_toggle_index'] = intval(is_int(intval($open_toggle_index)) ? $open_toggle_index : 0);

		$id = 'rock-toggles-'.$GLOBALS['rockthemes_toggles'];
		
		$GLOBALS['rockthemes_toggles_hash'] = ($toggle_use_hash === 'yes' ? true : false);
		
		$toggles_single_data = do_shortcode($content);
		
		$return = '';
		
		if($boxed_layout == "true") $return .= '<div class="boxed-layout padding">';
		
		$return .= '<div id="rock-toggles-'.esc_attr($GLOBALS['rockthemes_toggles']).'" class="row rock-toggles-container '.($toggle_type === 'multiple-mode' ? 'multiple-mode' : 'single-mode').' '.($GLOBALS['rockthemes_toggles_hash'] ? 'toggle-hash-active' : '').'">';
				
		$return .= $toggles_single_data;
		
		$return .= '</div>';
		
		if($boxed_layout == "true") $return .= '</div>';
		
		
		return $return;		
	}
	
}

add_shortcode("rockthemes_toggles", "rockthemes_shortcode_make_toggles");


if(!function_exists('rockthemes_shortcode_make_toggles_single')){
	function rockthemes_shortcode_make_toggles_single($atts, $content = null){	
		extract( shortcode_atts( array(
				'title' => 'Toggle New',
				'toggle_hash'	=>	'',
				'use_shadow' => 'false',
				'icon_class' => '',
				'icon_url' => ''
		), $atts ) );
		
		$use_icon = false;
		$use_url = false;
		$icon_html = '';
		$icon_url_html = '';
		
		if($icon_class != ""){
			$icon_html = '<i class="'.esc_attr($icon_class).' rock-toggle-header-icon"></i>';
			$use_icon = true;
		}
		
		if($icon_url != ""){
			$icon_html = '<img src="'.esc_attr($icon_url).'" class="rock-toggle-header-icon" />';
			$use_icon = true;	
		}

		
		$ref_id = 'toggles-'.$GLOBALS['rockthemes_toggles'];

		//frameborder=\"0\" was included in the replace field (not search field).
		//Youtube Support
		$content = preg_replace("/\s*[a-zA-Z\/\/:\.]*youtube.com\/watch\?v=([a-zA-Z0-9\-_]+)([a-zA-Z0-9\/\*\-\_\?\&\;\%\=\.]*)/i","<iframe width=\"420\" height=\"315\" src=\"//www.youtube.com/embed/$1\" allowfullscreen></iframe>",$content);
		
		$return = '';
		if($GLOBALS['rockthemes_toggles_open_counter'] === $GLOBALS['rockthemes_open_toggle_index']){
			$return .= '<div class="large-12 columns active" '.(($toggle_hash !== '' && $GLOBALS['rockthemes_toggles_hash']) ? 'id="'.esc_attr($toggle_hash).'"' : '').' >';
			$return .= '<div class="rock-toggle-header padding '.($use_shadow == 'true' ? 'azoom-small-box-shadow' : '').'">'.($use_icon ? $icon_html : '').''.esc_attr($title).'<i class="'.(defined('RPB_USE_ICOMOON') ? 'icomoon icomoon-icon-arrow-up6' : 'fa fa-chevron-up').' right main-toggle-icon"></i></div>';
			$return .= '<div class="clear"></div>';
			$return .= '<div class="rock-toggle-content padding-2x">'.do_shortcode(rock_check_p($content)).'</div>';
		}else{
			$return .= '<div class="large-12 columns" '.(($toggle_hash !== '' && $GLOBALS['rockthemes_toggles_hash']) ? 'id="'.esc_attr($toggle_hash).'"' : '').' >';
			$return .= '<div class="rock-toggle-header padding '.($use_shadow == 'true' ? 'azoom-small-box-shadow' : '').'">'.($use_icon ? $icon_html : '').''.esc_attr($title).'<i class="'.(defined('RPB_USE_ICOMOON') ? 'icomoon icomoon-icon-arrow-down6' : 'fa fa-chevron-down').' right main-toggle-icon"></i></div>';
			$return .= '<div class="clear"></div>';
			$return .= '<div class="rock-toggle-content padding-2x" style="display:none;">'.rock_check_p(do_shortcode($content)).'</div>';
		}
				
		$return .= '</div>';
		
		$GLOBALS['rockthemes_toggles_open_counter']++;
		
		return $return;
	}
}

add_shortcode("rockthemes_toggles_single","rockthemes_shortcode_make_toggles_single");

/*
**	End of Toggles Shortcode
*/





/*
**	Tabs Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_tabs')){
	function rockthemes_shortcode_make_tabs($atts, $content = null){
		//tab_type refers to "tab-top" , "tab-left" , "tab-right"
		extract( shortcode_atts( array(
				'tab_type' => 'tab-left',
				'tab_use_hash'	=>	'no',
				'open_tab_index' => '0',
				'boxed_layout' => 'false',
				'use_shadow' => 'false'
		), $atts ) );	
				
		$shadow = '';
		if($use_shadow !== "false"){$shadow .= 'tab-shadow';}
		
		if(isset($GLOBALS['rockthemes_tabs'])){
			$GLOBALS['rockthemes_tabs']++;
		}else{
			$GLOBALS['rockthemes_tabs'] = 1;
		}
		
		$GLOBALS['rockthemes_tabs_open_counter'] = 0;
		$GLOBALS['rockthemes_open_tab_index'] = intval(is_int(intval($open_tab_index)) ? $open_tab_index : 0);
		$GLOBALS['rockthemes_tabs-'.$GLOBALS['rockthemes_tabs'].'-headers'] = '';
		$GLOBALS['rockthemes_tabs-'.$GLOBALS['rockthemes_tabs'].'-contents'] = '';
		
		$tab_left_header_column = '';
		$tab_left_content_column = '';
		if($tab_type == "tab-left" || $tab_type == "tab-right"){
			$tab_left_header_column = 'large-3 columns';
			$tab_left_content_column = 'large-9 columns';
		}
		
		$id = 'rock-tabs-'.$GLOBALS['rockthemes_tabs'];
		$GLOBALS['rockthemes_tabs_hash'] = ($tab_use_hash === 'yes' ? true : false);
		
		$tabs_single_data = do_shortcode($content);
		
		$return = '';
		
		
		if($boxed_layout == "true"){ $return .= '<div class="boxed-layout padding">';}
		
		$return .= '<div id="rock-tabs-'.esc_attr($GLOBALS['rockthemes_tabs']).'" class="row rock-tabs-container row '.($GLOBALS['rockthemes_tabs_hash'] ? 'tab-hash-active' : '').' '.esc_attr($tab_type).' '.$shadow.'">';
		
		if($tab_type == "tab-top"){
		
			$return .= '<div class="rock-tabs-header-container large-12 columns">';
			
			$return .= $GLOBALS['rockthemes_tabs-'.esc_attr($GLOBALS['rockthemes_tabs']).'-headers'];
			
			$return .= '</div>';//Close rock-tabs-header-container div
		
		}else if($tab_type == "tab-left"){
			
			$return .= '<div class="rock-tabs-header-container '.esc_attr($tab_left_header_column).'">';
			
			$return .= $GLOBALS['rockthemes_tabs-'.esc_attr($GLOBALS['rockthemes_tabs']).'-headers'];
			
			$return .= '</div>';//Close rock-tabs-header-container div

		}else if($tab_type == "tab-right"){
			$return .= '<div class="rock-tabs-content-container '.esc_attr($tab_left_content_column).'">';
			
			$return .= '<div class="tabs-motion-container">';
			
			$return .= $GLOBALS['rockthemes_tabs-'.esc_attr($GLOBALS['rockthemes_tabs']).'-contents'];
			
			$return .= '</div>';//Close tabs-motion-container div
			
			$return .= '</div>';//Close rock-tabs-content-container div
			
			$return .= '<div class="rock-tabs-header-container '.esc_attr($tab_left_header_column).'">';
			
			$return .= $GLOBALS['rockthemes_tabs-'.esc_attr($GLOBALS['rockthemes_tabs']).'-headers'];
			
			$return .= '</div>';//Close rock-tabs-header-container div
		}
		
		
		if($tab_type == "tab-top"){
			
			$return .= '<div class="rock-tabs-content-container large-12 columns">';
			
			$return .= '<div class="tabs-motion-container">';
			
			$return .= $GLOBALS['rockthemes_tabs-'.$GLOBALS['rockthemes_tabs'].'-contents'];
			
			$return .= '</div>';//Close tabs-motion-container div
			
			$return .= '</div>';//Close rock-tabs-content-container div
			
		}else if($tab_type == "tab-left"){
			
			$return .= '<div class="rock-tabs-content-container '.esc_attr($tab_left_content_column).'">';
			
			$return .= '<div class="tabs-motion-container">';
			
			$return .= $GLOBALS['rockthemes_tabs-'.$GLOBALS['rockthemes_tabs'].'-contents'];
			
			$return .= '</div>';//Close tabs-motion-container div
			
			$return .= '</div>';//Close rock-tabs-content-container div
			
		}
				
		//$return .= $tabs_single_data;
		
		$return .= '</div>';
		
		if($boxed_layout == "true"){ $return .= '</div>';}
		
		return $return;		
	}
	
}

add_shortcode("rockthemes_tabs", "rockthemes_shortcode_make_tabs");


if(!function_exists('rockthemes_shortcode_make_tabs_single')){
	function rockthemes_shortcode_make_tabs_single($atts, $content = null){	
		extract( shortcode_atts( array(
				'title' => 'Tab New',
				'tab_hash' => '',
				'use_shadow' => 'false',
				'icon_class' => '',
				'icon_url' => ''
		), $atts ) );
				
		$use_icon = false;
		$use_url = false;
		$icon_html = '';
		$icon_url_html = '';
		
		if($icon_class != ""){
			$icon_html = '<i class="'.esc_attr($icon_class).' rock-tab-header-icon"></i>';
			$use_icon = true;
		}
		
		if($icon_url != ""){
			$icon_html = '<img src="'.esc_attr($icon_url).'" class="rock-tab-header-icon" />';
			$use_icon = true;	
		}
		
		
		$ref_id = 'rockthemes_tabs-'.$GLOBALS['rockthemes_tabs'];
				
		if($use_shadow == 'true'){
			$shadow_code = '<div class="hr-shadow-mask"><hr class="hr-shadow active shadow-effect curve curve-hz-1"></div>';
		}else{
			$shadow_code = '';
		}
		
		if($GLOBALS['rockthemes_tabs_open_counter'] === $GLOBALS['rockthemes_open_tab_index']){
			$GLOBALS[$ref_id.'-headers'] .= '
				<div class="rock-tab-header active" '.(($tab_hash !== '' && $GLOBALS['rockthemes_tabs_hash']) ? 'id="'.esc_attr($tab_hash).'"' : '').' data-tab-ref="rock-tabs-'.esc_attr($GLOBALS['rockthemes_tabs']).'" data-content-ref="content-'.esc_attr($GLOBALS['rockthemes_tabs_open_counter']).'">'.($use_icon ? $icon_html : "")." ".esc_attr($title).'</div>
			';
			$GLOBALS[$ref_id.'-contents'] .= '
				<div class="content-'.esc_attr($GLOBALS['rockthemes_tabs_open_counter']).' tabs-motion-content padding-2x active">'.do_shortcode($content).'</div>
			';
		}else{
			$GLOBALS[$ref_id.'-headers'] .= '
				<div class="rock-tab-header" '.(($tab_hash !== '' && $GLOBALS['rockthemes_tabs_hash']) ? 'id="'.esc_attr($tab_hash).'"' : '').' data-tab-ref="rock-tabs-'.esc_attr($GLOBALS['rockthemes_tabs']).'" data-content-ref="content-'.esc_attr($GLOBALS['rockthemes_tabs_open_counter']).'">'.($use_icon ? $icon_html : "")." ".esc_attr($title).'</div>
			';
			$GLOBALS[$ref_id.'-contents'] .= '
				<div class="content-'.$GLOBALS['rockthemes_tabs_open_counter'].' tabs-motion-content padding-2x hide">'.do_shortcode($content).'</div>
			';
		}

		$GLOBALS['rockthemes_tabs_open_counter']++;
		return ;
	}
}

add_shortcode("rockthemes_tabs_single","rockthemes_shortcode_make_tabs_single");

/*
**	End of Tabs Shortcode
*/


/*
**	Iconic Text Shortcode
*/
if(!function_exists('rockthemes_shortcode_make_iconictext')){
	function rockthemes_shortcode_make_iconictext($atts, $content=null){
		extract( shortcode_atts( array(
				'icon_align'		=>	'left',
				'icon_size'			=>	'',
				'icon_title'		=>	'',
				'avoid_sidebar'		=>	'false',
				'boxed_layout'		=>	'false',
				'icon_class'		=>	'',
				'icon_url'			=>	'',
				'icon_box_model'	=>	'',
				'icon_box_fill'		=>	'',
				'icon_box_ratio'	=>	'16_5',
				
				'icon_box_color_default'	=>	'',
				'icon_box_color_hover'		=>	'',
				'icon_color_default'		=>	'',
				'icon_color_hover'			=>	'',
				
				'link_url'			=>	'false',
				'link_id'			=>	'false',
				'link_is_tax'		=>	'false',
				'tax_name'			=>	'false',
				'use_shadow'		=>	'false'
		), $atts ) );
		
		if($icon_box_model == 'no-box') $icon_box_model = '';
		
		//Default values
		$a_link_color = '#eeeeee';
		$site_general_color = '#81c2f0';
		$bg_color = '#f0f0f0';
		$boxed_regular_color = '#dedeed';
		
		if(function_exists('xr_get_option')){
			$a_link_color = esc_attr(xr_get_option('a_link_color','#eeeeee'));
			$site_general_color = esc_attr(xr_get_option('site_general_color','#81c2f0'));
			$bg_color = esc_attr(xr_get_option('iconic_text_icon_box_default_color', '#f0f0f0'));
			$boxed_regular_color = '#dedeed';
		}
		
		if($icon_box_model == '' && function_exists('xr_get_option')){
			$boxed_regular_color = esc_attr(xr_get_option('boxed_layout_text_color','#101010'));
		}
		
		$final_icon_color = $boxed_regular_color;
		if($boxed_layout === 'true' ){
			$final_icon_color = esc_attr(xr_get_option('default_text_color','#101010'));
		}
		
		
		$icon_html = '';
		$icon_used = false;
		
		if($icon_class != '' && $icon_align !== 'top' && $icon_box_model !== 'full-width-box'){
			$icon_class .= ' animate-icon animate-to-right ';	
		}

		if($icon_class != ''){
			$icon_html = '<i class="'.esc_attr($icon_class).' '.esc_attr($icon_size).'"></i>';
			$icon_used = true;
		}elseif($icon_url != ''){
			$icon_html = '<img src="'.esc_url($icon_url).'" />';	
			$icon_used = true;
		}
						
		$link_active = false;
		$link_html = '';
		$link_icon_html = '';
		
		if($link_url !== 'false'){
			$link_html = '<a href="'.esc_url($link_url).'" class="iconic-text-link-wrap">';
			$link_icon_html = '<a href="'.esc_url($link_url).'" class="escapea">';
			$link_active = true;
		}elseif($link_id !== 'false' && $link_id !== 'undefined'){
			if($link_is_tax !== 'false'){
				$tax = get_category_by_slug($link_id);
				if(!$tax){
					$tax = get_term_link($link_id,$tax_name);	
				}else{
					$tax = get_category_link($tax);
				}
				$link_html = '<a href="'.esc_url($tax).'">';
				$link_icon_html = '<a href="'.esc_url($tax).'" class="escapea">';
			}else{
				$link_html = '<a href="'.esc_url(get_permalink($link_id)).'">';
				$link_icon_html = '<a href="'.esc_url(get_permalink($link_id)).'" class="escapea">';
			}
			$link_active = true;
		}
		
		
		$return = '';
		
		if($boxed_layout == "true") $return .= '<div class="boxed-layout boxed-colors '.($icon_align === 'top' ? 'padding-2x' : 'padding-2x').'" style="'.($icon_align === 'top' ? 'border-bottom:3px solid '.esc_attr($icon_box_color_default).'; ' : '').'">';
		
		$return .= '<div class="rock-iconictext-container row '.esc_attr($icon_box_model).' '.($icon_used ? 'rock-icon-'.esc_attr($icon_align) : '').'">';
		
		$azoom_box_radius = '';
		
		$icon_box_size = '';
		if($icon_box_model !== ''){
			switch($icon_size){
				case 'icon-2':
				$icon_box_size = ' width:68px; height:68px;';
				if(strpos($icon_box_fill,'border') > -1){
					$icon_box_size .= ' line-height:24px; ';
				}else{
					$icon_box_size .= ' line-height:28px; ';
				}
				$azoom_box_radius = ' border-radius:15px 0px 30px ';
				$icon_margin_left = '80px';
				$icon_margin_right = '80px';
				break;
				
				case 'icon-3':
				$icon_box_size = ' width:110px; height:110px;';
				if(strpos($icon_box_fill,'border') > -1){
					$icon_box_size .= ' line-height:110px; ';
				}else{
					$icon_box_size .= ' line-height:114px; ';
				}
				$icon_margin_left = '125px';
				$icon_margin_right = '125px';
				break;
				
				case 'icon-4':
				$icon_box_size = ' width:106px; height:106px;';
				if(strpos($icon_box_fill,'border') > -1){
					$icon_box_size .= ' line-height:116px; ';
				}else{
					$icon_box_size .= ' line-height:102px; ';
				}
				$icon_margin_left = '130px';
				$icon_margin_right = '130px';
				break;
				
				default:
				$icon_box_size = ' width:48px; height:48px;';
				if(strpos($icon_box_fill,'border') > -1){
					$icon_box_size .= ' line-height:16px; ';
				}else{
					$icon_box_size .= ' line-height:20px; ';
				}
				$icon_margin_left = '68px';
				$icon_margin_right = '68px';
				break;
			}
		}
		
		if($icon_box_model !== 'azoom-box'){
			$azoom_box_radius = '';
		}
				
		$data_attr = ' data-box-fill="'.esc_attr($icon_box_fill).'" data-icon-color="'.esc_attr($icon_color_default).'" data-icon-hover-color="'.esc_attr($icon_color_hover).'"';
		
		$class_style = ($icon_box_model === '' ? '" style="background:none; padding:0px; color:'.esc_attr($icon_color_default).';" data-bg-disabled="true"' : '  rockicon-'.esc_attr($icon_box_model).'" style="background:'.esc_attr($icon_box_color_default).'; color:'.esc_attr($icon_color_default).'; '.$icon_box_size.$azoom_box_radius.'"');
		
		$class_details = '';
		$style_details = '';
		if($icon_box_model !== ''){
			if(isset($icon_box_fill) && $icon_box_fill === 'border_only'){
				$class_details = 'rockicon-'.esc_attr($icon_box_model).' rockicon-border-only';
				$style_details = 'border-color:'.esc_attr($icon_box_color_default).'; color:'.esc_attr($icon_color_default).'; '.$icon_box_size.$azoom_box_radius.'';
				/*
				**	Border also uses the same color as the background color. So there will not be a change for the data values.
				*/
				$data_attr .= ' data-bg-color="'.esc_attr($icon_box_color_default).'" data-bg-hover-color="'.esc_attr($icon_box_color_hover).'"';
			}else{
				$class_details = 'rockicon-'.esc_attr($icon_box_model);
				$style_details = 'background:'.esc_attr($icon_box_color_default).'; color:'.esc_attr($icon_color_default).'; '.$icon_box_size.$azoom_box_radius.'"';
				$data_attr .= ' data-bg-color="'.esc_attr($icon_box_color_default).'" data-bg-hover-color="'.esc_attr($icon_box_color_hover).'"';
			}
		}else{
			$class_details = '';
			$style_details = 'background:none; padding:0px; color:'.esc_attr($icon_color_default).';';	
			$data_attr .= ' data-bg-disabled="true"';
		}
		
		
		if($icon_used){ 
			if($link_active) $return .= $link_icon_html;
			
			if($icon_align == 'left'){
				$return .= '<div class="large-12 columns">';
				$return .= '<div class="rockicon-container-column left">';
				$return .= '<div class="rockicon-container '.esc_attr($class_details).'" style="'.esc_attr($style_details).'" '.$data_attr.'>';	
				
				if($icon_box_model === 'azoom-box')	$return .= '<div class="azoom-style-dot"></div>';
				
				$return .= $icon_html;
				$return .= '</div>';
				
			}elseif($icon_align == 'right'){
				$return .= '<div class="large-12 columns">';
				$return .= '<div class="rockicon-container-column right">';
				$return .= '<div class="rockicon-container '.esc_attr($class_details).'" style="'.esc_attr($style_details).'" '.$data_attr.'>';	
				
				if($icon_box_model === 'azoom-box')	$return .= '<div class="azoom-style-dot"></div>';
				
				$return .= $icon_html;
				$return .= '</div>';
				
			}elseif($icon_align == 'top'){
				$return .= '<div class="large-12 columns rockicon-container-column padding">';
				
				
				if($icon_box_model === 'full-width-box'){
					$return .= '<div class="azoom-ratio-container ratio-'.esc_attr($icon_box_ratio).' '.($use_shadow !== 'false' ? 'azoom-small-box-shadow' : '').'">';
					$return .= '
					<div class="rockicon-container azoom-ratio-content rockicon-double-top azoom-transition-fast" style="background:'.esc_attr($icon_box_color_hover).';">
						<div class="azoom-w-h-middle" style="color:'.esc_attr($icon_color_hover).';">
							'.$icon_html.'
						</div>
					</div>';
					$return .= '
					<div class="rockicon-container azoom-ratio-content rockicon-double-bottom azoom-transition-fast" style="background:'.esc_attr($icon_box_color_default).';">
						<div class="azoom-w-h-middle" style="color:'.esc_attr($icon_color_default).';">
							'.$icon_html.'
						</div>
					</div>';

					$return .= '</div>';
				}else{
						
					$return .= '<div class="rockicon-container '.esc_attr($class_details).'" style="'.esc_attr($style_details).'" '.$data_attr.'>';
										
					$return .= $icon_html;
					$return .= '</div>';
					
				}
								
			}
			$return .= '</div>';//Close icon container class
			
			if($link_active) $return .= '</a>';
		}
		
		$icon_font_size = ' font-size:inherit;';
		
		if($icon_box_model === ""){
			$icon_margin_left = '15px';
			$icon_margin_right = '15px';

			switch($icon_size){
				case 'icon-2':
				$icon_margin_left = '60px';
				$icon_margin_right = '60px';
				break;
				
				case 'icon-3':
				$icon_margin_left = '70px';
				$icon_margin_right = '70px';
				$icon_font_size = ' font-size:20px;';
				break;
				
				case 'icon-4':
				$icon_margin_left = '105px';
				$icon_margin_right = '105px';
				$icon_font_size = ' font-size:20px;';
				break;
				
				default:
				$icon_margin_left = '30px';
				$icon_margin_right = '30px';
				break;
					
			}
		}
				
		if($icon_title != ''){
			if($link_active) $return .= $link_html;
			
			if($icon_used && ($icon_align == 'left' || $icon_align == 'right')){
				
				
				if($icon_align == 'left'){
					//a new div width margin
					$return .= '<div style="margin-left:'.esc_attr($icon_margin_left).';"><div class="rock-iconictext-header-title"><strong style="'.esc_attr($icon_font_size).'">'.esc_html($icon_title).'</strong></div><br/>';
				}elseif($icon_align == 'right'){
					//a new div width margin
					$return .= '<div style="margin-right:'.esc_attr($icon_margin_right).';"><div class="rock-iconictext-header-title"><strong style="'.esc_attr($icon_font_size).'">'.esc_html($icon_title).'</strong></div><br/>';
				}
			}else{
				$return .= '<div class="large-12 columns"><div class="rock-iconictext-header-title"><h3>'.esc_html($icon_title).'</h3></div></div>';
			}
			
			if($link_active) $return .= '</a>';
		}else{
			if($icon_align == 'left'){
				//a new div width margin
				$return .= '<div style="margin-left:'.esc_attr($icon_margin_left).';">';
			}elseif($icon_align == 'right'){
				//a new div width margin
				$return .= '<div style="margin-right:'.esc_attr($icon_margin_right).';">';
			}
		}
		
		
		if($content != null){
			if($icon_used && $icon_align == 'left'){
				$return .= '<div class="rock-iconictext-content">'.rock_check_p($content).'</div></div>';//a closing div for new div
			}elseif($icon_used && $icon_align == 'right'){
				$return .= '<div class="rock-iconictext-content">'.rock_check_p($content).'</div></div>';//a closing div for new div
			}else{
				$return .= '<div class="large-12 columns"><div class="rock-iconictext-content">'.rock_check_p($content).'</div></div>';
			}

		}else{
			if($icon_used && ($icon_align === 'left' || $icon_align === 'right')){
				$return .= '</div>';//close the div
			}
		}
		
		if($icon_used && ($icon_align == 'left' || $icon_align == 'right')){
			$return .= '</div>';//Close the large-12 columns div for the left align	
		}
		
		$return .= '</div>';//End of rock-iconictext-container
		
		$return .= '<div class="clear"></div>';//Clear any unwanted floats
		
		if($boxed_layout == "true") $return .= '</div>';
				
		return $return;
	}
}
add_shortcode('rockthemes_iconictext','rockthemes_shortcode_make_iconictext');

/*
**	End of Iconic Text Shortcode
*/



/*
**	Button Shortcode
*/
if(!function_exists('rockthemes_shortcode_make_button')){
	function rockthemes_shortcode_make_button($atts, $content=null){

		extract( shortcode_atts( array(
			'icon_align'			=>	'left', 
			'icon_size'				=>	'', 
			
			'icon_title'			=>	'', 
			'extra_class'			=>	'',
			'button_align'			=>	'none',
			'button_size'			=>	'', 
			'button_color'			=>	'', 
			'button_shadow'			=>	'no', 
			'button_shape'			=>	'', 
			
			'bg_color_default'		=>	'',
			'bg_color_hover'		=>	'',
			'text_color_default'	=>	'',
			'text_color_hover'		=>	'',
			'border_color'			=>	'',
			'border_color_hover'	=>	'',
			'button_bg_border'		=>	'',

			'button_link_target'	=>	'',
			'link_url'				=>	'', 
			'link_id'				=>	'', 
			'link_is_tax'			=>	'', 
			'tax_name'				=>	'', 
			'icon_class'			=>	'', 
			'icon_url'				=>	'',
			
			//For SEO
			'attr_title'			=>	'',
			
			//A unique attribute for removing wrapper
			'no_wrapper'			=>	'',
		), $atts ) );
		

		$link_active = false;
		$link_html = '';
		$link_icon_html = '';
		
		if($link_url !== 'false'){
			$link_html = $link_url;
			$link_active = true;
		}elseif($link_id !== 'false' && $link_id !== 'undefined'){
			if($link_is_tax !== 'false'){
				$tax = get_category_by_slug($link_id);
				if(!$tax){
					$tax = get_term_link($link_id,$tax_name);	
				}else{
					$tax = get_category_link($tax);
				}
				$link_html = $tax;
			}else{
				$link_html = get_permalink($link_id);
			}
			$link_active = true;
		}

		
		$icon_html = '';
		$icon_used = false;
		
		if($icon_class != ''){
			$icon_html = ' <i class="'.esc_attr($icon_class).' '.esc_attr($icon_size).' animate-icon animate-to-'.esc_attr($icon_align).'"></i> ';
			$icon_used = true;
		}elseif($icon_url != ''){
			$icon_html = ' <img src="'.esc_attr($icon_url).'" /> ';	
			$icon_used = true;
		}
		
		$return = '';
		
		$button_align_html = '';
				
		if($button_align !== 'block'){
			$button_align_html  = 'text-align:'.esc_attr($button_align).';';	
		}elseif($button_align === 'block'){
			$button_align_html  = 'display:'.esc_attr($button_align).';';	
		}


		$button_large_style = '';
				
		$custom_color_data = '';
		$custom_color_style = '';
		if($button_color === 'custom'){
			$custom_color_data = 'data-bg_color_default="'.esc_attr($bg_color_default).'" 
								  data-bg_color_hover="'.esc_attr($bg_color_hover).'" 
								  data-text_color_default="'.esc_attr($text_color_default).'" 
								  data-text_color_hover="'.esc_attr($text_color_hover).'" 
								  data-border_color="'.esc_attr($border_color).'" 
								  data-border_color_hover="'.esc_attr($border_color_hover).'" 
								  data-button-js-colors="true" ';	
								  
			$custom_color_style = ' background:'.esc_attr($bg_color_default).'; color:'.esc_attr($text_color_default).'; ';
		}
		
		$disable_bg_data = '';
		if(strpos($button_bg_border, 'use_border') > -1){
			if($button_bg_border === 'use_border'){
				$disable_bg_data = ' data-bg-disabled="true" ';	
				
				if($button_color === 'custom'){
					$custom_color_style .= 'background:none; ';	
				}
			}
						
			if($button_color === 'custom'){
				$custom_color_style .= 'color:'.esc_attr($text_color_default).'; border-color:'.esc_attr($border_color).';';
				
				if($button_bg_border === 'use_bg_color_use_border'){
					$custom_color_style .= 'box-shadow:0 6px 0 '.esc_attr($border_color).';-webkit-box-shadow:0 6px 0 '.esc_attr($border_color).';-moz-box-shadow:0 6px 0 '.esc_attr($border_color).';';
				}
			}
		}
				
		$modal_data = '';
		if($button_link_target === 'modal' && $link_html !== '' && $link_html !== '#'){
			$modal_data = 'data-rel="prettyPhoto" ';
			$link_html .= esc_html('?iframe=true&width=80%&height=80%');
		}
		
		if($link_html === ''){
			$link_html = '#';	
		}
		
		$ext_attr = '';
		if(isset($attr_title) && $attr_title !== ''){
			$ext_attr .= ' title="'.esc_attr($attr_title).'" ';	
		}
		
		$return .= (isset($no_wrapper) && $no_wrapper === 'true' ? '' : '<div class="azoom-button-wrapper" style="'.esc_attr($button_align_html).'" >').' ';
		$return .= '<a href="'.esc_url($link_html).'" ';
		$return .= ($button_link_target == "_blank" ? 'target="_blank"' : '').' ';
		$return .= 'style="'.$button_large_style.$custom_color_style.'" ';
		$return .= 'class="escapea button azoom-transition';
		$return .= (isset($button_link_target) && $button_link_target === 'inline' ? ' rockthemes-inline-link' : '');
		$return .= (isset($extra_class) && $extra_class !== '' ? ' '.esc_attr($extra_class) : '');
		$return .= (isset($button_align) && $button_align === 'block' ? ' button-block' : '');
		$return .= ($button_shape != '' ? ' '.esc_attr($button_shape) : '');
		$return .= ($button_size !== '' ? ' '.$button_size : '');
		$return .= ($button_color !== 'custom' ? ' button-'.esc_attr($button_color) : '');
		$return .= ($button_shadow === 'yes' ? ' azoom-small-box-shadow' : '');
		$return .= ($button_bg_border ===  'use_border' ? ' button-border' : '');
		$return .= ($button_bg_border ===  'use_bg_color_use_border' ? ' button-border-bottom' : '');
		$return .= ($button_link_target ===  'modal' ? ' button-modal' : '');
		$return .= '"';
		$return .= ' '.$custom_color_data;
		$return .= ' '.$disable_bg_data;
		$return .= ' '.$modal_data;
		$return .= ' '.$ext_attr;
		$return .= '>';
		$return .= ($icon_align == "left" ? $icon_html : '');
		$return .= $content;
		$return .= ($icon_align == "right" ? $icon_html : '');
		$return .= (isset($extra_class) && strpos($extra_class, 'load-more') > -1 && function_exists('rockthemes_loader_motion') ? rockthemes_loader_motion('load-more-button-loader') : '');
		$return .= '</a>';
		$return .= (isset($no_wrapper) && $no_wrapper === 'true' ? '' : '</div>');
				
		return $return;
	}
}
add_shortcode('rockthemes_button','rockthemes_shortcode_make_button');


/*
**	End of Button Shortcode
*/


/*
**	Skill Shortcode
*/
if(!function_exists('rockthemes_shortcode_make_skill')){
	function rockthemes_shortcode_make_skill($atts,$content=null){
		extract( shortcode_atts( array(
			'skill_title'=>'',
			'skill_color'=>'',
			'skill_bg_color'=>'',
			'skill_current_value'=>'',
		), $atts ) );
				
		
		
		$return = '
		<div class="azoom-skill" data-skill-value="'.esc_attr(str_replace('%','',$skill_current_value)).'">
			<div class="azoom-skill-bg" style="background:'.esc_attr($skill_bg_color).';"></div>
			<div class="azoom-skill-value-bg" style="background:'.esc_attr($skill_color).'; width:'.esc_attr(str_replace('%','',$skill_current_value)).'%;">
				<div class="azoom-skill-value">'.esc_attr($skill_current_value).'</div>
			</div>
			<div class="azoom-skill-title">'.esc_attr($skill_title).'</div>
		</div>';
		
		
		return $return;
	}
}
add_shortcode('rockthemes_skill','rockthemes_shortcode_make_skill');




/*
**	Horizontal Rule Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_hr')){
	function rockthemes_shortcode_make_hr($atts){
		extract( shortcode_atts( array(
			'hr_is_image'=>'',
			'image_url'=>'',
			'tile_image'=>'',
			'hr_html_model'=>'',
			'hr_height'=>'10px',
		), $atts ) );
		
		$return = '';
		
		if($hr_is_image == 'use_html'){
			$return = '<hr style="margin:30px 0px; width:100%; height:0px; border-bottom:none; " />';
		}
		
		if($hr_is_image == 'use_image'){
			$image_css_atts = ' no-repeat';
			if($tile_image == 'yes'){
				$image_css_atts = ' repeat';	
			}
			$return = '
				<div style="background:url(\''.esc_url($image_url).'\') '.$image_css_atts.'; width:100%; margin:15px 0; height:'.esc_attr($hr_height).';">
				</div>
				';
		}
		
		return $return;
	}
}

add_shortcode('rockthemes_hr','rockthemes_shortcode_make_hr');

/*
**	End of Horizontal Rule Shortcode
*/



/*
**	Vertical Space Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_vertical_space')){
	function rockthemes_shortcode_make_vertical_space($atts){
		extract( shortcode_atts( array(
			'vertical_space_height'	=>	'default',
			'custom_value'			=>	'60px',
		), $atts ) );
		
		$return = '';
		
		switch($vertical_space_height){
			case 'default':
			$return = '<div class="vertical-space"></div>';
			break;	
			
			case 'x_grid':
			$return = '<div class="vertical-space-x_grid"></div>';
			break;	
			
			case 'x_2':
			$return = '<div class="vertical-space-x2"></div>';
			break;
			
			case 'x_3':
			$return = '<div class="vertical-space-x3"></div>';
			break;
			
			case 'd_2':
			$return = '<div class="vertical-space-d3"></div>';
			break;
			
			case 'custom':
			if(strpos($custom_value, 'px') < 0 && strpos($custom_value, 'em') < 0){
				$custom_value = (int)$custom_value.'px';	
			}
			$return = '<div class="vertical-space" style="height:'.$custom_value.';"></div>';
			break;
			
		}
		

		
		return $return;
	}
}

add_shortcode('rockthemes_vertical_space','rockthemes_shortcode_make_vertical_space');

/*
**	End of Vertical Space Shortcode
*/








if(!function_exists('rockthemes_portfolio_ajax_category_filters')):
/*
**	Ajax Filtered Categories.
**
**	@param	:	$atts	:	Multidim Array used in shortcode
**	@return	:	Returns the category names with ajax links
**
**	@since	:	1.3
**
*/
function rockthemes_portfolio_ajax_category_filters($atts = array()){
	
	//Return if atts empty or wrong value
	if(empty($atts) || !isset($atts) || !is_array($atts)) return;
	
	extract($atts);

	//Navigation
	$return = '<div class="ajax-category-navigation" data-post_type="'.esc_attr($post_type).'" data-image_size="'.esc_attr($image_size).'">';
	
		if(function_exists('rockthemes_loader_motion')){
			$return .= '<div class="ajax-category-loading-cover">'.rockthemes_loader_motion('ajax-category-navigation-loader').'</div>';
		}

		$cat_list = explode(',', $category);
										
		$return .= '<ul>';
							
			$totalCat = sizeof($cat_list);
			$i = 0;
			$elements_list = '';
			$taxonomy_attr = ' data-taxonomy="category"';
			
			foreach($cat_list as $cat){
				
				$data = get_category_by_slug( $cat );
				$link_html = get_permalink($cat);
				
				if($data){

				}else{

					$tax_list = get_object_taxonomies($post_type);//get_object_taxonomies
					
					$post_tax = '';
					foreach($tax_list as $tax){
			
						if(strpos($tax,'cat') > -1){
							$post_tax = $tax;
							break;
						}
					}
					
					//Return if a custom product type added and removed and forgetten to remove from page.
					if(empty($tax_list)) return;
					
					
					$taxonomy_attr = ' data-taxonomy="'.esc_attr($post_tax).'"';
					$data = get_term_by('slug',$cat,$post_tax);
					if(!$data) continue;
					
						$tax = get_category_by_slug($cat);
						if(!$tax){
							$tax = get_term_link($cat,$post_tax);	
						}else{
							$tax = get_category_link($post_tax);
						}
						$link_html = $tax;
				}

				$elements_list .= '<li class="category-name" data-cat-link="'.esc_attr($link_html).'" data-slug-holder="'.esc_attr($data->slug).'" '.$taxonomy_attr.'><a href="#" class="disable-link escapea">'.esc_attr($data->name).'</a></li>';
				if($i + 1 < $totalCat){
					$elements_list .= '<li data-slug-holder="no-value" class="no-value"> / </li>';
				}
				
				$i++;
			}
			
			$return .= '<li class="category-name active" data-slug-holder="'.esc_attr($category).'" '.$taxonomy_attr.'><a href="#" class="disable-link escapea active">'.esc_html__('Latest','azoom').'</a></li>';
			$return .= '<li data-value="no-value" class="no-value"> / </li>';
			
			$return .= $elements_list;
		
		$return .= '</ul>';
		
		
		//Data element for loading category items via ajax
		$data_element = '<div class="data-cat-details hide" data-id_ref="lm_'.esc_attr($atts['elem_main_id']).'" ';
		$atts_single_dimension = rockthemes_array_flatten($atts);

		foreach($atts_single_dimension as $d_key => $d_val){
			$data_element .= 'data-'.esc_attr($d_key).'="'.esc_attr($d_val).'" ';	
		}
		
		$data_element .= 'data-last_load="0" data-load_amount="'.esc_attr($total).'"';
		$data_element .= '></div>';
		
		$return .= $data_element;

		
		
		
		$return .= '<div class="clear"></div>';
		
	$return .= '</div>';//End of Ajax Navigation
	
	return $return;
}
endif;





/*
**	Portfolio Shortcode
*/
if(!function_exists('rockthemes_shortcode_make_portfolio')){
	function rockthemes_shortcode_make_portfolio($s_atts = array(), $inline_content=null){
		global $paged, $wp_query;

		$atts = shortcode_atts( array(
				'image_size'				=>	'medium',
				'post_type'					=>	'post',
				'category'					=>	'all',
				'excerpt_title_option'		=>	'no_description',
				
				'activate_hover'			=>	'false',
				'hover_bg_change_elem'		=>	'false',
				'details_in_hover'			=>	'din_hover',
				
				'activate_category_link'	=>	'true',
				'activate_header_link'		=>	'true',
				'where_to_link'				=>	'items',
				
				'use_back_icon'				=>	'false',
				'use_link_icon'				=>	'false',
				'use_lightbox_image'		=>	'false',
				'use_lightbox_video'		=>	'false',
				'use_lightbox_gallery'		=>	'false',
				'use_like'					=>	'false',
				
				'wall_mode'					=>	'false',
				'masonry'					=>	'false',
				
				'display_price'				=>	'false',
				'display_date'				=>	'true',
				'excerpt_length'			=>	18,
				'block_grid_large'			=>	'3',
				'block_grid_medium'			=>	'3',
				'block_grid_small'			=>	'3',
				
				'total'						=>	'9',
				'boxed_layout'				=>	'false',
				'more_items'				=>	'',
				'swiper_nav_number'			=>	'4',

				'portfolio_model'			=>	'grid',
				'portfolio_model_switch'	=>	'false',
				'list_image_col_large'		=>	'5',
				
				'use_shadow'				=>	'false',
				'use_swiper_for_thumbnails'	=>	'false'
		), $s_atts ) ;	
		

		extract($atts);
		
		
		$use_wp_query_vars = false;
		if($post_type === 'no-selected'){
		
			//For archives only
			if(function_exists('rpb_is_archive') && rpb_is_archive()){
				$post_type = esc_attr($GLOBALS['rpb_archive_post_type']);
				$category = esc_attr($GLOBALS['rpb_archive_category']);
				$atts['post_type'] = $post_type;
				$atts['category'] = $category;
								
				if(isset($wp_query) && isset($wp_query->query_vars)){
					if(isset($wp_query->query_vars['order']) && isset($wp_query->query_vars['orderby'])){
						$atts['order'] = $wp_query->query_vars['order'];
						$atts['orderby'] = $wp_query->query_vars['orderby'];
					}
					
					if(isset($wp_query->query_vars['meta_key'])){
						$atts['meta_key'] = $wp_query->query_vars['meta_key'];
					}
				}
												
				if(isset($GLOBALS['rpb_has_term_id']) && $GLOBALS['rpb_has_term_id']){
					$use_wp_query_vars = true;
					$atts['use_wp_query_vars'] = 'true';
				}
			}else{
				return;	
			}
		
		}
		
		
		
		//Hover Details for the image. Will be used in azoom_hover_effect function in functions.php
		$hover_obj = array(
			'activate_hover_box'	=>	false,
			'activate_hover'		=>	($activate_hover == 'true' || $activate_hover === true) ? true : false,
			'use_link'				=>	($use_link_icon == 'true' || $use_link_icon === true) ? true : false,
			'use_back_icon'			=>	($use_back_icon == 'true' || $use_back_icon === true) ? 'true' : 'false',
			'full_link'				=>	false,
			'lightbox'				=>	array(
				'image'		=>	($use_lightbox_image == 'true' || $use_lightbox_image === true) ? true : false,
				'video'		=>	($use_lightbox_video == 'true' || $use_lightbox_video === true) ? true : false,
				'gallery'	=>	($use_lightbox_gallery == 'true' || $use_lightbox_gallery === true) ? true : false,
			),
			'like'					=>	($use_like == 'true' || $use_like === true) ? true : false,
			'use_schema'			=>	($portfolio_model === 'list' || $details_in_hover !== 'din_hover') ? false : true,
			'content'				=>	array(
				'use_title'		=>	false,
				'link_title'	=>	($activate_header_link == 'true' || $activate_header_link === true) ? true : false,
				'use_cats'		=>	false,
				'use_price'		=>	false,
				'use_excerpt'	=>	false,
				'excerpt_length'	=>	$excerpt_length,
			),
		);
		
		//Update Hover Object according to the details
		if($details_in_hover === 'din_hover'){
			$hover_obj['content']['use_title'] = (strpos($excerpt_title_option, 'title') > -1) ? true : false;
			$hover_obj['content']['use_cats'] = (strpos($excerpt_title_option, 'cats') > -1) ? true : false;
			$hover_obj['content']['use_excerpt'] = (strpos($excerpt_title_option, 'excerpt') > -1) ? true : false;
			$hover_obj['content']['use_price'] = ((isset($display_price) && ($display_price === 'true' || $display_price === true)))  ? true : false ;
		}else{
			//Disable hover price if displaying under image
			$hover_obj['content']['use_price'] = false;
		}
		
		if($portfolio_model === 'list'){
			$hover_obj['content']['use_title'] = false;
			$hover_obj['content']['use_cats'] = false;
			$hover_obj['content']['use_excerpt'] = false;
			$hover_obj['content']['use_price'] = false;
		}

		$atts['cats_in_hover'] = ($hover_obj['content']['use_cats']) ? 'true' : 'false';
		
		$atts['hover_obj'] = $hover_obj;
		

		
		//Columns Class	
		$block_class = ' large-block-grid-'.esc_attr($block_grid_large).' medium-block-grid-'.esc_attr($block_grid_medium).' small-block-grid-'.esc_attr($block_grid_small).' ';

		//Collapse block grid if space removed
		if($wall_mode === 'true' && $portfolio_model === 'grid'){
			$block_class .= 'block-collapse ';	
		}
		

		if(isset($GLOBALS['rockthemes_portfolio'])){
			$GLOBALS['rockthemes_portfolio']++;
		}else{
			$GLOBALS['rockthemes_portfolio'] = 1;	
		}
		
		if(isset($GLOBALS['lightbox_gallery'])){
			$GLOBALS['lightbox_gallery']++;
		}else{
			$GLOBALS['lightbox_gallery'] = 0;	
		}
		
		
		$id = "azoom_portfolio_".esc_attr($GLOBALS['rockthemes_portfolio']);
		$atts['elem_main_id'] = $id;
		
		//If masonry is true in shortcode activate it 	
		$masonry_class = '';
		$masonry_item_class = '';
		$masonry_attr = '';
		if($masonry === 'true' && $portfolio_model === 'grid'){
			//wp_enqueue_script( 'jquery-masonry' );
			wp_enqueue_script('jquery-masonry', AZOOM_PLUGIN_URI.'/js/masonry.min.js', array('jquery'), '3.3.0', true);
			$masonry_class ='rockthemes-masonry rockthemes-masonry-'.esc_attr($GLOBALS['rockthemes_portfolio']);
			$masonry_item_class = 'rockthemes-masonry-elem-'.esc_attr($GLOBALS['rockthemes_portfolio']);
			$masonry_attr = 'data-masonry-elem="'.$masonry_item_class.'"';
		}
		
		$atts['masonry'] = $masonry;
		$atts['masonry_class'] = $masonry_class;
		$atts['masonry_item_class'] = $masonry_item_class;

		
		
		$post_is_tax = false;

		$tax_list = get_object_taxonomies($post_type);//get_object_taxonomies
		$post_tax = '';
		foreach($tax_list as $tax){
			if(strpos($tax,'cat') > -1){
				$post_tax = $tax;
				break;
			}
		}
		

		$atts['post_tax'] = $post_tax;
		
		if(get_query_var('paged')){
			//Works for the pages called from index.php
			$paged = get_query_var('paged');	
		}elseif(get_query_var('page')){
			//Works for the shortcodes
			$paged = get_query_var('page');	
		}else{
			$paged = 1;	
		}
		
		
		$posts = array();
		if($post_type === 'post'){
			$post_query_args = array('category_name'=> esc_attr($category), 'posts_per_page'=>esc_attr($total), 'paged'=>esc_attr($paged));
			
			if($use_wp_query_vars){
				unset($post_query_args['category_name']);
				//Query posts function is not working normally. So we need to alter the taxonomy names only for posts
				$post_query_args = array_merge($wp_query->query_vars, $post_query_args);
			}
			
			if(isset($atts['order']) && isset($atts['orderby'])){
				$args['order'] = $atts['order'];
				$args['orderby'] = $atts['orderby'];	
			}
			if(isset($atts['meta_key'])){
				$args['meta_key'] = $atts['meta_key'];	
			}

			$posts = query_posts($post_query_args);
		}
		
		if(!count($posts) && $post_type !== 'post'){
			if(isset($GLOBALS['rpb_archive_taxonomy']) && $GLOBALS['rpb_archive_taxonomy']){
				$post_tax = $GLOBALS['rpb_archive_taxonomy'];	
				$atts['post_tax'] = $post_tax;
			}
			
			$args = array(
				'post_type'			=>	esc_attr($post_type),
				$post_tax			=>	esc_attr($category),
				'posts_per_page'	=>	esc_attr($total),
				'paged'				=>	esc_attr($paged)
			);
			
			if(isset($atts['order']) && isset($atts['orderby'])){
				$args['order'] = $atts['order'];
				$args['orderby'] = $atts['orderby'];	
			}
			if(isset($atts['meta_key'])){
				$args['meta_key'] = $atts['meta_key'];	
			}
			
			if($use_wp_query_vars){
				//Query posts function is not working normally. So we need to alter the taxonomy names only for posts
				$args = array_merge($wp_query->query_vars, $args);
			}			

			$posts = query_posts($args);
			$post_is_tax = true;
			
		}
		
		
		$return = '';
				
		$return .= '<div id="'.$id.'" class="azoom-portfolio-container '.esc_attr($portfolio_model).' '.esc_attr($details_in_hover).' '.($use_shadow === 'true' ? 'use-shadow' : '').' '.($boxed_layout === 'true' ? 'boxed_layout_holder' : '').' '.($masonry === 'true' ? 'masonry-active' : '').' '.($wall_mode === 'true' ? 'wall-mode-active' : '').'">';
			
						
			if(strpos($more_items, 'ajax_cats') > -1 && !$use_wp_query_vars){
				$return .= rockthemes_portfolio_ajax_category_filters($atts);
				if(!($wall_mode === 'true' && $portfolio_model === 'grid')){
					$return .= '<div class="vertical-space"></div>';
				}

			}
						
			//Body
			$return .= '<'.((($portfolio_model === 'list') || (strpos($more_items, 'more_items_swipe') > -1)) ? 'div' : 'ul').' '.((strpos($more_items, 'load_more') > -1 || strpos($more_items, 'ajax_cats') > -1) ? 'id="lm_'.esc_attr($id).'"' : '').' class="azoom-portfolio-body azoom-transition '.((strpos($more_items, 'more_items_swipe') > -1) ? 'swiper-navigation-active' : '').' '.($portfolio_model === 'grid' && (!(strpos($more_items, 'more_items_swipe') > -1)) ? $block_class.' '.$masonry_class : '').'" '.$masonry_attr.' data-class-ref="'.$block_class.'">';
						
			if(sizeof($posts)>0){
				
				if(strpos($more_items, 'more_items_swipe') > -1){
					wp_enqueue_style('swiper-css', AZOOM_PLUGIN_URI.'/css/idangerous.swiper-2.css', '', '', 'all' );
					wp_enqueue_script('swiper-js', AZOOM_PLUGIN_URI.'/js/idangerous.swiper-2.7.js', array('jquery'), '2.7.0', true);
					$return .= '<div class="swiper-container"><div class="swiper-wrapper">';
				}

				$count_columns = 1;
				$swiper_count = 0;
				$swiper_slide_count = 0;
								
				foreach($posts as $post_object){
					global $post, $rockthemes_advanced_details;
					$post = $post_object;
					setup_postdata($post);
								
					$atts['post_id'] = $post->ID;
					if(strpos($more_items, 'more_items_swipe') > -1){
						$atts['masonry_item_class'] = $masonry_item_class.'_'.$swiper_slide_count;
					}else{
						$atts['masonry_item_class'] = $masonry_item_class;
					}
					
					if(strpos($more_items, 'more_items_swipe') > -1){
						if($swiper_count === 0){
							$return .= '<div class="swiper-slide">';
							if((strpos($more_items, 'more_items_swipe') > -1)){
								$return .= '<'.(($portfolio_model === 'list') ? 'div' : 'ul').' '.((strpos($more_items, 'load_more') > -1 || strpos($more_items, 'ajax_cats') > -1) ? 'id="lm_'.esc_attr($id).'"' : '').' class="azoom-portfolio-body azoom-transition '.$masonry_class.' '.($portfolio_model === 'grid' ? $block_class : '').'" data-masonry-elem="'.$masonry_item_class.'_'.$swiper_slide_count.'" data-class-ref="'.$block_class.'">';
							}
						}elseif((($swiper_count % ((int) $swiper_nav_number)) == 0) && ($swiper_count) < count($posts)){
							if((strpos($more_items, 'more_items_swipe') > -1)){
								$return .= '</'.(($portfolio_model === 'list')? 'div' : 'ul').'>';//End of Body
							}
							
							$swiper_slide_count++;
							$atts['masonry_item_class'] = $masonry_item_class.'_'.$swiper_slide_count;
							$return .= '</div><div class="swiper-slide">';
							if((strpos($more_items, 'more_items_swipe') > -1)){
								$return .= '<'.(($portfolio_model === 'list') ? 'div' : 'ul').' '.((strpos($more_items, 'load_more') > -1 || strpos($more_items, 'ajax_cats') > -1) ? 'id="lm_'.esc_attr($id).'"' : '').' class="azoom-portfolio-body azoom-transition '.$masonry_class.' '.($portfolio_model === 'grid' ? $block_class : '').'" data-masonry-elem="'.$masonry_item_class.'_'.$swiper_slide_count.'" data-class-ref="'.$block_class.'">';
							}
						}
					}
					

					
					$return .= azoom_portfolio_grid_make_single($atts);
					
					$swiper_count++;
					
					
				}
				
				if(strpos($more_items, 'more_items_swipe') > -1){
					
					
					if((strpos($more_items, 'more_items_swipe') > -1)){
						$return .= '</'.(($portfolio_model === 'list') ? 'div' : 'ul').'>';//End of Body
					}
					
					$return .= '</div></div>';//swiper-slide / swiper-wrapper
					$return .= '</div><!--End Swiper-->';//swiper-container
					
					if(1 == 1){
						//Swiper navigation
						$return .= '
						<div class="swiper-pagination-holder">
							<div class="swiper-arrow-left azoom-transition"><i class="icomoon icomoon-icon-arrow-left4"></i></div>
							<div class="swiper-pagination"></div>
							<div class="swiper-arrow-right azoom-transition"><i class="icomoon icomoon-icon-arrow-right4"></i></div>
						</div>';	
					}

				}
						
			}else{
				$return .= '<div class="large-12 columns">'.__("No data found!","azoom").'</div>';
			}
		
		$return .= '</'.((($portfolio_model === 'list') || (strpos($more_items, 'more_items_swipe') > -1)) ? 'div' : 'ul').'>';//End of Body
		
		$return .= '<div class="clear"></div>';
		
		$total_pages = $wp_query->max_num_pages;
		
		if($more_items === 'pagination' && $total_pages > 1){
			//Footer navigation
			$return .= azoom_paging_nav();
		}
		
		$load_more_button_shortcode = '<a class="button button-large disable-link button-border load-more button-shadow azoom-small-box-shadow" href="#" data-id_ref="lm_'.esc_attr($id).'">'.esc_html__('Load More','azoom').'</a>';
		//Load More button shortcode		
		if(strpos($inline_content,'rockthemes_shortcode_lmb') > -1){

			preg_match_all('/rockthemes_shortcode_lmb(.*?)rockthemes_shortcode_end_lmb/',$inline_content, $load_more_button_shortcode_reg);
			if(!empty($load_more_button_shortcode_reg)){
				$load_more_button_shortcode = str_replace(array("&rss;","&rse;"),array("",""),$load_more_button_shortcode_reg[1][0]);
				if(strpos($load_more_button_shortcode, 'extra_class') > -1){
					$load_more_button_shortcode = str_replace('extra_class="', 'no_wrapper="true" extra_class="load-more disable-link ', $load_more_button_shortcode);
				}else{
					$load_more_button_shortcode = str_replace('[rockthemes_button ', '[rockthemes_button no_wrapper="true" extra_class="load-more disable-link" ', $load_more_button_shortcode);
				}
				$load_more_button_shortcode = str_replace('<a ', '<a data-id_ref="lm_'.esc_attr($id).'" ', do_shortcode($load_more_button_shortcode));
				$inline_content = substr($inline_content,strpos($inline_content,'&rss_lmb;'),strpos($inline_content,'&rse_lmb;'));
			}
		}


		if(strpos($more_items, 'load_more') > -1 && $total_pages > 1){

			$archive_load_more = false;
			if(isset($GLOBALS['rpb_archive_taxonomy']) && $GLOBALS['rpb_archive_taxonomy']){
				
				if($total_pages > 1){

					$current_page = max(1, get_query_var('paged'));  
					$load_more_links = '';
					for($l = 1; $l < $total_pages; $l++){
						$load_more_links .= '<a href="'.esc_url(get_pagenum_link($current_page + $l)).'" class="load-more-link"></a>';
					}	
					
					$archive_load_more = true;
				
				}
			}
			
			$return .= '<div class="load-more-wrapper">'.$load_more_button_shortcode;
			$data_element = '<div class="data-details hide" ';
			
			$atts_single_dimension = rockthemes_array_flatten($atts);

			foreach($atts_single_dimension as $d_key => $d_val){
				$data_element .= 'data-'.$d_key.'="'.$d_val.'" ';	
			}
			
			if($archive_load_more){
				$data_element .=  'data-archive_load_more="true" ';
			}
			
			$data_element .= 'data-last_load="0" data-load_amount="'.esc_attr($total).'"';
			$data_element .= '></div>';
			
			if($archive_load_more){
				$data_element .= '<div class="archive_load_more">'.$load_more_links.'</div>';	
			}
			
			$return .= $data_element.'</div>';//.load-more-wrapper
		}
		
			
								
		$return .= '</div>';//End of HTML field
		
		wp_reset_query();
		wp_reset_postdata();
		
				
		return $return;
	}
}
add_shortcode('rockthemes_portfolio','rockthemes_shortcode_make_portfolio');
/*
**	End of Portfolio Shortcode
*/



if(!function_exists('azoom_portfolio_grid_make_single_ajax')):
function azoom_portfolio_grid_make_single_ajax(){
	if(empty($_REQUEST['data']) || !$_REQUEST['data']){die('ERROR');}
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rockthemes_portfolio_nonce') ||
		!check_ajax_referer('rockthemes_portfolio_nonce')) {
		
		//Die
		die('ERROR');	
	}
	
	$atts = $_REQUEST['data'];
	 
	$return = '';
	extract($atts);
	
	
	if(isset($hover_obj) && is_array($hover_obj)){
		extract($hover_obj);
		extract($lightbox);
		extract($content);
	}
	

	$use_wp_query_vars = false;
	if(isset($atts['use_wp_query_vars']) && $atts['use_wp_query_vars']){
		$use_wp_query_vars = true;
	}


	//Remake hover object. Javascript data might break it
	$hover_obj = array(
		'activate_hover_box'	=>	(isset($activate_hover_box) && ($activate_hover_box === 'true' || $activate_hover_box)) ? 'true' : 'false',
		'activate_hover'		=>	(isset($activate_hover) && ($activate_hover === 'true' || $activate_hover)) ? 'true' : 'false',
		'use_link'				=>	(isset($use_link) && ($use_link === 'true' || $use_link)) ? 'true' : 'false',
		'full_link'				=>	(isset($full_link) && ($full_link === 'true' || $full_link === true)) ? 'true' : 'false',
		'use_back_icon'			=>	(isset($use_back_icon) && ($use_back_icon === 'true' || $use_back_icon === true)) ? 'true' : 'false',
		'lightbox'				=>	array(
			'image'		=>	(isset($image) && ($image === 'true' || $image)) ? 'true' : 'false',
			'video'		=>	(isset($video) && ($video === 'true' || $video)) ? 'true' : 'false',
			'gallery'	=>	(isset($gallery) && ($gallery === 'true' || $gallery)) ? 'true' : 'false',
		),
		'like'					=>	(isset($like) && ($like === 'true' || $like)) ? 'true' : 'false',
		'use_schema'			=>	(isset($use_schema) && ($use_schema === 'true' || $use_schema)) ? 'true' : 'false',
		'content'				=>	array(
			'use_title'		=>	(isset($use_title) && ($use_title === 'true' || $use_title)) ? 'true' : 'false',
			'link_title'	=>	(isset($link_title) && ($link_title === 'true' || $link_title)) ? 'true' : 'false',
			'use_cats'		=>	(isset($use_cats) && ($use_cats === 'true' || $use_cats)) ? 'true' : 'false',
			'use_price'		=>	(isset($use_price) && ($use_price === 'true' || $use_price)) ? 'true' : 'false',
			'use_excerpt'	=>	(isset($use_excerpt) && ($use_excerpt === 'true' || $use_excerpt)) ? 'true' : 'false',
			'excerpt_length'	=>	$excerpt_length,
		),
	);
	
	
	$atts['hover_obj'] = $hover_obj;
	
	if(isset($GLOBALS['lightbox_gallery'])){
		$GLOBALS['lightbox_gallery']++;
	}else{
		$GLOBALS['lightbox_gallery'] = 0;	
	}
	
	
		
	$post_is_tax = false;

	$tax_list = get_object_taxonomies($post_type);//get_object_taxonomies
	$post_tax;
	foreach($tax_list as $tax){
		if(strpos($tax,'cat') > -1){
			$post_tax = $tax;
			break;
		}
	}

	if(get_query_var('paged')){
		//Works for the pages called from index.php
		$paged = get_query_var('paged');	
	}elseif(get_query_var('page')){
		//Works for the shortcodes
		$paged = get_query_var('page');	
	}else{
		$paged = 1;	
	}

		
	$posts = array();

	if($post_type === 'post'){
		$post_query_args = array('category_name'=> esc_attr($category), 'posts_per_page'=>esc_attr($total), 'offset'=>esc_attr($last_load), 'paged'=>esc_attr($paged), 'post_status' => 'publish');
		if($use_wp_query_vars){
			unset($post_query_args['category_name']);
			$post_query_args = array_merge($wp_query_vars, $post_query_args);
		}

		$posts = query_posts($post_query_args);
		$args = $post_query_args;
		
		if(isset($order) && isset($orderby)){
			$args['order'] = $order;
			$args['orderby'] = $orderby;
		}
		
		if(isset($meta_key)){
			$args['meta_key'] = $meta_key;	
		}
		
		$atts['args'] = $args;
	}

	if(!count($posts) && $post_type !== 'post'){
		$args = array(
			'post_type'			=>	esc_attr($post_type),
			$post_tax			=>	esc_attr($category),
			'posts_per_page'	=>	esc_attr($total),
			'offset'			=>	esc_attr($last_load),
			'paged'				=>	esc_attr($paged),
			'post_status'		=>	'publish'
		);
		
		if(isset($order) && isset($orderby)){
			$args['order'] = $order;
			$args['orderby'] = $orderby;
		}
		
		if(isset($meta_key)){
			$args['meta_key'] = $meta_key;	
		}
		
		if($use_wp_query_vars){
			unset($args['post_type']);
			unset($args[$post_tax]);
			$args = array_merge($wp_query_vars, $args);
		}
		$posts = query_posts($args);
		$post_is_tax = true;
		
		$atts['args'] = $args;
	}
	
	$GLOBALS['rockthemes_portfolio'] = explode('_', $elem_main_id);
	$GLOBALS['rockthemes_portfolio'] = $GLOBALS['rockthemes_portfolio'][count($GLOBALS['rockthemes_portfolio']) - 1];

	$current_total = sizeof($posts);

	if(sizeof($posts)>0){				
		foreach($posts as $post_object){
			global $post;
			setup_postdata($post_object);
			$post = $post_object;
			$return .= azoom_portfolio_grid_make_single($atts);
		}
						
	}
	
	wp_reset_query();
		
	if(!empty($return)){
		
		$args['posts_per_page'] = -1;
		$num = query_posts($args);
		$disable = count($num) <= ($current_total + (int) $last_load) ? 'yes' : 'no';
				
		echo wp_send_json(array('body'=>$return, 'disable'=>$disable));
	}else{
		echo wp_send_json(array('body'=>'ERROR', 'disable'=>'yes'));	
	}
	exit;
}
endif;
add_action('wp_ajax_nopriv_rockthemes_portfolio_load_more', 'azoom_portfolio_grid_make_single_ajax');
add_action('wp_ajax_rockthemes_portfolio_load_more', 'azoom_portfolio_grid_make_single_ajax');







if(!function_exists('azoom_portfolio_grid_make_single')):
function azoom_portfolio_grid_make_single($atts){
	global $post;
		
	if(empty($atts) || !is_array($atts)) return '';
	//All attributes. Shortcode attributes and all required variables
	extract($atts);
		
	//Extract hover obj to override old values such as boolean true to string 'true';
	extract($hover_obj);

	
	if(empty($post) && !isset($post)){
		$post = get_post($post_id);	
	}
		
	if($masonry === 'true'){
		$masonry_attr = 'data-masonry-elem="'.esc_attr($masonry_item_class).'"';
	}
	
	if(function_exists('rad_get_option')){
		if(isset($hover_bg_change_elem) && $hover_bg_change_elem === 'true' && rad_get_option('main_hover_bg_change', $post)){
			$hover_obj['hover_bg_color']	=	rad_get_option('main_hover_bg_color', $post);
			$hover_obj['hover_bg_opacity']	=	rad_get_option('main_hover_bg_opacity', $post);
		}
	}

	
	$return = '';
					
	$rockthemes_advanced_details = get_post_meta($post->ID,'advanced_post_details',true);
	
	$schema = rockthemes_get_product_schema();

	$link_html = '';
	
	if(isset($post_tax)){
		$cat_list = wp_get_post_terms($post->ID,$post_tax);
		$total_cat = count($cat_list);
		$c = 0;
		
		$cat_divider = ($cats_in_hover === 'true') ? ' / ' : ', ';
		foreach($cat_list as $cat){
			$tax = get_category_by_slug($cat->slug);
			$tax = get_term_link($cat->slug,$post_tax);	

			//Check if category linking is active
			if($activate_category_link === 'true' || $activate_category_link === true){
				$link_html .= '<a '.($cats_in_hover === 'true' ? 'class="cat-link"' : 'class="cat-link"').' href="'.esc_url($tax).'">';
			}
			$link_html .= $cat->name;
			if($activate_category_link === 'true' || $activate_category_link === true){
				$link_html .= '</a>';
			}
			
			$c++;
			if($c < $total_cat) $link_html .= $cat_divider;
		}
	}

	if($content['use_cats'] === 'true' || $content['use_cats'] === true){
		$hover_obj['content']['cats_link'] = $link_html;
	}
	
	
	
	$featuredBig = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'ajax-filtered-hover');
	if($featuredBig){ 
		$featuredBig = $featuredBig[0];
	}else{
		$featuredBig = (wp_get_attachment_url( get_post_thumbnail_id($post->ID) ) && !$featuredBig) ? wp_get_attachment_url( get_post_thumbnail_id($post->ID) ): 'no-image';
	}
	
	if(($featuredBig === '' || $featuredBig === 'no-image' || !$featuredBig) && get_post_thumbnail_id($post->ID)){
		$featuredBig = rockthemes_demo_image('ajax-filtered-hover',true);
	}
	
	$thumbnail = wp_get_attachment_image( get_post_thumbnail_id($post->ID),$image_size );
	if($thumbnail && strpos($thumbnail, 'width') > -1 && xr_get_option('remove_image_wh', true)){
		$thumbnail = preg_replace( '/(width|height)="\d*"\s/', '', $thumbnail );
	}
	
	if($thumbnail === '' && get_post_thumbnail_id($post->ID)){
		$thumbnail = rockthemes_demo_image('ajax-filtered-hover');
	}
	
	$masonry_size = function_exists('rad_get_option') ? rad_get_option('masonry_size', $post) : '';


	$masonry_size_class = '';
	if(isset($masonry_size) && $masonry_size && $masonry_size !== '' && $masonry === 'true' && $portfolio_model === 'grid'){
		switch($masonry_size){
			case 'widetall':
			$image_size = 'masonry_wide_tall';
			$thumbnail = wp_get_attachment_image( get_post_thumbnail_id($post->ID), 'masonry_wide_tall' );
			break;	
			
			case 'wide':
			$image_size = 'masonry_wide';
			$thumbnail = wp_get_attachment_image( get_post_thumbnail_id($post->ID), 'masonry_wide' );
			break;	
			
			case 'tall':
			$image_size = 'masonry_tall';
			$thumbnail = wp_get_attachment_image( get_post_thumbnail_id($post->ID), 'masonry_tall' );
			break;	
		}

		if($thumbnail == '' && get_post_thumbnail_id($post->ID)){
			$thumbnail = rockthemes_demo_image($image_size);	
		}
		
		if(xr_get_option('remove_image_wh', true)){
			$thumbnail = preg_replace( '/(width|height)="\d*"\s/', '', $thumbnail);
		}
		
		$masonry_size_class = $masonry_size;
	}

	//TO DO : Bind Schema to a setting. This adds Schema.
	if($thumbnail && 1 == 1){
		$thumbnail = str_replace('<img ', '<img itemprop="image" ', $thumbnail);	
	}
	
	$title = $thumbnail ? $thumbnail : $post->post_title;
	
	
	if(!$thumbnail){
		$placeholder_size = rockthemes_get_custom_image_size($image_size);
		$placeholder = array('font_size' => '40px', 'width' => '80px');
		if($placeholder_size){
			$placeholder['width'] = $placeholder_size[0].'px';
			$placeholder['height'] = $placeholder_size[1].'px';
			$placeholder['font_size'] = '80px';
		}
		$title = azoom_featured_empty_icons($post->post_type, $placeholder, ($post->post_type === 'product' ? false : true));
	}

	$link = '';
	if($where_to_link === 'items'){
		$link = get_post_permalink($post->ID);
	}
	if(isset($where_to_link) && $where_to_link === 'external' && function_exists('rad_get_option') && rad_get_option('external_link', $post) && rad_get_option('external_link', $post) !== ''){
		$link = rad_get_option('external_link', $post);
		$hover_obj['where_to_link'] = $where_to_link;
	}else{
		$link = get_permalink();	
	}
	

	$excerpt = rock_check_p($post->post_excerpt);
	
	$product_price = '';
	$product = null;
	$use_woo_details = false;
	if(rockthemes_woocommerce_active() && function_exists('is_woocommerce') && is_woocommerce()){
		$product = new WC_Product( $post->ID );
		if(isset($product) && $product){
			$use_woo_details = true;
			$product_price = $product->get_price_html();
			$excerpt = '<div class="remove-foundation-padding"><div class="large-9 columns">'.rock_check_p($post->post_excerpt).'</div><div class="price-holder large-3 columns right-text">'.esc_attr($product_price).'</div></div>';
		}

	}
	
	if($link && $link != '' && $activate_hover != 'true'){
		$title = '<div class="relative-container rockthemes-hover"><a href="'.esc_url($link).'">'.($title).'</a></div>';
	}
	
	if(isset($display_date) && $display_date === 'true'){
		$overlay_date_bg_style = '';
		if(isset($hover_bg_change_elem) && $hover_bg_change_elem === 'true' && function_exists('rad_get_option') && rad_get_option('main_hover_bg_change', $post)){
			$overlay_date_bg_style = 'style="background:'.esc_attr(rad_get_option('main_hover_bg_color', $post)).';"';
		}

		$title .= '<div class="overlay-date-area azoom-transition" '.$overlay_date_bg_style.'>';
		if($post_type === 'post'){
			$title .= '<i class="'.azoom_get_post_type_icon_class().'"></i> ';
		}
		
		$title .= '<span class="entry-date" itemprop="datePublished" content="'.esc_attr( get_the_date( 'c' ) ).'">'.get_the_date().'</span></div>';
	}

	if($activate_hover == 'true'){
		$hover_effect = azoom_hover_effect($post->ID, $hover_obj, false);
		$title = '<div class="relative-container rockthemes-hover '.($use_shadow === 'true' ? 'azoom-small-box-shadow' : '').'">'.$title.$hover_effect.'</div>';
	}
	if(!rockthemes_is_true($link) && !rockthemes_is_true($activate_hover)){
		$title = '<div class="relative-container">'.$title.'</div>';
	}
	
		
	$description = '';
	$list_description = '';
	$price_html = '';					
	
	$desc_details = explode('_',$excerpt_title_option);
	
	$desc_details_price_active = false;
	if(strpos($excerpt_title_option,'price') > -1) $desc_details_price_active = true;
		
	$desc_details_excerpt_active = false;
	if(strpos($excerpt_title_option,'excerpt') > -1) $desc_details_excerpt_active = true;
	
	
	//WooCommerce Price
	if(isset($display_price) && ($display_price === 'true' || $display_price === true)){
				
		$price_html .= '<p class="azoom-price">'.$product_price.'</p>';
	}
	
	//Get WooCommerce Buttons
	$woo_buttons = '';
	if($use_woo_details && $details_in_hover === 'dunder_image'){
		$woo_buttons = rockthemes_woo_style_buttons();
	}
	
	
	if($excerpt_title_option != "no_description" && $details_in_hover !== 'din_hover'){
		foreach($desc_details as $detail){
			switch($detail){
				case 'title':
				if($activate_header_link === 'false'){
					$description .= '<h2 class="azoom-portfolio-title entry-title" itemprop="name">'.get_the_title().'</h2>';
				}else{
					$description .= '<h2 class="azoom-portfolio-title entry-title" itemprop="name"><a href="'.$link.'">'.get_the_title().'</a></h2>';
				}
				
				if($activate_category_link === 'true'){
					//Check if user activates the category link
					$description .= '<p class="azoom-portfolio-category-link">'.$link_html.'</p>';	
				}
				
				if(!$desc_details_excerpt_active){
					$description .= $price_html;	
				}
				
				
				break;
				
				case 'excerpt' :
				/*
				**	WooCommerce
				*/
				$description .= $price_html;

				if($desc_details_price_active) $description .= '<div>';
				$description .= '<p class="azoom-portfolio-excerpt" itemprop="description">'.(rockthemes_excerpt($post->post_excerpt,$excerpt_length)).'</p>';
				if($desc_details_price_active) $description .= '</div>';

				break;
				
			}
			
		}
		
	}
	
	$description .= $woo_buttons;

	
	//Model switch deprecated. Only list is active. Switch works but needs style improvements
	if($portfolio_model === 'list' || ($portfolio_model_switch === 'true' && 1 == 0)){
		//List Description will always display
		if($activate_header_link === 'false'){
			$list_description .= '<h2 class="azoom-portfolio-title entry-title" itemprop="name">'.get_the_title().'</h2>';
		}else{
			$list_description .= '<h2 class="azoom-portfolio-title entry-title" itemprop="name"><a href="'.get_permalink().'">'.get_the_title().'</a></h2>';
		}
		
		if($use_woo_details){
			$list_description .= $price_html;	
		}
				
		if($activate_category_link === 'true'){
			//Check if user activates the category link
			$list_description .= '<p class="azoom-portfolio-category-link">'.$link_html.'</p>';	
		}
		
		if($portfolio_model === 'list' || $portfolio_model_switch === 'true'){
			//Moved here from the switch. Now list view will always display the excerpt
			/*
			**	WooCommerce
			*/
			if($desc_details_price_active) $list_description .= '<div>';
			$list_description .= '<p class="azoom-portfolio-excerpt" itemprop="description">'.(rockthemes_excerpt($post->post_excerpt,$excerpt_length)).'</p>';
			if($desc_details_price_active) $list_description .= '</div>';
		}
		
		$button_html = '';
		
		if(isset($rockthemes_advanced_details['extra_buttons']) && $rockthemes_advanced_details['extra_buttons'][0] != ''){
			foreach($rockthemes_advanced_details['extra_buttons'] as $extra_button){
				$button_html .= do_shortcode($extra_button);	
			}
		}
						
		$primary_button = '<a href="'.get_permalink().'" class="more-link">'.esc_html__('Details','azoom').' <i class="animate-icon animate-to-right icomoon icomoon-icon-next15"></i></a>';
			
		if($use_woo_details && $details_in_hover === 'dunder_image'){
			$primary_button = $woo_buttons;	
		}
		
		$list_description .= '
			<div class="azoom-portfolio-buttons large-6 columns end">
				'.do_shortcode($primary_button).'
				'.$button_html.'
			</div>
		';
		
		//End of list description
	}
		
		
	
	$boxed_cover_html_pre = '';
	$boxed_cover_html_after = '';
	$boxed_cover_html_class = '';
	$boxed_cover_list_before = '';
	$boxed_cover_list_after = '';
	
	if(($boxed_layout == 'true' && $portfolio_model === 'list') || ($boxed_layout == 'true' && $portfolio_model === 'grid' && $details_in_hover === 'dunder_image'))	{
		$boxed_cover_html_pre = '<div class="boxed_layout_holder '.($portfolio_model ==='grid' ? 'boxed-layout boxed-colors columns' : 'large-'.(12 - (int)$list_image_col_large).' medium-'.(12 - (int)$list_image_col_large).' columns').'" data-ref="boxed-layout boxed-colors">';	
		$boxed_cover_html_after = '</div>';
		$boxed_cover_html_class = 'boxed-layout boxed-colors azoom-portfolio';
		
		if($portfolio_model === 'list'){
			$boxed_cover_list_before = '<div class="boxed-layout boxed-colors padding columns margin-bottom">';
			$boxed_cover_list_after = '</div>';
		}
	}
	
	if($portfolio_model === 'list'){
		$title = '<div class="relative-container-holder large-'.esc_attr($list_image_col_large).' medium-'.esc_attr($list_image_col_large).' columns">'.$title.'</div>';	
	}

	$return .= $boxed_cover_list_before.'<'.(($boxed_layout === 'true' && $portfolio_model === 'list') ? 'div' : 'li').' class="azoom-default-item azoom-animate-queue '.(($portfolio_model === 'list' )  ? 'row' : '').' '.($use_woo_details ? 'rockthemes-woo-elem' : '').' '.$masonry_size_class.' '.$masonry_item_class.'" data-featured-big="'.esc_attr($featuredBig).'">
				'.$title.$boxed_cover_html_pre.'
				'.(($portfolio_model !== 'list' && $details_in_hover === 'dunder_image') ? '<div class="grid-description">'.$description.'</div>' : '').'
				'.($portfolio_model === 'list' ? '<div class="list-description '.(($portfolio_model === 'list' && $boxed_layout != 'true') ? 'large-'.(12 - (int)$list_image_col_large).' medium-'.(12 - (int)$list_image_col_large).' columns' : '').'" data-class-ref="7">'.$list_description.'</div>' : '').'
				'.$boxed_cover_html_after.'
				</'.(($boxed_layout === 'true' && $portfolio_model === 'list') ? 'div' : 'li').'>
				'.$boxed_cover_list_after;
	
					
	return $return;
					
}
endif;











/*
**	Generates Swiper Slider Shortcode
**	@param $postID					:	ID of the post
**	@param $image_size				:	Wordpress image size
**	@param	$return_f_if_no_swiper	:	If there are no images for swiper, and we do not want default image size, return false
**	@return							:	Shortcode of the swiper slider with do_shortcode function
*/
if(!function_exists('rockthemes_make_swiperslider_shortcode')){
function rockthemes_make_swiperslider_shortcode($postID,$image_size='rockthemes_thumbnail', $return_f_if_no_swiper = false){
	//global $rockthemes_advanced_details,$not_mean;
	if(!$postID) return '';

	//Do not make a query if we have declared the advanced_details before. Performance improvement
	$rockthemes_advanced_details = get_post_meta($postID,'advanced_post_details',true);
	
	$images_string = '';
	
	$featured_regular = wp_get_attachment_image_src(get_post_thumbnail_id($postID),'full');
	
	if(!$featured_regular && get_post_thumbnail_id($postID)){
		$featured_regular = rockthemes_demo_image('',true);	
	}
	
	if(isset($featured_regular[0])){
		$images_string .= $featured_regular[0];
	}


	if(isset($rockthemes_advanced_details['extra_featured_images']) && 
		is_array($rockthemes_advanced_details['extra_featured_images']) && 
		count($rockthemes_advanced_details['extra_featured_images']) &&
		$rockthemes_advanced_details['extra_featured_images'][0] != ''){
		$length = count($rockthemes_advanced_details['extra_featured_images']);
		$i = 0;

		$loop_images_string = '';
		foreach($rockthemes_advanced_details['extra_featured_images'] as $extra_image){
			if($extra_image == '' || strlen($extra_image) < 11) continue;
			if(strlen($extra_image) > 10){
				$id_test = rockthemes_get_image_id_from_url($extra_image);
				if($id_test == ''){
					$extra_image = rockthemes_demo_image('',true);	
				}
			}
			$loop_images_string .= $extra_image;
			$i++;

			if($i<$length) $loop_images_string .= ',';
		}
		if($i > 0) $images_string .= ','.$loop_images_string;
	}else{
		if($return_f_if_no_swiper){return false;}
		$thumbnail = wp_get_attachment_image( get_post_thumbnail_id($postID),$image_size );
		
		if($thumbnail == '' && get_post_thumbnail_id($postID)){
			$thumbnail = rockthemes_demo_image();	
		}
		
		if(xr_get_option('remove_image_wh', true)){
			$thumbnail = preg_replace( '/(width|height)="\d*"\s/', '', $thumbnail);
		}
		
		return $thumbnail;
	}
		
	$shortcode = '[rockthemes_swiperslider images="'.$images_string.'" size="'.esc_attr($image_size).'" max_width="1140px"]';

	return do_shortcode($shortcode);
}
}










//Remove the Wordpress Default Gallery Shortcode
remove_shortcode('gallery');
if(!function_exists('rockthemes_shortcode_make_wp_gallery')){
	function rockthemes_shortcode_make_wp_gallery($atts){
		global $post;
		
		extract(shortcode_atts(array(
			'orderby' 		=>	'menu_order ASC, ID ASC',
			'id'			=>	$post->ID,
			'ids'			=>	'',
			'itemtag'		=>	'dl',
			'icontag'		=>	'dt',
			'captiontag'	=>	'dd',
			'columns'		=>	3,
			'size'			=>	'main_medium',
			'link'			=>	'file'
		), $atts));
		
		$hover_obj = array(
			'activate_hover_box'	=>	false,
			'activate_hover'		=>	true,
			'use_link'				=>	true,
			'use_back_icon'			=>	true,
			'full_link'				=>	false,
			'lightbox'				=>	array(
				'image'		=>	true,
				'video'		=>	true,
				'gallery'	=>	true,
			),
			'like'					=>	true,
			'use_schema'			=>	true,
			'content'				=>	array(
				'use_title'		=>	false,
				'link_title'	=>	true,
				'use_cats'		=>	false,
				'use_price'		=>	false,
				'use_excerpt'	=>	false,
				'excerpt_length'	=>	18,
			),
		);
		
		if(isset($GLOBALS['lightbox_gallery'])){
			$GLOBALS['lightbox_gallery']++;
		}else{
			$GLOBALS['lightbox_gallery'] = 0;	
		}

		$args = array(
			'post_type' => 'attachment',
			'post_parent' => $id,
			'numberposts' => -1,
			'orderby' => $orderby
			); 
		$images = get_posts($args);
	 
	 
	 	$return = '<ul class="large-block-grid-'.esc_attr($columns).' rockthemes-wp-gallery">';
		
		if(!empty($ids)){
			$ids_array = explode(',',$ids);
			if(count($ids_array) > 0) $images=array();
			foreach($ids_array as $a_id){
				$images[] = get_post($a_id);
			}
		}
	 
	 
	 
		foreach ( $images as $image ) {     
			$caption = $image->post_excerpt;
	 
			$description = $image->post_content;
			$title = $image->post_title;
			if($description == '') $description = $title;
	 
			$image_alt = get_post_meta($image->ID,'_wp_attachment_image_alt', true);
	 		
			$img_str = '';
			if(xr_get_option('remove_image_wh', true)){
				$img = wp_get_attachment_image_src($image->ID, $size);
				$img_str = '<img src="'.esc_url($img[0]).'" alt="'.esc_attr($image_alt).'" />';
			}else{
				$img_str =  wp_get_attachment_image($image->ID, $size);
			}
			
			if(($img_str == '' || !$img_str) && $image->ID){
				$img_str = rockthemes_demo_image();	
			}
			
				 
			// render your gallery here
			$return .= '
				<li><div class="relative-container rockthemes-hover azoom-small-box-shadow">'.$img_str.''.azoom_hover_effect($image->ID, $hover_obj).'</div>'.esc_attr($caption).'</li>
			';
		}
		
		$return .= '</ul>';//Close the main ul 
		
		$return = '<div class="relative-container">'.$return.'</div>';
		
		return $return;
	}
}
add_shortcode('gallery', 'rockthemes_shortcode_make_wp_gallery');




/*
**	Google Map Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_google_map')){
	function rockthemes_shortcode_make_google_map($atts, $content=null){
		extract(shortcode_atts(array(
			'api_key'		=>	'',
			'marker_title'	=>	'',
			'lat' 			=>	'-34.397',
			'lng'			=>	'150.644',
			'zoom_level'	=>	8,
			'map_type'		=>	'ROADMAP',
			'sensor'		=>	'false',
			'mouse_wheel'	=>	'true',
			'height'		=>	400,
			'resize_height'	=>	'false',
			'fullscreen'	=>	'false',
		), $atts));
		
		if(isset($GLOBALS['rockthemes_googlemap'])){
			$GLOBALS['rockthemes_googlemap']++;	
		}else{
			$GLOBALS['rockthemes_googlemap'] = 0;	
		}
		$id = 'google-map-'.$GLOBALS['rockthemes_googlemap'];
						

		$library_url = esc_url('https://maps.googleapis.com/maps/api/js?key='.esc_attr($api_key).'&sensor='.esc_attr($sensor).'&signed_in=true');
		//Enqueue Google Map Library with API KEY
		wp_enqueue_script('google-map', $library_url);
		
		$style_obj = '';
		
		if(strpos($content,'rockthemes_shortcode_start') > -1){
			preg_match_all('/rockthemes_shortcode_start(.*?)rockthemes_shortcode_end/',$content, $style_obj_array);
			if(!empty($style_obj_array)){
				$style_obj = str_replace(array("rockthemes_shortcode_start","rockthemes_shortcode_end"),array("",""),$style_obj_array[1][0]);
			}
			
			$content = substr($content,0,strpos($content,'rockthemes_shortcode_start'));
			
		}
		
		$content = ($content);
				
		$script = '
			<script type="text/javascript">
				var map_ratio = 1;
				function initialize_google_map() {
					var latLng = new google.maps.LatLng('.esc_attr($lat).', '.esc_attr($lng).');
					var draggable = jQuery(window).width() < 800 ? false : true;
					
					var mapOptions = {
						center: latLng,
						zoom: '.(int) $zoom_level.',
						mapTypeId: google.maps.MapTypeId.'.esc_attr($map_type).',
						zoomControlOptions: {
						  style: google.maps.ZoomControlStyle.LARGE
						},
						mapTypeControl: true,
						scrollwheel: '.esc_attr($mouse_wheel).',
						draggable: draggable
					};';
					
		if(isset($style_obj) && $style_obj !== ''){
			$script .= 'mapOptions.styles = '.($style_obj).';';
		}
		
		if($fullscreen === 'true'){
			$script .= 'var wh = jQuery(window).height();
						jQuery("#'.esc_attr($id).'").css("height", wh+"px");
					';	
		}
					
		$script .= 'var map = new google.maps.Map(document.getElementById("'.esc_attr($id).'"), mapOptions);
					
					var infowindow = new google.maps.InfoWindow({
						content: '.json_encode($content).'
					});					
					
					var marker = new google.maps.Marker({
						position: latLng,
						map: map,
						title:"'.esc_attr($marker_title).'"
					});			
					
					google.maps.event.addListener(marker, "click", function() {
						infowindow.open(map,marker);
					});			
								
					map_ratio = jQuery("#'.esc_attr($id).'").width() / '.(int) $height.';
									
		';
		
		if($resize_height === 'true' || 1 == 1){
			$script .= '
				jQuery(window).resize(function(){
					var that = jQuery("#'.esc_attr($id).'");
					var new_height = that.width() / map_ratio;
					var fullscreen = that.attr("data-fullscreen");
					if(fullscreen === "true"){
						new_height = jQuery(window).height()+"px";
					}
					if(new_height <= '.(int) $height.' || fullscreen === "true"){
						that.css("height", new_height);
					}
					
					google.maps.event.trigger(map, "resize");
				});
			';
		}
		
		$script .= '
				}

				jQuery(window).load(initialize_google_map);

			</script>
		';
		
		$html = '
			<div class="rockthemes-googlemap-container">
				<div id="'.esc_attr($id).'" class="rockthemes-googlemap" style="height:'.esc_attr($height).'px;" data-fullscreen="'.esc_attr($fullscreen).'"></div>
			</div>	
		';
		
		return $html.$script;
	}
}


add_shortcode('rockthemes_google_map', 'rockthemes_shortcode_make_google_map');
/*
**	End of Google Map Shortcode
*/



/*
**	LeafLet Map Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_leaflet_map')){
	function rockthemes_shortcode_make_leaflet_map($atts, $content=null){
		extract(shortcode_atts(array(
			'api_key'		=>	'',
			'marker_title'	=>	'',
			'lat' 			=>	'-34.397',
			'lng'			=>	'150.644',
			'zoom_level'	=>	8,
			'map_type'		=>	'ROADMAP',
			'sensor'		=>	'false',
			'mouse_wheel'	=>	'true',
			'height'		=>	400,
			'resize_height'	=>	'false',
			'fullscreen'	=>	'false',
		), $atts));
		
		if(isset($GLOBALS['rockthemes_leafletmap'])){
			$GLOBALS['rockthemes_leafletmap']++;	
		}else{
			$GLOBALS['rockthemes_leafletmap'] = 0;	
		}
		$id = 'leaflet-map-'.$GLOBALS['rockthemes_leafletmap'];


		if(strpos($content,'rockthemes_shortcode_start') > -1){
			preg_match_all('/rockthemes_shortcode_start(.*?)rockthemes_shortcode_end/',$content, $style_obj_array);
			if(!empty($style_obj_array)){
				$style_obj = str_replace(array("rockthemes_shortcode_start","rockthemes_shortcode_end"),array("",""),$style_obj_array[1][0]);
			}
			
			$content = substr($content,0,strpos($content,'rockthemes_shortcode_start'));
			
		}
		
		$content = ($content);

						
/*
		//Enqueue LeafLet Map Library with API KEY
		wp_enqueue_style( 'leaflet', AZOOM_PLUGIN_URI.'/libs/leaflet/leaflet.css', '', '', 'all' );
		wp_enqueue_script('leaflet', AZOOM_PLUGIN_URI.'/libs/leaflet/leaflet.js', array('jquery'), '2.7.0', false);
*/		
		//$library_url = esc_url('https://maps.leafletapis.com/maps/api/js?key='.esc_attr($api_key).'&sensor='.esc_attr($sensor).'&signed_in=true');
		//wp_enqueue_script('leaflet-map', $library_url);

		$js = '';

		$return = '<div id="'.$id.'" style="height:'.esc_attr( $height ).'px;z-index:0;" data-fullscreen="'.esc_attr($fullscreen).'"></div>';

		$js .= '
		<script type="text/javascript">
			(function(jQuery){
				function init(){

					var wh = jQuery(window).height(),
						map_ratio = jQuery("#'.esc_attr($id).'").width() / '.(int) $height.';	

					var mymap = L.map("'.$id.'").setView(['.esc_attr( $lat ).', '.esc_attr( $lng ).'], '.$zoom_level.');

					L.tileLayer("https://api.tiles.mapbox.com/v4/{id}/{z}/{x}/{y}.png?access_token={accessToken}", {
					    attribution: "Map data &copy; <a href=\"https://www.openstreetmap.org/\">OpenStreetMap</a> contributors, <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, Imagery © <a href=\"https://www.mapbox.com/\">Mapbox</a>",
					    maxZoom: 18,
					    id: "mapbox.streets",
					    detectRetina:true,
					    trackResize:false,
					    accessToken: "'.esc_attr( $api_key ).'"
					}).addTo(mymap);

					mymap.scrollWheelZoom.disable();

					var marker = L.marker(['.esc_attr( $lat ).', '.esc_attr( $lng ).']).addTo(mymap);
					marker.bindPopup("'.addslashes($content).'");

					jQuery(window).resize(function(){
						var that = jQuery("#'.esc_attr($id).'");
						var new_height = that.width() / map_ratio;
						var fullscreen = that.attr("data-fullscreen");
						if(fullscreen === "true"){
							new_height = jQuery(window).height()+"px";
						}
						if(new_height <= '.(int) $height.' || fullscreen === "true"){
							that.css("height", new_height);
						}
						
						mymap.invalidateSize();
					});

					';

					if($fullscreen === 'true'){
						$js .= 'jQuery("#'.esc_attr($id).'").css("height", wh+"px");';	
					}

		$js .= '
				}

				jQuery(window).load(init);

			})(jQuery);


		</script>';

		$return .= $js;

		return $return;

	}
}


add_shortcode('rockthemes_leaflet_map', 'rockthemes_shortcode_make_leaflet_map');
/*
**	End of LeafLet Map Shortcode
*/









/*
**	Promotion Box Shortcode
*/
if(!function_exists('rockthemes_shortcode_make_promotion_box')){
	function rockthemes_shortcode_make_promotion_box($atts, $content=null){		

		extract(shortcode_atts(array(
			'background_color'		=>	'#333333',
			'font_color' 			=>	'#FFFFFF',
		), $atts));

		$button_shortcode = '';
		
		if(strpos($content,'rockthemes_shortcode_start') > -1){

			preg_match_all('/rockthemes_shortcode_start(.*?)rockthemes_shortcode_end/',$content, $button_shortcode_array);
			if(!empty($button_shortcode_array)){
				$button_shortcode = str_replace(array("rockthemes_shortcode_start","rockthemes_shortcode_end"),array("",""),$button_shortcode_array[1][0]);
			}
			
			$content = substr($content,0,strpos($content,'rockthemes_shortcode_start'));
			
		}
		
		
		$return = '';
		
		$return .= '<div class="boxed-layout padding-2x" style="background-color:'.esc_attr($background_color).';">';
		
			$return .= '<div class="rock-promotion-box">';
			
				if($button_shortcode !== ''){
					$return .= '<div class="promotion-box-content" style="color:'.esc_attr($font_color).';">';	
				}else{
					$return .= '<div class="promotion-box-content" style="color:'.esc_attr($font_color).';">';	
				}

				
				$return .= ($content);
				
				$return .= '</div>';//Content columns
				
				if($button_shortcode !== ''){
					$return .= '
						<div class="promotion-box-button">
							<div class="promotion-box-button-container">
								'.do_shortcode($button_shortcode).'
							</div>
						</div>
					';	
				}
				
			
			$return .= '</div>';//row
		
		$return .= '</div>';//boxed-layout
		
		return $return;
	}
}

add_shortcode('rockthemes_promotion_box','rockthemes_shortcode_make_promotion_box');
/*
**	End of Promotion Box Shortcode
*/








/*
**	Alert Box Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_alert_box')){
	function rockthemes_shortcode_make_alert_box($atts, $content=null){
		extract(shortcode_atts(array(
			'background_color'		=>	'',
			'font_color' 			=>	'',
			'border_color'			=>	'',
			'alertbox_style'		=>	'info',
			'icon_class'			=>	'',
			'icon_url'				=>	'',
			'use_close_button'		=>	'true',
		), $atts));
		
		
		$use_icon = false;
		$use_url = false;
		$icon_html = '';
		
		if($alertbox_style !== 'custom'){
			$background_color = '';
			$border_color = '';
			$font_color = '';	
		}
		
		
		if($icon_class !== ''){
			$icon_html = '<i class="'.esc_attr($icon_class).' alertbox-icon padding" style="color:'.esc_attr($font_color).';"></i>';
			$use_icon = true;
		}
		
		if($icon_url !== ''){
			$icon_html = '<img src="'.esc_url($icon_url).'" class="alertbox-icon-image alertbox-icon padding" alt="icon" />';
			$use_icon = true;	
		}
				
		$return = '';
		
		$return .= '<div class="boxed-layout padding-2x alert-box '.esc_attr($alertbox_style).'" style="background-color:'.esc_attr($background_color).'; border-color:'.esc_attr($border_color).';">';
		
			$return .= '<div class="rock-alert-box row">';
			
				if($use_icon){
					$return .= $icon_html;	
				}
			
			
				if($use_icon !== ''){
					$return .= '<div class="alert-box-content" style="color:'.esc_attr($font_color).'">'.$content.'</div>';	
				}else{
					$return .= '<div class="alert-box-content" style="color:'.esc_attr($font_color).'">'.$content.'</div>';	
				}
				
				if($use_close_button === 'true'){
					$return .= '<div class="close alert-box-close" style="color:'.esc_attr($font_color).';">&times;</div>';
				}
			
			$return .= '</div>';//row
		
		$return .= '</div>';//boxed-layout
		
		return $return;
			
	}
}
add_shortcode('rockthemes_alert_box', 'rockthemes_shortcode_make_alert_box');

/*
**	End of Alert Box Shortcode
*/




/*
**	References Builder Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_references_builder')){
	function rockthemes_shortcode_make_references_builder($atts, $content = null){
		extract(shortcode_atts(array(
			'image_size'			=>	'medium',
			'references'			=>	'',
			'duration_time' 		=>	5000,
			'activate_navigation'	=>	'true',
			'auto_slide'			=>	'true',
			'block_grid_large'		=>	'3',
			'block_grid_medium'		=>	'3',
			'block_grid_small'		=>	'3',
			'ref_image_url_0'		=>	'',
			'ref_image_id_0'		=>	''
		), $atts));
		
		$block_class = ' large-block-grid-'.esc_attr($block_grid_large).' medium-block-grid-'.esc_attr($block_grid_medium).' small-block-grid-'.esc_attr($block_grid_small).' ';
		
		$references_html = '';

		$ri = 0;
		$ril = 'ref_image_link_';
		$rii = 'ref_image_id_';
		$i = 0;
		$hide = false;
		$closed = false;
		$total_ref = $references != '' ? count($references) : 0;
		$references_html .= '<div class="absolute-class" style="z-index:1;"><div class="relative-class"><ul class="'.$block_class.'">';
		
		$total_ref=0;
		while(isset($atts[$rii.$ri])){
			$total_ref++;
			$ri++;
		}
		
		$ri = 0;
		while(isset($atts[$rii.$ri])){
			
			$ref = array(0=>$atts[$rii.$ri], 1=>$atts[$ril.$ri]);
											
			$html = '';
			if($ref[0] !== ''){
				$ref_image_id = $ref[0];
				if(rockthemes_get_image_id_from_url($ref[0]) !== ''){
					$ref_image_id = rockthemes_get_image_id_from_url($ref[0]);
				}
				$this_img = '';
				if(xr_get_option('remove_image_wh', true)){
					$src = wp_get_attachment_image_src($ref_image_id, $image_size);
					$this_img = '<img src="'.esc_url($src[0]).'" alt="" />';
					$html .= $this_img;
				}else{
					$this_img = wp_get_attachment_image($ref_image_id, $image_size);
					$html .= $this_img;
				}
				
				if(($this_img == '' || !$this_img) && $ref_image_id && $ref_image_id != ''){
					$this_img = rockthemes_demo_image();
					$html .= $this_img;
				}
				
			}
			
			if($ref[1] !== ''){
				$html = '<a href="'.esc_url($ref[1]).'" target="_blank">'.$html.'</a>';	
			}
								
			if($html !== ''){
				$references_html .= '<li '.($hide ? 'style="margin-top:60px; opacity:0; filter: alpha(opacity=0);"' : 'style="z-index:1;"').'>'.$html.'</li>';
			}
			
			$i++;
			
			if(($i % (int) $block_grid_large) === 0){
				$references_html .= '</ul></div></div>';
				if($i < $total_ref){
					$references_html .= '<div class="absolute-class" style="display:hidden; z-index:0;"><div class="relative-class"><ul class="'.$block_class.'">';
				}else{
					$closed = true;	
				}
				$hide = true;
			}
			
			$ri++;
		}
		
		
		if(!$closed){
			$references_html .= '</ul></div></div>';
		}					

		
		if(isset($GLOBALS['rockthemes_referencesbuilder'])){
			$GLOBALS['rockthemes_referencesbuilder']++;
		}else{
			$GLOBALS['rockthemes_referencesbuilder'] = 0;	
		}
		
		$id_num = $GLOBALS['rockthemes_referencesbuilder'];
		
		$id = 'rock-references-builder-'.$GLOBALS['rockthemes_referencesbuilder'];
		
		$return = '';
		
		$return .= '<div id="'.esc_attr($id).'" class="rock-references-builder" data-time="'.esc_attr($duration_time).'" data-auto-slide="'.esc_attr($auto_slide).'" data-total-in-row="'.esc_attr($block_grid_large).'">';
									
			$return .= '<div class="rock-references-content">';
					
				$return .= $references_html;
				
			$return .= '</div>';//rock-references-content
			
			$navigation = '';
			if($activate_navigation === 'true'){
				$navigation = '	
						<div class="azoom-element-responsive-buttons">
							<div class="responsive-button azoom-transition-fast references_previous_button"><i class="icomoon icomoon-icon-arrow-left4"></i></div>
							<div class="responsive-button azoom-transition-fast references_next_button"><i class="icomoon icomoon-icon-arrow-right4"></i></div>
						</div>
				';
				
			}
			
			$return .= $navigation;			
		
		$return .= '</div>';//rock-references-builder

		
		return $return;
	}
}

add_shortcode('rockthemes_references_builder', 'rockthemes_shortcode_make_references_builder');

/*
**	End of References Builder Shortcode
*/





/*
**	Testimonials Builder Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_testimonials_builder')){
	function rockthemes_shortcode_make_testimonials_builder($atts, $content = null){
		extract( shortcode_atts( array(
			'boxed_layout'			=>	'false',
			'duration_time' 		=>	5000,
			'testimonials_title'	=>	'',
			'activate_navigation'	=>	'true',
			'auto_slide'			=>	'true',
				
		), $atts ) );	
		
		
		wp_enqueue_script('jquery');
		wp_enqueue_style( 'swiper-css', AZOOM_PLUGIN_URI.'/css/idangerous.swiper-2.css', '', '', 'all' );
		wp_enqueue_script('swiper-js', AZOOM_PLUGIN_URI.'/js/idangerous.swiper-2.7.js', array('jquery'), '2.7.0', true);
		
		
		if(isset($GLOBALS['rockthemes_testimonialsbuilder'])){
			$GLOBALS['rockthemes_testimonialsbuilder']++;
		}else{
			$GLOBALS['rockthemes_testimonialsbuilder'] = 1;
		}
		
		$id_num = $GLOBALS['rockthemes_testimonialsbuilder'];
				
		$id = 'rock-testimonialsbuilder-'.esc_attr($GLOBALS['rockthemes_testimonialsbuilder']);
		$pagination = 'pagination'.esc_attr($GLOBALS['rockthemes_testimonialsbuilder']);
		
		$GLOBALS['rockthemes_testimonialsbuilder_boxed'] = $boxed_layout == "true" ? true : false;
				
		$testimonialsbuilder_single_data = do_shortcode($content);
				
		$GLOBALS['rockthemes_testimonialsbuilder_first_single'] = false;
		
		$return = '';
		
		
		$return .= '<div id="'.$id.'" class="testimonials-builder-container">';
		
							
			$return .= '
			<div class="rock-testimonials-content azoom-swiperslider swiper-single-element" data-use-pagination="'.esc_attr($activate_navigation).'" data-auto-play="'.esc_attr($auto_slide).'" data-auto-play-time="'.esc_attr($duration_time).'">
				<div class="swiper-container">
					<div class="swiper-wrapper">';
					
					$return .= $testimonialsbuilder_single_data;
								
			$return .= '
					</div>
				</div>
				<div class="swiper-pagination '.esc_attr($pagination).'"></div>
			</div>';//rock-references-content
			
		
		$return .= '</div>';//rock-references-builder
		
		return $return;		
	}
	
}

add_shortcode("rockthemes_testimonials_builder", "rockthemes_shortcode_make_testimonials_builder");


if(!function_exists('rockthemes_shortcode_make_testimonials_builder_single')){
	function rockthemes_shortcode_make_testimonials_builder_single($atts, $content = null){	
		extract( shortcode_atts( array(
				'name'			=>	'',
				'company'		=>	'',
				'image_id'		=>	'',
				'image_url'		=>	'',
		), $atts ) );
		
		
		$ref_id = 'testimonialsbuilder-'.esc_attr($GLOBALS['rockthemes_testimonialsbuilder']);
		
		$return = '';
		
		$return .= '<div class="rock-testimonials-single swiper-slide testimonials-quotes">';
				
			$return .= '<div class="testimonials-content">';
			
				if($GLOBALS['rockthemes_testimonialsbuilder_boxed']){ $return .= '<div class="boxed-layout padding-2x">';}					
						
				$return .= $content;
				
				if($GLOBALS['rockthemes_testimonialsbuilder_boxed']){$return .= '</div>';}
			
			$return .= '</div>';
			
			$return .= '<div class="testimonials-details">';
			
				if($image_id !== '' || $image_url !== ''){

					$image_obj = array();					

					$size = 'main_small';
					
					if(isset($image_id)){

					}elseif(isset($image_url)){
						$image_id = rockthemes_get_image_id_from_url($image_url);
					}
								
					$src = wp_get_attachment_image($image_id, $size);
					
					if($src == '' && $image_id && $image_id != ''){
						$src = rockthemes_demo_image($size);	
					}
					
					if($src && $src !== ''){
						if(xr_get_option('remove_image_wh', true)){
							$src = preg_replace( '/(width|height)="\d*"\s/', '', $src );
						}
						$return .= '<span class="testimonial-image">'.$src.'</span>';
					}
				}
				
				$return .= '<span class="name-company">';
				
				if($name !== ''){
					$return .= '<strong> '.$name.'</strong><br/>';	
				}
				
				if($company !== ''){
					$return .= '<span class="testimonials-soft-color">'.$company.'</span>';	
				}
				
				$return .= '</span>';
							
			$return .= '</div>';
					
		$return .= '</div>';
		
		return $return;
	}
}

add_shortcode("rockthemes_testimonials_builder_single", "rockthemes_shortcode_make_testimonials_builder_single");

/*
**	End of Testimonials Builder Shortcode
*/






/*
**	Social Icons Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_social_icons')){
	function rockthemes_shortcode_make_social_icons($atts, $content = null){
		extract( shortcode_atts( array(
			'boxed_layout'			=>	'false',
			'duration_time' 		=>	5000,
			'testimonials_title'	=>	'',
			'activate_navigation'	=>	'true',
			'auto_slide'			=>	'true',
				
		), $atts ) );	
		
		
		if(isset($GLOBALS['rockthemes_socialicons'])){
			$GLOBALS['rockthemes_socialicons']++;
		}else{
			$GLOBALS['rockthemes_socialicons'] = 1;
			
			
		}
		
		$id_num = (int)$GLOBALS['rockthemes_socialicons'];
				
		$id = 'rock-social-icons-'.(int)$GLOBALS['rockthemes_socialicons'];
				
		$socialicons_single_data = do_shortcode($content);
				
		
		$return = '';
		
		
		$return .= '<div id="'.esc_attr($id).'" class="social-icon icon-group-container">';
											
				$return .= $socialicons_single_data;
				
				$return .= '<div class="clear"></div>';
									
		$return .= '</div>';//rock-references-builder
		
				
		return $return;
	}
	
}

add_shortcode("rockthemes_social_icons", "rockthemes_shortcode_make_social_icons");


if(!function_exists('rockthemes_shortcode_make_social_icons_single')){
	function rockthemes_shortcode_make_social_icons_single($atts, $content = null){	
		extract( shortcode_atts( array(
			'url'				=>	'',
			'icon_class'		=>	'',
			'icon_url'			=>	'',				
		), $atts ) );
		
		
		$use_icon = false;
		$use_url = false;
		$icon_html = '';
		$icon_hover_html = '';
		
		if($icon_class !== ''){
			$icon_class = esc_attr($icon_class);
			$icon_html = '<i class="'.esc_attr($icon_class).' social-icon-regular"></i>';
			$icon_hover_html = '<i class="'.esc_attr($icon_class).' social-icon-hover"></i>';
			$use_icon = true;
		}
		
		if($icon_url !== ''){
			$icon_html = '<img src="'.esc_url($icon_url).'"  />';
			$use_icon = true;	
		}
		
		
		$ref_id = 'social-icon-'.(int)$GLOBALS['rockthemes_socialicons'];
		
		$return = '';
		
		$return .= '<div class="rock-social-icon">';
		
			$return .= '<a href="'.esc_url($url).'" target="_blank">';
		
				$return .= '<div class="social-icon-container azoom-transition-fast">';
			
					$return .= $icon_html.$icon_hover_html;
			
				$return .= '</div>';
			
			$return .= '</a>';
		
		$return .= '</div>';

		return $return;
	}
}

add_shortcode("rockthemes_social_icons_single", "rockthemes_shortcode_make_social_icons_single");

/*
**	End of Social Icons
*/





/*
**	Team Members Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_team_members')){
	function rockthemes_shortcode_make_team_members($atts, $content = null){
		extract( shortcode_atts( array(
			'block_grid_large'		=>	1,
			'block_grid_medium'		=>	1,
			'block_grid_small'		=>	1,
		), $atts ) );	

		
		if(isset($GLOBALS['rockthemes_teammembers'])){
			$GLOBALS['rockthemes_teammembers']++;
		}else{
			$GLOBALS['rockthemes_teammembers'] = 1;
		}
		
		$id_num = $GLOBALS['rockthemes_teammembers'];
				
		$id = 'team-members-'.$GLOBALS['rockthemes_teammembers'];
		
		
		$return = '';
		
		$return .= '<div id="'.esc_attr($id).'" class="azoom-team-members">';
											
			$return .= '<ul class="large-block-grid-'.esc_attr($block_grid_large).' medium-block-grid-'.esc_attr($block_grid_medium).' small-block-grid-'.esc_attr($block_grid_small).'">';
	
				$return .= do_shortcode($content);
	
			$return .= '</ul>';								
									
		$return .= '</div>';//azoom-team-members
		
		
		return $return;
	}
	
}

add_shortcode("rockthemes_team_members", "rockthemes_shortcode_make_team_members");


if(!function_exists('rockthemes_shortcode_make_team_members_single')){
	function rockthemes_shortcode_make_team_members_single($atts, $content = null){	
		extract( shortcode_atts( array(
			'name'					=>	'',
			'company'				=>	'',
			'external_url'			=>	'',
			'member_image_url'		=>	'',
			'member_image_id'		=>	'',
		), $atts ) );
		
		$size_small	=	'main_medium';
		$size_big	=	'main_large';
		
		
		$social_shortcode = '';
		
		if(strpos($content,'rockthemes_shortcode_start') > -1){

			preg_match_all('/rockthemes_shortcode_start(.*?)rockthemes_shortcode_end/',$content, $social_shortcode_array);
			if(!empty($social_shortcode_array)){
				$social_shortcode = str_replace(array("rockthemes_shortcode_start","rockthemes_shortcode_end"),array("",""),$social_shortcode_array[1][0]);
			}
			
			$content = substr($content,0,strpos($content,'rockthemes_shortcode_start'));
			
		}

					
		if(isset($member_image_id) && $member_image_id !== ''){
			$image_id = $member_image_id;
		}elseif(isset($member_image_url) && isset($member_image_url)){
			$image_id = rockthemes_get_image_id_from_url(esc_url($member_image_url));
		}
		
		
		$img_small = wp_get_attachment_image($image_id, $size_small);
		$img_big = wp_get_attachment_image($image_id, $size_big);
		
		if($img_small == '' && $image_id && $image_id != ''){
			$img_small = rockthemes_demo_image($size_small);	
		}
		if($img_big == '' && $image_id && $image_id != ''){
			$img_big = rockthemes_demo_image($size_big);	
		}
		
		
		if(xr_get_option('remove_image_wh', true)){
			$img_small = preg_replace( '/(width|height)="\d*"\s/', '', $img_small);
			$img_big = preg_replace( '/(width|height)="\d*"\s/', '', $img_big);
		}


		$return = '<li>';
		
			$return .= '<div class="team-member-article article-margin-bottom boxed-layout boxed-colors azoom-small-box-shadow azoom-transition">';
			
				$return .= '	
					'.$img_small.'
					<div class="padding">
						<span class="team-member-i main-color">'.$company.'</span>
						<div class="member-b main-boxed-text-color">'.$name.'</div>
					</div>
				';
				
				$return .= '<div class="member-details">';
				
					$return .= '
						<div class="row">
							<div class="large-4 columns center-text">
								'.$img_big.'
							</div>
							<div class="large-8 columns left-text">
								<h3>'.esc_attr($name).' <span>'.esc_attr($company).'</span></h3>
								'.((isset($external_url) && $external_url !== '') ? 
								'<a class="member-url" href="'.esc_url($external_url).'" target="_blank">'.esc_url($external_url).'</a><br/><br/>' :
								 '').'
								'.($social_shortcode !== '' ? do_shortcode($social_shortcode).'<br/>' : '').'
								<div class="details">
									<div class="bio main-boxed-text-color">'.$content.'</div>
								</div>
							</div>
						</div>
					';
										
				$return .= '</div>';
			
			$return .= '</div>';//team-member-article
			
		$return .= '</li>';
		
		return $return;
	}
}

add_shortcode("rockthemes_team_members_single", "rockthemes_shortcode_make_team_members_single");

/*
**	End of Team Members
*/





/*
**	Before After Slider
*/

if(!function_exists('rockthemes_shortcode_make_before_after_slider')){
	function rockthemes_shortcode_make_before_after_slider($atts, $content=null){
		extract(shortcode_atts(array(
			'image_size'			=>	'main_large',
			'before_image_url' 		=>	'',
			'after_image_url'		=>	'',
			'height'				=>	'info',
			'min_width'				=>	'',
			'activate_navigation'	=>	''
		), $atts));
		

		wp_enqueue_style( 'zurb-twenty-twenty-style', AZOOM_PLUGIN_URI.'/css/twentytwenty.css', '', '', 'all' );

		wp_enqueue_script('jquery-event-move', AZOOM_PLUGIN_URI.'/js/jquery.event.move.min.js', array('jquery'), '');
		wp_enqueue_script('zurb-twenty-twenty', AZOOM_PLUGIN_URI.'/js/jquery.twentytwenty.min.js', array('jquery'), '1.0.0', true);
		
		if(isset($GLOBALS['rockthemes_beforeafterslider'])){
			$GLOBALS['rockthemes_beforeafterslider']++;
		}else{
			$GLOBALS['rockthemes_beforeafterslider'] = 0;	
		}

		$id = 'rockthemes-before-after-slider-'.esc_attr($GLOBALS['rockthemes_beforeafterslider']);
				
		$return = '';
		
		$return .= '<div id="'.esc_attr($id).'" class="rockthemes-before-after-slider twentytwenty-container">';
		
		
			$_before_image_id = '';
			if(isset($before_image_id)){
				$_before_image_id = $before_image_id;
			}else{
				$_before_image_id = rockthemes_get_image_id_from_url($before_image_url);
			}

			$before_image = wp_get_attachment_image($_before_image_id, $image_size);
			
			if($before_image == ''){
				$before_image = rockthemes_demo_image($image_size);	
			}

			if(xr_get_option('remove_image_wh', true)){
				$before_image = preg_replace( '/(width|height)="\d*"\s/', '', $before_image);
			}

			
			$_after_image_id = '';
			if(isset($after_image_id)){
				$_after_image_id = $after_image_id;
			}else{
				$_after_image_id = rockthemes_get_image_id_from_url($after_image_url);
			}
			
			$after_image = wp_get_attachment_image($_after_image_id, $image_size);
			
			if($after_image == ''){
				$after_image = rockthemes_demo_image($image_size);	
			}
			
			if(xr_get_option('remove_image_wh', true)){
				$after_image = preg_replace( '/(width|height)="\d*"\s/', '', $after_image);
			}
			
			$return .= $before_image;
		
			$return .= $after_image;

		$return .= '</div>';//boxed-layout
		
		$script = '';
						
		$script = '
			<script type="text/javascript">
				jQuery(window).load(function(){
					jQuery("#'.esc_attr($id).'").twentytwenty({default_offset_pct: 0.60});
				});
			</script>
		';
						
		return $return.$script;
			
	}
}
add_shortcode('rockthemes_before_after_slider', 'rockthemes_shortcode_make_before_after_slider');

/*
**	End of Alert Box Shortcode
*/





/*
**	Single Image Shortcode
**
*/
if(!function_exists('rockthemes_shortcode_make_single_image')){
	function rockthemes_shortcode_make_single_image($atts, $content = null){	
		extract( shortcode_atts( array(
			'image_id'				=>	'',
			'image_url'				=>	'',
			'image_align'			=>	'',
			'image_sizes'			=>	'main_large',
			
			'image_link_target'		=>	'',
			'link_url'				=>	'', 
			'link_id'				=>	'', 
			'link_is_tax'			=>	'', 
			'tax_name'				=>	'', 
			'icon_class'			=>	'', 
			'icon_url'				=>	'',
			
			'enable_hover'			=>	'',
			'hover_bg_color'		=>	'',
			'hover_color'			=>	'',
			'hover_title'			=>	'',
			
			'overflow_image'		=>	'false',
			'overflow_image_size'	=>	'',
			'extra_style'			=>	'',
			'extra_class'			=>	'',
			
			'snap_image'			=>	''
		), $atts ) );

		if(!$image_id && !$image_url) return;
		
		$image_classes = '';
		if($image_align !== ''){
			$image_classes .= ' '.$image_align.'-text ';
		}
		
		$data_details = '';
		
		if($overflow_image === 'true'){
			$image_classes .= ' azoom-overflow-image ';	
			$data_details .= 'data-overflow="'.(isset($overflow_image_size) && $overflow_image_size !== '' ? (int)$overflow_image_size : '105').'" ';
		}
		
		if($snap_image === 'left' || $snap_image === 'right'){
			$image_classes .= ' azoom-snap-image ';	
			$data_details .= 'data-snap-image="'.$snap_image.'" ';
		}
					
		//$image_id = '';
		if(isset($image_id) && $image_id !== ''){
			//Do Nothing
		}else{
			$image_id = rockthemes_get_image_id_from_url($image_url);
		}
		
		$image_file_name = str_replace(array('.jpg','.png','.gif','.svg'),array('','','',''), basename($image_url));
							
		//$image = wp_get_attachment_image($image_id, $image_sizes);
		if(function_exists('xr_get_option') && !xr_get_option('remove_image_wh', true)){
			$image = wp_get_attachment_image($image_id, $image_sizes);
			
			//For imported content, if demo image mode is enabled, check if this ID gives the originial image URL, or ID obtained by another image.
			if(xr_get_option('enable_demo_image', false) === true && strpos($image, basename($image_file_name)) === false){
				$image_id = '';
			}
		}else{
			$new_image_url = wp_get_attachment_image_src($image_id,$image_sizes);
			
			//For imported content, if demo image mode is enabled, check if this ID gives the originial image URL, or ID obtained by another image.
			if(function_exists('xr_get_option') && xr_get_option('enable_demo_image', false) === true && isset($new_image_url[0]) && strpos($new_image_url[0], basename($image_file_name)) === false){
				$image_id = '';
			}else{		
				$image_url = $new_image_url;
				$image_alt = trim(strip_tags( get_post_meta($image_id, '_wp_attachment_image_alt', true) ));	
				$image = '<img src="'.esc_url($image_url[0]).'" '.(isset($image_alt) && $image_alt ? 'alt="'.esc_attr($image_alt).'"' : '').' />';
			}
		}

		if($image_id == ''){
			$image = rockthemes_demo_image($image_sizes);	
		}
		
		
		
		$link_active = false;
		$link_html = '';
		
		if($link_url !== 'false'){
			$link_html = $link_url;
			$link_active = true;
		}elseif($link_id !== 'false' && $link_id !== 'undefined'){
			if($link_is_tax !== 'false'){
				$tax = get_category_by_slug($link_id);
				if(!$tax){
					$tax = get_term_link($link_id,$tax_name);	
				}else{
					$tax = get_category_link($tax);
				}
				$link_html = $tax;
			}else{
				$link_html = get_permalink($link_id);
			}
			$link_active = true;
		}		
		
		
		if($image_link_target === 'modal'){
			$link_html_array = wp_get_attachment_image_src($image_id,'');
			if(!$link_html_array && $image_id && $image_id != ''){
				$link_html = rockthemes_demo_image('',true);
			}else{
				$link_html = $link_html_array[0];
			}
		}
		
		$return = '<div class="azoom-single-image '.esc_attr($image_classes).' '.esc_attr($extra_class).'" '.($extra_style && $extra_style !== '' ? 'style="'.esc_attr($extra_style).'"' : '').' '.$data_details.'>';
		
			if($link_active){
				$return .= '
					<a href="'.esc_url($link_html).'" '.($image_link_target == "_blank" ? 'target="_blank"' : '').'
					'.($image_link_target === 'modal' ? ' data-rel="prettyPhoto" ' : '').'
					'.(($enable_hover === 'true' && $image_link_target === 'inline') ? ' class="rockthemes-inline-link" ' : '').'
					>
					<div class="relative-container '.($enable_hover === 'true' ? 'image-hover-enabled' : '').'">';
			}
		
			$return .=	$image;
			
			if($link_active){
				if($enable_hover === 'true'){
					$return .= '
						<div class="single-image-hover-bg azoom-transition-fast" style="background:'.esc_attr($hover_bg_color).';">
							<span class="single-image-hover-title azoom-transition" style="color:'.esc_attr($hover_color).';">'.esc_attr($hover_title).'</span>
						</div>
					';
				}
				
				$return .= '</div></a>';	
			}
			
		$return .= '</div>';
		
		return $return;
		
	}
}

add_shortcode("rockthemes_single_image", "rockthemes_shortcode_make_single_image");


/*
**	End of Single Image Shortcode
*/












/*
**	Rockthemes List Quick Shortcode on TinyMCE
**
**	
*/

if(!function_exists('rockthemes_shortcode_make_list')){
	function rockthemes_shortcode_make_list($atts, $content = null){	
		extract( shortcode_atts( array(
			'font_awesome_icon_class'	=>	'',
			'icomoon_icon_class'		=>	'',
			'icon_color'				=>	'',
		), $atts ) );
		
		//$content = str_replace(array('<p>','</p>'), array('',''), $content);
		
		$icon = '';
		$color = '';
		
		if($icon_color !== ''){
			$color = ' style="color:'.esc_attr($icon_color).';"';
		}
		
		if($font_awesome_icon_class !== ''){
			$icon = '<i class="fa '.esc_attr($font_awesome_icon_class).'" '.$color.'></i>';
		}
		if($icomoon_icon_class !== ''){
			$icon = '<i class="icomoon '.esc_attr($icomoon_icon_class).'" '.$color.'></i>';
		}
		
		
		$return = str_replace('<li>', '<li>'.$icon.' <span>', $content);
		$return = str_replace('</li>', '</span></li>', $return);

		
		$return = '<div class="rockthemes-list">'.$return.'<div class="clear"></div></div>';
		
		return $return;
		
	}
}

add_shortcode("rockthemes_list", "rockthemes_shortcode_make_list");


/*
**	End of Rockthemes TinyMCE List Shortcode
*/






/*
**	Rockthemes Advanced Text Quick Shortcode on TinyMCE
**
**	
*/

if(!function_exists('rockthemes_shortcode_make_advanced_text')){
	function rockthemes_shortcode_make_advanced_text($atts, $content = null){	
		extract( shortcode_atts( array(
			'font_family'	=>	'',
			'font_size'		=>	'',
			'font_weight'	=>	'',
			'font_color'	=>	'',
			'extra_style'	=>	'',
		), $atts ) );
		
		$return = '<span style="font-family:'.esc_attr(str_replace(';','',$font_family)).'; 
								font-size:'.esc_attr(str_replace('px','', $font_size)).'px; 
								font-weight:'.esc_attr(str_replace('px', '', $font_weight)).'; 
								color:#'.esc_attr(str_replace('#','', $font_color)).';
								 '.esc_attr($extra_style).'">'.$content.'</span>';		
		
				
		return $return;
		
	}
}

add_shortcode("rockthemes_advanced_text", "rockthemes_shortcode_make_advanced_text");


/*
**	End of Rockthemes TinyMCE Advanced Text Shortcode
*/





/*
**	Rockthemes Divider Quick Shortcode on TinyMCE
**
**	
*/

if(!function_exists('rockthemes_shortcode_make_divider')){
	function rockthemes_shortcode_make_divider($atts, $content = null){	
		extract( shortcode_atts( array(
			'type'	=>	'center',
		), $atts ) );
		
		$return = '';
		
		if($type === 'center'){
			$return = '
				<div class="rockthemes-divider">
					<span class="divider-line">
						<span class="divider-symbol"></span>
					</span>
				</div>
			';		
		}elseif($type === 'left'){
			$return = '
				<div class="rockthemes-divider">
					<span class="divider-line-left">
						<span class="divider-symbol-left"></span>
					</span>
				</div>
			';		
		}
		
				
		return $return;
		
	}
}

add_shortcode("rockthemes_divider", "rockthemes_shortcode_make_divider");


/*
**	End of Rockthemes Divider on TinyMCE
*/





/*
**	Rockthemes iFrame Youtube Video Quick Shortcode on TinyMCE
**
**	
*/

if(!function_exists('rockthemes_shortcode_make_youtube_video')){
	function rockthemes_shortcode_make_youtube_video($atts, $content = null){	
		extract( shortcode_atts( array(
			'resize_height'	=>	'true',
			'autoplay'		=>	'false',
			'mute'			=>	'false',
			'extra_style'	=>	'',
			'extra_class'	=>	'',
		), $atts ) );
		
		//Only activate api if we need to mute the video
		$api = $mute;
		
		$return = '';
		
		if($content === '') return;
		
		
		$video_id = explode("?v=", $content); // For videos like http://www.youtube.com/watch?v=...
		if (empty($video_id[1]))
			$video_id = explode("/v/", $content); // For videos like http://www.youtube.com/watch/v/..
		
		if(isset($video_id[1])){
			$video_id = explode("&", $video_id[1]); // Deleting any other params
		}
		$video_id = $video_id[0];
		
		if(!isset($GLOBALS['rockthemes_youtube_id'])){
			$GLOBALS['rockthemes_youtube_id'] = 0;	
		}else{
			$GLOBALS['rockthemes_youtube_id']++;	
		}
		
		$id = 'youtube_video_'.esc_attr($GLOBALS['rockthemes_youtube_id']);

		
		$video_details = '?wmode=transparent';
		if($autoplay === 'true'){
			$video_details .= '&autoplay=1&loop=1&controls=0&rel=0&playlist='.$video_id.'';	
			
			if($api === 'true'){
				$video_details .= '&enablejsapi=1&origin='.get_home_url().'';
			}
		}
		
		$video_details = str_replace('&', '&amp;', $video_details);
		
		$return = '
			<div class="azoom-iframe-container youtube-video '.esc_attr($extra_class).' '.($api === 'true' ? 'use-api' : '').'" data-youtube-id="'.esc_attr($video_id).'" style="'.esc_attr($extra_style).'">
		';
		if($api !== 'true'){
			$return .= '<iframe id="'.esc_attr($id).'" src="//www.youtube.com/embed/' . esc_attr($video_id .$video_details). '" height="240" width="320" allowfullscreen=""></iframe>';
		}else{
			$return .= '<div id="'.esc_attr($id).'" class="youtube-video-iframe-holder"></div>';
		}
		
		$return .= '</div>';
		
		
		return $return;
		
	}
}

add_shortcode("rockthemes_youtube_video", "rockthemes_shortcode_make_youtube_video");


/*
**	End of Rockthemes iFrame Youtube Video Shortcode
*/


/*
**	Rockthemes iFrame Vimeo Video Quick Shortcode on TinyMCE
**
**	
*/
if(!function_exists('rockthemes_shortcode_make_vimeo_video')){
	function rockthemes_shortcode_make_vimeo_video($atts, $content = null){	
		extract( shortcode_atts( array(
			'resize_height'	=>	'true',
			'autoplay'		=>	'false',
			'api'			=>	'true',
			'extra_style'	=>	'',
			'extra_class'	=>	'',
		), $atts ) );
		
		$return = '';
		
		if($content === '') return;
		
		if($api === 'true'){
			//Vimeo API froogaloop
			wp_enqueue_script('vimeo-froogaloop', AZOOM_PLUGIN_URI.'/js/froogaloop.min.js', array('jquery'));
		}
		
		$video_id = explode("/", $content); // For videos like http://www.youtube.com/watch?v=...
		if (empty($video_id[0]))
			$video_id = explode("/v/", $content); // For videos like http://www.youtube.com/watch/v/..
		
		if(isset($video_id[1])){
			$video_id = explode("&", $video_id[1]); // Deleting any other params
		}
		$video_id = $video_id[0];
		

		
		$video_id = rockthemes_get_vimeoid($content);
		
		
		if(!isset($GLOBALS['rockthemes_vimeo_id'])){
			$GLOBALS['rockthemes_vimeo_id'] = 0;	
		}else{
			$GLOBALS['rockthemes_vimeo_id']++;	
		}
		
		$id = 'vimeo_video_'.$GLOBALS['rockthemes_vimeo_id'];

		$video_details = '';
		if($autoplay === 'true'){
			$video_details = '?autoplay=1&loop=1';
			
			if($api === 'true'){
				$video_details .= '&api=1&byline=0&title=0&badge=0&player_id='.$id.'';
			}
		}

		$video_details = str_replace('&', '&amp;', $video_details);

		$return = '
			<div class="azoom-iframe-container vimeo-video '.($api === 'true' ? 'use-api not-visible' : '').'">
				<iframe id="'.$id.'" src="//player.vimeo.com/video/' .esc_attr($video_id .$video_details). '" height="240" width="320" allowfullscreen=""></iframe>
			</div>
		';
		
		
		return $return;
		
	}
}

add_shortcode("rockthemes_vimeo_video", "rockthemes_shortcode_make_vimeo_video");



if(!function_exists('rockthemes_get_vimeoid')):
function rockthemes_get_vimeoid( $url ) {
	$regex = '~
		# Match Vimeo link and embed code
		(?:<iframe [^>]*src=")?         # If iframe match up to first quote of src
		(?:                             # Group vimeo url
				https?:\/\/             # Either http or https
				(?:[\w]+\.)*            # Optional subdomains
				vimeo\.com              # Match vimeo.com
				(?:[\/\w]*\/videos?)?   # Optional video sub directory this handles groups links also
				\/                      # Slash before Id
				([0-9]+)                # $1: VIDEO_ID is numeric
				[^\s]*                  # Not a space
		)                               # End group
		"?                              # Match end quote if part of src
		(?:[^>]*></iframe>)?            # Match the end of the iframe
		(?:<p>.*</p>)?                  # Match any title information stuff
		~ix';
	
	preg_match( $regex, $url, $matches );
	
	if(isset($matches[1])){
		return $matches[1];
	}else{
		return '';	
	}
}
endif;
/*
**	End of Rockthemes Vimeo iFrame Video Shortcode
*/






/*
**	Rockthemes HTML5 Video Video Shortcode
**
*/
if(!function_exists('rockthemes_shortcode_make_html_video')){
	function rockthemes_shortcode_make_html_video($atts, $content = null){	
		extract( shortcode_atts( array(
			'video_url'		=>	'',
			'image_url'		=>	'',
			'image_id'		=>	'',
			'image'			=>	'',
			'autoplay'		=>	'false',
			'extra_style'	=>	'',
			'extra_class'	=>	'',
			'size'			=>	'large',
		), $atts ) );
		
		$return = '';
		
		$placeholder = '';
		
						
		if(isset($image_id) && $image_id !== ''){
			//Do nothing
		}elseif(isset($image_url)){
			$image_id = rockthemes_get_image_id_from_url($image_url);
		}else{
			$image_id = rockthemes_get_image_id_from_url($image);
		}

		$image = wp_get_attachment_image_src($image_id, $size);
		if(isset($image) && isset($image[0])){
			$placeholder = $image[0];
		}elseif($image_id && $image_id != ''){
			$placeholder = rockthemes_demo_image('',true);	
		}
		
		$return = '
		<div class="azoom-iframe-container html5-video">
			<video '.(isset($placeholder) ? 'poster="'.esc_url($placeholder).'"' : '').' controls>
				<source src="'.esc_url($video_url).'" type="video/mp4">
			</video>
		</div>
		';
		
		
		return $return;
		
	}
}
add_shortcode('rockthemes_html_video', 'rockthemes_shortcode_make_html_video');

/*
**	End of HTML5 Video 
*/










/*
**	Rockthemes Default Blog Shortcode
**	
**	Displays blogroll just like regular blog. Sticky posts will be displayed as first
**	
*/

if(!function_exists('rockthemes_shortcode_make_regular_blog')){
	function rockthemes_shortcode_make_regular_blog($atts, $content = null){

		extract( shortcode_atts( array(
			'pagination'		=>	'true',
			'total'				=>	5,
			'sticky_first'		=>	'false',
			'regular_content'	=>	'true',
			'category'			=>	'',
			
			'image_size'		=>	'thumbnail',
			'hover_active'		=>	'true',
			'image_col'			=>	4,
			'excerpt_length'	=>	30,
			'header_link'		=>	'true',
			'show_categories'	=>	'true',
			'show_tags'			=>	'true',
			'show_date'			=>	'true',
			'space_height'		=>	'45px',
		), $atts ) );
		
		
		global $more;		
				
		$total = (int) $total;
				
		$return = '';
		
		if($sticky_first === 'true'){
			
		
			$sticky = get_option('sticky_posts');
			
			if(count($sticky)) :
			$sticky_query = new WP_Query( 'p=' . esc_attr($sticky[0]).'&posts_per_page='.esc_attr($total).'&category_name='.esc_attr($category));	
			
			while ( $sticky_query->have_posts() ) : $sticky_query->the_post(); 
				$more = 0;
				
				if($regular_content === 'true'){
					ob_start();
					get_template_part( 'content', get_post_format() );
					$return .= ob_get_clean();
					
					$return .= '
					<div class="clear"></div>
					<div class="vertical-space"></div>
					';
				}else{
					$return .= rockthemes_display_posts_basic($atts, false);	
				}
				
				$total = $total - 1;
				
			endwhile; 
			endif; //Count Sticky
			
			wp_reset_postdata();
		}
		
		wp_reset_query();
		
		if ( get_query_var('paged') ) {
			$is_paged = get_query_var('paged');
		} else if ( get_query_var('page') ) {
			$is_paged = get_query_var('page');
		} else {
			$is_paged = 1;
		}
		
		$args = array(
			'posts_per_page' => esc_attr($total),
			'ignore_sticky_posts' => 1,
			'paged' => $is_paged,
			'category_name'	=>	esc_attr($category)
		);
		
		if($sticky_first === 'true'){
			$args['post__not_in'] = array($sticky);
		}
		
		$normal_query = query_posts($args);

		if(count($normal_query)){
			foreach($normal_query as $single_query):
				global $post;
				$post = $single_query;
				setup_postdata($post);
				$more = 0;
				
				if($regular_content === 'true'){
					ob_start();
					get_template_part( 'content', get_post_format() );
					$return .= ob_get_clean();
					
					$return .= '
					<div class="clear"></div>
					<div class="vertical-space"></div>
					';
				}else{
					$return .= rockthemes_display_posts_basic($atts, false);	
				}
				
			endforeach;	
			
		}

		
		if($pagination === 'true'){
			$return .= azoom_paging_nav(false);
		}
		
		wp_reset_postdata();
        wp_reset_query();
        
		return $return;
		
	}
}

add_shortcode("rockthemes_regular_blog", "rockthemes_shortcode_make_regular_blog");


if(!function_exists('rockthemes_display_posts_basic')):
/*
**	Displays the posts with the given details. This will not make any difference for
**	different post types. 
**
**	@global	:	$post	Object	Default post object
**	@param	:	$attr	[Array]	An array of displaying details
**	@param	:	$echo	Boolean	Echo the output or not
**
**	@return	:	Returns an HTML element of the current post
*/
function rockthemes_display_posts_basic($atts, $echo = false){
	global $post;
	if(!isset($post) || !$post)	return; //Return if no $post defined
	
	extract($atts);
		
	$image_col = (int) $image_col;
	$excerpt_length = (int) $excerpt_length;
	
	$return = '';
	
	$image = azoom_get_featured_image(false, $image_size, $hover_active === 'true' ? true : false);
	
	
	$content_col = 12 - $image_col;
	
	if($content_col === 0 ) $content_col = 12;
	
		
	$title = get_the_title();
	
	if($header_link === 'true'){
		$title = '<a href="'.get_permalink().'"	>'.$title.'</a>';
	}
	
	$sticky_html = '';
	
	$category_html = '';
	if($show_categories === 'true'){
		$categories_list = get_the_category_list( __( ', ', 'azoom' ) );
		if ( $categories_list ) {
			$category_html .= '<span class="categories-links">' . $categories_list . '</span>';
		}
	}

	$tags_html = '';
	if($show_tags === 'true'){
		// Translators: used between list items, there is a space after the comma.
		$tag_list = get_the_tag_list( '', __( ', ', 'azoom' ) );
		if ( $tag_list ) {
			$tags_html .= '<span class="tags-links">' . $tag_list . '</span>';
		}
	}
	
	$date_html = '';
	if($show_date === 'true'){
		$format_prefix = ( has_post_format( 'chat' ) || has_post_format( 'status' ) ) ? _x( '%1$s on %2$s', '1: post format name. 2: date', 'azoom' ): '%2$s';
	
		$date_html = sprintf( '<small class="date"><time class="entry-date" datetime="%1$s">%2$s</time></small>',
			esc_attr( get_the_date( 'c' ) ),
			esc_html( sprintf( $format_prefix, get_post_format_string( get_post_format() ), get_the_date() ) )
		);		
		
		$date_html .= '<br/><br/>';
	}

	
	if($category_html !== '' || $tags_html !== '' || $sticky_html !== '') $tags_html .= '<br/><br/>';
	
	$return .= '
	
		<div class="rockthemes-blog-basic">
			<div class="row">
	';
	
	if($image){
				$return .= '
				<div class="large-'.esc_attr($image_col).' columns">
					<div class="entry-thumbnail">
						'.$image.'
					</div>
				</div>
				<div class="large-'.esc_attr($content_col).' columns">
				';
	}else{
				$return .= '
				<div class="large-'.esc_attr($content_col).' columns">
				';
	}
	
	$return .= '
					<h3>'.$title.'</h3>
					'.$date_html.'
					'.$sticky_html.'
					'.$category_html.'
					'.$tags_html.'
					<div>
						'.rock_check_p((rockthemes_excerpt(get_the_excerpt(),$excerpt_length))).'
					</div>
				</div>
			</div>
			<div style="position:relative; display:block; width:100%; height:'.esc_attr($space_height).'"></div>
		</div>
	';
	
	if(!$echo) return $return;
	echo $return;
}
endif;
/*
**	End of Rockthemes Default Blog Shortcode
*/











/*
**	Achievement Element
*/
if(!function_exists('rockthemes_shortcode_make_achievement')){
	function rockthemes_shortcode_make_achievement($atts, $content = null){	
		extract( shortcode_atts( array(
			'number_color'		=>	'#787878',
			'text_color'		=>	'#787878',
			'icon_bg_color'		=>	'#56CCC8',
			'icon_color'		=>	'#ffffff',
			
			'detail_text'		=>	'',
			
			'icon_class'		=>	'',
			'icon_url'			=>	'',
			
			'mode'				=>	'static',
		
			'static_number'		=>	'',
			'function_php'		=>	'',
			'function_js'		=>	'',
			'external_url'		=>	'',
		), $atts ) );
		
		wp_enqueue_script('countup', AZOOM_PLUGIN_URI.'/js/countUp.min.js', array('jquery'), '1.0.0', true);
		
		if(isset($GLOBALS['rockthemes_achievement'])){
			$GLOBALS['rockthemes_achievement']++;
		}else{
			$GLOBALS['rockthemes_achievement'] = 0;
		}
		
		$use_icon = false;
		$use_url = false;
		$icon_html = '';
		$icon_url_html = '';
		
		if($icon_class != ""){
			$icon_html = '<i class="'.esc_attr($icon_class).' animate-icon animate-to-right"></i>';
			$use_icon = true;
		}
		
		if($icon_url != ""){
			$icon_html = '<img src="'.esc_url($icon_url).'" />';
			$use_icon = true;	
		}
		
		$id = 'rockthemes-achievement-'.esc_attr($GLOBALS['rockthemes_achievement']);
		
		$return = '';
		
		$number = $static_number;
		
		switch($mode){
			case 'function_php':
				$number = $function_php();
			break;
		}
		
		$return .= '<div id="'.esc_attr($id).'" class="rock-achievement left-text '.($icon_html !== '' ? 'icon-active' : '').'" '.($mode === 'function_js' ? 'data-function_js="'.esc_attr($function_js).'" ' : '').' '.($mode === 'function_ajax' ? 'data-function_ajax="'.esc_attr($function_php).'" ' : '').' data-mode="'.esc_attr($mode).'" data-value="'.esc_attr($number).'" style="color:'.esc_attr($number_color).';">';
		
			if($icon_html){
				$return .= '<div class="achievement-icon" style="background:'.esc_attr($icon_bg_color).'; color:'.esc_attr($icon_color).';">'.$icon_html.'</div>';
			}
		
			$return .= '
			<div class="achievement-content">
				<div id="'.esc_attr($id).'_number" class="achievement-number">0</div>
				<p style="color:'.esc_attr($text_color).';">'.$detail_text.'</p>
			</div>
			<div class="clear"></div>
			';
		
		$return .= '</div>';

		return $return;
	}
}

add_shortcode("rockthemes_achievement", "rockthemes_shortcode_make_achievement");

if(!function_exists('rockthemes_achievement_ajax')):
function rockthemes_achievement_ajax(){
	if(!isset($_POST['data'])) die();
	if(!isset($_REQUEST['_ajax_nonce']) ||
		empty($_REQUEST['_ajax_nonce']) || 
		!wp_verify_nonce($_REQUEST['_ajax_nonce'], 'rockthemes_achievement_nonce') ||
		!check_ajax_referer('rockthemes_achievement_nonce')) {
			
		//Die
		die('ERROR');
	}
	
	if(!isset($_POST['data']['function_name'])){
		die('ERROR');	
	}
	
	$fn = 'rockthemes_achievement_ajax_'.esc_attr($_POST['data']['function_name']);
	if(function_exists($fn)){
		$num = (int) $fn();
	}else{
		$num = 0;	
	}
	wp_send_json(array('number' => $num));
	exit;	
}
endif;
add_action('wp_ajax_nopriv_rockthemes_achievement_ajax', 'rockthemes_achievement_ajax');
add_action('wp_ajax_rockthemes_achievement_ajax', 'rockthemes_achievement_ajax');

/*
**	End of Achievement Element
*/





/*
**	Heading Element
*/
if(!function_exists('rockthemes_shortcode_make_heading')){
	function rockthemes_shortcode_make_heading($atts, $content = null){	
		extract( shortcode_atts( array(
			'bold_color'		=>	'#787878',
			'regular_color'		=>	'#787878',
			'details_color'	=>	'',
			
			'bold_text'			=>	'',
			'light_text'		=>	'',
			'details_text'		=>	'',
			
			'heading_font_size'	=>	'54px',
			'html_tag'			=>	'',
			'align'				=>	'left',
			'use_icon'			=>	'yes',
			
			'disable_margin'	=>	'no',
			'border_bottom'		=>	'yes',
		), $atts ) );
		
		
		
		$light = $light_text !== '' ? '<span style="font-weight:100; color:'.esc_attr($regular_color).';">'.$light_text.'</span>' : '';
		$details = $details_text !== '' ? '<p class="azoom-heading-details" style="color:'.esc_attr($details_color).'; '.($use_icon === 'yes' ? 'margin-left:20px' : '').'">'.$details_text.'</p>' : '';
		$border_bottom_details = $border_bottom === 'yes' ? '<div class="heading-bottom-line" style="background:'.esc_attr($regular_color).';"></div><div class="heading-bottom-line-end" style="background:'.esc_attr($regular_color).';"></div>' : '';

		$icon = $use_icon === 'yes' ? '<div class="azoom-heading-icon" style="background:'.esc_attr($regular_color).';"></div>' : '';
		
		$heading_class = '';
		switch($align){
			case 'center':
			$heading_class = 'centered-heading';
			break;
			
			case 'right':
			$heading_class = 'right-heading';
			break;
			
			case 'left':
			$heading_class = 'left-heading';
			break;	
		}
		
		$return = '
			<div class="azoom-heading-wrapper '.($use_icon === 'yes' ? 'icon-enabled' : '').' '.$heading_class.' '.($disable_margin === 'yes' ? 'no-margin-bottom' : '').'" style="text-align:'.esc_attr($align).';">
				<div class="azoom-heading-inline">
					'.$icon.'
					'.(($light_text !== '' || $bold_text !== '') ? '<'.$html_tag.' class="azoom-heading" style="color:'.esc_attr($bold_color).'; font-size:'.($heading_font_size !== '' ? $heading_font_size : '54px').'; '.($use_icon === 'yes' ? 'margin-left:20px' : '').'">'.$bold_text.(($bold_text !== '' && $light !== '') ? ' ' : '').$light.'</'.$html_tag.'>' : '').'
					'.$border_bottom_details.'
					'.$details.'
				</div>
			</div>
		';


		return $return;
	}
}

add_shortcode("rockthemes_heading", "rockthemes_shortcode_make_heading");
/*
**	End of Heading Element
*/











if(!function_exists('rockthemes_shortcode_make_like')):
	function rockthemes_shortcode_make_like($atts=array(), $content=null){
		extract( shortcode_atts( array(
			'id'		=>	'',
		), $atts ) );	
		
		if(empty($id)) return;

		$return = '
		<div class="entry-love-container azoom-love-icon azoom-transition" data-post-id="'.esc_attr($id).'">
			<a href="#" class="disable-link escapea"><i class="icomoon icomoon-icon-heart"></i></a>
			<span>'.azoom_get_love_num().'</span>
		</div>';
		
		return $return;
	}
endif;
add_shortcode('rockthemes_like', 'rockthemes_shortcode_make_like');




/*
**	Steps Element Shortcode
*/

if(!function_exists('rockthemes_shortcode_make_steps')){
	function rockthemes_shortcode_make_steps($atts, $content = null){
		extract( shortcode_atts( array(
			'steps_mode'		=>	'jump',
			'start_steps'		=>	'first',
			'steps_bg_color'	=>	'#787878',
			'min_width'			=>	'1140px',
			'margin_top'		=>	'160px',
			'margin_bottom'		=>	'190px',
		), $atts ) );	


		$GLOBALS['rockthemes_steps_num'] = 0;
		$steps = do_shortcode($content);
				
		
		$style = 'style="';
		
		if($margin_top !== ''){
			$style .= 'margin-top:'.esc_attr($margin_top).'; ';	
		}
		if($margin_bottom !== ''){
			$style .= 'margin-bottom:'.esc_attr($margin_bottom).'; ';	
		}
		
		$style .= '"';
		
		$return = '
		<div class="azoom-steps-wrapper">
			<div class="azoom-steps '.esc_attr($steps_mode).'-steps azoom-transition" data-start_steps="'.esc_attr($start_steps).'" data-min-width="'.esc_attr(str_replace('px', '', $min_width)).'" '.$style.'>
				<ul class="large-block-grid-'.esc_attr($GLOBALS['rockthemes_steps_num']).' medium-block-grid-'.esc_attr($GLOBALS['rockthemes_steps_num']).' small-block-grid-'.esc_attr($GLOBALS['rockthemes_steps_num']).'" 
							style="background:'.esc_attr($steps_bg_color).'; color:'.esc_attr($steps_bg_color).';">
		';
		
		$return .= $steps;
		
		$return .= '</ul></div></div>';
		
		return $return;
	}
	
}

add_shortcode("rockthemes_steps", "rockthemes_shortcode_make_steps");


if(!function_exists('rockthemes_shortcode_make_step_single')){
	function rockthemes_shortcode_make_step_single($atts, $content = null){	
		extract( shortcode_atts( array(
			'step_title'			=>	'',
			'step_color'			=>	'#787878',
		), $atts ) );
		
		$GLOBALS['rockthemes_steps_num']++;
		
		
		
		$return = '
			<li data-step-color="'.$step_color.'">
				<div class="step-nav">
					<i class="icomoon icomoon-icon-previous11 step-back"></i>
					<i class="icomoon icomoon-icon-next15 step-next"></i>
				</div>
				<div class="step-icon steps-noselect">
					<span class="number">'.esc_attr($GLOBALS['rockthemes_steps_num']).'</span>
					<span class="check">
						<i class="icomoon icomoon-icon-checkmark"></i>
					</span>
				</div>
				<div class="step-details-line"></div>
				<div class="step-details">
					<h3>'.esc_attr($step_title).'</h3>
					<p>'.esc_attr($content).'</p>
				</div>
			</li>
		';

		
		return $return;
	}
}

add_shortcode("rockthemes_step_single", "rockthemes_shortcode_make_step_single");

/*
**	End of Steps Element
*/







?>