<?php
/*
Plugin Name: Additional Post Types
Plugin URI:  http://curvyslider.com
Description: Add Default Items and Default Gallery Post types
Version:     1.0
Author:      Rockthemes
Author URI:  http://themeforest.net/user/XanderRock?ref=XanderRock
*/


if(!function_exists('azoom_register_defaultitems')):
/*
**	Azoom Custom Post Type Default Items
**	We use custom post type for default items. This function will register the custom post type and it's taxonomy
**
**	@return	:	Void
*/
function azoom_register_defaultitems(){
	
	if(!function_exists('xr_get_option')) return;
	
	//Return if Default Products Disabled
	if(xr_get_option('disable_default_items', false)) return;
		
	$labels = array(
		'name'               => 'Default Items',
		'singular_name'      => 'Default Item',
		'menu_name'          => 'Default Items',
		'name_admin_bar'     => 'Default Item',
		'add_new'            => 'Add New Item',
		'add_new_item'       => 'Add New Item',
		'new_item'           => 'New Default Item',
		'edit_item'          => 'Edit Default Item',
		'view_item'          => 'View Default Item',
		'all_items'          => 'All Default Items',
		'search_items'       => 'Search Default Items',
		'parent_item_colon'  => 'Parent Default Items:',
		'not_found'          => 'No Default Items found.',
		'not_found_in_trash' => 'No Default Items found in Trash.',
	);
	
	register_post_type('defaultitems', array(
		'labels' => $labels,
		'public' => true,
		'show_ui' => true,
		'capability_type' => 'page',
		'publicly_queryable' 	=> true,
		'exclude_from_search' 	=> false,
		'hierarchical' => false,
		'rewrite' => array(
			'slug' => sanitize_text_field(xr_get_option('slug_default_item', 'defaultitems')),
			'with_front' => false,
		  ),
		'query_var' => true,
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'comments', 'custom-fields', 'page-attributes' ),
		'show_in_nav_menus' 	=> true
	));
	register_taxonomy("defaultitem_cat",
					 array("defaultitems"), 
					 array("hierarchical" => true,
					 		"label" => __("Item Categories", "azoom"),
							"singular_label" => "Category",
							"rewrite" => array(
								"slug" => sanitize_text_field(xr_get_option("slug_default_item_category", "defaultitem_cat_slug")),
								"with_front"=>false
							)
					)
	);
}
endif;
add_action('init', 'azoom_register_defaultitems');





if(!function_exists('azoom_register_gallery')):
/*
**	Azoom Custom Post Type Gallery
**	We use custom post type for gallery. This function will register the custom post type and it's taxonomy
**
**	@return	:	Void
*/
function azoom_register_gallery(){
	
	if(!function_exists('xr_get_option')) return;
	
	if(xr_get_option('disable_default_gallery',false)) return;
		
	$labels = array(
		'name'               => 'Default Gallery',
		'singular_name'      => 'Default Gallery',
		'menu_name'          => 'Default Gallery',
		'name_admin_bar'     => 'Default Gallery',
		'add_new'            => 'Add New',
		'add_new_item'       => 'Add New Default Gallery',
		'new_item'           => 'New Gallery Image',
		'edit_item'          => 'Edit Gallery Image',
		'view_item'          => 'View Gallery Image',
		'all_items'          => 'Default Gallery',
		'search_items'       => 'Search Default Gallery',
		'parent_item_colon'  => 'Parent Default Gallery:',
		'not_found'          => 'No Default Gallery found.',
		'not_found_in_trash' => 'No Default Gallery found in Trash.',
	);

	register_post_type('defaultgallery', array(
		'labels' => $labels,
		'public' => true,
		'show_ui' => true,
		'capability_type' => 'page',
		'publicly_queryable' 	=> true,
		'exclude_from_search' 	=> false,
		'hierarchical' => false,
		'rewrite' => array(
			'slug' => sanitize_text_field(xr_get_option('default_gallery_slug', 'gallery-item')),
			'with_front' => false,
		  ),
		'query_var' => true,
		'supports' => array('title', 'excerpt', 'thumbnail'),
		'show_in_nav_menus' 	=> true
	));
	register_taxonomy("defaultgallery_cat",
					 array("defaultgallery"), 
					 array("hierarchical" => true,
					 		"label" => __("Default Gallery Categories", "azoom"),
							"singular_label" => "Category",
							"rewrite" => array(
								"slug" => sanitize_text_field(xr_get_option("default_gallery_category_slug", "gallery-category")),
								"with_front"=>false
							)));
}
endif;
add_action('init', 'azoom_register_gallery');


?>