<?php
add_shortcode( 'automatic_blog', 'automatic_tp_blog' );
function automatic_tp_blog( $atts ){
    extract( shortcode_atts(
        array(
			'title' => '',
            'layout_blog'=>'list',
            'items_show' => -1,
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();

    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'automatic_blog', $atts );
    $el_class = automatic_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    /*Query*/
    $paged   = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
    $args_post = array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'paged'          => $paged,
        'posts_per_page' => $items_show,
    );
    $rquery_post = New Wp_Query( $args_post );
    ?>
    <div class="automatic-blog<?php echo $el_class; ?>">
        <div class="automatic-recent-posts">
            <?php
            if ( $title != '' ) :
							 
                ?>
                <div class="shortcode-title wpb_bottom-to-top">
                    <h2><?php echo esc_attr( $title );?></h2>
                </div>
                <?php
            endif;
            /*Blog latest news*/
            if ( $rquery_post->have_posts() ) :
                if ( $layout_blog == 'slide' ) :
                    ?>
                    <div class="automatic-widget automatic-widget-blog initSlide_product" data-columns="1">
                        <div class="beans-stepslider" data-rotate="true">
                            <div class="beans-mask">
                                <div class="beans-slideset">
                                    <?php
                                    while ( $rquery_post->have_posts() ) : $rquery_post->the_post();
                                        ?>
                                        <div class="beans-slide">
                                            <?php if ( has_post_thumbnail() ) : ?>
                                               <?php the_post_thumbnail();?>
                                            <?php endif; ?>
                                            <div class="txt">
                                                <a class="" href="<?php the_permalink(); ?>">
                                                    <?php the_title(); ?>
                                                </a>
                                                <?php echo content(16);?>
                                                <div class="automatic-date">
                                                    <span class="item-time left"><?php echo get_the_time( 'F d Y',get_the_ID() ); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                    endwhile;
                                    ?>
                                </div>
                            </div>
                            <div class="beans-pagination"></div>
                        </div>
                    </div>
                    <?php
                    wp_reset_postdata();
                endif;

                if ( $layout_blog == 'list' ) :
                     while ( $rquery_post->have_posts() ) : $rquery_post->the_post();
                        ?>
                        <div class="blog-default">
                            <?php if ( has_post_thumbnail() ) : ?>
                               <?php the_post_thumbnail();?>
                            <?php endif; ?>
                            <div class="txt">
                                <a class="" href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                                <?php echo content(16);?>
                                <div class="automatic-date">
                                    <span class="item-time left"><?php echo get_the_time( 'F d Y',get_the_ID() ); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php
                    endwhile;
                    ?>
                    <div class="text-center">
                        <?php
                        custom_pagination($rquery_post->max_num_pages,"",$paged);
                        ?>
                    </div>
                <?php
                endif;
                wp_reset_postdata();
            endif;
            ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
?>