<?php
/**
* Shortcode Product
*/
add_shortcode( 'automatic_product', 'automatic_template_product' );
function automatic_template_product( $atts ){
    extract( shortcode_atts(
        array(
            'title' =>'',
            'type_product' => 'new-product',
            'type_layout' => 'default',
            'style'=>'default',
            'items_show' => -1,
            'cat_product' => '',
            'column' => '1',
            'rows_index' => '1',
            'show_nav' => '',
            'show_navbt' => '',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();
	
	if (!class_exists('Woocommerce')) {
		return;
	}
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'automatic_product', $atts );
    $el_class = automatic_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    $cl_class = '';
    $column_index = 3;
    $padding_col = 'padding-35';
    switch ( $column ) {
        case '1':
            $column_index = 1;
            $cl_class = 'col-xs-12 col-sm-12 col-md-12';
            $padding_col = 'padding-35';
            break;
        case '2':
            $column_index = 2;
            $cl_class = 'col-xs-12 col-sm-6 col-md-6';
            $padding_col = 'padding-35';
            break;
        case '3':
            $column_index = 3;
            $cl_class = 'col-xs-12 col-sm-4 col-md-4';
            $padding_col = 'padding-35';
            break;
        case '4':
            $column_index = 4;
            $cl_class = 'col-xs-12 col-sm-6 col-md-3';
            $padding_col = 'padding-35';
            break;
        case '5':
            $column_index = 5;
            $cl_class = 'col-xs-12 col-sm-15 col-md-15';
            $padding_col = 'padding-15';
            break;

        default:
            $cl_class = '';
            break;
    }
    $show_nav_cl = '';
    if ( $show_nav == 'enable_show_nav' ){
			$show_nav_cl .= 'show_nav ';
    }
    if ( $show_navbt == 'enable_show_navbt' ){
			$show_nav_cl .= 'show_navbt';
    } 
    ?>
    <div class="automatic-product <?php echo $el_class.' '.$show_nav_cl; ?>">
        <?php
        if ( $title != '' ) :
            ?>
           <div class="shortcode-title wpb_bottom-to-top">
                <h2><?php echo esc_attr( $title );?></h2>
            </div>
            <?php
        endif;
        if ( $type_product == 'new-product') {
			if ( $cat_product == '' ){
				$args = array(
					'post_type' => 'product',
					'post_status' => 'publish',
					'posts_per_page' => $items_show,
				);
			}else{
				$term_id = get_term_by('slug', $cat_product, 'product_cat');
				$term_id = $term_id  -> term_id;
				$automatic_term_childs = get_term_children($term_id,'product_cat');
				$automatic_term_childs[] = $term_id;
				$args = array(
					'post_type' => 'product',
					'post_status' => 'publish',
					'posts_per_page' => $items_show,
					'tax_query' => array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'product_cat',
							'field'    => 'term_id',
							'terms'    => $automatic_term_childs,
						),
					),
				);
			}
        }elseif ($type_product == 'gift-card-product') {
			if ( $cat_product == '' ){
				$args = array(
					'post_type' => 'product',
					'post_status' => 'publish',
					'posts_per_page' => $items_show,
					'tax_query' => array(
							array(
								'taxonomy' => 'product_type',
								'field'    => 'slug',
								'terms'    => 'gift-card', 
							),
					),
				);
			}else{
				$term_id = get_term_by('slug', $cat_product, 'product_cat');
				$term_id = $term_id  -> term_id;
				$automatic_term_childs = get_term_children($term_id,'product_cat');
				$automatic_term_childs[] = $term_id;
				$args = array(
					'post_type' => 'product',
					'post_status' => 'publish',
					'posts_per_page' => $items_show,
					'tax_query' => array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'product_cat',
							'field'    => 'term_id',
							'terms'    => $automatic_term_childs,
						),
						array(
							'taxonomy' => 'product_type',
							'field'    => 'slug',
							'terms'    => 'gift-card', 
						),
					),
				);
			}
        }elseif ( $type_product == 'feature-product' ) {
			if ( $cat_product == '' ) :
				$args = array(
					'post_type' => 'product',
					'post_status' => 'publish',
					'posts_per_page' => $items_show,
					'tax_query' => array(
						array(
							'taxonomy' => 'product_visibility',
							'field'    => 'slug',
							'terms'    => 'featured'
						)
					), 
				);
			else :
					$term_id = get_term_by('slug', $cat_product, 'product_cat');
					$term_id = $term_id  -> term_id;
					$automatic_term_childs = get_term_children($term_id,'product_cat');
					$automatic_term_childs[] = $term_id;
					$args = array(
							'post_type' => 'product',
							'post_status' => 'publish',
							'posts_per_page' => $items_show, 
							'tax_query' => array(
								'relation' => 'AND',
								array(
									'taxonomy' => 'product_cat',
									'field'    => 'term_id',
									'terms'    => $automatic_term_childs,
								),
								array(
									'taxonomy' => 'product_visibility',
									'field'    => 'slug',
									'terms'    => 'featured'
								)
							), 
					);
			endif;
        }elseif ( $type_product == 'sale-product' ){
            if ( $cat_product == '' ) :
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                    'meta_query'     => array(
                        'relation' => 'OR',
                        array( // Simple products type
                            'key'           => '_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                        array( // Variable products type
                            'key'           => '_min_variation_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        )
                    )
                );
            else :
                $term_id = get_term_by('slug', $cat_product, 'product_cat');
                $term_id = $term_id  -> term_id;
                $automatic_term_childs = get_term_children($term_id,'product_cat');
                $automatic_term_childs[] = $term_id;
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                    'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'term_id',
                            'terms'    => $automatic_term_childs,
                        ),
                    ),
                    'meta_query'     => array(
                        'relation' => 'OR',
                        array( // Simple products type
                            'key'           => '_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                        array( // Variable products type
                            'key'           => '_min_variation_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        )
                    )
                );
            endif;
        }else{
            $args = '';
        };
        $rquery = new Wp_Query($args);
        if ( $type_product == 'new-product' || $type_product == 'feature-product' || $type_product == 'sale-product'|| $type_product == 'gift-card-product' ){
            if ( $type_layout == 'default' ){
                if ( $style == 'default' ){
                    ?>
                    <div class="slide-product initSlide_product" data-columns="<?php echo $column_index; ?>">
						<div class="beans-stepslider" data-rotate="true">
							<div class="beans-mask">
								<div class="beans-slideset">
									<?php
									
									if ( $rquery -> have_posts() ) :
										while ( $rquery -> have_posts() ) : $rquery -> the_post();
										?>
											<div class="beans-slide <?php echo get_the_ID(); ?>">
												<div class="<?php echo esc_attr( $padding_col );?>">
													<div class="border-hover">
														<ul>
															<?php au_content_product(); ?>
														</ul>
													</div>
												</div>
											</div>
										<?php
										endwhile;
										wp_reset_postdata();
									endif;
									?>
								</div>
							</div>
							<div class="beans-pagination"></div>
							<a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
							<a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
						</div>
                    </div>
                    <?php
                }elseif ( $style == 'style-1' ){ ?>
                    <div class="slide-product style-1 initSlide_product" data-columns="<?php echo $column_index; ?>">
                        <div class="beans-stepslider" data-rotate="true">
                            <div class="beans-mask">
                                <div class="beans-slideset">
                                    <?php
                                    if ( $rquery -> have_posts() ) :
                                        while ( $rquery -> have_posts() ) : $rquery -> the_post();
                                            global $product;
											automatic_product_rate($product); 
											$average = $product->get_average_rating();
                                            ?>
                                            <div class="beans-slide">
                                                <div class="padding-10">
                                                    <ul>
                                                        <li <?php post_class(); ?>>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <?php
                                                                    $attachment_ids = $product->get_gallery_image_ids();
                                                                    if ( $attachment_ids ) {
                                                                        ?>
                                                                        <div class="product-thumbnails">
                                                                            <div class="flexslider">
                                                                                <ul class="slides">
                                                                                    <?php
                                                                                    $i=0;
                                                                                    foreach ( $attachment_ids as $attachment_id ) {
                                                                                        $i++;
                                                                                        $images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product' );
                                                                                        ?>
                                                                                        <li>
                                                                                            <img src="<?php echo $images[0]; ?>" alt="image-product">
                                                                                        </li>
                                                                                        <?php
                                                                                    }
                                                                                    ?>
                                                                                </ul>
                                                                            </div>
                                                                        </div>
                                                                        <?php
                                                                    }else{
                                                                        ?>
                                                                        <div class="product-thumbnails">
                                                                            <?php
                                                                                the_post_thumbnail( 'automatic-image-product' );
                                                                            ?>
                                                                        </div>
                                                                        <?php
                                                                    }
                                                                    $price = get_post_meta( get_the_ID() , '_regular_price', true);
                                                                    $sale = get_post_meta( get_the_ID() , '_sale_price', true);
                                                                    if ( $sale != '' && $price != '') :
                                                                        $discount = number_format( 100 - ($sale*100)/$price ,0,",","");
                                                                        ?>
                                                                        <div class="info-alert"><span class="automatic-title">-<?php echo $discount;?>%</span></div>
                                                                    <?php
                                                                    elseif ( $product->is_featured() ) :
                                                                        echo '<div class="info-alert"><span class="automatic-title">'.esc_html__('Hot','automatic_sc').'</span></div>';
                                                                    endif;
                                                                    ?>
                                                                </div>
                                                                <div class="col-md-8">
                                                                    <div class="ct-product-right">
                                                                        <?php 
                                                                        if ( $average != 0 ){
                                                                            echo '<div class="product-title-has-rate">';
                                                                            ?>
                                                                            <a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
                                                                            <span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>"><i class="automaticicon-rate"></i><?php echo esc_html($average); ?></span>
                                                                            <?php
                                                                            echo '</div>';
                                                                        }else{
                                                                            ?>
                                                                            <a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
                                                                            <?php
                                                                        }
                                                                        ?>
                                                                        <div class="format-price-addcart">
                                                                            <div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <?php
                                        endwhile;
                                        wp_reset_postdata();
                                    endif;
                                    ?>
                                </div>
                            </div>
                            <div class="beans-pagination"></div>
                            <a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                            <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
                        </div>
                    </div>
                    <?php
                }
            }elseif ( $type_layout == 'layout-1' ){ ?>
				<ul class="product-rating-list">
				<?php
					if ( $rquery -> have_posts() ) :
						while ( $rquery -> have_posts() ) : $rquery -> the_post();
							global $product;
							$average = $product->get_average_rating();
							$automatic_rate_ave = automatic_product_rate($product);
						?>
						<li <?php post_class(); ?>>
							<div class="row">
								<div class="col-md-4">
									<?php
									$attachment_ids = $product->get_gallery_image_ids();
									if ( $attachment_ids ) {
										?>
										<div class="product-thumbnails">
											<div class="flexslider">
												<ul class="slides">
													<?php
													$i=0;
													foreach ( $attachment_ids as $attachment_id ) {
														$i++;
														$images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product' );
														?>
														<li>
															<img src="<?php echo $images[0]; ?>" alt="image-product">
														</li>
														<?php
														}
													?>
												</ul>
											</div>
										</div>
										<?php
									}else{
										?>
										<div class="product-thumbnails">
											<?php
												the_post_thumbnail( 'automatic-image-product' );
											?>
										</div>
										<?php
									}
									$price = get_post_meta( get_the_ID() , '_regular_price', true);
									$sale = get_post_meta( get_the_ID() , '_sale_price', true);
									if ( $sale != '' && $price != '') :
										$discount = number_format( 100 - ($sale*100)/$price ,0,",","");
											?>
										<div class="info-alert"><span class="automatic-title">-<?php echo $discount;?>%</span></div>
									<?php
									elseif ( $product->is_featured() ) :
										echo '<div class="info-alert"><span class="automatic-title">'.esc_html__('Hot','automatic').'</span></div>';
									endif;
									?>
								</div>
								<div class="col-md-8">
									<div class="ct-product-right">
										<?php
										$average = $product->get_average_rating();
										if ( $average != 0 ){
											echo '<div class="product-title-has-rate">';
											?>
													<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
													<span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>">
															<i class="automaticicon-rate"></i><?php echo esc_html($average); ?>
													</span>
											<?php
											echo '</div>';
										}else{
											?>
											<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
											<?php
										}
										?>
										<div class="format-price-addcart">
											<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
										</div>
									</div>
								</div>
							</div>
						</li>
						<?php
						endwhile;
						wp_reset_postdata();
					endif;
				?>
				</ul>
				<?php
            }
        }elseif ( $type_product == 'top-rated-product' ){
			$query_args = array(
				'posts_per_page' => $items_show,
				'no_found_rows' => 1,
				'post_status' => 'publish',
				'post_type' => 'product',
				'meta_key'       => '_wc_average_rating',
				'orderby'        => 'meta_value_num',
				'order'          => 'DESC',
				'meta_query'     => WC()->query->get_meta_query(),
				'tax_query'      => WC()->query->get_tax_query(),
			);
			$r = new WP_Query( $query_args );
			if ( $r->have_posts() ) {
				if ( $type_layout == 'default' ){
					?>
					<div class="slide-product initSlide_product" data-columns="<?php echo $column_index; ?>">
						<div class="beans-stepslider" data-rotate="true">
							<div class="beans-mask">
								<div class="beans-slideset">
									<?php
										while ( $r->have_posts() ) {
										$r->the_post();
										?>
										<div class="beans-slide">
											<div class="<?php echo esc_attr( $padding_col );?>">
												<div class="border-hover">
													<ul>
													<?php au_content_product(); ?>
													</ul>
												</div>
											</div>
										</div>
									<?php
										}
									wp_reset_postdata();
									?>
								</div>
							</div>
							<div class="beans-pagination"></div>
							<a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
							<a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
						</div>
					</div>
				<?php
				}elseif ( $type_layout == 'layout-1' ){
					?>
					<ul class="product-rating-list">
						<?php
						while ( $r->have_posts() ) {
							$r->the_post();
							global $product;
							$automatic_rate_ave = automatic_product_rate($product);
							?>
							<li <?php post_class(); ?>>
								<div class="row">
									<div class="col-md-4">
										<?php
										$attachment_ids = $product->get_gallery_image_ids();
										if ( $attachment_ids ) {
											?>
											<div class="product-thumbnails">
												<div class="flexslider">
													<ul class="slides">
														<?php
														$i=0;
														foreach ( $attachment_ids as $attachment_id ) {
															$i++;
															$images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product' );
															?>
															<li><img src="<?php echo $images[0]; ?>" alt="image-product"></li>
															<?php
														}
														?>
													</ul>
												</div>
											</div>
											<?php
										}else{
											?>
											<div class="product-thumbnails">
												<?php
													the_post_thumbnail( 'automatic-image-product' );
												?>
											</div>
											<?php
										}
										$price = get_post_meta( get_the_ID() , '_regular_price', true);
										$sale = get_post_meta( get_the_ID() , '_sale_price', true);
										if ( $sale != '' && $price != '') :
												$discount = number_format( 100 - ($sale*100)/$price ,0,",","");
												?>
												<div class="info-alert"><span class="automatic-title">-<?php echo $discount;?>%</span></div>
										<?php
										elseif ( $product->is_featured() ) :
												echo '<div class="info-alert"><span class="automatic-title">'.esc_html__('Hot','automatic_sc').'</span></div>';
										endif;
										?>
									</div>
									<div class="col-md-8">
										<div class="ct-product-right">
											<?php
											$average = $product->get_average_rating();
											if ( $average != 0 ){
												echo '<div class="product-title-has-rate">';
												?>
												<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
												<span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>">
													<i class="automaticicon-rate"></i><?php echo esc_html($average); ?>
												</span>
												<?php
												echo '</div>';
											}else{
												?>
												<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
												<?php
											}
											?>
											<div class="format-price-addcart">
												<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
											</div>
										</div>
									</div>
								</div>
							</li>
							<?php
						}
						wp_reset_postdata();
						?>
					</ul>
					<?php
				}
			}
        }elseif ( $type_product == 'bestselling-product' ){
            if(class_exists('WC_Bestseller')){
                $WC_Bestseller= new WC_Bestseller();
                $args_id = $WC_Bestseller->list_product_bestseller();
                if(count($args_id)>0){
                    $arg_bestseller = array();
                    foreach ( $args_id as $value ){
                        $arg_bestseller[]= $value->product_id;
                    }
                    if($cat_product ==''){
                             $args = array(
                            'post_type' => 'product',
                            'post__in' => $arg_bestseller,
                            'posts_per_page' => $items_show
                        );
                    }else{
                        $term_id = get_term_by('slug', $cat_product, 'product_cat');
                        $term_id = $term_id  -> term_id;
                        $automatic_term_childs = get_term_children($term_id,'product_cat');
                        $automatic_term_childs[] = $term_id;
                        $args = array(
                            'post_type' => 'product',
                            'post__in' => $arg_bestseller,
                            'posts_per_page' => $items_show,
                            'tax_query' => array(
                                array(
                                    'taxonomy' => 'product_cat',
                                    'field'    => 'term_id',
                                    'terms'    => $automatic_term_childs,
                                ),
                            ),
                        );
                    }
                    if ( $style == 'default' ){
                        ?>
                        <div class="slide-product initSlide_product" data-columns="<?php echo $column_index;?>">
                            <div class="beans-stepslider" data-rotate="true">
                                <div class="beans-mask">
                                    <div class="beans-slideset">
                                    <?php
                                    $the_query = new WP_Query($args);
                                     while ( $the_query->have_posts() ) {
                                        $the_query->the_post();
                                        $id_post = get_the_ID();
                                            $_pf = new WC_Product_Factory();
                                            $_product = $_pf->get_product( $id_post );
                                            ?>
                                            <div class="beans-slide">
                                                <div class="<?php echo esc_attr( $padding_col );?>">
                                                    <div class="border-hover">
                                                        <div class="product type-product">
                                                            <div class="item-product">
                                                                <div class="product-img">
                                                                    <a href="<?php echo get_the_permalink($id_post);?>" itemprop="image" title="<?php echo get_the_title( $id_post); ?>"><?php echo get_the_post_thumbnail( $id_post,'automatic-slide-product'); ?></a>
                                                                </div>
                                                                <h3><a href="<?php echo get_the_permalink( $id_post); ?>"><?php echo get_the_title( $id_post); ?></a></h3>
                                                                <?php
                                                                $terms = get_the_terms( $id_post, 'product_cat' );
                                                                if(is_array($terms)){
                                                                    echo '<ul class="terms-product">';
                                                                    foreach ($terms as $term) {
                                                                        $term_link = get_term_link( $term );
                                                                        echo '<li><a href="' . esc_url( $term_link ) .'" title="'.$term->name.'">'.esc_attr( $term->name ).'</a></li>';
                                                                    }
                                                                    echo '</ul>';
                                                                }
                                                                ?>
                                                                <div class="format-price-addcart">
                                                                    <div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
                                                                    <div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
                                                                </div>
                                                                <div class="share-yith">
                                                                    <?php
                                                                    if(class_exists( 'YITH_WOOCOMPARE' ) ) {
                                                                        echo '<div class="btn-share btn-compare">';
                                                                            printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="fa fa-retweet" aria-hidden="true"></i>'.esc_html__('Compare', 'automatic_sc').'</a></div>', automatic_add_compare_action($id_post), 'add_to_compare compare button', $id_post, esc_html__('Compare', 'automatic_sc'));
                                                                        echo '</div>';
                                                                    }
                                                                    if (class_exists('YITH_WCWL')) {
                                                                        echo ' <div class="btn-share btn-wishlist">';
                                                                            echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                                                            echo '<span class="wishlist-count"> &#40;'. YITH_WCWL()->count_products() .'&#41;</span>';
                                                                        echo '</div>';
                                                                    }
                                                                    ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                    <?php
                                    }
                                     wp_reset_postdata();
                                    ?>
                                    </div>
                                </div>
                                <div class="beans-pagination">
                                    <!-- pagination generated here -->
                                </div>
                                <a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                                <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
                            </div>
                        </div>
                        <?php
                    }elseif ( $style == 'style-1' ){
                        ?>
                        <div class="slide-product style-1 initSlide_product" data-columns="<?php echo $column_index; ?>">
                            <div class="beans-stepslider" data-rotate="true">
                                <div class="beans-mask">
                                    <div class="beans-slideset">
                                        <?php
                                        $the_query = new WP_Query($args);
                                        while ( $the_query->have_posts() ) {
                                            $the_query->the_post();
                                            $id_post = get_the_ID();
                                            $_pf = new WC_Product_Factory();
                                            $_product = $_pf->get_product( $id_post ); 
											$automatic_rate_ave = automatic_product_rate($_product);
                                                ?>
                                                <div class="beans-slide">
                                                    <div class="padding-10">
                                                        <ul>
                                                            <li <?php post_class(); ?>>
                                                                <div class="row">
                                                                    <div class="col-md-4">
                                                                        <?php
                                                                        $attachment_ids = $_product->get_gallery_image_ids();
                                                                        if ( $attachment_ids ) {
                                                                            ?>
                                                                            <div class="product-thumbnails">
                                                                                <div class="flexslider">
                                                                                    <ul class="slides">
                                                                                        <?php
                                                                                        $i=0;
                                                                                        foreach ( $attachment_ids as $attachment_id ) {
                                                                                            $i++;
                                                                                            $images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product' );
                                                                                            ?>
                                                                                            <li>
                                                                                                <img src="<?php echo $images[0]; ?>" alt="image-product">
                                                                                            </li>
                                                                                            <?php
                                                                                        }
                                                                                        ?>
                                                                                    </ul>
                                                                                </div>
                                                                            </div>
                                                                            <?php
                                                                        }else{
                                                                            ?>
                                                                            <div class="product-thumbnails">
                                                                                <?php
                                                                                    the_post_thumbnail( 'automatic-image-product' );
                                                                                ?>
                                                                            </div>
                                                                            <?php
                                                                        }
                                                                        $price = get_post_meta( get_the_ID() , '_regular_price', true);
                                                                        $sale = get_post_meta( get_the_ID() , '_sale_price', true);
                                                                        if ( $sale != '' && $price != '') :
                                                                            $discount = number_format( 100 - ($sale*100)/$price ,0,",","");
                                                                            ?>
                                                                            <div class="info-alert"><span class="automatic-title">-<?php echo $discount;?>%</span></div>
                                                                        <?php
                                                                        elseif ( $_product->is_featured() ) :
                                                                            echo '<div class="info-alert"><span class="automatic-title">'.esc_html__('Hot','automatic_sc').'</span></div>';
                                                                        endif;
                                                                        ?>
                                                                    </div>
                                                                    <div class="col-md-8">
                                                                        <div class="ct-product-right">
                                                                            <?php
                                                                            $average = $_product->get_average_rating();
                                                                            if ( $average != 0 ){
                                                                                echo '<div class="product-title-has-rate">';
                                                                                ?>
                                                                                <a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
                                                                                <span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>"><i class="automaticicon-rate"></i><?php echo esc_html($average); ?></span>
                                                                                <?php
                                                                                echo '</div>';
                                                                            }else{
                                                                                ?>
                                                                                <a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php do_action( 'woocommerce_shop_loop_item_title' );?></a>
                                                                                <?php
                                                                            }
                                                                            ?>
                                                                            <div class="format-price-addcart">
                                                                                <div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <?php
                                        }
                                        wp_reset_postdata();
                                        ?>
                                    </div>
                                </div>
                                <div class="beans-pagination"></div>
                                <a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                                <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
                            </div>
                        </div>
                        <?php
                    }
                }
            }
        }
        ?>
    </div>
    <?php
    return ob_get_clean();
}
if(!function_exists('automatic_product_rate')){
	function automatic_product_rate($_product){
		$average = $_product->get_average_rating();
		$automatic_rate_ave = "";
		if (($average < 3 && $average > 0)) {
			$automatic_rate_ave = "rate_red";
		}
		elseif (($average < 4 && $average >= 3)) {
			$automatic_rate_ave = "rate_yellow";
		}
		elseif (($average <= 5 && $average >= 4)) {
			$automatic_rate_ave = "rate_blue";
		}
		return $automatic_rate_ave;
	}
}