<?php
/**
 * Icon Advanced
 */

add_shortcode( 'automatic_about', 'tp_about' );
function tp_about( $atts, $content=null ){
    extract( shortcode_atts(
        array(
            'layout'=>'ltr',
            'title' => '',
            'align'=>'left',
            'source'=>'media_library',
            'image'=>'',
            'custom_src'=>'',
            'css_animation' => '',
            'el_class' => '',
            'css' => '',
        ),$atts));
        $content = wpb_js_remove_wpautop( $content, true );
		$default_src = vc_asset_url( 'vc/no_image.png' );
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'automatic_about', $atts );
    $css_class_anm = automatic_getCSSAnimation( $css_animation );
    $el_class = automatic_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    if ( $css_class_anm != '' ){
        $el_class .= ' '.$css_class_anm;
    }
    $aligntxt = 'text-center';
    switch ( $align ) {
        case 'left':
            $aligntxt = 'text-left';
            break;
        case 'right':
            $aligntxt = 'text-right';
            break;
        case 'center':
            $aligntxt = 'text-center';
            break;
        default:
            # code...
            break;
    }
	// image
	$img_id = preg_replace( '/[^\d]/', '', $image );
	switch ( $source ) {
		case 'media_library':
			$img = wpb_getImageBySize( array(
				'attach_id' => $img_id,
				'thumb_size' => 'full',
				'class' => 'vc_single_image-img',
			) );
			break;
		case 'external_link':
			$custom_src = $custom_src ? esc_attr( $custom_src ) : $default_src;

			$img = array(
				'thumbnail' => '<img class="vc_single_image-img" src="' . $custom_src . '" />',
			);
			break;

		default:
			$img = false;
	}

	if ( ! $img ) {
		$img['thumbnail'] = '<img class="vc_single_image-img" src="' . $default_src . '" />';
	}

    ?>

    <div class="automatic_about <?php echo $el_class; ?> au_fadeIn">
        <div class="row">
    		<div class="container container_about"></div>
    		<div class="wpb_column vc_column_container vc_col-sm-12">
    			<div class="vc_column-inner">
    				<div class="wpb_wrapper">
    					<div class="vc_row wpb_row vc_inner vc_row-fluid vc_row-o-equal-height vc_row-o-content-middle vc_row-flex">
    						<?php if($layout == 'ltr'): ?>
    							<div class="wpb_column col-lg-hide">
    								<div class="vc_column-inner "><div class="wpb_wrapper">
    									<div class="automatic-headingtitle automatic-headingtitle-right">
    										<div class="default <?php echo $aligntxt; ?>">
    											<?php if ( $title != '' ) : ?><h2 class="title-about"><?php echo esc_attr( $title ); ?></h2><?php endif; ?>
    											<div class="txt-ct"><?php echo $content; ?></div>
    										</div>
    									</div>
    								</div></div>
    							</div>
    							<div class="wpb_column vc_column_container vc_col-md-6">
    								<div class="vc_column-inner "><div class="wpb_wrapper">
    									<div class="wpb_single_image vc_align_left">
    										<figure class="wpb_wrapper vc_figure">
    											<div class="vc_single_image-wrapper vc_box_border_grey"><?php echo $img['thumbnail'] ?></div>
    										</figure>
    									</div>
    								</div></div>
    							</div>
    							<div class="wpb_column vc_column_container vc_col-md-6 col-xs-hide padding-top-20-mb padding-top-20-res">
    								<div class="vc_column-inner "><div class="wpb_wrapper">
    									<div class="automatic-headingtitle automatic-headingtitle-right">
    										<div class="default <?php echo $aligntxt; ?>">
    											<?php if ( $title != '' ) : ?><h2 class="title-about"><?php echo esc_attr( $title ); ?></h2><?php endif; ?>
    											<div class="txt-ct"><?php echo $content; ?></div>
    										</div>
    									</div>
    								</div></div>
    							</div>
    						<?php else: ?>
    							<div class="wpb_column vc_column_container vc_col-md-6">
    								<div class="vc_column-inner "><div class="wpb_wrapper">
    									<div class="automatic-headingtitle automatic-headingtitle-left">
    										<div class="default <?php echo $aligntxt; ?>">
    											<?php if ( $title != '' ) : ?><h2 class="title-about"><?php echo esc_attr( $title ); ?></h2><?php endif; ?>
    											<div class="txt-ct"><?php echo $content; ?></div>
    										</div>
    									</div>
    								</div></div>
    							</div>
    							<div class="wpb_column vc_column_container vc_col-md-6 padding-top-20-mb padding-top-20-res">
    								<div class="vc_column-inner "><div class="wpb_wrapper">
    									<div class="wpb_single_image vc_align_left">
    										<figure class="wpb_wrapper vc_figure">
    											<div class="vc_single_image-wrapper vc_box_border_grey"><?php echo $img['thumbnail'] ?></div>
    										</figure>
    									</div>
    								</div></div>
    							</div>
    						<?php endif ?>
    					</div>
    				</div>
    			</div>
    		</div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}