<?php
/**
 * Shortcode Automatic Viewed Product
 */
add_action('vc_build_admin_page', 'automatic_shortcode_viewed_product');
add_action( 'vc_before_init', 'automatic_shortcode_viewed_product' );

function automatic_shortcode_viewed_product() {
    vc_map( array(
        'name' => esc_html__( '[Automatic] Viewed Product', 'automatic_sc' ),
        'base' => 'automatic_viewed_product',
        "icon" => "automatic_vc_icon",
        'category' =>'Automatic',
        'description' => esc_html__( 'Display your product viewed', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'No view', 'automatic_sc' ),
                'param_name' => 'no_view',
                'description' => esc_html__( 'Text show when You have not viewed any product yet!', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Align Title', 'automatic_sc' ),
                'param_name' => 'align',
                'value' => array(
                    esc_html__( 'Left', 'automatic_sc' ) => 'left',
                    esc_html__( 'Right', 'automatic_sc' ) => 'right',
                    esc_html__( 'Center', 'automatic_sc' ) => 'center'
                ),
                'description' => esc_html__( 'Type align title tab.', 'automatic_sc' ),
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Content", "automatic" ),
                "param_name" => "content",
                "value" => esc_html__( "", "automatic" ),
                "description" => esc_html__( "Enter your content.", "automatic" ),
            ),
            vc_map_add_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        ),
    ) );
}