<?php
add_action('vc_build_admin_page', 'automatic_shortcode_pagetitle');
add_action( 'vc_before_init', 'automatic_shortcode_pagetitle' );

function automatic_shortcode_pagetitle() {

    vc_map( array(
        'name' => esc_html__( '[Automatic] Heading title', 'automatic_sc' ),
        'base' => 'automatic_pagetitle',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'Heading title.', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'param_name' => 'title',
                'heading' => esc_html__( 'Label', 'automatic_sc' ),
                'description' => esc_html__( 'Enter text used as widget title.', 'automatic_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Text align', 'automatic_sc' ),
                'param_name' => 'align',
                'value' => array(
                    esc_html__( 'Left', 'automatic_sc' ) => 'left',
                    esc_html__( 'Center', 'automatic_sc' ) => 'center',
                    esc_html__( 'Right', 'automatic_sc' ) => 'right',
                ),
                'description' => esc_html__( 'Select align heading title.', 'automatic_sc' ),
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", "automatic" ),
                "param_name" => "content",
                "value" => esc_html__( "", "automatic" ),
                "description" => esc_html__( "Enter your content.", "automatic" )
            ),
            automatic_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}