<?php
add_action('vc_build_admin_page', 'automatic_shortcode_icon');
add_action( 'vc_before_init', 'automatic_shortcode_icon' );
function automatic_shortcode_icon() {
    vc_map( array(
        "name" => esc_html__( "[Automatic] Advanced Icon", "automatic" ),
        "base" => "automatic_icon",
        "class" => "",
        'icon' => 'automatic_vc_icon',
        "category" => "Automatic",
        "description" => esc_html__( 'Advanced design icon','automatic_sc' ),
        "params" => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'automatic_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Default', 'automatic_sc' ) => 'default',
                    esc_html__( 'List Icon', 'automatic_sc' ) => 'list',
                ),
                'description' => esc_html__( 'Select type for box.', 'automatic_sc' ),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'automatic_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter icon, title and color.', 'automatic_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'title' => esc_html__( 'Development', 'automatic_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Design', 'automatic_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Marketing', 'automatic_sc' ),
                    ),
                ) ) ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('list')
                ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'automatic_sc' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title slide carousel', 'automatic_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => esc_html__( "Content", "automatic" ),
                        "param_name" => "content",
                        "value" => esc_html__( " ", "automatic" ),
                        "description" => esc_html__( "Enter your content.", "automatic" )
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__( 'Type Icon', 'automatic_sc' ),
                        'value' => array(
                            esc_html__( 'Font Icon', 'automatic_sc' ) => 'font-icon',
                            esc_html__( 'Image', 'automatic_sc' ) => 'image',
                        ),
                        'param_name' => 'type_icon',
                        'description' => esc_html__( 'Select type icon.', 'automatic_sc' ),
                    ),
                    array(
                        "type" => "icon_manager",
                        "class" => "",
                        "heading" => esc_html__("Select Icon ","ultimate_vc"),
                        "param_name" => "icon_font",
                        "value" => "",
                        "description" => esc_html__("Click and select icon of your choice. If you can't find the one that suits for your purpose","ultimate_vc").", ".__("you can","ultimate_vc")." <a href='admin.php?page=bsf-font-icon-manager' target='_blank'>".__("add new here","ultimate_vc")."</a>.",
                        'dependency' => array(
                            'element' => 'type_icon',
                            'value' => 'font-icon',
                        ),
                    ),
                    array(
                        'type' => 'attach_image',
                        'param_name' =>'image',
                        'heading' => esc_html__( 'Image','automatic_sc' ),
                        'value' => '',
                        'description' => esc_html__( 'select image background','automatic_sc' ),
                        'dependency' => array(
                            'element' => 'type_icon',
                            'value' => array('image')
                        ),
                    ),
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Title slide carousel', 'automatic_sc' ),
                'admin_label' => true,
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('default')
                ),
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", "automatic" ),
                "param_name" => "content",
                "value" => esc_html__( "", "automatic" ),
                "description" => esc_html__( "Enter your content.", "automatic" ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('default')
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type Icon', 'automatic_sc' ),
                'value' => array(
                    esc_html__( 'Font Icon', 'automatic_sc' ) => 'font-icon',
                    esc_html__( 'Image', 'automatic_sc' ) => 'image',
                ),
                'param_name' => 'type_icon',
                'description' => esc_html__( 'Select type icon.', 'automatic_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('default')
                ),
            ),
            array(
                "type" => "icon_manager",
                "class" => "",
                "heading" => esc_html__("Select Icon ","ultimate_vc"),
                "param_name" => "icon_font",
                "value" => "",
                "description" => esc_html__("Click and select icon of your choice. If you can't find the one that suits for your purpose","ultimate_vc").", ".__("you can","ultimate_vc")." <a href='admin.php?page=bsf-font-icon-manager' target='_blank'>".__("add new here","ultimate_vc")."</a>.",
                'dependency' => array(
                    'element' => 'type_icon',
                    'value' => 'font-icon',
                ),
            ),
            array(
                'type' => 'attach_image',
                'param_name' =>'image',
                'heading' => esc_html__( 'Image','automatic_sc' ),
                'value' => '',
                'description' => esc_html__( 'select image background','automatic_sc' ),
                'dependency' => array(
                    'element' => 'type_icon',
                    'value' => array('image')
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Size', 'automatic_sc' ),
                'param_name' => 'size',
                'value' => array_merge( getVcShared( 'sizes' ), array( 'Extra Large' => 'xl' ) ),
                'std' => 'md',
                'description' => esc_html__( 'Icon size.', 'automatic_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Align', 'automatic_sc' ),
                'param_name' => 'align',
                'value' => array(
                    esc_html__( 'Left', 'automatic_sc' ) => 'text-left',
                    esc_html__( 'Right', 'automatic_sc' ) => 'text-right',
                    esc_html__( 'Center', 'automatic_sc' ) => 'text-center',
                ),
                'description' => esc_html__( 'Select icon alignment.', 'automatic_sc' ),
            ),
            vc_map_add_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ));
}