<?php
/*
Plugin Name: Automatic Shortcodes
Plugin URI:
Description: Shortcodes for automatic Theme.
Version: 1.4
Author: AHT
Author URI:
Text Domain: automatic_sc
*/

// don't load directly
if (!defined('ABSPATH'))
    die('-1');

define('AUTOMATIC_SHORTCODES_URL', plugin_dir_url(__FILE__));
define('AUTOMATIC_SHORTCODES_PATH', dirname(__FILE__) . '/shortcodes/');
define('AUTOMATIC_SHORTCODES_LIB', dirname(__FILE__) . '/lib/');
define('AUTOMATIC_SHORTCODES_TEMPLATES', dirname(__FILE__) . '/templates/');


add_action( 'vc_after_init', 'add_button_super_color' );
function add_button_super_color() {
  $param = WPBMap::getParam( 'vc_btn', 'color' );
  $param['value'][esc_html__( 'Default color', 'automatic_sc' )] = 'default';
  vc_update_shortcode_param( 'vc_btn', $param );
}


class AutomaticShortcodesClass {

    private $shortcodes = array('automatic_advanced_icon','automatic_advanced_box','automatic_banner_product','automatic_product','automatic_viewed_product','automatic_testimonial','automatic_client','automatic_added_product','automatic_product_dailydeal','automatic_list_category','automatic_product_special','automatic_slide_banner','automatic_recent_blog','automatic_team','automatic_about','automatic_headingtitle','automatic_map','automatic_contactinfo','automatic_compare');
    function __construct() {

        // Load text domain
        add_action( 'plugins_loaded', array( $this, 'loadTextDomain' ) );

        // Init plugins
        add_action( 'init', array( $this, 'initPlugin' ) );

        $this->addShortcodes();

        add_filter( 'the_content', array( $this, 'formatShortcodes' ) );
        add_filter( 'widget_text', array( $this, 'formatShortcodes' ) );
				add_filter( 'load_textdomain_mofile', array( $this, 'overload_textdomain_mofile' ), 10, 2 );
    }

    // Init plugins
    function initPlugin() {
        $this->addTinyMCEButtons();
    }
		function overload_textdomain_mofile( $mofile, $domain ) { 
			if ( 'automatic_sc' === $domain ) {
				$mofile = WP_LANG_DIR . '/plugins/automatic_sc-' . get_locale() . '.mo';
			}
			return $mofile;
		}
    // load plugin text domain
    function loadTextDomain() {
        load_plugin_textdomain( 'automatic_sc', false, dirname( __FILE__ ) . '/languages/' );
    }

    // Add buttons to tinyMCE
    function addTinyMCEButtons() {
        if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
            return;

        if ( get_user_option('rich_editing') == 'true' ) {
            add_filter( 'mce_buttons', array(&$this, 'registerTinyMCEButtons') );
        }
    }

    function registerTinyMCEButtons($buttons) {
        array_push($buttons, "automatic_shortcodes_button");
        return $buttons;
    }

    // Add shortcodes
    function addShortcodes() {
        require_once(AUTOMATIC_SHORTCODES_LIB . 'functions.php');
        require_once(AUTOMATIC_SHORTCODES_PATH . 'automatic_params.php');
        require_once(AUTOMATIC_SHORTCODES_PATH . 'automatic_static_block.php');
        foreach ($this->shortcodes as $shortcode) {
            require_once(AUTOMATIC_SHORTCODES_PATH . $shortcode . '.php');
            require_once(AUTOMATIC_SHORTCODES_TEMPLATES . $shortcode . '.php');
        }
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
    }

    // Format shortcodes content
    function formatShortcodes($content) {
        $block = join("|", $this->shortcodes);
        // opening tag
        $content = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]", $content);
        // closing tag
        $content = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)/","[/$2]", $content);

        return $content;
    }

}

// Finally initialize code
new AutomaticShortcodesClass();
