<?php 
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

global $post, $product;
?>
<div class="images1 images">
    <?php
        global $product;
        $attachment_ids = $product->get_gallery_image_ids();
        if(count($attachment_ids) > 0){
        ?>
            <div class="wrapper r_corners container_zoom_image relative">
                <?php
                    $j = 0;
                    if ( count($attachment_ids) > 0 ){
                        foreach( $attachment_ids as $attachment_id ){
                            $j++;
                            if ( $j == 1 ){
                            $image_link = wp_get_attachment_image_src( $attachment_id ,'full');
                            $image_link_full = wp_get_attachment_image_src( $attachment_id , 'full');
                            ?>
                            <img id="img_zoom" src="<?php echo esc_url($image_link[0]); ?>" data-zoom-image="<?php echo esc_url($image_link_full[0]); ?>" alt="">
                        <?php
                            }
                        }
                    }
                    if ( count($attachment_ids) == 0 ) {
                        $image_link = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full');
                        $image_link_full = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full');
                        ?>
                        <img id="img_zoom" src="<?php echo esc_url($image_link[0]); ?>" data-zoom-image="<?php echo esc_url($image_link_full[0]); ?>" alt="">
                    <?php
                    }
                    ?>
            </div>
            <div class="thumbnails_carousel">
                <ul id="thumbnails">
                    <?php
                        $i = 0;
                        foreach( $attachment_ids as $attachment_id )
                        {
                            $i++;
                            if ( $i==1 ) echo '<li><div>';
                            if ( ($i-1)%3==0 && $i>3) echo '<li><div>';
                            $image_link = wp_get_attachment_image_src( $attachment_id , 'automatic-image-product-gallery');
                            $image_link_medium = wp_get_attachment_image_src( $attachment_id , 'full');
                            $image_link_full = wp_get_attachment_image_src( $attachment_id , 'full');
                            ?>
                            <a href="#" data-zoom-image="<?php echo esc_url($image_link_full[0]); ?>" data-image="<?php echo esc_url($image_link_medium[0]); ?>" class="<?php if ( $i == 0 ) echo 'active'; ?> d_block wrapper r_corners tr_all translucent"><img src="<?php echo esc_url($image_link[0]); ?>" alt="" class="r_corners"></a>
                            <?php
                            if ( $i==3) echo '</div></li>';
                            if ( $i%3==0 && $i>3) echo '</div></li>';
                        }
                    ?>
                </ul>
                <!---->
                <input type="hidden" value="<?php echo count($attachment_ids) ?>" id="count_item" >
            </div>
        <?php } else {
            ?>
            <div class="wrapper r_corners container_zoom_image relative">
                <?php
                    $image_link = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full');
                ?>
                    <img id="img_zoom" src="<?php echo esc_url($image_link[0]); ?>" data-zoom-image="<?php echo esc_url($image_link[0]); ?>" alt="">
            </div>
            <?php
        }
        ?>
</div>
