<?php 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $woocommerce,$product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div <?php post_class(); ?>>
	<?php
	/**
	 * woocommerce_before_shop_loop_item hook.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10

	/**
	 * woocommerce_before_shop_loop_item_title hook.
	 *
	 * @hooked woocommerce_show_product_loop_sale_flash - 10
	 * @hooked woocommerce_template_loop_product_thumbnail - 10
	 */
	//do_action( 'woocommerce_before_shop_loop_item_title' );
	$attachment_ids = $product->get_gallery_image_ids();
	if ( $attachment_ids ) {
		?>
		<div class="product-thumbnails">
			<div class="flexslider">
				<ul class="slides">
					<?php
		    		$i=0;
					foreach ( $attachment_ids as $attachment_id ) {
						$i++;
						$images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product' );
						?>
						<li>
						<img src="<?php echo esc_url($images[0]); ?>" alt="image-product">
						</li>
					<?php
					}
					?>
				</ul>
			</div>
		</div>
		<?php
	}else{
		?>
		<div class="product-thumbnails">
			<?php
				echo '<a href="'. get_the_permalink() .'">';
				the_post_thumbnail( 'automatic-image-product-list' );
				echo '</a>';
			?>
		</div>
		<?php
	}
	automatic_product_alert($product);
	automatic_product_title($product); 
	automatic_product_term($product);
    ?>
	<div class="format-price-addcart">
		<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
		<div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
	</div>
	<div class="share-yith">
	<?php
		automatic_product_share_yith($product);
	?>
	</div>
</div>
