<?php
/**
 * The template used for displaying page content
 *
 * @package WordPress
 * @subpackage Automatic
 * @since Automatic 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<?php
		the_content();
		wp_link_pages( array(
			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'automatic' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'automatic' ) . ' </span>%',
			'separator'   => '<span class="screen-reader-text">, </span>',
		) );
		?>
	</div><!-- .entry-content -->
	<?php if(automatic_post_comment()){?>
		<?php if (get_comments_number() > 0){ ?>
			<div class="count-cmt">
				<span class="fw_light color_333">
					<?php
						echo get_comments_number() .' ';
						if ( get_comments_number() > 1 ){
							echo esc_html__('Comments','automatic');
						}else{
							echo esc_html__('Comment','automatic');
						}
					?>
				</span>
			</div>

		<?php }
		// If comments are open or we have at least one comment, load up the comment template.
			comments_template();
		// End of the loop.
	}?>
	<?php edit_post_link( esc_html__( 'Edit', 'automatic' ), '<footer class="entry-footer"><span class="edit-link">', '</span></footer><!-- .entry-footer -->' ); ?>

</article><!-- #post-## -->
<?php 
if(automatic_post_comment()){?> 
	<?php if (get_comments_number() > 0){ ?>
		<div class="count-cmt">
			<span>
				<?php
					echo get_comments_number() .' ';
					if ( get_comments_number() > 1 ){
						echo esc_html__('Comment(s)','automatic');
					}else{
						echo esc_html__('Comment','automatic');
					}
				?>
			</span>
		</div>

	<?php }
	// If comments are open or we have at least one comment, load up the comment template.
		comments_template();
	// End of the loop.
}
